/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.STEM.STEMGeoRelationshipPage;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class GeoRelationshipSubDlg
extends BaseDialog
implements ActionListener {
    private static final int sComboWidth = 120;
    private STEMGeoRelationshipPage.MapSpecItem mMapSpecItem;
    private String mMapFileName;
    private String mLayer;
    protected ContinueAction mContinueAction;
    private FocusableTextArea mGeoRelaInfo;
    private JLabel mMapFileLabel;
    private FocusableTextArea mMapFilePath;
    private JLabel mRelationLabel;
    private JComboBox mRelationCombo;
    private JLabel mDistSpinLabel;
    private NumberSpinner mDistSpinner;
    private JLabel mIncrementLabel;
    private JComboBox mIncrementCombo;
    private JLabel mMaxAssocSpinLabel;
    private NumberSpinner mMaxAssocSpinner;
    private boolean mContinuePressed;

    public GeoRelationshipSubDlg(BaseWizardDialog baseWizardDialog, STEMGeoRelationshipPage.MapSpecItem mapSpecItem) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_GEOSPATIAL_RELATION_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mMapSpecItem = mapSpecItem;
        this.mContinuePressed = false;
        this.mMapFileName = mapSpecItem.getMapFullName();
        this.mLayer = mapSpecItem.getMapLayer();
        this.mMapFilePath.setText(this.mMapFileName);
        this.initializePanel(mapSpecItem.getRelationship());
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mRelationCombo) {
            this.enableControls();
        }
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_relationship");
    }

    protected void init() {
        super.init();
        this.initVars();
    }

    private void initializePanel(String string) {
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel, string);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.setDefault();
        this.pack();
    }

    public boolean continuePressed() {
        return this.mContinuePressed;
    }

    public void setMapAndLayer(String string, String string2) {
        this.mMapFileName = string;
        this.mLayer = string2;
        this.mMapFilePath.setText(this.mMapFileName);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mGeoRelaInfo = new FocusableTextArea(this.getResString("IDS_STEM_GEOSPATIAL_RELATION_SUB_INFO"), null);
        this.mMapFilePath = new FocusableTextArea("", null);
        this.mMapFileLabel = DialogUtil.createLabel(this, "IDS_STEM_GEOSPATIAL_RELATION_SUB_MAP_LABEL");
        this.mMapFileLabel.setLabelFor(this.mMapFilePath);
        String[] stringArray = this.getResStringArray("IDS_STEM_STEP_THREE_MAP_RELATIONSHIP_ARRARY");
        this.mRelationLabel = DialogUtil.createLabel(this, "IDS_STEM_GEOSPATIAL_RELATION_SUB_RELA_COMBO_LABEL");
        this.mRelationCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(stringArray));
        this.mRelationCombo.setAction(new ComboboxAction(this, "IDS_STEM_GEOSPATIAL_RELATION_SUB_RELA_COMBO_LABEL"));
        this.mRelationCombo.addActionListener(this);
        int n = this.mRelationCombo.getPreferredSize().height;
        this.mRelationCombo.setPreferredSize(new Dimension(120, n));
        this.mRelationLabel.setLabelFor(this.mRelationCombo);
        this.mDistSpinLabel = DialogUtil.createLabel(this, "IDS_STEM_GEOSPATIAL_RELATION_SUB_DISTANCE_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1.0, 1.0, 99999.0, 1.0);
        FloatTextField floatTextField = new FloatTextField(1.0, 99999.0, 2);
        floatTextField.setHorizontalAlignment(4);
        this.mDistSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        this.mDistSpinner.setAlignmentX(1.0f);
        this.mDistSpinLabel.setLabelFor(this.mDistSpinner.getEditor());
        String[] stringArray2 = this.getResStringArray("IDS_STEM_GEOSPATIAL_RELATION_SUB_INCREMENT_VALUES");
        this.mIncrementLabel = DialogUtil.createLabel(this, "IDS_STEM_GEOSPATIAL_RELATION_SUB_INCRE_COMBO_LABEL");
        this.mIncrementCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(stringArray2));
        this.mIncrementCombo.setAction(new ComboboxAction(this, "IDS_STEM_GEOSPATIAL_RELATION_SUB_INCRE_COMBO_LABEL"));
        this.mIncrementCombo.setPreferredSize(new Dimension(120, n));
        this.mIncrementLabel.setLabelFor(this.mIncrementCombo);
        this.mMaxAssocSpinLabel = DialogUtil.createLabel(this, "IDS_STEM_GEOSPATIAL_RELATION_SUB_MAX_ASSOCIATION");
        spinnerNumberModel = new SpinnerNumberModel(1, 1, 10, 1);
        IntTextField intTextField = new IntTextField(1, 10, true);
        floatTextField.setHorizontalAlignment(4);
        this.mMaxAssocSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mMaxAssocSpinner.setAlignmentX(1.0f);
        this.mMaxAssocSpinLabel.setLabelFor(this.mMaxAssocSpinner.getEditor());
    }

    private void setDefault() {
        int n = this.mMapSpecItem.getMaxAssoction();
        this.mMaxAssocSpinner.getModel().setValue(n);
        this.mIncrementCombo.setSelectedItem(this.mMapSpecItem.getIncrement());
        this.mDistSpinner.getModel().setValue(this.mMapSpecItem.getDistance());
        this.enableControls();
    }

    private void addComponents(JPanel jPanel, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        this.mGeoRelaInfo.setRows(4);
        DialogUtil.addUsingGBL(jPanel, this.mGeoRelaInfo, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mGeoRelaInfo.setMinimumSize(new Dimension(300, 100));
        this.mGeoRelaInfo.setPreferredSize(new Dimension(300, 100));
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mMapFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mMapFilePath, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, 0, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, n2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mRelationLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mRelationCombo.setSelectedItem(string);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 2, n2, n2 * 8);
        DialogUtil.addUsingGBL(jPanel, this.mRelationCombo, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, n2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mDistSpinLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 2, n2, n2 * 6);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDistSpinner, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, n2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mIncrementLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 2, n2, n2 * 8);
        DialogUtil.addUsingGBL(jPanel, this.mIncrementCombo, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, n2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxAssocSpinLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 2, n2, n2 * 6);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxAssocSpinner, gridBagConstraints, 1, 6, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGeoRelaInfo);
        vector.add(this.mMapFilePath);
        vector.add(this.mRelationCombo);
        vector.add(this.mDistSpinner.getEditor());
        vector.add(this.mIncrementCombo);
        vector.add(this.mMaxAssocSpinner.getEditor());
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void enableControls() {
        int n = this.mRelationCombo.getSelectedIndex();
        if (n == 1 || n == 5 || n == 6 || n == 7 || n == 8) {
            this.mDistSpinLabel.setEnabled(true);
            this.mDistSpinner.getEditor().setEnabled(true);
            this.mIncrementLabel.setEnabled(true);
            this.mIncrementCombo.setEnabled(true);
        } else {
            this.mDistSpinLabel.setEnabled(false);
            this.mDistSpinner.getEditor().setEnabled(false);
            this.mIncrementLabel.setEnabled(false);
            this.mIncrementCombo.setEnabled(false);
        }
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GeoRelationshipSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GeoRelationshipSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = GeoRelationshipSubDlg.this.mRelationCombo.getSelectedItem().toString();
            GeoRelationshipSubDlg.this.mMapSpecItem.setRelationship(string);
            String string2 = ((JTextField)GeoRelationshipSubDlg.this.mMaxAssocSpinner.getEditor()).getText();
            GeoRelationshipSubDlg.this.mMapSpecItem.setMaxAssoction(Integer.parseInt(string2));
            if (GeoRelationshipSubDlg.this.mDistSpinner.getEditor().isEnabled()) {
                GeoRelationshipSubDlg.this.mMapSpecItem.setIncrement(GeoRelationshipSubDlg.this.mIncrementCombo.getSelectedItem().toString());
                String string3 = ((JTextField)GeoRelationshipSubDlg.this.mDistSpinner.getEditor()).getText();
                GeoRelationshipSubDlg.this.mMapSpecItem.setDistance(Double.parseDouble(string3));
            } else {
                GeoRelationshipSubDlg.this.mMapSpecItem.setIncrement("");
                GeoRelationshipSubDlg.this.mMapSpecItem.setDistance(-1.0);
            }
            GeoRelationshipSubDlg.this.mContinuePressed = true;
            GeoRelationshipSubDlg.this.dispose();
        }
    }
}

