/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import java.util.Vector;

public class GeoContextSource {
    private Vector<NonSpatialDataSource> mNonSpatialSources;
    private String mGeoSourceID;
    private SpatialSourceType mType;
    private String mProjectionName;
    private String mFinalSourceName;
    private String mMapLayer;
    private int mMaxRelations;
    private double mCloseRadius;
    private SpatialPredType mPredicateType;
    private DistMeasureType mDistanceMeasure;
    private String mCoordType;
    private String mCSName;
    private String mRoleString;
    private int mWKID;

    public GeoContextSource(String string) {
        this.mGeoSourceID = string;
        this.mType = SpatialSourceType.UNKNOWN;
        this.mProjectionName = "";
        this.mFinalSourceName = "";
        this.mMapLayer = "";
        this.mMaxRelations = 1;
        this.mCloseRadius = 1.0;
        this.mPredicateType = SpatialPredType.NONE;
        this.mDistanceMeasure = DistMeasureType.MILE;
        this.mNonSpatialSources = new Vector();
        this.mCoordType = "";
        this.mCSName = "";
        this.mWKID = -1;
    }

    public String getGeoSourceID() {
        return this.mGeoSourceID;
    }

    public SpatialSourceType getType() {
        return this.mType;
    }

    public void setType(SpatialSourceType spatialSourceType) {
        this.mType = spatialSourceType;
    }

    public void setType(String string) {
        if (string.equals("UNKNOWN")) {
            this.mType = SpatialSourceType.UNKNOWN;
        } else if (string.equals("FILE")) {
            this.mType = SpatialSourceType.FILE;
        } else if (string.equals("SERVICE")) {
            this.mType = SpatialSourceType.SERVICE;
        } else if (string.equals("PACKAGE")) {
            this.mType = SpatialSourceType.PACKAGE;
        } else if (string.equals("GDB")) {
            this.mType = SpatialSourceType.GDB;
        }
    }

    public String getProjectionName() {
        return this.mProjectionName;
    }

    public void setProjectionName(String string) {
        this.mProjectionName = string;
    }

    public String getFinalSourceName() {
        return this.mFinalSourceName;
    }

    public void setFinalSourceName(String string) {
        this.mFinalSourceName = string;
    }

    public String getMapLayerName() {
        return this.mMapLayer;
    }

    public void setMapLayerName(String string) {
        this.mMapLayer = string;
    }

    public int getMaxRelations() {
        return this.mMaxRelations;
    }

    public void setMaxRelations(int n) {
        this.mMaxRelations = n;
    }

    public double getCloseRadius() {
        return this.mCloseRadius;
    }

    public void setCloseRadius(double d) {
        this.mCloseRadius = d;
    }

    public SpatialPredType getPredicateType() {
        return this.mPredicateType;
    }

    public void setPredicateType(SpatialPredType spatialPredType) {
        this.mPredicateType = spatialPredType;
    }

    public void setPredicateType(String string) {
        if (string.equals("NONE")) {
            this.mPredicateType = SpatialPredType.NONE;
        } else if (string.equals("WITHIN")) {
            this.mPredicateType = SpatialPredType.WITHIN;
        } else if (string.equals("CLOSE")) {
            this.mPredicateType = SpatialPredType.CLOSE;
        } else if (string.equals("CONTAINS")) {
            this.mPredicateType = SpatialPredType.CONTAINS;
        } else if (string.equals("INTERSECTS")) {
            this.mPredicateType = SpatialPredType.INTERSECTS;
        } else if (string.equals("CROSS")) {
            this.mPredicateType = SpatialPredType.CROSS;
        } else if (string.equals("OVERLAP")) {
            this.mPredicateType = SpatialPredType.OVERLAP;
        } else if (string.equals("TOUCH")) {
            this.mPredicateType = SpatialPredType.TOUCH;
        } else if (string.equals("EAST")) {
            this.mPredicateType = SpatialPredType.EAST;
        } else if (string.equals("WEST")) {
            this.mPredicateType = SpatialPredType.WEST;
        } else if (string.equals("SOUTH")) {
            this.mPredicateType = SpatialPredType.SOUTH;
        } else if (string.equals("NORTH")) {
            this.mPredicateType = SpatialPredType.NORTH;
        }
    }

    public DistMeasureType getDistanceMeasure() {
        return this.mDistanceMeasure;
    }

    public void setDistanceMeasure(String string) {
        if (string.equals("ml")) {
            this.mDistanceMeasure = DistMeasureType.MILE;
        } else if (string.equals("ft")) {
            this.mDistanceMeasure = DistMeasureType.FOOT;
        } else if (string.equals("km")) {
            this.mDistanceMeasure = DistMeasureType.KM;
        } else if (string.equals("m")) {
            this.mDistanceMeasure = DistMeasureType.METER;
        }
    }

    public void setDistanceMeasure(DistMeasureType distMeasureType) {
        this.mDistanceMeasure = distMeasureType;
    }

    public String getCoordType() {
        return this.mCoordType;
    }

    public void setCoordType(String string) {
        this.mCoordType = string;
    }

    public String getCSName() {
        return this.mCSName;
    }

    public void setCSName(String string) {
        this.mCSName = string;
    }

    public int getWKID() {
        return this.mWKID;
    }

    public void setWKID(int n) {
        this.mWKID = n;
    }

    public Vector<NonSpatialDataSource> getNonSpatialSources() {
        return this.mNonSpatialSources;
    }

    public void setNonSpatialSources(Vector<NonSpatialDataSource> vector) {
        this.mNonSpatialSources = vector;
    }

    static class MatchDataToMap {
        private Vector<Object> mDataFieldValue = new Vector();
        private Vector<Object> mMapFieldValue = new Vector();

        public Vector<Object> getDataFieldValue() {
            return this.mDataFieldValue;
        }

        public void setDataFieldValues(Vector<Object> vector) {
            this.mDataFieldValue = vector;
        }

        public void addOneDataFieldValue(Object object) {
            this.mDataFieldValue.add(object);
        }

        public Vector<Object> getMapFieldValues() {
            return this.mMapFieldValue;
        }

        public void setMapFieldValues(Vector<Object> vector) {
            this.mMapFieldValue = vector;
        }

        public void addOneMapFieldValue(Object object) {
            this.mMapFieldValue.add(object);
        }
    }

    static class NonSpatialDataSource {
        private Vector<String> mMapKeys;
        private Vector<String> mDataKeys;
        private Vector<MatchDataToMap> mDataToMap;
        private String mMapId;
        private String mSourceName;
        private String mSourceId;
        private String mSourceType;
        private String mXCoordinateField;
        private String mYCoordinateField;
        private String mZCoordinateField;
        private String mCoordType;
        private String mCSName;
        private int mWKID;
        private boolean mRoleContext;

        public NonSpatialDataSource(String string, String string2, boolean bl) {
            this.mSourceName = string;
            this.mMapId = "";
            this.mSourceId = string2;
            this.mRoleContext = bl;
            this.mMapKeys = new Vector();
            this.mDataKeys = new Vector();
            this.mDataToMap = new Vector();
            this.mXCoordinateField = "";
            this.mYCoordinateField = "";
            this.mZCoordinateField = "";
            this.mCoordType = "";
            this.mCSName = "";
            this.mWKID = -1;
        }

        public String getAssociatedMapId() {
            return this.mMapId;
        }

        public void setAssociatedMapId(String string) {
            this.mMapId = string;
        }

        public String getSourceName() {
            return this.mSourceName;
        }

        public void setSourceName(String string) {
            this.mSourceName = string;
        }

        public String getSourceId() {
            return this.mSourceId;
        }

        public void setSourceId(String string) {
            this.mSourceId = string;
        }

        public boolean isRoleContext() {
            return this.mRoleContext;
        }

        public Vector<String> getMapKeys() {
            return this.mMapKeys;
        }

        public void setMapKeys(Vector<String> vector) {
            this.mMapKeys = vector;
        }

        public Vector<String> getDataKeys() {
            return this.mDataKeys;
        }

        public void setDataKeys(Vector<String> vector) {
            this.mDataKeys = vector;
        }

        public Vector<MatchDataToMap> getDataToMap() {
            return this.mDataToMap;
        }

        public void setDataToMap(Vector<MatchDataToMap> vector) {
            this.mDataToMap = vector;
        }

        public String getSourceType() {
            return this.mSourceType;
        }

        public void setSourceType(String string) {
            this.mSourceType = string;
        }

        public String getXCoordinateField() {
            return this.mXCoordinateField;
        }

        public void setXCoordinateField(String string) {
            this.mXCoordinateField = string;
        }

        public String getYCoordinateField() {
            return this.mYCoordinateField;
        }

        public void setYCoordinateField(String string) {
            this.mYCoordinateField = string;
        }

        public String getZCoordinateField() {
            return this.mZCoordinateField;
        }

        public void setZCoordinateField(String string) {
            this.mZCoordinateField = string;
        }

        public String getCoordType() {
            return this.mCoordType;
        }

        public void setCoordType(String string) {
            this.mCoordType = string;
        }

        public String getCSName() {
            return this.mCSName;
        }

        public void setCSName(String string) {
            this.mCSName = string;
        }

        public int getWKID() {
            return this.mWKID;
        }

        public void setWKID(int n) {
            this.mWKID = n;
        }
    }

    public static enum SpatialPredType {
        NONE,
        WITHIN,
        CLOSE,
        CONTAINS,
        INTERSECTS,
        CROSS,
        OVERLAP,
        TOUCH,
        EAST,
        WEST,
        SOUTH,
        NORTH;


        public String toString() {
            switch (this) {
                case NONE: {
                    return "NONE";
                }
                case WITHIN: {
                    return "Within";
                }
                case CLOSE: {
                    return "Close";
                }
                case CONTAINS: {
                    return "Contains";
                }
                case INTERSECTS: {
                    return "Intersects";
                }
                case CROSS: {
                    return "Cross";
                }
                case OVERLAP: {
                    return "Overlap";
                }
                case TOUCH: {
                    return "Touch";
                }
                case EAST: {
                    return "East";
                }
                case WEST: {
                    return "West";
                }
                case SOUTH: {
                    return "South";
                }
                case NORTH: {
                    return "North";
                }
            }
            return "NONE";
        }
    }

    public static enum DistMeasureType {
        MILE,
        FOOT,
        KM,
        METER;


        public String toString() {
            switch (this) {
                case MILE: {
                    return "ml";
                }
                case FOOT: {
                    return "ft";
                }
                case KM: {
                    return "km";
                }
                case METER: {
                    return "m";
                }
            }
            return "";
        }
    }

    public static enum SpatialSourceType {
        UNKNOWN,
        FILE,
        SERVICE,
        PACKAGE,
        GDB;


        public String toString() {
            switch (this) {
                case UNKNOWN: {
                    return "UNKNOWN";
                }
                case FILE: {
                    return "FILE";
                }
                case SERVICE: {
                    return "SERVICE";
                }
                case PACKAGE: {
                    return "PACKAGE";
                }
                case GDB: {
                    return "GDB";
                }
            }
            return "UNKNOWN";
        }
    }
}

