/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.STEM.MergeEventDataPage;
import com.spss.java_client.ui.dialogs.STEM.STEMSelectRolePage;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.Bidi;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GSARDefineRolePage
extends STEMSelectRolePage
implements ListDataListener,
IVarMoveHandler,
ListSelectionListener {
    protected static Border sNoFocusBorder = null;
    protected static Border sFocusBorder = null;
    private JLabel mBothVarListLabel;
    private TargetVariableList mBothVarList;
    private JScrollPane mBothVarListScrollPane;
    private ArrowButton mBothArrowButton;
    private JLabel mConditionVarListLabel;
    private TargetVariableList mConditionVarList;
    private ArrowButton mConditionArrowButton;
    private JScrollPane mConsqVarListScrollPane;
    private JLabel mPredVarListLabel;
    private TargetVariableList mPredVarList;
    private JScrollPane mPredeScrollPane;
    private ArrowButton mPredArrowButton;
    private Vector<GSARDataListContainer> mSources;
    private int mEventDataIndex;
    private boolean mKeepTargets = false;
    private String mEventDataId = "";

    public GSARDefineRolePage(BaseWizardDialog baseWizardDialog) {
        super(baseWizardDialog, "GSARDefineRolePage");
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mDataAndFields = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getAllContextDataFields();
        if (((STEMWizardDlg)this.mWizardDialog).getContextPage().countEventData() > 1) {
            this.mDataAndFields.put(this.mDefaultSources[1], ((STEMWizardDlg)this.mWizardDialog).getMergePage().getSelectedEventFields());
            this.mEventDataId = ((STEMWizardDlg)this.mWizardDialog).getMergePage().getEventDataIDs();
        } else {
            Hashtable<String, Vector<ISpssVariable>> hashtable = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getAllEventFields();
            this.mEventDataId = hashtable.keys().nextElement();
            this.mDataAndFields.put(this.mDefaultSources[1], hashtable.elements().nextElement());
        }
        if (!this.mKeepTargets || this.mSources == null || this.mSources.size() == 0) {
            this.mBothVarList.removeAll();
            this.mPredVarList.removeAll();
            this.mConditionVarList.removeAll();
            this.setupSourceContainer();
            int n = 1;
            this.mDataSourceList.setSelectedIndex(n);
            this.mEventDataIndex = n;
            this.mSelectedSrcIndex = n;
            this.mWizardDialog.enableNext(this.validate());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.mDataSourceList) {
            int n = this.mDataSourceList.getSelectedIndex();
            this.loadFieldList(n);
            this.mSelectedSrcIndex = n;
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_stem_gsar_fields";
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        int n = this.mDataSourceList.getSelectedIndex();
        boolean bl = true;
        if (n > 0) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(n - 1);
            if (variableList instanceof SrcVariableList) {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (gSARDataListContainer.findVariable(iSpssVariable)) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mBothVarList.getModel() || object == this.mConditionVarList.getModel() || object == this.mPredVarList.getModel()) {
            int n = this.mDataSourceList.getSelectedIndex();
            int n2 = listDataEvent.getIndex0();
            if (n2 < 0 || n < 0) {
                return;
            }
            ISpssVariable iSpssVariable = null;
            iSpssVariable = object == this.mBothVarList.getModel() ? this.mBothVarList.getModel().getElementAt(n2) : (object == this.mPredVarList.getModel() ? this.mPredVarList.getModel().getElementAt(n2) : this.mConditionVarList.getModel().getElementAt(n2));
            GSARDataListContainer gSARDataListContainer = null;
            if (n > 0) {
                gSARDataListContainer = this.mSources.get(n - 1);
            } else if (n == 0 && (n = this.findSourceIndex(iSpssVariable)) >= 0) {
                gSARDataListContainer = this.mSources.get(n);
            }
            if (gSARDataListContainer != null && iSpssVariable != null) {
                boolean bl = false;
                bl = object == this.mBothVarList.getModel() ? gSARDataListContainer.addTargetBothField(iSpssVariable) : (object == this.mPredVarList.getModel() ? gSARDataListContainer.addTargetPredField(iSpssVariable) : gSARDataListContainer.addTargetCondField(iSpssVariable));
                if (bl) {
                    gSARDataListContainer.removeSourceField(iSpssVariable);
                }
            }
        }
        this.mWizardDialog.enableNext(this.validate());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mBothVarList.getModel() || object == this.mConditionVarList.getModel() || object == this.mPredVarList.getModel()) {
            int n = this.mDataSourceList.getSelectedIndex();
            int n2 = listDataEvent.getIndex0();
            if (n2 < 0) {
                return;
            }
            ISpssVariable iSpssVariable = null;
            GSARDataListContainer gSARDataListContainer = null;
            iSpssVariable = object == this.mBothVarList.getModel() ? ((STEMSelectRolePage.STEMVarListModel)this.mBothVarList.getModel()).getRemovedVar() : (object == this.mPredVarList.getModel() ? ((STEMSelectRolePage.STEMVarListModel)this.mPredVarList.getModel()).getRemovedVar() : ((STEMSelectRolePage.STEMVarListModel)this.mConditionVarList.getModel()).getRemovedVar());
            if (n > 0) {
                gSARDataListContainer = this.mSources.get(n - 1);
            } else if (n == 0 && (n = this.findSourceIndex(iSpssVariable)) >= 0) {
                gSARDataListContainer = this.mSources.get(n);
            }
            if (gSARDataListContainer != null && iSpssVariable != null) {
                if (object == this.mBothVarList.getModel()) {
                    gSARDataListContainer.removeTargetBothField(iSpssVariable);
                } else if (object == this.mPredVarList.getModel()) {
                    gSARDataListContainer.removeTargetPredField(iSpssVariable);
                } else {
                    gSARDataListContainer.removeTargetCondField(iSpssVariable);
                }
                gSARDataListContainer.addSourceField(iSpssVariable);
            }
        }
        this.mWizardDialog.enableNext(this.validate());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    private int findSourceIndex(ISpssVariable iSpssVariable) {
        for (int i = 0; i < this.mSources.size(); ++i) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(i);
            if (!gSARDataListContainer.findVariable(iSpssVariable)) continue;
            return i;
        }
        return -1;
    }

    String getDataSourceIdFor(ISpssVariable iSpssVariable) {
        for (int i = 0; i < this.mSources.size(); ++i) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(i);
            if (!gSARDataListContainer.findVariable(iSpssVariable)) continue;
            return gSARDataListContainer.getDataId();
        }
        return "";
    }

    boolean isDataSourceEvent(String string) {
        boolean bl = false;
        if (string.equals(this.mSources.get(0).getDataId())) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected void initTargetPanelVar() {
        this.mInfoText = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STEP_TWO_INFOR_TEXT"), null);
        this.mDataSourceList.addListSelectionListener(this);
        this.mVariableSrcList.getModel().addListDataListener(this);
        this.mBothVarList = new TargetVariableList();
        STEMSelectRolePage.STEMVarListModel sTEMVarListModel = new STEMSelectRolePage.STEMVarListModel(this, this.mBothVarList);
        this.mBothVarList.setModel(sTEMVarListModel);
        this.mBothVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mBothVarList.setIdentifier("IDS_CSAR_STEP_TWO_BOTH_VARIABLE_TARGET_LIST");
        this.mBothVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mBothVarList.getFixedCellHeight() * 4 + 2));
        this.mBothVarList.getModel().addListDataListener(this);
        this.mBothVarListLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_TWO_BOTH_LIST");
        this.mBothVarListLabel.setLabelFor(this.mBothVarList);
        this.mBothVarListScrollPane = new JScrollPane(this.mBothVarList);
        this.mBothVarListScrollPane.setPreferredSize(this.mBothVarList.getMinimumSize());
        this.mBothVarListScrollPane.setVerticalScrollBarPolicy(20);
        this.mBothVarListScrollPane.setHorizontalScrollBarPolicy(30);
        this.mPredVarListLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_TWO_ANTECEDENT_LIST");
        this.mPredVarList = new TargetVariableList();
        STEMSelectRolePage.STEMVarListModel sTEMVarListModel2 = new STEMSelectRolePage.STEMVarListModel(this, this.mPredVarList);
        this.mPredVarList.setModel(sTEMVarListModel2);
        this.mPredVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mPredVarList.setIdentifier("IDS_CSAR_STEP_TWO_TARGET_LIST");
        this.mPredVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mPredVarList.getFixedCellHeight() * 4 + 2));
        this.mPredVarList.getModel().addListDataListener(this);
        this.mPredVarListLabel.setLabelFor(this.mPredVarList);
        this.mPredeScrollPane = new JScrollPane(this.mPredVarList);
        this.mPredeScrollPane.setVerticalScrollBarPolicy(20);
        this.mPredeScrollPane.setHorizontalScrollBarPolicy(30);
        this.mPredeScrollPane.setPreferredSize(this.mPredVarList.getMinimumSize());
        this.mConditionVarList = new TargetVariableList();
        STEMSelectRolePage.STEMVarListModel sTEMVarListModel3 = new STEMSelectRolePage.STEMVarListModel(this, this.mConditionVarList);
        this.mConditionVarList.setModel(sTEMVarListModel3);
        this.mConditionVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mConditionVarList.setIdentifier("IDS_CSAR_STEP_TWO_PREDICTOR_LIST");
        this.mConditionVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mConditionVarList.getFixedCellHeight() * 4 + 2));
        this.mConditionVarList.getModel().addListDataListener(this);
        this.mConditionVarListLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_TWO_CONSEQUENT_LIST");
        this.mConditionVarListLabel.setLabelFor(this.mConditionVarList);
        this.mConsqVarListScrollPane = new JScrollPane(this.mConditionVarList);
        this.mConsqVarListScrollPane.setVerticalScrollBarPolicy(20);
        this.mConsqVarListScrollPane.setHorizontalScrollBarPolicy(30);
        this.mConsqVarListScrollPane.setPreferredSize(this.mConditionVarList.getMinimumSize());
        this.mConditionArrowButton = new GSARArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mConditionArrowButton.setVarMoveHandler(this);
        this.mConditionArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mConditionArrowButton.registerVariableList(this.mConditionVarList, SpssArrowButton.ButtonOrientation.left);
        this.mBothArrowButton = new GSARArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mBothArrowButton.setVarMoveHandler(this);
        this.mBothArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mBothArrowButton.registerVariableList(this.mBothVarList, SpssArrowButton.ButtonOrientation.left);
        this.mPredArrowButton = new GSARArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPredArrowButton.setVarMoveHandler(this);
        this.mPredArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mPredArrowButton.registerVariableList(this.mPredVarList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected void addTargetPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mBothVarListLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mBothArrowButton, gridBagConstraints, 1, 3, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mBothVarListScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mPredVarListLabel, gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mPredArrowButton, gridBagConstraints, 1, 5, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        insets.set(1, insets2.left, n2, n2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mPredeScrollPane, gridBagConstraints, 2, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mConditionVarListLabel, gridBagConstraints, 2, 6, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(1, insets2.left, 10, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mConditionArrowButton, gridBagConstraints, 1, 7, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, insets2.left, 10, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mConsqVarListScrollPane, gridBagConstraints, 2, 7, 1, 1, n, insets);
        this.setDefault();
        this.setTabTraversalOrder();
    }

    Vector<String> getPredFields() {
        Vector<String> vector = new Vector<String>();
        int n = this.mSources.size();
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(n2);
            Vector<String> vector2 = gSARDataListContainer.getPredString();
            for (String string : vector2) {
                vector.add(string);
            }
        }
        return vector;
    }

    Vector<String> getAllDataSourceIDs() {
        Vector<String> vector = new Vector<String>();
        int n = this.mSources.size();
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(n2);
            vector.add(gSARDataListContainer.getDataId());
        }
        return vector;
    }

    Vector<String> getAllModelFields() {
        Vector<String> vector = new Vector<String>();
        int n = this.mSources.size();
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(n2);
            Vector<String> vector2 = gSARDataListContainer.getAllModelFieldString();
            for (String string : vector2) {
                vector.add(string);
            }
        }
        return vector;
    }

    boolean isSameMeasurLevel(String string, String string2) {
        if (string.trim().length() == 0 || string2.trim().length() == 0) {
            return false;
        }
        ISpssVariable iSpssVariable = this.getVariable(string, null);
        ISpssVariable iSpssVariable2 = this.getVariable(string2, null);
        if (iSpssVariable == null || iSpssVariable2 == null) {
            return false;
        }
        return iSpssVariable.getMeasurementLevel() == iSpssVariable2.getMeasurementLevel();
    }

    Vector<ISpssVariable> getContAndOrdinalModelField() {
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        int n = this.mSources.size();
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(n2);
            Vector<ISpssVariable> vector2 = gSARDataListContainer.getContAndOrdinalField();
            for (ISpssVariable iSpssVariable : vector2) {
                vector.add(iSpssVariable);
            }
        }
        return vector;
    }

    public ISpssVariable getVariable(String string, Vector<String> vector) {
        int n = string.lastIndexOf("(");
        String string2 = string.substring(n + 1, string.length() - 2);
        boolean bl = ((STEMWizardDlg)this.mWizardDialog).getContextPage().countEventData() > 1;
        String string3 = string.substring(0, n);
        int n2 = this.mSources.size();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(n3);
            if (!gSARDataListContainer.getDataId().equals(string2)) continue;
            if (vector != null) {
                if (n3 == 0) {
                    vector.add("EVENT");
                } else {
                    vector.add(gSARDataListContainer.getRealId());
                }
            }
            return gSARDataListContainer.getVariable(string3);
        }
        return null;
    }

    @Override
    public String getNextPage() {
        return "STEMSettingsPage";
    }

    @Override
    public boolean validate() {
        int n = this.mBothVarList.getModel().getSize();
        int n2 = this.mPredVarList.getModel().getSize();
        int n3 = this.mConditionVarList.getModel().getSize();
        boolean bl = false;
        if (n2 > 0 && n3 > 0) {
            bl = true;
        } else if (n > 0 && n3 > 0) {
            bl = true;
        } else if (n > 0 && n2 > 0) {
            bl = true;
        } else if (n >= 2) {
            bl = true;
        }
        for (int i = 0; i < this.mSources.size() && bl; ++i) {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(i);
            bl = gSARDataListContainer.getTargetBothModel().getSize() > 0 || gSARDataListContainer.getTargetCondModel().getSize() > 0 || gSARDataListContainer.getTargetPredModel().getSize() > 0;
        }
        return bl && super.validate();
    }

    @Override
    public boolean validateOnBack() {
        if (((STEMWizardDlg)this.mWizardDialog).getContextPage().countEventData() == 1) {
            ((STEMWizardDlg)this.mWizardDialog).getContextPage().setKeepSettings(true);
        }
        return true;
    }

    void reset() {
        this.mBothVarList.removeAll();
        this.mPredVarList.removeAll();
        this.mConditionVarList.removeAll();
        if (this.mSources != null) {
            this.mSources.clear();
        }
        this.mDataSourceList.removeAll();
        this.mDataSourceList.setModel(new DefaultListModel());
    }

    void setKeepTarget(boolean bl) {
        this.mKeepTargets = bl;
    }

    protected void loadFieldList(int n) {
        if (n < 0) {
            return;
        }
        if (n == 0) {
            this.mVariableSrcList.getModel().removeAll();
            this.mVariableSrcList.removeAllVarFilters();
            VarListModel varListModel = this.mVariableSrcList.getModel();
            for (int i = 0; i < this.mSources.size(); ++i) {
                GSARDataListContainer gSARDataListContainer = this.mSources.get(i);
                VarListModel varListModel2 = gSARDataListContainer.getSourceModel();
                for (int j = 0; j < varListModel2.getSize(); ++j) {
                    varListModel.addElement(varListModel2.getElementAt(j));
                }
            }
            this.mVariableSrcList.setModel(varListModel);
            this.mVariableSrcList.setSelectedIndex(0);
            this.addCellRender(null);
        } else {
            GSARDataListContainer gSARDataListContainer = this.mSources.get(n - 1);
            VarListModel varListModel = gSARDataListContainer.getSourceModel();
            if (varListModel != null) {
                this.mVariableSrcList.getModel().removeAll();
                this.mVariableSrcList.removeAllVarFilters();
                VarListModel varListModel3 = this.mVariableSrcList.getModel();
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    varListModel3.addElement(varListModel.getElementAt(i));
                }
                this.mVariableSrcList.setModel(varListModel3);
                this.mVariableSrcList.setSelectedIndex(0);
            }
            this.addCellRender(gSARDataListContainer);
        }
    }

    @Override
    public void moveVarOnPredefinedRole() {
        int n;
        if (this.mSources == null || this.mDataSourceList == null) {
            return;
        }
        this.mBothVarList.getModel().removeAll();
        this.mPredVarList.getModel().removeAll();
        this.mConditionVarList.getModel().removeAll();
        for (n = 0; n < this.mSources.size(); ++n) {
            this.mSources.get(n).setUpPredefinedRoleList();
            this.fillTargetList(this.mSources.get(n));
        }
        n = this.mDataSourceList.getSelectedIndex();
        this.loadFieldList(n);
        this.mSelectedSrcIndex = n;
    }

    @Override
    public void moveVarOnCustomRole() {
        int n;
        if (this.mSources == null || this.mDataSourceList == null) {
            return;
        }
        this.mBothVarList.getModel().removeAll();
        this.mPredVarList.getModel().removeAll();
        this.mConditionVarList.getModel().removeAll();
        for (n = 0; n < this.mSources.size(); ++n) {
            this.mSources.get(n).MoveAllVarToSource();
        }
        n = this.mDataSourceList.getSelectedIndex();
        this.loadFieldList(n);
        this.mSelectedSrcIndex = n;
    }

    private void addCellRender(GSARDataListContainer gSARDataListContainer) {
        TargetlistCellRenderer targetlistCellRenderer = new TargetlistCellRenderer(gSARDataListContainer, this.mBothVarList);
        this.mBothVarList.setCellRenderer(targetlistCellRenderer);
        TargetlistCellRenderer targetlistCellRenderer2 = new TargetlistCellRenderer(gSARDataListContainer, this.mPredVarList);
        this.mPredVarList.setCellRenderer(targetlistCellRenderer2);
        TargetlistCellRenderer targetlistCellRenderer3 = new TargetlistCellRenderer(gSARDataListContainer, this.mConditionVarList);
        this.mConditionVarList.setCellRenderer(targetlistCellRenderer3);
    }

    @Override
    String getDataRoleSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        int n = this.mSources.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean bl;
            GSARDataListContainer gSARDataListContainer = this.mSources.get(i);
            stringBuffer.append("\n /DATASET");
            stringBuffer.append(" DATAID=");
            boolean bl2 = bl = i == 0;
            if (bl) {
                stringBuffer.append(this.mEventDataId);
            } else {
                stringBuffer.append(gSARDataListContainer.getDataId());
            }
            StringBuffer stringBuffer2 = new StringBuffer("");
            boolean bl3 = false;
            if (bl && ((STEMWizardDlg)this.mWizardDialog).getContextPage().countEventData() > 1) {
                bl3 = true;
                object4 = gSARDataListContainer.getSourceModel();
                stringBuffer2.append(" KEEP=");
            }
            object4 = "";
            VarListModel varListModel = gSARDataListContainer.getTargetBothModel();
            int n2 = 0;
            for (n2 = 0; n2 < varListModel.getSize(); ++n2) {
                object3 = varListModel.getElementAt(n2).getName();
                object4 = (String)object4 + (String)object3 + " ";
                if (!bl3) continue;
                object2 = ((STEMWizardDlg)this.mWizardDialog).getMergePage().getEventDataField((String)object3);
                stringBuffer2.append((String)object3);
                stringBuffer2.append("(" + ((MergeEventDataPage.EventDataField)object2).getDataSourceId() + " " + this.getVarTypeAndMLSynstax(((MergeEventDataPage.EventDataField)object2).getSpssVar()) + ") ");
            }
            object3 = object4;
            varListModel = gSARDataListContainer.getTargetPredModel();
            for (n2 = 0; n2 < varListModel.getSize(); ++n2) {
                object2 = varListModel.getElementAt(n2).getName();
                object3 = (String)object3 + (String)object2 + " ";
                if (!bl3) continue;
                object = ((STEMWizardDlg)this.mWizardDialog).getMergePage().getEventDataField((String)object2);
                stringBuffer2.append((String)object2);
                stringBuffer2.append("(" + ((MergeEventDataPage.EventDataField)object).getDataSourceId() + " " + this.getVarTypeAndMLSynstax(((MergeEventDataPage.EventDataField)object).getSpssVar()) + ") ");
            }
            object2 = object4;
            varListModel = gSARDataListContainer.getTargetCondModel();
            for (n2 = 0; n2 < varListModel.getSize(); ++n2) {
                object = varListModel.getElementAt(n2).getName();
                object2 = (String)object2 + (String)object + " ";
                if (!bl3) continue;
                MergeEventDataPage.EventDataField eventDataField = ((STEMWizardDlg)this.mWizardDialog).getMergePage().getEventDataField((String)object);
                stringBuffer2.append((String)object);
                stringBuffer2.append("(" + eventDataField.getDataSourceId() + " " + this.getVarTypeAndMLSynstax(eventDataField.getSpssVar()) + ") ");
            }
            if (bl3) {
                stringBuffer.append(stringBuffer2);
            }
            if (((String)object3).length() > 0) {
                stringBuffer.append(" PREDICTIONS=" + (String)object3);
            }
            if (((String)object2).length() > 0) {
                stringBuffer.append(" CONDITIONS=" + (String)object2);
            }
            object = ((STEMWizardDlg)this.mWizardDialog).getGSARSettingsPage().getBinExceptionSyntax(gSARDataListContainer.getDataId());
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    private String getVarTypeAndMLSynstax(ISpssVariable iSpssVariable) {
        String string = "";
        string = iSpssVariable.getType() > 0 ? string + "STRING " : string + "NUMERIC ";
        MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
        string = measurementLevel.equals((Object)MeasurementLevel.nominal) ? string + "NOMINAL" : (measurementLevel.equals((Object)MeasurementLevel.ordinal) ? string + "ORDINAL" : string + "SCALE");
        return string;
    }

    private void setDefault() {
        this.mConditionArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mConditionArrowButton.setEnabled(true);
        this.mBothArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfoText);
        vector.add(this.mDataSourceList);
        Vector<Object> vector2 = this.mSortPanel.getTabTraversalComponent();
        vector.addAll(vector2);
        vector.add(this.mVariableSrcList);
        vector.addAll(this.mSelectorPanel.getTabTraversalComponent());
        vector.add(this.mBothArrowButton);
        vector.add(this.mBothVarList);
        vector.add(this.mPredArrowButton);
        vector.add(this.mPredVarList);
        vector.add(this.mConditionArrowButton);
        vector.add(this.mConditionVarList);
        Vector<Object> vector3 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector3, false);
    }

    private void setupSourceContainer() {
        boolean bl = ((STEMWizardDlg)this.mWizardDialog).getContextPage().countEventData() > 1;
        int n = this.mDataSourceList.getModel().getSize();
        this.mSources = new Vector();
        ListModel listModel = this.mDataSourceList.getModel();
        for (int i = 1; i < n; ++i) {
            String string = listModel.getElementAt(i).toString();
            GSARDataListContainer gSARDataListContainer = new GSARDataListContainer(string);
            if (!bl && i == 1) {
                gSARDataListContainer.setRealId(this.mEventDataId);
            }
            VarListModel varListModel = gSARDataListContainer.getSourceModel();
            Vector vector = (Vector)this.mDataAndFields.get(string);
            if (vector != null) {
                for (ISpssVariable iSpssVariable : vector) {
                    varListModel.addElement(iSpssVariable);
                }
            }
            gSARDataListContainer.setSourceModel(varListModel);
            this.mSources.add(i - 1, gSARDataListContainer);
        }
    }

    private void fillTargetList(GSARDataListContainer gSARDataListContainer) {
        ISpssVariable iSpssVariable;
        int n;
        VarListModel varListModel = gSARDataListContainer.getTargetBothModel();
        for (n = 0; n < varListModel.getSize(); ++n) {
            iSpssVariable = varListModel.getElementAt(n);
            if (this.mBothVarList.getModel().contains(iSpssVariable)) continue;
            this.mBothVarList.getModel().addElement(iSpssVariable);
        }
        varListModel = gSARDataListContainer.getTargetCondModel();
        for (n = 0; n < varListModel.getSize(); ++n) {
            iSpssVariable = varListModel.getElementAt(n);
            if (this.mConditionVarList.getModel().contains(iSpssVariable)) continue;
            this.mConditionVarList.getModel().addElement(iSpssVariable);
        }
        varListModel = gSARDataListContainer.getTargetPredModel();
        for (n = 0; n < varListModel.getSize(); ++n) {
            iSpssVariable = varListModel.getElementAt(n);
            if (this.mPredVarList.getModel().contains(iSpssVariable)) continue;
            this.mPredVarList.getModel().addElement(iSpssVariable);
        }
    }

    class TargetlistCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private GSARDataListContainer mSource;
        private TargetVariableList mTargetList;

        TargetlistCellRenderer(GSARDataListContainer gSARDataListContainer, TargetVariableList targetVariableList) {
            this.mSource = gSARDataListContainer;
            this.mTargetList = targetVariableList;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3 = object instanceof ISpssVariable;
            boolean bl4 = GSARDefineRolePage.this.mVariableSrcList.getShowVarLabels();
            boolean bl5 = false;
            ISpssVariable iSpssVariable = null;
            if (bl3) {
                iSpssVariable = (ISpssVariable)object;
                this.setIcon(GSARDefineRolePage.this.mVariableSrcList.getShowIcon() ? this.mTargetList.getIcon((ISpssVariable)object) : null);
                String string = iSpssVariable.getName();
                String string2 = iSpssVariable.getLabel();
                if (!ComponentState.isBtdRtlOrLtr()) {
                    if (bl4 && string2.length() > 0) {
                        this.setText(string2 + " [" + string + "]");
                    } else {
                        this.setText(string);
                    }
                } else if (bl4 && string2.length() > 0) {
                    this.setText(this.concatLabelNameForBidiDispaly(string2, string));
                } else {
                    this.setText(this.concatLabelNameForBidiDispaly(null, string));
                }
                if (iSpssVariable.getId().isNull() && CommandLine.isClementineCaller() && !DialogDataModel.isSpecialVariable(iSpssVariable)) {
                    bl5 = true;
                }
            } else {
                this.setText(object != null ? object.toString() : "");
            }
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                if (bl5) {
                    this.setForeground(Color.RED);
                }
            } else {
                this.setOpaque(false);
            }
            boolean bl6 = jList.isEnabled();
            if (iSpssVariable != null && this.mSource != null) {
                bl6 = this.mSource.findVariable(iSpssVariable);
            }
            this.setEnabled(bl6);
            this.setFont(jList.getFont());
            this.handleBorder(jList, bl2);
            return this;
        }

        private String concatLabelNameForBidiDispaly(String string, String string2) {
            String string3 = null;
            if (string == null && string2 == null) {
                return string3;
            }
            string3 = string != null && string.length() > 0 ? (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200f' + string + " [" + string2 + "]" : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200e' + string + " [" + string2 + "]" : string + " [" + string2 + "]")) : (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200f' + string2 : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200e' + string2 : string2));
            return string3;
        }

        private void handleBorder(JList jList, boolean bl) {
            if (sNoFocusBorder == null || sFocusBorder == null) {
                this.createBorders();
            }
            Border border = bl && jList.isEnabled() ? sFocusBorder : sNoFocusBorder;
            this.setBorder(border);
        }

        private void createBorders() {
            Border border = BorderFactory.createEmptyBorder(0, 2, 0, 0);
            Border border2 = UIManager.getBorder("List.focusCellHighlightBorder");
            sFocusBorder = BorderFactory.createCompoundBorder(border2, border);
            border2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            sNoFocusBorder = BorderFactory.createCompoundBorder(border2, border);
        }
    }

    class GSARArrowButton
    extends ArrowButton {
        public GSARArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        protected boolean canMoveVars(VariableList variableList, ISpssVariable[] iSpssVariableArray) {
            int n = GSARDefineRolePage.this.mDataSourceList.getSelectedIndex();
            boolean bl = true;
            if (n > 0) {
                GSARDataListContainer gSARDataListContainer = (GSARDataListContainer)GSARDefineRolePage.this.mSources.get(n - 1);
                if (variableList instanceof SrcVariableList) {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (gSARDataListContainer.findVariable(iSpssVariable)) continue;
                        bl = false;
                        break;
                    }
                }
            }
            return bl && super.canMoveVars(variableList, iSpssVariableArray);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            GSARDefineRolePage.this.mResetTarget = false;
        }
    }

    class GSARDataListContainer {
        private String mDataId;
        private String mRealId;
        private Vector<ISpssVariable> mVariables;
        private SrcVariableList mSrcList;
        private TargetVariableList mBothList;
        private TargetVariableList mPredtionList;
        private TargetVariableList mConditionList;

        public GSARDataListContainer(String string) {
            this.mDataId = string;
            this.mSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
            this.mSrcList.setIdentifier(string);
            this.mBothList = new TargetVariableList();
            this.mBothList.setIdentifier(string + "_BOTH");
            this.mPredtionList = new TargetVariableList();
            this.mPredtionList.setIdentifier(string + "_PREDIC");
            this.mConditionList = new TargetVariableList();
            this.mConditionList.setIdentifier(string + "_CONDI");
            this.mVariables = new Vector();
            this.mRealId = this.mDataId;
        }

        public VarListModel getSourceModel() {
            return this.mSrcList.getModel();
        }

        public ISpssVariable getVariable(String string) {
            for (ISpssVariable iSpssVariable : this.mVariables) {
                if (!iSpssVariable.getName().equals(string)) continue;
                return iSpssVariable;
            }
            return null;
        }

        public void setSourceModel(VarListModel varListModel) {
            this.mSrcList.setModel(varListModel);
            for (int i = 0; i < varListModel.getSize(); ++i) {
                this.mVariables.add(i, varListModel.getElementAt(i));
            }
        }

        public boolean findVariable(ISpssVariable iSpssVariable) {
            return this.mVariables.contains(iSpssVariable);
        }

        public void addSourceField(ISpssVariable iSpssVariable) {
            this.mSrcList.getModel().addElement(iSpssVariable);
        }

        public void removeSourceField(ISpssVariable iSpssVariable) {
            this.mSrcList.getModel().removeElement(iSpssVariable);
        }

        public VarListModel getTargetBothModel() {
            return this.mBothList.getModel();
        }

        public void setTargetBothModel(VarListModel varListModel) {
            this.mBothList.setModel(varListModel);
        }

        public boolean addTargetBothField(ISpssVariable iSpssVariable) {
            boolean bl = false;
            if (this.findVariable(iSpssVariable) && this.mBothList.getModel().findElementIndex(iSpssVariable) < 0) {
                this.mBothList.getModel().addElement(iSpssVariable);
                bl = true;
            }
            return bl;
        }

        public void removeTargetBothField(ISpssVariable iSpssVariable) {
            this.mBothList.getModel().removeElement(iSpssVariable);
        }

        public VarListModel getTargetPredModel() {
            return this.mPredtionList.getModel();
        }

        public void setTargetPredModel(VarListModel varListModel) {
            this.mPredtionList.setModel(varListModel);
        }

        public boolean addTargetPredField(ISpssVariable iSpssVariable) {
            boolean bl = false;
            if (this.findVariable(iSpssVariable) && this.mPredtionList.getModel().findElementIndex(iSpssVariable) < 0) {
                this.mPredtionList.getModel().addElement(iSpssVariable);
                bl = true;
            }
            return bl;
        }

        public Vector<String> getPredString() {
            String string;
            ISpssVariable iSpssVariable;
            Vector<String> vector = new Vector<String>();
            VarListModel varListModel = this.mBothList.getModel();
            int n = 0;
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                string = iSpssVariable.getName() + "(" + this.mDataId + ") ";
                vector.add(string);
            }
            varListModel = this.mPredtionList.getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                string = iSpssVariable.getName() + "(" + this.mDataId + ") ";
                vector.add(string);
            }
            return vector;
        }

        public Vector<String> getAllModelFieldString() {
            Vector<String> vector = this.getPredString();
            VarListModel varListModel = this.mConditionList.getModel();
            int n = 0;
            for (n = 0; n < varListModel.getSize(); ++n) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(n);
                String string = iSpssVariable.getName() + "(" + this.mDataId + ") ";
                vector.add(string);
            }
            return vector;
        }

        public Vector<ISpssVariable> getContAndOrdinalField() {
            ISpssVariable iSpssVariable;
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
            VarListModel varListModel = this.mBothList.getModel();
            int n = 0;
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() || iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale && iSpssVariable.getMeasurementLevel() != MeasurementLevel.ordinal) continue;
                vector.add(iSpssVariable);
            }
            varListModel = this.mPredtionList.getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() || iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale && iSpssVariable.getMeasurementLevel() != MeasurementLevel.ordinal) continue;
                vector.add(iSpssVariable);
            }
            varListModel = this.mConditionList.getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() || iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale && iSpssVariable.getMeasurementLevel() != MeasurementLevel.ordinal) continue;
                vector.add(iSpssVariable);
            }
            return vector;
        }

        public void removeTargetPredField(ISpssVariable iSpssVariable) {
            this.mPredtionList.getModel().removeElement(iSpssVariable);
        }

        public VarListModel getTargetCondModel() {
            return this.mConditionList.getModel();
        }

        public void setTargetCondModel(VarListModel varListModel) {
            this.mConditionList.setModel(varListModel);
        }

        public boolean addTargetCondField(ISpssVariable iSpssVariable) {
            boolean bl = false;
            if (this.findVariable(iSpssVariable) && this.mConditionList.getModel().findElementIndex(iSpssVariable) < 0) {
                this.mConditionList.getModel().addElement(iSpssVariable);
                bl = true;
            }
            return bl;
        }

        public void removeTargetCondField(ISpssVariable iSpssVariable) {
            this.mConditionList.getModel().removeElement(iSpssVariable);
        }

        public String getDataId() {
            return this.mDataId;
        }

        public String getRealId() {
            return this.mRealId;
        }

        public void setRealId(String string) {
            this.mRealId = string;
        }

        public void setUpPredefinedRoleList() {
            if (this.mVariables == null || this.mVariables.size() == 0) {
                return;
            }
            this.mSrcList.getModel().removeAll();
            this.mBothList.getModel().removeAll();
            this.mPredtionList.getModel().removeAll();
            this.mConditionList.getModel().removeAll();
            for (ISpssVariable iSpssVariable : this.mVariables) {
                if (iSpssVariable.getRole() == Role.both) {
                    this.mBothList.getModel().addElement(iSpssVariable);
                    continue;
                }
                if (iSpssVariable.getRole() == Role.input) {
                    this.mConditionList.getModel().addElement(iSpssVariable);
                    continue;
                }
                if (iSpssVariable.getRole() == Role.target) {
                    this.mPredtionList.getModel().addElement(iSpssVariable);
                    continue;
                }
                this.mSrcList.getModel().addElement(iSpssVariable);
            }
        }

        public void MoveAllVarToSource() {
            if (this.mVariables == null || this.mVariables.size() == 0) {
                return;
            }
            this.mSrcList.getModel().removeAll();
            this.mBothList.getModel().removeAll();
            this.mPredtionList.getModel().removeAll();
            this.mConditionList.getModel().removeAll();
            for (ISpssVariable iSpssVariable : this.mVariables) {
                this.mSrcList.getModel().addElement(iSpssVariable);
            }
        }
    }
}

