/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.SelectCoordinateSubDlg;
import com.spss.java_client.ui.dialogs.STEM.ValidateKeysSubDlg;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public class DataMapAssociationSubDlg
extends BaseDialog
implements ItemListener,
ListDataListener,
DocumentListener {
    static int COMBOBOX_WIDTH = 50;
    static String DATA_FIELD_LIST = "IDS_STEM_ASSOCIATION_DATA_FIELD_LIST";
    static String TARGET_DATA_KEYS = "IDS_STEM_ASSOCIATION_TARGET_DATA_KEYS";
    static String SRC_MAP_KEY_LIST = "IDS_STEM_ASSOCIATION_SRC_MAP_KEY_LIST";
    static String TARGET_MAP_KEYS = "IDS_STEM_ASSOCIATION_TARGET_MAP_KEYS";
    protected ContinueAction mContinueAction;
    protected ValidateAction mValidateAction;
    private JLabel mEventDataLabel;
    private FocusableTextArea mEventDataName;
    private FocusableLabel mAssocLabel;
    private JLabel mMapLabel;
    private JComboBox mMapCombo;
    private JRadioButton mByValueRadio;
    private JRadioButton mByCoordinateRadio;
    private SpssButtonGroup mButtonGroup;
    private JLabel mDataFieldListLabel;
    private SrcVariableList mDataFieldList;
    private JScrollPane mDataFieldListScrollPane;
    private JLabel mDataKeyLabel;
    private TargetVariableList mDataKeyList;
    private JScrollPane mDataKeyScrollPane;
    private ArrowButton mDataArrowButton;
    private JLabel mAllMapKeyListLabel;
    private SrcVariableList mAllMapKeyList;
    private JScrollPane mAllMapKeyListScrollPane;
    private JLabel mMapKeyListLabel;
    private TargetVariableList mMapKeyList;
    private ArrowButton mMapKeyArrowButton;
    private JScrollPane mMapKeyScrollPane;
    private JLabel mXLabel;
    private JComboBox mXCombo;
    private JLabel mYLabel;
    private JComboBox mYCombo;
    private JLabel mZLabel;
    private JComboBox mZCombo;
    private JButton mValidateButton;
    private JButton mContinueButton;
    private JLabel mKeyTableLabel;
    private JTable mKeyTable;
    private KeyTableModel mKeyTableModel;
    private Vector<String> mMapFiles;
    private Hashtable<String, Vector<ISpssVariable>> mMapKeys;
    private ContextDataItem mDataSourceItem;
    private boolean mIsGSAR;
    private boolean mIsContinuePressed;
    private boolean mValidationContinuePressed;
    private String[] mRoleString;
    private boolean mIsPoint;
    protected BaseWizardDialog mParentDlg;
    private String mDisplayProjection;

    public DataMapAssociationSubDlg(BaseWizardDialog baseWizardDialog, ContextDataItem contextDataItem, Vector<String> vector, Hashtable<String, Vector<ISpssVariable>> hashtable, boolean bl, boolean bl2, String[] stringArray) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_DATA_MAP_ASSOC_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mParentDlg = baseWizardDialog;
        this.mDataSourceItem = contextDataItem;
        this.mMapFiles = vector;
        this.mMapKeys = hashtable;
        this.mIsGSAR = bl;
        this.mIsPoint = bl2;
        this.mRoleString = stringArray;
        this.mDisplayProjection = "SIMPLE";
        this.initializePanel();
        this.setLocationRelativeTo(this.getParent());
        this.mIsContinuePressed = false;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_association");
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mByValueRadio || itemEvent.getSource() == this.mByCoordinateRadio) {
            this.enableControls();
            this.enableContinue();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mDataKeyList.getModel() || object == this.mMapKeyList.getModel()) {
            this.enableContinue();
            this.enableValidate();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mDataKeyList.getModel() || object == this.mMapKeyList.getModel()) {
            this.enableContinue();
            this.enableValidate();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setDefault();
    }

    private void initializePanel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.mMapFiles);
        this.mMapCombo.setModel(defaultComboBoxModel);
        this.mEventDataName.setText(this.mDataSourceItem.getDisplayID());
        if (defaultComboBoxModel.getSize() > 0) {
            this.selectMap();
        }
        Vector<String> vector = this.getNonTimeNumericFields();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(vector);
        this.mXCombo.setModel(defaultComboBoxModel2);
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>(vector);
        this.mYCombo.setModel(defaultComboBoxModel3);
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>(vector);
        this.mZCombo.setModel(defaultComboBoxModel4);
        this.loadDataKeySourceList();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.mByValueRadio.setSelected(true);
        if (vector.size() < 3 || this.mDataSourceItem.getDataType() == ContextDataItem.DataType.MAP && !this.mIsPoint || this.mIsGSAR && this.mDataSourceItem.isRoleContext()) {
            this.mByCoordinateRadio.setEnabled(false);
        } else {
            this.mXCombo.setSelectedIndex(this.getCoordinateFieldIndex(vector, this.mDataSourceItem.getCoordinateXVar()));
            this.mYCombo.setSelectedIndex(this.getCoordinateFieldIndex(vector, this.mDataSourceItem.getCoordinateYVar()));
            this.mZCombo.setSelectedIndex(this.getCoordinateFieldIndex(vector, this.mDataSourceItem.getCoordinateZVar()));
        }
        if (defaultComboBoxModel.getSize() == 0) {
            this.mByCoordinateRadio.setSelected(true);
            this.mByValueRadio.setEnabled(false);
        }
        if (this.mByCoordinateRadio.isEnabled() && this.mIsGSAR && !this.mDataSourceItem.isRoleContext()) {
            this.mByCoordinateRadio.setSelected(true);
        }
        if (this.mByCoordinateRadio.isEnabled() && this.mByValueRadio.isEnabled()) {
            if (this.mDataSourceItem.getAssocType() == ContextDataItem.AssocType.COORDINATE) {
                this.mByCoordinateRadio.setSelected(true);
            } else if (this.mDataSourceItem.getAssocType() == ContextDataItem.AssocType.KEYS) {
                this.mByValueRadio.setSelected(true);
            }
        }
        this.enableControls();
        this.pack();
    }

    private void selectMap() {
        int n = 0;
        String string = this.mDataSourceItem.getMapAssocId();
        for (int i = 0; i < this.mMapFiles.size(); ++i) {
            if (!string.equals(this.mMapFiles.get(i))) continue;
            n = i;
            break;
        }
        this.mMapCombo.setSelectedIndex(n);
        if (string.length() > 0) {
            this.loadMapKeyList(string, true);
        }
    }

    private int getCoordinateFieldIndex(Vector<String> vector, String string) {
        int n = vector.indexOf(string);
        if (n < 0) {
            return 0;
        }
        return n;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        this.mContinueButton = new JButton(this.mContinueAction);
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        this.mValidateAction = new ValidateAction();
        this.mValidateButton = new JButton(this.mValidateAction);
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mValidateButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mValidateButton);
                jPanel.add(this.mContinueButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mValidateButton);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mEventDataName = new FocusableTextArea("", null);
        this.mEventDataLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_DATA_LABEL");
        this.mEventDataLabel.setLabelFor(this.mEventDataName);
        this.mAssocLabel = new FocusableLabel(this.getResString("IDS_STEM_DATA_MAP_ASSOC_SUB_LABEL"));
        this.mMapLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_MAP_LABEL");
        this.mMapCombo = new JComboBox();
        this.mMapCombo.setAction(new ComboboxAction(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_MAP_LABEL"));
        this.mMapCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = DataMapAssociationSubDlg.this.mMapCombo.getSelectedItem();
                if (object != null) {
                    DataMapAssociationSubDlg.this.loadMapKeyList(object.toString(), false);
                }
            }
        });
        this.mMapLabel.setLabelFor(this.mMapCombo);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_BY_KEY");
        this.mByValueRadio = new JRadioButton(toggleButtonAction);
        this.mByValueRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_BY_COORDINATE");
        this.mByCoordinateRadio = new JRadioButton(toggleButtonAction);
        this.mByCoordinateRadio.addItemListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mByValueRadio);
        this.mButtonGroup.add(this.mByCoordinateRadio);
        this.mDataFieldList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mDataFieldList.setIdentifier(DATA_FIELD_LIST);
        this.mDataFieldList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDataFieldList.getFixedCellHeight() * 4 + 2));
        this.mDataFieldListLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_DATASET_LABEL");
        this.mDataFieldListLabel.setLabelFor(this.mDataFieldList);
        this.mDataFieldListScrollPane = new JScrollPane(this.mDataFieldList);
        this.mDataFieldListScrollPane.setPreferredSize(this.mDataFieldList.getMinimumSize());
        this.mDataFieldListScrollPane.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDataFieldList.getFixedCellHeight() * 4 + 2));
        this.mDataFieldListScrollPane.setHorizontalScrollBarPolicy(30);
        this.mDataFieldListScrollPane.setVerticalScrollBarPolicy(20);
        this.mDataKeyList = new TargetVariableList();
        this.mDataKeyList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDataKeyList.setIdentifier(TARGET_DATA_KEYS);
        this.mDataKeyList.getModel().addListDataListener(this);
        this.mDataKeyList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDataKeyList.getFixedCellHeight() * 4 + 2));
        this.mDataKeyLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_DATA_KEY_LABEL");
        this.mDataKeyLabel.setLabelFor(this.mDataKeyList);
        this.mDataKeyScrollPane = new JScrollPane(this.mDataKeyList);
        this.mDataKeyScrollPane.setPreferredSize(this.mDataKeyList.getMinimumSize());
        this.mDataKeyScrollPane.setMinimumSize(this.mDataKeyList.getMinimumSize());
        this.mDataKeyScrollPane.setVerticalScrollBarPolicy(20);
        this.mDataKeyScrollPane.setHorizontalScrollBarPolicy(30);
        this.mAllMapKeyList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mAllMapKeyList.setIdentifier(SRC_MAP_KEY_LIST);
        this.mAllMapKeyList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mAllMapKeyList.getFixedCellHeight() * 4 + 2));
        this.mAllMapKeyListLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_MAP_KEY_LABEL");
        this.mAllMapKeyListLabel.setLabelFor(this.mAllMapKeyList);
        this.mAllMapKeyListScrollPane = new JScrollPane(this.mAllMapKeyList);
        this.mAllMapKeyListScrollPane.setPreferredSize(this.mAllMapKeyList.getMinimumSize());
        this.mAllMapKeyListScrollPane.setMinimumSize(this.mAllMapKeyList.getMinimumSize());
        this.mAllMapKeyListScrollPane.setHorizontalScrollBarPolicy(30);
        this.mAllMapKeyListScrollPane.setVerticalScrollBarPolicy(20);
        this.mMapKeyList = new TargetVariableList();
        this.mMapKeyList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mMapKeyList.setIdentifier(TARGET_MAP_KEYS);
        this.mMapKeyList.getModel().addListDataListener(this);
        this.mMapKeyList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mMapKeyList.getFixedCellHeight() * 4 + 2));
        this.mMapKeyListLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_SELECT_MAP_KEY_LABEL");
        this.mMapKeyListLabel.setLabelFor(this.mMapKeyList);
        this.mMapKeyScrollPane = new JScrollPane(this.mMapKeyList);
        this.mMapKeyScrollPane.setPreferredSize(this.mMapKeyList.getMinimumSize());
        this.mMapKeyScrollPane.setMinimumSize(this.mMapKeyList.getMinimumSize());
        this.mMapKeyScrollPane.setVerticalScrollBarPolicy(20);
        this.mMapKeyScrollPane.setHorizontalScrollBarPolicy(30);
        this.mXLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_COORDINATES_X");
        this.mXCombo = new JComboBox(new DefaultComboBoxModel());
        int n = this.mXCombo.getPreferredSize().height;
        this.mXCombo.setPreferredSize(new Dimension(COMBOBOX_WIDTH, n));
        this.mXCombo.setAction(new ComboboxAction(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_COORDINATES_X"));
        this.mXLabel.setLabelFor(this.mXCombo);
        this.mXCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMapAssociationSubDlg.this.enableContinue();
            }
        });
        this.mYLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_COORDINATES_Y");
        this.mYCombo = new JComboBox(new DefaultComboBoxModel());
        this.mYCombo.setPreferredSize(new Dimension(COMBOBOX_WIDTH, n));
        this.mYCombo.setAction(new ComboboxAction(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_COORDINATES_Y"));
        this.mYLabel.setLabelFor(this.mYCombo);
        this.mYCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMapAssociationSubDlg.this.enableContinue();
            }
        });
        this.mZLabel = DialogUtil.createLabel(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_COORDINATES_Z");
        this.mZCombo = new JComboBox(new DefaultComboBoxModel());
        this.mZCombo.setPreferredSize(new Dimension(COMBOBOX_WIDTH, n));
        this.mZCombo.setAction(new ComboboxAction(this, "IDS_STEM_DATA_MAP_ASSOC_SUB_COORDINATES_Z"));
        this.mZLabel.setLabelFor(this.mZCombo);
        this.mZCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMapAssociationSubDlg.this.enableContinue();
            }
        });
        this.mDataArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDataArrowButton.registerVariableList(this.mDataFieldList, SpssArrowButton.ButtonOrientation.right);
        this.mDataArrowButton.registerVariableList(this.mDataKeyList, SpssArrowButton.ButtonOrientation.left);
        this.mMapKeyArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mMapKeyArrowButton.registerVariableList(this.mAllMapKeyList, SpssArrowButton.ButtonOrientation.right);
        this.mMapKeyArrowButton.registerVariableList(this.mMapKeyList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefault() {
    }

    private void loadMapKeyList(String string, boolean bl) {
        Vector<ISpssVariable> vector = this.mMapKeys.get(string);
        this.mAllMapKeyList.removeAll();
        this.mMapKeyList.removeAll();
        Vector<Object> vector2 = new Vector();
        if (this.mDataSourceItem.getDataType() != ContextDataItem.DataType.MAP && bl) {
            vector2 = this.mDataSourceItem.getSelectedMapKeys();
        }
        VarListModel varListModel = this.mMapKeyList.getModel();
        VarListModel varListModel2 = this.mAllMapKeyList.getModel();
        for (ISpssVariable iSpssVariable : vector) {
            if (!vector2.contains(iSpssVariable.getName())) {
                varListModel2.addElement(iSpssVariable);
                continue;
            }
            varListModel.addElement(iSpssVariable);
        }
    }

    private void loadDataKeySourceList() {
        this.mDataFieldList.removeAll();
        Vector<Object> vector = new Vector();
        vector = this.mDataSourceItem.getDataType() == ContextDataItem.DataType.MAP ? this.mDataSourceItem.getKeyList() : this.mDataSourceItem.getSelectedDataKeys();
        VarListModel varListModel = this.mDataKeyList.getModel();
        Vector<ISpssVariable> vector2 = this.mDataSourceItem.getSpssVars();
        VarListModel varListModel2 = this.mDataFieldList.getModel();
        for (ISpssVariable iSpssVariable : vector2) {
            if (!vector.contains(iSpssVariable.getName())) {
                varListModel2.addElement(iSpssVariable);
                continue;
            }
            varListModel.addElement(iSpssVariable);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mEventDataLabel);
        vector.add(this.mEventDataName);
        vector.add(this.mAssocLabel);
        vector.add(this.mByCoordinateRadio);
        vector.add(this.mXCombo);
        vector.add(this.mYCombo);
        vector.add(this.mZCombo);
        vector.add(this.mByValueRadio);
        vector.add(this.mMapCombo);
        vector.add(this.mDataFieldList);
        vector.add(this.mDataArrowButton);
        vector.add(this.mDataKeyList);
        vector.add(this.mAllMapKeyList);
        vector.add(this.mMapKeyArrowButton);
        vector.add(this.mMapKeyList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mEventDataLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mEventDataName, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mAssocLabel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mByCoordinateRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        JPanel jPanel4 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel4, this.mXLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel4, this.mXCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel4, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel5 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel5, this.mYLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel5, this.mYCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel5, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel6 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel6, this.mZLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel6, this.mZCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel6, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2 * 2, n2, 2);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mByValueRadio, gridBagConstraints, 0, 4, 2, 1, n, insets);
        JPanel jPanel7 = PanelFactory.getEmptyPanel(this.getResString("IDS_STEM_DATA_MAP_ASSOC_SUB_KEY_PANEL_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, n2, 2);
        DialogUtil.addUsingGBL(jPanel7, PanelFactory.getBasicPanel(new JComponent[]{this.mMapLabel, this.mMapCombo}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mDataFieldListLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(1, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mDataFieldListScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mAllMapKeyListLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(1, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mAllMapKeyListScrollPane, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mDataArrowButton, gridBagConstraints, 1, 2, 1, 1, 10, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mMapKeyArrowButton, gridBagConstraints, 1, 4, 1, 1, 10, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mDataKeyLabel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(1, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mDataKeyScrollPane, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mMapKeyListLabel, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(1, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mMapKeyScrollPane, gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(1, n2 * 2, n2, 2);
        DialogUtil.addUsingGBL(jPanel, jPanel7, gridBagConstraints, 0, 5, 2, 1, n, insets);
    }

    private Vector<String> getNonTimeNumericFields() {
        Vector<String> vector = new Vector<String>();
        Vector<ISpssVariable> vector2 = this.mDataSourceItem.getSpssVars();
        for (ISpssVariable iSpssVariable : vector2) {
            if (iSpssVariable.getType() != 0 || iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) continue;
            vector.add(iSpssVariable.getName());
        }
        if (vector.size() > 0) {
            vector.insertElementAt("", 0);
        }
        return vector;
    }

    private void enableZCoordinate(boolean bl) {
        if (this.mIsGSAR) {
            this.mZCombo.setEnabled(false);
            this.mZLabel.setEnabled(false);
        } else {
            this.mZCombo.setEnabled(bl);
            this.mZLabel.setEnabled(bl);
        }
    }

    private void enableControls() {
        if (this.mByValueRadio.isSelected()) {
            this.mMapLabel.setEnabled(true);
            this.mMapCombo.setEnabled(true);
            this.mDataFieldListLabel.setEnabled(true);
            this.mDataFieldList.setEnabled(true);
            this.mDataKeyLabel.setEnabled(true);
            this.mDataKeyList.setEnabled(true);
            this.mDataArrowButton.setEnabled(true);
            this.mAllMapKeyListLabel.setEnabled(true);
            this.mAllMapKeyList.setEnabled(true);
            this.mMapKeyListLabel.setEnabled(true);
            this.mMapKeyList.setEnabled(true);
            this.mMapKeyArrowButton.setEnabled(true);
            this.mXLabel.setEnabled(false);
            this.mXCombo.setEnabled(false);
            this.mYLabel.setEnabled(false);
            this.mYCombo.setEnabled(false);
            this.enableZCoordinate(false);
            this.mValidateButton.setEnabled(true);
        } else if (this.mByCoordinateRadio.isSelected()) {
            this.mMapLabel.setEnabled(false);
            this.mMapCombo.setEnabled(false);
            this.mDataFieldListLabel.setEnabled(false);
            this.mDataFieldList.setEnabled(false);
            this.mDataKeyLabel.setEnabled(false);
            this.mDataKeyList.setEnabled(false);
            this.mDataArrowButton.setEnabled(false);
            this.mAllMapKeyListLabel.setEnabled(false);
            this.mAllMapKeyList.setEnabled(false);
            this.mMapKeyListLabel.setEnabled(false);
            this.mMapKeyList.setEnabled(false);
            this.mMapKeyArrowButton.setEnabled(false);
            this.mXLabel.setEnabled(true);
            this.mXCombo.setEnabled(true);
            this.mYLabel.setEnabled(true);
            this.mYCombo.setEnabled(true);
            this.enableZCoordinate(true);
            this.mValidateButton.setEnabled(false);
        }
        if (this.mDataSourceItem.getDataType() == ContextDataItem.DataType.MAP) {
            this.mMapLabel.setEnabled(false);
            this.mMapCombo.setEnabled(false);
            this.mAllMapKeyListLabel.setEnabled(false);
            this.mAllMapKeyList.setEnabled(false);
            this.mMapKeyArrowButton.setEnabled(false);
            this.mMapKeyListLabel.setEnabled(false);
            this.mMapKeyList.setEnabled(false);
        }
        this.enableValidateButton();
    }

    private void enableContinue() {
        boolean bl = true;
        if (this.mByCoordinateRadio.isSelected()) {
            if (this.mXCombo.getSelectedItem() == null || this.mYCombo.getSelectedItem() == null) {
                bl = false;
            }
            if (bl) {
                if (this.mXCombo.getSelectedItem().toString().length() == 0 || this.mYCombo.getSelectedItem().toString().length() == 0) {
                    bl = false;
                } else if (this.mXCombo.getSelectedItem().toString().equals(this.mYCombo.getSelectedItem().toString())) {
                    bl = false;
                }
                if (bl && this.mZCombo.isEnabled()) {
                    String string = "";
                    if (this.mZCombo.getSelectedItem() != null && this.mZCombo.getSelectedItem().toString().length() == 0) {
                        string = this.mZCombo.getSelectedItem().toString();
                    }
                    if (bl && string.length() > 0 && (string.equals(this.mYCombo.getSelectedItem().toString()) || string.length() > 0 && string.equals(this.mYCombo.getSelectedItem().toString()))) {
                        bl = false;
                    }
                }
            }
        } else if (this.mByValueRadio.isSelected() && (bl = this.mDataKeyList.getModel().getSize() > 0) && this.mMapKeyList.isEnabled()) {
            bl = this.mMapKeyList.getModel().getSize() > 0 && this.mDataKeyList.getModel().getSize() == this.mMapKeyList.getModel().getSize();
        }
        this.mContinueButton.setEnabled(bl);
    }

    private void enableValidate() {
        boolean bl = true;
        if (this.mByCoordinateRadio.isSelected()) {
            bl = false;
        } else if (this.mByValueRadio.isSelected()) {
            if (!this.mMapCombo.isEnabled()) {
                bl = false;
            }
            if (bl) {
                bl = this.mMapKeyList.getModel().getSize() > 0 && this.mDataKeyList.getModel().getSize() == this.mMapKeyList.getModel().getSize();
            }
        }
        this.mValidateButton.setEnabled(bl);
    }

    public boolean continuePressed() {
        return this.mIsContinuePressed;
    }

    private boolean checkControls() {
        boolean bl = true;
        if (this.mByCoordinateRadio.isSelected()) {
            String string;
            String string2;
            boolean bl2 = false;
            String string3 = (String)this.mXCombo.getSelectedItem();
            if (string3.equals(string2 = (String)this.mYCombo.getSelectedItem())) {
                bl2 = true;
            }
            if (!bl2 && !this.mIsGSAR && ((string = (String)this.mZCombo.getSelectedItem()).equals(string3) || string.equals(string2))) {
                bl2 = true;
            }
            if (bl2) {
                string = this.getResString("IDS_STEM_DATA_MAP_ASSOC_SUB_SAME_VAR_ERROR");
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                bl = false;
            }
        }
        if (bl) {
            bl = this.isSelectedFieldTypeSame();
        }
        return bl;
    }

    boolean isSelectedFieldTypeSame() {
        boolean bl = true;
        if (this.mByValueRadio.isSelected() && this.mDataKeyList.getModel().getSize() > 0 && this.mDataKeyList.getModel().getSize() == this.mMapKeyList.getModel().getSize()) {
            int n = this.mDataKeyList.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = this.mDataKeyList.getModel().getElementAt(i);
                ISpssVariable iSpssVariable2 = this.mMapKeyList.getModel().getElementAt(i);
                if ((iSpssVariable.getType() != 0 || iSpssVariable2.getType() <= 0) && (iSpssVariable.getType() <= 0 || iSpssVariable2.getType() != 0)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                String string = this.getResString("IDS_STEM_VALIDATE_SAME_TYPE_ERROR");
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
            }
        }
        return bl;
    }

    private void enableValidateButton() {
        boolean bl = false;
        if (this.mDataSourceItem.getDataType() != ContextDataItem.DataType.MAP) {
            bl = true;
        }
        if (bl) {
            if (this.mByCoordinateRadio.isSelected()) {
                bl = false;
            } else if (this.mByValueRadio.isSelected()) {
                bl = true;
            }
        }
        if (bl && this.mByValueRadio.isSelected()) {
            bl = this.mDataKeyList.getModel().getSize() > 0 && this.mDataKeyList.getModel().getSize() == this.mMapKeyList.getModel().getSize();
        }
        this.mValidateButton.setEnabled(false);
    }

    private void saveSelections() {
        if (this.mByCoordinateRadio.isSelected()) {
            this.mDataSourceItem.setAssocType(ContextDataItem.AssocType.COORDINATE);
            this.mDataSourceItem.setCoordinateXVar((String)this.mXCombo.getSelectedItem());
            this.mDataSourceItem.setCoordinateYVar((String)this.mYCombo.getSelectedItem());
            this.mDataSourceItem.setSelectedDataKeys(new Vector<String>());
            this.mDataSourceItem.setSelectedMapKeys(new Vector<String>());
            if (!this.mIsGSAR && this.mZCombo.getSelectedItem() != null && this.mZCombo.getSelectedItem().toString().length() > 0) {
                this.mDataSourceItem.setCoordinateZVar((String)this.mZCombo.getSelectedItem());
            }
        } else if (this.mByValueRadio.isSelected()) {
            this.mDataSourceItem.setAssocType(ContextDataItem.AssocType.KEYS);
            this.mDataSourceItem.setMapAssocId(this.mMapCombo.getSelectedItem().toString());
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            VarListModel varListModel = this.mDataKeyList.getModel();
            for (int i = 0; i < varListModel.getSize(); ++i) {
                vector2.add(varListModel.getElementAt(i).getName());
            }
            if (this.mMapKeyList.isEnabled()) {
                VarListModel varListModel2 = this.mMapKeyList.getModel();
                for (int i = 0; i < varListModel2.getSize(); ++i) {
                    vector.add(varListModel2.getElementAt(i).getName());
                }
            }
            if (vector.size() > 0 && vector2.size() > 0) {
                this.mDataSourceItem.setSelectedDataKeys(vector2);
                this.mDataSourceItem.setSelectedMapKeys(vector);
            } else if (vector.size() == 0) {
                this.mDataSourceItem.setKeyList(vector2);
            }
            this.mDataSourceItem.setCoordinateXVar("");
            this.mDataSourceItem.setCoordinateYVar("");
        }
    }

    String getDisplayProjection() {
        return this.mDisplayProjection;
    }

    private boolean runSetCoordinateSub() {
        boolean bl = true;
        if (this.mMapFiles.size() > 0 && this.mByCoordinateRadio.isSelected()) {
            SelectCoordinateSubDlg selectCoordinateSubDlg = new SelectCoordinateSubDlg(this.mParentDlg, true);
            selectCoordinateSubDlg.setVisible(true);
            if (!selectCoordinateSubDlg.continuePressed()) {
                bl = false;
                return bl;
            }
            int n = selectCoordinateSubDlg.getSelectedRadioIndex();
            String[] stringArray = new String[1];
            selectCoordinateSubDlg.getSelctedDisplayProjection(stringArray);
            this.mDisplayProjection = stringArray[0];
            switch (n) {
                case 0: {
                    this.mDataSourceItem.setCoorSystem(ContextDataItem.CoordinateSys.GEO);
                    break;
                }
                case 1: {
                    this.mDataSourceItem.setCoorSystem(ContextDataItem.CoordinateSys.CARTESIAN);
                    break;
                }
                case 2: {
                    this.mDataSourceItem.setCoorSystem(ContextDataItem.CoordinateSys.WKID);
                    this.mDataSourceItem.setWKID(selectCoordinateSubDlg.getWKID());
                    break;
                }
                case 3: {
                    this.mDataSourceItem.setCoorSystem(ContextDataItem.CoordinateSys.PROJECTION);
                    this.mDataSourceItem.setProjection(selectCoordinateSubDlg.getCSName());
                }
            }
        }
        return bl;
    }

    class KeyTableModel
    extends AbstractTableModel {
        private TargetVariableList mDataKeyList;
        private TargetVariableList mMapKeyList;
        private String[] mColumnNames;

        public KeyTableModel(String[] stringArray, TargetVariableList targetVariableList, TargetVariableList targetVariableList2) {
            this.mDataKeyList = targetVariableList;
            this.mMapKeyList = targetVariableList2;
            this.mColumnNames = stringArray;
        }

        @Override
        public int getRowCount() {
            int n;
            int n2 = this.mDataKeyList.getModel().getSize();
            if (n2 >= (n = this.mDataKeyList.getModel().getSize())) {
                return n2;
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                this.mDataKeyList.getModel().getElementAt(n);
            } else if (n2 == 1) {
                this.mMapKeyList.getModel().getElementAt(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof ISpssVariable) {
                if (n2 == 0) {
                    this.mDataKeyList.getModel().insertElementAt((ISpssVariable)object, n);
                } else if (n2 == 1) {
                    this.mMapKeyList.getModel().insertElementAt((ISpssVariable)object, n);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataMapAssociationSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataMapAssociationSubDlg.this.processCancel();
        }
    }

    class ValidateAction
    extends AbstractAction {
        ValidateAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_VALIDATE"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_VALIDATE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (DataMapAssociationSubDlg.this.isSelectedFieldTypeSame() && (bl = this.callBackend()) && DataMapAssociationSubDlg.this.mValidationContinuePressed) {
                DataMapAssociationSubDlg.this.mIsContinuePressed = true;
                DataMapAssociationSubDlg.this.saveSelections();
                DataMapAssociationSubDlg.this.dispose();
            }
        }

        private boolean callBackend() {
            Object object;
            String string;
            boolean bl = true;
            DataMapAssociationSubDlg.this.mValidationContinuePressed = false;
            String string2 = ((STEMWizardDlg)((Object)DataMapAssociationSubDlg.this.getParent())).getGeoRelationPage().getShpFilePath(DataMapAssociationSubDlg.this.mMapCombo.getSelectedItem().toString());
            Vector<String> vector = new Vector<String>();
            String string3 = "";
            VarListModel varListModel = DataMapAssociationSubDlg.this.mMapKeyList.getModel();
            for (int i = 0; i < varListModel.getSize(); ++i) {
                string = varListModel.getElementAt(i).getName();
                vector.add(string);
                string3 = string3 + string + ";";
            }
            LocallyUniqueId locallyUniqueId = null;
            if (DataMapAssociationSubDlg.this.mDataSourceItem.getDataType() == ContextDataItem.DataType.DATASET) {
                locallyUniqueId = DataMapAssociationSubDlg.this.mDataSourceItem.getDatasetUID();
            }
            string = DataMapAssociationSubDlg.this.mDataSourceItem.getDataSourceFullName();
            Vector<String> vector2 = new Vector<String>();
            String string4 = "";
            VarListModel varListModel2 = DataMapAssociationSubDlg.this.mDataKeyList.getModel();
            for (int i = 0; i < varListModel2.getSize(); ++i) {
                object = varListModel2.getElementAt(i).getName();
                vector2.add((String)object);
                string4 = string4 + (String)object + ";";
            }
            Vector<Vector<String>> vector3 = new Vector<Vector<String>>();
            object = new Vector();
            Vector vector4 = new Vector();
            ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().matchShapeKeys(string2, vector, locallyUniqueId, string, vector2, 2001, vector3, (Vector)object, vector4);
            if (aSMapsError.getHasError()) {
                String string5 = aSMapsError.getMessage();
                String string6 = aSMapsError.getExplain();
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)DataMapAssociationSubDlg.this), string5 + " " + string6, VersionInfo.getAppVersionString());
                bl = false;
            } else {
                Object object2;
                int n;
                if (vector3.size() > 100 && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)DataMapAssociationSubDlg.this), (String)(object2 = DataMapAssociationSubDlg.this.getResString("IDS_STEM_VALIDATE_KEYS_TOO_MANY_UNMATCHED")), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
                    return false;
                }
                object2 = new File(string2);
                DataMapAssociationSubDlg.this.mDataSourceItem.setUnMatchedMapValues(vector3);
                DataMapAssociationSubDlg.this.mDataSourceItem.setUnMatchedDataValues((Vector<Vector<String>>)object);
                DataMapAssociationSubDlg.this.mDataSourceItem.setNumMatchedValues((Integer)vector4.get(0));
                ValidateKeysSubDlg validateKeysSubDlg = new ValidateKeysSubDlg((BaseWizardDialog)((Object)DataMapAssociationSubDlg.this.getParent()), DataMapAssociationSubDlg.this.mDataSourceItem, (Integer)vector4.get(0), DataMapAssociationSubDlg.this.mDataSourceItem.getSourceId(), string4, ((File)object2).getName(), string3);
                validateKeysSubDlg.setVisible(true);
                DataMapAssociationSubDlg.this.mValidationContinuePressed = validateKeysSubDlg.continuePressed();
            }
            return bl;
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DataMapAssociationSubDlg.this.checkControls()) {
                DataMapAssociationSubDlg.this.mIsContinuePressed = true;
                DataMapAssociationSubDlg.this.saveSelections();
                if (DataMapAssociationSubDlg.this.runSetCoordinateSub()) {
                    DataMapAssociationSubDlg.this.dispose();
                }
            }
        }
    }
}

