/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoordinateSystemUtil {
    private static CoordinateSystemUtil INSTANCE;
    private List<CoordinateSystem> all = new ArrayList<CoordinateSystem>();
    private List<CoordinateSystem> pcs = new ArrayList<CoordinateSystem>();
    private Map<Integer, CoordinateSystem> wkidMap = null;
    private Map<String, CoordinateSystem> nameMap = null;

    private CoordinateSystemUtil() {
        CoordinateSystemUtil.addPCS(this.pcs);
        this.pcs.addAll(this.all);
        CoordinateSystemUtil.addGCS(this.all);
    }

    public static CoordinateSystemUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CoordinateSystemUtil();
        }
        return INSTANCE;
    }

    public CoordinateSystem lookupByWKID(int n) {
        if (this.wkidMap == null) {
            this.wkidMap = new HashMap<Integer, CoordinateSystem>();
            for (CoordinateSystem coordinateSystem : this.all) {
                this.wkidMap.put(coordinateSystem.getWKID(), coordinateSystem);
            }
            for (CoordinateSystem coordinateSystem : this.pcs) {
                this.wkidMap.put(coordinateSystem.getWKID(), coordinateSystem);
            }
        }
        return this.wkidMap.get(new Integer(n));
    }

    public CoordinateSystem lookupByName(String string) {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, CoordinateSystem>();
            for (CoordinateSystem coordinateSystem : this.all) {
                this.nameMap.put(coordinateSystem.getName(), coordinateSystem);
            }
            for (CoordinateSystem coordinateSystem : this.pcs) {
                this.nameMap.put(coordinateSystem.getName(), coordinateSystem);
            }
        }
        return this.nameMap.get(string);
    }

    public List<CoordinateSystem> getAllCoordinateSystems() {
        return this.all;
    }

    public List<CoordinateSystem> getProjectedCoordinateSystems() {
        return this.pcs;
    }

    private static void addGCS(List<CoordinateSystem> list) {
        GCS_1.add(list);
    }

    private static void addPCS(List<CoordinateSystem> list) {
        PCS_1.add(list);
        PCS_2.add(list);
        PCS_3.add(list);
        PCS_4.add(list);
        PCS_5.add(list);
    }

    private static class PCS_5 {
        private PCS_5() {
        }

        static void add(List<CoordinateSystem> list) {
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103003, "NAD_1983_2011_StatePlane_California_I_FIPS_0401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103004, "NAD_1983_2011_StatePlane_California_II_FIPS_0402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103005, "NAD_1983_2011_StatePlane_California_III_FIPS_0403_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103006, "NAD_1983_2011_StatePlane_California_IV_FIPS_0404_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103007, "NAD_1983_2011_StatePlane_California_V_FIPS_0405_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103008, "NAD_1983_2011_StatePlane_California_VI_FIPS_0406_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103009, "NAD_1983_2011_StatePlane_Colorado_North_FIPS_0501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103010, "NAD_1983_2011_StatePlane_Colorado_Central_FIPS_0502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103011, "NAD_1983_2011_StatePlane_Colorado_South_FIPS_0503", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103012, "NAD_1983_2011_StatePlane_Colorado_North_FIPS_0501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103013, "NAD_1983_2011_StatePlane_Colorado_Central_FIPS_0502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103014, "NAD_1983_2011_StatePlane_Colorado_South_FIPS_0503_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103015, "NAD_1983_2011_StatePlane_Connecticut_FIPS_0600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103016, "NAD_1983_2011_StatePlane_Connecticut_FIPS_0600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103017, "NAD_1983_2011_StatePlane_Delaware_FIPS_0700", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103018, "NAD_1983_2011_StatePlane_Delaware_FIPS_0700_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103019, "NAD_1983_2011_StatePlane_Florida_East_FIPS_0901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103020, "NAD_1983_2011_StatePlane_Florida_West_FIPS_0902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103021, "NAD_1983_2011_StatePlane_Florida_North_FIPS_0903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103022, "NAD_1983_2011_StatePlane_Florida_East_FIPS_0901_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103023, "NAD_1983_2011_StatePlane_Florida_West_FIPS_0902_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103024, "NAD_1983_2011_StatePlane_Florida_North_FIPS_0903_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103025, "NAD_1983_2011_StatePlane_Georgia_East_FIPS_1001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103026, "NAD_1983_2011_StatePlane_Georgia_West_FIPS_1002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103027, "NAD_1983_2011_StatePlane_Georgia_East_FIPS_1001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103028, "NAD_1983_2011_StatePlane_Georgia_West_FIPS_1002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103029, "NAD_1983_2011_StatePlane_Idaho_East_FIPS_1101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103030, "NAD_1983_2011_StatePlane_Idaho_Central_FIPS_1102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103031, "NAD_1983_2011_StatePlane_Idaho_West_FIPS_1103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103032, "NAD_1983_2011_StatePlane_Idaho_East_FIPS_1101_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103033, "NAD_1983_2011_StatePlane_Idaho_Central_FIPS_1102_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103034, "NAD_1983_2011_StatePlane_Idaho_West_FIPS_1103_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103035, "NAD_1983_2011_StatePlane_Illinois_East_FIPS_1201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103036, "NAD_1983_2011_StatePlane_Illinois_West_FIPS_1202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103037, "NAD_1983_2011_StatePlane_Illinois_East_FIPS_1201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103038, "NAD_1983_2011_StatePlane_Illinois_West_FIPS_1202_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103039, "NAD_1983_2011_StatePlane_Indiana_East_FIPS_1301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103040, "NAD_1983_2011_StatePlane_Indiana_West_FIPS_1302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103041, "NAD_1983_2011_StatePlane_Indiana_East_FIPS_1301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103042, "NAD_1983_2011_StatePlane_Indiana_West_FIPS_1302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103043, "NAD_1983_2011_StatePlane_Iowa_North_FIPS_1401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103044, "NAD_1983_2011_StatePlane_Iowa_South_FIPS_1402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103045, "NAD_1983_2011_StatePlane_Iowa_North_FIPS_1401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103046, "NAD_1983_2011_StatePlane_Iowa_South_FIPS_1402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103047, "NAD_1983_2011_StatePlane_Kansas_North_FIPS_1501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103048, "NAD_1983_2011_StatePlane_Kansas_South_FIPS_1502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103049, "NAD_1983_2011_StatePlane_Kansas_North_FIPS_1501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103050, "NAD_1983_2011_StatePlane_Kansas_South_FIPS_1502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103051, "NAD_1983_2011_StatePlane_Kentucky_North_FIPS_1601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103052, "NAD_1983_2011_StatePlane_Kentucky_North_FIPS_1601_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103053, "NAD_1983_2011_StatePlane_Kentucky_FIPS_1600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103054, "NAD_1983_2011_StatePlane_Kentucky_FIPS_1600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103055, "NAD_1983_2011_StatePlane_Kentucky_South_FIPS_1602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103056, "NAD_1983_2011_StatePlane_Kentucky_South_FIPS_1602_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103057, "NAD_1983_2011_StatePlane_Louisiana_North_FIPS_1701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103058, "NAD_1983_2011_StatePlane_Louisiana_South_FIPS_1702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103059, "NAD_1983_2011_StatePlane_Louisiana_North_FIPS_1701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103060, "NAD_1983_2011_StatePlane_Louisiana_South_FIPS_1702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103061, "NAD_1983_2011_StatePlane_Maine_East_FIPS_1801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103062, "NAD_1983_2011_StatePlane_Maine_West_FIPS_1802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103063, "NAD_1983_2011_StatePlane_Maine_East_FIPS_1801_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103064, "NAD_1983_2011_StatePlane_Maine_West_FIPS_1802_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103065, "NAD_1983_2011_Maine_2000_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103066, "NAD_1983_2011_Maine_2000_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103067, "NAD_1983_2011_Maine_2000_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103068, "NAD_1983_2011_StatePlane_Maryland_FIPS_1900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103069, "NAD_1983_2011_StatePlane_Maryland_FIPS_1900_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103070, "NAD_1983_2011_StatePlane_Massachusetts_Mainland_FIPS_2001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103071, "NAD_1983_2011_StatePlane_Massachusetts_Island_FIPS_2002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103072, "NAD_1983_2011_StatePlane_Massachusetts_Mnld_FIPS_2001_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103073, "NAD_1983_2011_StatePlane_Massachusetts_Isl_FIPS_2002_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103074, "NAD_1983_2011_StatePlane_Michigan_North_FIPS_2111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103075, "NAD_1983_2011_StatePlane_Michigan_Central_FIPS_2112", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103076, "NAD_1983_2011_StatePlane_Michigan_South_FIPS_2113", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103077, "NAD_1983_2011_StatePlane_Michigan_North_FIPS_2111_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103078, "NAD_1983_2011_StatePlane_Michigan_Central_FIPS_2112_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103079, "NAD_1983_2011_StatePlane_Michigan_South_FIPS_2113_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103080, "NAD_1983_2011_StatePlane_Minnesota_North_FIPS_2201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103081, "NAD_1983_2011_StatePlane_Minnesota_Central_FIPS_2202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103082, "NAD_1983_2011_StatePlane_Minnesota_South_FIPS_2203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103083, "NAD_1983_2011_StatePlane_Minnesota_North_FIPS_2201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103084, "NAD_1983_2011_StatePlane_Minnesota_Central_FIPS_2202_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103085, "NAD_1983_2011_StatePlane_Minnesota_South_FIPS_2203_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103086, "NAD_1983_2011_StatePlane_Mississippi_East_FIPS_2301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103087, "NAD_1983_2011_StatePlane_Mississippi_West_FIPS_2302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103088, "NAD_1983_2011_StatePlane_Mississippi_East_FIPS_2301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103089, "NAD_1983_2011_StatePlane_Mississippi_West_FIPS_2302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103090, "NAD_1983_2011_StatePlane_Missouri_East_FIPS_2401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103091, "NAD_1983_2011_StatePlane_Missouri_Central_FIPS_2402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103092, "NAD_1983_2011_StatePlane_Missouri_West_FIPS_2403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103093, "NAD_1983_2011_StatePlane_Montana_FIPS_2500", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103094, "NAD_1983_2011_StatePlane_Montana_FIPS_2500_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103095, "NAD_1983_2011_StatePlane_Nebraska_FIPS_2600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103096, "NAD_1983_2011_StatePlane_Nebraska_FIPS_2600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103097, "NAD_1983_2011_StatePlane_Nevada_East_FIPS_2701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103098, "NAD_1983_2011_StatePlane_Nevada_Central_FIPS_2702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103099, "NAD_1983_2011_StatePlane_Nevada_West_FIPS_2703", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103100, "NAD_1983_2011_StatePlane_Nevada_East_FIPS_2701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103101, "NAD_1983_2011_StatePlane_Nevada_Central_FIPS_2702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103102, "NAD_1983_2011_StatePlane_Nevada_West_FIPS_2703_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103103, "NAD_1983_2011_StatePlane_New_Hampshire_FIPS_2800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103104, "NAD_1983_2011_StatePlane_New_Hampshire_FIPS_2800_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103105, "NAD_1983_2011_StatePlane_New_Jersey_FIPS_2900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103106, "NAD_1983_2011_StatePlane_New_Jersey_FIPS_2900_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103107, "NAD_1983_2011_StatePlane_New_Mexico_East_FIPS_3001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103108, "NAD_1983_2011_StatePlane_New_Mexico_Central_FIPS_3002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103109, "NAD_1983_2011_StatePlane_New_Mexico_West_FIPS_3003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103110, "NAD_1983_2011_StatePlane_New_Mexico_East_FIPS_3001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103111, "NAD_1983_2011_StatePlane_New_Mexico_Central_FIPS_3002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103112, "NAD_1983_2011_StatePlane_New_Mexico_West_FIPS_3003_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103113, "NAD_1983_2011_StatePlane_New_York_East_FIPS_3101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103114, "NAD_1983_2011_StatePlane_New_York_Central_FIPS_3102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103115, "NAD_1983_2011_StatePlane_New_York_West_FIPS_3103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103116, "NAD_1983_2011_StatePlane_New_York_Long_Island_FIPS_3104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103117, "NAD_1983_2011_StatePlane_New_York_East_FIPS_3101_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103118, "NAD_1983_2011_StatePlane_New_York_Central_FIPS_3102_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103119, "NAD_1983_2011_StatePlane_New_York_West_FIPS_3103_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103120, "NAD_1983_2011_StatePlane_New_York_Long_Isl_FIPS_3104_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103121, "NAD_1983_2011_StatePlane_North_Carolina_FIPS_3200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103122, "NAD_1983_2011_StatePlane_North_Carolina_FIPS_3200_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103123, "NAD_1983_2011_StatePlane_North_Dakota_North_FIPS_3301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103124, "NAD_1983_2011_StatePlane_North_Dakota_South_FIPS_3302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103125, "NAD_1983_2011_StatePlane_North_Dakota_North_FIPS_3301_FtI", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103126, "NAD_1983_2011_StatePlane_North_Dakota_South_FIPS_3302_FtI", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103127, "NAD_1983_2011_StatePlane_Ohio_North_FIPS_3401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103128, "NAD_1983_2011_StatePlane_Ohio_South_FIPS_3402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103129, "NAD_1983_2011_StatePlane_Ohio_North_FIPS_3401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103130, "NAD_1983_2011_StatePlane_Ohio_South_FIPS_3402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103131, "NAD_1983_2011_StatePlane_Oklahoma_North_FIPS_3501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103132, "NAD_1983_2011_StatePlane_Oklahoma_South_FIPS_3502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103133, "NAD_1983_2011_StatePlane_Oklahoma_North_FIPS_3501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103134, "NAD_1983_2011_StatePlane_Oklahoma_South_FIPS_3502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103135, "NAD_1983_2011_StatePlane_Oregon_North_FIPS_3601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103136, "NAD_1983_2011_StatePlane_Oregon_South_FIPS_3602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103137, "NAD_1983_2011_StatePlane_Oregon_North_FIPS_3601_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103138, "NAD_1983_2011_StatePlane_Oregon_South_FIPS_3602_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103139, "NAD_1983_2011_StatePlane_Pennsylvania_North_FIPS_3701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103140, "NAD_1983_2011_StatePlane_Pennsylvania_North_FIPS_3701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103141, "NAD_1983_2011_StatePlane_Pennsylvania_South_FIPS_3702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103142, "NAD_1983_2011_StatePlane_Pennsylvania_South_FIPS_3702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103143, "NAD_1983_2011_StatePlane_Rhode_Island_FIPS_3800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103144, "NAD_1983_2011_StatePlane_Rhode_Island_FIPS_3800_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103145, "NAD_1983_2011_StatePlane_South_Carolina_FIPS_3900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103146, "NAD_1983_2011_StatePlane_South_Carolina_FIPS_3900_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103147, "NAD_1983_2011_StatePlane_South_Dakota_North_FIPS_4001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103148, "NAD_1983_2011_StatePlane_South_Dakota_South_FIPS_4002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103149, "NAD_1983_2011_StatePlane_South_Dakota_North_FIPS_4001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103150, "NAD_1983_2011_StatePlane_South_Dakota_South_FIPS_4002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103151, "NAD_1983_2011_StatePlane_Tennessee_FIPS_4100", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103152, "NAD_1983_2011_StatePlane_Tennessee_FIPS_4100_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103153, "NAD_1983_2011_StatePlane_Texas_North_FIPS_4201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103154, "NAD_1983_2011_StatePlane_Texas_North_Central_FIPS_4202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103155, "NAD_1983_2011_StatePlane_Texas_Central_FIPS_4203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103156, "NAD_1983_2011_StatePlane_Texas_South_Central_FIPS_4204", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103157, "NAD_1983_2011_StatePlane_Texas_South_FIPS_4205", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103158, "NAD_1983_2011_StatePlane_Texas_North_FIPS_4201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103159, "NAD_1983_2011_StatePlane_Texas_North_Central_FIPS_4202_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103160, "NAD_1983_2011_StatePlane_Texas_Central_FIPS_4203_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103161, "NAD_1983_2011_StatePlane_Texas_South_Central_FIPS_4204_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103162, "NAD_1983_2011_StatePlane_Texas_South_FIPS_4205_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103163, "NAD_1983_2011_StatePlane_Utah_North_FIPS_4301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103164, "NAD_1983_2011_StatePlane_Utah_Central_FIPS_4302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103165, "NAD_1983_2011_StatePlane_Utah_South_FIPS_4303", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103166, "NAD_1983_2011_StatePlane_Utah_North_FIPS_4301_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103167, "NAD_1983_2011_StatePlane_Utah_Central_FIPS_4302_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103168, "NAD_1983_2011_StatePlane_Utah_South_FIPS_4303_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103169, "NAD_1983_2011_StatePlane_Utah_North_FIPS_4301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103170, "NAD_1983_2011_StatePlane_Utah_Central_FIPS_4302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103171, "NAD_1983_2011_StatePlane_Utah_South_FIPS_4303_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103172, "NAD_1983_2011_StatePlane_Vermont_FIPS_4400", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103173, "NAD_1983_2011_StatePlane_Vermont_FIPS_4400_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103174, "NAD_1983_2011_StatePlane_Virginia_North_FIPS_4501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103175, "NAD_1983_2011_StatePlane_Virginia_South_FIPS_4502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103176, "NAD_1983_2011_StatePlane_Virginia_North_FIPS_4501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103177, "NAD_1983_2011_StatePlane_Virginia_South_FIPS_4502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103178, "NAD_1983_2011_StatePlane_Washington_North_FIPS_4601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103179, "NAD_1983_2011_StatePlane_Washington_South_FIPS_4602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103180, "NAD_1983_2011_StatePlane_Washington_North_FIPS_4601_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103181, "NAD_1983_2011_StatePlane_Washington_South_FIPS_4602_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103182, "NAD_1983_2011_StatePlane_West_Virginia_North_FIPS_4701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103183, "NAD_1983_2011_StatePlane_West_Virginia_South_FIPS_4702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103184, "NAD_1983_2011_StatePlane_West_Virginia_North_FIPS_4701_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103185, "NAD_1983_2011_StatePlane_West_Virginia_South_FIPS_4702_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103186, "NAD_1983_2011_StatePlane_Wisconsin_North_FIPS_4801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103187, "NAD_1983_2011_StatePlane_Wisconsin_Central_FIPS_4802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103188, "NAD_1983_2011_StatePlane_Wisconsin_South_FIPS_4803", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103189, "NAD_1983_2011_StatePlane_Wisconsin_North_FIPS_4801_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103190, "NAD_1983_2011_StatePlane_Wisconsin_Central_FIPS_4802_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103191, "NAD_1983_2011_StatePlane_Wisconsin_South_FIPS_4803_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103192, "NAD_1983_2011_StatePlane_Wyoming_East_FIPS_4901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103193, "NAD_1983_2011_StatePlane_Wyoming_East_Central_FIPS_4902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103194, "NAD_1983_2011_StatePlane_Wyoming_West_Central_FIPS_4903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103195, "NAD_1983_2011_StatePlane_Wyoming_West_FIPS_4904", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103196, "NAD_1983_2011_StatePlane_Wyoming_East_FIPS_4901_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103197, "NAD_1983_2011_StatePlane_Wyoming_E_Central_FIPS_4902_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103198, "NAD_1983_2011_StatePlane_Wyoming_W_Central_FIPS_4903_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103199, "NAD_1983_2011_StatePlane_Wyoming_West_FIPS_4904_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103200, "NAD_1983_2011_StatePlane_Puerto_Rico_Virgin_Isls_FIPS_5200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103220, "NAD_1983_CORS96_StatePlane_Alabama_East_FIPS_0101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103221, "NAD_1983_CORS96_StatePlane_Alabama_West_FIPS_0102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103222, "NAD_1983_CORS96_StatePlane_Arizona_East_FIPS_0201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103223, "NAD_1983_CORS96_StatePlane_Arizona_Central_FIPS_0202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103224, "NAD_1983_CORS96_StatePlane_Arizona_West_FIPS_0203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103225, "NAD_1983_CORS96_StatePlane_Arizona_East_FIPS_0201_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103226, "NAD_1983_CORS96_StatePlane_Arizona_Central_FIPS_0202_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103227, "NAD_1983_CORS96_StatePlane_Arizona_West_FIPS_0203_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103228, "NAD_1983_CORS96_StatePlane_Arkansas_North_FIPS_0301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103229, "NAD_1983_CORS96_StatePlane_Arkansas_South_FIPS_0302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103230, "NAD_1983_CORS96_StatePlane_Arkansas_North_FIPS_0301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103231, "NAD_1983_CORS96_StatePlane_Arkansas_South_FIPS_0302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103232, "NAD_1983_CORS96_StatePlane_California_I_FIPS_0401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103233, "NAD_1983_CORS96_StatePlane_California_II_FIPS_0402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103234, "NAD_1983_CORS96_StatePlane_California_III_FIPS_0403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103235, "NAD_1983_CORS96_StatePlane_California_IV_FIPS_0404", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103236, "NAD_1983_CORS96_StatePlane_California_V_FIPS_0405", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103237, "NAD_1983_CORS96_StatePlane_California_VI_FIPS_0406", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103238, "NAD_1983_CORS96_StatePlane_California_I_FIPS_0401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103239, "NAD_1983_CORS96_StatePlane_California_II_FIPS_0402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103240, "NAD_1983_CORS96_StatePlane_California_III_FIPS_0403_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103241, "NAD_1983_CORS96_StatePlane_California_IV_FIPS_0404_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103242, "NAD_1983_CORS96_StatePlane_California_V_FIPS_0405_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103243, "NAD_1983_CORS96_StatePlane_California_VI_FIPS_0406_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103244, "NAD_1983_CORS96_StatePlane_Colorado_North_FIPS_0501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103245, "NAD_1983_CORS96_StatePlane_Colorado_Central_FIPS_0502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103246, "NAD_1983_CORS96_StatePlane_Colorado_South_FIPS_0503", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103247, "NAD_1983_CORS96_StatePlane_Colorado_North_FIPS_0501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103248, "NAD_1983_CORS96_StatePlane_Colorado_Central_FIPS_0502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103249, "NAD_1983_CORS96_StatePlane_Colorado_South_FIPS_0503_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103250, "NAD_1983_CORS96_StatePlane_Connecticut_FIPS_0600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103251, "NAD_1983_CORS96_StatePlane_Connecticut_FIPS_0600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103252, "NAD_1983_CORS96_StatePlane_Delaware_FIPS_0700", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103253, "NAD_1983_CORS96_StatePlane_Delaware_FIPS_0700_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103254, "NAD_1983_CORS96_StatePlane_Florida_East_FIPS_0901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103255, "NAD_1983_CORS96_StatePlane_Florida_West_FIPS_0902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103256, "NAD_1983_CORS96_StatePlane_Florida_North_FIPS_0903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103257, "NAD_1983_CORS96_StatePlane_Florida_East_FIPS_0901_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103258, "NAD_1983_CORS96_StatePlane_Florida_West_FIPS_0902_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103259, "NAD_1983_CORS96_StatePlane_Florida_North_FIPS_0903_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103260, "NAD_1983_CORS96_StatePlane_Georgia_East_FIPS_1001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103261, "NAD_1983_CORS96_StatePlane_Georgia_West_FIPS_1002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103262, "NAD_1983_CORS96_StatePlane_Georgia_East_FIPS_1001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103263, "NAD_1983_CORS96_StatePlane_Georgia_West_FIPS_1002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103264, "NAD_1983_CORS96_StatePlane_Idaho_East_FIPS_1101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103265, "NAD_1983_CORS96_StatePlane_Idaho_Central_FIPS_1102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103266, "NAD_1983_CORS96_StatePlane_Idaho_West_FIPS_1103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103267, "NAD_1983_CORS96_StatePlane_Idaho_East_FIPS_1101_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103268, "NAD_1983_CORS96_StatePlane_Idaho_Central_FIPS_1102_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103269, "NAD_1983_CORS96_StatePlane_Idaho_West_FIPS_1103_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103270, "NAD_1983_CORS96_StatePlane_Illinois_East_FIPS_1201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103271, "NAD_1983_CORS96_StatePlane_Illinois_West_FIPS_1202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103272, "NAD_1983_CORS96_StatePlane_Illinois_East_FIPS_1201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103273, "NAD_1983_CORS96_StatePlane_Illinois_West_FIPS_1202_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103274, "NAD_1983_CORS96_StatePlane_Indiana_East_FIPS_1301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103275, "NAD_1983_CORS96_StatePlane_Indiana_West_FIPS_1302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103276, "NAD_1983_CORS96_StatePlane_Indiana_East_FIPS_1301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103277, "NAD_1983_CORS96_StatePlane_Indiana_West_FIPS_1302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103278, "NAD_1983_CORS96_StatePlane_Iowa_North_FIPS_1401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103279, "NAD_1983_CORS96_StatePlane_Iowa_South_FIPS_1402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103280, "NAD_1983_CORS96_StatePlane_Iowa_North_FIPS_1401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103281, "NAD_1983_CORS96_StatePlane_Iowa_South_FIPS_1402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103282, "NAD_1983_CORS96_StatePlane_Kansas_North_FIPS_1501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103283, "NAD_1983_CORS96_StatePlane_Kansas_South_FIPS_1502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103284, "NAD_1983_CORS96_StatePlane_Kansas_North_FIPS_1501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103285, "NAD_1983_CORS96_StatePlane_Kansas_South_FIPS_1502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103286, "NAD_1983_CORS96_StatePlane_Kentucky_North_FIPS_1601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103287, "NAD_1983_CORS96_StatePlane_Kentucky_North_FIPS_1601_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103288, "NAD_1983_CORS96_StatePlane_Kentucky_FIPS_1600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103289, "NAD_1983_CORS96_StatePlane_Kentucky_FIPS_1600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103290, "NAD_1983_CORS96_StatePlane_Kentucky_South_FIPS_1602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103291, "NAD_1983_CORS96_StatePlane_Kentucky_South_FIPS_1602_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103292, "NAD_1983_CORS96_StatePlane_Louisiana_North_FIPS_1701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103293, "NAD_1983_CORS96_StatePlane_Louisiana_South_FIPS_1702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103294, "NAD_1983_CORS96_StatePlane_Louisiana_North_FIPS_1701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103295, "NAD_1983_CORS96_StatePlane_Louisiana_South_FIPS_1702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103296, "NAD_1983_CORS96_StatePlane_Maine_East_FIPS_1801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103297, "NAD_1983_CORS96_StatePlane_Maine_West_FIPS_1802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103298, "NAD_1983_CORS96_StatePlane_Maine_East_FIPS_1801_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103299, "NAD_1983_CORS96_StatePlane_Maine_West_FIPS_1802_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103300, "NAD_1983_HARN_WISCRS_Adams_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103301, "NAD_1983_HARN_WISCRS_Ashland_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103302, "NAD_1983_HARN_WISCRS_Barron_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103303, "NAD_1983_HARN_WISCRS_Bayfield_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103304, "NAD_1983_HARN_WISCRS_Brown_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103305, "NAD_1983_HARN_WISCRS_Buffalo_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103306, "NAD_1983_HARN_WISCRS_Burnett_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103307, "NAD_1983_HARN_WISCRS_Calumet_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103308, "NAD_1983_HARN_WISCRS_Chippewa_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103309, "NAD_1983_HARN_WISCRS_Clark_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103310, "NAD_1983_HARN_WISCRS_Columbia_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103311, "NAD_1983_HARN_WISCRS_Crawford_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103312, "NAD_1983_HARN_WISCRS_Dane_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103313, "NAD_1983_HARN_WISCRS_Dodge_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103314, "NAD_1983_HARN_WISCRS_Door_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103315, "NAD_1983_HARN_WISCRS_Douglas_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103316, "NAD_1983_HARN_WISCRS_Dunn_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103317, "NAD_1983_HARN_WISCRS_EauClaire_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103318, "NAD_1983_HARN_WISCRS_Florence_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103319, "NAD_1983_HARN_WISCRS_Fond_du_Lac_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103320, "NAD_1983_HARN_WISCRS_Forest_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103321, "NAD_1983_HARN_WISCRS_Grant_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103322, "NAD_1983_HARN_WISCRS_Green_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103323, "NAD_1983_HARN_WISCRS_GreenLake_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103324, "NAD_1983_HARN_WISCRS_Iowa_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103325, "NAD_1983_HARN_WISCRS_Iron_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103326, "NAD_1983_HARN_WISCRS_Jackson_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103327, "NAD_1983_HARN_WISCRS_Jefferson_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103328, "NAD_1983_HARN_WISCRS_Juneau_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103329, "NAD_1983_HARN_WISCRS_Kenosha_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103330, "NAD_1983_HARN_WISCRS_Kewaunee_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103331, "NAD_1983_HARN_WISCRS_LaCrosse_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103332, "NAD_1983_HARN_WISCRS_Lafayette_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103333, "NAD_1983_HARN_WISCRS_Langlade_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103334, "NAD_1983_HARN_WISCRS_Lincoln_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103335, "NAD_1983_HARN_WISCRS_Manitowoc_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103336, "NAD_1983_HARN_WISCRS_Marathon_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103337, "NAD_1983_HARN_WISCRS_Marinette_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103338, "NAD_1983_HARN_WISCRS_Marquette_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103339, "NAD_1983_HARN_WISCRS_Menominee_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103340, "NAD_1983_HARN_WISCRS_Milwaukee_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103341, "NAD_1983_HARN_WISCRS_Monroe_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103342, "NAD_1983_HARN_WISCRS_Oconto_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103343, "NAD_1983_HARN_WISCRS_Oneida_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103344, "NAD_1983_HARN_WISCRS_Outagamie_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103345, "NAD_1983_HARN_WISCRS_Ozaukee_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103346, "NAD_1983_HARN_WISCRS_Pepin_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103347, "NAD_1983_HARN_WISCRS_Pierce_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103348, "NAD_1983_HARN_WISCRS_Polk_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103349, "NAD_1983_HARN_WISCRS_Portage_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103350, "NAD_1983_HARN_WISCRS_Price_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103351, "NAD_1983_HARN_WISCRS_Racine_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103352, "NAD_1983_HARN_WISCRS_Richland_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103353, "NAD_1983_HARN_WISCRS_Rock_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103354, "NAD_1983_HARN_WISCRS_Rusk_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103355, "NAD_1983_HARN_WISCRS_Sauk_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103356, "NAD_1983_HARN_WISCRS_Sawyer_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103357, "NAD_1983_HARN_WISCRS_Shawano_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103358, "NAD_1983_HARN_WISCRS_Sheboygan_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103359, "NAD_1983_HARN_WISCRS_St_Croix_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103360, "NAD_1983_HARN_WISCRS_Taylor_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103361, "NAD_1983_HARN_WISCRS_Trempealeau_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103362, "NAD_1983_HARN_WISCRS_Vernon_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103363, "NAD_1983_HARN_WISCRS_Vilas_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103364, "NAD_1983_HARN_WISCRS_Walworth_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103365, "NAD_1983_HARN_WISCRS_Washburn_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103366, "NAD_1983_HARN_WISCRS_Washington_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103367, "NAD_1983_HARN_WISCRS_Waukesha_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103368, "NAD_1983_HARN_WISCRS_Waupaca_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103369, "NAD_1983_HARN_WISCRS_Waushara_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103370, "NAD_1983_HARN_WISCRS_Winnebago_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103371, "NAD_1983_HARN_WISCRS_Wood_County_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103372, "NAD_1983_CORS96_Maine_2000_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103373, "NAD_1983_CORS96_Maine_2000_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103374, "NAD_1983_CORS96_Maine_2000_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103375, "NAD_1983_CORS96_StatePlane_Maryland_FIPS_1900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103376, "NAD_1983_CORS96_StatePlane_Maryland_FIPS_1900_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103377, "NAD_1983_CORS96_StatePlane_Massachusetts_Mainland_FIPS_2001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103378, "NAD_1983_CORS96_StatePlane_Massachusetts_Island_FIPS_2002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103379, "NAD_1983_CORS96_StatePlane_Massachusetts_Mnld_FIPS_2001_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103380, "NAD_1983_CORS96_StatePlane_Massachusetts_Isl_FIPS_2002_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103381, "NAD_1983_CORS96_StatePlane_Michigan_North_FIPS_2111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103382, "NAD_1983_CORS96_StatePlane_Michigan_Central_FIPS_2112", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103383, "NAD_1983_CORS96_StatePlane_Michigan_South_FIPS_2113", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103384, "NAD_1983_CORS96_StatePlane_Michigan_North_FIPS_2111_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103385, "NAD_1983_CORS96_StatePlane_Michigan_Central_FIPS_2112_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103386, "NAD_1983_CORS96_StatePlane_Michigan_South_FIPS_2113_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103387, "NAD_1983_CORS96_StatePlane_Minnesota_North_FIPS_2201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103388, "NAD_1983_CORS96_StatePlane_Minnesota_Central_FIPS_2202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103389, "NAD_1983_CORS96_StatePlane_Minnesota_South_FIPS_2203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103390, "NAD_1983_CORS96_StatePlane_Minnesota_North_FIPS_2201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103391, "NAD_1983_CORS96_StatePlane_Minnesota_Central_FIPS_2202_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103392, "NAD_1983_CORS96_StatePlane_Minnesota_South_FIPS_2203_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103393, "NAD_1983_CORS96_StatePlane_Mississippi_East_FIPS_2301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103394, "NAD_1983_CORS96_StatePlane_Mississippi_West_FIPS_2302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103395, "NAD_1983_CORS96_StatePlane_Mississippi_East_FIPS_2301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103396, "NAD_1983_CORS96_StatePlane_Mississippi_West_FIPS_2302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103397, "NAD_1983_CORS96_StatePlane_Missouri_East_FIPS_2401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103398, "NAD_1983_CORS96_StatePlane_Missouri_Central_FIPS_2402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103399, "NAD_1983_CORS96_StatePlane_Missouri_West_FIPS_2403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103400, "NAD_1983_HARN_WISCRS_Adams_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103401, "NAD_1983_HARN_WISCRS_Ashland_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103402, "NAD_1983_HARN_WISCRS_Barron_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103403, "NAD_1983_HARN_WISCRS_Bayfield_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103404, "NAD_1983_HARN_WISCRS_Brown_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103405, "NAD_1983_HARN_WISCRS_Buffalo_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103406, "NAD_1983_HARN_WISCRS_Burnett_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103407, "NAD_1983_HARN_WISCRS_Calumet_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103408, "NAD_1983_HARN_WISCRS_Chippewa_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103409, "NAD_1983_HARN_WISCRS_Clark_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103410, "NAD_1983_HARN_WISCRS_Columbia_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103411, "NAD_1983_HARN_WISCRS_Crawford_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103412, "NAD_1983_HARN_WISCRS_Dane_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103413, "NAD_1983_HARN_WISCRS_Dodge_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103414, "NAD_1983_HARN_WISCRS_Door_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103415, "NAD_1983_HARN_WISCRS_Douglas_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103416, "NAD_1983_HARN_WISCRS_Dunn_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103417, "NAD_1983_HARN_WISCRS_EauClaire_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103418, "NAD_1983_HARN_WISCRS_Florence_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103419, "NAD_1983_HARN_WISCRS_Fond_du_Lac_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103420, "NAD_1983_HARN_WISCRS_Forest_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103421, "NAD_1983_HARN_WISCRS_Grant_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103422, "NAD_1983_HARN_WISCRS_Green_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103423, "NAD_1983_HARN_WISCRS_GreenLake_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103424, "NAD_1983_HARN_WISCRS_Iowa_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103425, "NAD_1983_HARN_WISCRS_Iron_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103426, "NAD_1983_HARN_WISCRS_Jackson_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103427, "NAD_1983_HARN_WISCRS_Jefferson_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103428, "NAD_1983_HARN_WISCRS_Juneau_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103429, "NAD_1983_HARN_WISCRS_Kenosha_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103430, "NAD_1983_HARN_WISCRS_Kewaunee_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103431, "NAD_1983_HARN_WISCRS_LaCrosse_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103432, "NAD_1983_HARN_WISCRS_Lafayette_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103433, "NAD_1983_HARN_WISCRS_Langlade_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103434, "NAD_1983_HARN_WISCRS_Lincoln_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103435, "NAD_1983_HARN_WISCRS_Manitowoc_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103436, "NAD_1983_HARN_WISCRS_Marathon_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103437, "NAD_1983_HARN_WISCRS_Marinette_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103438, "NAD_1983_HARN_WISCRS_Marquette_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103439, "NAD_1983_HARN_WISCRS_Menominee_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103440, "NAD_1983_HARN_WISCRS_Milwaukee_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103441, "NAD_1983_HARN_WISCRS_Monroe_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103442, "NAD_1983_HARN_WISCRS_Oconto_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103443, "NAD_1983_HARN_WISCRS_Oneida_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103444, "NAD_1983_HARN_WISCRS_Outagamie_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103445, "NAD_1983_HARN_WISCRS_Ozaukee_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103446, "NAD_1983_HARN_WISCRS_Pepin_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103447, "NAD_1983_HARN_WISCRS_Pierce_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103448, "NAD_1983_HARN_WISCRS_Polk_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103449, "NAD_1983_HARN_WISCRS_Portage_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103450, "NAD_1983_HARN_WISCRS_Price_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103451, "NAD_1983_HARN_WISCRS_Racine_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103452, "NAD_1983_HARN_WISCRS_Richland_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103453, "NAD_1983_HARN_WISCRS_Rock_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103454, "NAD_1983_HARN_WISCRS_Rusk_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103455, "NAD_1983_HARN_WISCRS_Sauk_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103456, "NAD_1983_HARN_WISCRS_Sawyer_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103457, "NAD_1983_HARN_WISCRS_Shawano_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103458, "NAD_1983_HARN_WISCRS_Sheboygan_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103459, "NAD_1983_HARN_WISCRS_St_Croix_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103460, "NAD_1983_HARN_WISCRS_Taylor_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103461, "NAD_1983_HARN_WISCRS_Trempealeau_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103462, "NAD_1983_HARN_WISCRS_Vernon_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103463, "NAD_1983_HARN_WISCRS_Vilas_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103464, "NAD_1983_HARN_WISCRS_Walworth_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103465, "NAD_1983_HARN_WISCRS_Washburn_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103466, "NAD_1983_HARN_WISCRS_Washington_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103467, "NAD_1983_HARN_WISCRS_Waukesha_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103468, "NAD_1983_HARN_WISCRS_Waupaca_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103469, "NAD_1983_HARN_WISCRS_Waushara_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103470, "NAD_1983_HARN_WISCRS_Winnebago_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103471, "NAD_1983_HARN_WISCRS_Wood_County_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103472, "NAD_1983_CORS96_StatePlane_Montana_FIPS_2500", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103473, "NAD_1983_CORS96_StatePlane_Montana_FIPS_2500_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103474, "NAD_1983_CORS96_StatePlane_Nebraska_FIPS_2600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103475, "NAD_1983_CORS96_StatePlane_Nebraska_FIPS_2600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103476, "NAD_1983_CORS96_StatePlane_Nevada_East_FIPS_2701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103477, "NAD_1983_CORS96_StatePlane_Nevada_Central_FIPS_2702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103478, "NAD_1983_CORS96_StatePlane_Nevada_West_FIPS_2703", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103479, "NAD_1983_CORS96_StatePlane_Nevada_East_FIPS_2701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103480, "NAD_1983_CORS96_StatePlane_Nevada_Central_FIPS_2702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103481, "NAD_1983_CORS96_StatePlane_Nevada_West_FIPS_2703_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103482, "NAD_1983_CORS96_StatePlane_New_Hampshire_FIPS_2800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103483, "NAD_1983_CORS96_StatePlane_New_Hampshire_FIPS_2800_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103484, "NAD_1983_CORS96_StatePlane_New_Jersey_FIPS_2900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103485, "NAD_1983_CORS96_StatePlane_New_Jersey_FIPS_2900_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103486, "NAD_1983_CORS96_StatePlane_New_Mexico_East_FIPS_3001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103487, "NAD_1983_CORS96_StatePlane_New_Mexico_Central_FIPS_3002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103488, "NAD_1983_CORS96_StatePlane_New_Mexico_West_FIPS_3003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103489, "NAD_1983_CORS96_StatePlane_New_Mexico_East_FIPS_3001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103490, "NAD_1983_CORS96_StatePlane_New_Mexico_Central_FIPS_3002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103491, "NAD_1983_CORS96_StatePlane_New_Mexico_West_FIPS_3003_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103492, "NAD_1983_CORS96_StatePlane_New_York_East_FIPS_3101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103493, "NAD_1983_CORS96_StatePlane_New_York_Central_FIPS_3102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103494, "NAD_1983_CORS96_StatePlane_New_York_West_FIPS_3103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103495, "NAD_1983_CORS96_StatePlane_New_York_Long_Island_FIPS_3104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103496, "NAD_1983_CORS96_StatePlane_New_York_East_FIPS_3101_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103497, "NAD_1983_CORS96_StatePlane_New_York_Central_FIPS_3102_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103498, "NAD_1983_CORS96_StatePlane_New_York_West_FIPS_3103_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103499, "NAD_1983_CORS96_StatePlane_New_York_Long_Isl_FIPS_3104_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103500, "NAD_1983_CORS96_StatePlane_North_Carolina_FIPS_3200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103501, "NAD_1983_CORS96_StatePlane_North_Carolina_FIPS_3200_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103502, "NAD_1983_CORS96_StatePlane_North_Dakota_North_FIPS_3301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103503, "NAD_1983_CORS96_StatePlane_North_Dakota_South_FIPS_3302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103504, "NAD_1983_CORS96_StatePlane_North_Dakota_North_FIPS_3301_FtI", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103505, "NAD_1983_CORS96_StatePlane_North_Dakota_South_FIPS_3302_FtI", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103506, "NAD_1983_CORS96_StatePlane_Ohio_North_FIPS_3401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103507, "NAD_1983_CORS96_StatePlane_Ohio_South_FIPS_3402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103508, "NAD_1983_CORS96_StatePlane_Ohio_North_FIPS_3401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103509, "NAD_1983_CORS96_StatePlane_Ohio_South_FIPS_3402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103510, "NAD_1983_CORS96_StatePlane_Oklahoma_North_FIPS_3501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103511, "NAD_1983_CORS96_StatePlane_Oklahoma_South_FIPS_3502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103512, "NAD_1983_CORS96_StatePlane_Oklahoma_North_FIPS_3501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103513, "NAD_1983_CORS96_StatePlane_Oklahoma_South_FIPS_3502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103514, "NAD_1983_CORS96_StatePlane_Pennsylvania_North_FIPS_3701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103515, "NAD_1983_CORS96_StatePlane_Pennsylvania_North_FIPS_3701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103516, "NAD_1983_CORS96_StatePlane_Pennsylvania_South_FIPS_3702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103517, "NAD_1983_CORS96_StatePlane_Pennsylvania_South_FIPS_3702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103518, "NAD_1983_CORS96_StatePlane_Rhode_Island_FIPS_3800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103519, "NAD_1983_CORS96_StatePlane_Rhode_Island_FIPS_3800_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103520, "NAD_1983_CORS96_StatePlane_South_Carolina_FIPS_3900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103521, "NAD_1983_CORS96_StatePlane_South_Carolina_FIPS_3900_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103522, "NAD_1983_CORS96_StatePlane_South_Dakota_North_FIPS_4001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103523, "NAD_1983_CORS96_StatePlane_South_Dakota_South_FIPS_4002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103524, "NAD_1983_CORS96_StatePlane_South_Dakota_North_FIPS_4001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103525, "NAD_1983_CORS96_StatePlane_South_Dakota_South_FIPS_4002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103526, "NAD_1983_CORS96_StatePlane_Tennessee_FIPS_4100", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103527, "NAD_1983_CORS96_StatePlane_Tennessee_FIPS_4100_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103539, "NAD_1983_CORS96_StatePlane_Texas_North_FIPS_4201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103540, "NAD_1983_CORS96_StatePlane_Texas_North_Central_FIPS_4202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103541, "NAD_1983_CORS96_StatePlane_Texas_Central_FIPS_4203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103542, "NAD_1983_CORS96_StatePlane_Texas_South_Central_FIPS_4204", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103543, "NAD_1983_CORS96_StatePlane_Texas_South_FIPS_4205", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103544, "NAD_1983_CORS96_StatePlane_Texas_North_FIPS_4201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103545, "NAD_1983_CORS96_StatePlane_Texas_North_Central_FIPS_4202_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103546, "NAD_1983_CORS96_StatePlane_Texas_Central_FIPS_4203_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103547, "NAD_1983_CORS96_StatePlane_Texas_South_Central_FIPS_4204_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103548, "NAD_1983_CORS96_StatePlane_Texas_South_FIPS_4205_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103549, "NAD_1983_CORS96_StatePlane_Utah_North_FIPS_4301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103550, "NAD_1983_CORS96_StatePlane_Utah_Central_FIPS_4302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103551, "NAD_1983_CORS96_StatePlane_Utah_South_FIPS_4303", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103552, "NAD_1983_CORS96_StatePlane_Utah_North_FIPS_4301_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103553, "NAD_1983_CORS96_StatePlane_Utah_Central_FIPS_4302_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103554, "NAD_1983_CORS96_StatePlane_Utah_South_FIPS_4303_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103555, "NAD_1983_CORS96_StatePlane_Utah_North_FIPS_4301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103556, "NAD_1983_CORS96_StatePlane_Utah_Central_FIPS_4302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103557, "NAD_1983_CORS96_StatePlane_Utah_South_FIPS_4303_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103558, "NAD_1983_CORS96_StatePlane_Vermont_FIPS_4400", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103559, "NAD_1983_CORS96_StatePlane_Virginia_North_FIPS_4501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103560, "NAD_1983_CORS96_StatePlane_Virginia_South_FIPS_4502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103561, "NAD_1983_CORS96_StatePlane_Virginia_North_FIPS_4501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103562, "NAD_1983_CORS96_StatePlane_Virginia_South_FIPS_4502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103563, "NAD_1983_CORS96_StatePlane_Washington_North_FIPS_4601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103564, "NAD_1983_CORS96_StatePlane_Washington_South_FIPS_4602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103565, "NAD_1983_CORS96_StatePlane_Washington_North_FIPS_4601_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103566, "NAD_1983_CORS96_StatePlane_Washington_South_FIPS_4602_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103567, "NAD_1983_CORS96_StatePlane_West_Virginia_North_FIPS_4701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103568, "NAD_1983_CORS96_StatePlane_West_Virginia_South_FIPS_4702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103569, "NAD_1983_CORS96_StatePlane_West_Virginia_North_FIPS_4701_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103570, "NAD_1983_CORS96_StatePlane_West_Virginia_South_FIPS_4702_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103571, "NAD_1983_CORS96_StatePlane_Wisconsin_North_FIPS_4801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103572, "NAD_1983_CORS96_StatePlane_Wisconsin_Central_FIPS_4802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103573, "NAD_1983_CORS96_StatePlane_Wisconsin_South_FIPS_4803", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103574, "NAD_1983_CORS96_StatePlane_Wisconsin_North_FIPS_4801_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103575, "NAD_1983_CORS96_StatePlane_Wisconsin_Central_FIPS_4802_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103576, "NAD_1983_CORS96_StatePlane_Wisconsin_South_FIPS_4803_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103577, "NAD_1983_CORS96_StatePlane_Wyoming_East_FIPS_4901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103578, "NAD_1983_CORS96_StatePlane_Wyoming_East_Central_FIPS_4902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103579, "NAD_1983_CORS96_StatePlane_Wyoming_West_Central_FIPS_4903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103580, "NAD_1983_CORS96_StatePlane_Wyoming_West_FIPS_4904", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103581, "NAD_1983_CORS96_StatePlane_Wyoming_East_FIPS_4901_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103582, "NAD_1983_CORS96_StatePlane_Wyoming_E_Central_FIPS_4902_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103583, "NAD_1983_CORS96_StatePlane_Wyoming_W_Central_FIPS_4903_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103585, "NAD_1983_CORS96_StatePlane_Wyoming_West_FIPS_4904_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103600, "NAD_1983_HARN_Adj_MN_Aitkin_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103601, "NAD_1983_HARN_Adj_MN_Clay_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103602, "NAD_1983_HARN_Adj_MN_Clearwater_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103603, "NAD_1983_HARN_Adj_MN_Hubbard_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103604, "NAD_1983_HARN_Adj_MN_Lake_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103605, "NAD_1983_HARN_Adj_MN_Mille_Lacs_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103606, "NAD_1983_HARN_Adj_MN_Washington_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103607, "NAD_1983_HARN_Adj_MN_Wilkin_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103608, "NAD_1983_HARN_Adj_MN_Anoka_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103609, "NAD_1983_HARN_Adj_MN_Becker_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103610, "NAD_1983_HARN_Adj_MN_Beltrami_North_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103611, "NAD_1983_HARN_Adj_MN_Beltrami_South_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103612, "NAD_1983_HARN_Adj_MN_Benton_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103613, "NAD_1983_HARN_Adj_MN_Big_Stone_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103614, "NAD_1983_HARN_Adj_MN_Blue_Earth_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103615, "NAD_1983_HARN_Adj_MN_Brown_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103616, "NAD_1983_HARN_Adj_MN_Carlton_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103617, "NAD_1983_HARN_Adj_MN_Carver_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103618, "NAD_1983_HARN_Adj_MN_Cass_North_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103619, "NAD_1983_HARN_Adj_MN_Cass_South_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103620, "NAD_1983_HARN_Adj_MN_Chippewa_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103621, "NAD_1983_HARN_Adj_MN_Chisago_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103622, "NAD_1983_HARN_Adj_MN_Cook_North_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103623, "NAD_1983_HARN_Adj_MN_Cook_South_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103624, "NAD_1983_HARN_Adj_MN_Cottonwood_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103625, "NAD_1983_HARN_Adj_MN_Crow_Wing_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103626, "NAD_1983_HARN_Adj_MN_Dakota_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103627, "NAD_1983_HARN_Adj_MN_Dodge_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103628, "NAD_1983_HARN_Adj_MN_Douglas_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103629, "NAD_1983_HARN_Adj_MN_Faribault_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103630, "NAD_1983_HARN_Adj_MN_Fillmore_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103631, "NAD_1983_HARN_Adj_MN_Freeborn_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103632, "NAD_1983_HARN_Adj_MN_Goodhue_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103633, "NAD_1983_HARN_Adj_MN_Grant_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103634, "NAD_1983_HARN_Adj_MN_Hennepin_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103635, "NAD_1983_HARN_Adj_MN_Houston_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103636, "NAD_1983_HARN_Adj_MN_Isanti_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103637, "NAD_1983_HARN_Adj_MN_Itasca_North_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103638, "NAD_1983_HARN_Adj_MN_Itasca_South_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103639, "NAD_1983_HARN_Adj_MN_Jackson_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103640, "NAD_1983_HARN_Adj_MN_Kanabec_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103641, "NAD_1983_HARN_Adj_MN_Kandiyohi_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103642, "NAD_1983_HARN_Adj_MN_Kittson_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103643, "NAD_1983_HARN_Adj_MN_Koochiching_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103644, "NAD_1983_HARN_Adj_MN_Lac_Qui_Parle_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103645, "NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_North_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103646, "NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_South_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103647, "NAD_1983_HARN_Adj_MN_Le_Sueur_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103648, "NAD_1983_HARN_Adj_MN_Lincoln_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103649, "NAD_1983_HARN_Adj_MN_Lyon_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103650, "NAD_1983_HARN_Adj_MN_McLeod_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103651, "NAD_1983_HARN_Adj_MN_Mahnomen_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103652, "NAD_1983_HARN_Adj_MN_Marshall_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103653, "NAD_1983_HARN_Adj_MN_Martin_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103654, "NAD_1983_HARN_Adj_MN_Meeker_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103655, "NAD_1983_HARN_Adj_MN_Morrison_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103656, "NAD_1983_HARN_Adj_MN_Mower_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103657, "NAD_1983_HARN_Adj_MN_Murray_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103658, "NAD_1983_HARN_Adj_MN_Nicollet_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103659, "NAD_1983_HARN_Adj_MN_Nobles_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103660, "NAD_1983_HARN_Adj_MN_Norman_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103661, "NAD_1983_HARN_Adj_MN_Olmsted_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103662, "NAD_1983_HARN_Adj_MN_Ottertail_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103663, "NAD_1983_HARN_Adj_MN_Pennington_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103664, "NAD_1983_HARN_Adj_MN_Pine_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103665, "NAD_1983_HARN_Adj_MN_Pipestone_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103666, "NAD_1983_HARN_Adj_MN_Polk_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103667, "NAD_1983_HARN_Adj_MN_Pope_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103668, "NAD_1983_HARN_Adj_MN_Ramsey_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103669, "NAD_1983_HARN_Adj_MN_Red_Lake_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103670, "NAD_1983_HARN_Adj_MN_Redwood_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103671, "NAD_1983_HARN_Adj_MN_Renville_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103672, "NAD_1983_HARN_Adj_MN_Rice_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103673, "NAD_1983_HARN_Adj_MN_Rock_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103674, "NAD_1983_HARN_Adj_MN_Roseau_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103675, "NAD_1983_HARN_Adj_MN_St_Louis_North_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103676, "NAD_1983_HARN_Adj_MN_St_Louis_Central_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103677, "NAD_1983_HARN_Adj_MN_St_Louis_South_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103678, "NAD_1983_HARN_Adj_MN_Scott_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103679, "NAD_1983_HARN_Adj_MN_Sherburne_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103680, "NAD_1983_HARN_Adj_MN_Sibley_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103681, "NAD_1983_HARN_Adj_MN_Stearns_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103682, "NAD_1983_HARN_Adj_MN_Steele_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103683, "NAD_1983_HARN_Adj_MN_Stevens_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103684, "NAD_1983_HARN_Adj_MN_Swift_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103685, "NAD_1983_HARN_Adj_MN_Todd_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103686, "NAD_1983_HARN_Adj_MN_Traverse_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103687, "NAD_1983_HARN_Adj_MN_Wabasha_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103688, "NAD_1983_HARN_Adj_MN_Wadena_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103689, "NAD_1983_HARN_Adj_MN_Waseca_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103690, "NAD_1983_HARN_Adj_MN_Watonwan_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103691, "NAD_1983_HARN_Adj_MN_Winona_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103692, "NAD_1983_HARN_Adj_MN_Wright_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103693, "NAD_1983_HARN_Adj_MN_Yellow_Medicine_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103694, "NAD_1983_HARN_Adj_MN_St_Louis_CS96_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103695, "NAD_1983_HARN_Adj_MN_St_Louis_CS96_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103700, "NAD_1983_HARN_Adj_MN_Aitkin_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103701, "NAD_1983_HARN_Adj_MN_Clay_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103702, "NAD_1983_HARN_Adj_MN_Clearwater_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103703, "NAD_1983_HARN_Adj_MN_Hubbard_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103704, "NAD_1983_HARN_Adj_MN_Lake_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103705, "NAD_1983_HARN_Adj_MN_Mille_Lacs_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103706, "NAD_1983_HARN_Adj_MN_Washington_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103707, "NAD_1983_HARN_Adj_MN_Wilkin_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103708, "NAD_1983_HARN_Adj_MN_Anoka_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103709, "NAD_1983_HARN_Adj_MN_Becker_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103710, "NAD_1983_HARN_Adj_MN_Beltrami_North_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103711, "NAD_1983_HARN_Adj_MN_Beltrami_South_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103712, "NAD_1983_HARN_Adj_MN_Benton_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103713, "NAD_1983_HARN_Adj_MN_Big_Stone_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103714, "NAD_1983_HARN_Adj_MN_Blue_Earth_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103715, "NAD_1983_HARN_Adj_MN_Brown_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103716, "NAD_1983_HARN_Adj_MN_Carlton_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103717, "NAD_1983_HARN_Adj_MN_Carver_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103718, "NAD_1983_HARN_Adj_MN_Cass_North_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103719, "NAD_1983_HARN_Adj_MN_Cass_South_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103720, "NAD_1983_HARN_Adj_MN_Chippewa_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103721, "NAD_1983_HARN_Adj_MN_Chisago_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103722, "NAD_1983_HARN_Adj_MN_Cook_North_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103723, "NAD_1983_HARN_Adj_MN_Cook_South_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103724, "NAD_1983_HARN_Adj_MN_Cottonwood_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103725, "NAD_1983_HARN_Adj_MN_Crow_Wing_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103726, "NAD_1983_HARN_Adj_MN_Dakota_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103727, "NAD_1983_HARN_Adj_MN_Dodge_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103728, "NAD_1983_HARN_Adj_MN_Douglas_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103729, "NAD_1983_HARN_Adj_MN_Faribault_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103730, "NAD_1983_HARN_Adj_MN_Fillmore_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103731, "NAD_1983_HARN_Adj_MN_Freeborn_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103732, "NAD_1983_HARN_Adj_MN_Goodhue_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103733, "NAD_1983_HARN_Adj_MN_Grant_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103734, "NAD_1983_HARN_Adj_MN_Hennepin_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103735, "NAD_1983_HARN_Adj_MN_Houston_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103736, "NAD_1983_HARN_Adj_MN_Isanti_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103737, "NAD_1983_HARN_Adj_MN_Itasca_North_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103738, "NAD_1983_HARN_Adj_MN_Itasca_South_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103739, "NAD_1983_HARN_Adj_MN_Jackson_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103740, "NAD_1983_HARN_Adj_MN_Kanabec_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103741, "NAD_1983_HARN_Adj_MN_Kandiyohi_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103742, "NAD_1983_HARN_Adj_MN_Kittson_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103743, "NAD_1983_HARN_Adj_MN_Koochiching_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103744, "NAD_1983_HARN_Adj_MN_Lac_Qui_Parle_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103745, "NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_North_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103746, "NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_South_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103747, "NAD_1983_HARN_Adj_MN_Le_Sueur_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103748, "NAD_1983_HARN_Adj_MN_Lincoln_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103749, "NAD_1983_HARN_Adj_MN_Lyon_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103750, "NAD_1983_HARN_Adj_MN_McLeod_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103751, "NAD_1983_HARN_Adj_MN_Mahnomen_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103752, "NAD_1983_HARN_Adj_MN_Marshall_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103753, "NAD_1983_HARN_Adj_MN_Martin_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103754, "NAD_1983_HARN_Adj_MN_Meeker_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103755, "NAD_1983_HARN_Adj_MN_Morrison_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103756, "NAD_1983_HARN_Adj_MN_Mower_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103757, "NAD_1983_HARN_Adj_MN_Murray_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103758, "NAD_1983_HARN_Adj_MN_Nicollet_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103759, "NAD_1983_HARN_Adj_MN_Nobles_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103760, "NAD_1983_HARN_Adj_MN_Norman_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103761, "NAD_1983_HARN_Adj_MN_Olmsted_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103762, "NAD_1983_HARN_Adj_MN_Ottertail_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103763, "NAD_1983_HARN_Adj_MN_Pennington_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103764, "NAD_1983_HARN_Adj_MN_Pine_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103765, "NAD_1983_HARN_Adj_MN_Pipestone_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103766, "NAD_1983_HARN_Adj_MN_Polk_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103767, "NAD_1983_HARN_Adj_MN_Pope_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103768, "NAD_1983_HARN_Adj_MN_Ramsey_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103769, "NAD_1983_HARN_Adj_MN_Red_Lake_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103770, "NAD_1983_HARN_Adj_MN_Redwood_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103771, "NAD_1983_HARN_Adj_MN_Renville_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103772, "NAD_1983_HARN_Adj_MN_Rice_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103773, "NAD_1983_HARN_Adj_MN_Rock_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103774, "NAD_1983_HARN_Adj_MN_Roseau_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103775, "NAD_1983_HARN_Adj_MN_St_Louis_North_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103776, "NAD_1983_HARN_Adj_MN_St_Louis_Central_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103777, "NAD_1983_HARN_Adj_MN_St_Louis_South_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103778, "NAD_1983_HARN_Adj_MN_Scott_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103779, "NAD_1983_HARN_Adj_MN_Sherburne_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103780, "NAD_1983_HARN_Adj_MN_Sibley_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103781, "NAD_1983_HARN_Adj_MN_Stearns_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103782, "NAD_1983_HARN_Adj_MN_Steele_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103783, "NAD_1983_HARN_Adj_MN_Stevens_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103784, "NAD_1983_HARN_Adj_MN_Swift_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103785, "NAD_1983_HARN_Adj_MN_Todd_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103786, "NAD_1983_HARN_Adj_MN_Traverse_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103787, "NAD_1983_HARN_Adj_MN_Wabasha_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103788, "NAD_1983_HARN_Adj_MN_Wadena_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103789, "NAD_1983_HARN_Adj_MN_Waseca_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103790, "NAD_1983_HARN_Adj_MN_Watonwan_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103791, "NAD_1983_HARN_Adj_MN_Winona_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103792, "NAD_1983_HARN_Adj_MN_Wright_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103793, "NAD_1983_HARN_Adj_MN_Yellow_Medicine_Feet", "Foot_US", 0.3048006096012192));
        }
    }

    private static class PCS_4 {
        private PCS_4() {
        }

        static void add(List<CoordinateSystem> list) {
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30729, "Nord_Sahara_1959_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30730, "Nord_Sahara_1959_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30731, "Nord_Sahara_1959_UTM_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30732, "Nord_Sahara_1959_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30791, "Nord_Sahara_1959_Voirol_Unifie_Nord", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30792, "Nord_Sahara_1959_Voirol_Unifie_Sud", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31028, "Yoff_1972_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31121, "Zanderij_1972_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31154, "Zanderij_TM_54_NW", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31170, "Zanderij_Suriname_Old_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31171, "Zanderij_Suriname_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31251, "MGI_Ferro_Austria_GK_West", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31252, "MGI_Ferro_Austria_GK_Central", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31253, "MGI_Ferro_Austria_GK_East", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31254, "MGI_Austria_GK_West", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31255, "MGI_Austria_GK_Central", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31256, "MGI_Austria_GK_East", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31257, "MGI_Austria_GK_M28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31258, "MGI_Austria_GK_M31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31259, "MGI_Austria_GK_M34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31265, "MGI_3_Degree_Gauss_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31266, "MGI_3_Degree_Gauss_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31267, "MGI_3_Degree_Gauss_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31268, "MGI_3_Degree_Gauss_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31275, "MGI_Balkans_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31276, "MGI_Balkans_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31277, "MGI_Balkans_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31279, "MGI_Balkans_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31281, "Austria_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31282, "Austria_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31283, "Austria_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31284, "MGI_M28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31285, "MGI_M31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31286, "MGI_M34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31287, "MGI_Austria_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31288, "MGI_Ferro_M28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31289, "MGI_Ferro_M31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31290, "MGI_Ferro_M34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31370, "Belge_Lambert_1972", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31466, "DHDN_3_Degree_Gauss_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31467, "DHDN_3_Degree_Gauss_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31468, "DHDN_3_Degree_Gauss_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31469, "DHDN_3_Degree_Gauss_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31491, "Germany_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31492, "Germany_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31493, "Germany_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31494, "Germany_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31495, "Germany_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31528, "Conakry_1905_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31529, "Conakry_1905_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31600, "Stereo_33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31700, "Stereo_70", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31838, "NGN_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31839, "NGN_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31901, "KUDAMS_KTM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31965, "SIRGAS_2000_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31966, "SIRGAS_2000_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31967, "SIRGAS_2000_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31968, "SIRGAS_2000_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31969, "SIRGAS_2000_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31970, "SIRGAS_2000_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31971, "SIRGAS_2000_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31972, "SIRGAS_2000_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31973, "SIRGAS_2000_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31974, "SIRGAS_2000_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31975, "SIRGAS_2000_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31976, "SIRGAS_2000_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31977, "SIRGAS_2000_UTM_Zone_17S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31978, "SIRGAS_2000_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31979, "SIRGAS_2000_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31980, "SIRGAS_2000_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31981, "SIRGAS_2000_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31982, "SIRGAS_2000_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31983, "SIRGAS_2000_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31984, "SIRGAS_2000_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31985, "SIRGAS_2000_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31986, "SIRGAS_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31987, "SIRGAS_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31988, "SIRGAS_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31989, "SIRGAS_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31990, "SIRGAS_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31991, "SIRGAS_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31992, "SIRGAS_UTM_Zone_17S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31993, "SIRGAS_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31994, "SIRGAS_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31995, "SIRGAS_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31996, "SIRGAS_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31997, "SIRGAS_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31998, "SIRGAS_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 31999, "SIRGAS_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32000, "SIRGAS_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32001, "NAD_1927_StatePlane_Montana_North_FIPS_2501", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32002, "NAD_1927_StatePlane_Montana_Central_FIPS_2502", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32003, "NAD_1927_StatePlane_Montana_South_FIPS_2503", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32005, "NAD_1927_StatePlane_Nebraska_North_FIPS_2601", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32006, "NAD_1927_StatePlane_Nebraska_South_FIPS_2602", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32007, "NAD_1927_StatePlane_Nevada_East_FIPS_2701", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32008, "NAD_1927_StatePlane_Nevada_Central_FIPS_2702", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32009, "NAD_1927_StatePlane_Nevada_West_FIPS_2703", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32010, "NAD_1927_StatePlane_New_Hampshire_FIPS_2800", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32011, "NAD_1927_StatePlane_New_Jersey_FIPS_2900", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32012, "NAD_1927_StatePlane_New_Mexico_East_FIPS_3001", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32013, "NAD_1927_StatePlane_New_Mexico_Central_FIPS_3002", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32014, "NAD_1927_StatePlane_New_Mexico_West_FIPS_3003", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32015, "NAD_1927_StatePlane_New_York_East_FIPS_3101", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32016, "NAD_1927_StatePlane_New_York_Central_FIPS_3102", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32017, "NAD_1927_StatePlane_New_York_West_FIPS_3103", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32019, "NAD_1927_StatePlane_North_Carolina_FIPS_3200", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32020, "NAD_1927_StatePlane_North_Dakota_North_FIPS_3301", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32021, "NAD_1927_StatePlane_North_Dakota_South_FIPS_3302", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32022, "NAD_1927_StatePlane_Ohio_North_FIPS_3401", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32023, "NAD_1927_StatePlane_Ohio_South_FIPS_3402", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32024, "NAD_1927_StatePlane_Oklahoma_North_FIPS_3501", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32025, "NAD_1927_StatePlane_Oklahoma_South_FIPS_3502", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32026, "NAD_1927_StatePlane_Oregon_North_FIPS_3601", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32027, "NAD_1927_StatePlane_Oregon_South_FIPS_3602", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32028, "NAD_1927_StatePlane_Pennsylvania_North_FIPS_3701", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32030, "NAD_1927_StatePlane_Rhode_Island_FIPS_3800", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32031, "NAD_1927_StatePlane_South_Carolina_North_FIPS_3901", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32033, "NAD_1927_StatePlane_South_Carolina_South_FIPS_3902", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32034, "NAD_1927_StatePlane_South_Dakota_North_FIPS_4001", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32035, "NAD_1927_StatePlane_South_Dakota_South_FIPS_4002", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32037, "NAD_1927_StatePlane_Texas_North_FIPS_4201", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32038, "NAD_1927_StatePlane_Texas_North_Central_FIPS_4202", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32039, "NAD_1927_StatePlane_Texas_Central_FIPS_4203", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32040, "NAD_1927_StatePlane_Texas_South_Central_FIPS_4204", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32041, "NAD_1927_StatePlane_Texas_South_FIPS_4205", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32042, "NAD_1927_StatePlane_Utah_North_FIPS_4301", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32043, "NAD_1927_StatePlane_Utah_Central_FIPS_4302", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32044, "NAD_1927_StatePlane_Utah_South_FIPS_4303", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32045, "NAD_1927_StatePlane_Vermont_FIPS_4400", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32046, "NAD_1927_StatePlane_Virginia_North_FIPS_4501", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32047, "NAD_1927_StatePlane_Virginia_South_FIPS_4502", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32048, "NAD_1927_StatePlane_Washington_North_FIPS_4601", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32049, "NAD_1927_StatePlane_Washington_South_FIPS_4602", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32050, "NAD_1927_StatePlane_West_Virginia_North_FIPS_4701", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32051, "NAD_1927_StatePlane_West_Virginia_South_FIPS_4702", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32052, "NAD_1927_StatePlane_Wisconsin_North_FIPS_4801", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32053, "NAD_1927_StatePlane_Wisconsin_Central_FIPS_4802", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32054, "NAD_1927_StatePlane_Wisconsin_South_FIPS_4803", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32055, "NAD_1927_StatePlane_Wyoming_East_FIPS_4901", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32056, "NAD_1927_StatePlane_Wyoming_East_Central_FIPS_4902", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32057, "NAD_1927_StatePlane_Wyoming_West_Central_FIPS_4903", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32058, "NAD_1927_StatePlane_Wyoming_West_FIPS_4904", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32059, "NAD_1927_StatePlane_Puerto_Rico_FIPS_5201", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32060, "NAD_1927_StatePlane_Virgin_Islands_St_Croix_FIPS_5202", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32061, "NAD_1927_Guatemala_Norte", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32062, "NAD_1927_Guatemala_Sur", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32064, "NAD_1927_BLM_Zone_14N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32065, "NAD_1927_BLM_Zone_15N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32066, "NAD_1927_BLM_Zone_16N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32067, "NAD_1927_BLM_Zone_17N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32081, "NAD_1927_MTM_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32082, "NAD_1927_MTM_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32083, "NAD_1927_MTM_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32084, "NAD_1927_MTM_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32085, "NAD_1927_MTM_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32086, "NAD_1927_MTM_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32098, "NAD_1927_Quebec_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32099, "NAD_1927_StatePlane_Louisiana_Offshore_FIPS_1703", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32100, "NAD_1983_StatePlane_Montana_FIPS_2500", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32104, "NAD_1983_StatePlane_Nebraska_FIPS_2600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32107, "NAD_1983_StatePlane_Nevada_East_FIPS_2701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32108, "NAD_1983_StatePlane_Nevada_Central_FIPS_2702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32109, "NAD_1983_StatePlane_Nevada_West_FIPS_2703", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32110, "NAD_1983_StatePlane_New_Hampshire_FIPS_2800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32111, "NAD_1983_StatePlane_New_Jersey_FIPS_2900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32112, "NAD_1983_StatePlane_New_Mexico_East_FIPS_3001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32113, "NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32114, "NAD_1983_StatePlane_New_Mexico_West_FIPS_3003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32115, "NAD_1983_StatePlane_New_York_East_FIPS_3101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32116, "NAD_1983_StatePlane_New_York_Central_FIPS_3102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32117, "NAD_1983_StatePlane_New_York_West_FIPS_3103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32118, "NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32119, "NAD_1983_StatePlane_North_Carolina_FIPS_3200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32120, "NAD_1983_StatePlane_North_Dakota_North_FIPS_3301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32121, "NAD_1983_StatePlane_North_Dakota_South_FIPS_3302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32122, "NAD_1983_StatePlane_Ohio_North_FIPS_3401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32123, "NAD_1983_StatePlane_Ohio_South_FIPS_3402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32124, "NAD_1983_StatePlane_Oklahoma_North_FIPS_3501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32125, "NAD_1983_StatePlane_Oklahoma_South_FIPS_3502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32126, "NAD_1983_StatePlane_Oregon_North_FIPS_3601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32127, "NAD_1983_StatePlane_Oregon_South_FIPS_3602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32128, "NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32129, "NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32130, "NAD_1983_StatePlane_Rhode_Island_FIPS_3800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32133, "NAD_1983_StatePlane_South_Carolina_FIPS_3900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32134, "NAD_1983_StatePlane_South_Dakota_North_FIPS_4001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32135, "NAD_1983_StatePlane_South_Dakota_South_FIPS_4002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32136, "NAD_1983_StatePlane_Tennessee_FIPS_4100", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32137, "NAD_1983_StatePlane_Texas_North_FIPS_4201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32138, "NAD_1983_StatePlane_Texas_North_Central_FIPS_4202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32139, "NAD_1983_StatePlane_Texas_Central_FIPS_4203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32140, "NAD_1983_StatePlane_Texas_South_Central_FIPS_4204", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32141, "NAD_1983_StatePlane_Texas_South_FIPS_4205", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32142, "NAD_1983_StatePlane_Utah_North_FIPS_4301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32143, "NAD_1983_StatePlane_Utah_Central_FIPS_4302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32144, "NAD_1983_StatePlane_Utah_South_FIPS_4303", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32145, "NAD_1983_StatePlane_Vermont_FIPS_4400", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32146, "NAD_1983_StatePlane_Virginia_North_FIPS_4501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32147, "NAD_1983_StatePlane_Virginia_South_FIPS_4502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32148, "NAD_1983_StatePlane_Washington_North_FIPS_4601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32149, "NAD_1983_StatePlane_Washington_South_FIPS_4602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32150, "NAD_1983_StatePlane_West_Virginia_North_FIPS_4701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32151, "NAD_1983_StatePlane_West_Virginia_South_FIPS_4702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32152, "NAD_1983_StatePlane_Wisconsin_North_FIPS_4801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32153, "NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32154, "NAD_1983_StatePlane_Wisconsin_South_FIPS_4803", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32155, "NAD_1983_StatePlane_Wyoming_East_FIPS_4901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32156, "NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32157, "NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32158, "NAD_1983_StatePlane_Wyoming_West_FIPS_4904", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32161, "NAD_1983_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32164, "NAD_1983_BLM_Zone_14N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32165, "NAD_1983_BLM_Zone_15N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32166, "NAD_1983_BLM_Zone_16N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32167, "NAD_1983_BLM_Zone_17N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32180, "NAD_1983_MTM_2_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32181, "NAD_1983_MTM_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32182, "NAD_1983_MTM_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32183, "NAD_1983_MTM_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32184, "NAD_1983_MTM_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32185, "NAD_1983_MTM_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32186, "NAD_1983_MTM_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32187, "NAD_1983_MTM_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32188, "NAD_1983_MTM_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32189, "NAD_1983_MTM_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32190, "NAD_1983_MTM_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32191, "NAD_1983_MTM_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32192, "NAD_1983_MTM_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32193, "NAD_1983_MTM_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32194, "NAD_1983_MTM_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32195, "NAD_1983_MTM_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32196, "NAD_1983_MTM_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32197, "NAD_1983_MTM_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32198, "NAD_1983_Quebec_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32199, "NAD_1983_StatePlane_Louisiana_Offshore_FIPS_1703", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32201, "WGS_1972_UTM_Zone_1N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32202, "WGS_1972_UTM_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32203, "WGS_1972_UTM_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32204, "WGS_1972_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32205, "WGS_1972_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32206, "WGS_1972_UTM_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32207, "WGS_1972_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32208, "WGS_1972_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32209, "WGS_1972_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32210, "WGS_1972_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32211, "WGS_1972_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32212, "WGS_1972_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32213, "WGS_1972_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32214, "WGS_1972_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32215, "WGS_1972_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32216, "WGS_1972_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32217, "WGS_1972_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32218, "WGS_1972_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32219, "WGS_1972_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32220, "WGS_1972_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32221, "WGS_1972_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32222, "WGS_1972_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32223, "WGS_1972_UTM_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32224, "WGS_1972_UTM_Zone_24N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32225, "WGS_1972_UTM_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32226, "WGS_1972_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32227, "WGS_1972_UTM_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32228, "WGS_1972_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32229, "WGS_1972_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32230, "WGS_1972_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32231, "WGS_1972_UTM_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32232, "WGS_1972_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32233, "WGS_1972_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32234, "WGS_1972_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32235, "WGS_1972_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32236, "WGS_1972_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32237, "WGS_1972_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32238, "WGS_1972_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32239, "WGS_1972_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32240, "WGS_1972_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32241, "WGS_1972_UTM_Zone_41N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32242, "WGS_1972_UTM_Zone_42N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32243, "WGS_1972_UTM_Zone_43N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32244, "WGS_1972_UTM_Zone_44N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32245, "WGS_1972_UTM_Zone_45N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32246, "WGS_1972_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32247, "WGS_1972_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32248, "WGS_1972_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32249, "WGS_1972_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32250, "WGS_1972_UTM_Zone_50N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32251, "WGS_1972_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32252, "WGS_1972_UTM_Zone_52N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32253, "WGS_1972_UTM_Zone_53N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32254, "WGS_1972_UTM_Zone_54N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32255, "WGS_1972_UTM_Zone_55N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32256, "WGS_1972_UTM_Zone_56N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32257, "WGS_1972_UTM_Zone_57N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32258, "WGS_1972_UTM_Zone_58N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32259, "WGS_1972_UTM_Zone_59N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32260, "WGS_1972_UTM_Zone_60N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32301, "WGS_1972_UTM_Zone_1S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32302, "WGS_1972_UTM_Zone_2S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32303, "WGS_1972_UTM_Zone_3S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32304, "WGS_1972_UTM_Zone_4S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32305, "WGS_1972_UTM_Zone_5S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32306, "WGS_1972_UTM_Zone_6S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32307, "WGS_1972_UTM_Zone_7S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32308, "WGS_1972_UTM_Zone_8S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32309, "WGS_1972_UTM_Zone_9S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32310, "WGS_1972_UTM_Zone_10S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32311, "WGS_1972_UTM_Zone_11S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32312, "WGS_1972_UTM_Zone_12S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32313, "WGS_1972_UTM_Zone_13S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32314, "WGS_1972_UTM_Zone_14S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32315, "WGS_1972_UTM_Zone_15S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32316, "WGS_1972_UTM_Zone_16S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32317, "WGS_1972_UTM_Zone_17S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32318, "WGS_1972_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32319, "WGS_1972_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32320, "WGS_1972_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32321, "WGS_1972_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32322, "WGS_1972_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32323, "WGS_1972_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32324, "WGS_1972_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32325, "WGS_1972_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32326, "WGS_1972_UTM_Zone_26S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32327, "WGS_1972_UTM_Zone_27S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32328, "WGS_1972_UTM_Zone_28S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32329, "WGS_1972_UTM_Zone_29S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32330, "WGS_1972_UTM_Zone_30S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32331, "WGS_1972_UTM_Zone_31S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32332, "WGS_1972_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32333, "WGS_1972_UTM_Zone_33S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32334, "WGS_1972_UTM_Zone_34S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32335, "WGS_1972_UTM_Zone_35S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32336, "WGS_1972_UTM_Zone_36S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32337, "WGS_1972_UTM_Zone_37S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32338, "WGS_1972_UTM_Zone_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32339, "WGS_1972_UTM_Zone_39S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32340, "WGS_1972_UTM_Zone_40S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32341, "WGS_1972_UTM_Zone_41S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32342, "WGS_1972_UTM_Zone_42S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32343, "WGS_1972_UTM_Zone_43S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32344, "WGS_1972_UTM_Zone_44S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32345, "WGS_1972_UTM_Zone_45S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32346, "WGS_1972_UTM_Zone_46S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32347, "WGS_1972_UTM_Zone_47S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32348, "WGS_1972_UTM_Zone_48S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32349, "WGS_1972_UTM_Zone_49S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32350, "WGS_1972_UTM_Zone_50S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32351, "WGS_1972_UTM_Zone_51S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32352, "WGS_1972_UTM_Zone_52S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32353, "WGS_1972_UTM_Zone_53S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32354, "WGS_1972_UTM_Zone_54S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32355, "WGS_1972_UTM_Zone_55S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32356, "WGS_1972_UTM_Zone_56S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32357, "WGS_1972_UTM_Zone_57S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32358, "WGS_1972_UTM_Zone_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32359, "WGS_1972_UTM_Zone_59S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32360, "WGS_1972_UTM_Zone_60S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32601, "WGS_1984_UTM_Zone_1N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32602, "WGS_1984_UTM_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32603, "WGS_1984_UTM_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32604, "WGS_1984_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32605, "WGS_1984_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32606, "WGS_1984_UTM_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32607, "WGS_1984_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32608, "WGS_1984_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32609, "WGS_1984_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32610, "WGS_1984_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32611, "WGS_1984_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32612, "WGS_1984_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32613, "WGS_1984_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32614, "WGS_1984_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32615, "WGS_1984_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32616, "WGS_1984_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32617, "WGS_1984_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32618, "WGS_1984_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32619, "WGS_1984_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32620, "WGS_1984_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32621, "WGS_1984_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32622, "WGS_1984_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32623, "WGS_1984_UTM_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32624, "WGS_1984_UTM_Zone_24N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32625, "WGS_1984_UTM_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32626, "WGS_1984_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32627, "WGS_1984_UTM_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32628, "WGS_1984_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32629, "WGS_1984_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32630, "WGS_1984_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32631, "WGS_1984_UTM_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32632, "WGS_1984_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32633, "WGS_1984_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32634, "WGS_1984_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32635, "WGS_1984_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32636, "WGS_1984_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32637, "WGS_1984_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32638, "WGS_1984_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32639, "WGS_1984_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32640, "WGS_1984_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32641, "WGS_1984_UTM_Zone_41N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32642, "WGS_1984_UTM_Zone_42N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32643, "WGS_1984_UTM_Zone_43N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32644, "WGS_1984_UTM_Zone_44N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32645, "WGS_1984_UTM_Zone_45N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32646, "WGS_1984_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32647, "WGS_1984_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32648, "WGS_1984_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32649, "WGS_1984_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32650, "WGS_1984_UTM_Zone_50N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32651, "WGS_1984_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32652, "WGS_1984_UTM_Zone_52N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32653, "WGS_1984_UTM_Zone_53N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32654, "WGS_1984_UTM_Zone_54N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32655, "WGS_1984_UTM_Zone_55N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32656, "WGS_1984_UTM_Zone_56N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32657, "WGS_1984_UTM_Zone_57N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32658, "WGS_1984_UTM_Zone_58N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32659, "WGS_1984_UTM_Zone_59N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32660, "WGS_1984_UTM_Zone_60N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32661, "UPS_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32662, "WGS_1984_Plate_Carree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32664, "WGS_1984_BLM_Zone_14N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32665, "WGS_1984_BLM_Zone_15N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32666, "WGS_1984_BLM_Zone_16N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32667, "WGS_1984_BLM_Zone_17N_ftUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32701, "WGS_1984_UTM_Zone_1S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32702, "WGS_1984_UTM_Zone_2S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32703, "WGS_1984_UTM_Zone_3S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32704, "WGS_1984_UTM_Zone_4S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32705, "WGS_1984_UTM_Zone_5S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32706, "WGS_1984_UTM_Zone_6S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32707, "WGS_1984_UTM_Zone_7S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32708, "WGS_1984_UTM_Zone_8S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32709, "WGS_1984_UTM_Zone_9S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32710, "WGS_1984_UTM_Zone_10S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32711, "WGS_1984_UTM_Zone_11S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32712, "WGS_1984_UTM_Zone_12S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32713, "WGS_1984_UTM_Zone_13S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32714, "WGS_1984_UTM_Zone_14S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32715, "WGS_1984_UTM_Zone_15S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32716, "WGS_1984_UTM_Zone_16S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32717, "WGS_1984_UTM_Zone_17S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32718, "WGS_1984_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32719, "WGS_1984_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32720, "WGS_1984_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32721, "WGS_1984_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32722, "WGS_1984_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32723, "WGS_1984_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32724, "WGS_1984_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32725, "WGS_1984_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32726, "WGS_1984_UTM_Zone_26S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32727, "WGS_1984_UTM_Zone_27S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32728, "WGS_1984_UTM_Zone_28S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32729, "WGS_1984_UTM_Zone_29S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32730, "WGS_1984_UTM_Zone_30S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32731, "WGS_1984_UTM_Zone_31S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32732, "WGS_1984_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32733, "WGS_1984_UTM_Zone_33S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32734, "WGS_1984_UTM_Zone_34S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32735, "WGS_1984_UTM_Zone_35S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32736, "WGS_1984_UTM_Zone_36S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32737, "WGS_1984_UTM_Zone_37S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32738, "WGS_1984_UTM_Zone_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32739, "WGS_1984_UTM_Zone_39S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32740, "WGS_1984_UTM_Zone_40S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32741, "WGS_1984_UTM_Zone_41S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32742, "WGS_1984_UTM_Zone_42S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32743, "WGS_1984_UTM_Zone_43S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32744, "WGS_1984_UTM_Zone_44S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32745, "WGS_1984_UTM_Zone_45S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32746, "WGS_1984_UTM_Zone_46S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32747, "WGS_1984_UTM_Zone_47S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32748, "WGS_1984_UTM_Zone_48S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32749, "WGS_1984_UTM_Zone_49S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32750, "WGS_1984_UTM_Zone_50S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32751, "WGS_1984_UTM_Zone_51S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32752, "WGS_1984_UTM_Zone_52S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32753, "WGS_1984_UTM_Zone_53S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32754, "WGS_1984_UTM_Zone_54S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32755, "WGS_1984_UTM_Zone_55S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32756, "WGS_1984_UTM_Zone_56S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32757, "WGS_1984_UTM_Zone_57S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32758, "WGS_1984_UTM_Zone_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32759, "WGS_1984_UTM_Zone_59S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32760, "WGS_1984_UTM_Zone_60S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32761, "UPS_South", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 32766, "WGS_1984_TM_36_SE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53001, "Sphere_Plate_Carree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53002, "Sphere_Equidistant_Cylindrical", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53003, "Sphere_Miller_Cylindrical", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53004, "Sphere_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53008, "Sphere_Sinusoidal", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53009, "Sphere_Mollweide", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53010, "Sphere_Eckert_VI", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53011, "Sphere_Eckert_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53012, "Sphere_Eckert_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53013, "Sphere_Eckert_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53014, "Sphere_Eckert_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53015, "Sphere_Eckert_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53016, "Sphere_Gall_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53017, "Sphere_Behrmann", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53018, "Sphere_Winkel_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53019, "Sphere_Winkel_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53021, "Sphere_Polyconic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53022, "Sphere_Quartic_Authalic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53023, "Sphere_Loximuthal", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53024, "Sphere_Bonne", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53025, "Sphere_Hotine", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53026, "Sphere_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53027, "Sphere_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53028, "Sphere_Cassini", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53029, "Sphere_Van_der_Grinten_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53030, "Sphere_Robinson", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53031, "Sphere_Two_Point_Equidistant", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53032, "Sphere_Azimuthal_Equidistant", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53034, "Sphere_Cylindrical_Equal_Area", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53042, "Sphere_Winkel_Tripel_NGS", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53043, "Sphere_Aitoff", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53044, "Sphere_Hammer_Aitoff", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53045, "Sphere_Flat_Polar_Quartic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53046, "Sphere_Craster_Parabolic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53048, "Sphere_Times", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 53049, "Sphere_Vertical_Perspective", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54001, "World_Plate_Carree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54002, "World_Equidistant_Cylindrical", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54003, "World_Miller_Cylindrical", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54004, "World_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54008, "World_Sinusoidal", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54009, "World_Mollweide", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54010, "World_Eckert_VI", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54011, "World_Eckert_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54012, "World_Eckert_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54013, "World_Eckert_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54014, "World_Eckert_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54015, "World_Eckert_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54016, "World_Gall_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54017, "World_Behrmann", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54018, "World_Winkel_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54019, "World_Winkel_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54021, "World_Polyconic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54022, "World_Quartic_Authalic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54023, "World_Loximuthal", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54024, "World_Bonne", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54025, "World_Hotine", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54026, "World_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54027, "World_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54028, "World_Cassini", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54029, "World_Van_der_Grinten_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54030, "World_Robinson", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54031, "World_Two_Point_Equidistant", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54032, "World_Azimuthal_Equidistant", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54034, "World_Cylindrical_Equal_Area", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54042, "World_Winkel_Tripel_NGS", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54043, "World_Aitoff", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54044, "World_Hammer_Aitoff", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54045, "World_Flat_Polar_Quartic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54046, "World_Craster_Parabolic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54048, "World_Times", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54049, "World_Vertical_Perspective", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54050, "World_Fuller", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54051, "World_Cube", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54052, "World_Goode_Homolosine_Land", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 54053, "World_Goode_Homolosine_Ocean", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 65061, "NAD_1927_StatePlane_Guam_FIPS_5400", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 65062, "American_Samoa_1962_StatePlane_American_Samoa_FIPS_5300", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 65161, "NAD_1983_StatePlane_Guam_FIPS_5400", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102001, "Canada_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102002, "Canada_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102003, "USA_Contiguous_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102004, "USA_Contiguous_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102005, "USA_Contiguous_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102007, "Hawaii_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102008, "North_America_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102009, "North_America_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102010, "North_America_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102011, "Africa_Sinusoidal", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102012, "Asia_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102013, "Europe_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102014, "Europe_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102015, "South_America_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102016, "North_Pole_Azimuthal_Equidistant", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102017, "North_Pole_Lambert_Azimuthal_Equal_Area", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102018, "North_Pole_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102019, "South_Pole_Azimuthal_Equidistant", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102020, "South_Pole_Lambert_Azimuthal_Equal_Area", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102021, "South_Pole_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102022, "Africa_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102023, "Africa_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102024, "Africa_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102025, "Asia_North_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102026, "Asia_North_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102027, "Asia_North_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102028, "Asia_South_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102029, "Asia_South_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102030, "Asia_South_Lambert_Conformal_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102031, "Europe_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102032, "South_America_Equidistant_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102033, "South_America_Albers_Equal_Area_Conic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102034, "North_Pole_Gnomonic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102035, "North_Pole_Orthographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102036, "South_Pole_Gnomonic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102037, "South_Pole_Orthographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102038, "The_World_From_Space", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102039, "USA_Contiguous_Albers_Equal_Area_Conic_USGS_version", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102041, "COB_NAD83_2007", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102042, "NAD_1983_USFS_R9_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102043, "NAD_1983_CORS96_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102044, "NAD_1983_NSRS2007_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102045, "NAD_1983_2011_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102060, "D48_Slovenia_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102061, "Everest_Modified_1969_RSO_Malaya_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102062, "Kertau_RSO_Malaya_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102063, "Kandawala_Ceylon_Belt_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102064, "Kandawala_Ceylon_Belt_Indian_Yards_1937", "Yard_Indian_1937", 0.91439523));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102068, "EMEP_50_Kilometer_Grid", "50_Kilometers", 50000.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102069, "EMEP_150_Kilometer_Grid", "150_Kilometers", 150000.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102070, "Guernsey_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102071, "AGD_1966_ACT_Grid_AGC_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102072, "AGD_1966_ISG_54_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102073, "AGD_1966_ISG_54_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102074, "AGD_1966_ISG_55_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102075, "AGD_1966_ISG_55_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102076, "AGD_1966_ISG_55_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102077, "AGD_1966_ISG_56_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102078, "AGD_1966_ISG_56_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102079, "AGD_1966_ISG_56_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102093, "Roma_1940_Gauss_Boaga_Est", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102094, "Roma_1940_Gauss_Boaga_Ovest", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102096, "Bab_South_Palau_Azimuthal_Equidistant", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102097, "ETRS_1989_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102098, "ETRS_1989_UTM_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102099, "ETRS_1989_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102101, "NGO_1948_Norway_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102102, "NGO_1948_Norway_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102103, "NGO_1948_Norway_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102104, "NGO_1948_Norway_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102105, "NGO_1948_Norway_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102106, "NGO_1948_Norway_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102107, "NGO_1948_Norway_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102108, "NGO_1948_Norway_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102109, "ETRS_1989_Slovenia_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102114, "Old_Hawaiian_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102115, "Old_Hawaiian_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102116, "American_Samoa_1962_UTM_Zone_2S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102117, "NAD_1927_Alaska_Albers_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102118, "NAD_1927_Georgia_Statewide_Albers", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102120, "NAD_1927_Michigan_GeoRef_Feet_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102121, "NAD_1983_Michigan_GeoRef_Feet_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102122, "NAD_1927_Michigan_GeoRef_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102132, "NGO_1948_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102133, "NGO_1948_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102134, "NGO_1948_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102135, "NGO_1948_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102136, "NGO_1948_Baerum_Kommune", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102137, "NGO_1948_Bergenhalvoen", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102138, "NGO_1948_Oslo_Kommune", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102141, "Hong_Kong_1980_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102142, "Hong_Kong_1980_UTM_Zone_50N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102143, "QND_1995_UTM_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102144, "Merchich_Degree_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102150, "JGD_2000_UTM_Zone_56N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102156, "Tokyo_UTM_Zone_56N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102157, "ETRS_1989_Kosovo_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102158, "Jordan_JTM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102159, "Observatorio_Meteorologico_1965_Macau_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102160, "Datum_73_Hayford_Gauss_IGeoE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102161, "Datum_73_Hayford_Gauss_IPCC", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102162, "Graciosa_Base_SW_1948_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102163, "Lisboa_Bessel_Bonne", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102164, "Lisboa_Hayford_Gauss_IGeoE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102165, "Lisboa_Hayford_Gauss_IPCC", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102166, "Observatorio_Meteorologico_1939_UTM_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102168, "Sao_Braz_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102173, "ETRS_1989_UWPP_1992", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102174, "ETRS_1989_UWPP_2000_PAS_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102175, "ETRS_1989_UWPP_2000_PAS_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102176, "ETRS_1989_UWPP_2000_PAS_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102177, "ETRS_1989_UWPP_2000_PAS_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102178, "NAD_1927_10TM_AEP_Forest", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102179, "NAD_1927_10TM_AEP_Resource", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102191, "Nord_Maroc_Degree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102192, "Sud_Maroc_Degree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102193, "Sahara_Degree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102194, "UWPP_1992", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102195, "UWPP_2000_PAS_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102196, "UWPP_2000_PAS_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102197, "UWPP_2000_PAS_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102198, "UWPP_2000_PAS_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102204, "Ain_el_Abd_1970_Aramco_Lambert_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102212, "NAD_1983_WyLAM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102213, "NAD_1983_UTM_Zone_58N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102215, "WGS_1984_Canada_Atlas_LCC", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102216, "GDA_1994_Perth_Coastal_Grid_1994", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102217, "NAD_1983_NSRS2007_Wisconsin_TM_US_Ft", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102218, "NAD_1983_USFS_R6_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102219, "NAD_1983_Wisconsin_TM_US_Ft", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102220, "NAD_1983_HARN_Wisconsin_TM_US_Ft", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102221, "Ocotepeque_1935_Costa_Rica_Lambert_Norte", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102222, "Ocotepeque_1935_Costa_Rica_Lambert_Sur", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102223, "WGS_1984_Costa_Rica_TM_90", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102224, "MONREF_1997_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102225, "MONREF_1997_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102226, "MONREF_1997_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102227, "MONREF_1997_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102228, "MONREF_1997_UTM_Zone_50N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102231, "Colombia_West_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102232, "Bogota_Ciudad_Bogota", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102233, "MAGNA_Ciudad_Bogota", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102237, "Pohnpei_Az_Eq_1971", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102238, "Saipan_Az_Eq_1969", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102239, "Guam_Geodetic_Triangulation_Network_1963", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102240, "Guam_Geodetic_Network_1993", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102247, "NAD_1983_CORS96_Alaska_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102299, "Berghaus_Star_AAG", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102306, "Nepal_Nagarkot_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102319, "CGRS_1993_LTM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102328, "ETRS_1989_UTM_Zone_32N_7stellen", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102329, "ETRS_1989_UTM_Zone_32N_8stellen", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102359, "ETRS_1989_UTM_Zone_33N_7stellen", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102360, "ETRS_1989_UTM_Zone_33N_8stellen", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102364, "NAD_1983_CORS96_UTM_Zone_59N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102365, "NAD_1983_CORS96_UTM_Zone_60N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102366, "NAD_1983_CORS96_StatePlane_Alaska_1_FIPS_5001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102367, "NAD_1983_CORS96_StatePlane_Alaska_2_FIPS_5002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102368, "NAD_1983_CORS96_StatePlane_Alaska_3_FIPS_5003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102369, "NAD_1983_CORS96_StatePlane_Alaska_4_FIPS_5004", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102370, "NAD_1983_CORS96_StatePlane_Alaska_5_FIPS_5005", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102371, "NAD_1983_CORS96_StatePlane_Alaska_6_FIPS_5006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102372, "NAD_1983_CORS96_StatePlane_Alaska_7_FIPS_5007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102373, "NAD_1983_CORS96_StatePlane_Alaska_8_FIPS_5008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102374, "NAD_1983_CORS96_StatePlane_Alaska_9_FIPS_5009", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102375, "NAD_1983_CORS96_StatePlane_Alaska_10_FIPS_5010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102376, "NAD_1983_CORS96_StatePlane_Oregon_North_FIPS_3601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102377, "NAD_1983_CORS96_StatePlane_Oregon_South_FIPS_3602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102378, "NAD_1983_CORS96_StatePlane_Oregon_North_FIPS_3601_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102379, "NAD_1983_CORS96_StatePlane_Oregon_South_FIPS_3602_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102380, "NAD_1983_CORS96_Oregon_Statewide_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102381, "NAD_1983_CORS96_Oregon_Statewide_Lambert_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102389, "NAD_1983_Fargo_Ground_Coordinate_System", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102390, "NAD_1983_HARN_Fargo_Ground_Coordinate_System", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102391, "NAD_1983_2011_Fargo_Ground_Coordinate_System", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102392, "NAD_1983_2011_StatePlane_Alaska_4_FIPS_5004_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102393, "NAD_1983_2011_StatePlane_Alaska_5_FIPS_5005_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102394, "NAD_1983_2011_StatePlane_Alaska_6_FIPS_5006_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102395, "NAD_1983_2011_StatePlane_Alaska_7_FIPS_5007_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102396, "NAD_1983_2011_StatePlane_Alaska_8_FIPS_5008_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102397, "NAD_1983_2011_StatePlane_Alaska_9_FIPS_5009_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102398, "NAD_1983_2011_StatePlane_Alaska_10_FIPS_5010_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102401, "NAD_1983_CORS96_UTM_Zone_1N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102402, "NAD_1983_CORS96_UTM_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102403, "NAD_1983_CORS96_UTM_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102404, "NAD_1983_CORS96_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102405, "NAD_1983_CORS96_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102406, "NAD_1983_CORS96_UTM_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102407, "NAD_1983_CORS96_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102408, "NAD_1983_CORS96_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102409, "NAD_1983_CORS96_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102410, "NAD_1983_CORS96_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102411, "NAD_1983_CORS96_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102412, "NAD_1983_CORS96_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102413, "NAD_1983_CORS96_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102414, "NAD_1983_CORS96_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102415, "NAD_1983_CORS96_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102416, "NAD_1983_CORS96_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102417, "NAD_1983_CORS96_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102418, "NAD_1983_CORS96_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102419, "NAD_1983_CORS96_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102421, "WGS_1984_ARC_System_Zone_01", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102422, "WGS_1984_ARC_System_Zone_02", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102423, "WGS_1984_ARC_System_Zone_03", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102424, "WGS_1984_ARC_System_Zone_04", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102425, "WGS_1984_ARC_System_Zone_05", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102426, "WGS_1984_ARC_System_Zone_06", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102427, "WGS_1984_ARC_System_Zone_07", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102428, "WGS_1984_ARC_System_Zone_08", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102429, "WGS_1984_ARC_System_Zone_09", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102430, "WGS_1984_ARC_System_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102431, "WGS_1984_ARC_System_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102432, "WGS_1984_ARC_System_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102433, "WGS_1984_ARC_System_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102434, "WGS_1984_ARC_System_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102435, "WGS_1984_ARC_System_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102436, "WGS_1984_ARC_System_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102437, "WGS_1984_ARC_System_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102438, "WGS_1984_ARC_System_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102440, "LKS_1992_Latvia_TM_0", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102445, "NAD_1983_2011_StatePlane_Alaska_1_FIPS_5001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102446, "NAD_1983_2011_StatePlane_Alaska_2_FIPS_5002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102447, "NAD_1983_2011_StatePlane_Alaska_3_FIPS_5003_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102450, "NGO_1948_Oslo_Baerum_Kommune", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102451, "NGO_1948_Oslo_Bergenhalvoen", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102452, "NGO_1948_Oslo_Oslo_Kommune", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102461, "NAD_1983_HARN_StatePlane_Hawaii_1_FIPS_5101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102462, "NAD_1983_HARN_StatePlane_Hawaii_2_FIPS_5102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102464, "NAD_1983_HARN_StatePlane_Hawaii_4_FIPS_5104_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102465, "NAD_1983_HARN_StatePlane_Hawaii_5_FIPS_5105_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102470, "Cape_Lo15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102471, "Cape_Lo17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102472, "Cape_Lo19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102473, "Cape_Lo21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102474, "Cape_Lo23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102475, "Cape_Lo25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102476, "Cape_Lo27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102477, "Cape_Lo29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102478, "Cape_Lo31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102479, "Cape_Lo33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102480, "Hartebeesthoek94_Lo15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102481, "Hartebeesthoek94_Lo17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102482, "Hartebeesthoek94_Lo19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102483, "Hartebeesthoek94_Lo21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102484, "Hartebeesthoek94_Lo23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102485, "Hartebeesthoek94_Lo25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102486, "Hartebeesthoek94_Lo27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102487, "Hartebeesthoek94_Lo29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102488, "Hartebeesthoek94_Lo31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102489, "Hartebeesthoek94_Lo33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102491, "Nord_Algerie_Ancienne_Degree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102492, "Sud_Algerie_Ancienne_Degree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102493, "NAD_1983_PA11_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102494, "NAD_1983_PA11_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102495, "NAD_1983_MA11_Guam_Map_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102496, "NAD_1983_PA11_UTM_Zone_2S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102500, "OCRS_Baker_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102501, "OCRS_Bend-Burns_NAD_1983_CORS96_LCC_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102502, "OCRS_Bend-Klamath_Falls_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102503, "OCRS_Bend-Redmond-Prineville_NAD_1983_CORS96_LCC_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102504, "OCRS_Canyonville-Grants_Pass_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102505, "OCRS_Columbia_River_East_NAD_1983_CORS96_LCC_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102506, "OCRS_Columbia_River_West_NAD_1983_CORS96_OM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102507, "OCRS_Cottage_Grove-Canyonville_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102508, "OCRS_Dufur-Madras_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102509, "OCRS_Eugene_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102510, "OCRS_Grants_Pass-Ashland_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102511, "OCRS_Gresham-Warm_Springs_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102512, "OCRS_La_Grande_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102513, "OCRS_Ontario_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102514, "OCRS_Oregon_Coast_NAD_1983_CORS96_OM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102515, "OCRS_Pendleton-La_Grande_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102516, "OCRS_Pendleton_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102517, "OCRS_Portland_NAD_1983_CORS96_LCC_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102518, "OCRS_Salem_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102519, "OCRS_Santiam_Pass_NAD_1983_CORS96_TM_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102520, "NAD_1983_PA11_StatePlane_Hawaii_1_FIPS_5101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102521, "NAD_1983_PA11_StatePlane_Hawaii_2_FIPS_5102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102522, "NAD_1983_PA11_StatePlane_Hawaii_3_FIPS_5103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102523, "NAD_1983_PA11_StatePlane_Hawaii_4_FIPS_5104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102524, "NAD_1983_PA11_StatePlane_Hawaii_5_FIPS_5105", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102525, "NAD_1983_PA11_StatePlane_Hawaii_1_FIPS_5101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102526, "NAD_1983_PA11_StatePlane_Hawaii_2_FIPS_5102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102527, "NAD_1983_PA11_StatePlane_Hawaii_3_FIPS_5103_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102528, "NAD_1983_PA11_StatePlane_Hawaii_4_FIPS_5104_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102529, "NAD_1983_PA11_StatePlane_Hawaii_5_FIPS_5105_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102530, "OCRS_Baker_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102531, "OCRS_Bend-Burns_NAD_1983_CORS96_LCC_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102532, "OCRS_Bend-Klamath_Falls_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102533, "OCRS_Bend-Redmond-Prineville_NAD_1983_CORS96_LCC_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102534, "OCRS_Canyonville-Grants_Pass_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102535, "OCRS_Columbia_River_East_NAD_1983_CORS96_LCC_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102536, "OCRS_Columbia_River_West_NAD_1983_CORS96_OM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102537, "OCRS_Cottage_Grove-Canyonville_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102538, "OCRS_Dufur-Madras_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102539, "OCRS_Eugene_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102540, "OCRS_Grants_Pass-Ashland_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102541, "OCRS_Gresham-Warm_Springs_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102542, "OCRS_La_Grande_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102543, "OCRS_Ontario_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102544, "OCRS_Oregon_Coast_NAD_1983_CORS96_OM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102545, "OCRS_Pendleton-La_Grande_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102546, "OCRS_Pendleton_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102547, "OCRS_Portland_NAD_1983_CORS96_LCC_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102548, "OCRS_Salem_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102549, "OCRS_Santiam_Pass_NAD_1983_CORS96_TM_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102570, "WGS_1984_Complex_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102571, "WGS_1984_Complex_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102572, "WGS_1984_Complex_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102573, "WGS_1984_Complex_UTM_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102574, "WGS_1984_Complex_UTM_Zone_24N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102575, "WGS_1984_Complex_UTM_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102576, "WGS_1984_Complex_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102577, "WGS_1984_Complex_UTM_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102578, "WGS_1984_Complex_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102579, "WGS_1984_Complex_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102580, "WGS_1984_Complex_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102581, "NTF_France_I_degrees", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102582, "NTF_France_II_degrees", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102583, "NTF_France_III_degrees", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102584, "NTF_France_IV_degrees", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102585, "NTF_Lambert_Zone_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102586, "NTF_Lambert_Zone_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102587, "NTF_Lambert_Zone_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102588, "NTF_Lambert_Zone_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102589, "Panhandle_Energy_Albers", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102590, "Tananarive_1925_Laborde_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102591, "Nord_Algerie_Degree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102592, "Sud_Algerie_Degree", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102593, "JGD_2011_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102594, "JGD_2011_UTM_Zone_52N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102595, "JGD_2011_UTM_Zone_53N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102596, "JGD_2011_UTM_Zone_54N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102597, "JGD_2011_UTM_Zone_55N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102598, "JGD_2011_UTM_Zone_56N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102599, "WGS_1984_California_Teale_Albers_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102600, "NAD_1983_California_Teale_Albers_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102604, "NAD_1983_Georgia_Statewide_Lambert", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102605, "NAD_1983_Idaho_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102610, "JGD_2011_Japan_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102611, "JGD_2011_Japan_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102612, "JGD_2011_Japan_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102613, "JGD_2011_Japan_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102614, "JGD_2011_Japan_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102615, "JGD_2011_Japan_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102616, "JGD_2011_Japan_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102617, "JGD_2011_Japan_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102618, "JGD_2011_Japan_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102619, "JGD_2011_Japan_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102620, "JGD_2011_Japan_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102621, "JGD_2011_Japan_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102622, "JGD_2011_Japan_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102623, "JGD_2011_Japan_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102624, "JGD_2011_Japan_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102625, "JGD_2011_Japan_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102626, "JGD_2011_Japan_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102627, "JGD_2011_Japan_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102628, "JGD_2011_Japan_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102629, "NAD_1983_StatePlane_Alabama_East_FIPS_0101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102630, "NAD_1983_StatePlane_Alabama_West_FIPS_0102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102631, "NAD_1983_StatePlane_Alaska_1_FIPS_5001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102632, "NAD_1983_StatePlane_Alaska_2_FIPS_5002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102633, "NAD_1983_StatePlane_Alaska_3_FIPS_5003_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102634, "NAD_1983_StatePlane_Alaska_4_FIPS_5004_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102635, "NAD_1983_StatePlane_Alaska_5_FIPS_5005_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102636, "NAD_1983_StatePlane_Alaska_6_FIPS_5006_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102637, "NAD_1983_StatePlane_Alaska_7_FIPS_5007_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102638, "NAD_1983_StatePlane_Alaska_8_FIPS_5008_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102639, "NAD_1983_StatePlane_Alaska_9_FIPS_5009_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102640, "NAD_1983_StatePlane_Alaska_10_FIPS_5010_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102648, "NAD_1983_StatePlane_Arizona_East_FIPS_0201_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102649, "NAD_1983_StatePlane_Arizona_Central_FIPS_0202_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102650, "NAD_1983_StatePlane_Arizona_West_FIPS_0203_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102661, "NAD_1983_StatePlane_Hawaii_1_FIPS_5101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102662, "NAD_1983_StatePlane_Hawaii_2_FIPS_5102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102664, "NAD_1983_StatePlane_Hawaii_4_FIPS_5104_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102665, "NAD_1983_StatePlane_Hawaii_5_FIPS_5105_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102688, "NAD_1983_StatePlane_Michigan_North_FIPS_2111_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102689, "NAD_1983_StatePlane_Michigan_Central_FIPS_2112_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102690, "NAD_1983_StatePlane_Michigan_South_FIPS_2113_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102696, "NAD_1983_StatePlane_Missouri_East_FIPS_2401_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102697, "NAD_1983_StatePlane_Missouri_Central_FIPS_2402_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102698, "NAD_1983_StatePlane_Missouri_West_FIPS_2403_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102699, "NAD_1927_StatePlane_California_V_Ventura", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102700, "NAD_1983_StatePlane_Montana_FIPS_2500_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102701, "NAD_1983_PACP00_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102702, "NAD_1983_PACP00_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102703, "NAD_1983_PACP00_UTM_Zone_2S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102705, "NAD_1983_Nebraska_Lancaster_County_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102720, "NAD_1983_StatePlane_North_Dakota_North_FIPS_3301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102721, "NAD_1983_StatePlane_North_Dakota_South_FIPS_3302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102726, "NAD_1983_StatePlane_Oregon_North_FIPS_3601_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102727, "NAD_1983_StatePlane_Oregon_South_FIPS_3602_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102733, "NAD_1983_StatePlane_South_Carolina_FIPS_3900_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102761, "NAD_1983_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102766, "NAD_1983_StatePlane_Guam_FIPS_5400_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102962, "NAD_1983_2011_California_Teale_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102963, "NAD_1983_2011_Mississippi_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102964, "NAD_1983_2011_Virginia_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102966, "NAD_1983_2011_Alaska_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102967, "NAD_1983_2011_Florida_GDL_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102968, "NAD_1983_2011_Michigan_GeoRef_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102969, "NAD_1983_2011_Oregon_Statewide_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102970, "NAD_1983_2011_Oregon_Statewide_Lambert_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102971, "NAD_1983_2011_Texas_Centric_Mapping_System_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102972, "NAD_1983_2011_Texas_Centric_Mapping_System_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102973, "NAD_1983_2011_Wisconsin_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102974, "NAD_1983_2011_Wisconsin_TM_US_Ft", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102975, "NAD_1983_2011_StatePlane_Alabama_East_FIPS_0101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102976, "NAD_1983_2011_StatePlane_Alabama_West_FIPS_0102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102977, "NAD_1983_2011_StatePlane_Alaska_1_FIPS_5001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102978, "NAD_1983_2011_StatePlane_Alaska_2_FIPS_5002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102979, "NAD_1983_2011_StatePlane_Alaska_3_FIPS_5003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102980, "NAD_1983_2011_StatePlane_Alaska_4_FIPS_5004", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102981, "NAD_1983_2011_StatePlane_Alaska_5_FIPS_5005", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102982, "NAD_1983_2011_StatePlane_Alaska_6_FIPS_5006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102983, "NAD_1983_2011_StatePlane_Alaska_7_FIPS_5007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102984, "NAD_1983_2011_StatePlane_Alaska_8_FIPS_5008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102985, "NAD_1983_2011_StatePlane_Alaska_9_FIPS_5009", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102986, "NAD_1983_2011_StatePlane_Alaska_10_FIPS_5010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102987, "NAD_1983_2011_StatePlane_Arizona_East_FIPS_0201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102988, "NAD_1983_2011_StatePlane_Arizona_Central_FIPS_0202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102989, "NAD_1983_2011_StatePlane_Arizona_West_FIPS_0203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102990, "NAD_1983_2011_StatePlane_Arizona_East_FIPS_0201_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102991, "NAD_1983_2011_StatePlane_Arizona_Central_FIPS_0202_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102992, "NAD_1983_2011_StatePlane_Arizona_West_FIPS_0203_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102993, "NAD_1983_2011_StatePlane_Arkansas_North_FIPS_0301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102994, "NAD_1983_2011_StatePlane_Arkansas_South_FIPS_0302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102995, "NAD_1983_2011_StatePlane_Arkansas_North_FIPS_0301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102996, "NAD_1983_2011_StatePlane_Arkansas_South_FIPS_0302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102997, "NAD_1983_2011_StatePlane_California_I_FIPS_0401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102998, "NAD_1983_2011_StatePlane_California_II_FIPS_0402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 102999, "NAD_1983_2011_StatePlane_California_III_FIPS_0403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103000, "NAD_1983_2011_StatePlane_California_IV_FIPS_0404", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103001, "NAD_1983_2011_StatePlane_California_V_FIPS_0405", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 103002, "NAD_1983_2011_StatePlane_California_VI_FIPS_0406", "Meter", 1.0));
        }
    }

    private static class PCS_3 {
        private PCS_3() {
        }

        static void add(List<CoordinateSystem> list) {
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5572, "Ukraine_2000_3_Degree_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5573, "Ukraine_2000_3_Degree_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5574, "Ukraine_2000_3_Degree_GK_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5575, "Ukraine_2000_3_Degree_GK_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5576, "Ukraine_2000_3_Degree_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5577, "Ukraine_2000_3_Degree_GK_CM_21E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5578, "Ukraine_2000_3_Degree_GK_CM_24E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5579, "Ukraine_2000_3_Degree_GK_CM_27E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5580, "Ukraine_2000_3_Degree_GK_CM_30E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5581, "Ukraine_2000_3_Degree_GK_CM_33E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5582, "Ukraine_2000_3_Degree_GK_CM_36E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5583, "Ukraine_2000_3_Degree_GK_CM_39E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5588, "NAD_1927_New_Brunswick_Stereographic", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5589, "Sibun_Gorge_1922_Colony_Grid", "Foot_Clarke", 0.3047972654));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5596, "FEH2010_Fehmarnbelt_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5623, "NAD_1927_StatePlane_Michigan_East_Old_FIPS_2101", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5624, "NAD_1927_StatePlane_Michigan_Central_Old_FIPS_2102", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5625, "NAD_1927_StatePlane_Michigan_West_Old_FIPS_2103", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5627, "ED_1950_TM_6_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5629, "Moznet_UTM_Zone_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5631, "Pulkovo_1942_Adj_1958_GK_Zone_2_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5632, "PTRA08_LCC_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5633, "PTRA08_LAEA_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5634, "REGCAN95_LCC_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5635, "REGCAN95_LAEA_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5636, "TUREF_LAEA_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5637, "TUREF_LCC_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5638, "ISN_2004_LAEA_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5639, "ISN_2004_LCC_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5641, "SIRGAS_2000_Brazil_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5643, "ED_1950_Southern_Permian_Basin_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5644, "RGR_1992_UTM_39S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5646, "NAD_1983_StatePlane_Vermont_FIPS_4400_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5649, "ETRS_1989_UTM_Zone_31N_zE-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5650, "ETRS_1989_UTM_Zone_33N_zE-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5651, "ETRS_1989_UTM_Zone_31N_N-zE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5652, "ETRS_1989_UTM_Zone_32N_N-zE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5653, "ETRS_1989_UTM_Zone_33N_N-zE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5654, "NAD_1983_HARN_StatePlane_Vermont_FIPS_4400_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5655, "NAD_1983_NSRS2007_StatePlane_Vermont_FIPS_4400_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5659, "Monte_Mario_TM_Emilia-Romagna", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5663, "Pulkovo_1942_Adj_1958_GK_Zone_3_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5664, "Pulkovo_1942_Adj_1983_GK_Zone_2_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5665, "Pulkovo_1942_Adj_1983_GK_Zone_3_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5666, "PD/83_3_Degree_GK_Zone_3_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5667, "PD/83_3_Degree_GK_Zone_4_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5668, "RD/83_3_Degree_GK_Zone_4_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5669, "RD/83_3_Degree_GK_Zone_5_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5670, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_3_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5671, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_4_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5672, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_5_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5673, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_3_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5674, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_4_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5675, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_5_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5676, "DHDN_3_Degree_GK_Zone_2_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5677, "DHDN_3_Degree_GK_Zone_3_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5678, "DHDN_3_Degree_GK_Zone_4_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5679, "DHDN_3_Degree_GK_Zone_5_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5680, "DHDN_3_Degree_GK_Zone_1_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5682, "DB_REF_3-Degree_GK_Zone_2_(E-N)", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5683, "DB_REF_3-Degree_GK_Zone_3_(E-N)", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5684, "DB_REF_3-Degree_GK_Zone_4_(E-N)", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5685, "DB_REF_3-Degree_GK_Zone_5_(E-N)", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5700, "NZGD_2000_UTM_Zone_1S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5825, "AGD_1966_ACT_Standard_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5836, "Yemen_NGN_1996_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5837, "Yemen_NGN_1996_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5839, "Peru96_UTM_Zone_17S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5842, "WGS_1984_TM_12_SE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5844, "RGRDC_2005_Congo_TM_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5858, "SAD_1969_96_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5875, "SAD_1969_96_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5876, "SAD_1969_96_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5877, "SAD_1969_96_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5879, "Cadastre_1997_UTM_Zone_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5880, "SIRGAS_2000_Brazil_Polyconic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5887, "TGD2005_Tonga_Map_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5890, "JAXA_Snow_Depth_Polar_Stereographic_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5921, "WGS_1984_EPSG_Arctic_Regional_zone_A1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5922, "WGS_1984_EPSG_Arctic_Regional_zone_A2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5923, "WGS_1984_EPSG_Arctic_Regional_zone_A3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5924, "WGS_1984_EPSG_Arctic_Regional_zone_A4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5925, "WGS_1984_EPSG_Arctic_Regional_zone_A5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5926, "WGS_1984_EPSG_Arctic_Regional_zone_B1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5927, "WGS_1984_EPSG_Arctic_Regional_zone_B2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5928, "WGS_1984_EPSG_Arctic_Regional_zone_B3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5929, "WGS_1984_EPSG_Arctic_Regional_zone_B4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5930, "WGS_1984_EPSG_Arctic_Regional_zone_B5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5931, "WGS_1984_EPSG_Arctic_Regional_zone_C1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5932, "WGS_1984_EPSG_Arctic_Regional_zone_C2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5933, "WGS_1984_EPSG_Arctic_Regional_zone_C3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5934, "WGS_1984_EPSG_Arctic_Regional_zone_C4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5935, "WGS_1984_EPSG_Arctic_Regional_zone_C5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5936, "WGS_1984_EPSG_Alaska_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5937, "WGS_1984_EPSG_Canada_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5938, "WGS_1984_EPSG_Greenland_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5939, "WGS_1984_EPSG_Norway_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5940, "WGS_1984_EPSG_Russia_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6050, "GR96_EPSG_Arctic_zone_1-25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6051, "GR96_EPSG_Arctic_zone_2-18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6052, "GR96_EPSG_Arctic_zone_2-20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6053, "GR96_EPSG_Arctic_zone_3-29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6054, "GR96_EPSG_Arctic_zone_3-31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6055, "GR96_EPSG_Arctic_zone_3-33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6056, "GR96_EPSG_Arctic_zone_4-20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6057, "GR96_EPSG_Arctic_zone_4-22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6058, "GR96_EPSG_Arctic_zone_4-24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6059, "GR96_EPSG_Arctic_zone_5-41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6060, "GR96_EPSG_Arctic_zone_5-43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6061, "GR96_EPSG_Arctic_zone_5-45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6062, "GR96_EPSG_Arctic_zone_6-26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6063, "GR96_EPSG_Arctic_zone_6-28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6064, "GR96_EPSG_Arctic_zone_6-30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6065, "GR96_EPSG_Arctic_zone_7-11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6066, "GR96_EPSG_Arctic_zone_7-13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6067, "GR96_EPSG_Arctic_zone_8-20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6068, "GR96_EPSG_Arctic_zone_8-22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6069, "ETRS_1989_EPSG_Arctic_zone_2-22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6070, "ETRS_1989_EPSG_Arctic_zone_3-11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6071, "ETRS_1989_EPSG_Arctic_zone_4-26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6072, "ETRS_1989_EPSG_Arctic_zone_4-28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6073, "ETRS_1989_EPSG_Arctic_zone_5-11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6074, "ETRS_1989_EPSG_Arctic_zone_5-13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6075, "WGS_1984_EPSG_Arctic_zone_2-24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6076, "WGS_1984_EPSG_Arctic_zone_2-26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6077, "WGS_1984_EPSG_Arctic_zone_3-13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6078, "WGS_1984_EPSG_Arctic_zone_3-15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6079, "WGS_1984_EPSG_Arctic_zone_3-17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6080, "WGS_1984_EPSG_Arctic_zone_3-19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6081, "WGS_1984_EPSG_Arctic_zone_4-30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6082, "WGS_1984_EPSG_Arctic_zone_4-32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6083, "WGS_1984_EPSG_Arctic_zone_4-34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6084, "WGS_1984_EPSG_Arctic_zone_4-36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6085, "WGS_1984_EPSG_Arctic_zone_4-38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6086, "WGS_1984_EPSG_Arctic_zone_4-40", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6087, "WGS_1984_EPSG_Arctic_zone_5-15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6088, "WGS_1984_EPSG_Arctic_zone_5-17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6089, "WGS_1984_EPSG_Arctic_zone_5-19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6090, "WGS_1984_EPSG_Arctic_zone_5-21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6091, "WGS_1984_EPSG_Arctic_zone_5-23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6092, "WGS_1984_EPSG_Arctic_zone_5-25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6093, "WGS_1984_EPSG_Arctic_zone_5-27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6094, "NAD_1983_NSRS2007_EPSG_Arctic_zone_5-29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6095, "NAD_1983_NSRS2007_EPSG_Arctic_zone_5-31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6096, "NAD_1983_NSRS2007_EPSG_Arctic_zone_6-14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6097, "NAD_1983_NSRS2007_EPSG_Arctic_zone_6-16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6098, "NAD_1983_CSRS_EPSG_Arctic_zone_1-23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6099, "NAD_1983_CSRS_EPSG_Arctic_zone_2-14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6100, "NAD_1983_CSRS_EPSG_Arctic_zone_2-16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6101, "NAD_1983_CSRS_EPSG_Arctic_zone_3-25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6102, "NAD_1983_CSRS_EPSG_Arctic_zone_3-27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6103, "NAD_1983_CSRS_EPSG_Arctic_zone_3-29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6104, "NAD_1983_CSRS_EPSG_Arctic_zone_4-14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6105, "NAD_1983_CSRS_EPSG_Arctic_zone_4-16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6106, "NAD_1983_CSRS_EPSG_Arctic_zone_4-18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6107, "NAD_1983_CSRS_EPSG_Arctic_zone_5-33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6108, "NAD_1983_CSRS_EPSG_Arctic_zone_5-35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6109, "NAD_1983_CSRS_EPSG_Arctic_zone_5-37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6110, "NAD_1983_CSRS_EPSG_Arctic_zone_5-39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6111, "NAD_1983_CSRS_EPSG_Arctic_zone_6-18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6112, "NAD_1983_CSRS_EPSG_Arctic_zone_6-20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6113, "NAD_1983_CSRS_EPSG_Arctic_zone_6-22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6114, "NAD_1983_CSRS_EPSG_Arctic_zone_6-24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6115, "WGS_1984_EPSG_Arctic_zone_1-27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6116, "WGS_1984_EPSG_Arctic_zone_1-29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6117, "WGS_1984_EPSG_Arctic_zone_1-31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6118, "WGS_1984_EPSG_Arctic_zone_1-21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6119, "WGS_1984_EPSG_Arctic_zone_2-28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6120, "WGS_1984_EPSG_Arctic_zone_2-10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6121, "WGS_1984_EPSG_Arctic_zone_2-12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6122, "WGS_1984_EPSG_Arctic_zone_3-21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6123, "WGS_1984_EPSG_Arctic_zone_3-23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6124, "WGS_1984_EPSG_Arctic_zone_4-12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6125, "ETRS_1989_EPSG_Arctic_zone_5-47", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6128, "Grand_Cayman_National_Grid_1959", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6129, "Sister_Islands_National_Grid_1961", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6210, "SIRGAS_2000_UTM_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6211, "SIRGAS_2000_UTM_Zone_24N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6244, "MAGNA_Arauca_2007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6245, "MAGNA_Armenia_Quindio_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6246, "MAGNA_Barranquilla_Atlantico_1997", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6247, "MAGNA_Bogota_DC_2005", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6248, "MAGNA_Bucaramanga_Santander_2008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6249, "MAGNA_Cali_Valle_del_Cauca_2009", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6250, "MAGNA_Cartagena_Bolivar_2005", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6251, "MAGNA_Cucuta_Norte_de_Santander_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6252, "MAGNA_Florencia_Caqueta_2007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6253, "MAGNA_Ibague_Tolima_2007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6254, "MAGNA_Inirida_Guainia_2008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6255, "MAGNA_Leticia_Amazonas_1994", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6256, "MAGNA_Manizales_Caldas_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6257, "MAGNA_Medellin_Antioquia_2010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6258, "MAGNA_Mitu_Vaupes_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6259, "MAGNA_Mocoa_Putumayo_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6260, "MAGNA_Monteria_Cordoba_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6261, "MAGNA_Neiva_Huila_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6262, "MAGNA_Pasto_Narino_2008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6263, "MAGNA_Pereira_Risaralda_2007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6264, "MAGNA_Popayan_Cauca_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6265, "MAGNA_Puerto_Carreno_Vichada_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6266, "MAGNA_Quibdo_Choco_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6267, "MAGNA_Riohacha_La_Guajira_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6268, "MAGNA_San_Andres_2007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6269, "MAGNA_San_Jose_del_Guaviare_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6270, "MAGNA_Santa_Marta_Magdalena_2007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6271, "MAGNA_Sucre_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6272, "MAGNA_Tunja_Boyaca_1997", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6273, "MAGNA_Valledupar_Cesar_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6274, "MAGNA_Villavicencio_Meta_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6275, "MAGNA_Yopal_Casanare_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6316, "Macedonia_State_Coordinate_System_zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6328, "NAD_1983_2011_UTM_Zone_59N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6329, "NAD_1983_2011_UTM_Zone_60N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6330, "NAD_1983_2011_UTM_Zone_1N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6331, "NAD_1983_2011_UTM_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6332, "NAD_1983_2011_UTM_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6333, "NAD_1983_2011_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6334, "NAD_1983_2011_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6335, "NAD_1983_2011_UTM_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6336, "NAD_1983_2011_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6337, "NAD_1983_2011_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6338, "NAD_1983_2011_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6339, "NAD_1983_2011_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6340, "NAD_1983_2011_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6341, "NAD_1983_2011_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6342, "NAD_1983_2011_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6343, "NAD_1983_2011_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6344, "NAD_1983_2011_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6345, "NAD_1983_2011_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6346, "NAD_1983_2011_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6347, "NAD_1983_2011_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6348, "NAD_1983_2011_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6350, "NAD_1983_2011_Contiguous_USA_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6351, "NAD_1983_2011_EPSG_Arctic_zone_5-29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6352, "NAD_1983_2011_EPSG_Arctic_zone_5-31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6353, "NAD_1983_2011_EPSG_Arctic_zone_6-14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6354, "NAD_1983_2011_EPSG_Arctic_zone_6-16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 6391, "Cayman_Islands_National_Grid_2011", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20002, "Pulkovo_1995_GK_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20003, "Pulkovo_1995_GK_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20004, "Pulkovo_1995_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20005, "Pulkovo_1995_GK_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20006, "Pulkovo_1995_GK_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20007, "Pulkovo_1995_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20008, "Pulkovo_1995_GK_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20009, "Pulkovo_1995_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20010, "Pulkovo_1995_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20011, "Pulkovo_1995_GK_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20012, "Pulkovo_1995_GK_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20013, "Pulkovo_1995_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20014, "Pulkovo_1995_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20015, "Pulkovo_1995_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20016, "Pulkovo_1995_GK_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20017, "Pulkovo_1995_GK_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20018, "Pulkovo_1995_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20019, "Pulkovo_1995_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20020, "Pulkovo_1995_GK_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20021, "Pulkovo_1995_GK_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20022, "Pulkovo_1995_GK_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20023, "Pulkovo_1995_GK_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20024, "Pulkovo_1995_GK_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20025, "Pulkovo_1995_GK_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20026, "Pulkovo_1995_GK_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20027, "Pulkovo_1995_GK_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20028, "Pulkovo_1995_GK_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20029, "Pulkovo_1995_GK_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20030, "Pulkovo_1995_GK_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20031, "Pulkovo_1995_GK_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20032, "Pulkovo_1995_GK_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20062, "Pulkovo_1995_GK_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20063, "Pulkovo_1995_GK_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20064, "Pulkovo_1995_GK_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20065, "Pulkovo_1995_GK_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20066, "Pulkovo_1995_GK_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20067, "Pulkovo_1995_GK_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20068, "Pulkovo_1995_GK_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20069, "Pulkovo_1995_GK_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20070, "Pulkovo_1995_GK_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20071, "Pulkovo_1995_GK_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20072, "Pulkovo_1995_GK_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20073, "Pulkovo_1995_GK_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20074, "Pulkovo_1995_GK_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20075, "Pulkovo_1995_GK_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20076, "Pulkovo_1995_GK_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20077, "Pulkovo_1995_GK_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20078, "Pulkovo_1995_GK_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20079, "Pulkovo_1995_GK_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20080, "Pulkovo_1995_GK_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20081, "Pulkovo_1995_GK_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20082, "Pulkovo_1995_GK_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20083, "Pulkovo_1995_GK_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20084, "Pulkovo_1995_GK_Zone_24N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20085, "Pulkovo_1995_GK_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20086, "Pulkovo_1995_GK_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20087, "Pulkovo_1995_GK_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20088, "Pulkovo_1995_GK_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20089, "Pulkovo_1995_GK_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20090, "Pulkovo_1995_GK_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20091, "Pulkovo_1995_GK_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20092, "Pulkovo_1995_GK_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20135, "Adindan_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20136, "Adindan_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20137, "Adindan_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20138, "Adindan_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20248, "AGD_1966_AMG_Zone_48", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20249, "AGD_1966_AMG_Zone_49", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20250, "AGD_1966_AMG_Zone_50", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20251, "AGD_1966_AMG_Zone_51", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20252, "AGD_1966_AMG_Zone_52", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20253, "AGD_1966_AMG_Zone_53", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20254, "AGD_1966_AMG_Zone_54", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20255, "AGD_1966_AMG_Zone_55", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20256, "AGD_1966_AMG_Zone_56", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20257, "AGD_1966_AMG_Zone_57", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20258, "AGD_1966_AMG_Zone_58", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20348, "AGD_1984_AMG_Zone_48", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20349, "AGD_1984_AMG_Zone_49", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20350, "AGD_1984_AMG_Zone_50", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20351, "AGD_1984_AMG_Zone_51", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20352, "AGD_1984_AMG_Zone_52", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20353, "AGD_1984_AMG_Zone_53", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20354, "AGD_1984_AMG_Zone_54", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20355, "AGD_1984_AMG_Zone_55", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20356, "AGD_1984_AMG_Zone_56", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20357, "AGD_1984_AMG_Zone_57", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20358, "AGD_1984_AMG_Zone_58", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20436, "Ain_el_Abd_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20437, "Ain_el_Abd_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20438, "Ain_el_Abd_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20439, "Ain_el_Abd_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20440, "Ain_el_Abd_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20499, "Bahrain_State_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20538, "Afgooye_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20539, "Afgooye_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20790, "Portuguese_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20791, "Lisbon_Lisbon_Portuguese_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20822, "Aratu_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20823, "Aratu_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20824, "Aratu_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20934, "Arc_1950_UTM_Zone_34S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20935, "Arc_1950_UTM_Zone_35S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 20936, "Arc_1950_UTM_Zone_36S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21035, "Arc_1960_UTM_Zone_35S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21036, "Arc_1960_UTM_Zone_36S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21037, "Arc_1960_UTM_Zone_37S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21095, "Arc_1960_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21096, "Arc_1960_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21097, "Arc_1960_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21148, "Batavia_UTM_Zone_48S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21149, "Batavia_UTM_Zone_49S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21150, "Batavia_UTM_Zone_50S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21291, "Barbados_1938_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21292, "Barbados_1938_Barbados_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21413, "Beijing_1954_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21414, "Beijing_1954_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21415, "Beijing_1954_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21416, "Beijing_1954_GK_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21417, "Beijing_1954_GK_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21418, "Beijing_1954_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21419, "Beijing_1954_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21420, "Beijing_1954_GK_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21421, "Beijing_1954_GK_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21422, "Beijing_1954_GK_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21423, "Beijing_1954_GK_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21473, "Beijing_1954_GK_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21474, "Beijing_1954_GK_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21475, "Beijing_1954_GK_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21476, "Beijing_1954_GK_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21477, "Beijing_1954_GK_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21478, "Beijing_1954_GK_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21479, "Beijing_1954_GK_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21480, "Beijing_1954_GK_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21481, "Beijing_1954_GK_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21482, "Beijing_1954_GK_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21483, "Beijing_1954_GK_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21500, "Belge_Lambert_1950", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21780, "Bern_1898_Bern_LV03C", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21781, "CH1903_LV03", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21782, "CH1903_LV03C-G", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21817, "Bogota_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21818, "Bogota_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21896, "Colombia_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21897, "Colombia_Bogota_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21898, "Colombia_East_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 21899, "Colombia_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22032, "Camacupa_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22033, "Camacupa_UTM_Zone_33S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22091, "Camacupa_TM_11_30_SE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22092, "Camacupa_TM_12_SE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22171, "POSGAR_1998_Argentina_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22172, "POSGAR_1998_Argentina_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22173, "POSGAR_1998_Argentina_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22174, "POSGAR_1998_Argentina_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22175, "POSGAR_1998_Argentina_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22176, "POSGAR_1998_Argentina_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22177, "POSGAR_1998_Argentina_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22181, "POSGAR_1994_Argentina_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22182, "POSGAR_1994_Argentina_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22183, "POSGAR_1994_Argentina_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22184, "POSGAR_1994_Argentina_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22185, "POSGAR_1994_Argentina_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22186, "POSGAR_1994_Argentina_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22187, "POSGAR_1994_Argentina_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22191, "Argentina_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22192, "Argentina_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22193, "Argentina_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22194, "Argentina_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22195, "Argentina_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22196, "Argentina_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22197, "Argentina_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22234, "Cape_UTM_Zone_34S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22235, "Cape_UTM_Zone_35S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22236, "Cape_UTM_Zone_36S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22332, "Carthage_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22391, "Nord_Tunisie", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22392, "Sud_Tunisie", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22521, "Corrego_Alegre_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22522, "Corrego_Alegre_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22523, "Corrego_Alegre_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22524, "Corrego_Alegre_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22525, "Corrego_Alegre_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22700, "Deir_ez_Zor_Levant_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22770, "Deir_ez_Zor_Syria_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22780, "Deir_ez_Zor_Levant_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22832, "Douala_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22991, "Egypt_Blue_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22992, "Egypt_Red_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22993, "Egypt_Purple_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 22994, "Egypt_Extended_Purple_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23028, "ED_1950_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23029, "ED_1950_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23030, "ED_1950_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23031, "ED_1950_UTM_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23032, "ED_1950_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23033, "ED_1950_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23034, "ED_1950_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23035, "ED_1950_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23036, "ED_1950_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23037, "ED_1950_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23038, "ED_1950_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23090, "ED_1950_TM_0_N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23095, "ED_1950_TM_5_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23239, "Fahud_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23240, "Fahud_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23700, "Hungarian_1972_Egyseges_Orszagos_Vetuleti", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23830, "DGN_1995_Indonesia_TM-3_Zone_46.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23831, "DGN_1995_Indonesia_TM-3_Zone_47.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23832, "DGN_1995_Indonesia_TM-3_Zone_47.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23833, "DGN_1995_Indonesia_TM-3_Zone_48.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23834, "DGN_1995_Indonesia_TM-3_Zone_48.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23835, "DGN_1995_Indonesia_TM-3_Zone_49.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23836, "DGN_1995_Indonesia_TM-3_Zone_49.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23837, "DGN_1995_Indonesia_TM-3_Zone_50.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23838, "DGN_1995_Indonesia_TM-3_Zone_50.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23839, "DGN_1995_Indonesia_TM-3_Zone_51.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23840, "DGN_1995_Indonesia_TM-3_Zone_51.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23841, "DGN_1995_Indonesia_TM-3_Zone_52.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23842, "DGN_1995_Indonesia_TM-3_Zone_52.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23843, "DGN_1995_Indonesia_TM-3_Zone_53.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23844, "DGN_1995_Indonesia_TM-3_Zone_53.2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23845, "DGN_1995_Indonesia_TM-3_Zone_54.1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23846, "Indonesian_1974_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23847, "Indonesian_1974_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23848, "Indonesian_1974_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23849, "Indonesian_1974_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23850, "Indonesian_1974_UTM_Zone_50N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23851, "Indonesian_1974_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23852, "Indonesian_1974_UTM_Zone_52N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23853, "Indonesian_1974_UTM_Zone_53N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23866, "DGN_1995_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23867, "DGN_1995_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23868, "DGN_1995_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23869, "DGN_1995_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23870, "DGN_1995_UTM_Zone_50N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23871, "DGN_1995_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23872, "DGN_1995_UTM_Zone_52N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23877, "DGN_1995_UTM_Zone_47S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23878, "DGN_1995_UTM_Zone_48S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23879, "DGN_1995_UTM_Zone_49S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23880, "DGN_1995_UTM_Zone_50S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23881, "DGN_1995_UTM_Zone_51S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23882, "DGN_1995_UTM_Zone_52S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23883, "DGN_1995_UTM_Zone_53S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23884, "DGN_1995_UTM_Zone_54S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23886, "Indonesian_1974_UTM_Zone_46S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23887, "Indonesian_1974_UTM_Zone_47S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23888, "Indonesian_1974_UTM_Zone_48S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23889, "Indonesian_1974_UTM_Zone_49S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23890, "Indonesian_1974_UTM_Zone_50S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23891, "Indonesian_1974_UTM_Zone_51S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23892, "Indonesian_1974_UTM_Zone_52S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23893, "Indonesian_1974_UTM_Zone_53S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23894, "Indonesian_1974_UTM_Zone_54S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23946, "Indian_1954_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23947, "Indian_1954_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 23948, "Indian_1954_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24047, "Indian_1975_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24048, "Indian_1975_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24100, "Jamaica_1875_Old_Grid", "Foot_Clarke", 0.3047972654));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24200, "Jamaica_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24305, "Kalianpur_1937_UTM_Zone_45N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24306, "Kalianpur_1937_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24311, "Kalianpur_1962_UTM_Zone_41N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24312, "Kalianpur_1962_UTM_Zone_42N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24313, "Kalianpur_1962_UTM_Zone_43N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24342, "Kalianpur_1975_UTM_Zone_42N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24343, "Kalianpur_1975_UTM_Zone_43N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24344, "Kalianpur_1975_UTM_Zone_44N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24345, "Kalianpur_1975_UTM_Zone_45N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24346, "Kalianpur_1975_UTM_Zone_46N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24347, "Kalianpur_1975_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24370, "Kalianpur_1880_India_Zone_0", "Yard_Indian", 0.9143985307444408));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24371, "Kalianpur_1880_India_Zone_I", "Yard_Indian", 0.9143985307444408));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24372, "Kalianpur_1880_India_Zone_IIa", "Yard_Indian", 0.9143985307444408));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24373, "Kalianpur_1880_India_Zone_III", "Yard_Indian", 0.9143985307444408));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24374, "Kalianpur_1880_India_Zone_IV", "Yard_Indian", 0.9143985307444408));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24375, "Kalianpur_1937_India_Zone_IIb", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24376, "Kalianpur_1962_India_Zone_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24377, "Kalianpur_1962_India_Zone_IIa", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24378, "Kalianpur_1975_India_Zone_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24379, "Kalianpur_1975_India_Zone_IIa", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24380, "Kalianpur_1975_India_Zone_IIb", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24381, "Kalianpur_1975_India_Zone_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24382, "Kalianpur_1880_India_Zone_IIb", "Yard_Indian", 0.9143985307444408));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24383, "Kalianpur_1975_India_Zone_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24500, "Kertau_Singapore_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24547, "Kertau_UTM_Zone_47N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24548, "Kertau_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24571, "Kertau_RSO_Malaya_Chains", "Chain_Benoit_1895_B", 20.11678249437587));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24600, "KOC_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24718, "La_Canoa_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24719, "La_Canoa_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24720, "La_Canoa_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24721, "La_Canoa_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24817, "PSAD_1956_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24818, "PSAD_1956_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24819, "PSAD_1956_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24820, "PSAD_1956_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24821, "PSAD_1956_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24877, "PSAD_1956_UTM_Zone_17S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24878, "PSAD_1956_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24879, "PSAD_1956_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24880, "PSAD_1956_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24881, "PSAD_1956_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24882, "PSAD_1956_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24891, "Peru_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24892, "Peru_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 24893, "Peru_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25000, "Ghana_Metre_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25231, "Lome_UTM_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25391, "Philippines_Zone_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25392, "Philippines_Zone_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25393, "Philippines_Zone_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25394, "Philippines_Zone_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25395, "Philippines_Zone_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25828, "ETRS_1989_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25829, "ETRS_1989_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25830, "ETRS_1989_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25831, "ETRS_1989_UTM_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25832, "ETRS_1989_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25833, "ETRS_1989_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25834, "ETRS_1989_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25835, "ETRS_1989_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25836, "ETRS_1989_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25837, "ETRS_1989_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25838, "ETRS_1989_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25884, "ETRS_1989_TM_Baltic_1993", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 25932, "Malongo_1987_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26191, "Nord_Maroc", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26192, "Sud_Maroc", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26193, "Sahara", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26194, "Merchich_Sahara_Nord", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26195, "Merchich_Sahara_Sud", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26237, "Massawa_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26331, "Minna_UTM_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26332, "Minna_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26391, "Nigeria_West_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26392, "Nigeria_Mid_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26393, "Nigeria_East_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26591, "Monte_Mario_Rome_Italy_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26592, "Monte_Mario_Rome_Italy_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26632, "Mporaloko_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26692, "Mporaloko_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26701, "NAD_1927_UTM_Zone_1N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26702, "NAD_1927_UTM_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26703, "NAD_1927_UTM_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26704, "NAD_1927_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26705, "NAD_1927_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26706, "NAD_1927_UTM_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26707, "NAD_1927_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26708, "NAD_1927_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26709, "NAD_1927_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26710, "NAD_1927_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26711, "NAD_1927_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26712, "NAD_1927_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26713, "NAD_1927_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26714, "NAD_1927_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26715, "NAD_1927_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26716, "NAD_1927_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26717, "NAD_1927_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26718, "NAD_1927_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26719, "NAD_1927_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26720, "NAD_1927_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26721, "NAD_1927_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26722, "NAD_1927_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26729, "NAD_1927_StatePlane_Alabama_East_FIPS_0101", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26730, "NAD_1927_StatePlane_Alabama_West_FIPS_0102", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26731, "NAD_1927_StatePlane_Alaska_1_FIPS_5001", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26732, "NAD_1927_StatePlane_Alaska_2_FIPS_5002", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26733, "NAD_1927_StatePlane_Alaska_3_FIPS_5003", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26734, "NAD_1927_StatePlane_Alaska_4_FIPS_5004", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26735, "NAD_1927_StatePlane_Alaska_5_FIPS_5005", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26736, "NAD_1927_StatePlane_Alaska_6_FIPS_5006", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26737, "NAD_1927_StatePlane_Alaska_7_FIPS_5007", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26738, "NAD_1927_StatePlane_Alaska_8_FIPS_5008", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26739, "NAD_1927_StatePlane_Alaska_9_FIPS_5009", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26740, "NAD_1927_StatePlane_Alaska_10_FIPS_5010", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26741, "NAD_1927_StatePlane_California_I_FIPS_0401", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26742, "NAD_1927_StatePlane_California_II_FIPS_0402", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26743, "NAD_1927_StatePlane_California_III_FIPS_0403", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26744, "NAD_1927_StatePlane_California_IV_FIPS_0404", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26745, "NAD_1927_StatePlane_California_V_FIPS_0405", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26746, "NAD_1927_StatePlane_California_VI_FIPS_0406", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26748, "NAD_1927_StatePlane_Arizona_East_FIPS_0201", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26749, "NAD_1927_StatePlane_Arizona_Central_FIPS_0202", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26750, "NAD_1927_StatePlane_Arizona_West_FIPS_0203", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26751, "NAD_1927_StatePlane_Arkansas_North_FIPS_0301", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26752, "NAD_1927_StatePlane_Arkansas_South_FIPS_0302", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26753, "NAD_1927_StatePlane_Colorado_North_FIPS_0501", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26754, "NAD_1927_StatePlane_Colorado_Central_FIPS_0502", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26755, "NAD_1927_StatePlane_Colorado_South_FIPS_0503", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26756, "NAD_1927_StatePlane_Connecticut_FIPS_0600", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26757, "NAD_1927_StatePlane_Delaware_FIPS_0700", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26758, "NAD_1927_StatePlane_Florida_East_FIPS_0901", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26759, "NAD_1927_StatePlane_Florida_West_FIPS_0902", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26760, "NAD_1927_StatePlane_Florida_North_FIPS_0903", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26766, "NAD_1927_StatePlane_Georgia_East_FIPS_1001", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26767, "NAD_1927_StatePlane_Georgia_West_FIPS_1002", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26768, "NAD_1927_StatePlane_Idaho_East_FIPS_1101", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26769, "NAD_1927_StatePlane_Idaho_Central_FIPS_1102", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26770, "NAD_1927_StatePlane_Idaho_West_FIPS_1103", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26771, "NAD_1927_StatePlane_Illinois_East_FIPS_1201", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26772, "NAD_1927_StatePlane_Illinois_West_FIPS_1202", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26773, "NAD_1927_StatePlane_Indiana_East_FIPS_1301", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26774, "NAD_1927_StatePlane_Indiana_West_FIPS_1302", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26775, "NAD_1927_StatePlane_Iowa_North_FIPS_1401", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26776, "NAD_1927_StatePlane_Iowa_South_FIPS_1402", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26777, "NAD_1927_StatePlane_Kansas_North_FIPS_1501", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26778, "NAD_1927_StatePlane_Kansas_South_FIPS_1502", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26779, "NAD_1927_StatePlane_Kentucky_North_FIPS_1601", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26780, "NAD_1927_StatePlane_Kentucky_South_FIPS_1602", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26781, "NAD_1927_StatePlane_Louisiana_North_FIPS_1701", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26782, "NAD_1927_StatePlane_Louisiana_South_FIPS_1702", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26783, "NAD_1927_StatePlane_Maine_East_FIPS_1801", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26784, "NAD_1927_StatePlane_Maine_West_FIPS_1802", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26785, "NAD_1927_StatePlane_Maryland_FIPS_1900", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26786, "NAD_1927_StatePlane_Massachusetts_Mainland_FIPS_2001", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26787, "NAD_1927_StatePlane_Massachusetts_Island_FIPS_2002", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26788, "NAD_1927_StatePlane_Michigan_North_FIPS_2111", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26789, "NAD_1927_StatePlane_Michigan_Central_FIPS_2112", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26790, "NAD_1927_StatePlane_Michigan_South_FIPS_2113", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26791, "NAD_1927_StatePlane_Minnesota_North_FIPS_2201", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26792, "NAD_1927_StatePlane_Minnesota_Central_FIPS_2202", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26793, "NAD_1927_StatePlane_Minnesota_South_FIPS_2203", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26794, "NAD_1927_StatePlane_Mississippi_East_FIPS_2301", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26795, "NAD_1927_StatePlane_Mississippi_West_FIPS_2302", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26796, "NAD_1927_StatePlane_Missouri_East_FIPS_2401", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26797, "NAD_1927_StatePlane_Missouri_Central_FIPS_2402", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26798, "NAD_1927_StatePlane_Missouri_West_FIPS_2403", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26799, "NAD_1927_StatePlane_California_VII_FIPS_0407", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26847, "NAD_1983_StatePlane_Maine_East_FIPS_1801_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26848, "NAD_1983_StatePlane_Maine_West_FIPS_1802_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26849, "NAD_1983_StatePlane_Minnesota_North_FIPS_2201_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26850, "NAD_1983_StatePlane_Minnesota_Central_FIPS_2202_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26851, "NAD_1983_StatePlane_Minnesota_South_FIPS_2203_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26852, "NAD_1983_StatePlane_Nebraska_FIPS_2600_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26853, "NAD_1983_StatePlane_West_Virginia_North_FIPS_4701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26854, "NAD_1983_StatePlane_West_Virginia_South_FIPS_4702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26855, "NAD_1983_HARN_StatePlane_Maine_East_FIPS_1801_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26856, "NAD_1983_HARN_StatePlane_Maine_West_FIPS_1802_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26857, "NAD_1983_HARN_StatePlane_Minnesota_North_FIPS_2201_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26858, "NAD_1983_HARN_StatePlane_Minnesota_Central_FIPS_2202_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26859, "NAD_1983_HARN_StatePlane_Minnesota_South_FIPS_2203_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26860, "NAD_1983_HARN_StatePlane_Nebraska_FIPS_2600_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26861, "NAD_1983_HARN_StatePlane_West_Virginia_North_FIPS_4701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26862, "NAD_1983_HARN_StatePlane_West_Virginia_South_FIPS_4702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26863, "NAD_1983_NSRS2007_StatePlane_Maine_East_FIPS_1801_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26864, "NAD_1983_NSRS2007_StatePlane_Maine_West_FIPS_1802_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26865, "NAD_1983_NSRS2007_StatePlane_Minnesota_North_FIPS_2201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26866, "NAD_1983_NSRS2007_StatePlane_Minnesota_Central_FIPS_2202_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26867, "NAD_1983_NSRS2007_StatePlane_Minnesota_South_FIPS_2203_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26868, "NAD_1983_NSRS2007_StatePlane_Nebraska_FIPS_2600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26869, "NAD_1983_NSRS2007_StatePlane_West_Virginia_North_FIPS_4701_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26870, "NAD_1983_NSRS2007_StatePlane_West_Virginia_South_FIPS_4702_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26891, "NAD_1983_CSRS_MTM_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26892, "NAD_1983_CSRS_MTM_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26893, "NAD_1983_CSRS_MTM_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26894, "NAD_1983_CSRS_MTM_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26895, "NAD_1983_CSRS_MTM_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26896, "NAD_1983_CSRS_MTM_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26897, "NAD_1983_CSRS_MTM_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26898, "NAD_1983_CSRS_MTM_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26899, "NAD_1983_CSRS_MTM_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26901, "NAD_1983_UTM_Zone_1N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26902, "NAD_1983_UTM_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26903, "NAD_1983_UTM_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26904, "NAD_1983_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26905, "NAD_1983_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26906, "NAD_1983_UTM_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26907, "NAD_1983_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26908, "NAD_1983_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26909, "NAD_1983_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26910, "NAD_1983_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26911, "NAD_1983_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26912, "NAD_1983_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26913, "NAD_1983_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26914, "NAD_1983_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26915, "NAD_1983_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26916, "NAD_1983_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26917, "NAD_1983_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26918, "NAD_1983_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26919, "NAD_1983_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26920, "NAD_1983_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26921, "NAD_1983_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26922, "NAD_1983_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26923, "NAD_1983_UTM_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26929, "NAD_1983_StatePlane_Alabama_East_FIPS_0101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26930, "NAD_1983_StatePlane_Alabama_West_FIPS_0102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26931, "NAD_1983_StatePlane_Alaska_1_FIPS_5001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26932, "NAD_1983_StatePlane_Alaska_2_FIPS_5002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26933, "NAD_1983_StatePlane_Alaska_3_FIPS_5003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26934, "NAD_1983_StatePlane_Alaska_4_FIPS_5004", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26935, "NAD_1983_StatePlane_Alaska_5_FIPS_5005", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26936, "NAD_1983_StatePlane_Alaska_6_FIPS_5006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26937, "NAD_1983_StatePlane_Alaska_7_FIPS_5007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26938, "NAD_1983_StatePlane_Alaska_8_FIPS_5008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26939, "NAD_1983_StatePlane_Alaska_9_FIPS_5009", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26940, "NAD_1983_StatePlane_Alaska_10_FIPS_5010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26941, "NAD_1983_StatePlane_California_I_FIPS_0401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26942, "NAD_1983_StatePlane_California_II_FIPS_0402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26943, "NAD_1983_StatePlane_California_III_FIPS_0403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26944, "NAD_1983_StatePlane_California_IV_FIPS_0404", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26945, "NAD_1983_StatePlane_California_V_FIPS_0405", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26946, "NAD_1983_StatePlane_California_VI_FIPS_0406", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26948, "NAD_1983_StatePlane_Arizona_East_FIPS_0201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26949, "NAD_1983_StatePlane_Arizona_Central_FIPS_0202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26950, "NAD_1983_StatePlane_Arizona_West_FIPS_0203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26951, "NAD_1983_StatePlane_Arkansas_North_FIPS_0301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26952, "NAD_1983_StatePlane_Arkansas_South_FIPS_0302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26953, "NAD_1983_StatePlane_Colorado_North_FIPS_0501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26954, "NAD_1983_StatePlane_Colorado_Central_FIPS_0502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26955, "NAD_1983_StatePlane_Colorado_South_FIPS_0503", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26956, "NAD_1983_StatePlane_Connecticut_FIPS_0600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26957, "NAD_1983_StatePlane_Delaware_FIPS_0700", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26958, "NAD_1983_StatePlane_Florida_East_FIPS_0901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26959, "NAD_1983_StatePlane_Florida_West_FIPS_0902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26960, "NAD_1983_StatePlane_Florida_North_FIPS_0903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26961, "NAD_1983_StatePlane_Hawaii_1_FIPS_5101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26962, "NAD_1983_StatePlane_Hawaii_2_FIPS_5102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26963, "NAD_1983_StatePlane_Hawaii_3_FIPS_5103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26964, "NAD_1983_StatePlane_Hawaii_4_FIPS_5104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26965, "NAD_1983_StatePlane_Hawaii_5_FIPS_5105", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26966, "NAD_1983_StatePlane_Georgia_East_FIPS_1001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26967, "NAD_1983_StatePlane_Georgia_West_FIPS_1002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26968, "NAD_1983_StatePlane_Idaho_East_FIPS_1101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26969, "NAD_1983_StatePlane_Idaho_Central_FIPS_1102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26970, "NAD_1983_StatePlane_Idaho_West_FIPS_1103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26971, "NAD_1983_StatePlane_Illinois_East_FIPS_1201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26972, "NAD_1983_StatePlane_Illinois_West_FIPS_1202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26973, "NAD_1983_StatePlane_Indiana_East_FIPS_1301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26974, "NAD_1983_StatePlane_Indiana_West_FIPS_1302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26975, "NAD_1983_StatePlane_Iowa_North_FIPS_1401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26976, "NAD_1983_StatePlane_Iowa_South_FIPS_1402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26977, "NAD_1983_StatePlane_Kansas_North_FIPS_1501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26978, "NAD_1983_StatePlane_Kansas_South_FIPS_1502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26980, "NAD_1983_StatePlane_Kentucky_South_FIPS_1602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26981, "NAD_1983_StatePlane_Louisiana_North_FIPS_1701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26982, "NAD_1983_StatePlane_Louisiana_South_FIPS_1702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26983, "NAD_1983_StatePlane_Maine_East_FIPS_1801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26984, "NAD_1983_StatePlane_Maine_West_FIPS_1802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26985, "NAD_1983_StatePlane_Maryland_FIPS_1900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26986, "NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26987, "NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26988, "NAD_1983_StatePlane_Michigan_North_FIPS_2111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26989, "NAD_1983_StatePlane_Michigan_Central_FIPS_2112", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26990, "NAD_1983_StatePlane_Michigan_South_FIPS_2113", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26991, "NAD_1983_StatePlane_Minnesota_North_FIPS_2201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26992, "NAD_1983_StatePlane_Minnesota_Central_FIPS_2202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26993, "NAD_1983_StatePlane_Minnesota_South_FIPS_2203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26994, "NAD_1983_StatePlane_Mississippi_East_FIPS_2301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26995, "NAD_1983_StatePlane_Mississippi_West_FIPS_2302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26996, "NAD_1983_StatePlane_Missouri_East_FIPS_2401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26997, "NAD_1983_StatePlane_Missouri_Central_FIPS_2402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 26998, "NAD_1983_StatePlane_Missouri_West_FIPS_2403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27037, "Nahrwan_1967_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27038, "Nahrwan_1967_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27039, "Nahrwan_1967_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27040, "Nahrwan_1967_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27120, "Naparima_1972_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27200, "GD_1949_New_Zealand_Map_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27205, "NZGD_1949_Mount_Eden_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27206, "NZGD_1949_Bay_of_Plenty_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27207, "NZGD_1949_Poverty_Bay_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27208, "NZGD_1949_Hawkes_Bay_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27209, "NZGD_1949_Taranaki_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27210, "NZGD_1949_Tuhirangi_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27211, "NZGD_1949_Wanganui_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27212, "NZGD_1949_Wairarapa_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27213, "NZGD_1949_Wellington_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27214, "NZGD_1949_Collingwood_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27215, "NZGD_1949_Nelson_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27216, "NZGD_1949_Karamea_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27217, "NZGD_1949_Buller_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27218, "NZGD_1949_Grey_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27219, "NZGD_1949_Amuri_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27220, "NZGD_1949_Marlborough_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27221, "NZGD_1949_Hokitika_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27222, "NZGD_1949_Okarito_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27223, "NZGD_1949_Jacksons_Bay_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27224, "NZGD_1949_Mount_Pleasant_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27225, "NZGD_1949_Gawler_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27226, "NZGD_1949_Timaru_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27227, "NZGD_1949_Lindis_Peak_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27228, "NZGD_1949_Mount_Nicholas_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27229, "NZGD_1949_Mount_York_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27230, "NZGD_1949_Observation_Point_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27231, "NZGD_1949_North_Taieri_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27232, "NZGD_1949_Bluff_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27258, "NZGD_1949_UTM_Zone_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27259, "NZGD_1949_UTM_Zone_59S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27260, "NZGD_1949_UTM_Zone_60S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27291, "New_Zealand_North_Island", "Yard_Sears", 0.9143984146160287));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27292, "New_Zealand_South_Island", "Yard_Sears", 0.9143984146160287));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27391, "NGO_1948_Oslo_Norway_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27392, "NGO_1948_Oslo_Norway_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27393, "NGO_1948_Oslo_Norway_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27394, "NGO_1948_Oslo_Norway_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27395, "NGO_1948_Oslo_Norway_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27396, "NGO_1948_Oslo_Norway_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27397, "NGO_1948_Oslo_Norway_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27398, "NGO_1948_Oslo_Norway_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27429, "Datum_73_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27493, "Datum_73_Modified_Portuguese_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27500, "Nord_de_Guerre", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27561, "NTF_Paris_Lambert_Nord_France", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27562, "NTF_Paris_Lambert_Centre_France", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27563, "NTF_Paris_Lambert_Sud_France", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27564, "NTF_Paris_Lambert_Corse", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27571, "NTF_Paris_Lambert_Zone_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27572, "NTF_Paris_Lambert_Zone_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27573, "NTF_Paris_Lambert_Zone_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27574, "NTF_Paris_Lambert_Zone_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27581, "NTF_Paris_France_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27582, "NTF_Paris_France_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27583, "NTF_Paris_France_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27584, "NTF_Paris_France_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27591, "NTF_Paris_Nord_France", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27592, "NTF_Paris_Centre_France", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27593, "NTF_Paris_Sud_France", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27594, "NTF_Paris_Corse", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 27700, "British_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28191, "Palestine_1923_Palestine_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28192, "Palestine_1923_Palestine_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28193, "Palestine_1923_Israel_CS_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28232, "Pointe_Noire_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28348, "GDA_1994_MGA_Zone_48", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28349, "GDA_1994_MGA_Zone_49", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28350, "GDA_1994_MGA_Zone_50", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28351, "GDA_1994_MGA_Zone_51", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28352, "GDA_1994_MGA_Zone_52", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28353, "GDA_1994_MGA_Zone_53", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28354, "GDA_1994_MGA_Zone_54", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28355, "GDA_1994_MGA_Zone_55", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28356, "GDA_1994_MGA_Zone_56", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28357, "GDA_1994_MGA_Zone_57", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28358, "GDA_1994_MGA_Zone_58", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28402, "Pulkovo_1942_GK_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28403, "Pulkovo_1942_GK_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28404, "Pulkovo_1942_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28405, "Pulkovo_1942_GK_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28406, "Pulkovo_1942_GK_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28407, "Pulkovo_1942_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28408, "Pulkovo_1942_GK_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28409, "Pulkovo_1942_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28410, "Pulkovo_1942_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28411, "Pulkovo_1942_GK_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28412, "Pulkovo_1942_GK_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28413, "Pulkovo_1942_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28414, "Pulkovo_1942_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28415, "Pulkovo_1942_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28416, "Pulkovo_1942_GK_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28417, "Pulkovo_1942_GK_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28418, "Pulkovo_1942_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28419, "Pulkovo_1942_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28420, "Pulkovo_1942_GK_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28421, "Pulkovo_1942_GK_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28422, "Pulkovo_1942_GK_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28423, "Pulkovo_1942_GK_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28424, "Pulkovo_1942_GK_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28425, "Pulkovo_1942_GK_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28426, "Pulkovo_1942_GK_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28427, "Pulkovo_1942_GK_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28428, "Pulkovo_1942_GK_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28429, "Pulkovo_1942_GK_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28430, "Pulkovo_1942_GK_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28431, "Pulkovo_1942_GK_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28432, "Pulkovo_1942_GK_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28462, "Pulkovo_1942_GK_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28463, "Pulkovo_1942_GK_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28464, "Pulkovo_1942_GK_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28465, "Pulkovo_1942_GK_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28466, "Pulkovo_1942_GK_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28467, "Pulkovo_1942_GK_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28468, "Pulkovo_1942_GK_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28469, "Pulkovo_1942_GK_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28470, "Pulkovo_1942_GK_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28471, "Pulkovo_1942_GK_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28472, "Pulkovo_1942_GK_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28473, "Pulkovo_1942_GK_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28474, "Pulkovo_1942_GK_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28475, "Pulkovo_1942_GK_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28476, "Pulkovo_1942_GK_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28477, "Pulkovo_1942_GK_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28478, "Pulkovo_1942_GK_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28479, "Pulkovo_1942_GK_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28480, "Pulkovo_1942_GK_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28481, "Pulkovo_1942_GK_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28482, "Pulkovo_1942_GK_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28483, "Pulkovo_1942_GK_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28484, "Pulkovo_1942_GK_Zone_24N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28485, "Pulkovo_1942_GK_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28486, "Pulkovo_1942_GK_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28487, "Pulkovo_1942_GK_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28488, "Pulkovo_1942_GK_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28489, "Pulkovo_1942_GK_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28490, "Pulkovo_1942_GK_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28491, "Pulkovo_1942_GK_Zone_31N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28492, "Pulkovo_1942_GK_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28600, "Qatar_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28991, "RD_Old", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 28992, "RD_New", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29101, "SAD_1969_Brazil_Polyconic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29168, "SAD_1969_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29169, "SAD_1969_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29170, "SAD_1969_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29171, "SAD_1969_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29172, "SAD_1969_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29187, "SAD_1969_UTM_Zone_17S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29188, "SAD_1969_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29189, "SAD_1969_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29190, "SAD_1969_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29191, "SAD_1969_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29192, "SAD_1969_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29193, "SAD_1969_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29194, "SAD_1969_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29195, "SAD_1969_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29220, "Sapper_Hill_1943_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29221, "Sapper_Hill_1943_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29333, "Schwarzeck_UTM_Zone_33S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29635, "Sudan_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29636, "Sudan_UTM_Zone_36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29701, "Tananarive_1925_Paris_Laborde_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29738, "Tananarive_1925_UTM_Zone_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29739, "Tananarive_1925_UTM_Zone_39S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29849, "Timbalai_1948_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29850, "Timbalai_1948_UTM_Zone_50N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29871, "Timbalai_1948_RSO_Borneo_Chains", "Chain_Sears", 20.11676512155263));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29872, "Timbalai_1948_RSO_Borneo_Feet", "Foot_Sears", 0.3047994715386762));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29873, "Timbalai_1948_RSO_Borneo_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29901, "OSNI_1952_Irish_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29902, "TM65_Irish_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 29903, "TM75_Irish_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30161, "Japan_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30162, "Japan_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30163, "Japan_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30164, "Japan_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30165, "Japan_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30166, "Japan_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30167, "Japan_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30168, "Japan_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30169, "Japan_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30170, "Japan_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30171, "Japan_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30172, "Japan_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30173, "Japan_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30174, "Japan_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30175, "Japan_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30176, "Japan_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30177, "Japan_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30178, "Japan_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30179, "Japan_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30200, "Trinidad_1903_Trinidad_Grid", "Link_Clarke", 0.201166195164));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30339, "TC_1948_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30340, "TC_1948_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30491, "Nord_Algerie_Ancienne", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30492, "Sud_Algerie_Ancienne", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30493, "Voirol_1879_Nord_Algerie_Ancienne", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30494, "Voirol_1879_Sud_Algerie_Ancienne", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30591, "Nord_Algerie", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 30592, "Sud_Algerie", "Meter", 1.0));
        }
    }

    private static class PCS_2 {
        private PCS_2() {
        }

        static void add(List<CoordinateSystem> list) {
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3142, "Fiji_1956_UTM_Zone_1S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3146, "Pulkovo_1942_3_Degree_GK_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3147, "Pulkovo_1942_3_Degree_GK_CM_18E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3148, "Indian_1960_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3149, "Indian_1960_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3150, "Pulkovo_1995_3_Degree_GK_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3151, "Pulkovo_1995_3_Degree_GK_CM_18E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3153, "NAD_1983_CSRS_BC_Environment_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3154, "NAD_1983_CSRS_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3155, "NAD_1983_CSRS_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3156, "NAD_1983_CSRS_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3157, "NAD_1983_CSRS_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3158, "NAD_1983_CSRS_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3159, "NAD_1983_CSRS_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3160, "NAD_1983_CSRS_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3161, "NAD_1983_Ontario_MNR_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3162, "NAD_1983_CSRS_Ontario_MNR_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3163, "RGNC_1991_93_Lambert_New_Caledonia", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3164, "ST87_Ouvea_UTM_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3165, "NEA74_Noumea_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3166, "NEA74_Noumea_Lambert_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3167, "Kertau_RSO_RSO_Malaya_ChSears1922trunc", "Chain_Sears_1922_Truncated", 20.116756));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3168, "Kertau_RSO_RSO_Malaya", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3169, "RGNC_1991-93_UTM_Zone_57S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3170, "RGNC_1991-93_UTM_Zone_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3171, "RGNC_1991-93_UTM_Zone_59S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3172, "IGN53_Mare_UTM_Zone_59S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3174, "NAD_1983_Great_Lakes_Basin_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3175, "NAD_1983_Great_Lakes_and_St_Lawrence_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3176, "Indian_1960_TM_106NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3177, "LGD2006_Libya_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3178, "Greenland_1996_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3179, "Greenland_1996_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3180, "Greenland_1996_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3181, "Greenland_1996_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3182, "Greenland_1996_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3183, "Greenland_1996_UTM_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3184, "Greenland_1996_UTM_Zone_24N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3185, "Greenland_1996_UTM_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3186, "Greenland_1996_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3187, "Greenland_1996_UTM_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3188, "Greenland_1996_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3189, "Greenland_1996_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3190, "LGD2006_Libya_TM_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3191, "LGD2006_Libya_TM_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3192, "LGD2006_Libya_TM_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3193, "LGD2006_Libya_TM_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3194, "LGD2006_Libya_TM_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3195, "LGD2006_Libya_TM_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3196, "LGD2006_Libya_TM_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3197, "LGD2006_Libya_TM_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3198, "LGD2006_Libya_TM_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3199, "LGD2006_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3200, "FD_1958_Iraq", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3201, "LGD2006_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3202, "LGD2006_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3203, "LGD2006_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3294, "WGS_1984_USGS_Transantarctic_Mountains", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3295, "Guam_1963_Yap_Islands", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3296, "RGPF_UTM_Zone_5S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3297, "RGPF_UTM_Zone_6S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3298, "RGPF_UTM_Zone_7S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3299, "RGPF_UTM_Zone_8S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3300, "Estonian_Coordinate_System_of_1992", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3301, "Estonia_1997_Estonia_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3302, "IGN63_Hiva_Oa_UTM_Zone_7S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3303, "Fatu_Iva_1972_UTM_Zone_7S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3304, "Tahiti_1979_UTM_Zone_6S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3305, "Moorea_1987_UTM_Zone_6S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3306, "Maupiti_1983_UTM_Zone_5S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3307, "Nakhl-e_Ghanem_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3308, "GDA_1994_NSW_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3309, "NAD_1927_California_Teale_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3310, "NAD_1983_California_Teale_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3311, "NAD_1983_HARN_California_Teale_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3312, "CSG_1967_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3313, "RGFG_1995_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3315, "Katanga_1955_Katanga_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3316, "Kasai_1953_Congo_TM_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3317, "Kasai_1953_Congo_TM_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3318, "IGC_1962_Congo_TM_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3319, "IGC_1962_Congo_TM_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3320, "IGC_1962_Congo_TM_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3321, "IGC_1962_Congo_TM_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3322, "IGC_1962_Congo_TM_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3323, "IGC_1962_Congo_TM_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3324, "IGC_1962_Congo_TM_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3325, "IGC_1962_Congo_TM_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3326, "IGC_1962_Congo_TM_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3327, "IGC_1962_Congo_TM_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3328, "Pulkovo_1942_Adj_1958_GUGiK-80", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3329, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3330, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3331, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3332, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3333, "Pulkovo_1942_Adj_1958_GK_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3334, "Pulkovo_1942_Adj_1958_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3335, "Pulkovo_1942_Adj_1958_GK_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3336, "Kerguelen_Island_1949_UTM_42S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3337, "Le_Pouce_1934_Mauritius_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3338, "NAD_1983_Alaska_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3339, "IGCB_1955_Congo_TM_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3340, "IGCB_1955_Congo_TM_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3341, "IGCB_1955_Congo_TM_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3342, "IGCB_1955_UTM_Zone_33S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3343, "Mauritania_1999_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3344, "Mauritania_1999_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3345, "Mauritania_1999_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3346, "LKS_1994_Lithuania_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3347, "NAD_1983_Statistics_Canada_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3348, "NAD_1983_CSRS_Statistics_Canada_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3350, "Pulkovo_1942_CS63_Zone_C0", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3351, "Pulkovo_1942_CS63_Zone_C1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3352, "Pulkovo_1942_CS63_Zone_C2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3353, "Mhast_Onshore_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3354, "Mhast_Offshore_UTM_Zone_32S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3355, "Egypt_Gulf_of_Suez_S-650_TL_Red_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3356, "Grand_Cayman_1959_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3357, "Little_Cayman_1961_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3358, "NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3360, "NAD_1983_HARN_StatePlane_South_Carolina_FIPS_3900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3361, "NAD_1983_HARN_StatePlane_South_Carolina_FIPS_3900_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3362, "NAD_1983_HARN_StatePlane_Pennsylvania_North_FIPS_3701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3363, "NAD_1983_HARN_StatePlane_Pennsylvania_North_FIPS_3701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3364, "NAD_1983_HARN_StatePlane_Pennsylvania_South_FIPS_3702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3365, "NAD_1983_HARN_StatePlane_Pennsylvania_South_FIPS_3702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3367, "IGN_Astro_1960_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3368, "IGN_Astro_1960_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3369, "IGN_Astro_1960_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3370, "NAD_1927_UTM_Zone_59N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3371, "NAD_1927_UTM_Zone_60N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3372, "NAD_1983_UTM_Zone_59N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3373, "NAD_1983_UTM_Zone_60N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3374, "FD_1954_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3375, "GDM_2000_MRSO_Peninsular_Malaysia", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3376, "GDM_2000_BRSO_East_Malaysia", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3377, "GDM_2000_State_Cassini_Johor", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3378, "GDM_2000_State_Cassini_Negeri_Sembilan_and_Melaka", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3379, "GDM_2000_State_Cassini_Pahang", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3380, "GDM_2000_State_Cassini_Selangor", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3381, "GDM_2000_State_Cassini_Terengganu", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3382, "GDM_2000_State_Cassini_Pulau_Pinang_and_Seberang_Perai", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3383, "GDM_2000_State_Cassini_Perlis", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3384, "GDM_2000_State_Cassini_Perak", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3385, "GDM_2000_State_Cassini_Kelantan", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3386, "KKJ_Finland_Zone_0", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3387, "KKJ_Finland_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3388, "Pulkovo_1942_Caspian_Sea_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3389, "Pulkovo_1942_3_Degree_GK_Zone_60", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3390, "Pulkovo_1995_3_Degree_GK_Zone_60", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3391, "Karbala_1979_Polservice_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3392, "Karbala_1979_Polservice_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3393, "Karbala_1979_Polservice_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3394, "Nahrwan_1934_Iraq_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3395, "WGS_1984_World_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3396, "PD/83_GK_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3397, "PD/83_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3398, "RD/83_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3399, "RD/83_GK_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3400, "NAD_1983_10TM_AEP_Forest", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3401, "NAD_1983_10TM_AEP_Resource", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3402, "NAD_1983_CSRS_10TM_AEP_Forest", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3403, "NAD_1983_CSRS_10TM_AEP_Resource", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3404, "NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3405, "VN_2000_UTM_Zone_48N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3406, "VN_2000_UTM_Zone_49N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3407, "Hong_Kong_1963_Grid_System", "Foot_Clarke", 0.3047972654));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3408, "NSIDC_EASE_Grid_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3409, "NSIDC_EASE_Grid_South", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3410, "NSIDC_EASE_Grid_Global", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3411, "NSIDC_Sea_Ice_Polar_Stereographic_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3412, "NSIDC_Sea_Ice_Polar_Stereographic_South", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3413, "WGS_1984_NSIDC_Sea_Ice_Polar_Stereographic_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3414, "SVY21_Singapore_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3415, "WGS_1972_BE_South_China_Sea_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3416, "ETRS_1989_Austria_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3417, "NAD_1983_StatePlane_Iowa_North_FIPS_1401_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3418, "NAD_1983_StatePlane_Iowa_South_FIPS_1402_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3419, "NAD_1983_StatePlane_Kansas_North_FIPS_1501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3420, "NAD_1983_StatePlane_Kansas_South_FIPS_1502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3421, "NAD_1983_StatePlane_Nevada_East_FIPS_2701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3422, "NAD_1983_StatePlane_Nevada_Central_FIPS_2702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3423, "NAD_1983_StatePlane_Nevada_West_FIPS_2703_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3424, "NAD_1983_StatePlane_New_Jersey_FIPS_2900_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3425, "NAD_1983_HARN_StatePlane_Iowa_North_FIPS_1401_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3426, "NAD_1983_HARN_StatePlane_Iowa_South_FIPS_1402_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3427, "NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3428, "NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3429, "NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3430, "NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3431, "NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3432, "NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3433, "NAD_1983_StatePlane_Arkansas_North_FIPS_0301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3434, "NAD_1983_StatePlane_Arkansas_South_FIPS_0302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3435, "NAD_1983_StatePlane_Illinois_East_FIPS_1201_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3436, "NAD_1983_StatePlane_Illinois_West_FIPS_1202_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3437, "NAD_1983_StatePlane_New_Hampshire_FIPS_2800_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3438, "NAD_1983_StatePlane_Rhode_Island_FIPS_3800_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3439, "PDO_1993_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3440, "PDO_1993_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3441, "NAD_1983_HARN_StatePlane_Arkansas_North_FIPS_0301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3442, "NAD_1983_HARN_StatePlane_Arkansas_South_FIPS_0302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3443, "NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3444, "NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3445, "NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3446, "NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3447, "Belge_Lambert_2005", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3448, "JAD_2001_Jamaica_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3449, "JAD_2001_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3450, "JAD_2001_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3451, "NAD_1983_StatePlane_Louisiana_North_FIPS_1701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3452, "NAD_1983_StatePlane_Louisiana_South_FIPS_1702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3453, "NAD_1983_StatePlane_Louisiana_Offshore_FIPS_1703_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3455, "NAD_1983_StatePlane_South_Dakota_South_FIPS_4002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3456, "NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3457, "NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3458, "NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3459, "NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3460, "Fiji_1986_Fiji_Map_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3461, "Dabola_1981_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3462, "Dabola_1981_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3463, "NAD_1983_Maine_2000_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3464, "NAD_1983_HARN_Maine_2000_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3465, "NAD_1983_NSRS2007_StatePlane_Alabama_East_FIPS_0101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3466, "NAD_1983_NSRS2007_StatePlane_Alabama_West_FIPS_0102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3467, "NAD_1983_NSRS2007_Alaska_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3468, "NAD_1983_NSRS2007_StatePlane_Alaska_1_FIPS_5001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3469, "NAD_1983_NSRS2007_StatePlane_Alaska_2_FIPS_5002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3470, "NAD_1983_NSRS2007_StatePlane_Alaska_3_FIPS_5003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3471, "NAD_1983_NSRS2007_StatePlane_Alaska_4_FIPS_5004", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3472, "NAD_1983_NSRS2007_StatePlane_Alaska_5_FIPS_5005", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3473, "NAD_1983_NSRS2007_StatePlane_Alaska_6_FIPS_5006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3474, "NAD_1983_NSRS2007_StatePlane_Alaska_7_FIPS_5007", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3475, "NAD_1983_NSRS2007_StatePlane_Alaska_8_FIPS_5008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3476, "NAD_1983_NSRS2007_StatePlane_Alaska_9_FIPS_5009", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3477, "NAD_1983_NSRS2007_StatePlane_Alaska_10_FIPS_5010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3478, "NAD_1983_NSRS2007_StatePlane_Arizona_Central_FIPS_0202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3479, "NAD_1983_NSRS2007_StatePlane_Arizona_Central_FIPS_0202_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3480, "NAD_1983_NSRS2007_StatePlane_Arizona_East_FIPS_0201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3481, "NAD_1983_NSRS2007_StatePlane_Arizona_East_FIPS_0201_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3482, "NAD_1983_NSRS2007_StatePlane_Arizona_West_FIPS_0203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3483, "NAD_1983_NSRS2007_StatePlane_Arizona_West_FIPS_0203_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3484, "NAD_1983_NSRS2007_StatePlane_Arkansas_North_FIPS_0301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3485, "NAD_1983_NSRS2007_StatePlane_Arkansas_North_FIPS_0301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3486, "NAD_1983_NSRS2007_StatePlane_Arkansas_South_FIPS_0302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3487, "NAD_1983_NSRS2007_StatePlane_Arkansas_South_FIPS_0302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3488, "NAD_1983_NSRS2007_California_Teale_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3489, "NAD_1983_NSRS2007_StatePlane_California_I_FIPS_0401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3490, "NAD_1983_NSRS2007_StatePlane_California_I_FIPS_0401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3491, "NAD_1983_NSRS2007_StatePlane_California_II_FIPS_0402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3492, "NAD_1983_NSRS2007_StatePlane_California_II_FIPS_0402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3493, "NAD_1983_NSRS2007_StatePlane_California_III_FIPS_0403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3494, "NAD_1983_NSRS2007_StatePlane_California_III_FIPS_0403_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3495, "NAD_1983_NSRS2007_StatePlane_California_IV_FIPS_0404", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3496, "NAD_1983_NSRS2007_StatePlane_California_IV_FIPS_0404_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3497, "NAD_1983_NSRS2007_StatePlane_California_V_FIPS_0405", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3498, "NAD_1983_NSRS2007_StatePlane_California_V_FIPS_0405_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3499, "NAD_1983_NSRS2007_StatePlane_California_VI_FIPS_0406", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3500, "NAD_1983_NSRS2007_StatePlane_California_VI_FIPS_0406_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3501, "NAD_1983_NSRS2007_StatePlane_Colorado_Central_FIPS_0502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3502, "NAD_1983_NSRS2007_StatePlane_Colorado_Central_FIPS_0502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3503, "NAD_1983_NSRS2007_StatePlane_Colorado_North_FIPS_0501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3504, "NAD_1983_NSRS2007_StatePlane_Colorado_North_FIPS_0501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3505, "NAD_1983_NSRS2007_StatePlane_Colorado_South_FIPS_0503", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3506, "NAD_1983_NSRS2007_StatePlane_Colorado_South_FIPS_0503_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3507, "NAD_1983_NSRS2007_StatePlane_Connecticut_FIPS_0600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3508, "NAD_1983_NSRS2007_StatePlane_Connecticut_FIPS_0600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3509, "NAD_1983_NSRS2007_StatePlane_Delaware_FIPS_0700", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3510, "NAD_1983_NSRS2007_StatePlane_Delaware_FIPS_0700_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3511, "NAD_1983_NSRS2007_StatePlane_Florida_East_FIPS_0901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3512, "NAD_1983_NSRS2007_StatePlane_Florida_East_FIPS_0901_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3513, "NAD_1983_NSRS2007_Florida_GDL_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3514, "NAD_1983_NSRS2007_StatePlane_Florida_North_FIPS_0903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3515, "NAD_1983_NSRS2007_StatePlane_Florida_North_FIPS_0903_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3516, "NAD_1983_NSRS2007_StatePlane_Florida_West_FIPS_0902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3517, "NAD_1983_NSRS2007_StatePlane_Florida_West_FIPS_0902_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3518, "NAD_1983_NSRS2007_StatePlane_Georgia_East_FIPS_1001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3519, "NAD_1983_NSRS2007_StatePlane_Georgia_East_FIPS_1001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3520, "NAD_1983_NSRS2007_StatePlane_Georgia_West_FIPS_1002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3521, "NAD_1983_NSRS2007_StatePlane_Georgia_West_FIPS_1002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3522, "NAD_1983_NSRS2007_StatePlane_Idaho_Central_FIPS_1102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3523, "NAD_1983_NSRS2007_StatePlane_Idaho_Central_FIPS_1102_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3524, "NAD_1983_NSRS2007_StatePlane_Idaho_East_FIPS_1101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3525, "NAD_1983_NSRS2007_StatePlane_Idaho_East_FIPS_1101_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3526, "NAD_1983_NSRS2007_StatePlane_Idaho_West_FIPS_1103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3527, "NAD_1983_NSRS2007_StatePlane_Idaho_West_FIPS_1103_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3528, "NAD_1983_NSRS2007_StatePlane_Illinois_East_FIPS_1201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3529, "NAD_1983_NSRS2007_StatePlane_Illinois_East_FIPS_1201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3530, "NAD_1983_NSRS2007_StatePlane_Illinois_West_FIPS_1202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3531, "NAD_1983_NSRS2007_StatePlane_Illinois_West_FIPS_1202_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3532, "NAD_1983_NSRS2007_StatePlane_Indiana_East_FIPS_1301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3533, "NAD_1983_NSRS2007_StatePlane_Indiana_East_FIPS_1301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3534, "NAD_1983_NSRS2007_StatePlane_Indiana_West_FIPS_1302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3535, "NAD_1983_NSRS2007_StatePlane_Indiana_West_FIPS_1302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3536, "NAD_1983_NSRS2007_StatePlane_Iowa_North_FIPS_1401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3537, "NAD_1983_NSRS2007_StatePlane_Iowa_North_FIPS_1401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3538, "NAD_1983_NSRS2007_StatePlane_Iowa_South_FIPS_1402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3539, "NAD_1983_NSRS2007_StatePlane_Iowa_South_FIPS_1402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3540, "NAD_1983_NSRS2007_StatePlane_Kansas_North_FIPS_1501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3541, "NAD_1983_NSRS2007_StatePlane_Kansas_North_FIPS_1501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3542, "NAD_1983_NSRS2007_StatePlane_Kansas_South_FIPS_1502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3543, "NAD_1983_NSRS2007_StatePlane_Kansas_South_FIPS_1502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3544, "NAD_1983_NSRS2007_StatePlane_Kentucky_North_FIPS_1601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3545, "NAD_1983_NSRS2007_StatePlane_Kentucky_North_FIPS_1601_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3546, "NAD_1983_NSRS2007_StatePlane_Kentucky_FIPS_1600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3547, "NAD_1983_NSRS2007_StatePlane_Kentucky_FIPS_1600_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3548, "NAD_1983_NSRS2007_StatePlane_Kentucky_South_FIPS_1602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3549, "NAD_1983_NSRS2007_StatePlane_Kentucky_South_FIPS_1602_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3550, "NAD_1983_NSRS2007_StatePlane_Louisiana_North_FIPS_1701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3551, "NAD_1983_NSRS2007_StatePlane_Louisiana_North_FIPS_1701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3552, "NAD_1983_NSRS2007_StatePlane_Louisiana_South_FIPS_1702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3553, "NAD_1983_NSRS2007_StatePlane_Louisiana_South_FIPS_1702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3554, "NAD_1983_NSRS2007_Maine_2000_Central_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3555, "NAD_1983_NSRS2007_Maine_2000_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3556, "NAD_1983_NSRS2007_Maine_2000_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3557, "NAD_1983_NSRS2007_StatePlane_Maine_East_FIPS_1801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3558, "NAD_1983_NSRS2007_StatePlane_Maine_West_FIPS_1802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3559, "NAD_1983_NSRS2007_StatePlane_Maryland_FIPS_1900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3560, "NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3561, "Old_Hawaiian_StatePlane_Hawaii_1_FIPS_5101", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3562, "Old_Hawaiian_StatePlane_Hawaii_2_FIPS_5102", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3563, "Old_Hawaiian_StatePlane_Hawaii_3_FIPS_5103", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3564, "Old_Hawaiian_StatePlane_Hawaii_4_FIPS_5104", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3565, "Old_Hawaiian_StatePlane_Hawaii_5_FIPS_5105", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3566, "NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3567, "NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3568, "NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3569, "NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3570, "NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3571, "WGS_1984_North_Pole_LAEA_Bering_Sea", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3572, "WGS_1984_North_Pole_LAEA_Alaska", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3573, "WGS_1984_North_Pole_LAEA_Canada", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3574, "WGS_1984_North_Pole_LAEA_Atlantic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3575, "WGS_1984_North_Pole_LAEA_Europe", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3576, "WGS_1984_North_Pole_LAEA_Russia", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3577, "GDA_1994_Australia_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3578, "NAD_1983_Yukon_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3579, "NAD_1983_CSRS_Yukon_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3580, "NAD_1983_Northwest_Territories_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3581, "NAD_1983_CSRS_Northwest_Territories_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3582, "NAD_1983_NSRS2007_StatePlane_Maryland_FIPS_1900_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3583, "NAD_1983_NSRS2007_StatePlane_Massachusetts_Island_FIPS_2002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3584, "NAD_1983_NSRS2007_StatePlane_Massachusetts_Isl_FIPS_2002_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3585, "NAD_1983_NSRS2007_StatePlane_Massachusetts_Mainland_FIPS_2001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3586, "NAD_1983_NSRS2007_StatePlane_Massachusetts_Mnld_FIPS_2001_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3587, "NAD_1983_NSRS2007_StatePlane_Michigan_Central_FIPS_2112", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3588, "NAD_1983_NSRS2007_StatePlane_Michigan_Central_FIPS_2112_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3589, "NAD_1983_NSRS2007_StatePlane_Michigan_North_FIPS_2111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3590, "NAD_1983_NSRS2007_StatePlane_Michigan_North_FIPS_2111_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3591, "NAD_1983_NSRS2007_Michigan_GeoRef_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3592, "NAD_1983_NSRS2007_StatePlane_Michigan_South_FIPS_2113", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3593, "NAD_1983_NSRS2007_StatePlane_Michigan_South_FIPS_2113_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3594, "NAD_1983_NSRS2007_StatePlane_Minnesota_Central_FIPS_2202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3595, "NAD_1983_NSRS2007_StatePlane_Minnesota_North_FIPS_2201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3596, "NAD_1983_NSRS2007_StatePlane_Minnesota_South_FIPS_2203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3597, "NAD_1983_NSRS2007_StatePlane_Mississippi_East_FIPS_2301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3598, "NAD_1983_NSRS2007_StatePlane_Mississippi_East_FIPS_2301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3599, "NAD_1983_NSRS2007_StatePlane_Mississippi_West_FIPS_2302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3600, "NAD_1983_NSRS2007_StatePlane_Mississippi_West_FIPS_2302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3601, "NAD_1983_NSRS2007_StatePlane_Missouri_Central_FIPS_2402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3602, "NAD_1983_NSRS2007_StatePlane_Missouri_East_FIPS_2401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3603, "NAD_1983_NSRS2007_StatePlane_Missouri_West_FIPS_2403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3604, "NAD_1983_NSRS2007_StatePlane_Montana_FIPS_2500", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3605, "NAD_1983_NSRS2007_StatePlane_Montana_FIPS_2500_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3606, "NAD_1983_NSRS2007_StatePlane_Nebraska_FIPS_2600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3607, "NAD_1983_NSRS2007_StatePlane_Nevada_Central_FIPS_2702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3608, "NAD_1983_NSRS2007_StatePlane_Nevada_Central_FIPS_2702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3609, "NAD_1983_NSRS2007_StatePlane_Nevada_East_FIPS_2701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3610, "NAD_1983_NSRS2007_StatePlane_Nevada_East_FIPS_2701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3611, "NAD_1983_NSRS2007_StatePlane_Nevada_West_FIPS_2703", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3612, "NAD_1983_NSRS2007_StatePlane_Nevada_West_FIPS_2703_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3613, "NAD_1983_NSRS2007_StatePlane_New_Hampshire_FIPS_2800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3614, "NAD_1983_NSRS2007_StatePlane_New_Hampshire_FIPS_2800_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3615, "NAD_1983_NSRS2007_StatePlane_New_Jersey_FIPS_2900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3616, "NAD_1983_NSRS2007_StatePlane_New_Jersey_FIPS_2900_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3617, "NAD_1983_NSRS2007_StatePlane_New_Mexico_Central_FIPS_3002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3618, "NAD_1983_NSRS2007_StatePlane_New_Mexico_Central_FIPS_3002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3619, "NAD_1983_NSRS2007_StatePlane_New_Mexico_East_FIPS_3001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3620, "NAD_1983_NSRS2007_StatePlane_New_Mexico_East_FIPS_3001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3621, "NAD_1983_NSRS2007_StatePlane_New_Mexico_West_FIPS_3003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3622, "NAD_1983_NSRS2007_StatePlane_New_Mexico_West_FIPS_3003_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3623, "NAD_1983_NSRS2007_StatePlane_New_York_Central_FIPS_3102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3624, "NAD_1983_NSRS2007_StatePlane_New_York_Central_FIPS_3102_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3625, "NAD_1983_NSRS2007_StatePlane_New_York_East_FIPS_3101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3626, "NAD_1983_NSRS2007_StatePlane_New_York_East_FIPS_3101_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3627, "NAD_1983_NSRS2007_StatePlane_New_York_Long_Island_FIPS_3104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3628, "NAD_1983_NSRS2007_StatePlane_New_York_Long_Isl_FIPS_3104_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3629, "NAD_1983_NSRS2007_StatePlane_New_York_West_FIPS_3103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3630, "NAD_1983_NSRS2007_StatePlane_New_York_West_FIPS_3103_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3631, "NAD_1983_NSRS2007_StatePlane_North_Carolina_FIPS_3200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3632, "NAD_1983_NSRS2007_StatePlane_North_Carolina_FIPS_3200_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3633, "NAD_1983_NSRS2007_StatePlane_North_Dakota_North_FIPS_3301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3634, "NAD_1983_NSRS2007_StatePlane_North_Dakota_North_FIPS_3301_FtI", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3635, "NAD_1983_NSRS2007_StatePlane_North_Dakota_South_FIPS_3302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3636, "NAD_1983_NSRS2007_StatePlane_North_Dakota_South_FIPS_3302_FtI", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3637, "NAD_1983_NSRS2007_StatePlane_Ohio_North_FIPS_3401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3638, "NAD_1983_NSRS2007_StatePlane_Ohio_South_FIPS_3402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3639, "NAD_1983_NSRS2007_StatePlane_Oklahoma_North_FIPS_3501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3640, "NAD_1983_NSRS2007_StatePlane_Oklahoma_North_FIPS_3501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3641, "NAD_1983_NSRS2007_StatePlane_Oklahoma_South_FIPS_3502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3642, "NAD_1983_NSRS2007_StatePlane_Oklahoma_South_FIPS_3502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3643, "NAD_1983_NSRS2007_Oregon_Statewide_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3644, "NAD_1983_NSRS2007_Oregon_Statewide_Lambert_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3645, "NAD_1983_NSRS2007_StatePlane_Oregon_North_FIPS_3601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3646, "NAD_1983_NSRS2007_StatePlane_Oregon_North_FIPS_3601_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3647, "NAD_1983_NSRS2007_StatePlane_Oregon_South_FIPS_3602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3648, "NAD_1983_NSRS2007_StatePlane_Oregon_South_FIPS_3602_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3649, "NAD_1983_NSRS2007_StatePlane_Pennsylvania_North_FIPS_3701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3650, "NAD_1983_NSRS2007_StatePlane_Pennsylvania_North_FIPS_3701_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3651, "NAD_1983_NSRS2007_StatePlane_Pennsylvania_South_FIPS_3702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3652, "NAD_1983_NSRS2007_StatePlane_Pennsylvania_South_FIPS_3702_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3653, "NAD_1983_NSRS2007_StatePlane_Rhode_Island_FIPS_3800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3654, "NAD_1983_NSRS2007_StatePlane_Rhode_Island_FIPS_3800_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3655, "NAD_1983_NSRS2007_StatePlane_South_Carolina_FIPS_3900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3656, "NAD_1983_NSRS2007_StatePlane_South_Carolina_FIPS_3900_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3657, "NAD_1983_NSRS2007_StatePlane_South_Dakota_North_FIPS_4001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3658, "NAD_1983_NSRS2007_StatePlane_South_Dakota_North_FIPS_4001_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3659, "NAD_1983_NSRS2007_StatePlane_South_Dakota_South_FIPS_4002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3660, "NAD_1983_NSRS2007_StatePlane_South_Dakota_South_FIPS_4002_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3661, "NAD_1983_NSRS2007_StatePlane_Tennessee_FIPS_4100", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3662, "NAD_1983_NSRS2007_StatePlane_Tennessee_FIPS_4100_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3663, "NAD_1983_NSRS2007_StatePlane_Texas_Central_FIPS_4203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3664, "NAD_1983_NSRS2007_StatePlane_Texas_Central_FIPS_4203_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3665, "NAD_1983_NSRS2007_Texas_Centric_Mapping_System_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3666, "NAD_1983_NSRS2007_Texas_Centric_Mapping_System_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3667, "NAD_1983_NSRS2007_StatePlane_Texas_North_FIPS_4201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3668, "NAD_1983_NSRS2007_StatePlane_Texas_North_FIPS_4201_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3669, "NAD_1983_NSRS2007_StatePlane_Texas_North_Central_FIPS_4202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3670, "NAD_1983_NSRS2007_StatePlane_Texas_North_Central_FIPS_4202_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3671, "NAD_1983_NSRS2007_StatePlane_Texas_South_FIPS_4205", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3672, "NAD_1983_NSRS2007_StatePlane_Texas_South_FIPS_4205_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3673, "NAD_1983_NSRS2007_StatePlane_Texas_South_Central_FIPS_4204", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3674, "NAD_1983_NSRS2007_StatePlane_Texas_South_Central_FIPS_4204_FtUS", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3675, "NAD_1983_NSRS2007_StatePlane_Utah_Central_FIPS_4302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3676, "NAD_1983_NSRS2007_StatePlane_Utah_Central_FIPS_4302_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3677, "NAD_1983_NSRS2007_StatePlane_Utah_Central_FIPS_4302_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3678, "NAD_1983_NSRS2007_StatePlane_Utah_North_FIPS_4301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3679, "NAD_1983_NSRS2007_StatePlane_Utah_North_FIPS_4301_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3680, "NAD_1983_NSRS2007_StatePlane_Utah_North_FIPS_4301_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3681, "NAD_1983_NSRS2007_StatePlane_Utah_South_FIPS_4303", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3682, "NAD_1983_NSRS2007_StatePlane_Utah_South_FIPS_4303_Ft_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3683, "NAD_1983_NSRS2007_StatePlane_Utah_South_FIPS_4303_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3684, "NAD_1983_NSRS2007_StatePlane_Vermont_FIPS_4400", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3685, "NAD_1983_NSRS2007_StatePlane_Virginia_North_FIPS_4501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3686, "NAD_1983_NSRS2007_StatePlane_Virginia_North_FIPS_4501_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3687, "NAD_1983_NSRS2007_StatePlane_Virginia_South_FIPS_4502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3688, "NAD_1983_NSRS2007_StatePlane_Virginia_South_FIPS_4502_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3689, "NAD_1983_NSRS2007_StatePlane_Washington_North_FIPS_4601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3690, "NAD_1983_NSRS2007_StatePlane_Washington_North_FIPS_4601_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3691, "NAD_1983_NSRS2007_StatePlane_Washington_South_FIPS_4602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3692, "NAD_1983_NSRS2007_StatePlane_Washington_South_FIPS_4602_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3693, "NAD_1983_NSRS2007_StatePlane_West_Virginia_North_FIPS_4701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3694, "NAD_1983_NSRS2007_StatePlane_West_Virginia_South_FIPS_4702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3695, "NAD_1983_NSRS2007_StatePlane_Wisconsin_Central_FIPS_4802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3696, "NAD_1983_NSRS2007_StatePlane_Wisconsin_Central_FIPS_4802_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3697, "NAD_1983_NSRS2007_StatePlane_Wisconsin_North_FIPS_4801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3698, "NAD_1983_NSRS2007_StatePlane_Wisconsin_North_FIPS_4801_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3699, "NAD_1983_NSRS2007_StatePlane_Wisconsin_South_FIPS_4803", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3700, "NAD_1983_NSRS2007_StatePlane_Wisconsin_South_FIPS_4803_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3701, "NAD_1983_NSRS2007_Wisconsin_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3702, "NAD_1983_NSRS2007_StatePlane_Wyoming_East_FIPS_4901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3703, "NAD_1983_NSRS2007_StatePlane_Wyoming_East_Central_FIPS_4902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3704, "NAD_1983_NSRS2007_StatePlane_Wyoming_West_Central_FIPS_4903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3705, "NAD_1983_NSRS2007_StatePlane_Wyoming_West_FIPS_4904", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3706, "NAD_1983_NSRS2007_UTM_Zone_59N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3707, "NAD_1983_NSRS2007_UTM_Zone_60N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3708, "NAD_1983_NSRS2007_UTM_Zone_1N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3709, "NAD_1983_NSRS2007_UTM_Zone_2N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3710, "NAD_1983_NSRS2007_UTM_Zone_3N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3711, "NAD_1983_NSRS2007_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3712, "NAD_1983_NSRS2007_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3713, "NAD_1983_NSRS2007_UTM_Zone_6N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3714, "NAD_1983_NSRS2007_UTM_Zone_7N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3715, "NAD_1983_NSRS2007_UTM_Zone_8N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3716, "NAD_1983_NSRS2007_UTM_Zone_9N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3717, "NAD_1983_NSRS2007_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3718, "NAD_1983_NSRS2007_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3719, "NAD_1983_NSRS2007_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3720, "NAD_1983_NSRS2007_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3721, "NAD_1983_NSRS2007_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3722, "NAD_1983_NSRS2007_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3723, "NAD_1983_NSRS2007_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3724, "NAD_1983_NSRS2007_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3725, "NAD_1983_NSRS2007_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3726, "NAD_1983_NSRS2007_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3727, "Reunion_1947_TM_Reunion", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3728, "NAD_1983_NSRS2007_StatePlane_Ohio_North_FIPS_3401_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3729, "NAD_1983_NSRS2007_StatePlane_Ohio_South_FIPS_3402_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3730, "NAD_1983_NSRS2007_StatePlane_Wyoming_East_FIPS_4901_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3731, "NAD_1983_NSRS2007_StatePlane_Wyoming_E_Central_FIPS_4902_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3732, "NAD_1983_NSRS2007_StatePlane_Wyoming_W_Central_FIPS_4903_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3733, "NAD_1983_NSRS2007_StatePlane_Wyoming_West_FIPS_4904_Ft_US", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3734, "NAD_1983_StatePlane_Ohio_North_FIPS_3401_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3735, "NAD_1983_StatePlane_Ohio_South_FIPS_3402_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3736, "NAD_1983_StatePlane_Wyoming_East_FIPS_4901_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3737, "NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3738, "NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3739, "NAD_1983_StatePlane_Wyoming_West_FIPS_4904_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3740, "NAD_1983_HARN_UTM_Zone_10N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3741, "NAD_1983_HARN_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3742, "NAD_1983_HARN_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3743, "NAD_1983_HARN_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3744, "NAD_1983_HARN_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3745, "NAD_1983_HARN_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3746, "NAD_1983_HARN_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3747, "NAD_1983_HARN_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3748, "NAD_1983_HARN_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3749, "NAD_1983_HARN_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3750, "NAD_1983_HARN_UTM_Zone_4N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3751, "NAD_1983_HARN_UTM_Zone_5N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3753, "NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3754, "NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3755, "NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3756, "NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3757, "NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3758, "NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3759, "NAD_1983_StatePlane_Hawaii_3_FIPS_5103_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3760, "NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3761, "NAD_1983_CSRS_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3762, "WGS_1984_South_Georgia_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3763, "ETRS_1989_Portugal_TM06", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3764, "NZGD_2000_Chatham_Island_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3765, "HTRS96_Croatia_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3766, "HTRS96_Croatia_LCC", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3767, "HTRS96_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3768, "HTRS96_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3769, "Bermuda_1957_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3770, "Bermuda_2000_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3771, "NAD_1927_3TM_111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3772, "NAD_1927_3TM_114", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3773, "NAD_1927_3TM_117", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3775, "NAD_1983_3TM_111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3776, "NAD_1983_3TM_114", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3777, "NAD_1983_3TM_117", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3779, "NAD_1983_CSRS_3TM_111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3780, "NAD_1983_CSRS_3TM_114", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3781, "NAD_1983_CSRS_3TM_117", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3783, "Pitcairn_2006_Pitcairn_TM_2006", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3784, "Pitcairn_1967_UTM_Zone_9S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3788, "NZGD_2000_Auckland_Islands_TM_2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3789, "NZGD_2000_Campbell_Island_TM_2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3790, "NZGD_2000_Antipodes_Islands_TM_2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3791, "NZGD_2000_Raoul_Island_TM_2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3793, "NZGD_2000_Chatham_Islands_TM_2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3794, "Slovenia_1996_Slovene_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3797, "NAD_1927_MTQ_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3798, "NAD_1983_MTQ_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3799, "NAD_1983_CSRS_MTQ_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3800, "NAD_1927_3TM_120", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3801, "NAD_1983_3TM_120", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3802, "NAD_1983_CSRS_3TM_120", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3812, "Belge_Lambert_2008", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3814, "NAD_1983_Mississippi_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3815, "NAD_1983_HARN_Mississippi_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3816, "NAD_1983_NSRS2007_Mississippi_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3825, "TWD_1997_TM_Penghu", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3826, "TWD_1997_TM_Taiwan", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3827, "TWD_1967_TM_Penghu", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3828, "TWD_1967_TM_Taiwan", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3829, "Hu_Tzu_Shan_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3832, "WGS_1984_PDC_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3833, "Pulkovo_1942_Adj_1958_GK_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3834, "Pulkovo_1942_Adj_1983_GK_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3835, "Pulkovo_1942_Adj_1983_GK_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3836, "Pulkovo_1942_Adj_1983_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3837, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3838, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3839, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3840, "Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3841, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3844, "Pulkovo_1942_Adj_58_Stereo_70", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3845, "SWEREF99_RT90_7.5_gon_V_emulation", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3846, "SWEREF99_RT90_5_gon_V_emulation", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3847, "SWEREF99_RT90_2.5_gon_V_emulation", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3848, "SWEREF99_RT90_0_gon_emulation", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3849, "SWEREF99_RT90_2.5_gon_O_emulation", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3850, "SWEREF99_RT90_5_gon_O_emulation", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3851, "NZGD_2000_NZ_Continental_Shelf_2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3852, "RSRGD2000_DGLC2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3854, "SWEREF99_County_ST74", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3857, "WGS_1984_Web_Mercator_Auxiliary_Sphere", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3873, "ETRS_1989_GK19FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3874, "ETRS_1989_GK20FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3875, "ETRS_1989_GK21FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3876, "ETRS_1989_GK22FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3877, "ETRS_1989_GK23FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3878, "ETRS_1989_GK24FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3879, "ETRS_1989_GK25FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3880, "ETRS_1989_GK26FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3881, "ETRS_1989_GK27FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3882, "ETRS_1989_GK28FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3883, "ETRS_1989_GK29FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3884, "ETRS_1989_GK30FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3885, "ETRS_1989_GK31FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3890, "IGRS_UTM_Zone_37N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3891, "IGRS_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3892, "IGRS_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3893, "ED_1950_Iraq_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3907, "MGI_1901_Balkans_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3908, "MGI_1901_Balkans_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3909, "MGI_1901_Balkans_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3910, "MGI_1901_Balkans_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3911, "MGI_1901_Slovenia_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3912, "MGI_1901_Slovene_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3920, "Puerto_Rico_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3942, "RGF_1993_CC42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3943, "RGF_1993_CC43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3944, "RGF_1993_CC44", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3945, "RGF_1993_CC45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3946, "RGF_1993_CC46", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3947, "RGF_1993_CC47", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3948, "RGF_1993_CC48", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3949, "RGF_1993_CC49", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3950, "RGF_1993_CC50", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3968, "NAD_1983_Virginia_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3969, "NAD_1983_HARN_Virginia_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3970, "NAD_1983_NSRS2007_Virginia_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3973, "WGS_1984_EASE_Grid_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3974, "WGS_1984_EASE_Grid_South", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3975, "WGS_1984_EASE_Grid_Global", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3976, "WGS_1984_NSIDC_Sea_Ice_Polar_Stereographic_South", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3978, "NAD_1983_Canada_Atlas_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3979, "NAD_1983_CSRS_Canada_Atlas_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3986, "Katanga_1955_Katanga_Gauss_Zone_A", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3987, "Katanga_1955_Katanga_Gauss_Zone_B", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3988, "Katanga_1955_Katanga_Gauss_Zone_C", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3989, "Katanga_1955_Katanga_Gauss_Zone_D", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3991, "Puerto_Rico_StatePlane_Puerto_Rico_FIPS_5201", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3992, "Puerto_Rico_StatePlane_Virgin_Islands_St_Croix_FIPS_5202", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3994, "WGS_1984_Mercator_41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3995, "WGS_1984_Arctic_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3996, "WGS_1984_IBCAO_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3997, "WGS_1984_Dubai_Local_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4026, "MOLDREF99_Moldova_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4037, "WGS_1984_TMzn35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4038, "WGS_1984_TMzn36N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4048, "RGRDC_2005_Congo_TM_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4049, "RGRDC_2005_Congo_TM_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4050, "RGRDC_2005_Congo_TM_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4051, "RGRDC_2005_Congo_TM_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4056, "RGRDC_2005_Congo_TM_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4057, "RGRDC_2005_Congo_TM_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4058, "RGRDC_2005_Congo_TM_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4059, "RGRDC_2005_Congo_TM_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4060, "RGRDC_2005_Congo_TM_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4061, "RGRDC_2005_UTM_Zone_33S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4062, "RGRDC_2005_UTM_Zone_34S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4063, "RGRDC_2005_UTM_Zone_35S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4071, "Chua_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4082, "REGCAN95_UTM_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4083, "REGCAN95_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4093, "ETRS_1989_DKTM1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4094, "ETRS_1989_DKTM2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4095, "ETRS_1989_DKTM3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4096, "ETRS_1989_DKTM4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4217, "NAD_1983_BLM_Zone_59N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4399, "NAD_1927_BLM_Zone_59N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4400, "NAD_1927_BLM_Zone_60N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4401, "NAD_1927_BLM_Zone_1N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4402, "NAD_1927_BLM_Zone_2N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4403, "NAD_1927_BLM_Zone_3N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4404, "NAD_1927_BLM_Zone_4N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4405, "NAD_1927_BLM_Zone_5N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4406, "NAD_1927_BLM_Zone_6N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4407, "NAD_1927_BLM_Zone_7N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4408, "NAD_1927_BLM_Zone_8N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4409, "NAD_1927_BLM_Zone_9N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4410, "NAD_1927_BLM_Zone_10N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4411, "NAD_1927_BLM_Zone_11N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4412, "NAD_1927_BLM_Zone_12N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4413, "NAD_1927_BLM_Zone_13N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4414, "NAD_1983_HARN_Guam_Map_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4415, "Katanga_1955_Katanga_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4417, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4418, "NAD_1927_BLM_Zone_18N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4419, "NAD_1927_BLM_Zone_19N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4420, "NAD_1983_BLM_Zone_60N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4421, "NAD_1983_BLM_Zone_1N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4422, "NAD_1983_BLM_Zone_2N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4423, "NAD_1983_BLM_Zone_3N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4424, "NAD_1983_BLM_Zone_4N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4425, "NAD_1983_BLM_Zone_5N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4426, "NAD_1983_BLM_Zone_6N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4427, "NAD_1983_BLM_Zone_7N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4428, "NAD_1983_BLM_Zone_8N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4429, "NAD_1983_BLM_Zone_9N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4430, "NAD_1983_BLM_Zone_10N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4431, "NAD_1983_BLM_Zone_11N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4432, "NAD_1983_BLM_Zone_12N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4433, "NAD_1983_BLM_Zone_13N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4434, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4437, "NAD_1983_NSRS2007_StatePlane_Puerto_Rico_Virgin_Isls_FIPS_5200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4438, "NAD_1983_BLM_Zone_18N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4439, "NAD_1983_BLM_Zone_19N", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4455, "NAD_1927_StatePlane_Pennsylvania_South_FIPS_3702", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4456, "NAD_1927_StatePlane_New_York_Long_Island_FIPS_3104", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4457, "NAD_1983_StatePlane_South_Dakota_North_FIPS_4001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4462, "WGS_1984_Australian_Centre_for_Remote_Sensing_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4467, "RGSPM_2006_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4471, "RGM_2004_UTM_Zone_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4484, "Mexican_Datum_1993_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4485, "Mexican_Datum_1993_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4486, "Mexican_Datum_1993_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4487, "Mexican_Datum_1993_UTM_Zone_14N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4488, "Mexican_Datum_1993_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4489, "Mexican_Datum_1993_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4491, "CGCS2000_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4492, "CGCS2000_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4493, "CGCS2000_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4494, "CGCS2000_GK_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4495, "CGCS2000_GK_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4496, "CGCS2000_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4497, "CGCS2000_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4498, "CGCS2000_GK_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4499, "CGCS2000_GK_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4500, "CGCS2000_GK_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4501, "CGCS2000_GK_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4502, "CGCS2000_GK_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4503, "CGCS2000_GK_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4504, "CGCS2000_GK_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4505, "CGCS2000_GK_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4506, "CGCS2000_GK_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4507, "CGCS2000_GK_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4508, "CGCS2000_GK_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4509, "CGCS2000_GK_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4510, "CGCS2000_GK_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4511, "CGCS2000_GK_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4512, "CGCS2000_GK_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4513, "CGCS2000_3_Degree_GK_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4514, "CGCS2000_3_Degree_GK_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4515, "CGCS2000_3_Degree_GK_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4516, "CGCS2000_3_Degree_GK_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4517, "CGCS2000_3_Degree_GK_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4518, "CGCS2000_3_Degree_GK_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4519, "CGCS2000_3_Degree_GK_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4520, "CGCS2000_3_Degree_GK_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4521, "CGCS2000_3_Degree_GK_Zone_33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4522, "CGCS2000_3_Degree_GK_Zone_34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4523, "CGCS2000_3_Degree_GK_Zone_35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4524, "CGCS2000_3_Degree_GK_Zone_36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4525, "CGCS2000_3_Degree_GK_Zone_37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4526, "CGCS2000_3_Degree_GK_Zone_38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4527, "CGCS2000_3_Degree_GK_Zone_39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4528, "CGCS2000_3_Degree_GK_Zone_40", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4529, "CGCS2000_3_Degree_GK_Zone_41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4530, "CGCS2000_3_Degree_GK_Zone_42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4531, "CGCS2000_3_Degree_GK_Zone_43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4532, "CGCS2000_3_Degree_GK_Zone_44", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4533, "CGCS2000_3_Degree_GK_Zone_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4534, "CGCS2000_3_Degree_GK_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4535, "CGCS2000_3_Degree_GK_CM_78E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4536, "CGCS2000_3_Degree_GK_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4537, "CGCS2000_3_Degree_GK_CM_84E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4538, "CGCS2000_3_Degree_GK_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4539, "CGCS2000_3_Degree_GK_CM_90E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4540, "CGCS2000_3_Degree_GK_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4541, "CGCS2000_3_Degree_GK_CM_96E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4542, "CGCS2000_3_Degree_GK_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4543, "CGCS2000_3_Degree_GK_CM_102E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4544, "CGCS2000_3_Degree_GK_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4545, "CGCS2000_3_Degree_GK_CM_108E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4546, "CGCS2000_3_Degree_GK_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4547, "CGCS2000_3_Degree_GK_CM_114E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4548, "CGCS2000_3_Degree_GK_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4549, "CGCS2000_3_Degree_GK_CM_120E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4550, "CGCS2000_3_Degree_GK_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4551, "CGCS2000_3_Degree_GK_CM_126E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4552, "CGCS2000_3_Degree_GK_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4553, "CGCS2000_3_Degree_GK_CM_132E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4554, "CGCS2000_3_Degree_GK_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4559, "RRAF_1991_UTM_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4568, "New_Beijing_Gauss_Kruger_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4569, "New_Beijing_Gauss_Kruger_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4570, "New_Beijing_Gauss_Kruger_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4571, "New_Beijing_Gauss_Kruger_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4572, "New_Beijing_Gauss_Kruger_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4573, "New_Beijing_Gauss_Kruger_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4574, "New_Beijing_Gauss_Kruger_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4575, "New_Beijing_Gauss_Kruger_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4576, "New_Beijing_Gauss_Kruger_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4577, "New_Beijing_Gauss_Kruger_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4578, "New_Beijing_Gauss_Kruger_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4579, "New_Beijing_Gauss_Kruger_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4580, "New_Beijing_Gauss_Kruger_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4581, "New_Beijing_Gauss_Kruger_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4582, "New_Beijing_Gauss_Kruger_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4583, "New_Beijing_Gauss_Kruger_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4584, "New_Beijing_Gauss_Kruger_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4585, "New_Beijing_Gauss_Kruger_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4586, "New_Beijing_Gauss_Kruger_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4587, "New_Beijing_Gauss_Kruger_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4588, "New_Beijing_Gauss_Kruger_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4589, "New_Beijing_Gauss_Kruger_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4647, "ETRS_1989_UTM_Zone_N32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4652, "New_Beijing_3_Degree_Gauss_Kruger_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4653, "New_Beijing_3_Degree_Gauss_Kruger_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4654, "New_Beijing_3_Degree_Gauss_Kruger_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4655, "New_Beijing_3_Degree_Gauss_Kruger_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4656, "New_Beijing_3_Degree_Gauss_Kruger_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4766, "New_Beijing_3_Degree_Gauss_Kruger_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4767, "New_Beijing_3_Degree_Gauss_Kruger_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4768, "New_Beijing_3_Degree_Gauss_Kruger_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4769, "New_Beijing_3_Degree_Gauss_Kruger_Zone_33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4770, "New_Beijing_3_Degree_Gauss_Kruger_Zone_34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4771, "New_Beijing_3_Degree_Gauss_Kruger_Zone_35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4772, "New_Beijing_3_Degree_Gauss_Kruger_Zone_36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4773, "New_Beijing_3_Degree_Gauss_Kruger_Zone_37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4774, "New_Beijing_3_Degree_Gauss_Kruger_Zone_38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4775, "New_Beijing_3_Degree_Gauss_Kruger_Zone_39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4776, "New_Beijing_3_Degree_Gauss_Kruger_Zone_40", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4777, "New_Beijing_3_Degree_Gauss_Kruger_Zone_41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4778, "New_Beijing_3_Degree_Gauss_Kruger_Zone_42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4779, "New_Beijing_3_Degree_Gauss_Kruger_Zone_43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4780, "New_Beijing_3_Degree_Gauss_Kruger_Zone_44", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4781, "New_Beijing_3_Degree_Gauss_Kruger_Zone_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4782, "New_Beijing_3_Degree_Gauss_Kruger_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4783, "New_Beijing_3_Degree_Gauss_Kruger_CM_78E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4784, "New_Beijing_3_Degree_Gauss_Kruger_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4785, "New_Beijing_3_Degree_Gauss_Kruger_CM_84E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4786, "New_Beijing_3_Degree_Gauss_Kruger_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4787, "New_Beijing_3_Degree_Gauss_Kruger_CM_90E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4788, "New_Beijing_3_Degree_Gauss_Kruger_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4789, "New_Beijing_3_Degree_Gauss_Kruger_CM_96E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4790, "New_Beijing_3_Degree_Gauss_Kruger_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4791, "New_Beijing_3_Degree_Gauss_Kruger_CM_102E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4792, "New_Beijing_3_Degree_Gauss_Kruger_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4793, "New_Beijing_3_Degree_Gauss_Kruger_CM_108E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4794, "New_Beijing_3_Degree_Gauss_Kruger_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4795, "New_Beijing_3_Degree_Gauss_Kruger_CM_114E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4796, "New_Beijing_3_Degree_Gauss_Kruger_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4797, "New_Beijing_3_Degree_Gauss_Kruger_CM_120E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4798, "New_Beijing_3_Degree_Gauss_Kruger_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4799, "New_Beijing_3_Degree_Gauss_Kruger_CM_126E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4800, "New_Beijing_3_Degree_Gauss_Kruger_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4822, "New_Beijing_3_Degree_Gauss_Kruger_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4826, "WGS_1984_Cape_Verde_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 4839, "ETRS_1989_LCC_Germany_N-E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5014, "PTRA08_UTM_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5015, "PTRA08_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5016, "PTRA08_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5018, "Lisbon_Portuguese_Grid_New", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5048, "ETRS_1989_TM35FIN_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5069, "NAD_1927_Contiguous_USA_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5070, "NAD_1983_Contiguous_USA_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5071, "NAD_1983_HARN_Contiguous_USA_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5072, "NAD_1983_NSRS2007_Contiguous_USA_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5105, "ETRS_1989_NTM_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5106, "ETRS_1989_NTM_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5107, "ETRS_1989_NTM_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5108, "ETRS_1989_NTM_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5109, "ETRS_1989_NTM_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5110, "ETRS_1989_NTM_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5111, "ETRS_1989_NTM_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5112, "ETRS_1989_NTM_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5113, "ETRS_1989_NTM_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5114, "ETRS_1989_NTM_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5115, "ETRS_1989_NTM_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5116, "ETRS_1989_NTM_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5117, "ETRS_1989_NTM_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5118, "ETRS_1989_NTM_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5119, "ETRS_1989_NTM_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5120, "ETRS_1989_NTM_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5121, "ETRS_1989_NTM_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5122, "ETRS_1989_NTM_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5123, "ETRS_1989_NTM_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5124, "ETRS_1989_NTM_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5125, "ETRS_1989_NTM_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5126, "ETRS_1989_NTM_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5127, "ETRS_1989_NTM_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5128, "ETRS_1989_NTM_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5129, "ETRS_1989_NTM_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5130, "ETRS_1989_NTM_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5167, "Korean_1985_Korea_East_Sea_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5168, "Korean_1985_Korea_Central_Belt_Jeju", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5173, "Korean_1985_Modified_Korea_West_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5174, "Korean_1985_Modified_Korea_Central_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5175, "Korean_1985_Modified_Korea_Central_Belt_Jeju", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5176, "Korean_1985_Modified_Korea_East_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5177, "Korean_1985_Modified_Korea_East_Sea_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5178, "Korean_1985_Korea_Unified_Coordinate_System", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5179, "Korea_2000_Korea_Unified_Coordinate_System", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5180, "Korea_2000_Korea_West_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5181, "Korea_2000_Korea_Central_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5182, "Korea_2000_Korea_Central_Belt_Jeju", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5183, "Korea_2000_Korea_East_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5184, "Korea_2000_Korea_East_Sea_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5185, "Korea_2000_Korea_West_Belt_2010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5186, "Korea_2000_Korea_Central_Belt_2010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5187, "Korea_2000_Korea_East_Belt_2010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5188, "Korea_2000_Korea_East_Sea_Belt_2010", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5221, "S-JTSK_Ferro_Krovak_East_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5223, "WGS_1984_UTM_Gabon_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5234, "Kandawala_Sri_Lanka_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5235, "SLD99_Sri_Lanka_Grid_1999", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5243, "ETRS_1989_LCC_Germany_E-N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5247, "GDBD2009_GEORSO", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5253, "TUREF_TM27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5254, "TUREF_TM30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5255, "TUREF_TM33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5256, "TUREF_TM36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5257, "TUREF_TM39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5258, "TUREF_TM42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5259, "TUREF_TM45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5266, "DRUKREF_03_Bhutan_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5269, "TUREF_3_Degree_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5270, "TUREF_3_Degree_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5271, "TUREF_3_Degree_GK_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5272, "TUREF_3_Degree_GK_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5273, "TUREF_3_Degree_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5274, "TUREF_3_Degree_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5275, "TUREF_3_Degree_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5292, "DRUKREF_03_Bumthang_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5293, "DRUKREF_03_Chhukha_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5294, "DRUKREF_03_Dagana_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5295, "DRUKREF_03_Gasa_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5296, "DRUKREF_03_Ha_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5297, "DRUKREF_03_Lhuentse_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5298, "DRUKREF_03_Mongar_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5299, "DRUKREF_03_Paro_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5300, "DRUKREF_03_Pemagatshel_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5301, "DRUKREF_03_Punakha_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5302, "DRUKREF_03_Samdrup_Jongkhar_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5303, "DRUKREF_03_Samtse_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5304, "DRUKREF_03_Sarpang_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5305, "DRUKREF_03_Thimphu_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5306, "DRUKREF_03_Trashigang_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5307, "DRUKREF_03_Trongsa_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5308, "DRUKREF_03_Tsirang_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5309, "DRUKREF_03_Wangdue_Phodrang_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5310, "DRUKREF_03_Yangtse_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5311, "DRUKREF_03_Zhemgang_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5316, "ETRS_1989_FAROE_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5320, "NAD_1983_Teranet_Ontario_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5321, "NAD_1983_CSRS_Teranet_Ontario_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5325, "ISN_2004_Lambert_2004", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5329, "Gunung_Segara_Jakarta_NEIEZ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5330, "Batavia_Jakarta_NEIEZ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5331, "Makassar_Jakarta_NEIEZ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5337, "Aratu_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5343, "POSGAR_2007_Argentina_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5344, "POSGAR_2007_Argentina_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5345, "POSGAR_2007_Argentina_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5346, "POSGAR_2007_Argentina_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5347, "POSGAR_2007_Argentina_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5348, "POSGAR_2007_Argentina_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5349, "POSGAR_2007_Argentina_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5355, "MARGEN_UTM_Zone_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5356, "MARGEN_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5357, "MARGEN_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5361, "SIRGAS-Chile_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5362, "SIRGAS-Chile_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5367, "CRTM05", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5382, "SIRGAS-ROU98_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5383, "SIRGAS-ROU98_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5387, "Peru96_UTM_Zone_18S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5389, "Peru96_UTM_Zone_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5396, "SIRGAS_2000_UTM_Zone_26S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5456, "Ocotepeque_1935_Costa_Rica_Norte", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5457, "Ocotepeque_1935_Costa_Rica_Sur", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5459, "Ocotepeque_1935_Guatemala_Sur", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5460, "Ocotepeque_1935_El_Salvador_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5461, "Ocotepeque_1935_Nicaragua_Norte", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5462, "Ocotepeque_1935_Nicaragua_Sur", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5463, "SAD_1969_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5469, "Panama-Colon_1911_Panama_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5472, "Panama-Colon_1911_Panama_Polyconic", "Yard_Clarke", 0.9143917962));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5479, "RSRGD2000_MSLC2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5480, "RSRGD2000_BCLC2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5481, "RSRGD2000_PCLC2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5482, "RSRGD2000_RSPS2000", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5490, "RGAF09_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5513, "S-JTSK_Krovak", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5514, "S-JTSK_Krovak_East_North", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5518, "Chatham_Island_1971_Map_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5519, "Chatham_Islands_1979_Map_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5520, "DHDN_3_Degree_Gauss_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5523, "WGS_1984_UTM_Gabon_TM_2011", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5530, "SAD_1969_96_Brazil_Polyconic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5531, "SAD_1969_96_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5533, "SAD_1969_96_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5534, "SAD_1969_96_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5535, "SAD_1969_96_UTM_Zone_25S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5536, "Corrego_Alegre_1961_UTM_Zone_21S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5537, "Corrego_Alegre_1961_UTM_Zone_22S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5538, "Corrego_Alegre_1961_UTM_Zone_23S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5539, "Corrego_Alegre_1961_UTM_Zone_24S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5550, "PNG94_PNGMG94_Zone_54", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5551, "PNG94_PNGMG94_Zone_55", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5552, "PNG94_PNGMG94_Zone_56", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5559, "Ocotepeque_1935_Guatemala_Norte", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5562, "Ukraine_2000_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5563, "Ukraine_2000_GK_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5564, "Ukraine_2000_GK_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5565, "Ukraine_2000_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5566, "Ukraine_2000_GK_CM_21E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5567, "Ukraine_2000_GK_CM_27E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5568, "Ukraine_2000_GK_CM_33E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5569, "Ukraine_2000_GK_CM_39E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5570, "Ukraine_2000_3_Degree_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 5571, "Ukraine_2000_3_Degree_GK_Zone_8", "Meter", 1.0));
        }
    }

    private static class PCS_1 {
        private PCS_1() {
        }

        static void add(List<CoordinateSystem> list) {
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2000, "Anguilla_1957_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2001, "Antigua_1943_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2002, "Dominica_1945_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2003, "Grenada_1953_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2004, "Montserrat_1958_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2005, "St_Kitts_1955_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2006, "St_Lucia_1955_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2007, "St_Vincent_1945_British_West_Indies_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2008, "NAD_1927_CGQ77_MTM_2_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2009, "NAD_1927_CGQ77_MTM_3_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2010, "NAD_1927_CGQ77_MTM_4_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2011, "NAD_1927_CGQ77_MTM_5_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2012, "NAD_1927_CGQ77_MTM_6_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2013, "NAD_1927_CGQ77_MTM_7_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2014, "NAD_1927_CGQ77_MTM_8_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2015, "NAD_1927_CGQ77_MTM_9_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2016, "NAD_1927_CGQ77_MTM_10_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2017, "NAD_1927_DEF_1976_MTM_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2018, "NAD_1927_DEF_1976_MTM_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2019, "NAD_1927_DEF_1976_MTM_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2020, "NAD_1927_DEF_1976_MTM_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2021, "NAD_1927_DEF_1976_MTM_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2022, "NAD_1927_DEF_1976_MTM_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2023, "NAD_1927_DEF_1976_MTM_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2024, "NAD_1927_DEF_1976_MTM_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2025, "NAD_1927_DEF_1976_MTM_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2026, "NAD_1927_DEF_1976_MTM_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2027, "NAD_1927_DEF_1976_UTM_Zone_15N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2028, "NAD_1927_DEF_1976_UTM_Zone_16N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2029, "NAD_1927_DEF_1976_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2030, "NAD_1927_DEF_1976_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2031, "NAD_1927_CGQ77_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2032, "NAD_1927_CGQ77_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2033, "NAD_1927_CGQ77_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2034, "NAD_1927_CGQ77_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2035, "NAD_1927_CGQ77_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2039, "Israel_TM_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2040, "Locodjo_1965_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2041, "Abidjan_1987_UTM_Zone_30N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2042, "Locodjo_1965_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2043, "Abidjan_1987_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2044, "Hanoi_1972_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2045, "Hanoi_1972_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2056, "CH1903+_LV95", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2057, "Rassadiran_Nakhl_e_Taqi", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2058, "ED_1950_ED77_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2059, "ED_1950_ED77_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2060, "ED_1950_ED77_UTM_Zone_40N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2061, "ED_1950_ED77_UTM_Zone_41N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2062, "Madrid_1870_Madrid_Spain", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2065, "S-JTSK_Ferro_Krovak", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2066, "Mount_Dillon_Tobago_Grid", "Link_Clarke", 0.201166195164));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2067, "Naparima_1955_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2068, "ELD_1979_Libya_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2069, "ELD_1979_Libya_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2070, "ELD_1979_Libya_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2071, "ELD_1979_Libya_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2072, "ELD_1979_Libya_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2073, "ELD_1979_Libya_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2074, "ELD_1979_Libya_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2075, "ELD_1979_Libya_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2076, "ELD_1979_Libya_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2077, "ELD_1979_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2078, "ELD_1979_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2079, "ELD_1979_UTM_Zone_34N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2080, "ELD_1979_UTM_Zone_35N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2081, "Chos_Malal_1914_Argentina_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2082, "Pampa_del_Castillo_Argentina_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2083, "Hito_XVIII_1963_Argentina_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2084, "Hito_XVIII_1963_UTM_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2085, "NAD_1927_Cuba_Norte", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2086, "NAD_1927_Cuba_Sur", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2087, "ELD_1979_TM_12_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2088, "Carthage_TM_11_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2089, "Yemen_NGN_1996_UTM_Zone_38N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2090, "Yemen_NGN_1996_UTM_Zone_39N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2093, "Hanoi_1972_GK_106_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2094, "WGS_1972_BE_TM_106_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2095, "Bissau_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2096, "Korean_1985_Korea_East_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2097, "Korean_1985_Korea_Central_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2098, "Korean_1985_Korea_West_Belt", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2099, "Qatar_1948_Qatar_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2100, "Greek_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2101, "Lake_Maracaibo_Grid_M1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2102, "Lake_Maracaibo_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2103, "Lake_Maracaibo_Grid_M3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2104, "Lake_Maracaibo_La_Rosa_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2105, "NZGD_2000_Mount_Eden_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2106, "NZGD_2000_Bay_of_Plenty_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2107, "NZGD_2000_Poverty_Bay_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2108, "NZGD_2000_Hawkes_Bay_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2109, "NZGD_2000_Taranaki_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2110, "NZGD_2000_Tuhirangi_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2111, "NZGD_2000_Wanganui_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2112, "NZGD_2000_Wairarapa_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2113, "NZGD_2000_Wellington_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2114, "NZGD_2000_Collingwood_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2115, "NZGD_2000_Nelson_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2116, "NZGD_2000_Karamea_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2117, "NZGD_2000_Buller_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2118, "NZGD_2000_Grey_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2119, "NZGD_2000_Amuri_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2120, "NZGD_2000_Marlborough_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2121, "NZGD_2000_Hokitika_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2122, "NZGD_2000_Okarito_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2123, "NZGD_2000_Jacksons_Bay_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2124, "NZGD_2000_Mount_Pleasant_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2125, "NZGD_2000_Gawler_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2126, "NZGD_2000_Timaru_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2127, "NZGD_2000_Lindis_Peak_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2128, "NZGD_2000_Mount_Nicholas_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2129, "NZGD_2000_Mount_York_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2130, "NZGD_2000_Observation_Point_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2131, "NZGD_2000_North_Taieri_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2132, "NZGD_2000_Bluff_Circuit", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2133, "NZGD_2000_UTM_Zone_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2134, "NZGD_2000_UTM_Zone_59S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2135, "NZGD_2000_UTM_Zone_60S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2136, "Accra_Ghana_Grid", "Foot_Gold_Coast", 0.3047997101815088));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2137, "Accra_TM_1_NW", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2138, "NAD_1927_CGQ77_Quebec_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2154, "RGF_1993_Lambert_93", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2157, "IRENET95_Irish_Transverse_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2158, "IRENET95_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2159, "Sierra_Leone_1924_New_Colony_Grid", "Foot_Gold_Coast", 0.3047997101815088));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2160, "Sierra_Leone_1924_New_War_Office_Grid", "Foot_Gold_Coast", 0.3047997101815088));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2161, "Sierra_Leone_1968_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2162, "Sierra_Leone_1968_UTM_Zone_29N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2163, "US_National_Atlas_Equal_Area", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2164, "Locodjo_1965_TM_5_NW", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2165, "Abidjan_1987_TM_5_NW", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2169, "Luxembourg_1930_Gauss", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2170, "MGI_Slovenia_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2172, "Pulkovo_1942_Adj_1958_Poland_Zone_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2173, "Pulkovo_1942_Adj_1958_Poland_Zone_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2174, "Pulkovo_1942_Adj_1958_Poland_Zone_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2175, "Pulkovo_1942_Adj_1958_Poland_Zone_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2176, "ETRS_1989_Poland_CS2000_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2177, "ETRS_1989_Poland_CS2000_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2178, "ETRS_1989_Poland_CS2000_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2179, "ETRS_1989_Poland_CS2000_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2180, "ETRS_1989_Poland_CS92", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2181, "ED_1950_Turkey_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2182, "ED_1950_Turkey_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2183, "ED_1950_Turkey_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2184, "ED_1950_Turkey_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2185, "ED_1950_Turkey_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2186, "ED_1950_Turkey_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2187, "ED_1950_Turkey_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2188, "Azores_Occidental_1939_UTM_Zone_25N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2189, "Azores_Central_1948_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2190, "Azores_Oriental_1940_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2191, "Madeira_1936_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2192, "ED_1950_France_EuroLambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2193, "NZGD_2000_New_Zealand_Transverse_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2195, "NAD_1983_HARN_UTM_Zone_2S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2196, "ETRS_1989_Kp2000_Jutland", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2197, "ETRS_1989_Kp2000_Zealand", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2198, "ETRS_1989_Kp2000_Bornholm", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2200, "ATS_1977_New_Brunswick_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2201, "REGVEN_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2202, "REGVEN_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2203, "REGVEN_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2204, "NAD_1927_StatePlane_Tennessee_FIPS_4100", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2205, "NAD_1983_StatePlane_Kentucky_North_FIPS_1601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2206, "ED_1950_3_Degree_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2207, "ED_1950_3_Degree_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2208, "ED_1950_3_Degree_GK_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2209, "ED_1950_3_Degree_GK_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2210, "ED_1950_3_Degree_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2211, "ED_1950_3_Degree_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2212, "ED_1950_3_Degree_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2213, "ETRS_1989_TM_30_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2215, "Manoca_1962_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2216, "Qornoq_1927_UTM_Zone_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2217, "Qornoq_1927_UTM_Zone_23N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2219, "ATS_1977_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2220, "ATS_1977_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2222, "NAD_1983_StatePlane_Arizona_East_FIPS_0201_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2223, "NAD_1983_StatePlane_Arizona_Central_FIPS_0202_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2224, "NAD_1983_StatePlane_Arizona_West_FIPS_0203_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2225, "NAD_1983_StatePlane_California_I_FIPS_0401_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2226, "NAD_1983_StatePlane_California_II_FIPS_0402_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2227, "NAD_1983_StatePlane_California_III_FIPS_0403_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2228, "NAD_1983_StatePlane_California_IV_FIPS_0404_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2229, "NAD_1983_StatePlane_California_V_FIPS_0405_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2230, "NAD_1983_StatePlane_California_VI_FIPS_0406_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2231, "NAD_1983_StatePlane_Colorado_North_FIPS_0501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2232, "NAD_1983_StatePlane_Colorado_Central_FIPS_0502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2233, "NAD_1983_StatePlane_Colorado_South_FIPS_0503_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2234, "NAD_1983_StatePlane_Connecticut_FIPS_0600_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2235, "NAD_1983_StatePlane_Delaware_FIPS_0700_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2236, "NAD_1983_StatePlane_Florida_East_FIPS_0901_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2237, "NAD_1983_StatePlane_Florida_West_FIPS_0902_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2238, "NAD_1983_StatePlane_Florida_North_FIPS_0903_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2239, "NAD_1983_StatePlane_Georgia_East_FIPS_1001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2240, "NAD_1983_StatePlane_Georgia_West_FIPS_1002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2241, "NAD_1983_StatePlane_Idaho_East_FIPS_1101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2242, "NAD_1983_StatePlane_Idaho_Central_FIPS_1102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2243, "NAD_1983_StatePlane_Idaho_West_FIPS_1103_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2246, "NAD_1983_StatePlane_Kentucky_North_FIPS_1601_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2247, "NAD_1983_StatePlane_Kentucky_South_FIPS_1602_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2248, "NAD_1983_StatePlane_Maryland_FIPS_1900_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2249, "NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2250, "NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2251, "NAD_1983_StatePlane_Michigan_North_FIPS_2111_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2252, "NAD_1983_StatePlane_Michigan_Central_FIPS_2112_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2253, "NAD_1983_StatePlane_Michigan_South_FIPS_2113_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2254, "NAD_1983_StatePlane_Mississippi_East_FIPS_2301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2255, "NAD_1983_StatePlane_Mississippi_West_FIPS_2302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2256, "NAD_1983_StatePlane_Montana_FIPS_2500_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2257, "NAD_1983_StatePlane_New_Mexico_East_FIPS_3001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2258, "NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2259, "NAD_1983_StatePlane_New_Mexico_West_FIPS_3003_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2260, "NAD_1983_StatePlane_New_York_East_FIPS_3101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2261, "NAD_1983_StatePlane_New_York_Central_FIPS_3102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2262, "NAD_1983_StatePlane_New_York_West_FIPS_3103_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2263, "NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2264, "NAD_1983_StatePlane_North_Carolina_FIPS_3200_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2265, "NAD_1983_StatePlane_North_Dakota_North_FIPS_3301_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2266, "NAD_1983_StatePlane_North_Dakota_South_FIPS_3302_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2267, "NAD_1983_StatePlane_Oklahoma_North_FIPS_3501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2268, "NAD_1983_StatePlane_Oklahoma_South_FIPS_3502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2269, "NAD_1983_StatePlane_Oregon_North_FIPS_3601_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2270, "NAD_1983_StatePlane_Oregon_South_FIPS_3602_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2271, "NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2272, "NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2273, "NAD_1983_StatePlane_South_Carolina_FIPS_3900_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2274, "NAD_1983_StatePlane_Tennessee_FIPS_4100_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2275, "NAD_1983_StatePlane_Texas_North_FIPS_4201_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2276, "NAD_1983_StatePlane_Texas_North_Central_FIPS_4202_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2277, "NAD_1983_StatePlane_Texas_Central_FIPS_4203_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2278, "NAD_1983_StatePlane_Texas_South_Central_FIPS_4204_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2279, "NAD_1983_StatePlane_Texas_South_FIPS_4205_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2280, "NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2281, "NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2282, "NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2283, "NAD_1983_StatePlane_Virginia_North_FIPS_4501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2284, "NAD_1983_StatePlane_Virginia_South_FIPS_4502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2285, "NAD_1983_StatePlane_Washington_North_FIPS_4601_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2286, "NAD_1983_StatePlane_Washington_South_FIPS_4602_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2287, "NAD_1983_StatePlane_Wisconsin_North_FIPS_4801_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2288, "NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2289, "NAD_1983_StatePlane_Wisconsin_South_FIPS_4803_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2290, "Prince_Edward_Island_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2294, "ATS_1977_MTM_4_Nova_Scotia", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2295, "ATS_1977_MTM_5_Nova_Scotia", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2308, "Batavia_TM_109_SE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2309, "WGS_1984_TM_116_SE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2310, "WGS_1984_TM_132_SE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2311, "WGS_1984_TM_6_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2312, "Garoua_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2313, "Kousseri_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2314, "Trinidad_1903_Trinidad_Grid_Feet_Clarke", "Foot_Clarke", 0.3047972654));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2315, "Campo_Inchauspe_UTM_19S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2316, "Campo_Inchauspe_UTM_20S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2317, "PSAD_1956_ICN_Regional", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2318, "Ain_el_Abd_Aramco_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2319, "ED_1950_TM27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2320, "ED_1950_TM30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2321, "ED_1950_TM33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2322, "ED_1950_TM36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2323, "ED_1950_TM39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2324, "ED_1950_TM42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2325, "ED_1950_TM45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2326, "Hong_Kong_1980_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2327, "Xian_1980_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2328, "Xian_1980_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2329, "Xian_1980_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2330, "Xian_1980_GK_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2331, "Xian_1980_GK_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2332, "Xian_1980_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2333, "Xian_1980_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2334, "Xian_1980_GK_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2335, "Xian_1980_GK_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2336, "Xian_1980_GK_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2337, "Xian_1980_GK_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2338, "Xian_1980_GK_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2339, "Xian_1980_GK_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2340, "Xian_1980_GK_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2341, "Xian_1980_GK_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2342, "Xian_1980_GK_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2343, "Xian_1980_GK_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2344, "Xian_1980_GK_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2345, "Xian_1980_GK_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2346, "Xian_1980_GK_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2347, "Xian_1980_GK_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2348, "Xian_1980_GK_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2349, "Xian_1980_3_Degree_GK_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2350, "Xian_1980_3_Degree_GK_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2351, "Xian_1980_3_Degree_GK_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2352, "Xian_1980_3_Degree_GK_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2353, "Xian_1980_3_Degree_GK_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2354, "Xian_1980_3_Degree_GK_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2355, "Xian_1980_3_Degree_GK_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2356, "Xian_1980_3_Degree_GK_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2357, "Xian_1980_3_Degree_GK_Zone_33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2358, "Xian_1980_3_Degree_GK_Zone_34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2359, "Xian_1980_3_Degree_GK_Zone_35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2360, "Xian_1980_3_Degree_GK_Zone_36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2361, "Xian_1980_3_Degree_GK_Zone_37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2362, "Xian_1980_3_Degree_GK_Zone_38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2363, "Xian_1980_3_Degree_GK_Zone_39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2364, "Xian_1980_3_Degree_GK_Zone_40", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2365, "Xian_1980_3_Degree_GK_Zone_41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2366, "Xian_1980_3_Degree_GK_Zone_42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2367, "Xian_1980_3_Degree_GK_Zone_43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2368, "Xian_1980_3_Degree_GK_Zone_44", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2369, "Xian_1980_3_Degree_GK_Zone_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2370, "Xian_1980_3_Degree_GK_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2371, "Xian_1980_3_Degree_GK_CM_78E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2372, "Xian_1980_3_Degree_GK_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2373, "Xian_1980_3_Degree_GK_CM_84E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2374, "Xian_1980_3_Degree_GK_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2375, "Xian_1980_3_Degree_GK_CM_90E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2376, "Xian_1980_3_Degree_GK_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2377, "Xian_1980_3_Degree_GK_CM_96E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2378, "Xian_1980_3_Degree_GK_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2379, "Xian_1980_3_Degree_GK_CM_102E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2380, "Xian_1980_3_Degree_GK_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2381, "Xian_1980_3_Degree_GK_CM_108E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2382, "Xian_1980_3_Degree_GK_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2383, "Xian_1980_3_Degree_GK_CM_114E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2384, "Xian_1980_3_Degree_GK_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2385, "Xian_1980_3_Degree_GK_CM_120E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2386, "Xian_1980_3_Degree_GK_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2387, "Xian_1980_3_Degree_GK_CM_126E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2388, "Xian_1980_3_Degree_GK_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2389, "Xian_1980_3_Degree_GK_CM_132E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2390, "Xian_1980_3_Degree_GK_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2391, "Finland_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2392, "Finland_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2393, "Finland_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2394, "Finland_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2395, "South_Yemen_GK_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2396, "South_Yemen_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2397, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2398, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2399, "Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2400, "RT90_25_gon_W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2401, "Beijing_1954_3_Degree_GK_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2402, "Beijing_1954_3_Degree_GK_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2403, "Beijing_1954_3_Degree_GK_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2404, "Beijing_1954_3_Degree_GK_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2405, "Beijing_1954_3_Degree_GK_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2406, "Beijing_1954_3_Degree_GK_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2407, "Beijing_1954_3_Degree_GK_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2408, "Beijing_1954_3_Degree_GK_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2409, "Beijing_1954_3_Degree_GK_Zone_33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2410, "Beijing_1954_3_Degree_GK_Zone_34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2411, "Beijing_1954_3_Degree_GK_Zone_35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2412, "Beijing_1954_3_Degree_GK_Zone_36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2413, "Beijing_1954_3_Degree_GK_Zone_37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2414, "Beijing_1954_3_Degree_GK_Zone_38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2415, "Beijing_1954_3_Degree_GK_Zone_39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2416, "Beijing_1954_3_Degree_GK_Zone_40", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2417, "Beijing_1954_3_Degree_GK_Zone_41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2418, "Beijing_1954_3_Degree_GK_Zone_42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2419, "Beijing_1954_3_Degree_GK_Zone_43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2420, "Beijing_1954_3_Degree_GK_Zone_44", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2421, "Beijing_1954_3_Degree_GK_Zone_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2422, "Beijing_1954_3_Degree_GK_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2423, "Beijing_1954_3_Degree_GK_CM_78E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2424, "Beijing_1954_3_Degree_GK_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2425, "Beijing_1954_3_Degree_GK_CM_84E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2426, "Beijing_1954_3_Degree_GK_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2427, "Beijing_1954_3_Degree_GK_CM_90E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2428, "Beijing_1954_3_Degree_GK_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2429, "Beijing_1954_3_Degree_GK_CM_96E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2430, "Beijing_1954_3_Degree_GK_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2431, "Beijing_1954_3_Degree_GK_CM_102E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2432, "Beijing_1954_3_Degree_GK_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2433, "Beijing_1954_3_Degree_GK_CM_108E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2434, "Beijing_1954_3_Degree_GK_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2435, "Beijing_1954_3_Degree_GK_CM_114E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2436, "Beijing_1954_3_Degree_GK_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2437, "Beijing_1954_3_Degree_GK_CM_120E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2438, "Beijing_1954_3_Degree_GK_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2439, "Beijing_1954_3_Degree_GK_CM_126E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2440, "Beijing_1954_3_Degree_GK_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2441, "Beijing_1954_3_Degree_GK_CM_132E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2442, "Beijing_1954_3_Degree_GK_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2443, "JGD_2000_Japan_Zone_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2444, "JGD_2000_Japan_Zone_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2445, "JGD_2000_Japan_Zone_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2446, "JGD_2000_Japan_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2447, "JGD_2000_Japan_Zone_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2448, "JGD_2000_Japan_Zone_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2449, "JGD_2000_Japan_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2450, "JGD_2000_Japan_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2451, "JGD_2000_Japan_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2452, "JGD_2000_Japan_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2453, "JGD_2000_Japan_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2454, "JGD_2000_Japan_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2455, "JGD_2000_Japan_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2456, "JGD_2000_Japan_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2457, "JGD_2000_Japan_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2458, "JGD_2000_Japan_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2459, "JGD_2000_Japan_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2460, "JGD_2000_Japan_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2461, "JGD_2000_Japan_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2462, "Albanian_1987_GK_Zone_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2523, "Pulkovo_1942_3_Degree_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2524, "Pulkovo_1942_3_Degree_GK_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2525, "Pulkovo_1942_3_Degree_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2526, "Pulkovo_1942_3_Degree_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2527, "Pulkovo_1942_3_Degree_GK_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2528, "Pulkovo_1942_3_Degree_GK_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2529, "Pulkovo_1942_3_Degree_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2530, "Pulkovo_1942_3_Degree_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2531, "Pulkovo_1942_3_Degree_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2532, "Pulkovo_1942_3_Degree_GK_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2533, "Pulkovo_1942_3_Degree_GK_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2534, "Pulkovo_1942_3_Degree_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2535, "Pulkovo_1942_3_Degree_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2536, "Pulkovo_1942_3_Degree_GK_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2537, "Pulkovo_1942_3_Degree_GK_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2538, "Pulkovo_1942_3_Degree_GK_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2539, "Pulkovo_1942_3_Degree_GK_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2540, "Pulkovo_1942_3_Degree_GK_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2541, "Pulkovo_1942_3_Degree_GK_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2542, "Pulkovo_1942_3_Degree_GK_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2543, "Pulkovo_1942_3_Degree_GK_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2544, "Pulkovo_1942_3_Degree_GK_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2545, "Pulkovo_1942_3_Degree_GK_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2546, "Pulkovo_1942_3_Degree_GK_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2547, "Pulkovo_1942_3_Degree_GK_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2548, "Pulkovo_1942_3_Degree_GK_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2549, "Pulkovo_1942_3_Degree_GK_Zone_33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2550, "Samboja_UTM_Zone_50S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2551, "Pulkovo_1942_3_Degree_GK_Zone_34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2552, "Pulkovo_1942_3_Degree_GK_Zone_35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2553, "Pulkovo_1942_3_Degree_GK_Zone_36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2554, "Pulkovo_1942_3_Degree_GK_Zone_37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2555, "Pulkovo_1942_3_Degree_GK_Zone_38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2556, "Pulkovo_1942_3_Degree_GK_Zone_39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2557, "Pulkovo_1942_3_Degree_GK_Zone_40", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2558, "Pulkovo_1942_3_Degree_GK_Zone_41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2559, "Pulkovo_1942_3_Degree_GK_Zone_42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2560, "Pulkovo_1942_3_Degree_GK_Zone_43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2561, "Pulkovo_1942_3_Degree_GK_Zone_44", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2562, "Pulkovo_1942_3_Degree_GK_Zone_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2563, "Pulkovo_1942_3_Degree_GK_Zone_46", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2564, "Pulkovo_1942_3_Degree_GK_Zone_47", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2565, "Pulkovo_1942_3_Degree_GK_Zone_48", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2566, "Pulkovo_1942_3_Degree_GK_Zone_49", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2567, "Pulkovo_1942_3_Degree_GK_Zone_50", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2568, "Pulkovo_1942_3_Degree_GK_Zone_51", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2569, "Pulkovo_1942_3_Degree_GK_Zone_52", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2570, "Pulkovo_1942_3_Degree_GK_Zone_53", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2571, "Pulkovo_1942_3_Degree_GK_Zone_54", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2572, "Pulkovo_1942_3_Degree_GK_Zone_55", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2573, "Pulkovo_1942_3_Degree_GK_Zone_56", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2574, "Pulkovo_1942_3_Degree_GK_Zone_57", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2575, "Pulkovo_1942_3_Degree_GK_Zone_58", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2576, "Pulkovo_1942_3_Degree_GK_Zone_59", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2578, "Pulkovo_1942_3_Degree_GK_Zone_61", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2579, "Pulkovo_1942_3_Degree_GK_Zone_62", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2580, "Pulkovo_1942_3_Degree_GK_Zone_63", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2581, "Pulkovo_1942_3_Degree_GK_Zone_64", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2582, "Pulkovo_1942_3_Degree_GK_CM_21E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2583, "Pulkovo_1942_3_Degree_GK_CM_24E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2584, "Pulkovo_1942_3_Degree_GK_CM_27E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2585, "Pulkovo_1942_3_Degree_GK_CM_30E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2586, "Pulkovo_1942_3_Degree_GK_CM_33E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2587, "Pulkovo_1942_3_Degree_GK_CM_36E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2588, "Pulkovo_1942_3_Degree_GK_CM_39E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2589, "Pulkovo_1942_3_Degree_GK_CM_42E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2590, "Pulkovo_1942_3_Degree_GK_CM_45E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2591, "Pulkovo_1942_3_Degree_GK_CM_48E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2592, "Pulkovo_1942_3_Degree_GK_CM_51E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2593, "Pulkovo_1942_3_Degree_GK_CM_54E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2594, "Pulkovo_1942_3_Degree_GK_CM_57E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2595, "Pulkovo_1942_3_Degree_GK_CM_60E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2596, "Pulkovo_1942_3_Degree_GK_CM_63E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2597, "Pulkovo_1942_3_Degree_GK_CM_66E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2598, "Pulkovo_1942_3_Degree_GK_CM_69E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2599, "Pulkovo_1942_3_Degree_GK_CM_72E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2601, "Pulkovo_1942_3_Degree_GK_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2602, "Pulkovo_1942_3_Degree_GK_CM_78E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2603, "Pulkovo_1942_3_Degree_GK_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2604, "Pulkovo_1942_3_Degree_GK_CM_84E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2605, "Pulkovo_1942_3_Degree_GK_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2606, "Pulkovo_1942_3_Degree_GK_CM_90E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2607, "Pulkovo_1942_3_Degree_GK_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2608, "Pulkovo_1942_3_Degree_GK_CM_96E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2609, "Pulkovo_1942_3_Degree_GK_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2610, "Pulkovo_1942_3_Degree_GK_CM_102E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2611, "Pulkovo_1942_3_Degree_GK_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2612, "Pulkovo_1942_3_Degree_GK_CM_108E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2613, "Pulkovo_1942_3_Degree_GK_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2614, "Pulkovo_1942_3_Degree_GK_CM_114E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2615, "Pulkovo_1942_3_Degree_GK_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2616, "Pulkovo_1942_3_Degree_GK_CM_120E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2617, "Pulkovo_1942_3_Degree_GK_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2618, "Pulkovo_1942_3_Degree_GK_CM_126E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2619, "Pulkovo_1942_3_Degree_GK_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2620, "Pulkovo_1942_3_Degree_GK_CM_132E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2621, "Pulkovo_1942_3_Degree_GK_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2622, "Pulkovo_1942_3_Degree_GK_CM_138E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2623, "Pulkovo_1942_3_Degree_GK_CM_141E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2624, "Pulkovo_1942_3_Degree_GK_CM_144E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2625, "Pulkovo_1942_3_Degree_GK_CM_147E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2626, "Pulkovo_1942_3_Degree_GK_CM_150E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2627, "Pulkovo_1942_3_Degree_GK_CM_153E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2628, "Pulkovo_1942_3_Degree_GK_CM_156E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2629, "Pulkovo_1942_3_Degree_GK_CM_159E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2630, "Pulkovo_1942_3_Degree_GK_CM_162E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2631, "Pulkovo_1942_3_Degree_GK_CM_165E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2632, "Pulkovo_1942_3_Degree_GK_CM_168E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2633, "Pulkovo_1942_3_Degree_GK_CM_171E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2634, "Pulkovo_1942_3_Degree_GK_CM_174E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2635, "Pulkovo_1942_3_Degree_GK_CM_177E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2636, "Pulkovo_1942_3_Degree_GK_CM_180E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2637, "Pulkovo_1942_3_Degree_GK_CM_177W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2638, "Pulkovo_1942_3_Degree_GK_CM_174W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2639, "Pulkovo_1942_3_Degree_GK_CM_171W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2640, "Pulkovo_1942_3_Degree_GK_CM_168W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2641, "Pulkovo_1995_3_Degree_GK_Zone_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2642, "Pulkovo_1995_3_Degree_GK_Zone_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2643, "Pulkovo_1995_3_Degree_GK_Zone_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2644, "Pulkovo_1995_3_Degree_GK_Zone_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2645, "Pulkovo_1995_3_Degree_GK_Zone_11", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2646, "Pulkovo_1995_3_Degree_GK_Zone_12", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2647, "Pulkovo_1995_3_Degree_GK_Zone_13", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2648, "Pulkovo_1995_3_Degree_GK_Zone_14", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2649, "Pulkovo_1995_3_Degree_GK_Zone_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2650, "Pulkovo_1995_3_Degree_GK_Zone_16", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2651, "Pulkovo_1995_3_Degree_GK_Zone_17", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2652, "Pulkovo_1995_3_Degree_GK_Zone_18", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2653, "Pulkovo_1995_3_Degree_GK_Zone_19", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2654, "Pulkovo_1995_3_Degree_GK_Zone_20", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2655, "Pulkovo_1995_3_Degree_GK_Zone_21", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2656, "Pulkovo_1995_3_Degree_GK_Zone_22", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2657, "Pulkovo_1995_3_Degree_GK_Zone_23", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2658, "Pulkovo_1995_3_Degree_GK_Zone_24", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2659, "Pulkovo_1995_3_Degree_GK_Zone_25", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2660, "Pulkovo_1995_3_Degree_GK_Zone_26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2661, "Pulkovo_1995_3_Degree_GK_Zone_27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2662, "Pulkovo_1995_3_Degree_GK_Zone_28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2663, "Pulkovo_1995_3_Degree_GK_Zone_29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2664, "Pulkovo_1995_3_Degree_GK_Zone_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2665, "Pulkovo_1995_3_Degree_GK_Zone_31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2666, "Pulkovo_1995_3_Degree_GK_Zone_32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2667, "Pulkovo_1995_3_Degree_GK_Zone_33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2668, "Pulkovo_1995_3_Degree_GK_Zone_34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2669, "Pulkovo_1995_3_Degree_GK_Zone_35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2670, "Pulkovo_1995_3_Degree_GK_Zone_36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2671, "Pulkovo_1995_3_Degree_GK_Zone_37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2672, "Pulkovo_1995_3_Degree_GK_Zone_38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2673, "Pulkovo_1995_3_Degree_GK_Zone_39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2674, "Pulkovo_1995_3_Degree_GK_Zone_40", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2675, "Pulkovo_1995_3_Degree_GK_Zone_41", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2676, "Pulkovo_1995_3_Degree_GK_Zone_42", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2677, "Pulkovo_1995_3_Degree_GK_Zone_43", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2678, "Pulkovo_1995_3_Degree_GK_Zone_44", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2679, "Pulkovo_1995_3_Degree_GK_Zone_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2680, "Pulkovo_1995_3_Degree_GK_Zone_46", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2681, "Pulkovo_1995_3_Degree_GK_Zone_47", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2682, "Pulkovo_1995_3_Degree_GK_Zone_48", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2683, "Pulkovo_1995_3_Degree_GK_Zone_49", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2684, "Pulkovo_1995_3_Degree_GK_Zone_50", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2685, "Pulkovo_1995_3_Degree_GK_Zone_51", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2686, "Pulkovo_1995_3_Degree_GK_Zone_52", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2687, "Pulkovo_1995_3_Degree_GK_Zone_53", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2688, "Pulkovo_1995_3_Degree_GK_Zone_54", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2689, "Pulkovo_1995_3_Degree_GK_Zone_55", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2690, "Pulkovo_1995_3_Degree_GK_Zone_56", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2691, "Pulkovo_1995_3_Degree_GK_Zone_57", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2692, "Pulkovo_1995_3_Degree_GK_Zone_58", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2693, "Pulkovo_1995_3_Degree_GK_Zone_59", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2695, "Pulkovo_1995_3_Degree_GK_Zone_61", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2696, "Pulkovo_1995_3_Degree_GK_Zone_62", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2697, "Pulkovo_1995_3_Degree_GK_Zone_63", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2698, "Pulkovo_1995_3_Degree_GK_Zone_64", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2699, "Pulkovo_1995_3_Degree_GK_CM_21E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2700, "Pulkovo_1995_3_Degree_GK_CM_24E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2701, "Pulkovo_1995_3_Degree_GK_CM_27E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2702, "Pulkovo_1995_3_Degree_GK_CM_30E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2703, "Pulkovo_1995_3_Degree_GK_CM_33E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2704, "Pulkovo_1995_3_Degree_GK_CM_36E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2705, "Pulkovo_1995_3_Degree_GK_CM_39E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2706, "Pulkovo_1995_3_Degree_GK_CM_42E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2707, "Pulkovo_1995_3_Degree_GK_CM_45E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2708, "Pulkovo_1995_3_Degree_GK_CM_48E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2709, "Pulkovo_1995_3_Degree_GK_CM_51E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2710, "Pulkovo_1995_3_Degree_GK_CM_54E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2711, "Pulkovo_1995_3_Degree_GK_CM_57E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2712, "Pulkovo_1995_3_Degree_GK_CM_60E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2713, "Pulkovo_1995_3_Degree_GK_CM_63E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2714, "Pulkovo_1995_3_Degree_GK_CM_66E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2715, "Pulkovo_1995_3_Degree_GK_CM_69E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2716, "Pulkovo_1995_3_Degree_GK_CM_72E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2717, "Pulkovo_1995_3_Degree_GK_CM_75E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2718, "Pulkovo_1995_3_Degree_GK_CM_78E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2719, "Pulkovo_1995_3_Degree_GK_CM_81E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2720, "Pulkovo_1995_3_Degree_GK_CM_84E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2721, "Pulkovo_1995_3_Degree_GK_CM_87E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2722, "Pulkovo_1995_3_Degree_GK_CM_90E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2723, "Pulkovo_1995_3_Degree_GK_CM_93E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2724, "Pulkovo_1995_3_Degree_GK_CM_96E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2725, "Pulkovo_1995_3_Degree_GK_CM_99E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2726, "Pulkovo_1995_3_Degree_GK_CM_102E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2727, "Pulkovo_1995_3_Degree_GK_CM_105E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2728, "Pulkovo_1995_3_Degree_GK_CM_108E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2729, "Pulkovo_1995_3_Degree_GK_CM_111E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2730, "Pulkovo_1995_3_Degree_GK_CM_114E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2731, "Pulkovo_1995_3_Degree_GK_CM_117E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2732, "Pulkovo_1995_3_Degree_GK_CM_120E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2733, "Pulkovo_1995_3_Degree_GK_CM_123E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2734, "Pulkovo_1995_3_Degree_GK_CM_126E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2735, "Pulkovo_1995_3_Degree_GK_CM_129E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2736, "Tete_UTM_Zone_36S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2737, "Tete_UTM_Zone_37S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2738, "Pulkovo_1995_3_Degree_GK_CM_132E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2739, "Pulkovo_1995_3_Degree_GK_CM_135E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2740, "Pulkovo_1995_3_Degree_GK_CM_138E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2741, "Pulkovo_1995_3_Degree_GK_CM_141E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2742, "Pulkovo_1995_3_Degree_GK_CM_144E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2743, "Pulkovo_1995_3_Degree_GK_CM_147E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2744, "Pulkovo_1995_3_Degree_GK_CM_150E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2745, "Pulkovo_1995_3_Degree_GK_CM_153E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2746, "Pulkovo_1995_3_Degree_GK_CM_156E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2747, "Pulkovo_1995_3_Degree_GK_CM_159E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2748, "Pulkovo_1995_3_Degree_GK_CM_162E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2749, "Pulkovo_1995_3_Degree_GK_CM_165E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2750, "Pulkovo_1995_3_Degree_GK_CM_168E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2751, "Pulkovo_1995_3_Degree_GK_CM_171E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2752, "Pulkovo_1995_3_Degree_GK_CM_174E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2753, "Pulkovo_1995_3_Degree_GK_CM_177E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2754, "Pulkovo_1995_3_Degree_GK_CM_180E", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2755, "Pulkovo_1995_3_Degree_GK_CM_177W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2756, "Pulkovo_1995_3_Degree_GK_CM_174W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2757, "Pulkovo_1995_3_Degree_GK_CM_171W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2758, "Pulkovo_1995_3_Degree_GK_CM_168W", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2759, "NAD_1983_HARN_StatePlane_Alabama_East_FIPS_0101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2760, "NAD_1983_HARN_StatePlane_Alabama_West_FIPS_0102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2761, "NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2762, "NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2763, "NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2764, "NAD_1983_HARN_StatePlane_Arkansas_North_FIPS_0301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2765, "NAD_1983_HARN_StatePlane_Arkansas_South_FIPS_0302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2766, "NAD_1983_HARN_StatePlane_California_I_FIPS_0401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2767, "NAD_1983_HARN_StatePlane_California_II_FIPS_0402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2768, "NAD_1983_HARN_StatePlane_California_III_FIPS_0403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2769, "NAD_1983_HARN_StatePlane_California_IV_FIPS_0404", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2770, "NAD_1983_HARN_StatePlane_California_V_FIPS_0405", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2771, "NAD_1983_HARN_StatePlane_California_VI_FIPS_0406", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2772, "NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2773, "NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2774, "NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2775, "NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2776, "NAD_1983_HARN_StatePlane_Delaware_FIPS_0700", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2777, "NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2778, "NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2779, "NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2780, "NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2781, "NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2782, "NAD_1983_HARN_StatePlane_Hawaii_1_FIPS_5101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2783, "NAD_1983_HARN_StatePlane_Hawaii_2_FIPS_5102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2784, "NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2785, "NAD_1983_HARN_StatePlane_Hawaii_4_FIPS_5104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2786, "NAD_1983_HARN_StatePlane_Hawaii_5_FIPS_5105", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2787, "NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2788, "NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2789, "NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2790, "NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2791, "NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2792, "NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2793, "NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2794, "NAD_1983_HARN_StatePlane_Iowa_North_FIPS_1401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2795, "NAD_1983_HARN_StatePlane_Iowa_South_FIPS_1402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2796, "NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2797, "NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2798, "NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2799, "NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2800, "NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2801, "NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2802, "NAD_1983_HARN_StatePlane_Maine_East_FIPS_1801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2803, "NAD_1983_HARN_StatePlane_Maine_West_FIPS_1802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2804, "NAD_1983_HARN_StatePlane_Maryland_FIPS_1900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2805, "NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2806, "NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2807, "NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2808, "NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2112", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2809, "NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2810, "NAD_1983_HARN_StatePlane_Minnesota_North_FIPS_2201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2811, "NAD_1983_HARN_StatePlane_Minnesota_Central_FIPS_2202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2812, "NAD_1983_HARN_StatePlane_Minnesota_South_FIPS_2203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2813, "NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2814, "NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2815, "NAD_1983_HARN_StatePlane_Missouri_East_FIPS_2401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2816, "NAD_1983_HARN_StatePlane_Missouri_Central_FIPS_2402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2817, "NAD_1983_HARN_StatePlane_Missouri_West_FIPS_2403", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2818, "NAD_1983_HARN_StatePlane_Montana_FIPS_2500", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2819, "NAD_1983_HARN_StatePlane_Nebraska_FIPS_2600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2820, "NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2821, "NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2822, "NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2823, "NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2824, "NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2825, "NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2826, "NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2827, "NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2828, "NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2829, "NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2830, "NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2831, "NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2832, "NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2833, "NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2834, "NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2835, "NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2836, "NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2837, "NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2838, "NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2839, "NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2840, "NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2841, "NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2842, "NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2843, "NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2844, "NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2845, "NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2846, "NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2847, "NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2848, "NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2849, "NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2850, "NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2851, "NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2852, "NAD_1983_HARN_StatePlane_Vermont_FIPS_4400", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2853, "NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2854, "NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2855, "NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2856, "NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2857, "NAD_1983_HARN_StatePlane_West_Virginia_North_FIPS_4701", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2858, "NAD_1983_HARN_StatePlane_West_Virginia_South_FIPS_4702", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2859, "NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2860, "NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2861, "NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2862, "NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2863, "NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2864, "NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2865, "NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2866, "NAD_1983_HARN_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2867, "NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2868, "NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2869, "NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2870, "NAD_1983_HARN_StatePlane_California_I_FIPS_0401_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2871, "NAD_1983_HARN_StatePlane_California_II_FIPS_0402_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2872, "NAD_1983_HARN_StatePlane_California_III_FIPS_0403_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2873, "NAD_1983_HARN_StatePlane_California_IV_FIPS_0404_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2874, "NAD_1983_HARN_StatePlane_California_V_FIPS_0405_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2875, "NAD_1983_HARN_StatePlane_California_VI_FIPS_0406_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2876, "NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2877, "NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2878, "NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2879, "NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2880, "NAD_1983_HARN_StatePlane_Delaware_FIPS_0700_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2881, "NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2882, "NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2883, "NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2884, "NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2885, "NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2886, "NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2887, "NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2888, "NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2891, "NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2892, "NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2893, "NAD_1983_HARN_StatePlane_Maryland_FIPS_1900_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2894, "NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2895, "NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2896, "NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2897, "NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2112_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2898, "NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2899, "NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2900, "NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2901, "NAD_1983_HARN_StatePlane_Montana_FIPS_2500_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2902, "NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2903, "NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2904, "NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2905, "NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2906, "NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2907, "NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2908, "NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2909, "NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2910, "NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2911, "NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2912, "NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2913, "NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2914, "NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2915, "NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2916, "NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2917, "NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2918, "NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2919, "NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2920, "NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2921, "NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2922, "NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2923, "NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2924, "NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2925, "NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2926, "NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2927, "NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2928, "NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2929, "NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2930, "NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2931, "Beduaram_TM_13_NE", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2932, "QND_1995_Qatar_National_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2933, "Gunung_Segara_UTM_Zone_50S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2935, "Pulkovo_1942_CS63_Zone_A1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2936, "Pulkovo_1942_CS63_Zone_A2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2937, "Pulkovo_1942_CS63_Zone_A3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2938, "Pulkovo_1942_CS63_Zone_A4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2939, "Pulkovo_1942_CS63_Zone_K2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2940, "Pulkovo_1942_CS63_Zone_K3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2941, "Pulkovo_1942_CS63_Zone_K4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2942, "Porto_Santo_1936_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2943, "Selvagem_Grande_1938_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2944, "NAD_1983_CSRS_MTM_2_SCoPQ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2945, "NAD_1983_CSRS_MTM_3", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2946, "NAD_1983_CSRS_MTM_4", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2947, "NAD_1983_CSRS_MTM_5", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2948, "NAD_1983_CSRS_MTM_6", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2949, "NAD_1983_CSRS_MTM_7", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2950, "NAD_1983_CSRS_MTM_8", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2951, "NAD_1983_CSRS_MTM_9", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2952, "NAD_1983_CSRS_MTM_10", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2953, "NAD_1983_CSRS_New_Brunswick_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2954, "NAD_1983_CSRS_Prince_Edward_Island", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2955, "NAD_1983_CSRS_UTM_Zone_11N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2956, "NAD_1983_CSRS_UTM_Zone_12N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2957, "NAD_1983_CSRS_UTM_Zone_13N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2958, "NAD_1983_CSRS_UTM_Zone_17N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2959, "NAD_1983_CSRS_UTM_Zone_18N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2960, "NAD_1983_CSRS_UTM_Zone_19N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2961, "NAD_1983_CSRS_UTM_Zone_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2962, "NAD_1983_CSRS_UTM_Zone_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2964, "NAD_1927_Alaska_Albers_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2965, "NAD_1983_StatePlane_Indiana_East_FIPS_1301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2966, "NAD_1983_StatePlane_Indiana_West_FIPS_1302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2967, "NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2968, "NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2969, "Fort_Marigot_UTM_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2970, "Sainte_Anne_UTM_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2971, "CSG_1967_UTM_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2972, "RGFG_1995_UTM_22N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2973, "Fort_Desaix_UTM_20N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2975, "RGR_1992_UTM_40S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2976, "Tahiti_1952_UTM_6S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2977, "Tahaa_1954_UTM_5S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2978, "IGN72_Nuku_Hiva_UTM_7S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2980, "Combani_1950_UTM_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2981, "IGN56_Lifou_UTM_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2984, "RGNC_1991_Lambert_New_Caledonia", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2985, "Petrels_1972_Terre_Adelie_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2986, "Perroud_1950_Terre_Adelie_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2987, "Saint_Pierre_et_Miquelon_1950_UTM_21N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2988, "MOP78_UTM_1S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2991, "NAD_1983_Oregon_Statewide_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2992, "NAD_1983_Oregon_Statewide_Lambert_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2993, "NAD_1983_HARN_Oregon_Statewide_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2994, "NAD_1983_HARN_Oregon_Statewide_Lambert_Feet_Intl", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2995, "IGN53_Mare_UTM_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2996, "ST84_Ile_des_Pins_UTM_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2997, "ST71_Belep_UTM_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2998, "NEA74_Noumea_UTM_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 2999, "Grand_Comoros_UTM_38S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3000, "Gunung_Segara_NEIEZ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3001, "Batavia_NEIEZ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3002, "Makassar_NEIEZ", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3003, "Monte_Mario_Italy_1", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3004, "Monte_Mario_Italy_2", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3005, "NAD_1983_BC_Environment_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3006, "SWEREF99_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3007, "SWEREF99_12_00", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3008, "SWEREF99_13_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3009, "SWEREF99_15_00", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3010, "SWEREF99_16_30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3011, "SWEREF99_18_00", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3012, "SWEREF99_14_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3013, "SWEREF99_15_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3014, "SWEREF99_17_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3015, "SWEREF99_18_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3016, "SWEREF99_20_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3017, "SWEREF99_21_45", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3018, "SWEREF99_23_15", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3019, "RT90_75_gon_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3020, "RT90_5_gon_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3021, "RT90_25_gon_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3022, "RT90_0_gon", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3023, "RT90_25_gon_O", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3024, "RT90_5_gon_O", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3025, "RT38_75_gon_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3026, "RT38_5_gon_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3027, "RT38_25_gon_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3028, "RT38_0_gon", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3029, "RT38_25_gon_O", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3030, "RT38_5_gon_O", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3031, "WGS_1984_Antarctic_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3032, "WGS_1984_Australian_Antarctic_Polar_Stereographic", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3033, "WGS_1984_Australian_Antarctic_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3034, "ETRS_1989_LCC", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3035, "ETRS_1989_LAEA", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3036, "Moznet_UTM_Zone_36S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3037, "Moznet_UTM_Zone_37S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3038, "ETRS_1989_ETRS-TM26", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3039, "ETRS_1989_ETRS-TM27", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3040, "ETRS_1989_ETRS-TM28", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3041, "ETRS_1989_ETRS-TM29", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3042, "ETRS_1989_ETRS-TM30", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3043, "ETRS_1989_ETRS-TM31", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3044, "ETRS_1989_ETRS-TM32", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3045, "ETRS_1989_ETRS-TM33", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3046, "ETRS_1989_ETRS-TM34", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3047, "ETRS_1989_ETRS-TM35", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3048, "ETRS_1989_ETRS-TM36", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3049, "ETRS_1989_ETRS-TM37", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3050, "ETRS_1989_ETRS-TM38", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3051, "ETRS_1989_ETRS-TM39", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3054, "Hjorsey_1955_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3055, "Hjorsey_1955_UTM_Zone_27N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3056, "Hjorsey_1955_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3057, "ISN_1993_Lambert_1993", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3058, "Helle_1954_Jan_Mayen_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3059, "LKS_1992_Latvia_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3060, "IGN72_Grande_Terre_UTM_58S", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3061, "Porto_Santo_1995_UTM_Zone_28N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3062, "Azores_Oriental_1995_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3063, "Azores_Central_1995_UTM_Zone_26N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3064, "IGM_1995_UTM_Zone_32N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3065, "IGM_1995_UTM_Zone_33N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3066, "ED_1950_Jordan_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3067, "EUREF_FIN_TM35FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3068, "DHDN_Soldner_Berlin", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3069, "NAD_1927_Wisconsin_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3070, "NAD_1983_Wisconsin_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3071, "NAD_1983_HARN_Wisconsin_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3072, "NAD_1983_Maine_2000_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3074, "NAD_1983_Maine_2000_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3075, "NAD_1983_HARN_Maine_2000_East_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3077, "NAD_1983_HARN_Maine_2000_West_Zone", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3078, "NAD_1983_Michigan_GeoRef_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3079, "NAD_1983_HARN_Michigan_GeoRef_Meters", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3080, "NAD_1927_Texas_Statewide_Mapping_System", "Foot", 0.3048));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3081, "NAD_1983_Texas_Statewide_Mapping_System", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3082, "NAD_1983_Texas_Centric_Mapping_System_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3083, "NAD_1983_Texas_Centric_Mapping_System_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3084, "NAD_1983_HARN_Texas_Centric_Mapping_System_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3085, "NAD_1983_HARN_Texas_Centric_Mapping_System_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3086, "NAD_1983_Florida_GDL_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3087, "NAD_1983_HARN_Florida_GDL_Albers", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3088, "NAD_1983_StatePlane_Kentucky_FIPS_1600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3089, "NAD_1983_StatePlane_Kentucky_FIPS_1600_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3090, "NAD_1983_HARN_StatePlane_Kentucky_FIPS_1600", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3091, "NAD_1983_HARN_StatePlane_Kentucky_FIPS_1600_Feet", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3092, "Tokyo_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3093, "Tokyo_UTM_Zone_52N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3094, "Tokyo_UTM_Zone_53N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3095, "Tokyo_UTM_Zone_54N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3096, "Tokyo_UTM_Zone_55N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3097, "JGD_2000_UTM_Zone_51N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3098, "JGD_2000_UTM_Zone_52N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3099, "JGD_2000_UTM_Zone_53N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3100, "JGD_2000_UTM_Zone_54N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3101, "JGD_2000_UTM_Zone_55N", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3102, "Samoa_1962_Samoa_Lambert", "Foot_US", 0.3048006096012192));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3106, "Gulshan_303_Bangladesh_TM", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3107, "GDA_1994_South_Australia_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3108, "ETRS_1989_Guernsey_Grid", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3109, "ETRS_1989_Jersey_Transverse_Mercator", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3110, "AGD_1966_VICGRID", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3111, "GDA_1994_VICGRID94", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3112, "GDA_1994_Geoscience_Australia_Lambert", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3113, "GDA_1994_BCSG02", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3114, "MAGNA_Colombia_Oeste_Oeste", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3115, "MAGNA_Colombia_Oeste", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3116, "MAGNA_Colombia_Bogota", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3117, "MAGNA_Colombia_Este", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3118, "MAGNA_Colombia_Este_Este", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3119, "Douala_1948_AEF_West", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3120, "Pulkovo_1942_Adj_1958_Poland_Zone_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3121, "PRS_1992_Philippines_Zone_I", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3122, "PRS_1992_Philippines_Zone_II", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3123, "PRS_1992_Philippines_Zone_III", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3124, "PRS_1992_Philippines_Zone_IV", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3125, "PRS_1992_Philippines_Zone_V", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3126, "ETRS_1989_ETRS-GK19FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3127, "ETRS_1989_ETRS-GK20FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3128, "ETRS_1989_ETRS-GK21FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3129, "ETRS_1989_ETRS-GK22FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3130, "ETRS_1989_ETRS-GK23FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3131, "ETRS_1989_ETRS-GK24FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3132, "ETRS_1989_ETRS-GK25FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3133, "ETRS_1989_ETRS-GK26FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3134, "ETRS_1989_ETRS-GK27FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3135, "ETRS_1989_ETRS-GK28FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3136, "ETRS_1989_ETRS-GK29FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3137, "ETRS_1989_ETRS-GK30FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3138, "ETRS_1989_ETRS-GK31FIN", "Meter", 1.0));
            list.add(new CoordinateSystem(CoordinateSystemType.PROJECTED, 3141, "Fiji_1956_UTM_Zone_60S", "Meter", 1.0));
        }
    }

    private static class GCS_1 {
        private GCS_1() {
        }

        static void add(List<CoordinateSystem> list) {
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 3819, "GCS_HD1909", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 3821, "GCS_TWD_1967", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 3824, "GCS_TWD_1997", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 3889, "GCS_IGRS", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 3906, "GCS_MGI_1901", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4001, "GCS_Airy_1830", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4002, "GCS_Airy_Modified", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4003, "GCS_Australian", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4004, "GCS_Bessel_1841", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4005, "GCS_Bessel_Modified", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4006, "GCS_Bessel_Namibia", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4007, "GCS_Clarke_1858", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4008, "GCS_Clarke_1866", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4009, "GCS_Clarke_1866_Michigan", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4010, "GCS_Clarke_1880_Benoit", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4011, "GCS_Clarke_1880_IGN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4012, "GCS_Clarke_1880_RGS", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4013, "GCS_Clarke_1880_Arc", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4014, "GCS_Clarke_1880_SGA", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4015, "GCS_Everest_Adj_1937", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4016, "GCS_Everest_def_1967", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4018, "GCS_Everest_Modified", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4019, "GCS_GRS_1980", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4020, "GCS_Helmert_1906", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4021, "GCS_Indonesian", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4022, "GCS_International_1924", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4023, "GCS_MOLDREF99", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4024, "GCS_Krasovsky_1940", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4025, "GCS_NWL_9D", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4027, "GCS_Plessis_1817", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4028, "GCS_Struve_1860", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4029, "GCS_War_Office", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4031, "GCS_GEM_10C", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4032, "GCS_OSU_86F", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4033, "GCS_OSU_91A", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4034, "GCS_Clarke_1880", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4035, "GCS_Sphere", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4036, "GCS_GRS_1967", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4042, "GCS_Everest_1830", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4044, "GCS_Everest_def_1962", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4045, "GCS_Everest_def_1975", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4046, "GCS_RGRDC_2005", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4047, "GCS_Sphere_GRS_1980_Authalic", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4052, "GCS_Sphere_Clarke_1866_Authalic", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4053, "GCS_Sphere_International_1924_Authalic", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4054, "GCS_Hughes_1980", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4075, "GCS_SREF98", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4081, "GCS_REGCAN95", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4120, "GCS_Greek", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4121, "GCS_GGRS_1987", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4122, "GCS_ATS_1977", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4123, "GCS_KKJ", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4124, "GCS_RT_1990", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4125, "GCS_Samboja", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4127, "GCS_Tete", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4128, "GCS_Madzansua", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4129, "GCS_Observatario", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4130, "GCS_Moznet", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4131, "GCS_Indian_1960", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4132, "GCS_FD_1958", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4133, "GCS_Estonia_1992", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4134, "GCS_PDO_1993", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4135, "GCS_Old_Hawaiian", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4136, "GCS_St_Lawrence_Island", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4137, "GCS_St_Paul_Island", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4138, "GCS_St_George_Island", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4139, "GCS_Puerto_Rico", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4141, "GCS_Israel", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4142, "GCS_Locodjo_1965", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4143, "GCS_Abidjan_1987", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4144, "GCS_Kalianpur_1937", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4145, "GCS_Kalianpur_1962", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4146, "GCS_Kalianpur_1975", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4147, "GCS_Hanoi_1972", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4148, "GCS_Hartebeesthoek_1994", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4149, "GCS_CH1903", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4150, "GCS_CH1903+", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4151, "GCS_Swiss_TRF_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4152, "GCS_North_American_1983_HARN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4153, "GCS_Rassadiran", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4154, "GCS_European_1950_ED77", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4155, "GCS_Dabola_1981", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4156, "GCS_S_JTSK", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4157, "GCS_Mount_Dillon", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4158, "GCS_Naparima_1955", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4159, "GCS_European_Libyan_Datum_1979", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4160, "GCS_Chos_Malal_1914", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4161, "GCS_Pampa_del_Castillo", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4162, "GCS_Korean_Datum_1985", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4163, "GCS_Yemen_NGN_1996", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4164, "GCS_South_Yemen", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4165, "GCS_Bissau", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4166, "GCS_Korean_Datum_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4167, "GCS_NZGD_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4168, "GCS_Accra", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4169, "GCS_American_Samoa_1962", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4170, "GCS_SIRGAS", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4171, "GCS_RGF_1993", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4172, "GCS_POSGAR", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4173, "GCS_IRENET95", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4174, "GCS_Sierra_Leone_1924", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4175, "GCS_Sierra_Leone_1968", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4176, "GCS_Australian_Antarctic_1998", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4178, "GCS_Pulkovo_1942_Adj_1983", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4179, "GCS_Pulkovo_1942_Adj_1958", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4180, "GCS_Estonia_1997", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4181, "GCS_Luxembourg_1930", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4182, "GCS_Azores_Occidental_1939", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4183, "GCS_Azores_Central_1948", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4184, "GCS_Azores_Oriental_1940", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4185, "GCS_Madeira_1936", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4188, "GCS_OSNI_1952", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4189, "GCS_REGVEN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4190, "GCS_POSGAR_1998", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4191, "GCS_Albanian_1987", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4192, "GCS_Douala_1948", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4193, "GCS_Manoca_1962", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4194, "GCS_Qornoq_1927", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4195, "GCS_Scoresbysund_1952", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4196, "GCS_Ammassalik_1958", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4197, "GCS_Garoua", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4198, "GCS_Kousseri", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4199, "GCS_Egypt_1930", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4200, "GCS_Pulkovo_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4201, "GCS_Adindan", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4202, "GCS_Australian_1966", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4203, "GCS_Australian_1984", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4204, "GCS_Ain_el_Abd_1970", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4205, "GCS_Afgooye", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4206, "GCS_Agadez", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4207, "GCS_Lisbon", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4208, "GCS_Aratu", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4209, "GCS_Arc_1950", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4210, "GCS_Arc_1960", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4211, "GCS_Batavia", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4212, "GCS_Barbados_1938", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4213, "GCS_Beduaram", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4214, "GCS_Beijing_1954", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4215, "GCS_Belge_1950", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4216, "GCS_Bermuda_1957", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4218, "GCS_Bogota", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4219, "GCS_Bukit_Rimpah", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4220, "GCS_Camacupa", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4221, "GCS_Campo_Inchauspe", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4222, "GCS_Cape", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4223, "GCS_Carthage", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4224, "GCS_Chua", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4225, "GCS_Corrego_Alegre", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4226, "GCS_Cote_d_Ivoire", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4227, "GCS_Deir_ez_Zor", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4228, "GCS_Douala", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4229, "GCS_Egypt_1907", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4230, "GCS_European_1950", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4231, "GCS_European_1987", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4232, "GCS_Fahud", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4235, "GCS_Guyane_Francaise", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4236, "GCS_Hu_Tzu_Shan", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4237, "GCS_Hungarian_1972", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4238, "GCS_Indonesian_1974", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4239, "GCS_Indian_1954", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4240, "GCS_Indian_1975", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4241, "GCS_Jamaica_1875", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4242, "GCS_Jamaica_1969", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4243, "GCS_Kalianpur_1880", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4244, "GCS_Kandawala", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4245, "GCS_Kertau", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4246, "GCS_Kuwait_Oil_Company", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4247, "GCS_La_Canoa", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4248, "GCS_Provisional_S_American_1956", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4249, "GCS_Lake", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4250, "GCS_Leigon", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4251, "GCS_Liberia_1964", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4252, "GCS_Lome", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4253, "GCS_Luzon_1911", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4254, "GCS_Hito_XVIII_1963", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4255, "GCS_Herat_North", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4256, "GCS_Mahe_1971", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4257, "GCS_Makassar", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4258, "GCS_ETRS_1989", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4259, "GCS_Malongo_1987", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4260, "GCS_Manoca", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4261, "GCS_Merchich", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4262, "GCS_Massawa", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4263, "GCS_Minna", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4265, "GCS_Monte_Mario", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4266, "GCS_Mporaloko", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4267, "GCS_North_American_1927", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4269, "GCS_North_American_1983", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4270, "GCS_Nahrwan_1967", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4271, "GCS_Naparima_1972", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4272, "GCS_New_Zealand_1949", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4273, "GCS_NGO_1948", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4274, "GCS_Datum_73", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4275, "GCS_NTF", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4276, "GCS_NSWC_9Z_2", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4277, "GCS_OSGB_1936", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4278, "GCS_OSGB_1970_SN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4279, "GCS_OS_SN_1980", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4280, "GCS_Padang_1884", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4281, "GCS_Palestine_1923", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4282, "GCS_Pointe_Noire", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4283, "GCS_GDA_1994", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4284, "GCS_Pulkovo_1942", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4285, "GCS_Qatar_1974", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4286, "GCS_Qatar_1948", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4288, "GCS_Loma_Quintana", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4289, "GCS_Amersfoort", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4292, "GCS_Sapper_Hill_1943", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4293, "GCS_Schwarzeck", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4294, "GCS_Segora", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4295, "GCS_Serindung", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4296, "GCS_Sudan", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4297, "GCS_Tananarive_1925", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4298, "GCS_Timbalai_1948", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4299, "GCS_TM65", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4300, "GCS_TM75", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4301, "GCS_Tokyo", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4302, "GCS_Trinidad_1903", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4303, "GCS_Trucial_Coast_1948", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4304, "GCS_Voirol_1875", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4305, "GCS_Voirol_Unifie_1960", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4306, "GCS_Bern_1938", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4307, "GCS_Nord_Sahara_1959", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4308, "GCS_RT38", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4309, "GCS_Yacare", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4310, "GCS_Yoff", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4311, "GCS_Zanderij", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4312, "GCS_MGI", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4313, "GCS_Belge_1972", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4314, "GCS_Deutsches_Hauptdreiecksnetz", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4315, "GCS_Conakry_1905", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4316, "GCS_Dealul_Piscului_1933", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4317, "GCS_Dealul_Piscului_1970", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4318, "GCS_NGN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4319, "GCS_KUDAMS", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4322, "GCS_WGS_1972", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4324, "GCS_WGS_1972_BE", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4326, "GCS_WGS_1984", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4463, "GCS_RGSPM_2006", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4470, "GCS_RGM_2004", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4475, "GCS_Cadastre_1997", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4483, "GCS_Mexican_Datum_of_1993", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4490, "GCS_China_Geodetic_Coordinate_System_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4555, "GCS_New_Beijing", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4558, "GCS_RRAF_1991", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4600, "GCS_Anguilla_1957", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4601, "GCS_Antigua_1943", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4602, "GCS_Dominica_1945", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4603, "GCS_Grenada_1953", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4604, "GCS_Montserrat_1958", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4605, "GCS_St_Kitts_1955", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4606, "GCS_St_Lucia_1955", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4607, "GCS_St_Vincent_1945", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4608, "GCS_NAD_1927_Definition_1976", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4609, "GCS_NAD_1927_CGQ77", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4610, "GCS_Xian_1980", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4611, "GCS_Hong_Kong_1980", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4612, "GCS_JGD_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4613, "GCS_Gunung_Segara", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4614, "GCS_QND_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4615, "GCS_Porto_Santo_1936", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4616, "GCS_Selvagem_Grande_1938", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4617, "GCS_North_American_1983_CSRS", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4618, "GCS_South_American_1969", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4619, "GCS_SWEREF99", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4620, "GCS_Point_58", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4621, "GCS_Fort_Marigot", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4622, "GCS_Sainte_Anne", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4623, "GCS_CSG_1967", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4624, "GCS_RGFG_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4625, "GCS_Fort_Desaix", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4626, "GCS_Reunion_1947", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4627, "GCS_RGR_1992", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4628, "GCS_Tahiti_1952", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4629, "GCS_Tahaa_1954", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4630, "GCS_IGN72_Nuku_Hiva", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4632, "GCS_Combani_1950", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4633, "GCS_IGN56_Lifou", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4636, "GCS_Petrels_1972", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4637, "GCS_Pointe_Geologie_Perroud_1950", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4638, "GCS_Saint_Pierre_et_Miquelon_1950", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4639, "GCS_MOP78", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4641, "GCS_IGN53_Mare", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4642, "GCS_ST84_Ile_des_Pins", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4643, "GCS_ST71_Belep", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4644, "GCS_NEA74_Noumea", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4645, "GCS_RGNC_1991", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4646, "GCS_Grand_Comoros", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4657, "GCS_Reykjavik_1900", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4658, "GCS_Hjorsey_1955", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4659, "GCS_ISN_1993", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4660, "GCS_Helle_1954", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4661, "GCS_LKS_1992", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4662, "GCS_IGN72_Grande_Terre", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4663, "GCS_Porto_Santo_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4664, "GCS_Azores_Oriental_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4665, "GCS_Azores_Central_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4666, "GCS_Lisbon_1890", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4667, "GCS_IKBD_1992", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4668, "GCS_European_1979", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4669, "GCS_LKS_1994", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4670, "GCS_IGM_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4671, "GCS_Voirol_1879", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4672, "GCS_Chatham_Island_1971", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4673, "GCS_Chatham_Islands_1979", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4674, "GCS_SIRGAS_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4675, "GCS_Guam_1963", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4676, "GCS_Vientiane_1982", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4677, "GCS_Lao_1993", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4678, "GCS_Lao_1997", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4679, "GCS_Jouik_1961", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4680, "GCS_Nouakchott_1965", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4682, "GCS_Gulshan_303", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4683, "GCS_PRS_1992", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4684, "GCS_Gan_1970", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4686, "GCS_MAGNA", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4687, "GCS_RGPF", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4688, "GCS_Fatu_Iva_1972", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4689, "GCS_IGN63_Hiva_Oa", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4690, "GCS_Tahiti_1979", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4691, "GCS_Moorea_1987", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4692, "GCS_Maupiti_1983", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4693, "GCS_Nakhl-e_Ghanem", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4694, "GCS_POSGAR_1994", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4695, "GCS_Katanga_1955", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4696, "GCS_Kasai_1953", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4697, "GCS_IGC_1962_6th_Parallel_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4698, "GCS_Kerguelen_Island_1949", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4699, "GCS_Le_Pouce_1934", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4700, "GCS_IGN_Astro_1960", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4701, "GCS_IGCB_1955", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4702, "GCS_Mauritania_1999", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4703, "GCS_Mhast_1951", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4704, "GCS_Mhast_Onshore", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4705, "GCS_Mhast_Offshore", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4706, "GCS_Egypt_Gulf_of_Suez_S-650_TL", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4707, "GCS_Tern_Island_1961", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4708, "GCS_Anna_1_1965", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4709, "GCS_Beacon_E_1945", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4710, "GCS_DOS_71_4", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4711, "GCS_Astro_1952", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4712, "GCS_Ascension_Island_1958", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4713, "GCS_Ayabelle", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4714, "GCS_Bellevue_IGN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4715, "GCS_Camp_Area", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4716, "GCS_Canton_1966", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4717, "GCS_Cape_Canaveral", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4718, "GCS_Solomon_1968", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4719, "GCS_Easter_Island_1967", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4720, "GCS_Fiji_1986", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4721, "GCS_Fiji_1956", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4722, "GCS_ISTS_061_1968", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4723, "GCS_Grand_Cayman_1959", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4724, "GCS_ISTS_073_1969", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4725, "GCS_Johnston_Island_1961", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4726, "GCS_Little_Cayman_1961", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4727, "GCS_Midway_1961", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4728, "GCS_Pico_de_Las_Nieves", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4729, "GCS_Pitcairn_1967", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4730, "GCS_Santo_DOS_1965", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4731, "GCS_Viti_Levu_1916", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4732, "GCS_Wake_Eniwetok_1960", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4733, "GCS_Wake_Island_1952", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4734, "GCS_Tristan_1968", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4735, "GCS_Kusaie_1951", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4736, "GCS_Deception_Island", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4737, "GCS_Korea_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4738, "GCS_Hong_Kong_1963", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4739, "GCS_Hong_Kong_1963_67", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4740, "GCS_PZ_1990", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4741, "GCS_FD_1954", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4742, "GCS_GDM_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4743, "GCS_Karbala_1979_Polservice", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4744, "GCS_Nahrwan_1934", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4745, "GCS_RD/83", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4746, "GCS_PD/83", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4747, "GCS_Greenland_1996", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4748, "GCS_Vanua_Levu_1915", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4749, "GCS_RGNC_1991-93", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4750, "GCS_ST87_Ouvea", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4751, "GCS_Kertau_RSO", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4752, "GCS_Viti_Levu_1912", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4753, "GCS_fk89", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4754, "GCS_LGD2006", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4755, "GCS_DGN_1995", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4756, "GCS_VN_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4757, "GCS_SVY21", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4758, "GCS_JAD_2001", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4759, "GCS_NAD_1983_NSRS2007", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4760, "GCS_WGS_1966", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4761, "GCS_HTRS96", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4762, "GCS_Bermuda_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4763, "GCS_Pitcairn_2006", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4764, "GCS_RSRGD2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4765, "GCS_Slovenia_1996", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4801, "GCS_Bern_1898_Bern", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4802, "GCS_Bogota_Bogota", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4803, "GCS_Lisbon_Lisbon", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4804, "GCS_Makassar_Jakarta", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4805, "GCS_MGI_Ferro", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4806, "GCS_Monte_Mario_Rome", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4807, "GCS_NTF_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4808, "GCS_Padang_1884_Jakarta", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4809, "GCS_Belge_1950_Brussels", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4810, "GCS_Tananarive_1925_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4811, "GCS_Voirol_1875_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4812, "GCS_Voirol_Unifie_1960_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4813, "GCS_Batavia_Jakarta", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4814, "GCS_RT38_Stockholm", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4815, "GCS_Greek_Athens", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4816, "GCS_Carthage_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4817, "GCS_NGO_1948_Oslo", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4818, "GCS_S_JTSK_Ferro", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4819, "GCS_Nord_Sahara_1959_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4820, "GCS_Gunung_Segara_Jakarta", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4821, "GCS_Voirol_1879_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4823, "GCS_Sao_Tome", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4824, "GCS_Principe", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4901, "GCS_ATF_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4902, "GCS_Nord_de_Guerre_Paris", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4903, "GCS_Madrid_1870_Madrid", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 4904, "GCS_Lisbon_1890_Lisbon", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5013, "GCS_PTRA08", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5228, "GCS_S_JTSK/05", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5229, "GCS_S_JTSK/05_Ferro", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5233, "GCS_SLD99", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5246, "GCS_GDBD2009", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5252, "GCS_TUREF", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5264, "GCS_DRUKREF_03", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5324, "GCS_ISN_2004", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5340, "GCS_POSGAR_2007", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5354, "GCS_MARGEN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5360, "GCS_SIRGAS-Chile", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5365, "GCS_CR05", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5371, "GCS_MARCARIO_SOLIS", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5373, "GCS_Peru96", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5381, "GCS_SIRGAS-ROU98", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5393, "GCS_SIRGAS_ES2007.8", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5451, "GCS_Ocotepeque_1935", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5464, "GCS_Sibun_Gorge_1922", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5467, "GCS_Panama-Colon_1911", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5489, "GCS_RGAF09", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5524, "GCS_Corrego_Alegre_1961", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5527, "GCS_SAD_1969_96", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5546, "GCS_PNG94", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5561, "GCS_Ukraine_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5593, "GCS_FEH2010", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5681, "GCS_DB_REF", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 5886, "GCS_TGD2005", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 6135, "GCS_CIGD11", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 6207, "GCS_Nepal_Nagarkot", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 6318, "GCS_NAD_1983_2011", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 6322, "GCS_NAD_1983_PA11", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 6325, "GCS_NAD_1983_MA11", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37002, "GCS_Fischer_1960", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37003, "GCS_Fischer_1968", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37004, "GCS_Fischer_Modified", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37005, "GCS_Hough_1960", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37006, "GCS_Everest_Modified_1969", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37007, "GCS_Walbeck", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37008, "GCS_Sphere_ARC_INFO", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37202, "GCS_Everest_Bangladesh", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37203, "GCS_Everest_India_Nepal", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37206, "GCS_Oman", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37207, "GCS_South_Asia_Singapore", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37218, "GCS_DOS_1968", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37221, "GCS_GUX_1", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37225, "GCS_Carthage_Grad", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37240, "GCS_Fort_Thomas_1955", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37241, "GCS_Graciosa_Base_SW_1948", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37243, "GCS_LC5_1961", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37245, "GCS_Observatorio_Meteorologico_1939", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37249, "GCS_Sao_Braz", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37257, "GCS_S42_Hungary", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 37260, "GCS_Alaskan_Islands", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104020, "GCS_JGD_2011", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104101, "GCS_Estonia_1937", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104102, "GCS_Hermannskogel", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104103, "GCS_Sierra_Leone_1960", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104105, "GCS_Datum_Lisboa_Bessel", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104106, "GCS_Datum_Lisboa_Hayford", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104109, "GCS_Pohnpei", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104112, "GCS_Bab_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104113, "GCS_Majuro", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104115, "GCS_ITRF_1988", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104116, "GCS_ITRF_1989", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104117, "GCS_ITRF_1990", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104118, "GCS_ITRF_1991", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104119, "GCS_ITRF_1992", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104120, "GCS_ITRF_1993", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104121, "GCS_ITRF_1994", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104122, "GCS_ITRF_1996", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104123, "GCS_ITRF_1997", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104124, "GCS_ITRF_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104126, "GCS_Observatorio_Meteorologico_1965", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104127, "GCS_Roma_1940", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104128, "GCS_Sphere_EMEP", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104129, "GCS_EUREF_FIN", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104130, "GCS_Jordan", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104131, "GCS_D48", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104134, "GCS_MONREF_1997", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104135, "GCS_MSK_1942", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104138, "GCS_Old_Hawaiian_Intl_1924", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104139, "GCS_Voirol_1875_Grad", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104140, "GCS_Voirol_1879_Grad", "Grad", 0.01570796326794897));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104141, "GCS_CGRS_1993", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104223, "GCS_NAD_1983_CORS96", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104257, "GCS_ITRF_2008", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104258, "GCS_ETRF_1989", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104259, "GCS_NAD_1983_PACP00", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104260, "GCS_NAD_1983_MARP00", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104261, "GCS_Merchich_Degree", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104305, "GCS_Voirol_Unifie_1960_Degree", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104700, "GCS_NAD_1983_HARN_Adj_MN_Anoka", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104701, "GCS_NAD_1983_HARN_Adj_MN_Becker", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104702, "GCS_NAD_1983_HARN_Adj_MN_Beltrami_North", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104703, "GCS_NAD_1983_HARN_Adj_MN_Beltrami_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104704, "GCS_NAD_1983_HARN_Adj_MN_Benton", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104705, "GCS_NAD_1983_HARN_Adj_MN_Big_Stone", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104706, "GCS_NAD_1983_HARN_Adj_MN_Blue_Earth", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104707, "GCS_NAD_1983_HARN_Adj_MN_Brown", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104708, "GCS_NAD_1983_HARN_Adj_MN_Carlton", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104709, "GCS_NAD_1983_HARN_Adj_MN_Carver", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104710, "GCS_NAD_1983_HARN_Adj_MN_Cass_North", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104711, "GCS_NAD_1983_HARN_Adj_MN_Cass_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104712, "GCS_NAD_1983_HARN_Adj_MN_Chippewa", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104713, "GCS_NAD_1983_HARN_Adj_MN_Chisago", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104714, "GCS_NAD_1983_HARN_Adj_MN_Cook_North", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104715, "GCS_NAD_1983_HARN_Adj_MN_Cook_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104716, "GCS_NAD_1983_HARN_Adj_MN_Cottonwood", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104717, "GCS_NAD_1983_HARN_Adj_MN_Crow_Wing", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104718, "GCS_NAD_1983_HARN_Adj_MN_Dakota", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104719, "GCS_NAD_1983_HARN_Adj_MN_Dodge", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104720, "GCS_NAD_1983_HARN_Adj_MN_Douglas", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104721, "GCS_NAD_1983_HARN_Adj_MN_Faribault", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104722, "GCS_NAD_1983_HARN_Adj_MN_Fillmore", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104723, "GCS_NAD_1983_HARN_Adj_MN_Freeborn", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104724, "GCS_NAD_1983_HARN_Adj_MN_Goodhue", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104725, "GCS_NAD_1983_HARN_Adj_MN_Grant", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104726, "GCS_NAD_1983_HARN_Adj_MN_Hennepin", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104727, "GCS_NAD_1983_HARN_Adj_MN_Houston", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104728, "GCS_NAD_1983_HARN_Adj_MN_Isanti", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104729, "GCS_NAD_1983_HARN_Adj_MN_Itasca_North", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104730, "GCS_NAD_1983_HARN_Adj_MN_Itasca_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104731, "GCS_NAD_1983_HARN_Adj_MN_Jackson", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104732, "GCS_NAD_1983_HARN_Adj_MN_Kanabec", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104733, "GCS_NAD_1983_HARN_Adj_MN_Kandiyohi", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104734, "GCS_NAD_1983_HARN_Adj_MN_Kittson", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104735, "GCS_NAD_1983_HARN_Adj_MN_Koochiching", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104736, "GCS_NAD_1983_HARN_Adj_MN_Lac_Qui_Parle", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104737, "GCS_NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_North", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104738, "GCS_NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104739, "GCS_NAD_1983_HARN_Adj_MN_Le_Sueur", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104740, "GCS_NAD_1983_HARN_Adj_MN_Lincoln", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104741, "GCS_NAD_1983_HARN_Adj_MN_Lyon", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104742, "GCS_NAD_1983_HARN_Adj_MN_McLeod", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104743, "GCS_NAD_1983_HARN_Adj_MN_Mahnomen", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104744, "GCS_NAD_1983_HARN_Adj_MN_Marshall", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104745, "GCS_NAD_1983_HARN_Adj_MN_Martin", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104746, "GCS_NAD_1983_HARN_Adj_MN_Meeker", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104747, "GCS_NAD_1983_HARN_Adj_MN_Morrison", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104748, "GCS_NAD_1983_HARN_Adj_MN_Mower", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104749, "GCS_NAD_1983_HARN_Adj_MN_Murray", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104750, "GCS_NAD_1983_HARN_Adj_MN_Nicollet", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104751, "GCS_NAD_1983_HARN_Adj_MN_Nobles", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104752, "GCS_NAD_1983_HARN_Adj_MN_Norman", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104753, "GCS_NAD_1983_HARN_Adj_MN_Olmsted", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104754, "GCS_NAD_1983_HARN_Adj_MN_Ottertail", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104755, "GCS_NAD_1983_HARN_Adj_MN_Pennington", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104756, "GCS_NAD_1983_HARN_Adj_MN_Pine", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104757, "GCS_NAD_1983_HARN_Adj_MN_Pipestone", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104758, "GCS_NAD_1983_HARN_Adj_MN_Polk", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104759, "GCS_NAD_1983_HARN_Adj_MN_Pope", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104760, "GCS_NAD_1983_HARN_Adj_MN_Ramsey", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104761, "GCS_NAD_1983_HARN_Adj_MN_Red_Lake", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104762, "GCS_NAD_1983_HARN_Adj_MN_Redwood", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104763, "GCS_NAD_1983_HARN_Adj_MN_Renville", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104764, "GCS_NAD_1983_HARN_Adj_MN_Rice", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104765, "GCS_NAD_1983_HARN_Adj_MN_Rock", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104766, "GCS_NAD_1983_HARN_Adj_MN_Roseau", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104767, "GCS_NAD_1983_HARN_Adj_MN_St_Louis_North", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104768, "GCS_NAD_1983_HARN_Adj_MN_St_Louis_Central", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104769, "GCS_NAD_1983_HARN_Adj_MN_St_Louis_South", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104770, "GCS_NAD_1983_HARN_Adj_MN_Scott", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104771, "GCS_NAD_1983_HARN_Adj_MN_Sherburne", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104772, "GCS_NAD_1983_HARN_Adj_MN_Sibley", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104773, "GCS_NAD_1983_HARN_Adj_MN_Stearns", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104774, "GCS_NAD_1983_HARN_Adj_MN_Steele", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104775, "GCS_NAD_1983_HARN_Adj_MN_Stevens", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104776, "GCS_NAD_1983_HARN_Adj_MN_Swift", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104777, "GCS_NAD_1983_HARN_Adj_MN_Todd", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104778, "GCS_NAD_1983_HARN_Adj_MN_Traverse", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104779, "GCS_NAD_1983_HARN_Adj_MN_Wabasha", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104780, "GCS_NAD_1983_HARN_Adj_MN_Wadena", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104781, "GCS_NAD_1983_HARN_Adj_MN_Waseca", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104782, "GCS_NAD_1983_HARN_Adj_MN_Watonwan", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104783, "GCS_NAD_1983_HARN_Adj_MN_Winona", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104784, "GCS_NAD_1983_HARN_Adj_MN_Wright", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104785, "GCS_NAD_1983_HARN_Adj_MN_Yellow_Medicine", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104786, "GCS_NAD_1983_HARN_Adj_MN_St_Louis", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104896, "GCS_ITRF_2005", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104900, "GCS_Mercury_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104901, "GCS_Venus_1985", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104902, "GCS_Venus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104903, "GCS_Moon_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104904, "GCS_Mars_1979", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104905, "GCS_Mars_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104906, "GCS_Deimos_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104907, "GCS_Phobos_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104908, "GCS_Jupiter_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104909, "GCS_Adrastea_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104910, "GCS_Amalthea_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104911, "GCS_Ananke_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104912, "GCS_Callisto_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104913, "GCS_Carme_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104914, "GCS_Elara_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104915, "GCS_Europa_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104916, "GCS_Ganymede_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104917, "GCS_Himalia_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104918, "GCS_Io_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104919, "GCS_Leda_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104920, "GCS_Lysithea_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104921, "GCS_Metis_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104922, "GCS_Pasiphae_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104923, "GCS_Sinope_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104924, "GCS_Thebe_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104925, "GCS_Saturn_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104926, "GCS_Atlas_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104927, "GCS_Calypso_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104928, "GCS_Dione_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104929, "GCS_Enceladus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104930, "GCS_Epimetheus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104931, "GCS_Helene_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104932, "GCS_Hyperion_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104933, "GCS_Iapetus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104934, "GCS_Janus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104935, "GCS_Mimas_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104936, "GCS_Pan_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104937, "GCS_Pandora_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104938, "GCS_Phoebe_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104939, "GCS_Prometheus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104940, "GCS_Rhea_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104941, "GCS_Telesto_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104942, "GCS_Tethys_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104943, "GCS_Titan_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104944, "GCS_Uranus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104945, "GCS_Ariel_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104946, "GCS_Belinda_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104947, "GCS_Bianca_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104948, "GCS_Cordelia_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104949, "GCS_Cressida_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104950, "GCS_Desdemona_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104951, "GCS_Juliet_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104952, "GCS_Miranda_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104953, "GCS_Oberon_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104954, "GCS_Ophelia_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104955, "GCS_Portia_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104956, "GCS_Puck_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104957, "GCS_Rosalind_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104958, "GCS_Titania_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104959, "GCS_Umbriel_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104960, "GCS_Neptune_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104961, "GCS_Despina_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104962, "GCS_Galatea_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104963, "GCS_Larissa_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104964, "GCS_Naiad_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104965, "GCS_Nereid_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104966, "GCS_Proteus_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104967, "GCS_Thalassa_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104968, "GCS_Triton_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104969, "GCS_Pluto_2000", "Degree", 0.0174532925199433));
            list.add(new CoordinateSystem(CoordinateSystemType.GEOGRAPHIC, 104970, "GCS_Charon_2000", "Degree", 0.0174532925199433));
        }
    }

    public static class CoordinateSystem {
        private CoordinateSystemType type;
        private int wkid;
        private String name;
        private String unitName;
        private Double unitMultiplier;

        protected CoordinateSystem(CoordinateSystemType coordinateSystemType, int n, String string, String string2, Double d) {
            this.type = coordinateSystemType;
            this.wkid = n;
            this.name = string;
            this.unitName = string2;
            this.unitMultiplier = d;
        }

        public CoordinateSystemType getType() {
            return this.type;
        }

        public int getWKID() {
            return this.wkid;
        }

        public String getName() {
            return this.name;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public Double getUnitMultiplier() {
            return this.unitMultiplier;
        }
    }

    public static enum CoordinateSystemType {
        PROJECTED,
        GEOGRAPHIC;

    }
}

