/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ContextDataItem
implements SerializableObject {
    private String mSourceId;
    private String mDisplayID;
    private String mContextDataFileName = "";
    private String mFullName;
    private LocallyUniqueId mDatasetUID;
    private boolean mIsOpen;
    private boolean mRoleContext;
    private boolean mAssocSet;
    private String mMapAssociationId = "";
    private DataType mDataType;
    private Vector<String> mKeyList;
    private Vector<String> mSelectedMapKeys;
    private Vector<String> mSelectedDataKeys;
    private String mCoordinateXVar;
    private String mCoordinateYVar;
    private String mCoordinateZVar;
    private CoordinateSys mCoorSystem;
    private AssocType mAssocType;
    private Vector<Pair<Vector<String>, Vector<String>>> mMatchedDataMapValues;
    private Vector<Vector<String>> mUnMatchedMapValues;
    private Vector<Vector<String>> mUnMatchedDataValues;
    private Vector<VariableBlock> mVarInfoFromdbf;
    private Vector<ISpssVariable> mSpssVars;
    private String mWKID;
    private String mProjection;
    private String mDisplayMapString;
    private String mDataSetName;
    private int mNumMatchedValues;

    public ContextDataItem(String string, String string2, String string3, boolean bl, boolean bl2, String string4, DataType dataType, String string5) {
        this.mSourceId = string;
        this.mDisplayID = string;
        this.mFullName = string2;
        this.mContextDataFileName = string3;
        this.mRoleContext = bl2;
        this.mMapAssociationId = string4;
        this.mIsOpen = bl;
        this.mDataType = dataType;
        this.mKeyList = new Vector();
        this.mSelectedMapKeys = new Vector();
        this.mSelectedDataKeys = new Vector();
        this.mCoordinateXVar = "";
        this.mCoordinateYVar = "";
        this.mCoordinateZVar = "";
        this.mCoorSystem = CoordinateSys.GEO;
        this.mMatchedDataMapValues = new Vector();
        this.mVarInfoFromdbf = new Vector();
        this.mSpssVars = new Vector();
        this.mWKID = "";
        this.mProjection = "";
        this.mDisplayMapString = string5;
        this.mDatasetUID = new LocallyUniqueId();
        this.mAssocSet = false;
        this.mUnMatchedMapValues = new Vector();
        this.mUnMatchedDataValues = new Vector();
        this.mNumMatchedValues = -1;
        this.mDataSetName = this.mContextDataFileName;
        this.mAssocType = AssocType.UNKNOWMN;
    }

    public String getContextDataSourceName() {
        return this.mContextDataFileName;
    }

    public void setContextDataSourceName(String string) {
        this.mContextDataFileName = string;
    }

    public String getDataSourceFullName() {
        return this.mFullName;
    }

    public void setDataSourceFullName(String string) {
        this.mFullName = string;
    }

    public boolean isOpenedDataSource() {
        return this.mIsOpen;
    }

    public void setIsOpenedDataSource(boolean bl) {
        this.mIsOpen = bl;
    }

    public boolean isRoleContext() {
        return this.mRoleContext;
    }

    public void setIsRoleContext(boolean bl) {
        this.mRoleContext = bl;
    }

    public String getMapAssocId() {
        return this.mMapAssociationId;
    }

    public void setMapAssocId(String string) {
        this.mMapAssociationId = string;
    }

    public DataType getDataType() {
        return this.mDataType;
    }

    public void setDataType(DataType dataType) {
        this.mDataType = dataType;
    }

    public Vector<String> getKeyList() {
        return this.mKeyList;
    }

    public void setKeyList(Vector<String> vector) {
        if (this.mDataType == DataType.MAP) {
            this.mKeyList = vector;
        }
    }

    public Vector<String> getSelectedMapKeys() {
        return this.mSelectedMapKeys;
    }

    public void setSelectedMapKeys(Vector<String> vector) {
        this.mSelectedMapKeys = vector;
    }

    public Vector<String> getSelectedDataKeys() {
        return this.mSelectedDataKeys;
    }

    public void setSelectedDataKeys(Vector<String> vector) {
        this.mSelectedDataKeys = vector;
    }

    public String getCoordinateXVar() {
        return this.mCoordinateXVar;
    }

    public void setCoordinateXVar(String string) {
        this.mCoordinateXVar = string;
    }

    public String getCoordinateYVar() {
        return this.mCoordinateYVar;
    }

    public void setCoordinateYVar(String string) {
        this.mCoordinateYVar = string;
    }

    public String getCoordinateZVar() {
        return this.mCoordinateZVar;
    }

    public void setCoordinateZVar(String string) {
        this.mCoordinateZVar = string;
    }

    public CoordinateSys getCoorSystem() {
        return this.mCoorSystem;
    }

    public void setCoorSystem(CoordinateSys coordinateSys) {
        this.mCoorSystem = coordinateSys;
    }

    public String getWKID() {
        return this.mWKID;
    }

    public void setWKID(String string) {
        this.mWKID = string;
    }

    public String getProjection() {
        return this.mProjection;
    }

    public void setProjection(String string) {
        this.mProjection = string;
    }

    public Vector<Pair<Vector<String>, Vector<String>>> getMatchedDataMapValues() {
        return this.mMatchedDataMapValues;
    }

    public void setMatchedDataMapValues(Vector<Pair<Vector<String>, Vector<String>>> vector) {
        this.mMatchedDataMapValues = vector;
    }

    public String getSourceId() {
        return this.mSourceId;
    }

    public void setSourceId(String string) {
        this.mSourceId = string;
    }

    public String getDisplayID() {
        return this.mDisplayID;
    }

    public void setDisplayID(String string) {
        this.mDisplayID = string;
    }

    public Vector<VariableBlock> getVarInfoFromdbf() {
        return this.mVarInfoFromdbf;
    }

    public void setVarInfoFromdbf(Vector<VariableBlock> vector) {
        if (this.mDataType == DataType.MAP) {
            this.mVarInfoFromdbf = vector;
        }
    }

    public void addOnePair(Vector<String> vector, Vector<String> vector2) {
        Pair pair = new Pair(vector, vector2);
        this.mMatchedDataMapValues.add((Pair<Vector<String>, Vector<String>>)pair);
    }

    public Vector<ISpssVariable> getSpssVars() {
        return this.mSpssVars;
    }

    public void setSpssVars(Vector<ISpssVariable> vector) {
        this.mSpssVars = vector;
    }

    public boolean isVarNumeric(String string) {
        boolean bl = true;
        if (this.mSpssVars != null) {
            for (ISpssVariable iSpssVariable : this.mSpssVars) {
                if (!iSpssVariable.getName().equals(string) || iSpssVariable.getType() <= 0) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public String getDisplayMapString() {
        return this.mDisplayMapString;
    }

    public void setDisplayMapString(String string) {
        this.mDisplayMapString = string;
    }

    public LocallyUniqueId getDatasetUID() {
        return this.mDatasetUID;
    }

    public void setDatasetUID(LocallyUniqueId locallyUniqueId) {
        this.mDatasetUID = locallyUniqueId;
    }

    public boolean equals(ContextDataItem contextDataItem) {
        return this.mContextDataFileName.equals(contextDataItem.getContextDataSourceName()) && this.mFullName.equals(contextDataItem.getDataSourceFullName());
    }

    public boolean isAssocSet() {
        return this.mAssocSet;
    }

    public void setAssocSetStatus(boolean bl) {
        this.mAssocSet = bl;
    }

    public Vector<Vector<String>> getUnMatchedMapValues() {
        return this.mUnMatchedMapValues;
    }

    public void setUnMatchedMapValues(Vector<Vector<String>> vector) {
        this.mUnMatchedMapValues = vector;
    }

    public Vector<Vector<String>> getUnMatchedDataValues() {
        return this.mUnMatchedDataValues;
    }

    public void setUnMatchedDataValues(Vector<Vector<String>> vector) {
        this.mUnMatchedDataValues = vector;
    }

    public int getNumMatchedValues() {
        return this.mNumMatchedValues;
    }

    public void setNumMatchedValues(int n) {
        this.mNumMatchedValues = n;
    }

    public String getDataSetName() {
        return this.mDataSetName;
    }

    public void setDataSetName(String string) {
        this.mDataSetName = string;
    }

    public AssocType getAssocType() {
        return this.mAssocType;
    }

    public void setAssocType(AssocType assocType) {
        this.mAssocType = assocType;
    }

    protected Object clone() throws CloneNotSupportedException {
        ContextDataItem contextDataItem = new ContextDataItem(this.mSourceId, this.mContextDataFileName, this.mFullName, this.mIsOpen, this.mRoleContext, this.mMapAssociationId, this.mDataType, this.mDisplayMapString);
        return contextDataItem;
    }

    public String getClassName() {
        return " com.spss.java_client.ui.dialogs.STEM.ContextDataItem";
    }

    public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
        this.mSourceId = objectInputStream.readUTF();
        this.mContextDataFileName = objectInputStream.readUTF();
        this.mFullName = objectInputStream.readUTF();
        this.mIsOpen = objectInputStream.readBoolean();
        this.mRoleContext = objectInputStream.readBoolean();
        this.mMapAssociationId = objectInputStream.readUTF();
        int n2 = objectInputStream.readInt();
        switch (n2) {
            case 0: {
                this.mDataType = DataType.FILE;
                break;
            }
            case 1: {
                this.mDataType = DataType.MAP;
                break;
            }
            case 2: {
                this.mDataType = DataType.DATASET;
            }
        }
        this.mKeyList = (Vector)objectInputStream.readObject();
        this.mSelectedMapKeys = (Vector)objectInputStream.readObject();
        this.mSelectedDataKeys = (Vector)objectInputStream.readObject();
        this.mCoordinateXVar = objectInputStream.readUTF();
        this.mCoordinateYVar = objectInputStream.readUTF();
        this.mCoordinateZVar = objectInputStream.readUTF();
        n2 = objectInputStream.readInt();
        switch (n2) {
            case 0: {
                this.mCoorSystem = CoordinateSys.GEO;
                break;
            }
            case 1: {
                this.mCoorSystem = CoordinateSys.CARTESIAN;
                break;
            }
            case 2: {
                this.mCoorSystem = CoordinateSys.WKID;
                break;
            }
            case 3: {
                this.mCoorSystem = CoordinateSys.PROJECTION;
            }
        }
        this.mMatchedDataMapValues = (Vector)objectInputStream.readObject();
        this.mWKID = objectInputStream.readUTF();
        this.mProjection = objectInputStream.readUTF();
        this.mUnMatchedDataValues = (Vector)objectInputStream.readObject();
        this.mUnMatchedMapValues = (Vector)objectInputStream.readObject();
        return true;
    }

    public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
        objectOutputStream.writeUTF(this.mSourceId);
        objectOutputStream.writeUTF(this.mContextDataFileName);
        objectOutputStream.writeUTF(this.mFullName);
        objectOutputStream.writeBoolean(this.mIsOpen);
        objectOutputStream.writeBoolean(this.mRoleContext);
        objectOutputStream.writeUTF(this.mMapAssociationId);
        objectOutputStream.writeInt(this.mDataType.ordinal());
        objectOutputStream.writeObject(this.mKeyList);
        objectOutputStream.writeObject(this.mSelectedMapKeys);
        objectOutputStream.writeObject(this.mSelectedDataKeys);
        objectOutputStream.writeUTF(this.mCoordinateXVar);
        objectOutputStream.writeUTF(this.mCoordinateYVar);
        objectOutputStream.writeUTF(this.mCoordinateZVar);
        objectOutputStream.writeInt(this.mCoorSystem.ordinal());
        objectOutputStream.writeObject(this.mMatchedDataMapValues);
        objectOutputStream.writeUTF(this.mWKID);
        objectOutputStream.writeUTF(this.mProjection);
        objectOutputStream.writeObject(this.mUnMatchedDataValues);
        objectOutputStream.writeObject(this.mUnMatchedMapValues);
        return true;
    }

    public static enum AssocType {
        UNKNOWMN,
        COORDINATE,
        KEYS;

    }

    public static enum CoordinateSys {
        GEO,
        CARTESIAN,
        WKID,
        PROJECTION;


        public String toString() {
            switch (this) {
                case GEO: {
                    return "GEOGRAPHIC";
                }
                case CARTESIAN: {
                    return "CARTESIAN";
                }
                case WKID: {
                    return "WKID";
                }
                case PROJECTION: {
                    return "PROJECTION";
                }
            }
            return "";
        }
    }

    public static enum DataType {
        FILE,
        MAP,
        DATASET;


        public String toString() {
            switch (this) {
                case FILE: {
                    return "FILE";
                }
                case MAP: {
                    return "MAP";
                }
                case DATASET: {
                    return "DATASET";
                }
            }
            return "";
        }
    }
}

