/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.STEM.STEMUtil;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ConnectToMapServiceSubDlg
extends BaseDialog
implements ActionListener {
    private ContinueAction mContinueAction;
    private JLabel mAllMapLabel;
    private JTree mAllMaptree;
    private DefaultTreeModel mMapTreeModel;
    private JScrollPane mAllMapScrollPane;
    private JLabel mMapURLLabel;
    private JComboBox mMapURLCombo;
    private JButton mFreshButton;
    private JLabel mMapInfoLabel;
    private FocusableTextArea mMapInfoTextArea;
    private JScrollPane mMapInfoScrollPane;

    public ConnectToMapServiceSubDlg(BaseWizardDialog baseWizardDialog) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_MAP_SERVICE_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.initializePanel();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mFreshButton) {
            this.handleBackendCall(this.mMapURLCombo.getSelectedItem().toString());
        }
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_add_service");
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setDefault();
    }

    private void initializePanel() {
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    public boolean continuePressed() {
        return true;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mMapURLLabel = DialogUtil.createLabel(this, "IDS_STEM_MAP_SERVICE_SUB_MAP_URL_LABEL");
        this.mMapURLCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"http://nowcoast.noaa.gov/help/mapservices.shtml?name=mapservices"}));
        this.mMapURLCombo.setEditable(true);
        this.mMapURLCombo.setAction(new ComboboxAction(this, "IDS_STEM_MAP_SERVICE_SUB_MAP_URL_LABEL"));
        this.mMapURLLabel.setLabelFor(this.mMapURLCombo);
        this.mFreshButton = DialogUtil.createButton(this, "IDS_STEM_MAP_SERVICE_SUB_REFRESH_BUTTON", this);
        this.mFreshButton.addActionListener(this);
        this.mAllMapLabel = DialogUtil.createLabel(this, "IDS_STEM_MAP_SERVICE_SUB_ALL_MAPS_LABEL");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.getResString("IDS_STEM_MAP_SERVICE_SUB_ALL_MAPS_ROOT"));
        this.mMapTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.mAllMaptree = new JTree(this.mMapTreeModel);
        this.mAllMapScrollPane = new JScrollPane(this.mAllMaptree);
        this.mAllMapScrollPane.setHorizontalScrollBarPolicy(31);
        this.mAllMapScrollPane.setVerticalScrollBarPolicy(20);
        this.mAllMapScrollPane.setPreferredSize(new Dimension(250, 280));
        this.mAllMapScrollPane.setMinimumSize(new Dimension(250, 280));
        this.mMapInfoLabel = DialogUtil.createLabel(this, "IDS_STEM_MAP_SERVICE_SUB_MAP_INFO_LABEL");
        this.mMapInfoTextArea = new FocusableTextArea("", null);
        this.mMapInfoLabel.setLabelFor(this.mMapInfoTextArea);
        this.mMapInfoTextArea.setMinimumSize(new Dimension(200, 280));
        this.mMapInfoScrollPane = new JScrollPane(this.mMapInfoTextArea);
        this.mMapInfoScrollPane.setHorizontalScrollBarPolicy(31);
        this.mMapInfoScrollPane.setVerticalScrollBarPolicy(20);
        this.mMapInfoScrollPane.setPreferredSize(this.mMapInfoTextArea.getMinimumSize());
        this.mMapInfoScrollPane.setMinimumSize(this.mMapInfoTextArea.getMinimumSize());
    }

    private void setDefault() {
    }

    private void callBackend(String string) {
        Vector vector = new Vector();
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().validateMapService(string, vector);
        String string2 = "";
        String string3 = "";
        if (aSMapsError.getHasError()) {
            string2 = aSMapsError.getMessage();
            string3 = aSMapsError.getExplain();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2 + " " + string3, VersionInfo.getAppVersionString());
        } else {
            if (vector.size() == 1) {
                String string4 = (String)vector.get(0);
                JSONArray jSONArray = null;
                try {
                    string4 = "{ \"layer\": " + string4 + " }";
                    JSONObject jSONObject = JSONObject.parse((String)string4);
                    jSONArray = (JSONArray)jSONObject.get((Object)"layer");
                    int n = jSONArray.size();
                    String[] stringArray = new String[n];
                    String[] stringArray2 = new String[n];
                    int n2 = 0;
                    for (n2 = 0; n2 < n; ++n2) {
                        JSONObject jSONObject2 = (JSONObject)jSONArray.get(n2);
                        stringArray[n2] = (String)jSONObject2.get((Object)"value");
                        stringArray2[n2] = (String)jSONObject2.get((Object)"label");
                    }
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        this.handleLayer(n2, string);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            System.out.println(vector);
        }
    }

    private void handleLayer(int n, String string) {
        Vector vector = new Vector();
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().validateServiceLayer(string, n, vector);
        String string2 = "";
        String string3 = "";
        if (aSMapsError.getHasError()) {
            string2 = aSMapsError.getMessage();
            string3 = aSMapsError.getExplain();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2 + " " + string3, VersionInfo.getAppVersionString());
        } else if (vector.size() == 1) {
            String string4 = PrefsMgr.getPrefsMgr().getTempPath();
            File file = null;
            File file2 = null;
            try {
                file = PASWFileUtil.createTempFile((String)"datamodel", (String)".xml", (File)new File(string4));
                file2 = PASWFileUtil.createTempFile((String)"GeoJson", (String)".json", (File)new File(string4));
                file2.deleteOnExit();
                file.deleteOnExit();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            String string5 = string4 + File.separator + "dataModel.xml";
            STEMUtil.DataModelContent dataModelContent = STEMUtil.handleDataModelXML(string5, (String)vector.get(0));
            String string6 = dataModelContent.getCSName();
            int n2 = dataModelContent.getWKId();
            aSMapsError = SysFileProxy.getSysFileProxy().getServiceGeoJSON(string6, n2, string, n, file, file2);
            if (aSMapsError.getHasError()) {
                string2 = aSMapsError.getMessage();
                string3 = aSMapsError.getExplain();
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2 + " " + string3, VersionInfo.getAppVersionString());
            } else {
                dataModelContent = STEMUtil.handleDataModelXML(file.getAbsolutePath());
                if (dataModelContent != null) {
                    // empty if block
                }
            }
            file.delete();
            file2.delete();
        }
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, 0, 2, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mMapURLLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mMapURLCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mFreshButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        insets.set(n2, 0, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAllMapLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAllMapScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMapInfoLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMapInfoScrollPane, gridBagConstraints, 1, 2, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void handleBackendCall(String string) {
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectToMapServiceSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectToMapServiceSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ConnectToMapServiceSubDlg.this.continuePressed()) {
                ConnectToMapServiceSubDlg.this.dispose();
            }
        }
    }
}

