/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class CellComboBoxEditor
implements TableCellEditor {
    private JTable mTable;
    private TableCellEditor mDefaultCellEditor;
    private TableCellEditor mCurrentEditor;
    private Hashtable<Integer, TableCellEditor> mAllEditors;

    public CellComboBoxEditor(JTable jTable) {
        this.mTable = jTable;
        this.mAllEditors = new Hashtable();
        this.mDefaultCellEditor = new DefaultCellEditor(new JComboBox());
    }

    public void addRowEditor(int n, TableCellEditor tableCellEditor) {
        this.mAllEditors.put(new Integer(n), tableCellEditor);
    }

    public void removeAll() {
        this.mAllEditors.clear();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.mCurrentEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.mCurrentEditor != null) {
            return this.mCurrentEditor.getCellEditorValue();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            this.selectEditor((MouseEvent)eventObject);
        } else {
            this.selectEditor(null);
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            this.selectEditor((MouseEvent)eventObject);
        } else {
            this.selectEditor(null);
        }
        return this.mCurrentEditor.shouldSelectCell(eventObject);
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.mCurrentEditor.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.mCurrentEditor.removeCellEditorListener(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.mCurrentEditor.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        return this.mCurrentEditor.stopCellEditing();
    }

    private void selectEditor(MouseEvent mouseEvent) {
        int n = mouseEvent == null ? this.mTable.getSelectionModel().getAnchorSelectionIndex() : this.mTable.rowAtPoint(mouseEvent.getPoint());
        this.mCurrentEditor = this.mAllEditors.get(new Integer(n));
        if (this.mCurrentEditor == null) {
            this.mCurrentEditor = this.mDefaultCellEditor;
        }
    }
}

