/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class BinningSubDlg
extends BaseDialog
implements ItemListener,
TableModelListener {
    protected ContinueAction mContinueAction;
    private FocusableTextArea mInfo;
    private FocusableLabel mSelectedFieldLabel;
    private String mFieldLabel;
    private String mFieldName;
    private FocusableTextArea mRadioGroupInfo;
    private JRadioButton mAutoBinRadio;
    private JRadioButton mManualBinRadio;
    private SpssButtonGroup mButtonGroup;
    private boolean mIsContinuePressed;
    private JLabel mCutValueLabel;
    private PlainTable mCutValueTable;
    private DefaultTableModel mCutValueTableModel;
    private String mAutoBinValue;

    public BinningSubDlg(BaseWizardDialog baseWizardDialog, String string) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_BINNING_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mFieldName = string;
        this.initializePanel();
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_gsar_bin_aggregate_bins");
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = tableModelEvent.getSource();
        if (tableModelEvent.getType() == 0 && object == this.mCutValueTableModel) {
            int n = tableModelEvent.getFirstRow();
            String string = this.mCutValueTableModel.getValueAt(n, 0).toString();
            this.addEmptyRow(this.mCutValueTable, this.mCutValueTableModel, new String[]{""});
            int n2 = this.mCutValueTable.getRowCount() + 1;
        }
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setDefault();
    }

    private void initializePanel() {
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    public boolean continuePressed() {
        return this.mIsContinuePressed;
    }

    public String getBinValues() {
        String string = "";
        if (this.mAutoBinRadio.isSelected()) {
            string = this.mAutoBinValue;
        } else {
            int n = this.mCutValueTableModel.getRowCount();
            String string2 = "";
            Vector<Double> vector = new Vector<Double>();
            for (int i = 0; i < n; ++i) {
                Object object = this.mCutValueTableModel.getValueAt(i, 0);
                if (object == null || object.toString().length() <= 0) continue;
                vector.add(Double.parseDouble(object.toString()));
            }
            if (vector.size() > 0) {
                double[] dArray = new double[vector.size()];
                int n2 = 0;
                for (Double d : vector) {
                    dArray[n2++] = d;
                }
                Arrays.sort(dArray);
                string = string2;
                for (int i = 0; i < dArray.length; ++i) {
                    string2 = string2 + dArray[i];
                    if (i >= dArray.length - 1) continue;
                    string2 = string2 + ";";
                }
                string = string2;
            }
        }
        return string;
    }

    private boolean addEmptyRow(JTable jTable, DefaultTableModel defaultTableModel, Object[] objectArray) {
        boolean bl = true;
        int n = jTable.getColumnCount();
        int n2 = jTable.getRowCount() - 1;
        if (n < 0 || n2 < 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = defaultTableModel.getValueAt(n2, i);
            if (object == null || object.toString().length() <= 0) continue;
            bl = false;
        }
        if (!bl) {
            defaultTableModel.addRow(objectArray);
            jTable.changeSelection(defaultTableModel.getRowCount() - 1, 1, false, false);
            return true;
        }
        return false;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mInfo = new FocusableTextArea(this.getResString("IDS_STEM_BINNING_SUB_INFO"), null);
        this.mFieldLabel = this.getResString("IDS_STEM_BINNING_SUB_SELECTED_FIELD_LABEL");
        this.mRadioGroupInfo = new FocusableTextArea(this.getResString("IDS_STEM_BINNING_SUB_RADIO_GROUP_LABEL"), null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_BINNING_SUB_AUTO_BIN");
        this.mAutoBinRadio = new JRadioButton(toggleButtonAction);
        this.mAutoBinRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_BINNING_SUB_MANUAL_BIN");
        this.mManualBinRadio = new JRadioButton(toggleButtonAction);
        this.mManualBinRadio.addItemListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mAutoBinRadio);
        this.mButtonGroup.add(this.mManualBinRadio);
        this.mCutValueLabel = DialogUtil.createLabel(this, "IDS_STEM_BINNING_SUB_CUT_TABLE");
        this.mCutValueTableModel = new DefaultTableModel(new String[]{" "}, 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mCutValueTable = new PlainTable(){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                if (this.editCellAt(n, n2)) {
                    Component component = this.getEditorComponent();
                    component.requestFocusInWindow();
                }
            }
        };
        this.mCutValueTable.setModel(this.mCutValueTableModel);
        this.mCutValueTable.setRowHeight(22);
        this.mCutValueTable.setColumnSelectionAllowed(false);
        this.mCutValueTable.setRowSelectionAllowed(true);
        this.mCutValueTable.setSelectionMode(0);
        this.mCutValueTable.getTableHeader().setReorderingAllowed(false);
        this.mCutValueTable.getTableHeader().setResizingAllowed(true);
        this.mCutValueTable.setGridColor(Color.darkGray);
        this.mCutValueTable.getTableHeader().setReorderingAllowed(false);
        this.mCutValueTable.setSelectionMode(0);
        this.mCutValueTable.getColumnModel().getColumn(0).setCellEditor(new FloatFieldEditor(new FloatTextField()));
        this.mCutValueLabel.setLabelFor(this.mCutValueTable);
        this.mCutValueTable.getModel().addTableModelListener(this);
        this.mAutoBinValue = this.getResString("IDS_STEM_BINNING_SUB_AUTO_BIN_VALUE");
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JRadioButton) {
            this.enableTableControls();
        }
    }

    private void setDefault() {
        this.mAutoBinRadio.setSelected(true);
        this.mIsContinuePressed = false;
        this.enableTableControls();
    }

    private void enableTableControls() {
        if (this.mAutoBinRadio.isSelected()) {
            this.mCutValueLabel.setEnabled(false);
            this.mCutValueTable.setEnabled(false);
        } else {
            this.mCutValueLabel.setEnabled(true);
            this.mCutValueTable.setEnabled(true);
            this.selectlastCell();
        }
    }

    private void selectlastCell() {
        int n = this.mCutValueTable.getRowCount() - 1;
        if (n < 0) {
            return;
        }
        if (this.mCutValueTable.getEditorComponent() != null) {
            this.mCutValueTable.getEditorComponent().setEnabled(true);
        }
        this.mCutValueTable.changeSelection(n, 1, false, false);
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        this.mInfo.setRows(2);
        DialogUtil.addUsingGBL(jPanel, this.mInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mInfo.setMinimumSize(new Dimension(240, 50));
        this.mInfo.setPreferredSize(new Dimension(240, 50));
        this.mSelectedFieldLabel = new FocusableLabel(this.mFieldLabel + " " + this.mFieldName);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSelectedFieldLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRadioGroupInfo, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2 * 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mAutoBinRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mManualBinRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 4, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mCutValueLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mCutValueTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(200, 100));
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 4, 2, 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 6, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfo);
        vector.add(this.mRadioGroupInfo);
        vector.add(this.mAutoBinRadio);
        vector.add(this.mManualBinRadio);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    class FloatFieldRender
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        FloatFieldRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && (n2 == 2 || n2 == 3)) {
                Object object2;
                boolean bl3 = jTable.isCellEditable(n, n2);
                this.setBackground(jTable.getTableHeader().getBackground());
                if (bl3) {
                    this.setForeground(jTable.getForeground());
                    this.setOpaque(false);
                } else {
                    this.setForeground(Color.gray);
                    this.setOpaque(true);
                }
                if (bl2) {
                    object2 = null;
                    if (bl) {
                        object2 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                    }
                    if (object2 == null) {
                        object2 = UIManager.getBorder("Table.focusCellHighlightBorder");
                    }
                    this.setBorder((Border)object2);
                } else {
                    this.setBorder(noFocusBorder);
                }
                this.setEnabled(bl3);
                object2 = object.toString();
                try {
                    double d = Double.parseDouble((String)object2);
                    if (((String)object2).length() > 0) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
                        numberFormat.setGroupingUsed(false);
                        numberFormat.setMaximumFractionDigits(2);
                        this.setText(numberFormat.format(d));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setText((String)object2);
                }
            }
            return this;
        }
    }

    class FloatFieldEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private FloatTextField mField;

        FloatFieldEditor(FloatTextField floatTextField) {
            super((JTextField)floatTextField);
            this.mField = floatTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 == 0) {
                if (object != null) {
                    this.mField.setText(object.toString());
                } else {
                    this.mField.setText("");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FloatFieldEditor.this.mField.setSelectionStart(0);
                        FloatFieldEditor.this.mField.setSelectionEnd(FloatFieldEditor.this.mField.getText().length());
                        FloatFieldEditor.this.mField.requestFocus();
                    }
                });
            }
            return this.mField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mField.getText();
        }
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinningSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinningSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinningSubDlg.this.mIsContinuePressed = true;
            BinningSubDlg.this.dispose();
        }
    }
}

