/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.DataMapAssociationSubDlg;
import com.spss.java_client.ui.dialogs.STEM.STEMDataSourcePage;
import com.spss.java_client.ui.dialogs.STEM.STEMUtil;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class AddContextDataSubDlg
extends BaseDialog
implements ActionListener,
ItemListener,
ListSelectionListener,
DocumentListener {
    private static final int FILE_FIELD_LENGTH = 40;
    private static final int LIST_WIDTH = 200;
    private static final int LIST_HEIGHT = 80;
    private String sMapAssocDefault;
    static final String STEM_OPEN_DATASET_LIST = "IDS_STEM_OPEN_DATASET_LIST";
    static final String STEM_MAP_DATA_LIST = "IDS_STEM_MAP_DATA_LIST";
    static final String STEM_FILE_TEXT = "IDS_STEM_FILE_TEXT";
    private String sDefaultContextID = "Context";
    private String sDefaultEventID = "Event Data";
    private String sDefaultPointID = "Point Density";
    private BaseWizardDialog mSTEMWizardDlg;
    protected ContinueAction mContinueAction;
    private FocusableTextArea mContextDataInfo;
    private JRadioButton mOpenDatasetRadio;
    private JRadioButton mMapDataRadio;
    private JRadioButton mCustomFileRadio;
    private SpssButtonGroup mButtonGroup;
    private SerializableList mOpenDatasetList;
    private JScrollPane mOpenDatasetScroll;
    private SerializableList mMapDataList;
    private JScrollPane mMapDataScroll;
    private FileTextField mCustomFileText;
    private JButton mCustomBrowseButton;
    private FocusableTextArea mDatasetInfo;
    private ContextDataItem mSelectedFile;
    private Vector<ContextDataItem> mMapDataFiles;
    private boolean mIsContinuePressed;
    private boolean mIsAssocatePressed;
    private String mDisplayPrj;
    private Vector<ContextDataItem> mOpenDataset;
    private String mRoleString;
    private boolean mIsContextSource;
    private boolean mIsGSAR;
    private boolean mCanEnableAssocButton;

    public AddContextDataSubDlg(BaseWizardDialog baseWizardDialog, Vector<ContextDataItem> vector, boolean bl, String string) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_ADD_CONTEXT_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mSTEMWizardDlg = baseWizardDialog;
        this.mSelectedFile = null;
        this.mMapDataFiles = vector;
        this.mRoleString = string;
        this.mIsContextSource = bl;
        this.mCanEnableAssocButton = true;
        this.mIsGSAR = ((STEMWizardDlg)this.mSTEMWizardDlg).getStepOnePage().isGSARSelected();
        this.updateMapDataList();
        this.updateOpenDataSetList();
        this.mIsContinuePressed = false;
        this.mIsAssocatePressed = false;
        this.mDisplayPrj = "";
        if (this.mOpenDatasetList.getModel().getSize() > 0) {
            this.mOpenDatasetRadio.setSelected(true);
        } else {
            this.mCustomFileRadio.setSelected(true);
        }
        if (this.mIsGSAR && !((STEMWizardDlg)this.mSTEMWizardDlg).getGeoRelationPage().hasMap()) {
            this.mCanEnableAssocButton = false;
        }
        this.setLocationRelativeTo(this.getParent());
        this.sMapAssocDefault = "";
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_add_data_source");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.isSelectedFileOnRemoteHost("IDS_STEM_ADD_CONTEXT_SUB_BROWSE_FILE_TITLE", "IDS_STEM_ADD_CONTEXT_SUB_FILE_FILTER", "IDS_STEM_ADD_CONTEXT_SUB_FILE_EXTENSION", (JTextField)((Object)this.mCustomFileText));
        this.setContinueEnabled();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mOpenDatasetRadio || object == this.mMapDataRadio || object == this.mCustomFileRadio) {
            this.enableControls();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.setDefault();
        this.pack();
    }

    private void setDefault() {
        this.enableControls();
    }

    private void updateOpenDataSetList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        Vector<String> vector = this.getDataSetList();
        for (String string : vector) {
            defaultListModel.addElement(string);
        }
        this.mOpenDatasetList.setModel(defaultListModel);
        if (defaultListModel.getSize() == 0) {
            this.mOpenDatasetRadio.setEnabled(false);
            this.mOpenDatasetList.setEnabled(false);
        }
    }

    private void updateMapDataList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (ContextDataItem contextDataItem : this.mMapDataFiles) {
            defaultListModel.addElement(contextDataItem.getContextDataSourceName());
        }
        this.mMapDataList.setModel(defaultListModel);
        if (this.mMapDataFiles.size() == 0) {
            this.mMapDataRadio.setEnabled(false);
            this.mMapDataList.setEnabled(false);
        }
    }

    private void enableControls() {
        if (this.mOpenDatasetRadio.isSelected()) {
            this.mOpenDatasetList.setEnabled(true);
            this.mMapDataList.setEnabled(false);
            this.mCustomFileText.setEnabled(false);
            this.mCustomFileText.setOpaque(false);
            this.mCustomBrowseButton.setEnabled(false);
        } else if (this.mMapDataRadio.isSelected()) {
            this.mMapDataList.setEnabled(true);
            this.mOpenDatasetList.setEnabled(false);
            this.mCustomFileText.setEnabled(false);
            this.mCustomFileText.setOpaque(false);
            this.mCustomBrowseButton.setEnabled(false);
        } else if (this.mCustomFileRadio.isSelected()) {
            this.mOpenDatasetList.setEnabled(false);
            this.mMapDataList.setEnabled(false);
            this.mCustomFileText.setEnabled(true);
            this.mCustomFileText.setOpaque(true);
            this.mCustomBrowseButton.setEnabled(true);
        }
        this.setContinueEnabled();
    }

    private void setContinueEnabled() {
        if (this.mOpenDatasetRadio.isSelected()) {
            if (this.mOpenDatasetList.getSelectedIndex() > -1) {
                this.mContinueAction.setEnabled(true);
            } else {
                this.mContinueAction.setEnabled(false);
            }
        } else if (this.mMapDataRadio.isSelected()) {
            if (this.mMapDataList.getSelectedIndex() > -1) {
                this.mContinueAction.setEnabled(true);
            } else {
                this.mContinueAction.setEnabled(false);
            }
        } else if (this.mCustomFileRadio.isSelected()) {
            if (this.mCustomFileText.getText() != null && this.mCustomFileText.getDocument().getLength() > 0) {
                this.mContinueAction.setEnabled(true);
            } else {
                this.mContinueAction.setEnabled(false);
            }
        }
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, 2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mContextDataInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, 0, 2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mOpenDatasetRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, n2 * 3, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mOpenDatasetScroll, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, 0, 2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mMapDataRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(0, n2 * 3, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mMapDataScroll, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, 2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mCustomFileRadio, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(0, n2 * 3, 2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mCustomFileText, this.mCustomBrowseButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 6, 1, 1, n, insets);
        insets.set(0, n2 * 3, n2, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetInfo, gridBagConstraints, 0, 7, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mContextDataInfo);
        vector.add(this.mOpenDatasetRadio);
        vector.add(this.mOpenDatasetList);
        vector.add(this.mMapDataRadio);
        vector.add(this.mMapDataList);
        vector.add(this.mCustomFileRadio);
        vector.add(this.mCustomFileText);
        vector.add(this.mCustomBrowseButton);
        vector.add(this.mDatasetInfo);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private boolean processContinue() {
        this.mSelectedFile = null;
        if (this.mOpenDatasetRadio.isSelected()) {
            int n = this.mOpenDatasetList.getSelectedIndex();
            if (n >= 0) {
                this.mSelectedFile = this.mOpenDataset.get(n);
                if (this.mSelectedFile.getSpssVars().size() == 0) {
                    this.mSelectedFile.setSpssVars(this.getVarsFromDataset(this.mSelectedFile.getDataSourceFullName(), this.mSelectedFile.getDatasetUID()));
                }
            }
        } else if (this.mMapDataRadio.isSelected()) {
            int n = this.mMapDataList.getSelectedIndex();
            if (n >= 0) {
                this.mSelectedFile = this.mMapDataFiles.get(n);
            }
        } else if (this.mCustomFileRadio.isSelected()) {
            String string = this.mCustomFileText.getText();
            File file = new File(string);
            String string2 = file.getName();
            String string3 = string2.substring(0, string2.length() - 4);
            string3 = STEMUtil.removeSpaceFrom(string3);
            DocUtil.DataEncryptionTestResults dataEncryptionTestResults = DocUtil.testOpenEncryptedData(this.getParentFrame(), string);
            boolean bl = dataEncryptionTestResults.isCanContinue();
            Vector<VariableBlock> vector = null;
            Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
            if (bl) {
                vector = dataEncryptionTestResults.getVarBlocks();
                for (int i = 0; i < vector.size(); ++i) {
                    String string4;
                    VariableBlock variableBlock = vector.get(i);
                    if (variableBlock.getVarLevel() == MeasurementLevel.unknown) {
                        string4 = this.getResString("IDS_STEM_ADD_CONTEXT_SUB_ERROR_MESG");
                        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string4, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                        if (n != 2) continue;
                        this.mCustomFileText.requestFocusInWindow();
                        return false;
                    }
                    string4 = new SpssVariable();
                    string4.setName(variableBlock.getVarName());
                    string4.setMeasurementLevel(variableBlock.getVarLevel());
                    string4.setLabel(variableBlock.getVarLabel());
                    FormatType formatType = variableBlock.getFormatType();
                    SPSS_Format sPSS_Format = new SPSS_Format();
                    sPSS_Format.setFormatType(formatType);
                    string4.setFormat(sPSS_Format);
                    string4.setType((short)variableBlock.getDiType());
                    string4.setId(STEMDataSourcePage.sIdGenerator.next());
                    vector2.add((ISpssVariable)string4);
                }
            }
            this.mSelectedFile = new ContextDataItem(string3, string, string2, false, this.mIsContextSource, "", ContextDataItem.DataType.FILE, this.sMapAssocDefault);
            this.mSelectedFile.setSpssVars(vector2);
        }
        if (this.mSelectedFile != null) {
            String string = this.getDisplaySourceId();
            this.mSelectedFile.setDisplayID(string);
            if (this.mIsContextSource) {
                this.mSelectedFile.setSourceId(string);
                this.mSelectedFile.setIsRoleContext(true);
            } else {
                this.mSelectedFile.setIsRoleContext(false);
            }
        }
        return true;
    }

    private Vector<ISpssVariable> getVarsFromDataset(String string, LocallyUniqueId locallyUniqueId) {
        Vector<ISpssVariable> vector = null;
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame[] spssFrameArray2 = spssFrameArray;
        int n = spssFrameArray2.length;
        for (int i = 0; i < n; ++i) {
            SpssFrame spssFrame = spssFrameArray2[i];
            if (!spssFrame.docType().equals((Object)DocType.DE_DOC)) continue;
            File file = spssFrame.getCoreDocument().getFileSpec();
            if (file != null && file.getAbsolutePath().equals(string)) {
                iSpssDataSrc = ((DataFrame)spssFrame).getDataSource();
                break;
            }
            if (string.length() == 0 && locallyUniqueId != null && (iSpssDataSrc = ((DataFrame)spssFrame).getDataSource()).getDataSetId().equals((Object)locallyUniqueId)) break;
        }
        if (iSpssDataSrc != null) {
            vector = new Vector<ISpssVariable>();
            int n2 = iSpssDataSrc.columnCount();
            for (n = 0; n < n2; ++n) {
                vector.add(n, iSpssDataSrc.getVariable(n));
            }
        }
        return vector;
    }

    protected JFrame getParentFrame() {
        Container container = this.mSTEMWizardDlg.getParent();
        JFrame jFrame = container instanceof JFrame ? (JFrame)container : SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        return jFrame;
    }

    public boolean continuePressed() {
        return this.mIsContinuePressed;
    }

    public boolean AssocatePressed() {
        return this.mIsAssocatePressed;
    }

    private boolean isSelectedFileOnRemoteHost(String string, String string2, String string3, JTextField jTextField) {
        int n;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString(string));
        String[] stringArray = this.getResStringArray(string2);
        String[] stringArray2 = this.getResStringArray(string3);
        for (n = 1; n < stringArray.length; ++n) {
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(stringArray[n], stringArray2[n]));
        }
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(stringArray[0], stringArray2[0]));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileSelectionMode(0);
        n = remoteFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string4 = remoteFileChooser.getSelectedFilePath();
            jTextField.setText(string4);
        }
        return remoteFileChooser.isServerFileSystem();
    }

    private Vector<String> getDataSetList() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        String string = DataMgr.getDataMgr().getDataSource(locallyUniqueId).getDatasetName();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        this.mOpenDataset = new Vector();
        for (SpssFrame spssFrame : spssFrameArray) {
            String string2;
            if (!(spssFrame instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrame;
            String string3 = dataFrame.getCoreDocument().getDocName();
            File file = dataFrame.getCoreDocument().getFileSpec();
            if (dataFrame.getCoreDocument().isDocumentEmpty() || ((STEMWizardDlg)this.mSTEMWizardDlg).getContextPage().isDataSetUsed(dataFrame.getDatasetId())) continue;
            String string4 = dataFrame.getDatasetName();
            String string5 = "";
            if (file != null) {
                string5 = file.getAbsolutePath();
                string2 = string3;
            } else {
                string2 = string4;
            }
            String string6 = string3 + " [" + string4 + "]";
            vector.add(string6);
            String string7 = STEMUtil.removeSpaceFrom(string4);
            ContextDataItem contextDataItem = new ContextDataItem(string7, string5, string6, true, this.mIsContextSource, "", ContextDataItem.DataType.DATASET, this.sMapAssocDefault);
            contextDataItem.setDataSetName(string4);
            contextDataItem.setDatasetUID(dataFrame.getDatasetId());
            this.mOpenDataset.add(n, contextDataItem);
            ++n;
        }
        return vector;
    }

    private String getDisplaySourceId() {
        String string = this.mRoleString;
        string = this.mIsContextSource ? ((STEMWizardDlg)this.mSTEMWizardDlg).findUniqueId(this.mRoleString) : (this.mIsGSAR ? this.getResString("IDS_STEM_FIELDS_SOURCE_EVENT_DATA_ID") : this.getResString("IDS_STEM_FIELDS_SOURCE_PINT_DENSITY_ID"));
        return string;
    }

    public ContextDataItem getSelectedFile() {
        return this.mSelectedFile;
    }

    public String getDisplayPrj() {
        return this.mDisplayPrj;
    }

    private boolean runAssociateSub() {
        ContextDataItem contextDataItem = this.getSelectedFile();
        if (contextDataItem == null) {
            this.processContinue();
            contextDataItem = this.getSelectedFile();
            this.mIsContinuePressed = true;
        }
        boolean bl = false;
        Vector<String> vector = ((STEMWizardDlg)this.mSTEMWizardDlg).getGeoRelationPage().getAllMapIds();
        Hashtable<String, Vector<ISpssVariable>> hashtable = ((STEMWizardDlg)this.mSTEMWizardDlg).getGeoRelationPage().getMapKeys();
        boolean bl2 = false;
        String[] stringArray = this.mIsGSAR ? this.mSTEMWizardDlg.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_ARRARY") : this.mSTEMWizardDlg.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_STP_ARRARY");
        DataMapAssociationSubDlg dataMapAssociationSubDlg = new DataMapAssociationSubDlg(this.mSTEMWizardDlg, contextDataItem, vector, hashtable, this.mIsGSAR, bl2, stringArray);
        dataMapAssociationSubDlg.setVisible(true);
        if (dataMapAssociationSubDlg.continuePressed()) {
            this.mDisplayPrj = dataMapAssociationSubDlg.getDisplayProjection();
            bl = true;
        }
        return bl;
    }

    private void initVars() {
        this.sDefaultContextID = this.getResString("IDS_STEM_FIELDS_SOURCE_CONTEXT_ID");
        this.sDefaultEventID = this.getResString("IDS_STEM_FIELDS_SOURCE_EVENT_DATA_ID");
        this.sDefaultPointID = this.getResString("IDS_STEM_FIELDS_SOURCE_PINT_DENSITY_ID");
        this.sMapAssocDefault = this.getResString("IDS_STEM_CONTEXT_DATA_MAP_ASSOC_DEFAULT");
        this.mContextDataInfo = new FocusableTextArea(this.getResString("IDS_STEM_ADD_CONTEXT_SUB_INFO"), null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_ADD_CONTEXT_SUB_OPEN_RADIO");
        this.mOpenDatasetRadio = new JRadioButton(toggleButtonAction);
        this.mOpenDatasetRadio.addItemListener(this);
        this.mOpenDatasetList = new SerializableList(STEM_OPEN_DATASET_LIST);
        this.mOpenDatasetScroll = new JScrollPane(this.mOpenDatasetList);
        this.mOpenDatasetScroll.setPreferredSize(new Dimension(200, 80));
        this.mOpenDatasetList.addListSelectionListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_ADD_CONTEXT_SUB_MAP_DATA_RADIO");
        this.mMapDataRadio = new JRadioButton(toggleButtonAction);
        this.mMapDataRadio.addItemListener(this);
        this.mMapDataList = new SerializableList(STEM_MAP_DATA_LIST);
        this.mMapDataScroll = new JScrollPane(this.mMapDataList);
        this.mMapDataScroll.setPreferredSize(new Dimension(200, 80));
        this.mMapDataList.addListSelectionListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_ADD_CONTEXT_SUB_CHOOSE_RADIO");
        this.mCustomFileRadio = new JRadioButton(toggleButtonAction);
        this.mCustomFileRadio.addItemListener(this);
        this.mCustomFileText = new FileTextField();
        this.mCustomFileText.setAction(new TextFieldAction(this, STEM_FILE_TEXT));
        this.mCustomFileText.setColumns(40);
        this.mCustomFileText.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_ADD_CONTEXT_SUB_BROWSE_BUTTON");
        this.mCustomBrowseButton = new JButton(toggleButtonAction);
        this.mCustomBrowseButton.addActionListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mOpenDatasetRadio);
        this.mButtonGroup.add(this.mMapDataRadio);
        this.mButtonGroup.add(this.mCustomFileRadio);
        this.mDatasetInfo = new FocusableTextArea(this.getResString("IDS_STEM_ADD_CONTEXT_SUB_INFO1"), null);
    }

    class AssociateAction
    extends AbstractAction {
        AssociateAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_ASSOCIATION"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_ASSOCIATION"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddContextDataSubDlg.this.mIsAssocatePressed = AddContextDataSubDlg.this.runAssociateSub();
            AddContextDataSubDlg.this.dispose();
        }
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddContextDataSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddContextDataSubDlg.this.mIsContinuePressed = false;
            AddContextDataSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddContextDataSubDlg.this.processContinue();
            AddContextDataSubDlg.this.mIsContinuePressed = true;
            ContextDataItem contextDataItem = AddContextDataSubDlg.this.getSelectedFile();
            if (AddContextDataSubDlg.this.mCanEnableAssocButton && (contextDataItem.getDataType() == ContextDataItem.DataType.DATASET || contextDataItem.getDataType() == ContextDataItem.DataType.FILE)) {
                AddContextDataSubDlg.this.mIsAssocatePressed = AddContextDataSubDlg.this.runAssociateSub();
            }
            AddContextDataSubDlg.this.dispose();
        }
    }
}

