/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.SpssVLMapId;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.core.xml.DOMFactory;
import com.spss.java_client.core.xml.SchemaType;
import com.spss.java_client.ui.dialogs.MC.CorrelationEntry;
import com.spss.java_client.ui.dialogs.MC.FitStatistics;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.shared.core_tools.utils.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SimulationPlanHandler {
    private static final String PLAN_TIME_STAMP = "autofitTimeStamp";
    private static final String CRETERIA_TYPE_POINT_VALUE = "point_value";
    private static final String XML_FITTING_ROOT_ELE = "FitStats";
    private static final String CRETERIA_TYPE_TAIL = "tail";
    private static final String CRETERIA_UNIT_VALUE = "value";
    private static final String CRETERIA_UNIT_PERCENT = "percent";
    private static final String CRETERIA_UNIT_TAIL_PERCENTILE = "percentile";
    private static final String XML_ATT_STDDEV = "stddev";
    private static final String XML_ATT_NBINS = "nbins";
    private static final String XML_ELE_MODELFILES = "ModelFiles";
    private static final String XML_ELE_PMMLMODELS = "PMMLModels";
    private static final String XML_ELE_MODELFILE = "ModelFile";
    private static final String XML_ATT_NUMFILES = "numberOfFiles";
    private static final String XML_ATT_FILE = "file";
    private static final String XML_ATT_NUM_TARGETS = "numberOfTargets";
    private static final String XML_ATT_IS_CUSTOMMODEL = "customModels";
    private static final String XML_ELE_CUSTOMMODELS = "CustomModels";
    private static final String XML_ATT_NUM_EQUATION = "numberOfEquations";
    private static final String XML_ELE_EQUATION = "Equation";
    private static final String XML_ATT_TARGET = "target";
    private static final String XML_ELE_EXPRESSION = "Expression";
    private static final String XML_ELE_COMMENT = "Comment";
    private static final String XML_ELE_SIMULATED_FIELDS = "SimulatedFields";
    private static final String XML_ATT_NUM_FIELDS = "numberOfFields";
    private static final String XML_ELE_SIMULATED_FIELD = "SimulatedField";
    private static final String XML_ELE_TARGET = "Target";
    private static final String XML_ATT_EXCLUD = "excludeFromOutput";
    private static final String XML_ATT_OUTFORMAT = "outputFormat";
    private static final String XML_ELE_TARGET_FILTER = "TargetFilter";
    private static final String XML_ATT_NAME = "name";
    private static final String XML_ATT_ML = "measurementLevel";
    private static final String XML_VAL_ML_CATE = "categorical";
    private static final String XML_VAL_ML_ORDINAL = "ordinal";
    private static final String XML_VAL_ML_SCALE = "continuous";
    private static final String XML_ATT_MAPPEDNAME = "mappedName";
    private static final String XML_ATT_MIN = "min";
    private static final String XML_ATT_MAX = "max";
    private static final String XML_ATT_AUTOFIT = "autofitted";
    private static final String XML_ATT_LOCKED = "locked";
    private static final String XML_ATT_DIST_NUMPARASETS = "numberOfParamSets";
    private static final String XML_ELE_ASSO_TARGET = "AssociatedTarget";
    private static final String XML_ELE_AUTOFIT_LIST = "AutofitDistList";
    private static final String XML_ELE_DISTNAME = "DistName";
    private static final String XML_ELE_VALUELABELS = "ValueLabels";
    private static final String XML_ELE_VALUELABEL = "ValueLabel";
    private static final String XML_ATT_DISPLAY_VALUE = "displayValue";
    private static final String XML_ELE_DISTBETA = "DistBeta";
    private static final String XML_ELE_DISTBIO = "DistBinomial";
    private static final String XML_ELE_DISTCATE = "DistCategorical";
    private static final String XML_ELE_DISTEMP = "DistEmpirical";
    private static final String XML_ELE_DISTEXP = "DistExponential";
    private static final String XML_ELE_DISTGAMMA = "DistGamma";
    private static final String XML_ELE_DISTLOG = "DistLognormal";
    private static final String XML_ELE_DISTNEGBIN = "DistNegbinomial";
    private static final String XML_ELE_DISTNORM = "DistNormal";
    private static final String XML_ELE_DISTPOISSON = "DistPoisson";
    private static final String XML_ELE_DISTTRI = "DistTriangular";
    private static final String XML_ELE_DISTUNIFORM = "DistUniform";
    private static final String XML_ELE_DISTRANGE = "DistUserRanges";
    private static final String XML_ELE_DISTWEIBULL = "DistWeibull";
    private static final String XML_ELE_BERNOULLI = "DistBernoulli";
    private static final String XML_ELE_FIXED_FIELDS = "FixedFields";
    private static final String XML_ELE_FIXED_FIELD = "FixedField";
    private static final String XML_ATT_VALUETYPE = "valueType";
    private static final String XML_ELE_PARAMETERS = "Parameters";
    private static final String XML_ELE_CATEGORY = "Category";
    private static final String XML_ELE_INTERVAL = "Interval";
    private static final String XML_ELE_PROBABILITY = "Probability";
    private static final String XML_ELE_VALUE = "Value";
    private static final String XML_ATT_VALUE = "value";
    private static final String XML_ELE_CORR_MATRIX = "CorrMatrix";
    private static final String XML_ATT_NUM_CELLS = "numberOfCells";
    private static final String XML_ELE_CORRCELL = "CorrCell";
    private static final String XML_ATT_ROWVAR = "rowVar";
    private static final String XML_ATT_COLVAR = "colVar";
    private static final String XML_ELE_SETTINGS = "Settings";
    private static final String XML_ELE_CROSSTAB = "ContingencyTable";
    private static final String XML_ELE_CROSS_FACTORS = "CrossFactors";
    private static final String XML_ELE_FACTOR = "Factor";
    private static final String XML_ATT_SAMPLES = "simulatedCases";
    private static final String XML_ATT_SEED = "seed";
    private static final String XML_ATT_NUMCRITERIA = "numberOfCriteria";
    private static final String XML_ELE_CRITERIA = "Criteria";
    private static final String XML_ATT_TYPE = "type";
    private static final String XML_ATT_FILTER_INCLUDE_LOW = "includeLow";
    private static final String XML_ATT_FILTER_INCLUDE_HIGH = "includeHigh";
    private static final String XML_ATT_MAXSAMPLES = "maxSamples";
    private static final String XML_ELE_POINT_VALUE = "PointValue";
    private static final String XML_ATT_PARAM = "parameter";
    private static final String XML_ATT_THRESHHOLD = "threshold";
    private static final String XML_ATT_UNIT = "unit";
    private static final String XML_ELE_TAIL = "Tail";
    private static final String XML_ATT_SIDE = "side";
    private static final String XML_ATT_VALUE_RIGHT = "right";
    private static final String XML_ATT_VALUE_LEFT = "left";
    private static final String XML_ATT_FREQ = "frequency";
    private static final String XML_ATT_CONFLEVEL = "confidenceLevel";
    private static final String XML_ELE_FILTERING = "Filtering";
    private static final String XML_ATT_NUM_FILTERS = "numberOfFilters";
    private static final String XML_ELE_FILTER = "Filter";
    private static final String XML_ATT_LOW = "low";
    private static final String XML_ATT_HIGH = "high";
    private static final String XML_ELE_FIT = "Fit";
    private static final String XML_ATT_FIT_NAME = "fitName";
    private static final String XML_ATT_FIT_VALUE = "fitValue";
    private static final String XML_ATT_FIT_P_VALUE = "p";
    private static final String XML_VALUE_DIST_BINOMIAL = "Binomial";
    private static final String XML_VALUE_DIST_NEGBIN = "Negbinomial";
    private static final String XML_VALUE_DIST_CATEGORICAL = "Categorical";
    private static final String XML_VALUE_DIST_LOGNORMAL = "Lognormal";
    private static final String XML_VALUE_DIST_NORMAL = "Normal";
    private static final String XML_VALUE_DIST_POISSON = "Poisson";
    private static final String XML_VALUE_DIST_TRIANGULAR = "Triangular";
    private static final String XML_VALUE_DIST_UNIFORM = "Uniform";
    private static final String XML_VALUE_DIST_WEIBULL = "Weibull";
    private static final String XML_VALUE_DIST_GAMMA = "Gamma";
    private static final String XML_VALUE_DIST_BETA = "Beta";
    private static final String XML_VALUE_DIST_EXPONENTIAL = "Exponential";
    private static final String XML_VALUE_DIST_BERNOULLI = "Bernoulli";
    private static final String XML_VALUE_DIST_EMPIRICAL = "Empirical";
    private static final String XML_VALUE_DIST_USERRANGES = "UserRanges";
    private static final Hashtable<String, SimulationHelper.DistributionType> sDistNameAndType = new Hashtable();
    private static final Hashtable<String, SimulationHelper.DistributionType> sFitDistNameAndType = new Hashtable();
    private ArrayList<Pair<String, String>> mTargetAndEquations;
    private ArrayList<Pair<String, String>> mTargetAndComments;
    private ArrayList<String> mPMMLFileNames;
    private ArrayList<SimulatedField> mSimulatedPredictors;
    private ArrayList<CorrelationEntry> mCorrelations;
    private boolean mIsCorrLocked = false;
    private MonteCarloSimulationDlg.CorrelationStructure mCorrelStruct;
    private ArrayList<SamplingCriteria> mCriterias;
    private int mNumOfSamples = -1;
    private int mSeed;
    private ArrayList<TargetField> mTargetList;
    private ArrayList<ModelFile> mModelFiles = null;
    private String mTimeStamp = "";
    private boolean mIsCrossTabUsed = false;
    private Vector<String> mCrossFactorNames;

    public SimulationPlanHandler() {
        SimulationPlanHandler.setupDistMap();
        SimulationPlanHandler.setupFitDistMap();
    }

    public boolean parsePlanFile(String string) {
        Object object;
        NodeList nodeList;
        Document document;
        boolean bl = true;
        this.mCrossFactorNames = new Vector();
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(new FileInputStream(string)), SchemaType.SCHEMA_SIMULATION_PLAN);
            if (document == null) {
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute(PLAN_TIME_STAMP);
        if (string2 != null && string2.length() > 0) {
            int n = string2.lastIndexOf(10);
            if (n == string2.length() - 1) {
                string2 = string2.substring(0, n);
            }
            this.mTimeStamp = string2;
        }
        if ((nodeList = element.getElementsByTagName(XML_ELE_MODELFILES)).getLength() > 0) {
            bl = this.handleModelFiles(nodeList);
        }
        if (!bl) {
            return bl;
        }
        nodeList = element.getElementsByTagName(XML_ELE_CROSSTAB);
        if (bl && nodeList.getLength() > 0) {
            this.mIsCrossTabUsed = true;
            this.handleCrossFactors(nodeList);
        }
        nodeList = element.getElementsByTagName(XML_ELE_SIMULATED_FIELDS);
        int n = 0;
        if (nodeList.getLength() > 0) {
            object = (Element)nodeList.item(0);
            n += Integer.parseInt(object.getAttribute(XML_ATT_NUM_FIELDS));
        }
        if ((object = element.getElementsByTagName(XML_ELE_FIXED_FIELDS)).getLength() > 0) {
            Element element2 = (Element)object.item(0);
            n += Integer.parseInt(element2.getAttribute(XML_ATT_NUM_FIELDS));
        }
        this.mSimulatedPredictors = new ArrayList(n);
        if (nodeList.getLength() > 0) {
            bl = this.handleSimulatedFields(nodeList, this.mSimulatedPredictors, false);
        }
        if (bl && object.getLength() > 0) {
            bl = this.handleFixedFields((NodeList)object);
        }
        nodeList = element.getElementsByTagName(XML_ELE_CORR_MATRIX);
        if (bl && nodeList.getLength() > 0) {
            bl = this.handleCorrelations(nodeList);
        }
        nodeList = element.getElementsByTagName(XML_ELE_SETTINGS);
        if (bl && nodeList.getLength() > 0) {
            bl = this.handleSettings(nodeList);
        }
        return bl;
    }

    public boolean parsingFitStats(InputStreamReader inputStreamReader, ArrayList<SimulatedField> arrayList) {
        return this.parsingFitStats(inputStreamReader, arrayList, false);
    }

    public boolean parsingFitStats(InputStreamReader inputStreamReader, ArrayList<SimulatedField> arrayList, boolean bl) {
        Document document;
        boolean bl2 = true;
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(inputStreamReader), SchemaType.SCHEMA_NONE);
            if (document == null) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equals(XML_FITTING_ROOT_ELE)) {
            return false;
        }
        NodeList nodeList = element.getElementsByTagName(XML_ELE_SIMULATED_FIELDS);
        if (nodeList.getLength() > 0) {
            bl2 = this.handleSimulatedFields(nodeList, arrayList, bl);
        }
        nodeList = element.getElementsByTagName(XML_ELE_CORR_MATRIX);
        if (!bl && nodeList.getLength() > 0) {
            bl2 = this.handleCorrelations(nodeList);
        }
        return bl2;
    }

    public ArrayList<String> getPMMLModelFileNamesFromPlan() {
        return this.mPMMLFileNames;
    }

    public ArrayList<Pair<String, String>> getTargetAndEquationFromPlan() {
        return this.mTargetAndEquations;
    }

    public ArrayList<Pair<String, String>> getTargetAndCommentFromPlan() {
        return this.mTargetAndComments;
    }

    public ArrayList<SimulatedField> getSimulatedPredictors() {
        return this.mSimulatedPredictors;
    }

    public boolean isFieldFromPlan(String string) {
        boolean bl = false;
        if (this.mSimulatedPredictors != null && this.mSimulatedPredictors.size() > 0) {
            for (SimulatedField simulatedField : this.mSimulatedPredictors) {
                if (!simulatedField.getName().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public ArrayList<CorrelationEntry> getCorrelationMatrix() {
        return this.mCorrelations;
    }

    public MonteCarloSimulationDlg.CorrelationStructure getcorrelationStructure() {
        return this.mCorrelStruct;
    }

    public ArrayList<SamplingCriteria> getCriterias() {
        return this.mCriterias;
    }

    public int getNumOfSampling() {
        return this.mNumOfSamples;
    }

    public int getSamplingSeed() {
        return this.mSeed;
    }

    public ArrayList<TargetField> getTargets() {
        return this.mTargetList;
    }

    public ArrayList<ModelFile> getModelFiles() {
        return this.mModelFiles;
    }

    private boolean handleModelFiles(NodeList nodeList) {
        boolean bl = true;
        Element element = (Element)nodeList.item(0);
        int n = Integer.parseInt(element.getAttribute(XML_ATT_NUMFILES));
        this.mModelFiles = new ArrayList(n);
        NodeList nodeList2 = element.getElementsByTagName(XML_ELE_MODELFILE);
        String string = "";
        String string2 = "";
        for (int i = 0; i < nodeList2.getLength() && bl; ++i) {
            Element element2 = (Element)nodeList2.item(i);
            string = element2.getAttribute(XML_ATT_FILE);
            if (string.length() == 0) {
                bl = false;
                continue;
            }
            string2 = element2.getAttribute(XML_ATT_IS_CUSTOMMODEL);
            ModelFile modelFile = new ModelFile(string, string2.equals("yes"));
            int n2 = Integer.parseInt(element2.getAttribute(XML_ATT_NUM_TARGETS));
            NodeList nodeList3 = element2.getElementsByTagName(XML_ELE_TARGET);
            bl = this.handleTargetList(nodeList3, n2);
            if (!bl) {
                return false;
            }
            modelFile.setTargetList(this.mTargetList);
            this.mModelFiles.add(i, modelFile);
        }
        return bl;
    }

    private boolean handlePMMLModels(NodeList nodeList) {
        boolean bl = true;
        Element element = (Element)nodeList.item(0);
        int n = Integer.parseInt(element.getAttribute(XML_ATT_NUMFILES));
        this.mPMMLFileNames = new ArrayList();
        NodeList nodeList2 = element.getElementsByTagName(XML_ELE_MODELFILE);
        String string = "";
        for (int i = 0; i < nodeList2.getLength() && bl; ++i) {
            Element element2 = (Element)nodeList2.item(i);
            string = element2.getAttribute(XML_ATT_FILE);
            if (string.length() == 0) {
                bl = false;
                continue;
            }
            File file = new File(string);
            if (!file.exists() || !file.isFile()) {
                bl = false;
                continue;
            }
            this.mPMMLFileNames.add(i, string);
        }
        if (n != this.mPMMLFileNames.size()) {
            bl = false;
        }
        return bl;
    }

    private boolean handleCustomModel(NodeList nodeList) {
        Element element = (Element)nodeList.item(0);
        int n = Integer.parseInt(element.getAttribute(XML_ATT_NUM_EQUATION));
        this.mTargetAndEquations = new ArrayList(n);
        this.mTargetAndComments = new ArrayList(n);
        NodeList nodeList2 = element.getElementsByTagName(XML_ELE_EQUATION);
        String string = "";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element2 = (Element)nodeList2.item(i);
            string = element2.getAttribute(XML_ATT_TARGET);
            NodeList nodeList3 = element2.getElementsByTagName(XML_ELE_EXPRESSION);
            if (nodeList3.getLength() != 1) {
                return false;
            }
            Node node = nodeList3.item(0).getFirstChild();
            if (node == null) {
                return false;
            }
            string2 = node.getNodeValue();
            this.mTargetAndEquations.add(i, (Pair<String, String>)new Pair((Object)string, (Object)string2));
            NodeList nodeList4 = element2.getElementsByTagName(XML_ELE_COMMENT);
            if (nodeList4.getLength() == 1) {
                Node node2 = nodeList4.item(0).getFirstChild();
                if (node2 == null) {
                    return false;
                }
                string3 = node2.getNodeValue();
                this.mTargetAndComments.add(i, (Pair<String, String>)new Pair((Object)string, (Object)string3));
                continue;
            }
            this.mTargetAndComments.add(i, (Pair<String, String>)new Pair((Object)string, (Object)""));
        }
        return true;
    }

    private boolean handleSimulatedFields(NodeList nodeList, ArrayList<SimulatedField> arrayList, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = arrayList.size() > 0;
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(XML_ELE_SIMULATED_FIELD);
        String string = "";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < nodeList2.getLength() && bl2; ++i) {
            Object object;
            SimulatedField simulatedField;
            bl2 = true;
            Element element2 = (Element)nodeList2.item(i);
            String string4 = element2.getAttribute(XML_ATT_NAME);
            if (string4.length() == 0) {
                bl2 = false;
                continue;
            }
            if (!bl3) {
                NodeList nodeList3;
                String string5 = element2.getAttribute(XML_ATT_ML);
                if (string5.length() == 0) {
                    bl2 = false;
                    continue;
                }
                MeasurementLevel measurementLevel = SimulationPlanHandler.getMLevel(string5);
                String string6 = element2.getAttribute(XML_ATT_MAPPEDNAME);
                String string7 = element2.getAttribute(XML_ATT_MIN);
                String string8 = element2.getAttribute(XML_ATT_MAX);
                String string9 = element2.getAttribute(XML_ATT_AUTOFIT);
                string = element2.getAttribute(XML_ATT_EXCLUD);
                string2 = element2.getAttribute(XML_ATT_LOCKED);
                string3 = element2.getAttribute(XML_ATT_OUTFORMAT);
                simulatedField = new SimulatedField(string4);
                if (this.mCrossFactorNames.contains(string4)) {
                    simulatedField.setInContingencyTable(true);
                    string2 = "yes";
                }
                simulatedField.setMeasurementLevel(measurementLevel);
                if (string6.length() > 0) {
                    simulatedField.setMappedName(string6);
                }
                if (string7.length() > 0) {
                    simulatedField.setMinValue(this.getDoubleValue(string7));
                }
                if (string8.length() > 0) {
                    simulatedField.setMaxValue(this.getDoubleValue(string8));
                }
                if (((String)(object = element2.getAttribute(XML_ATT_VALUETYPE))).equals("string")) {
                    simulatedField.setType((short)1);
                } else {
                    simulatedField.setType((short)0);
                }
                if (string9.length() > 0) {
                    simulatedField.setAutoFit(string9.equals("yes"));
                }
                simulatedField.setLock(string2.equals("yes"));
                simulatedField.setExcludeFromOutput(string.equals("yes"));
                if (string3.length() > 0) {
                    simulatedField.setOutputFormat(string3);
                    this.processFormat(simulatedField, null, string3);
                }
                if ((nodeList3 = element2.getElementsByTagName(XML_ELE_VALUELABELS)) != null && nodeList3.getLength() == 1) {
                    this.processValueLabels(simulatedField, nodeList3);
                }
            } else {
                simulatedField = this.findFieldFrom(string4, arrayList);
            }
            object = this.HandleSimChildNodes(element2.getChildNodes(), simulatedField);
            this.handleOneDistNode((Node)object, simulatedField, true, bl);
            if (!bl3) {
                Object object2;
                int n = 0;
                NodeList nodeList4 = element2.getElementsByTagName(XML_ELE_ASSO_TARGET);
                for (n = 0; n < nodeList4.getLength(); ++n) {
                    object2 = (Element)nodeList4.item(n);
                    string4 = object2.getAttribute(XML_ATT_NAME);
                    if (string4.length() == 0) {
                        return false;
                    }
                    simulatedField.addRelatedModelName(string4);
                }
                object2 = element2.getElementsByTagName(XML_ELE_AUTOFIT_LIST);
                if (object2.getLength() == 1) {
                    Element element3 = (Element)object2.item(0);
                    NodeList nodeList5 = element3.getElementsByTagName(XML_ELE_DISTNAME);
                    for (n = 0; n < nodeList5.getLength(); ++n) {
                        Element element4 = (Element)nodeList5.item(n);
                        string4 = element4.getAttribute(XML_ATT_NAME);
                        if (string4.length() == 0) {
                            return false;
                        }
                        simulatedField.addAutofilDistName(string4);
                    }
                }
                arrayList.add(simulatedField);
                continue;
            }
            for (object = object.getNextSibling(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1 || sDistNameAndType.get(object.getNodeName()) == null && sFitDistNameAndType.get(object.getNodeName()) == null) continue;
                this.handleOneDistNode((Node)object, simulatedField, false, bl);
            }
        }
        return bl2;
    }

    private void processValueLabels(SimulatedField simulatedField, NodeList nodeList) {
        boolean bl;
        TreeMap<OBS, String> treeMap = new TreeMap<OBS, String>();
        boolean bl2 = bl = simulatedField.getType() > 0;
        if (nodeList.getLength() == 1) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getElementsByTagName(XML_ELE_VALUELABEL);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2 = (Element)nodeList2.item(i);
                String string = element2.getAttribute("value");
                OBS oBS = null;
                if (bl) {
                    oBS = new OBS(string);
                } else {
                    try {
                        oBS = new OBS(Double.parseDouble(string));
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                String string2 = element2.getAttribute(XML_ATT_DISPLAY_VALUE);
                if (string2 == null || string2 != null && string2.length() == 0) {
                    string2 = string;
                }
                if (oBS == null) continue;
                treeMap.put(oBS, string2);
            }
        }
        if (treeMap.size() > 0) {
            simulatedField.setValueLabels((IValueLabelMap)new ValueLabelMap(SpssVLMapId.next(), treeMap));
        }
    }

    private void processFormat(SimulatedField simulatedField, TargetField targetField, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String string2 = stringTokenizer.nextToken();
        int n2 = SimulationHelper.getFormatIndex(string2.trim());
        if (n2 >= 0) {
            int n3 = 0;
            if (n == 2) {
                String string3 = stringTokenizer.nextToken();
                try {
                    n3 = Integer.parseInt(string3.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
            }
            if (simulatedField != null) {
                simulatedField.setFormatIndex(n2, n3);
            } else {
                targetField.setFormatIndex(n2, n3);
            }
        }
    }

    private boolean handleOneDistNode(Node node, SimulatedField simulatedField, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        boolean bl3 = true;
        boolean bl4 = false;
        String string = node.getNodeName();
        SimulationHelper.DistributionType distributionType = sDistNameAndType.get(string);
        if (distributionType == null) {
            distributionType = sFitDistNameAndType.get(string);
        }
        if (distributionType == null) {
            return false;
        }
        if (bl) {
            simulatedField.setDistributionType(distributionType);
        }
        FitStatistics fitStatistics = null;
        if (((Element)node).getElementsByTagName(XML_ELE_FIT).getLength() != 0) {
            fitStatistics = new FitStatistics(SimulationHelper.getDistributionName(distributionType), distributionType);
            bl4 = true;
        }
        if (!bl4 && distributionType == SimulationHelper.DistributionType.NEGBIN && ((String)(object3 = ((Element)node).getAttribute(XML_ATT_TYPE))).length() > 0) {
            simulatedField.setNegBinType((String)object3);
        }
        object3 = new ArrayList();
        if (distributionType == SimulationHelper.DistributionType.EMPIRICAL) {
            object2 = ((Element)node).getAttribute(XML_ATT_MIN);
            String string2 = ((Element)node).getAttribute(XML_ATT_MAX);
            if (((String)object2).length() > 0 && string2.length() > 0) {
                simulatedField.setEmpricalMinMax(this.getDoubleValue((String)object2), this.getDoubleValue(string2));
                ((ArrayList)object3).add(new Pair((Object)XML_ATT_MIN, object2));
                ((ArrayList)object3).add(new Pair((Object)XML_ATT_MAX, (Object)string2));
                if (bl4) {
                    fitStatistics.addOneParamAndValue(XML_ATT_MIN, (String)object2);
                    fitStatistics.addOneParamAndValue(XML_ATT_MAX, string2);
                }
            }
            if (!bl4) {
                object2 = ((Element)node).getAttribute(XML_ATT_STDDEV);
                string2 = ((Element)node).getAttribute(XML_ATT_NBINS);
                if (((String)object2).length() <= 0 || string2.length() > 0) {
                    // empty if block
                }
                object = new Vector();
                simulatedField.setEmpricalProbs(this.handleProbabilityEle((Element)node, (Vector<String>)object));
            }
        }
        object2 = node.getChildNodes();
        int n = -1;
        object = ((Element)node).getAttribute(XML_ATT_DIST_NUMPARASETS);
        if (object != null && ((String)object).length() > 0) {
            n = Integer.parseInt((String)object);
        }
        for (int i = 0; i < object2.getLength() && distributionType != SimulationHelper.DistributionType.EMPIRICAL; ++i) {
            Object object4;
            Object object5;
            Object object6;
            Node node2 = object2.item(i);
            if (node2.getNodeType() != 1) continue;
            String string3 = node2.getNodeName();
            if (string3.equals(XML_ELE_FIT)) {
                object6 = ((Element)node2).getAttribute(XML_ATT_FIT_NAME);
                String string4 = ((Element)node2).getAttribute(XML_ATT_FIT_VALUE);
                object5 = ((Element)node2).getAttribute(XML_ATT_FIT_P_VALUE);
                fitStatistics.addFitFunctionNameAndValue((String)object6, this.getDoubleValue(string4), this.getDoubleValue((String)object5));
                continue;
            }
            if (string3.equals(XML_ELE_PARAMETERS)) {
                object6 = (Element)node2;
                NamedNodeMap namedNodeMap = object6.getAttributes();
                if (namedNodeMap == null) continue;
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node3 = namedNodeMap.item(j);
                    String string5 = node3.getNodeName();
                    object4 = node3.getNodeValue();
                    if (bl4 && (distributionType == SimulationHelper.DistributionType.NEGBIN || distributionType == SimulationHelper.DistributionType.NEGBIN_TRIAL) && string5.equals(XML_ATT_TYPE)) continue;
                    if (n == 1 || !this.isContainPair((ArrayList<Pair<String, String>>)object3, string5, (String)object4)) {
                        ((ArrayList)object3).add(new Pair((Object)string5, object4));
                    }
                    if (fitStatistics == null) continue;
                    fitStatistics.addOneParamAndValue(string5, (String)object4);
                }
                continue;
            }
            if (string3.equals(XML_ELE_CATEGORY)) {
                object6 = (Element)node2;
                String string6 = object6.getAttribute("value");
                object5 = new Vector();
                Vector<Double> vector = this.handleProbabilityEle((Element)object6, (Vector<String>)object5);
                for (int j = 0; j < vector.size(); ++j) {
                    ((ArrayList)object3).add(new Pair((Object)string6, ((Vector)object5).get(j)));
                    if (fitStatistics == null) continue;
                    fitStatistics.addOneParamAndValue(string6, (String)((Vector)object5).get(j));
                }
                simulatedField.addOneCatAndProbs(string6, vector);
                continue;
            }
            if (!string3.equals(XML_ELE_INTERVAL)) continue;
            object6 = (Element)node2;
            double d = this.getDoubleValue(object6.getAttribute(XML_ATT_MIN));
            double d2 = this.getDoubleValue(object6.getAttribute(XML_ATT_MAX));
            ((ArrayList)object3).add(new Pair((Object)XML_ATT_MIN, (Object)object6.getAttribute(XML_ATT_MIN)));
            ((ArrayList)object3).add(new Pair((Object)XML_ATT_MAX, (Object)object6.getAttribute(XML_ATT_MAX)));
            if (fitStatistics != null) {
                fitStatistics.addOneParamAndValue(XML_ATT_MIN, object6.getAttribute(XML_ATT_MIN));
                fitStatistics.addOneParamAndValue("XML_ATT_MAX", object6.getAttribute(XML_ATT_MAX));
            }
            object4 = new Vector();
            Vector<Double> vector = this.handleProbabilityEle((Element)object6, (Vector<String>)object4);
            for (int j = 0; j < vector.size(); ++j) {
                ((ArrayList)object3).add(new Pair((Object)"prob", ((Vector)object4).get(j)));
                if (fitStatistics == null) continue;
                fitStatistics.addOneParamAndValue("prob", (String)((Vector)object4).get(j));
            }
            simulatedField.addOnePairRangeMinMax((Pair<Double, Double>)new Pair((Object)d, (Object)d2), vector);
        }
        if (distributionType == SimulationHelper.DistributionType.NEGBIN) {
            distributionType = simulatedField.getDistributionType();
        }
        if (!bl4 || bl4 && bl) {
            if (bl4 && distributionType == SimulationHelper.DistributionType.MULTINOMIAL && simulatedField.getCatsCount() > 0) {
                this.checkMismachCats(simulatedField, (ArrayList<Pair<String, String>>)object3);
            } else {
                simulatedField.addParameter(distributionType, (ArrayList<Pair<String, String>>)object3, false);
            }
            if (!bl4 && distributionType == SimulationHelper.DistributionType.MULTINOMIAL && this.mIsCrossTabUsed && this.mCrossFactorNames.contains(simulatedField.getName())) {
                simulatedField.copyCatsAndProbs((ArrayList<Pair<String, String>>)object3);
            }
        }
        if (fitStatistics != null) {
            if (!bl2) {
                simulatedField.addOneFitStats(fitStatistics);
            } else {
                simulatedField.addOneFitStatsForFitDetails(fitStatistics);
            }
        }
        return bl3;
    }

    private void checkMismachCats(SimulatedField simulatedField, ArrayList<Pair<String, String>> arrayList) {
        int n;
        Object object;
        int n2;
        Vector<String> vector = simulatedField.getCatsFromModel();
        Vector<Double> vector2 = new Vector<Double>();
        Vector<String> vector3 = new Vector<String>();
        double d = 0.0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = vector.get(n2);
            double d2 = this.getProbValueForCat((String)object, arrayList);
            d += d2;
            vector2.add(d2);
        }
        n2 = 0;
        if (Math.abs(d - 100.0) > SimulationHelper.sProbTolerance) {
            n2 = 1;
        }
        if (n2 == 0) {
            simulatedField.addParameter(SimulationHelper.DistributionType.MULTINOMIAL, arrayList, false);
            return;
        }
        object = new ArrayList();
        for (n = 0; n < vector2.size(); ++n) {
            double d3 = (Double)vector2.get(n);
            if (d3 > 0.0) {
                d3 /= d;
            }
            Pair pair = new Pair((Object)vector.get(n), (Object)Double.toString(d3));
            ((ArrayList)object).add(n, pair);
        }
        simulatedField.addParameter(SimulationHelper.DistributionType.MULTINOMIAL, (ArrayList<Pair<String, String>>)object, false);
        for (n = 0; n < arrayList.size(); ++n) {
            Pair<String, String> pair = arrayList.get(n);
            if (vector.contains(pair.getFirst())) continue;
            vector3.add((String)pair.getFirst());
        }
        simulatedField.setTotalZero(d == 0.0);
        simulatedField.setMisMatchCats(vector3);
    }

    private double getProbValueForCat(String string, ArrayList<Pair<String, String>> arrayList) {
        double d = 0.0;
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((String)arrayList.get(i).getFirst()).equalsIgnoreCase(string)) continue;
                d = Double.parseDouble((String)arrayList.get(i).getSecond());
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    private boolean isContainPair(ArrayList<Pair<String, String>> arrayList, String string, String string2) {
        if (arrayList == null || string == null || string2 == null || arrayList.size() == 0) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Pair<String, String> pair = arrayList.get(i);
            if (!string.equals(pair.getFirst()) || !string2.equals(pair.getSecond())) continue;
            return true;
        }
        return false;
    }

    private Vector<Double> handleProbabilityEle(Element element, Vector<String> vector) {
        Vector<Double> vector2 = new Vector<Double>();
        NodeList nodeList = element.getElementsByTagName(XML_ELE_PROBABILITY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            vector.add(i, element2.getAttribute("value"));
            vector2.add(i, this.getDoubleValue(element2.getAttribute("value")));
        }
        return vector2;
    }

    private Vector<String> getProbStrings(Element element) {
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = element.getElementsByTagName(XML_ELE_PROBABILITY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            vector.add(i, element2.getAttribute("value"));
        }
        return vector;
    }

    private double getDoubleValue(String string) {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.MAX_VALUE;
        }
        return d;
    }

    private SimulatedField findFieldFrom(String string, ArrayList<SimulatedField> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            SimulatedField simulatedField = arrayList.get(i);
            if (!string.equals(simulatedField.getName())) continue;
            return simulatedField;
        }
        return null;
    }

    private Node HandleSimChildNodes(NodeList nodeList, SimulatedField simulatedField) {
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (node2.getNodeType() != 1 || sDistNameAndType.get(string) == null && sFitDistNameAndType.get(string) == null) continue;
            return node2;
        }
        return node;
    }

    public static MeasurementLevel getMLevel(String string) {
        if (string.equals(XML_VAL_ML_CATE)) {
            return MeasurementLevel.nominal;
        }
        if (string.equals(XML_VAL_ML_ORDINAL)) {
            return MeasurementLevel.ordinal;
        }
        if (string.equals(XML_VAL_ML_SCALE)) {
            return MeasurementLevel.scale;
        }
        return MeasurementLevel.unknown;
    }

    private boolean handleFixedFields(NodeList nodeList) {
        boolean bl = true;
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(XML_ELE_FIXED_FIELD);
        for (int i = 0; i < nodeList2.getLength() && bl; ++i) {
            NodeList nodeList3;
            Element element2 = (Element)nodeList2.item(i);
            String string = element2.getAttribute(XML_ATT_NAME);
            SimulatedField simulatedField = new SimulatedField(string);
            simulatedField.setDistributionType(SimulationHelper.DistributionType.FIXED);
            simulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
            string = element2.getAttribute(XML_ATT_VALUETYPE);
            if (string.equals("double")) {
                simulatedField.setType((short)0);
                simulatedField.setMeasurementLevel(MeasurementLevel.scale);
            } else if (string.equals("string")) {
                simulatedField.setType((short)1);
                simulatedField.setMeasurementLevel(MeasurementLevel.nominal);
            } else {
                return false;
            }
            String string2 = element2.getAttribute(XML_ATT_LOCKED);
            simulatedField.setLock(string2.equals("yes"));
            String string3 = element2.getAttribute(XML_ATT_OUTFORMAT);
            if (string3 != null && string3.length() > 0) {
                simulatedField.setOutputFormat(string3);
                this.processFormat(simulatedField, null, string3);
            }
            if ((nodeList3 = element2.getChildNodes()) == null) {
                bl = false;
                continue;
            }
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Node node = nodeList3.item(j);
                if (node.getNodeType() != 1) continue;
                string = node.getNodeName();
                if (!(string.equals(XML_ELE_ASSO_TARGET) || string.equals(XML_ELE_VALUE) || string.equals(XML_ELE_VALUELABELS))) {
                    bl = false;
                    continue;
                }
                if (string.equals(XML_ELE_ASSO_TARGET)) {
                    simulatedField.addRelatedModelName(((Element)node).getAttribute(XML_ATT_NAME));
                    continue;
                }
                if (!string.equals(XML_ELE_VALUE)) continue;
                arrayList.add((Pair<String, String>)new Pair((Object)"value", (Object)((Element)node).getAttribute("value")));
            }
            simulatedField.addParameter(SimulationHelper.DistributionType.FIXED, arrayList);
            NodeList nodeList4 = element2.getElementsByTagName(XML_ELE_VALUELABELS);
            if (bl && nodeList4 != null && nodeList4.getLength() == 1) {
                this.processValueLabels(simulatedField, nodeList4);
            }
            this.mSimulatedPredictors.add(simulatedField);
        }
        return bl;
    }

    private boolean handleCorrelations(NodeList nodeList) {
        boolean bl = true;
        Element element = (Element)nodeList.item(0);
        int n = Integer.parseInt(element.getAttribute(XML_ATT_NUM_CELLS));
        String string = element.getAttribute(XML_ATT_LOCKED);
        this.setCorrLocked(string.equals("yes"));
        NodeList nodeList2 = element.getChildNodes();
        this.mCorrelations = new ArrayList();
        for (int i = 0; i < nodeList2.getLength() && bl; ++i) {
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1) continue;
            if (!node.getNodeName().equals(XML_ELE_CORRCELL)) {
                bl = false;
                continue;
            }
            String string2 = ((Element)node).getAttribute(XML_ATT_ROWVAR);
            String string3 = ((Element)node).getAttribute(XML_ATT_COLVAR);
            String string4 = ((Element)node).getAttribute("value");
            if (string2.length() == 0 || string3.length() == 0 || string4.length() == 0) {
                bl = false;
                continue;
            }
            double d = this.getDoubleValue(string4);
            if (d < -1.0 || d > 1.0) {
                if (string4.equalsIgnoreCase(".")) {
                    d = -1.7976931348623157E308;
                } else {
                    bl = false;
                    continue;
                }
            }
            CorrelationEntry correlationEntry = new CorrelationEntry(string2, string3, d);
            if (!string2.equals(string3)) {
                if (!this.isContainsEntry(string2, string3)) {
                    this.mCorrelations.add(correlationEntry);
                }
                if (this.isContainsEntry(string3, string2)) continue;
                CorrelationEntry correlationEntry2 = new CorrelationEntry(string3, string2, d);
                this.mCorrelations.add(correlationEntry2);
                continue;
            }
            this.mCorrelations.add(correlationEntry);
        }
        if (this.mCorrelations.size() == 1) {
            this.mCorrelations.clear();
        }
        return bl;
    }

    private boolean isContainsEntry(String string, String string2) {
        boolean bl = false;
        for (int i = 0; i < this.mCorrelations.size(); ++i) {
            CorrelationEntry correlationEntry = this.mCorrelations.get(i);
            if (!correlationEntry.getRowFiledName().equals(string) || !correlationEntry.getColFieldName().equals(string2)) continue;
            return true;
        }
        return bl;
    }

    private boolean handleSettings(NodeList nodeList) {
        boolean bl = true;
        Element element = (Element)nodeList.item(0);
        String string = element.getAttribute(XML_ATT_SAMPLES);
        if (string.length() > 0) {
            this.mNumOfSamples = Integer.parseInt(string);
        }
        int n = 0;
        string = element.getAttribute(XML_ATT_NUMCRITERIA);
        if (string.length() > 0) {
            n = Integer.parseInt(string);
        }
        NodeList nodeList2 = element.getChildNodes();
        this.mCriterias = new ArrayList();
        for (int i = 0; i < nodeList2.getLength() && bl; ++i) {
            Element element2;
            NodeList nodeList3;
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1) continue;
            if (!node.getNodeName().equals(XML_ELE_CRITERIA)) {
                bl = false;
                continue;
            }
            String string2 = ((Element)node).getAttribute(XML_ATT_TARGET);
            String string3 = ((Element)node).getAttribute(XML_ATT_TYPE);
            if (string2.length() == 0 || string3.length() == 0) {
                bl = false;
                continue;
            }
            SamplingCriteria samplingCriteria = new SamplingCriteria(string2);
            if (string3.equals(CRETERIA_TYPE_POINT_VALUE)) {
                samplingCriteria.setCriteriaType(MonteCarloSimulationDlg.CriteriaType.point_value);
            } else if (string3.equals(CRETERIA_TYPE_TAIL)) {
                samplingCriteria.setCriteriaType(MonteCarloSimulationDlg.CriteriaType.tail);
            } else {
                bl = false;
                continue;
            }
            if (string3.equals(CRETERIA_TYPE_POINT_VALUE)) {
                nodeList3 = ((Element)node).getElementsByTagName(XML_ELE_POINT_VALUE);
                if (nodeList3.getLength() != 1) {
                    bl = false;
                    continue;
                }
                element2 = (Element)nodeList3.item(0);
                string2 = element2.getAttribute(XML_ATT_PARAM);
                string3 = element2.getAttribute(XML_ATT_THRESHHOLD);
                String string4 = element2.getAttribute(XML_ATT_UNIT);
                if (string2.length() == 0 || string3.length() == 0 || string4.length() == 0) {
                    bl = false;
                    continue;
                }
                if (string4.equals("value")) {
                    samplingCriteria.setCriteriaUnit(MonteCarloSimulationDlg.CriteriaUnit.value);
                } else if (string4.equals(CRETERIA_UNIT_PERCENT)) {
                    samplingCriteria.setCriteriaUnit(MonteCarloSimulationDlg.CriteriaUnit.percent);
                } else {
                    bl = false;
                    continue;
                }
                samplingCriteria.setParameterName(string2);
                samplingCriteria.setThreshHold(this.getDoubleValue(string3));
                string4 = element2.getAttribute(XML_ATT_CONFLEVEL);
                if (string4.length() > 0) {
                    double d = Double.parseDouble(string4);
                    if (d < 0.0 || d > 100.0) {
                        bl = false;
                        continue;
                    }
                    samplingCriteria.setConfidenceLevel(d);
                }
            } else {
                String string5;
                nodeList3 = ((Element)node).getElementsByTagName(XML_ELE_TAIL);
                if (nodeList3.getLength() != 1) {
                    bl = false;
                    continue;
                }
                element2 = (Element)nodeList3.item(0);
                string3 = element2.getAttribute(XML_ATT_TYPE);
                if (string3.length() > 0) {
                    if (string3.equals("value")) {
                        samplingCriteria.setCriteriaUnit(MonteCarloSimulationDlg.CriteriaUnit.value);
                    } else if (string3.equals(CRETERIA_UNIT_TAIL_PERCENTILE)) {
                        samplingCriteria.setCriteriaUnit(MonteCarloSimulationDlg.CriteriaUnit.percent);
                    } else {
                        bl = false;
                        continue;
                    }
                }
                if ((string5 = element2.getAttribute(XML_ATT_SIDE)).length() > 0) {
                    samplingCriteria.setTailSide(string5);
                }
                samplingCriteria.setThreshHold(this.getDoubleValue(element2.getAttribute(XML_ATT_THRESHHOLD)));
                String string6 = element2.getAttribute(XML_ATT_FREQ);
                if (string6.length() > 0) {
                    samplingCriteria.setTailFrequency(Integer.parseInt(string6));
                }
            }
            this.mCriterias.add(samplingCriteria);
        }
        if (this.mCriterias.size() != n) {
            bl = false;
        }
        return bl;
    }

    private boolean handleTargetList(NodeList nodeList, int n) {
        boolean bl = true;
        this.mTargetList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            String string;
            String string2;
            Element element = (Element)nodeList.item(i);
            String string3 = element.getAttribute(XML_ATT_NAME);
            if (string3 == null || string3.length() == 0) {
                return false;
            }
            TargetField targetField = new TargetField(string3);
            String string4 = element.getAttribute(XML_ATT_MAPPEDNAME);
            if (string4.length() > 0) {
                targetField.setMappedName(string4);
            }
            if ((string2 = element.getAttribute(XML_ATT_ML)).length() > 0) {
                targetField.setMLevel(SimulationPlanHandler.getMLevel(string2));
            }
            targetField.setExcludeFromOutput((string = element.getAttribute(XML_ATT_EXCLUD)).equals("yes"));
            NodeList nodeList2 = element.getElementsByTagName(XML_ELE_TARGET_FILTER);
            if (nodeList2 != null && nodeList2.getLength() == 1) {
                targetField.setHasFilter(true);
                object2 = (Element)nodeList2.item(0);
                String string5 = object2.getAttribute(XML_ATT_LOW);
                if (string5.length() > 0) {
                    targetField.setLowValue(this.getDoubleValue(string5));
                    object = object2.getAttribute(XML_ATT_FILTER_INCLUDE_LOW);
                    if (((String)object).length() > 0 && ((String)object).equalsIgnoreCase("no")) {
                        targetField.setIncludeLow(false);
                    }
                }
                if ((string5 = object2.getAttribute(XML_ATT_HIGH)).length() > 0) {
                    targetField.setHighValue(this.getDoubleValue(string5));
                    object = object2.getAttribute(XML_ATT_FILTER_INCLUDE_HIGH);
                    if (((String)object).length() > 0 && ((String)object).equalsIgnoreCase("no")) {
                        targetField.setIncludeHigh(false);
                    }
                }
            }
            if ((object2 = element.getElementsByTagName(XML_ELE_COMMENT)).getLength() == 1) {
                object = object2.item(0).getFirstChild();
                if (object == null) {
                    return false;
                }
                targetField.setComment(object.getNodeValue());
            }
            if ((string = element.getAttribute(XML_ATT_OUTFORMAT)) != null && string.length() > 0) {
                targetField.setOutputFormat(string);
                this.processFormat(null, targetField, string);
            }
            this.mTargetList.add(i, targetField);
        }
        return bl;
    }

    private void handleCrossFactors(NodeList nodeList) {
        NodeList nodeList2;
        Element element = (Element)nodeList.item(0);
        NodeList nodeList3 = element.getElementsByTagName(XML_ELE_CROSS_FACTORS);
        if (nodeList3 != null && nodeList3.getLength() > 0 && (nodeList2 = element.getElementsByTagName(XML_ELE_FACTOR)) != null) {
            this.mCrossFactorNames.clear();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2 = (Element)nodeList2.item(i);
                String string = element2.getAttribute(XML_ATT_NAME);
                this.mCrossFactorNames.add(i, string);
            }
        }
    }

    public boolean isCorrLocked() {
        return this.mIsCorrLocked;
    }

    public void setCorrLocked(boolean bl) {
        this.mIsCorrLocked = bl;
    }

    public String getPlanTimeStamp() {
        return this.mTimeStamp;
    }

    public Vector<String> getCrossFactorNames() {
        return this.mCrossFactorNames;
    }

    public boolean isCrossTabUsed() {
        return this.mIsCrossTabUsed;
    }

    private static void setupDistMap() {
        sDistNameAndType.put(XML_ELE_DISTBETA, SimulationHelper.DistributionType.BETA);
        sDistNameAndType.put(XML_ELE_DISTBIO, SimulationHelper.DistributionType.BINOMIAL);
        sDistNameAndType.put(XML_ELE_DISTCATE, SimulationHelper.DistributionType.MULTINOMIAL);
        sDistNameAndType.put(XML_ELE_DISTEMP, SimulationHelper.DistributionType.EMPIRICAL);
        sDistNameAndType.put(XML_ELE_DISTEXP, SimulationHelper.DistributionType.EXPONENTIAL);
        sDistNameAndType.put(XML_ELE_DISTGAMMA, SimulationHelper.DistributionType.GAMMA);
        sDistNameAndType.put(XML_ELE_DISTLOG, SimulationHelper.DistributionType.LOGNORMAL);
        sDistNameAndType.put(XML_ELE_DISTNEGBIN, SimulationHelper.DistributionType.NEGBIN);
        sDistNameAndType.put(XML_ELE_DISTNORM, SimulationHelper.DistributionType.NORMAL);
        sDistNameAndType.put(XML_ELE_DISTPOISSON, SimulationHelper.DistributionType.POISSON);
        sDistNameAndType.put(XML_ELE_DISTTRI, SimulationHelper.DistributionType.TRIANGULAR);
        sDistNameAndType.put(XML_ELE_DISTUNIFORM, SimulationHelper.DistributionType.UNIFORM);
        sDistNameAndType.put(XML_ELE_DISTRANGE, SimulationHelper.DistributionType.RANGE);
        sDistNameAndType.put(XML_ELE_DISTWEIBULL, SimulationHelper.DistributionType.WEIBULL);
        sDistNameAndType.put(XML_ELE_BERNOULLI, SimulationHelper.DistributionType.BERNOULLI);
    }

    private static void setupFitDistMap() {
        sFitDistNameAndType.put(XML_VALUE_DIST_BETA, SimulationHelper.DistributionType.BETA);
        sFitDistNameAndType.put(XML_VALUE_DIST_BINOMIAL, SimulationHelper.DistributionType.BINOMIAL);
        sFitDistNameAndType.put(XML_VALUE_DIST_CATEGORICAL, SimulationHelper.DistributionType.MULTINOMIAL);
        sFitDistNameAndType.put(XML_VALUE_DIST_EMPIRICAL, SimulationHelper.DistributionType.EMPIRICAL);
        sFitDistNameAndType.put(XML_VALUE_DIST_EXPONENTIAL, SimulationHelper.DistributionType.EXPONENTIAL);
        sFitDistNameAndType.put(XML_VALUE_DIST_GAMMA, SimulationHelper.DistributionType.GAMMA);
        sFitDistNameAndType.put(XML_VALUE_DIST_LOGNORMAL, SimulationHelper.DistributionType.LOGNORMAL);
        sFitDistNameAndType.put(XML_VALUE_DIST_NEGBIN, SimulationHelper.DistributionType.NEGBIN);
        sFitDistNameAndType.put(XML_VALUE_DIST_NORMAL, SimulationHelper.DistributionType.NORMAL);
        sFitDistNameAndType.put(XML_VALUE_DIST_POISSON, SimulationHelper.DistributionType.POISSON);
        sFitDistNameAndType.put(XML_VALUE_DIST_TRIANGULAR, SimulationHelper.DistributionType.TRIANGULAR);
        sFitDistNameAndType.put(XML_VALUE_DIST_UNIFORM, SimulationHelper.DistributionType.UNIFORM);
        sFitDistNameAndType.put(XML_VALUE_DIST_USERRANGES, SimulationHelper.DistributionType.RANGE);
        sFitDistNameAndType.put(XML_VALUE_DIST_WEIBULL, SimulationHelper.DistributionType.WEIBULL);
        sFitDistNameAndType.put(XML_VALUE_DIST_BERNOULLI, SimulationHelper.DistributionType.BERNOULLI);
    }

    public class ModelFile {
        private ArrayList<TargetField> mTargetList;
        private String mFileName;
        private boolean mIsCustomModel;

        public ModelFile(String string, boolean bl) {
            this.mFileName = string;
            this.mIsCustomModel = bl;
            this.mTargetList = new ArrayList();
        }

        public void addOneTargetField(TargetField targetField) {
            this.mTargetList.add(this.mTargetList.size(), targetField);
        }

        public void setTargetList(ArrayList<TargetField> arrayList) {
            this.mTargetList = arrayList;
        }

        public ArrayList<TargetField> getMTargetList() {
            return this.mTargetList;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public boolean isIsCustomModel() {
            return this.mIsCustomModel;
        }
    }

    public class TargetField {
        private String mName;
        private boolean mIncludeLow = true;
        private boolean mIncludeHigh = true;
        private double mHigh;
        private double mLow;
        private String mComment;
        private String mMappedName;
        private boolean mExcludeFromOutput;
        private String mOutputFormat;
        private int mFormatIndex = 0;
        private int mDecimalDigits = 2;
        private boolean mHasFilter;
        private MeasurementLevel mMLevel;

        public TargetField(String string) {
            this.mName = string;
            this.mIncludeLow = true;
            this.mIncludeHigh = true;
            this.mHigh = Double.POSITIVE_INFINITY;
            this.mLow = Double.NEGATIVE_INFINITY;
            this.mComment = "";
            this.mExcludeFromOutput = false;
            this.mMappedName = "";
            this.mOutputFormat = "";
            this.mHasFilter = false;
            this.mMLevel = MeasurementLevel.unknown;
        }

        public String getName() {
            return this.mName;
        }

        public void setHasFilter(boolean bl) {
            this.mHasFilter = bl;
        }

        public boolean hasFilter() {
            return this.mHasFilter;
        }

        public void setIncludeLow(boolean bl) {
            this.mIncludeLow = bl;
        }

        public boolean isLowInclude() {
            return this.mIncludeLow;
        }

        public void setIncludeHigh(boolean bl) {
            this.mIncludeHigh = bl;
        }

        public boolean isHighInclude() {
            return this.mIncludeHigh;
        }

        public void setHighValue(double d) {
            this.mHigh = d;
        }

        public void setLowValue(double d) {
            this.mLow = d;
        }

        public double getHighValue() {
            return this.mHigh;
        }

        public double getLowValue() {
            return this.mLow;
        }

        public String getComment() {
            return this.mComment;
        }

        public void setComment(String string) {
            this.mComment = string;
        }

        public String getMappedName() {
            return this.mMappedName;
        }

        public void setMappedName(String string) {
            this.mMappedName = string;
        }

        public boolean isExcludeFromOutput() {
            return this.mExcludeFromOutput;
        }

        public void setExcludeFromOutput(boolean bl) {
            this.mExcludeFromOutput = bl;
        }

        public String getOutputFormat() {
            return this.mOutputFormat;
        }

        public void setOutputFormat(String string) {
            this.mOutputFormat = string;
        }

        public int getFormatIndex() {
            return this.mFormatIndex;
        }

        public void setFormatIndex(int n, int n2) {
            this.mFormatIndex = n;
            this.mDecimalDigits = n2;
        }

        public int getNumDecimals() {
            return this.mDecimalDigits;
        }

        public void setMLevel(MeasurementLevel measurementLevel) {
            this.mMLevel = measurementLevel;
        }

        public MeasurementLevel getMLevel() {
            return this.mMLevel;
        }
    }

    public class SamplingCriteria {
        private String mTargetName;
        private MonteCarloSimulationDlg.CriteriaType mType = null;
        private MonteCarloSimulationDlg.CriteriaUnit mUnit = null;
        private String mParameterName;
        private double mThreshold;
        private double mConfLevel = -1.0;
        private int mMaxSamples;
        private int mTailFrequency = -1;
        private String mTailSide = "left";

        public SamplingCriteria(String string) {
            this.mTargetName = string;
            this.mMaxSamples = -1;
            this.mConfLevel = 95.0;
            this.mTailFrequency = 10;
        }

        public String getTargetName() {
            return this.mTargetName;
        }

        public void setCriteriaType(MonteCarloSimulationDlg.CriteriaType criteriaType) {
            this.mType = criteriaType;
        }

        public MonteCarloSimulationDlg.CriteriaType getCriteriaType() {
            return this.mType;
        }

        public void setCriteriaUnit(MonteCarloSimulationDlg.CriteriaUnit criteriaUnit) {
            this.mUnit = criteriaUnit;
        }

        public MonteCarloSimulationDlg.CriteriaUnit getCriteriaUnit() {
            return this.mUnit;
        }

        public void setMaxSamples(int n) {
            this.mMaxSamples = n;
        }

        public int getMaxSamples() {
            return this.mMaxSamples;
        }

        public void setThreshHold(double d) {
            this.mThreshold = d;
        }

        public double getThreshold() {
            return this.mThreshold;
        }

        public void setConfidenceLevel(double d) {
            this.mConfLevel = d;
        }

        public double getConfLevel() {
            return this.mConfLevel;
        }

        public void setParameterName(String string) {
            this.mParameterName = string;
        }

        public String getParameterName() {
            return this.mParameterName;
        }

        public int getTailFrequency() {
            return this.mTailFrequency;
        }

        public void setTailFrequency(int n) {
            this.mTailFrequency = n;
        }

        public String getTailSide() {
            return this.mTailSide;
        }

        public void setTailSide(String string) {
            this.mTailSide = string;
        }
    }
}

