/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.xml.DOMFactory;
import com.spss.java_client.core.xml.SchemaType;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.MC.BaseMCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.CorrelationEntry;
import com.spss.java_client.ui.dialogs.MC.DistributionImageUtil;
import com.spss.java_client.ui.dialogs.MC.FitStatistics;
import com.spss.java_client.ui.dialogs.MC.MCSimpleSimulationModelDlg;
import com.spss.java_client.ui.dialogs.MC.MCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulatedFieldTable;
import com.spss.java_client.ui.dialogs.MC.SimulatedFieldTableModel;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.MC.res.MCResBundle;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SimulationHelper {
    public static final String STATIC_COLUMN_KEY = "COL_KEY";
    private static final String PLAN_ROOT_NAME = "SimulationPlan";
    private static final String PMML_ROOT = "PMML";
    private static final String TEMP_TRANSFORMATION_XML_NAME = "SIMPREP_transformation.xml";
    public static final int DIST_TABLE_WIDTH = 160;
    public static final int IMAGE_WIDTH = 120;
    public static final int IMAGE_HEIGHT = 100;
    public static Hashtable<DistributionType, String> sDistributionHelp = null;
    static String[] sFieldOutputFormat = null;
    static double sProbTolerance = 0.001;

    public static String getDistributionName(DistributionType distributionType) {
        String string = "";
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        string = distributionType == DistributionType.NORMAL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL") : (distributionType == DistributionType.BINOMIAL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL") : (distributionType == DistributionType.NEGBIN ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN") : (distributionType == DistributionType.NEGBIN_TRIAL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN_TRIAL") : (distributionType == DistributionType.MULTINOMIAL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL") : (distributionType == DistributionType.EMPIRICAL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL") : (distributionType == DistributionType.POISSON ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON") : (distributionType == DistributionType.LOGNORMAL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL") : (distributionType == DistributionType.TRIANGULAR ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR") : (distributionType == DistributionType.UNIFORM ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM") : (distributionType == DistributionType.GAMMA ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA") : (distributionType == DistributionType.WEIBULL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL") : (distributionType == DistributionType.BETA ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA") : (distributionType == DistributionType.EXPONENTIAL ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL") : (distributionType == DistributionType.RANGE ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_RANGE") : (distributionType == DistributionType.BERNOULLI ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI") : (distributionType == DistributionType.FIXED ? resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_FIXED") : resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NONE")))))))))))))))));
        return string;
    }

    public static String getMLevelString(MeasurementLevel measurementLevel) {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (measurementLevel == MeasurementLevel.scale) {
            return resourceBundle.getString("IMS_MC_MLEVEL_CONTINOUS");
        }
        return measurementLevel.toString();
    }

    public static boolean isMinMaxSupported(DistributionType distributionType) {
        return distributionType == DistributionType.NORMAL || distributionType == DistributionType.LOGNORMAL || distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL || distributionType == DistributionType.POISSON || distributionType == DistributionType.GAMMA || distributionType == DistributionType.BETA || distributionType == DistributionType.BINOMIAL || distributionType == DistributionType.EXPONENTIAL || distributionType == DistributionType.WEIBULL;
    }

    public static String generateSimCREATESyntax(DialogDataModel dialogDataModel, boolean bl, boolean bl2) {
        SimulationPlanHandler.ModelFile modelFile;
        ArrayList<SimulationPlanHandler.TargetField> arrayList;
        String string;
        Boolean bl3;
        SimulationPlanHandler simulationPlanHandler = (SimulationPlanHandler)dialogDataModel.getObject("SimulationPlanHandler");
        ArrayList<SimulationPlanHandler.ModelFile> arrayList2 = null;
        if (simulationPlanHandler != null) {
            arrayList2 = simulationPlanHandler.getModelFiles();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n*Create simulation plan.");
        String string2 = SimulationHelper.getPlanPathFromUser(dialogDataModel, bl);
        String string3 = "";
        if (string2.length() > 0) {
            string3 = dialogDataModel.getString(MonteCarloSimulationDlg.FILE_HANDLE_KEY);
            stringBuffer.append("\nFILE HANDLE " + string3);
            stringBuffer.append(" /NAME='" + string2 + "'.");
        }
        stringBuffer.append("\nSIMPLAN CREATE");
        String string4 = dialogDataModel.getString("SimulationPlanPath");
        boolean bl4 = false;
        if (simulationPlanHandler != null && simulationPlanHandler.isCrossTabUsed() && string4 != null) {
            stringBuffer.append(" SOURCE='");
            stringBuffer.append(string4);
            stringBuffer.append("'");
            bl4 = true;
        }
        Boolean bl5 = dialogDataModel.getBoolean("IDS_MC_MODEL_CREATE_DATA_BUTTON");
        String string5 = dialogDataModel.getString("SimulationModelPMMLPath");
        if (string5 == null || string5.length() == 0) {
            boolean bl6;
            string5 = string4;
            if (string5 == null || string5.length() == 0) {
                string5 = dialogDataModel.getString("IDS_MC_MODEL_NEW_MODEL_PMML_FILE_PATH");
                if (!(string5 != null && string5.length() != 0 || bl5 != null && bl5.booleanValue())) {
                    string5 = SimulationHelper.getTransFileNamePath();
                }
            } else if (!bl && (simulationPlanHandler = (SimulationPlanHandler)dialogDataModel.getObject("SimulationPlanHandler")) != null && simulationPlanHandler.getModelFiles() != null && simulationPlanHandler.getModelFiles().size() > 0 && (bl6 = simulationPlanHandler.getModelFiles().get(0).isIsCustomModel())) {
                string5 = SimulationHelper.getTransFileNamePath();
            }
        }
        String string6 = "";
        boolean bl7 = true;
        if (bl) {
            if (arrayList2 == null || arrayList2.size() == 0) {
                bl7 = false;
            }
        } else if (bl5 != null && bl5.booleanValue()) {
            bl7 = false;
        }
        if (string5 != null && string5.length() > 0 && bl7) {
            stringBuffer.append("\n /MODEL FILE='");
            stringBuffer.append(string5 + "'");
            bl3 = dialogDataModel.getBoolean("IDS_MC_MODEL_ENTER_EQUATION_BUTTON");
            stringBuffer.append("  CUSTOM=");
            string6 = "No";
            if (bl3 != null && bl3.booleanValue()) {
                string6 = "YES";
            } else if (bl && arrayList2 != null && arrayList2.size() > 0) {
                string6 = arrayList2.get(0).isIsCustomModel() ? "YES" : "NO";
            }
            stringBuffer.append(string6);
        }
        bl3 = dialogDataModel.getBoolean("IDS_MC_CORRELATION_CORR_CROSSTAB_CHECK");
        stringBuffer.append("\n /CONTINGENCY MULTIWAY=");
        string6 = "NO";
        if (bl3 != null && bl3.booleanValue()) {
            string6 = "YES";
        }
        stringBuffer.append(string6);
        JTable jTable = (JTable)dialogDataModel.getObject("IDS_MC_SIMALATION_FORMAT");
        Object object = dialogDataModel.getObject("IDS_MC_MODEL_TAB_EQUATION_COMMENT_KEY");
        Object object2 = dialogDataModel.getObject("IDS_MC_MODEL_TAB_EQUATION_TARGET_KEY");
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        if (object != null) {
            hashtable = (Hashtable)object;
        }
        if (object2 != null) {
            hashtable2 = (Hashtable)object2;
        }
        if (!bl) {
            String string7 = dialogDataModel.getString("IDS_MC_MODEL_NEW_MODEL_PMML_FILE_TYPE");
            if (string7 == null || !string7.equals("CLUSTER_KMEANS") && !string7.equals("CLUSTER_TWOSTEP")) {
                Object[] objectArray = dialogDataModel.getArray("IDS_MC_SIMALATION_TARGET_NAMES");
                int n = 0;
                for (n = 0; n < jTable.getRowCount(); ++n) {
                    Object v;
                    Object v2;
                    String string8 = jTable.getValueAt(n, 0).toString();
                    String string9 = jTable.getValueAt(n, 1).toString();
                    String string10 = jTable.getValueAt(n, 2).toString();
                    if (!SimulationHelper.isContain(objectArray, string8)) continue;
                    stringBuffer.append("\n /TARGETOPTS ");
                    stringBuffer.append(" TARGET= ");
                    stringBuffer.append(string8 + "(FORMAT=");
                    stringBuffer.append(SimulationHelper.getSyntaxForOutputFormat(string9) + "," + string10);
                    stringBuffer.append(")");
                    if (hashtable != null && (v2 = hashtable.get(string8)) != null && v2.toString().length() > 0) {
                        stringBuffer.append(" COMMENT=");
                        stringBuffer.append(CharacterUtil.smartQuote((String)v2.toString()).replace("\n", " \\n "));
                    }
                    boolean bl8 = true;
                    if (hashtable2 != null && (v = hashtable2.get(string8)) != null) {
                        boolean bl9 = bl8 = !((SimulatedField)((Object)v)).isExcludeFromOutput();
                    }
                    if (bl8) {
                        stringBuffer.append(" OUTPUT=YES");
                    } else {
                        stringBuffer.append(" OUTPUT=NO");
                    }
                    stringBuffer.append(SimulationHelper.getTARGETFILTERSyntax(dialogDataModel, string8));
                }
            }
        } else if (arrayList2 != null && arrayList2.size() > 0 && ((string = dialogDataModel.getString(MCSimpleSimulationModelDlg.SIMPLE_MODEL_TYPE)) == null || !string.equals("CLUSTER_KMEANS") && !string.equals("CLUSTER_TWOSTEP")) && (arrayList = (modelFile = arrayList2.get(0)).getMTargetList()) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append("\n /TARGETOPTS ");
                SimulationPlanHandler.TargetField targetField = arrayList.get(i);
                stringBuffer.append(" TARGET= " + targetField.getName());
                String string11 = targetField.getOutputFormat();
                if (string11.length() > 0) {
                    stringBuffer.append("(FORMAT=" + string11 + ") ");
                }
                if ((string11 = targetField.getComment()).length() > 0) {
                    stringBuffer.append("COMMENT=");
                    stringBuffer.append(CharacterUtil.smartQuote((String)string11).replace("\n", " \\n "));
                }
                if (targetField.isExcludeFromOutput()) {
                    stringBuffer.append(" OUTPUT=NO");
                } else {
                    stringBuffer.append(" OUTPUT=YES");
                }
                stringBuffer.append(SimulationHelper.getTARGETFILTERSyntax(dialogDataModel, targetField.getName()));
            }
        }
        if (!bl) {
            stringBuffer.append(SimulationHelper.getSimInputAndFixedInputSyntax(dialogDataModel, bl2, bl4));
        } else {
            stringBuffer.append(SimulationHelper.getSimInputAndFixedInputSyntaxForSimple(dialogDataModel, bl2, bl4));
        }
        if (!bl) {
            stringBuffer.append(SimulationHelper.getCorrelationSyntax(dialogDataModel));
        } else if (simulationPlanHandler.isCorrLocked()) {
            stringBuffer.append(SimulationHelper.getCorrelationSyntax(simulationPlanHandler));
        }
        stringBuffer.append(SimulationHelper.getAutofitSyntax(dialogDataModel, simulationPlanHandler));
        if (!bl) {
            stringBuffer.append(SimulationHelper.getStopCreteriaSyntax(dialogDataModel));
        } else {
            stringBuffer.append(SimulationHelper.getStopCreteriaSyntax(simulationPlanHandler));
        }
        stringBuffer.append(SimulationHelper.getCatMissingHandleSyntax(dialogDataModel, bl));
        if (!bl7) {
            stringBuffer.append(SimulationHelper.getValueLabels(dialogDataModel, simulationPlanHandler, bl));
        }
        stringBuffer.append(SimulationHelper.getPlanSyntax(dialogDataModel, bl, string3));
        return stringBuffer.toString();
    }

    private static String getCatMissingHandleSyntax(DialogDataModel dialogDataModel, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "IDS_MC_OPTION_CAT_INCLUDE_BUTTON";
        if (bl) {
            string = "IDS_MC_SIMPLE_MISSING_HANDLE_CHECK";
        }
        Boolean bl2 = dialogDataModel.getBoolean(string);
        stringBuffer.append("\n /MISSING CLASSMISSING=");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("INCLUDE");
        } else {
            stringBuffer.append("EXCLUDE");
        }
        return stringBuffer.toString();
    }

    private static String getTARGETFILTERSyntax(DialogDataModel dialogDataModel, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String[] stringArray = resourceBundle.getStringArray("IDS_MC_OUTPUT_LIMIT_VALUE_COMBO");
        JTable jTable = (JTable)dialogDataModel.getObject("IDS_MC_SIMULATION_TARGET_LIMIT_TABLE");
        if (jTable != null && jTable.getRowCount() > 0) {
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                if (!string.equals(jTable.getValueAt(i, 0))) continue;
                String string2 = jTable.getValueAt(i, 1).toString();
                if (string2.equals(stringArray[1])) {
                    stringBuffer.append(" TARGETFILTER =YES(MIN=").append(jTable.getValueAt(i, 2).toString());
                    stringBuffer.append("(INCLUSIVE)  MAX=HI)");
                } else if (string2.equals(stringArray[2])) {
                    stringBuffer.append(" TARGETFILTER =YES(MIN=LO MAX=");
                    stringBuffer.append(jTable.getValueAt(i, 3).toString());
                    stringBuffer.append("(INCLUSIVE) )");
                } else if (string2.equals(stringArray[3])) {
                    stringBuffer.append(" TARGETFILTER =YES(MIN=");
                    stringBuffer.append(jTable.getValueAt(i, 2).toString());
                    stringBuffer.append("(INCLUSIVE) MAX=");
                    stringBuffer.append(jTable.getValueAt(i, 3).toString());
                    stringBuffer.append("(INCLUSIVE) )");
                }
                return stringBuffer.toString();
            }
        }
        return stringBuffer.toString();
    }

    private static String getSimInputAndFixedInputSyntaxForSimple(DialogDataModel dialogDataModel, boolean bl, boolean bl2) {
        Object object = dialogDataModel.getObject(MCSimpleSimulationModelDlg.SIMULATED_LIST_MODEL);
        if (object == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        VarListModel varListModel = (VarListModel)object;
        Vector<SimulatedField> vector = new Vector<SimulatedField>();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SimulatedField simulatedField = (SimulatedField)varListModel.getElementAt(i);
            if (simulatedField.getDistributionType() == DistributionType.FIXED) {
                vector.add(vector.size(), simulatedField);
                continue;
            }
            stringBuffer.append(SimulationHelper.getSIMINPUTSyntaxForField(simulatedField, true, dialogDataModel, bl, bl2));
        }
        if (vector.size() > 0) {
            stringBuffer.append(SimulationHelper.getFIXEDSyntax(vector, true, dialogDataModel));
        }
        return stringBuffer.toString();
    }

    private static String getSimInputAndFixedInputSyntax(DialogDataModel dialogDataModel, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        SimulatedFieldTable simulatedFieldTable = (SimulatedFieldTable)dialogDataModel.getObject("IDS_MC_SIMULATION_TABLE_KEY");
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)simulatedFieldTable.getModel();
        Vector<SimulatedField> vector = new Vector<SimulatedField>();
        int n = 0;
        for (n = 0; n < simulatedFieldTable.getRowCount(); ++n) {
            SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(n);
            if (simulatedField.getDistributionType() == DistributionType.FIXED) {
                vector.add(vector.size(), simulatedField);
                continue;
            }
            stringBuffer.append(SimulationHelper.getSIMINPUTSyntaxForField(simulatedField, false, dialogDataModel, bl, bl2));
        }
        if (vector.size() > 0) {
            stringBuffer.append(SimulationHelper.getFIXEDSyntax(vector, false, dialogDataModel));
        }
        return stringBuffer.toString();
    }

    private static String getValueLabels(DialogDataModel dialogDataModel, SimulationPlanHandler simulationPlanHandler, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (bl) {
            Object object = dialogDataModel.getObject(MCSimpleSimulationModelDlg.SIMULATED_LIST_MODEL);
            if (object == null) {
                return "";
            }
            VarListModel varListModel = (VarListModel)object;
            Vector vector = new Vector();
            for (int i = 0; i < varListModel.getSize(); ++i) {
                SimulatedField simulatedField = (SimulatedField)varListModel.getElementAt(i);
                stringBuffer.append(SimulationHelper.getValueLabelSyntaxForField(simulatedField, simulationPlanHandler));
            }
        } else {
            SimulatedFieldTable simulatedFieldTable = (SimulatedFieldTable)dialogDataModel.getObject("IDS_MC_SIMULATION_TABLE_KEY");
            SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)simulatedFieldTable.getModel();
            for (int i = 0; i < simulatedFieldTable.getRowCount(); ++i) {
                SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
                stringBuffer.append(SimulationHelper.getValueLabelSyntaxForField(simulatedField, simulationPlanHandler));
            }
        }
        return stringBuffer.toString();
    }

    private static String getValueLabelSyntaxForField(SimulatedField simulatedField, SimulationPlanHandler simulationPlanHandler) {
        Set set;
        IValueLabelMap iValueLabelMap;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (simulationPlanHandler == null && iSpssDataSrc.findVarIndex(simulatedField.getName()) == -1) {
            bl = true;
        } else if (simulationPlanHandler != null) {
            if (simulationPlanHandler.isFieldFromPlan(simulatedField.getName())) {
                bl = true;
            } else if (iSpssDataSrc.findVarIndex(simulatedField.getName()) == -1) {
                bl = true;
            }
        }
        if (bl && (iValueLabelMap = simulatedField.getValueLabels()) != null && (set = iValueLabelMap.getValueLabelEntries()).size() > 0) {
            boolean bl2 = simulatedField.getFormat().getFormatType().isStringFormat() || simulatedField.getType() > 0;
            Iterator iterator = set.iterator();
            stringBuffer.append("\n /VALUELABELS VARIABLES=" + simulatedField.getName() + " VALUES=");
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (bl2) {
                    stringBuffer.append(" " + CharacterUtil.smartQuote((String)((OBS)entry.getKey()).getString()));
                } else {
                    stringBuffer.append(" " + ((OBS)entry.getKey()).getNum());
                }
                stringBuffer.append(" " + CharacterUtil.smartQuote((String)((String)entry.getValue())));
            }
        }
        return stringBuffer.toString();
    }

    private static String getSIMINPUTSyntaxForField(SimulatedField simulatedField, boolean bl, DialogDataModel dialogDataModel, boolean bl2, boolean bl3) {
        boolean bl4;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n /SIMINPUT");
        String string = simulatedField.getName();
        stringBuffer.append(" INPUT=");
        stringBuffer.append(string);
        String string2 = "";
        string2 = bl ? simulatedField.getOutputFormat() : SimulationHelper.getFormatForInput(string, dialogDataModel);
        boolean bl5 = false;
        if (string2.length() > 0) {
            stringBuffer.append("(");
            stringBuffer.append("FORMAT=" + string2);
            bl5 = true;
        }
        String string3 = simulatedField.getMappedName();
        boolean bl6 = false;
        if (string3.length() > 0 && !string.equalsIgnoreCase(string3)) {
            if (string2.length() == 0) {
                stringBuffer.append("(");
            }
            stringBuffer.append(" MAPTO=" + string3);
            bl5 = true;
            bl6 = true;
        }
        if (bl5) {
            stringBuffer.append(")");
        }
        stringBuffer.append(" OUTPUT=");
        if (simulatedField.isExcludeFromOutput()) {
            stringBuffer.append("NO");
        } else {
            stringBuffer.append("YES");
        }
        stringBuffer.append(" TYPE=");
        MonteCarloSimulationDlg.FitToState fitToState = simulatedField.getAutoFitState();
        boolean bl7 = fitToState == MonteCarloSimulationDlg.FitToState.MatchedAndFitted || fitToState == MonteCarloSimulationDlg.FitToState.DistributionFittedBefore;
        boolean bl8 = true;
        boolean bl9 = simulatedField.isLocked();
        DistributionType distributionType = simulatedField.getDistributionType();
        if (distributionType == DistributionType.EMPIRICAL) {
            String string4;
            if (bl9) {
                stringBuffer.append("MANUAL(LOCK=YES) DISTRIBUTION= ");
            } else {
                stringBuffer.append("MANUAL(LOCK=NO) DISTRIBUTION= ");
            }
            stringBuffer.append(SimulationHelper.getDistributionSyntax(distributionType));
            if (!bl3 && (string4 = dialogDataModel.getString("SimulationPlanPath")) != null && string4.length() > 0 && simulatedField.getAutoFitState() == MonteCarloSimulationDlg.FitToState.ManualDefined) {
                stringBuffer.append("(SOURCE='");
                stringBuffer.append(string4);
                stringBuffer.append("')");
            }
            return stringBuffer.toString();
        }
        if (fitToState == MonteCarloSimulationDlg.FitToState.DistributionFitChanged && !bl9 && !bl2) {
            object7 = simulatedField.getAllFitStats();
            object6 = ((FitStatistics)((ArrayList)object7).get(0)).getDistType();
            object5 = DistributionType.NONE;
            object4 = simulatedField.getAllFitStatsForFitDetails();
            if (object4 != null && ((ArrayList)object4).size() > 0) {
                object5 = ((ArrayList)object4).get(0).getDistType();
            }
            if (simulatedField.getDistributionType() == object6 || simulatedField.getDistributionType() == object5) {
                object3 = "";
                for (n = 0; n < ((ArrayList)object7).size(); ++n) {
                    object2 = (FitStatistics)((ArrayList)object7).get(n);
                    object = ((FitStatistics)object2).getDistType();
                    if (object == DistributionType.EMPIRICAL) continue;
                    object3 = (String)object3 + SimulationHelper.getDistributionSyntax(object) + " ";
                }
                if (((String)object3).length() > 0) {
                    stringBuffer.append("AUTOFIT(");
                    stringBuffer.append((String)object3);
                    stringBuffer.append(") ");
                    return stringBuffer.toString();
                }
            } else {
                bl7 = false;
            }
        }
        object7 = "";
        if (distributionType == DistributionType.MULTINOMIAL && !bl) {
            object6 = dialogDataModel.getObject("SimulationPlanHandler");
            object5 = null;
            if (object6 != null) {
                object5 = (SimulationPlanHandler)object6;
            }
            object7 = SimulationHelper.checkStatusOfCategoricalDistField(simulatedField, dialogDataModel, (SimulationPlanHandler)object5, bl2);
        }
        if (((String)object7).length() > 0) {
            stringBuffer.append((String)object7);
            return stringBuffer.toString();
        }
        if (bl7) {
            if (bl9) {
                stringBuffer.append("MANUAL(LOCK=YES SAVEASFITTED=YES)");
                bl4 = true;
            } else if (bl2) {
                stringBuffer.append("MANUAL(LOCK=NO SAVEASFITTED=YES)");
                bl4 = true;
            } else {
                stringBuffer.append("AUTOFIT");
                bl4 = false;
            }
        } else {
            if (bl9) {
                stringBuffer.append("MANUAL(LOCK=YES)");
            } else {
                stringBuffer.append("MANUAL(LOCK=NO)");
            }
            bl4 = true;
        }
        object6 = NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
        ((NumberFormat)object6).setGroupingUsed(false);
        ((NumberFormat)object6).setMaximumFractionDigits(2);
        if (bl4) {
            stringBuffer.append(" DISTRIBUTION=");
            stringBuffer.append(SimulationHelper.getDistributionSyntax(distributionType));
            if (distributionType != DistributionType.RANGE) {
                stringBuffer.append("(");
            }
            if (distributionType != DistributionType.MULTINOMIAL && distributionType != DistributionType.RANGE) {
                stringBuffer.append(SimulationHelper.getParameterValuesSyntax(distributionType, simulatedField.getParametersFor(distributionType)));
            } else if (distributionType == DistributionType.MULTINOMIAL) {
                stringBuffer.append(SimulationHelper.getCatAndProbSyntax(simulatedField));
            } else if (distributionType == DistributionType.RANGE) {
                object5 = simulatedField.getAllRangeMinMax();
                object4 = simulatedField.getAllRangeProbs();
                boolean bl10 = false;
                if (object4 != null && ((Vector)object4).size() > 0) {
                    for (n = 0; object4 != null && n < ((Vector)object4).size(); ++n) {
                        object2 = (Vector)((Vector)object4).get(n);
                        if (((Vector)object2).size() <= 1) continue;
                        bl10 = true;
                        break;
                    }
                }
                if (bl10 && object5 != null && object4 != null && ((Vector)object5).size() > 0 && ((Vector)object5).size() == ((Vector)object4).size()) {
                    n = 0;
                    object2 = "MIN=";
                    object = "MAX=";
                    String string5 = "PROBS=";
                    for (n = 0; n < ((Vector)object5).size(); ++n) {
                        Pair pair = (Pair)((Vector)object5).get(n);
                        object2 = (String)object2 + pair.getFirst() + " ";
                        object = (String)object + pair.getSecond() + " ";
                    }
                    int n2 = ((Vector)((Vector)object4).get(0)).size();
                    for (int i = 0; i < n2; ++i) {
                        for (n = 0; n < ((Vector)object4).size(); ++n) {
                            Vector vector = (Vector)((Vector)object4).get(n);
                            string5 = string5 + UIToolResUtil.removeLocale((String)((Format)object6).format(vector.get(i))) + " ";
                        }
                        if (i >= n2 - 1) continue;
                        string5 = string5 + "; ";
                    }
                    if (((String)object2).length() > 4) {
                        stringBuffer.append("USER_RANGES(" + (String)object2 + " " + (String)object + " " + string5);
                    }
                } else {
                    ArrayList<Pair<String, String>> arrayList = simulatedField.getParametersFor(distributionType);
                    object2 = "MIN=";
                    object = "MAX=";
                    String string6 = "PROBS=";
                    for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                        Pair<String, String> pair = arrayList.get(i);
                        if (pair.getSecond() == null) continue;
                        if (pair.getFirst() == "min") {
                            object2 = (String)object2 + (String)pair.getSecond() + " ";
                            continue;
                        }
                        if (pair.getFirst() == "max") {
                            object = (String)object + (String)pair.getSecond() + " ";
                            continue;
                        }
                        string6 = string6 + (String)pair.getSecond() + " ";
                    }
                    if (((String)object2).length() > 4) {
                        stringBuffer.append("USER_RANGES(" + (String)object2 + " " + (String)object + " " + string6);
                    }
                }
            }
            stringBuffer.append(")");
        } else {
            object5 = "";
            if (simulatedField.getAllFitStats() == null) {
                object5 = "(DEFAULT)";
            } else {
                object4 = simulatedField.getMeasurementLevel();
                object3 = simulatedField.getAllFitStats();
                String string7 = "";
                for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                    object = (FitStatistics)((ArrayList)object3).get(i);
                    DistributionType distributionType2 = ((FitStatistics)object).getDistType();
                    if (distributionType2 == DistributionType.EMPIRICAL || SimulationHelper.isDefaultDistribution(distributionType2, (MeasurementLevel)object4)) continue;
                    string7 = string7 + SimulationHelper.getDistributionSyntax(distributionType2) + " ";
                }
                object5 = string7.length() > 0 ? "( " + string7 + ")" : "(DEFAULT)";
            }
            stringBuffer.append((String)object5);
        }
        if (simulatedField.getMinValue() != Double.NEGATIVE_INFINITY) {
            stringBuffer.append(" MINVAL=" + simulatedField.getMinValue());
        }
        if (simulatedField.getMaxValue() != Double.POSITIVE_INFINITY) {
            stringBuffer.append(" MAXVAL=" + simulatedField.getMaxValue());
        }
        return stringBuffer.toString();
    }

    private static String checkStatusOfCategoricalDistField(SimulatedField simulatedField, DialogDataModel dialogDataModel, SimulationPlanHandler simulationPlanHandler, boolean bl) {
        Vector<String> vector;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = dialogDataModel.getString("SimulationPlanPath");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MC_CORRELATION_CORR_CROSSTAB_CHECK");
        MonteCarloSimulationDlg.FitToState fitToState = simulatedField.getAutoFitState();
        if (string == null || string.length() == 0 || simulationPlanHandler != null && !simulationPlanHandler.isCrossTabUsed()) {
            if (bl && bl2 != null && bl2.booleanValue()) {
                if (fitToState == MonteCarloSimulationDlg.FitToState.MatchedAndFitted || fitToState == MonteCarloSimulationDlg.FitToState.DistributionFitChanged || fitToState == MonteCarloSimulationDlg.FitToState.DistributionFittedBefore) {
                    stringBuffer.append("MANUAL(LOCK=");
                    if (simulatedField.isLocked()) {
                        stringBuffer.append("YES ");
                    } else {
                        stringBuffer.append("NO ");
                    }
                    stringBuffer.append("SAVEASFITTED=YES)  DISTRIBUTION=CATEGORICAL(CONTINGENCY=YES)");
                    stringBuffer.toString();
                } else if (fitToState == MonteCarloSimulationDlg.FitToState.ManualDefined) {
                    stringBuffer.append("MANUAL(LOCK=");
                    if (simulatedField.isLocked()) {
                        stringBuffer.append("YES ");
                    } else {
                        stringBuffer.append("NO ");
                    }
                    stringBuffer.append("SAVEASFITTED=NO) DISTRIBUTION=CATEGORICAL(");
                    stringBuffer.append(SimulationHelper.getCatAndProbSyntax(simulatedField));
                    stringBuffer.append(" CONTINGENCY=NO)");
                    stringBuffer.toString();
                }
            }
        } else if (simulationPlanHandler != null && (vector = simulationPlanHandler.getCrossFactorNames()) != null && vector.size() > 0 && bl2 != null && bl2.booleanValue()) {
            Boolean bl3 = dialogDataModel.getBoolean("IDS_MC_CORRELATION_CONTIGENCY_FROM_PLAN_BUTTON");
            if (bl3 != null && bl3.booleanValue()) {
                if (vector.contains(simulatedField.getName())) {
                    stringBuffer.append("MANUAL(LOCK=");
                    if (simulatedField.isLocked()) {
                        stringBuffer.append("YES");
                    } else {
                        stringBuffer.append("NO");
                    }
                    stringBuffer.append(" SAVEASFITTED=YES)");
                }
            } else if (bl && fitToState != MonteCarloSimulationDlg.FitToState.ManualDefined) {
                stringBuffer.append("MANUAL(LOCK=");
                if (simulatedField.isLocked()) {
                    stringBuffer.append("YES");
                } else {
                    stringBuffer.append("NO");
                }
                stringBuffer.append(" SAVEASFITTED=YES) DISTRIBUTION=CATEGORICAL(CONTINGENCY=YES)");
            }
        }
        return stringBuffer.toString();
    }

    private static String getCatAndProbSyntax(SimulatedField simulatedField) {
        int n;
        AbstractList abstractList;
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = simulatedField.getType() > 0;
        ArrayList<Pair<String, Vector<Double>>> arrayList = simulatedField.getAllCatsAndProbs();
        String string = "CATS=";
        String string2 = "PROBS=";
        boolean bl2 = false;
        DistributionType distributionType = simulatedField.getDistributionType();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                Pair<String, Vector<Double>> pair = arrayList.get(i);
                if (((Vector)pair.getSecond()).size() <= 1) continue;
                bl2 = true;
                break;
            }
        }
        Vector<String> vector = simulatedField.getMisMatchCats();
        boolean bl3 = false;
        if (bl2 && arrayList != null && arrayList.size() > 0) {
            bl3 = true;
            for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                Pair<String, Vector<Double>> pair = arrayList.get(i);
                String string3 = (String)pair.getFirst();
                string = bl ? string + CharacterUtil.smartQuote((String)string3) + " " : string + string3 + " ";
            }
            abstractList = (Vector)arrayList.get(0).getSecond();
            n = ((Vector)abstractList).size();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; arrayList != null && j < arrayList.size(); ++j) {
                    Pair<String, Vector<Double>> pair = arrayList.get(j);
                    String string4 = (String)pair.getFirst();
                    if (vector == null || !vector.contains(string4)) {
                        Vector vector2 = (Vector)pair.getSecond();
                        string2 = string2 + UIToolResUtil.removeLocale((String)Double.toString((Double)vector2.get(i))) + " ";
                        continue;
                    }
                    string2 = string2 + "0.0 ";
                }
                if (i >= n - 1) continue;
                string2 = string2 + "; ";
            }
        } else {
            abstractList = simulatedField.getParametersFor(distributionType);
            for (n = 0; abstractList != null && n < ((ArrayList)abstractList).size(); ++n) {
                Pair<String, String> pair = ((ArrayList)abstractList).get(n);
                if (pair.getSecond() == null || ((String)pair.getSecond()).length() <= 0) continue;
                string = bl ? string + CharacterUtil.smartQuote((String)((String)pair.getFirst())) + " " : string + (String)pair.getFirst() + " ";
                string2 = string2 + UIToolResUtil.removeLocale((String)((String)pair.getSecond())) + " ";
            }
        }
        if (!bl3 && vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                string = bl ? string + CharacterUtil.smartQuote((String)vector.get(i)) + " " : string + vector.get(i) + " ";
                string2 = string2 + "0.0 ";
            }
        }
        if (string.length() > 5) {
            stringBuffer.append(string + " " + string2);
        }
        return stringBuffer.toString();
    }

    private static String getFIXEDSyntax(Vector<SimulatedField> vector, boolean bl, DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            ArrayList<Pair<String, String>> arrayList;
            stringBuffer.append("\n /FIXEDINPUT");
            SimulatedField simulatedField = vector.get(i);
            String string2 = simulatedField.getName();
            stringBuffer.append(" INPUT=");
            stringBuffer.append(string2);
            String string3 = "";
            string3 = !bl ? SimulationHelper.getFormatForInput(string2, dialogDataModel) : simulatedField.getOutputFormat();
            if (string3.length() > 0) {
                stringBuffer.append("(FORMAT=" + string3 + ")");
            }
            if ((arrayList = simulatedField.getParametersFor(DistributionType.FIXED)).size() == 1) {
                string = (String)arrayList.get(0).getSecond();
                if (simulatedField.getType() > 0 || simulatedField.getFormat().getFormatType().isStringFormat()) {
                    stringBuffer.append(" VALUE=" + CharacterUtil.smartQuote((String)string));
                } else {
                    stringBuffer.append(" VALUE=" + string);
                }
            } else {
                stringBuffer.append(" ITERATIONS=VALUES(");
                for (int j = 0; j < arrayList.size(); ++j) {
                    string = (String)arrayList.get(j).getSecond();
                    if (simulatedField.getType() > 0 || simulatedField.getFormat().getFormatType().isStringFormat()) {
                        stringBuffer.append(" " + CharacterUtil.smartQuote((String)string));
                        continue;
                    }
                    stringBuffer.append(" " + string);
                }
                stringBuffer.append(")");
            }
            stringBuffer.append(" LOCK=");
            if (simulatedField.isLocked()) {
                stringBuffer.append("YES");
                continue;
            }
            stringBuffer.append("NO");
        }
        return stringBuffer.toString();
    }

    private static String getCorrelationSyntax(SimulationPlanHandler simulationPlanHandler) {
        int n;
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("");
        ArrayList<CorrelationEntry> arrayList = simulationPlanHandler.getCorrelationMatrix();
        if (arrayList == null || arrayList.size() == 0) {
            return "";
        }
        ArrayList<SimulatedField> arrayList2 = simulationPlanHandler.getSimulatedPredictors();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            object2 = arrayList2.get(n2);
            object = ((SimulatedField)((Object)object2)).getDistributionType();
            if (object == DistributionType.FIXED || object == DistributionType.MULTINOMIAL) continue;
            vector.add(object2.getName());
        }
        object2 = "";
        object = "";
        for (n = 0; n < vector.size(); ++n) {
            String string = (String)vector.get(n);
            object2 = object2 + string + " ";
            for (int i = 0; i <= n; ++i) {
                double d;
                object = n == i ? object + "1 " : ((d = SimulationHelper.findValue(arrayList, (String)vector.get(n), (String)vector.get(i))) != -1.7976931348623157E308 ? object + d + ", " : object + "., ");
            }
            if (n >= vector.size() - 1) continue;
            object = object + "; ";
        }
        stringBuffer.append("\n /CORRELATIONS VARORDER=");
        stringBuffer.append((String)object2);
        stringBuffer.append(" CORRMATRIX=");
        stringBuffer.append((String)object);
        stringBuffer.append(" LOCK=");
        n = simulationPlanHandler.isCorrLocked() ? 1 : 0;
        if (n != 0) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        return stringBuffer.toString();
    }

    private static double findValue(ArrayList<CorrelationEntry> arrayList, String string, String string2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            CorrelationEntry correlationEntry = arrayList.get(i);
            if (!correlationEntry.getColFieldName().equals(string2) || !correlationEntry.getRowFiledName().equals(string)) continue;
            return correlationEntry.getValue();
        }
        return 0.0;
    }

    private static String getCorrelationSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        Boolean bl = dialogDataModel.getBoolean("IDS_MC_CORRELATION_TABLE_CHANGED");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MC_CORRELATION_DONNOT_BUTTON");
        if (bl2 != null && bl2.booleanValue() || bl != null && bl.booleanValue()) {
            JTable jTable = (JTable)dialogDataModel.getObject("IDS_MC_CORRELATION_TABLE_KEY");
            MCSimulationTab.CorrelationTableModel correlationTableModel = (MCSimulationTab.CorrelationTableModel)jTable.getModel();
            if (jTable.getRowCount() < 2) {
                return stringBuffer.toString();
            }
            String string = "";
            String string2 = "";
            String string3 = ".";
            int n = 0;
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                string = string + correlationTableModel.getValueAt(i, 0) + " ";
                for (int j = 1; j <= i + 1; ++j) {
                    String string4 = correlationTableModel.getValueAt(i, j).toString();
                    string2 = Double.parseDouble(string4) != -1.7976931348623157E308 ? string2 + string4 : string2 + string3;
                    if (j != i + 1) {
                        string2 = string2 + ", ";
                    }
                    if (i + 1 == j || Double.parseDouble(correlationTableModel.getValueAt(i, j).toString()) == 0.0) continue;
                    ++n;
                }
                if (i >= jTable.getRowCount() - 1) continue;
                string2 = string2 + "; ";
            }
            stringBuffer.append("\n /CORRELATIONS VARORDER=");
            stringBuffer.append(string);
            stringBuffer.append(" CORRMATRIX=");
            stringBuffer.append(string2);
            stringBuffer.append(" LOCK=");
            bl2 = dialogDataModel.getBoolean("IDS_MC_CORRELATION_RECALCULATE_BUTTON");
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("NO");
            } else {
                stringBuffer.append("YES");
            }
        }
        return stringBuffer.toString();
    }

    private static String getAutofitSyntax(DialogDataModel dialogDataModel, SimulationPlanHandler simulationPlanHandler) {
        StringBuffer stringBuffer = new StringBuffer("\n /AUTOFIT");
        stringBuffer.append(" NCASES=");
        Boolean bl = dialogDataModel.getBoolean("IDS_MC_OPTION_ALL_CASE_LABEL");
        String string = "ALL";
        if (simulationPlanHandler != null && simulationPlanHandler.getNumOfSampling() > 0) {
            string = "" + simulationPlanHandler.getNumOfSampling();
        } else if (bl == null || !bl.booleanValue()) {
            string = dialogDataModel.getString("IDS_MC_OPTION_LIMIT_CASE_NUM");
        }
        stringBuffer.append(string);
        if (simulationPlanHandler == null) {
            bl = dialogDataModel.getBoolean("IDS_MC_OPTION_ANDERSON_DARLING_LABEL");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(" FIT=AD");
            } else {
                stringBuffer.append(" FIT=KS");
            }
            stringBuffer.append(" BINS=" + dialogDataModel.getString("IDS_MC_EMPERICAL_BINS"));
        } else {
            stringBuffer.append(" FIT=AD BINS=100");
        }
        return stringBuffer.toString();
    }

    private static String getStopCreteriaSyntax(SimulationPlanHandler simulationPlanHandler) {
        StringBuffer stringBuffer = new StringBuffer("\n /STOPCRITERIA");
        ArrayList<SimulationPlanHandler.SamplingCriteria> arrayList = simulationPlanHandler.getCriterias();
        if (arrayList == null || arrayList.size() == 0) {
            return "";
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SimulationPlanHandler.SamplingCriteria samplingCriteria = arrayList.get(i);
            int n = samplingCriteria.getMaxSamples();
            if (n > 0) {
                stringBuffer.append(" MAXCASES=" + n);
            }
            if (samplingCriteria.getCriteriaType() == null) continue;
            stringBuffer.append(" TARGET=" + samplingCriteria.getTargetName());
            if (samplingCriteria.getCriteriaType() == MonteCarloSimulationDlg.CriteriaType.point_value) {
                stringBuffer.append(" TYPE=MEAN(THRESH=" + samplingCriteria.getThreshold());
                if (samplingCriteria.getCriteriaUnit() == MonteCarloSimulationDlg.CriteriaUnit.percent) {
                    stringBuffer.append(" UNIT=PERCENT CILEVEL=");
                } else {
                    stringBuffer.append(" UNIT=VALUE CILEVEL=");
                }
                stringBuffer.append(samplingCriteria.getConfLevel() + ")");
                continue;
            }
            stringBuffer.append(" TYPE=TAIL(THRESH=" + samplingCriteria.getThreshold());
            if (samplingCriteria.getCriteriaUnit() == MonteCarloSimulationDlg.CriteriaUnit.percent) {
                stringBuffer.append(" UNIT=PERCENTILE FREQUENCY=");
            } else {
                stringBuffer.append(" UNIT=VALUE FREQUENCY=");
            }
            stringBuffer.append(samplingCriteria.getTailFrequency());
            if (samplingCriteria.getTailSide().length() > 0) {
                stringBuffer.append(" SIDE=" + samplingCriteria.getTailSide());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static String getStopCreteriaSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("\n /STOPCRITERIA");
        stringBuffer.append(" MAXCASES=" + dialogDataModel.getString("IDS_MC_NUM_CASES_TO_GENERATE"));
        Boolean bl = dialogDataModel.getBoolean("IDS_MC_OPTION_STOP_CRITERIA_RADIO_BY_TAIL");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_MC_OPTION_STOP_CRITERIA_RADIO_BY_THRESHOLD");
        if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
            String string = dialogDataModel.getString("IDS_MC_OPTION_CRITERIA_TARGET_NAME");
            if (string != null) {
                stringBuffer.append(" TARGET=" + string);
            }
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append(" TYPE=MEAN(THRESH=");
                Integer n = dialogDataModel.getInteger("IDS_MC_OPTION_CRITERIA_TTHRESH_TYPE");
                if (n == 0) {
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_THRESH_PERCENTILE"));
                    stringBuffer.append(" UNIT=PERCENT CILEVEL=");
                } else if (n == 1) {
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_THRESH_VALUE"));
                    stringBuffer.append(" UNIT=VALUE CILEVEL=");
                }
                stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_THRESH_CONFIDENCE"));
                stringBuffer.append(")");
            } else {
                stringBuffer.append(" TYPE=TAIL(THRESH=");
                Integer n = dialogDataModel.getInteger("IDS_MC_OPTION_CRITERIA_TAIL_TYPE");
                if (n == 0) {
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_TAIL_PERCENTILE_VALUE"));
                    stringBuffer.append(" UNIT=PERCENTILE FREQUENCY=");
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_CRITERIA_TAIL_FREQ") + ")");
                } else if (n == 1) {
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_OPTION_TAIL_VALUE"));
                    stringBuffer.append(" UNIT=VALUE FREQUENCY=");
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_CRITERIA_TAIL_FREQ"));
                    Integer n2 = dialogDataModel.getInteger("IDS_MC_OPTION_CRITERIA_TAIL_SIDE");
                    if (n2 == 0) {
                        stringBuffer.append(" SIDE=LEFT)");
                    } else {
                        stringBuffer.append(" SIDE=RIGHT)");
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getPlanSyntax(DialogDataModel dialogDataModel, boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer("\n /PLAN FILE=");
        String string2 = SimulationHelper.getSimPlanPath(dialogDataModel, bl);
        if (string.length() > 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("'" + string2);
            stringBuffer.append("'");
        }
        stringBuffer.append(" DISPLAY=YES.");
        PesFile pesFile = PES_Repository.getPesFile((String)string2);
        if (pesFile != null) {
            stringBuffer.append("\n " + pesFile.getPerAttributesSyntax());
        }
        return stringBuffer.toString();
    }

    private static String getSimPlanPath(DialogDataModel dialogDataModel, boolean bl) {
        String string = SimulationHelper.getPlanPathFromUser(dialogDataModel, bl);
        if (string == null || string.length() == 0) {
            string = SimulationHelper.getDefaultSimplanPath(true);
        }
        return string;
    }

    private static String getPlanPathFromUser(DialogDataModel dialogDataModel, boolean bl) {
        Boolean bl2;
        String string = "";
        String string2 = "IDS_MC_SIMPLE_SAVE_PLAN_FILE_CHECK";
        if (!bl) {
            string2 = "IDS_MC_SAVE_PLAN_FILE_CHECK";
        }
        if ((bl2 = dialogDataModel.getBoolean(string2)) != null && bl2.booleanValue()) {
            string = bl ? dialogDataModel.getString("IDS_MC_SIMPLE_SAVE_PLAN_FILE_NAME") : dialogDataModel.getString("IDS_MC_SAVE_PLAN_FILE_NAME");
        }
        return string;
    }

    public static String getFileHandleName() {
        double d = Math.random() * 1000000.0;
        return "simplan_" + Math.round(d);
    }

    private static String getFormatForInput(String string, DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        JTable jTable = (JTable)dialogDataModel.getObject("IDS_MC_SIMALATION_FORMAT");
        int n = 0;
        for (n = 0; n < jTable.getRowCount(); ++n) {
            String string2 = jTable.getValueAt(n, 0).toString();
            String string3 = jTable.getValueAt(n, 1).toString();
            String string4 = jTable.getValueAt(n, 2).toString();
            if (!string.equalsIgnoreCase(string2)) continue;
            String string5 = SimulationHelper.getSyntaxForOutputFormat(string3);
            if (string5.length() != 0) {
                stringBuffer.append(string5 + "," + string4);
            }
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    private static String getParameterValuesSyntax(DistributionType distributionType, ArrayList<Pair<String, String>> arrayList) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (distributionType == DistributionType.NEGBIN_TRIAL) {
            stringBuffer.append("TYPE=TRIALS ");
        } else if (distributionType == DistributionType.NEGBIN) {
            stringBuffer.append("TYPE=FAILURES ");
        }
        Pair<String, String>[] pairArray = SimulationHelper.getParamNames(distributionType);
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            String string = (String)pairArray[i].getFirst();
            if ((distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) && string.equals("thresh")) {
                stringBuffer.append("THRESHOLD=");
            } else {
                stringBuffer.append(string.toUpperCase() + "=");
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                Pair<String, String> pair = arrayList.get(j);
                if (!string.equalsIgnoreCase((String)pair.getFirst())) continue;
                stringBuffer.append((String)pair.getSecond() + " ");
            }
        }
        return stringBuffer.toString();
    }

    public static int getFormatIndex(String string) {
        if (sFieldOutputFormat == null) {
            sFieldOutputFormat = SimulationHelper.createOutputFormatArray();
        }
        if (string.equals("F")) {
            return 0;
        }
        if (string.equals("DOT")) {
            return 1;
        }
        if (string.equals("COMMA")) {
            return 2;
        }
        if (string.equals("PCT")) {
            return 3;
        }
        if (string.equals("E")) {
            return 4;
        }
        if (string.equals("DOLLAR")) {
            return 5;
        }
        if (string.equals("CCA")) {
            return 6;
        }
        if (string.equals("CCB")) {
            return 7;
        }
        if (string.equals("CCC")) {
            return 8;
        }
        if (string.equals("CCD")) {
            return 9;
        }
        if (string.equals("CCE")) {
            return 10;
        }
        if (string.equals("N")) {
            return 11;
        }
        return 0;
    }

    public static String getSyntaxForOutputFormat(String string) {
        if (sFieldOutputFormat == null) {
            sFieldOutputFormat = SimulationHelper.createOutputFormatArray();
        }
        if (string.equals(sFieldOutputFormat[0])) {
            return "F";
        }
        if (string.equals(sFieldOutputFormat[1])) {
            return "DOT";
        }
        if (string.equals(sFieldOutputFormat[2])) {
            return "COMMA";
        }
        if (string.equals(sFieldOutputFormat[3])) {
            return "PCT";
        }
        if (string.equals(sFieldOutputFormat[4])) {
            return "E";
        }
        if (string.equals(sFieldOutputFormat[5])) {
            return "DOLLAR";
        }
        if (string.equals(sFieldOutputFormat[6])) {
            return "CCA";
        }
        if (string.equals(sFieldOutputFormat[7])) {
            return "CCB";
        }
        if (string.equals(sFieldOutputFormat[8])) {
            return "CCC";
        }
        if (string.equals(sFieldOutputFormat[9])) {
            return "CCD";
        }
        if (string.equals(sFieldOutputFormat[10])) {
            return "CCE";
        }
        if (string.equals(sFieldOutputFormat[11])) {
            return "N";
        }
        return "";
    }

    public static int getFormatTableIndexFromSyntax(String string) {
        if (string.equals("F")) {
            return 0;
        }
        if (string.equals("DOT")) {
            return 1;
        }
        if (string.equals("COMMA")) {
            return 2;
        }
        if (string.equals("PCT")) {
            return 3;
        }
        if (string.equals("E")) {
            return 4;
        }
        if (string.equals("DOLLAR")) {
            return 5;
        }
        if (string.equals("CCA")) {
            return 6;
        }
        if (string.equals("CCB")) {
            return 7;
        }
        if (string.equals("CCC")) {
            return 8;
        }
        if (string.equals("CCD")) {
            return 9;
        }
        if (string.equals("CCE")) {
            return 10;
        }
        if (string.equals("N")) {
            return 11;
        }
        return -1;
    }

    static String getSyntaxForOutputFormat(int n) {
        switch (n) {
            case 0: {
                return "F";
            }
            case 1: {
                return "DOT";
            }
            case 2: {
                return "COMMA";
            }
            case 3: {
                return "PCT";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "DOLLAR";
            }
            case 6: {
                return "CCA";
            }
            case 7: {
                return "CCB";
            }
            case 8: {
                return "CCC";
            }
            case 9: {
                return "CCD";
            }
            case 10: {
                return "CCE";
            }
            case 11: {
                return "N";
            }
        }
        return "F";
    }

    private static boolean isContain(Object[] objectArray, String string) {
        if (objectArray == null || string == null) {
            return false;
        }
        for (Object object : objectArray) {
            if (!object.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String generateSIMRUNsyntax(DialogDataModel dialogDataModel) {
        return SimulationHelper.generateSIMRUNsyntax(dialogDataModel, false);
    }

    public static String generateSIMRUNsyntax(DialogDataModel dialogDataModel, boolean bl) {
        Serializable serializable;
        Object object;
        Boolean bl2;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n*Run simulation plan.");
        string = "IDS_MC_SAVE_SIM_DATA_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_SAVE_SIM_DATA_CHECK";
        }
        boolean bl3 = true;
        SimulationPlanHandler simulationPlanHandler = (SimulationPlanHandler)dialogDataModel.getObject("SimulationPlanHandler");
        ArrayList<SimulationPlanHandler.ModelFile> arrayList = null;
        if (simulationPlanHandler != null && ((arrayList = simulationPlanHandler.getModelFiles()) == null || arrayList.size() == 0)) {
            bl3 = false;
        }
        Boolean bl4 = dialogDataModel.getBoolean(string);
        String string2 = "";
        String string3 = "";
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string4 = iSpssDataSrc.getDatasetName();
        if (bl4 != null && bl4.booleanValue()) {
            string = "IDS_MC_SAVE_DATASET_BUTTON";
            if (bl) {
                string = "IDS_MC_SIMPLE_SAVE_DATASET_BUTTON";
            }
            if ((bl2 = dialogDataModel.getBoolean(string)) != null && bl2.booleanValue()) {
                stringBuffer.append("\nDATASET DECLARE ");
                string2 = bl ? dialogDataModel.getString("IDS_MC_SIMPLE_SAVE_NEW_DATASET_NAME") : dialogDataModel.getString("IDS_MC_SAVE_NEW_DATASET_NAME");
                stringBuffer.append(string2 + ".");
            } else {
                string = "IDS_MC_SAVE_AS_EXCEL_FILE_BUTTON";
                if (bl) {
                    string = "IDS_MC_SIMPLE_SAVE_AS_EXCEL_FILE_BUTTON";
                }
                if ((bl2 = dialogDataModel.getBoolean(string)) != null && bl2.booleanValue()) {
                    string3 = bl ? dialogDataModel.getString("IDS_MC_SIMPLE_SAVE_NEW_EXCEL_FILE_NAME") : dialogDataModel.getString("IDS_MC_SAVE_NEW_EXCEL_FILE_NAME");
                    stringBuffer.append("\nDATASET DECLARE MC_RUN_tempdataset.");
                    if (string4.length() == 0) {
                        string4 = SpssMgr.getSpssMgr().getNextFreeDatasetName();
                    }
                    stringBuffer.append("\nDATASET NAME ");
                    stringBuffer.append(string4 + ".");
                }
            }
        }
        stringBuffer.append("\nSIMRUN");
        stringBuffer.append("\n /PLAN FILE=");
        if (SimulationHelper.getPlanPathFromUser(dialogDataModel, bl).length() > 0) {
            stringBuffer.append(dialogDataModel.getString(MonteCarloSimulationDlg.FILE_HANDLE_KEY));
        } else {
            stringBuffer.append("'" + SimulationHelper.getSimPlanPath(dialogDataModel, bl) + "'");
        }
        stringBuffer.append("\n /CRITERIA ");
        bl4 = dialogDataModel.getBoolean("IDS_MC_OPTION_SEED_CHECK");
        if (bl4 != null) {
            if (bl4.booleanValue()) {
                stringBuffer.append(" REPRESULTS=TRUE  SEED=");
                stringBuffer.append(dialogDataModel.getString("IDS_MC_OPTION_SEED_VALUE") + " ");
            } else {
                stringBuffer.append(" REPRESULTS=FALSE ");
            }
        } else {
            stringBuffer.append(" REPRESULTS=TRUE  SEED=629111597");
        }
        bl2 = dialogDataModel.getBoolean("IDS_MC_MODEL_CREATE_DATA_BUTTON");
        boolean bl5 = true;
        if (bl2 == null || !bl2.booleanValue()) {
            bl5 = false;
            stringBuffer.append(SimulationHelper.getOutputSettingForTargetSyntax(dialogDataModel, bl, bl3));
        }
        stringBuffer.append("\n /PRINT");
        String string5 = "IDS_MC_OUTPUT_CORRELATION_CROSSTAB_CHECK";
        if (bl) {
            string5 = "IDS_MC_SIMPLE_OUTPUT_CORRELATION_CROSSTAB_CHECK";
        }
        if ((bl4 = dialogDataModel.getBoolean(string5)) != null && bl4.booleanValue()) {
            stringBuffer.append(" ASSOCIATIONS=YES");
        } else {
            stringBuffer.append(" ASSOCIATIONS=NO");
        }
        if (bl) {
            stringBuffer.append(" DESCRIPTIVES=YES");
        } else {
            bl4 = dialogDataModel.getBoolean("IDS_MC_OUTPUT_DESCRIB_CHECK");
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append(" DESCRIPTIVES=YES");
                if (!bl5) {
                    stringBuffer.append("(CILEVEL=" + dialogDataModel.getString("IDS_MC_DESC_CONF_VALUE"));
                    stringBuffer.append(")");
                }
            } else {
                stringBuffer.append(" DESCRIPTIVES=NO");
            }
        }
        if (bl && bl3) {
            bl4 = dialogDataModel.getBoolean("IDS_MC_SIMPLE_OUTPUT_QUARTILE_TABLE_CHECK");
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append(" PERCENTILES=YES(NTILES=4)");
            } else {
                stringBuffer.append(" PERCENTILES=NO");
            }
        }
        if ((bl4 = dialogDataModel.getBoolean("IDS_MC_OUTPUT_CREATE_TABLE_CHECK")) != null && bl4.booleanValue()) {
            stringBuffer.append(" PERCENTILES=YES(");
            object = dialogDataModel.getBoolean("IDS_MC_OUTPUT_QUARTILE_CHECK");
            if (object != null && ((Boolean)object).booleanValue()) {
                stringBuffer.append("NTILES=4)");
            } else {
                object = dialogDataModel.getBoolean("IDS_MC_OUTPUT_INVERVAL_CHECK");
                if (object != null && ((Boolean)object).booleanValue()) {
                    stringBuffer.append("NTILES=");
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_OUTPUT_INTERVAL_VALUE"));
                    stringBuffer.append(")");
                } else {
                    object = dialogDataModel.getBoolean("IDS_MC_OUTPUT_CUSTOM_PERCENT_CHECK");
                    if (object != null && ((Boolean)object).booleanValue()) {
                        stringBuffer.append("PTILES=");
                        serializable = (JTable)dialogDataModel.getObject("IDS_MC_OUTPUT_CUSTOM_PERCENT_TABLE_KEY");
                        for (int i = 0; i < ((JTable)serializable).getRowCount(); ++i) {
                            Object object2 = ((JTable)serializable).getValueAt(i, 0);
                            if (object2 == null || object2.toString().length() <= 0) continue;
                            stringBuffer.append(object2 + " ");
                        }
                        stringBuffer.append(")");
                    }
                }
            }
        } else if (!bl) {
            stringBuffer.append(" PERCENTILES=NO");
        }
        string = "IDS_MC_SAVE_SIM_DATA_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_SAVE_SIM_DATA_CHECK";
        }
        bl4 = dialogDataModel.getBoolean(string);
        object = "";
        if (bl4 != null && bl4.booleanValue()) {
            string = "IDS_MC_SAVE_AS_SAV_FILE_BUTTON";
            if (bl) {
                string = "IDS_MC_SIMPLE_SAVE_AS_SAV_FILE_BUTTON";
            }
            if ((serializable = dialogDataModel.getBoolean(string)) != null && ((Boolean)serializable).booleanValue()) {
                stringBuffer.append("\n /OUTFILE FILE='");
                object = bl ? dialogDataModel.getString("IDS_MC_SIMPLE_SAVE_NEW_SAV_FILE_NAME") : dialogDataModel.getString("IDS_MC_SAVE_NEW_SAV_FILE_NAME");
                stringBuffer.append((String)object);
                stringBuffer.append("'.");
            } else if (string2.length() > 0) {
                stringBuffer.append("\n /OUTFILE FILE=" + string2 + ".");
            } else if (string3.length() > 0) {
                String string6 = "12";
                if (string3.endsWith(".xls")) {
                    string6 = "8";
                } else if (string3.endsWith(".xlsx")) {
                    string6 = "12";
                } else {
                    string3 = string3 + ".xlsx";
                }
                stringBuffer.append("\n /OUTFILE FILE=MC_RUN_tempdataset.");
                stringBuffer.append("\nDATASET ACTIVATE MC_RUN_tempdataset.");
                stringBuffer.append("\nSAVE TRANSLATE OUTFILE='" + string3 + "'");
                stringBuffer.append("\n  /TYPE=XLS");
                stringBuffer.append("\n  /VERSION=" + string6);
                stringBuffer.append("\n  /REPLACE");
                stringBuffer.append("\n  /FIELDNAMES");
                stringBuffer.append("\n  /CELLS=LABELS.");
                stringBuffer.append("\nDATASET ACTIVATE " + string4 + ".");
                stringBuffer.append("\nDATASET CLOSE MC_RUN_tempdataset.");
            }
        } else {
            stringBuffer.append(".");
        }
        if (object != null && ((String)object).length() > 0 && (serializable = PES_Repository.getPesFile((String)object)) != null) {
            stringBuffer.append("\n " + serializable.getPerAttributesSyntax());
        }
        sFieldOutputFormat = null;
        return stringBuffer.toString();
    }

    private static String getOutputSettingForTargetSyntax(DialogDataModel dialogDataModel, boolean bl, boolean bl2) {
        boolean bl3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Boolean bl4;
        Boolean bl5;
        StringBuffer stringBuffer = new StringBuffer("");
        if (bl && !bl2) {
            return stringBuffer.toString();
        }
        stringBuffer.append("\n /DISTRIBUTION ");
        String string = "IDS_MC_DFUNCTIONS_PDF_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_OUTPUT_PDF_CHECK";
        }
        Boolean bl6 = dialogDataModel.getBoolean(string);
        string = "IDS_MC_DFUNCTIONS_CDF_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_OUTPUT_CDF_CHECK";
        }
        Boolean bl7 = dialogDataModel.getBoolean(string);
        if (bl6 != null && bl6.booleanValue() && bl7 != null && bl7.booleanValue()) {
            stringBuffer.append("DISPLAY=PDF CDF CDFORDER=ASCENDING");
        } else if (bl6 != null && bl6.booleanValue()) {
            stringBuffer.append("DISPLAY=PDF");
        } else if (bl7 != null && bl7.booleanValue()) {
            stringBuffer.append("DISPLAY=CDF CDFORDER=ASCENDING");
        } else {
            stringBuffer.append("DISPLAY=NONE");
        }
        boolean bl8 = true;
        if (bl8) {
            stringBuffer.append(" SCALE = PDFVIEW(CURVE)");
            if (bl6 != null && bl6.booleanValue() || bl7 != null && bl7.booleanValue()) {
                bl5 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_REF_MEAN_CHECK");
                if (bl5 != null && bl5.booleanValue()) {
                    stringBuffer.append(" MEAN");
                }
                if ((bl5 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_REF_MEDIAN_CHECK")) != null && bl5.booleanValue()) {
                    stringBuffer.append(" MEDIAN");
                }
                if ((bl5 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_REF_PERCENTILE_CHECK")) != null && bl5.booleanValue()) {
                    stringBuffer.append(" PCT(");
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_DF_PERCENTILE_BOTTOM_VALUE") + " ");
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_DF_PERCENTILE_TOP_VALUE"));
                    stringBuffer.append(")");
                }
                if ((bl5 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_REF_SIGMA_CHECK")) != null && bl5.booleanValue()) {
                    stringBuffer.append(" SIGMAS(");
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_DF_SIGMA_LEVEL_VALUE"));
                    stringBuffer.append(")");
                }
                if ((bl5 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_REF_CUSTOM_CHECK")) != null && bl5.booleanValue()) {
                    stringBuffer.append(" CUSTOM(");
                    stringBuffer.append(dialogDataModel.getString("IDS_MC_DF_CUSTOM_REF_VALUES"));
                    stringBuffer.append(")");
                }
                if ((bl5 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_OVERLAY_CHECK")) != null && bl5.booleanValue()) {
                    stringBuffer.append(" OVERLAYTARGETS(YES)");
                } else {
                    stringBuffer.append(" OVERLAYTARGETS(NO)");
                }
            }
            bl5 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_SLIDER_SET_CHECK");
            Boolean bl9 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_SLIDER_NEG_INF_CHECK");
            bl4 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_SLIDER_POS_INF_CHECK");
            if (!(bl5 == null || !bl5.booleanValue() || bl9.booleanValue() && bl4.booleanValue())) {
                stringBuffer.append(" REFLINES (");
                object4 = dialogDataModel.getString("IDS_MC_DF_SLIDER_LOW_VALUE");
                object3 = dialogDataModel.getString("IDS_MC_DF_SLIDER_UPPER_VALUE");
                object2 = "";
                object = "";
                object = object4 != null && ((String)object4).length() > 0 ? "LOWER=" + (String)object4 : "LOWER=DEFAULT";
                object2 = object3 != null && ((String)object3).length() > 0 ? " UPPER=" + (String)object3 + ")" : " UPPER=DEFAULT)";
                if (bl9 != null && !bl9.booleanValue() && bl4 != null && !bl4.booleanValue()) {
                    stringBuffer.append((String)object);
                    stringBuffer.append((String)object2);
                } else if (bl9 != null && bl9.booleanValue()) {
                    stringBuffer.append("LOWER=LO");
                    stringBuffer.append((String)object2);
                } else {
                    stringBuffer.append((String)object);
                    stringBuffer.append(" UPPER=HI)");
                }
            }
        }
        if ((bl3 = true) && bl6 != null && bl6.booleanValue() && !bl) {
            stringBuffer.append(" CATEGORICAL=");
            bl4 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_PRED_CAT_CHECK");
            object4 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_PRED_PROB_CHECK");
            object3 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_BOTH_PRED_PROB_CHECK");
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append(" PREDVAL");
            } else if (object4 != null && ((Boolean)object4).booleanValue()) {
                stringBuffer.append(" PREDPROB");
            } else if (object3 != null && ((Boolean)object3).booleanValue()) {
                stringBuffer.append(" PREDVAL PREDPROB");
            }
            object2 = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_GROUP_CAT_BUTTON");
            object = dialogDataModel.getBoolean("IDS_MC_DFUNCTIONS_GROUP_ITERATION_BUTTON");
            if (object2 != null && ((Boolean)object2).booleanValue()) {
                stringBuffer.append(" GROUP(CATS) ");
            } else if (object != null && ((Boolean)object).booleanValue()) {
                stringBuffer.append(" GROUP(ITERS) ");
            }
        }
        if ((bl5 = dialogDataModel.getBoolean(string = !bl ? "IDS_MC_OUTPUT_BOXPLOT_CHECK" : "IDS_MC_SIMPLE_OUTPUT_BOXPLOT_CHECK")) != null && bl5.booleanValue()) {
            stringBuffer.append("\n /BOXPLOT DISPLAY=YES");
            string = "IDS_MC_SIMPLE_OUTPUT_OVERLAY_CHECK";
            if (!bl) {
                string = "IDS_MC_OUTPUT_OVERLAY_CHECK";
            }
            if ((bl4 = dialogDataModel.getBoolean(string)) != null && bl4.booleanValue()) {
                stringBuffer.append(" OVERLAYTARGETS=YES(GROUP=TARGETS)");
            } else {
                stringBuffer.append("  OVERLAYTARGETS=NO");
            }
        } else {
            stringBuffer.append("\n /BOXPLOT DISPLAY=NO");
        }
        string = "IDS_MC_OUTPUT_SCATTERPLOT_MATRIX_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_OUTPUT_SCATTERPLOT_MATRIX_CHECK";
        }
        if ((bl5 = dialogDataModel.getBoolean(string)) != null && bl5.booleanValue()) {
            stringBuffer.append("\n /SCATTERPLOT DISPLAY=YES ROWSIZE=DEFAULT");
        } else {
            stringBuffer.append("\n /SCATTERPLOT DISPLAY=NO");
        }
        int n = 0;
        stringBuffer.append("\n /TORNADO DISPLAY=");
        string = "IDS_MC_OUTPUT_TORNADO_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_OUTPUT_TORNADO_CHECK";
        }
        bl5 = dialogDataModel.getBoolean(string);
        object4 = " TYPE=";
        object3 = "";
        if (bl5 != null && bl5.booleanValue()) {
            object2 = dialogDataModel.getBoolean("IDS_MC_OUTPUT_USE_ORDINAL_CHECK");
            object4 = (String)object4 + "CORR";
            ++n;
        }
        string = "IDS_MC_OUTPUT_SENSITIVITY_TO_CHAHNGE_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_OUTPUT_SENSITIVITY_TO_CHANGE_CHECK";
        }
        if ((bl5 = dialogDataModel.getBoolean(string)) != null && bl5.booleanValue()) {
            object4 = (String)object4 + " DELTASTDDEV(";
            object4 = bl ? (String)object4 + "1" : (String)object4 + dialogDataModel.getString("IDS_MC_TORNADO_STDDEV_VALUE");
            object4 = (String)object4 + ")";
            ++n;
        }
        string = "IDS_MC_OUTPUT_CONTRI_TO_VARIANCE_CHECK";
        if (bl) {
            string = "IDS_MC_SIMPLE_OUTPUT_CONTRI_TO_VARIANCE_CHECK";
        }
        if ((bl5 = dialogDataModel.getBoolean(string)) != null && bl5.booleanValue()) {
            object4 = (String)object4 + " VARIANCE";
            ++n;
        }
        if (n == 0) {
            stringBuffer.append("NO");
        } else {
            stringBuffer.append("YES");
            stringBuffer.append((String)object4);
            stringBuffer.append((String)object3);
        }
        return stringBuffer.toString();
    }

    public static String getDistributionSyntax(DistributionType distributionType) {
        if (distributionType == DistributionType.NORMAL) {
            return "NORMAL";
        }
        if (distributionType == DistributionType.BINOMIAL) {
            return "BINOM";
        }
        if (distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) {
            return "NEGBIN";
        }
        if (distributionType == DistributionType.MULTINOMIAL) {
            return "CATEGORICAL";
        }
        if (distributionType == DistributionType.EMPIRICAL) {
            return "EMPIRICAL";
        }
        if (distributionType == DistributionType.POISSON) {
            return "POISSON";
        }
        if (distributionType == DistributionType.LOGNORMAL) {
            return "LNORMAL";
        }
        if (distributionType == DistributionType.TRIANGULAR) {
            return "TRIANGULAR";
        }
        if (distributionType == DistributionType.UNIFORM) {
            return "UNIFORM";
        }
        if (distributionType == DistributionType.GAMMA) {
            return "GAMMA";
        }
        if (distributionType == DistributionType.WEIBULL) {
            return "WEIBULL";
        }
        if (distributionType == DistributionType.BETA) {
            return "BETA";
        }
        if (distributionType == DistributionType.EXPONENTIAL) {
            return "EXP";
        }
        if (distributionType == DistributionType.RANGE) {
            return "";
        }
        if (distributionType == DistributionType.BERNOULLI) {
            return "BERNOULLI";
        }
        if (distributionType == DistributionType.FIXED) {
            return "";
        }
        return "";
    }

    public static String getDistributionHelpText(DistributionType distributionType) {
        String string = "";
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (distributionType == DistributionType.NORMAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL_HELP");
        } else if (distributionType == DistributionType.BINOMIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL_HELP");
        } else if (distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN_HELP");
        } else if (distributionType == DistributionType.MULTINOMIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL_HELP");
        } else if (distributionType == DistributionType.EMPIRICAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL_HELP");
        } else if (distributionType == DistributionType.POISSON) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON_HELP");
        } else if (distributionType == DistributionType.LOGNORMAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL_HELP");
        } else if (distributionType == DistributionType.TRIANGULAR) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR_HELP");
        } else if (distributionType == DistributionType.UNIFORM) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM_HELP");
        } else if (distributionType == DistributionType.GAMMA) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA_HELP");
        } else if (distributionType == DistributionType.WEIBULL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL_HELP");
        } else if (distributionType == DistributionType.BETA) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA_HELP");
        } else if (distributionType == DistributionType.EXPONENTIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL_HELP");
        } else if (distributionType == DistributionType.RANGE) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_RANGE_HELP");
        } else if (distributionType == DistributionType.BERNOULLI) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI_HELP");
        } else if (distributionType == DistributionType.FIXED) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_FIXED_HELP");
        }
        return string;
    }

    public static ImageIcon getDistributionHelpIcon(DistributionType distributionType) {
        String string;
        boolean bl;
        ImageIcon imageIcon = null;
        Locale locale = ResUtil.getLocale();
        String string2 = locale.getLanguage();
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String string3 = "";
        boolean bl2 = bl = locale == Locale.FRENCH || locale == Locale.GERMAN || locale == Locale.ITALIAN || string2.equals("es") || string2.equals("pl") || string2.equals("ru");
        if (distributionType == DistributionType.NORMAL) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_NORMAL_HELP_IMAGE";
        } else if (distributionType == DistributionType.BINOMIAL) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL_HELP_IMAGE";
        } else if (distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_NEGBIN_HELP_IMAGE";
        } else if (distributionType == DistributionType.MULTINOMIAL) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL_HELP_IMAGE";
        } else if (distributionType == DistributionType.POISSON) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_POISSON_HELP_IMAGE";
        } else if (distributionType == DistributionType.LOGNORMAL) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL_HELP_IMAGE";
        } else if (distributionType == DistributionType.TRIANGULAR) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR_HELP_IMAGE";
        } else if (distributionType == DistributionType.UNIFORM) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_UNIFORM_HELP_IMAGE";
        } else if (distributionType == DistributionType.GAMMA) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_GAMMA_HELP_IMAGE";
        } else if (distributionType == DistributionType.WEIBULL) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_WEIBULL_HELP_IMAGE";
        } else if (distributionType == DistributionType.BETA) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_BETA_HELP_IMAGE";
        } else if (distributionType == DistributionType.EXPONENTIAL) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL_HELP_IMAGE";
        } else if (distributionType == DistributionType.RANGE) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_RANGE_HELP_IMAGE";
        } else if (distributionType == DistributionType.BERNOULLI) {
            string3 = "IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI_HELP_IMAGE";
        }
        if (string3.length() > 0 && bl) {
            string3 = string3 + "_COMMA";
        }
        if (string3.length() > 0 && (string = resourceBundle.getString(string3)) != null) {
            URL uRL = ResUtil.getImageResourceFullPath(MCResBundle.getImageFolder() + string);
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }

    public static String getDistributionHelpIconTooltip(DistributionType distributionType) {
        Object var1_1 = null;
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String string = null;
        if (distributionType == DistributionType.NORMAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL");
        } else if (distributionType == DistributionType.BINOMIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL");
        } else if (distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN");
        } else if (distributionType == DistributionType.MULTINOMIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL");
        } else if (distributionType == DistributionType.POISSON) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON");
        } else if (distributionType == DistributionType.LOGNORMAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL");
        } else if (distributionType == DistributionType.TRIANGULAR) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR");
        } else if (distributionType == DistributionType.UNIFORM) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM");
        } else if (distributionType == DistributionType.GAMMA) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA");
        } else if (distributionType == DistributionType.WEIBULL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL");
        } else if (distributionType == DistributionType.BETA) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA");
        } else if (distributionType == DistributionType.EXPONENTIAL) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL");
        } else if (distributionType == DistributionType.RANGE) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_RANGE");
        } else if (distributionType == DistributionType.BERNOULLI) {
            string = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI");
        }
        String string2 = null;
        if (string != null) {
            string2 = MessageFormat.format(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TOOLTIP"), string);
        }
        return string2;
    }

    public static JLabel createStateImageLabel(SimulatedField simulatedField, boolean bl) {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        MonteCarloSimulationDlg.FitToState fitToState = simulatedField.getAutoFitState();
        String string = "IDS_MC_SIMULATED_FIELD_NOT_SET_IMAGE";
        String string2 = null;
        if (fitToState == MonteCarloSimulationDlg.FitToState.DistributionNotSet) {
            string = bl ? "IDS_MC_SIMULATED_FIELD_NOT_FIT_SMALL_IMAGE" : "IDS_MC_SIMULATED_FIELD_NOT_FIT_IMAGE";
            string2 = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_NOT_FIT_TOOLTIP");
        } else if (fitToState == MonteCarloSimulationDlg.FitToState.DistributionFittedBefore) {
            string = bl ? "IDS_MC_SIMULATED_FIELD_NOT_SET_SMALL_IMAGE" : "IDS_MC_SIMULATED_FIELD_NOT_SET_IMAGE";
            string2 = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_NOT_SET_TOOLTIP");
        } else if (fitToState == MonteCarloSimulationDlg.FitToState.DistributionFitChanged) {
            string = bl ? "IDS_MC_SIMULATED_FIELD_OVERRIDDEN_SMALL_IMAGE" : "IDS_MC_SIMULATED_FIELD_OVERRIDDEN_IMAGE";
            string2 = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_OVERRIDDEN_TOOLTIP");
        } else if (fitToState == MonteCarloSimulationDlg.FitToState.MatchedAndFitted) {
            string = bl ? "IDS_MC_SIMULATED_FIELD_MATCH_FITTED_SMALL_IMAGE" : "IDS_MC_SIMULATED_FIELD_MATCH_FITTED_IMAGE";
            string2 = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_MATCH_FITTED_TOOLTIP");
        } else if (fitToState == MonteCarloSimulationDlg.FitToState.ManualDefined) {
            string = bl ? "IDS_MC_SIMULATED_FIELD_MANUAL_DEFINE_SMALL_IMAGE" : "IDS_MC_SIMULATED_FIELD_MANUAL_DEFINE_IMAGE";
            string2 = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_MANUAL_DEFINE_TOOLTIP");
        }
        URL uRL = ResUtil.getImageResourceFullPath(MCResBundle.getImageFolder() + ResUtil.getString(resourceBundle, string));
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setToolTipText(string2);
        return jLabel;
    }

    public static boolean isDefaultDistribution(DistributionType distributionType, MeasurementLevel measurementLevel) {
        if (measurementLevel == MeasurementLevel.scale && (distributionType == DistributionType.NORMAL || distributionType == DistributionType.LOGNORMAL || distributionType == DistributionType.TRIANGULAR || distributionType == DistributionType.UNIFORM || distributionType == DistributionType.GAMMA || distributionType == DistributionType.BETA || distributionType == DistributionType.BERNOULLI || distributionType == DistributionType.WEIBULL || distributionType == DistributionType.RANGE || distributionType == DistributionType.EMPIRICAL || distributionType == DistributionType.EXPONENTIAL)) {
            return true;
        }
        if (measurementLevel == MeasurementLevel.ordinal && (distributionType == DistributionType.BINOMIAL || distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL || distributionType == DistributionType.POISSON || distributionType == DistributionType.EMPIRICAL)) {
            return true;
        }
        return measurementLevel == MeasurementLevel.nominal && distributionType == DistributionType.MULTINOMIAL;
    }

    static MeasurementLevel getMLevelOfDistribution(DistributionType distributionType) {
        if (distributionType == DistributionType.NORMAL || distributionType == DistributionType.LOGNORMAL || distributionType == DistributionType.TRIANGULAR || distributionType == DistributionType.UNIFORM || distributionType == DistributionType.GAMMA || distributionType == DistributionType.BETA || distributionType == DistributionType.BERNOULLI || distributionType == DistributionType.WEIBULL || distributionType == DistributionType.RANGE || distributionType == DistributionType.EXPONENTIAL) {
            return MeasurementLevel.scale;
        }
        if (distributionType == DistributionType.BINOMIAL || distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL || distributionType == DistributionType.POISSON) {
            return MeasurementLevel.ordinal;
        }
        if (distributionType == DistributionType.MULTINOMIAL) {
            return MeasurementLevel.nominal;
        }
        return MeasurementLevel.scale;
    }

    public static String getSyntaxForMLevel(MeasurementLevel measurementLevel) {
        if (measurementLevel == MeasurementLevel.scale) {
            return "NORMAL LNORMAL TRIANGULAR UNIFORM GAMMA WEIBULL BETA EXP";
        }
        if (measurementLevel == MeasurementLevel.ordinal) {
            return "BINOM NEGBIN POISSON";
        }
        if (measurementLevel == MeasurementLevel.nominal) {
            return "CATEGORICAL";
        }
        return "";
    }

    public static String[] getDistributionNames(MeasurementLevel measurementLevel) {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (measurementLevel == MeasurementLevel.scale) {
            return new String[]{resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL")};
        }
        if (measurementLevel == MeasurementLevel.ordinal) {
            return new String[]{resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON")};
        }
        if (measurementLevel == MeasurementLevel.nominal) {
            return new String[]{resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL")};
        }
        return new String[]{resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_RANGE"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI"), resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_FIXED")};
    }

    public static String[] getDistributionNames(SimulatedField simulatedField) {
        boolean bl;
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        int n = 18;
        int n2 = 0;
        String[] stringArray = null;
        if (simulatedField.getType() > 0) {
            stringArray = new String[3];
            stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NONE");
            stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL");
            stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_FIXED");
            return stringArray;
        }
        boolean bl2 = bl = simulatedField.getAllFitStats() != null && simulatedField.getAllFitStats().size() > 0;
        if (simulatedField.getDistributionType() == DistributionType.EMPIRICAL) {
            bl = true;
        }
        if (!bl) {
            n = 17;
        }
        stringArray = new String[n];
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NONE");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL");
        if (bl && simulatedField.getMeasurementLevel() != MeasurementLevel.nominal) {
            stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL");
        }
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_FIXED");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN_TRIAL");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_RANGE");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM");
        stringArray[n2++] = resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL");
        return stringArray;
    }

    public static HashMap<String, DistributionType> buildDistributionNameTypeMap() {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        HashMap<String, DistributionType> hashMap = new HashMap<String, DistributionType>();
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NONE"), DistributionType.NONE);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL"), DistributionType.NORMAL);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL"), DistributionType.BINOMIAL);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN"), DistributionType.NEGBIN);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN_TRIAL"), DistributionType.NEGBIN_TRIAL);
        hashMap.put("Negbinomial", DistributionType.NEGBIN);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL"), DistributionType.MULTINOMIAL);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL"), DistributionType.EMPIRICAL);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON"), DistributionType.POISSON);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL"), DistributionType.LOGNORMAL);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR"), DistributionType.TRIANGULAR);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM"), DistributionType.UNIFORM);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA"), DistributionType.GAMMA);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL"), DistributionType.WEIBULL);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA"), DistributionType.BETA);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL"), DistributionType.EXPONENTIAL);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_RANGE"), DistributionType.RANGE);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI"), DistributionType.BERNOULLI);
        hashMap.put(resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_FIXED"), DistributionType.FIXED);
        return hashMap;
    }

    public static HashMap<DistributionType, String> buildDistributionTypeNameMap() {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        HashMap<DistributionType, String> hashMap = new HashMap<DistributionType, String>();
        hashMap.put(DistributionType.NONE, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NONE"));
        hashMap.put(DistributionType.NORMAL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NORMAL"));
        hashMap.put(DistributionType.BINOMIAL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BINOMIAL"));
        hashMap.put(DistributionType.NEGBIN, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN"));
        hashMap.put(DistributionType.NEGBIN_TRIAL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_NEGBIN_TRIAL"));
        hashMap.put(DistributionType.MULTINOMIAL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_MULTINOMIAL"));
        hashMap.put(DistributionType.EMPIRICAL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EMPIRICAL"));
        hashMap.put(DistributionType.POISSON, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_POISSON"));
        hashMap.put(DistributionType.LOGNORMAL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_LOGNORMAL"));
        hashMap.put(DistributionType.TRIANGULAR, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_TRIANGULAR"));
        hashMap.put(DistributionType.UNIFORM, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_UNIFORM"));
        hashMap.put(DistributionType.GAMMA, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_GAMMA"));
        hashMap.put(DistributionType.WEIBULL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_WEIBULL"));
        hashMap.put(DistributionType.BETA, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BETA"));
        hashMap.put(DistributionType.EXPONENTIAL, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_EXPONENTIAL"));
        hashMap.put(DistributionType.RANGE, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_RANGE"));
        hashMap.put(DistributionType.BERNOULLI, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_BERNOULLI"));
        hashMap.put(DistributionType.FIXED, resourceBundle.getString("IDS_MC_SIMULATED_FIELD_DIST_FIXED"));
        return hashMap;
    }

    public static BufferedImage createPreviewImage(Object[][] objectArray, DistributionType distributionType, SimulatedField simulatedField, Hashtable<String, BaseMCSimulationTab.ScannedVar> hashtable) {
        return SimulationHelper.createPreviewImage(objectArray, distributionType, simulatedField, hashtable, null);
    }

    public static String createImageKey(int n) {
        return SimulationHelper.createImageKey(n, -1);
    }

    public static String createImageKey(int n, int n2) {
        String string = n2 >= 0 ? "" + n2 : STATIC_COLUMN_KEY;
        String string2 = n + ":" + string;
        return string2;
    }

    public static BufferedImage createPreviewImage(Object[][] objectArray, DistributionType distributionType, SimulatedField simulatedField, Hashtable<String, BaseMCSimulationTab.ScannedVar> hashtable, Dimension dimension) {
        BufferedImage bufferedImage = null;
        Dimension dimension2 = dimension = dimension != null ? dimension : new Dimension(120, 100);
        if (distributionType == DistributionType.NORMAL) {
            bufferedImage = DistributionImageUtil.getScaleImage(SimulationHelper.getBinData(simulatedField, hashtable), com.spss.vis.specification.statistic.DistributionType.NORMAL, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.BINOMIAL) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(SimulationHelper.getOriginalData(simulatedField, hashtable), DistributionType.BINOMIAL, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.NEGBIN) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(SimulationHelper.getOriginalData(simulatedField, hashtable), DistributionType.NEGBIN, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.NEGBIN_TRIAL) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(SimulationHelper.getOriginalData(simulatedField, hashtable), DistributionType.NEGBIN_TRIAL, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.NEGBIN_TRIAL) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(SimulationHelper.getOriginalData(simulatedField, hashtable), DistributionType.NEGBIN_TRIAL, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.MULTINOMIAL) {
            bufferedImage = DistributionImageUtil.getCategoricalImage(SimulationHelper.getOriginalData(simulatedField, hashtable), objectArray, dimension.width, dimension.height);
        } else if (distributionType == DistributionType.EMPIRICAL) {
            bufferedImage = simulatedField.getMeasurementLevel() == MeasurementLevel.scale ? DistributionImageUtil.getScaleImage(SimulationHelper.getBinData(simulatedField, hashtable), com.spss.vis.specification.statistic.DistributionType.UNIFORM, null, dimension.width, dimension.height) : DistributionImageUtil.getDiscreteImage(SimulationHelper.getOriginalData(simulatedField, hashtable), DistributionType.EMPIRICAL, null, SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.POISSON) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(SimulationHelper.getOriginalData(simulatedField, hashtable), DistributionType.POISSON, SimulationHelper.getOneParameter(objectArray, SimulationHelper.getParamNameIds(simulatedField)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.LOGNORMAL) {
            bufferedImage = DistributionImageUtil.getLogNormalImage(SimulationHelper.getBinData(simulatedField, hashtable), SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.TRIANGULAR) {
            bufferedImage = DistributionImageUtil.getTriangleImage(SimulationHelper.getBinData(simulatedField, hashtable), SimulationHelper.getThreeParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.UNIFORM) {
            bufferedImage = DistributionImageUtil.getScaleImage(SimulationHelper.getBinData(simulatedField, hashtable), com.spss.vis.specification.statistic.DistributionType.UNIFORM, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.GAMMA) {
            bufferedImage = DistributionImageUtil.getScaleImage(SimulationHelper.getBinData(simulatedField, hashtable), com.spss.vis.specification.statistic.DistributionType.GAMMA, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.WEIBULL) {
            bufferedImage = DistributionImageUtil.getWeibullImage(SimulationHelper.getBinData(simulatedField, hashtable), SimulationHelper.getThreeParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.BETA) {
            bufferedImage = DistributionImageUtil.getScaleImage(SimulationHelper.getBinData(simulatedField, hashtable), com.spss.vis.specification.statistic.DistributionType.BETA, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.EXPONENTIAL) {
            bufferedImage = DistributionImageUtil.getScaleImage(SimulationHelper.getBinData(simulatedField, hashtable), com.spss.vis.specification.statistic.DistributionType.EXPONENTIAL, SimulationHelper.getOneParameter(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.RANGE) {
            bufferedImage = DistributionImageUtil.getRangeImage(SimulationHelper.getBinData(simulatedField, hashtable), SimulationHelper.getThreeParameters(objectArray, SimulationHelper.getParamNameIds(simulatedField)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.BERNOULLI) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(SimulationHelper.getOriginalData(simulatedField, hashtable), DistributionType.BERNOULLI, SimulationHelper.getOneParameter(objectArray, SimulationHelper.getParamNameIds(simulatedField)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType != DistributionType.FIXED || simulatedField.getFormat().getFormatType().isNumericFormat()) {
            // empty if block
        }
        return bufferedImage;
    }

    public static BufferedImage createPreviewImage(Object[][] objectArray, DistributionType distributionType, SimulatedField simulatedField, BaseMCSimulationTab.ScannedVar scannedVar, Dimension dimension) {
        BufferedImage bufferedImage = null;
        Dimension dimension2 = dimension = dimension != null ? dimension : new Dimension(120, 100);
        if (distributionType == DistributionType.NORMAL) {
            bufferedImage = DistributionImageUtil.getScaleImage(scannedVar.getHistoBins(), com.spss.vis.specification.statistic.DistributionType.NORMAL, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.BINOMIAL) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(scannedVar.getValMap(), DistributionType.BINOMIAL, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.NEGBIN) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(scannedVar.getValMap(), DistributionType.NEGBIN, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.NEGBIN_TRIAL) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(scannedVar.getValMap(), DistributionType.NEGBIN_TRIAL, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.MULTINOMIAL) {
            bufferedImage = DistributionImageUtil.getCategoricalImage(scannedVar.getValMap(), objectArray, dimension.width, dimension.height);
        } else if (distributionType == DistributionType.EMPIRICAL) {
            bufferedImage = simulatedField.getMeasurementLevel() == MeasurementLevel.scale ? DistributionImageUtil.getScaleImage(scannedVar.getHistoBins(), com.spss.vis.specification.statistic.DistributionType.UNIFORM, null, dimension.width, dimension.height) : DistributionImageUtil.getDiscreteImage(scannedVar.getValMap(), DistributionType.EMPIRICAL, null, SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.POISSON) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(scannedVar.getValMap(), DistributionType.POISSON, SimulationHelper.getOneParameter(objectArray, SimulationHelper.getParamNameIds(distributionType)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.LOGNORMAL) {
            bufferedImage = DistributionImageUtil.getLogNormalImage(scannedVar.getHistoBins(), SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.TRIANGULAR) {
            bufferedImage = DistributionImageUtil.getTriangleImage(scannedVar.getHistoBins(), SimulationHelper.getThreeParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.UNIFORM) {
            bufferedImage = DistributionImageUtil.getScaleImage(scannedVar.getHistoBins(), com.spss.vis.specification.statistic.DistributionType.UNIFORM, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.GAMMA) {
            bufferedImage = DistributionImageUtil.getScaleImage(scannedVar.getHistoBins(), com.spss.vis.specification.statistic.DistributionType.GAMMA, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.WEIBULL) {
            bufferedImage = DistributionImageUtil.getWeibullImage(scannedVar.getHistoBins(), SimulationHelper.getThreeParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.BETA) {
            bufferedImage = DistributionImageUtil.getScaleImage(scannedVar.getHistoBins(), com.spss.vis.specification.statistic.DistributionType.BETA, SimulationHelper.getTwoParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.EXPONENTIAL) {
            bufferedImage = DistributionImageUtil.getScaleImage(scannedVar.getHistoBins(), com.spss.vis.specification.statistic.DistributionType.EXPONENTIAL, SimulationHelper.getOneParameter(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.RANGE) {
            bufferedImage = DistributionImageUtil.getRangeImage(scannedVar.getHistoBins(), SimulationHelper.getThreeParameters(objectArray, SimulationHelper.getParamNameIds(distributionType)), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.BERNOULLI) {
            bufferedImage = DistributionImageUtil.getDiscreteImage(scannedVar.getValMap(), DistributionType.BERNOULLI, SimulationHelper.getOneParameter(objectArray, SimulationHelper.getParamNameIds(distributionType)), SimulationHelper.getNumberOfParameters(simulatedField), dimension.width, dimension.height);
        } else if (distributionType == DistributionType.FIXED) {
            // empty if block
        }
        return bufferedImage;
    }

    public static String[][] getDefaulCells(SimulatedField simulatedField) {
        if (simulatedField != null) {
            return SimulationHelper.getDefaulCells(simulatedField.getDistributionType());
        }
        return new String[2][2];
    }

    private static Pair<String, String>[] getParamNames(SimulatedField simulatedField) {
        DistributionType distributionType = simulatedField.getDistributionType();
        return SimulationHelper.getParamNames(distributionType);
    }

    public static String[][] getDefaulCells(DistributionType distributionType) {
        Pair<String, String>[] pairArray;
        Pair<String, String>[] pairArray2 = pairArray = distributionType != null ? SimulationHelper.getParamNames(distributionType) : SimulationHelper.getParamNames(DistributionType.MULTINOMIAL);
        if (pairArray != null) {
            String[][] stringArray = new String[pairArray.length][2];
            for (int i = 0; i < pairArray.length; ++i) {
                stringArray[i][0] = (String)pairArray[i].getSecond();
            }
            return stringArray;
        }
        return new String[2][2];
    }

    public static Pair<String, String>[] getParamNames(DistributionType distributionType) {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (distributionType == DistributionType.NORMAL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"mean", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MEAN")), new Pair((Object)"stddev", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_STDDEV"))};
            return pairArray;
        }
        if (distributionType == DistributionType.BINOMIAL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"n", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_N")), new Pair((Object)"prob", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_PROB"))};
            return pairArray;
        }
        if (distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"thresh", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_THRESH")), new Pair((Object)"prob", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_PROB"))};
            return pairArray;
        }
        if (distributionType == DistributionType.MULTINOMIAL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"", (Object)"")};
            return pairArray;
        }
        if (distributionType == DistributionType.EMPIRICAL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"min", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MIN")), new Pair((Object)"max", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MAX")), new Pair((Object)"nbins", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_NBINS"))};
            return pairArray;
        }
        if (distributionType == DistributionType.POISSON) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"mean", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MEAN"))};
            return pairArray;
        }
        if (distributionType == DistributionType.LOGNORMAL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"a", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_A")), new Pair((Object)"b", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_B"))};
            return pairArray;
        }
        if (distributionType == DistributionType.TRIANGULAR) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"min", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MIN")), new Pair((Object)"max", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MAX")), new Pair((Object)"mode", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MODE"))};
            return pairArray;
        }
        if (distributionType == DistributionType.UNIFORM) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"min", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MIN")), new Pair((Object)"max", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MAX"))};
            return pairArray;
        }
        if (distributionType == DistributionType.GAMMA) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"shape", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SHAPE")), new Pair((Object)"scale", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SCALE"))};
            return pairArray;
        }
        if (distributionType == DistributionType.WEIBULL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"a", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_A")), new Pair((Object)"b", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_B")), new Pair((Object)"c", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_C"))};
            return pairArray;
        }
        if (distributionType == DistributionType.BETA) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"shape1", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SHAPE_1")), new Pair((Object)"shape2", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SHAPE_2"))};
            return pairArray;
        }
        if (distributionType == DistributionType.EXPONENTIAL) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"scale", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SCALE"))};
            return pairArray;
        }
        if (distributionType == DistributionType.RANGE) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"min", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MIN")), new Pair((Object)"max", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MAX")), new Pair((Object)"prob", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_PROB"))};
            return pairArray;
        }
        if (distributionType == DistributionType.BERNOULLI) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"prob", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_PROB"))};
            return pairArray;
        }
        if (distributionType == DistributionType.FIXED) {
            Pair[] pairArray = new Pair[]{new Pair((Object)"value", (Object)resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_VALUE"))};
            return pairArray;
        }
        return null;
    }

    private static String[] getParamNameIds(SimulatedField simulatedField) {
        return SimulationHelper.getParamNameIds(simulatedField.getDistributionType());
    }

    public static String[] getParamNameIds(DistributionType distributionType) {
        if (distributionType == DistributionType.NORMAL) {
            return new String[]{"mean", "stddev"};
        }
        if (distributionType == DistributionType.BINOMIAL) {
            return new String[]{"n", "prob"};
        }
        if (distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) {
            return new String[]{"thresh", "prob"};
        }
        if (distributionType == DistributionType.MULTINOMIAL) {
            return new String[]{""};
        }
        if (distributionType == DistributionType.EMPIRICAL) {
            return new String[]{"min", "max", "nbins"};
        }
        if (distributionType == DistributionType.POISSON) {
            return new String[]{"mean"};
        }
        if (distributionType == DistributionType.LOGNORMAL) {
            return new String[]{"a", "b"};
        }
        if (distributionType == DistributionType.TRIANGULAR) {
            return new String[]{"min", "max", "mode"};
        }
        if (distributionType == DistributionType.UNIFORM) {
            return new String[]{"min", "max"};
        }
        if (distributionType == DistributionType.GAMMA) {
            return new String[]{"shape", "scale"};
        }
        if (distributionType == DistributionType.WEIBULL) {
            return new String[]{"a", "b", "c"};
        }
        if (distributionType == DistributionType.BETA) {
            return new String[]{"shape1", "shape2"};
        }
        if (distributionType == DistributionType.EXPONENTIAL) {
            return new String[]{"scale"};
        }
        if (distributionType == DistributionType.RANGE) {
            return new String[]{"min", "max", "prob"};
        }
        if (distributionType == DistributionType.BERNOULLI) {
            return new String[]{"prob"};
        }
        if (distributionType == DistributionType.FIXED) {
            return new String[]{"value"};
        }
        return null;
    }

    static int getNumberOfParameters(SimulatedField simulatedField) {
        int n = 0;
        if (simulatedField != null) {
            if (simulatedField.getDistributionType() == DistributionType.MULTINOMIAL || simulatedField.getDistributionType() == DistributionType.POISSON || simulatedField.getDistributionType() == DistributionType.EXPONENTIAL || simulatedField.getDistributionType() == DistributionType.BERNOULLI || simulatedField.getDistributionType() == DistributionType.FIXED) {
                n = 1;
            }
            if (simulatedField.getDistributionType() == DistributionType.NORMAL || simulatedField.getDistributionType() == DistributionType.BINOMIAL || simulatedField.getDistributionType() == DistributionType.NEGBIN || simulatedField.getDistributionType() == DistributionType.NEGBIN_TRIAL || simulatedField.getDistributionType() == DistributionType.LOGNORMAL || simulatedField.getDistributionType() == DistributionType.UNIFORM || simulatedField.getDistributionType() == DistributionType.GAMMA || simulatedField.getDistributionType() == DistributionType.BETA || simulatedField.getDistributionType() == DistributionType.EMPIRICAL) {
                n = 2;
            }
            if (simulatedField.getDistributionType() == DistributionType.TRIANGULAR || simulatedField.getDistributionType() == DistributionType.RANGE || simulatedField.getDistributionType() == DistributionType.WEIBULL) {
                n = 3;
            }
        }
        return n;
    }

    private static Double[] getOneParameter(Object[][] objectArray, String[] stringArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Map<String, String> map = SimulationHelper.getStatParameterLangNameMap();
        for (Object[] objectArray2 : objectArray) {
            if (!objectArray2[0].equals(map.get(stringArray[0])) && !objectArray2[0].equals(stringArray[0])) continue;
            if (objectArray2[1] != null && ((String)objectArray2[1]).length() > 0) {
                arrayList.add(Double.valueOf(UIToolResUtil.removeLocale((String)((String)objectArray2[1]))));
                continue;
            }
            arrayList.add(null);
        }
        Object[][] objectArray3 = null;
        if (arrayList.size() > 0) {
            objectArray3 = new Double[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray3[i] = (Double)arrayList.get(i);
            }
        }
        return objectArray3;
    }

    private static Double[] getTwoParameters(Object[][] objectArray, String[] stringArray) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        Map<String, String> map = SimulationHelper.getStatParameterLangNameMap();
        Object[][] objectArray2 = objectArray;
        int n2 = objectArray2.length;
        for (n = 0; n < n2; ++n) {
            Object[] objectArray3 = objectArray2[n];
            if (objectArray3[0].equals(map.get(stringArray[0])) || objectArray3[0].equals(stringArray[0])) {
                if (objectArray3[1] != null && ((String)objectArray3[1]).length() > 0) {
                    arrayList.add(Double.valueOf(UIToolResUtil.removeLocale((String)((String)objectArray3[1]))));
                    continue;
                }
                arrayList.add(null);
                continue;
            }
            if (!objectArray3[0].equals(map.get(stringArray[1])) && !objectArray3[0].equals(stringArray[1])) continue;
            if (objectArray3[1] != null && ((String)objectArray3[1]).length() > 0) {
                arrayList2.add(Double.valueOf(UIToolResUtil.removeLocale((String)((String)objectArray3[1]))));
                continue;
            }
            arrayList2.add(null);
        }
        int n3 = Math.max(arrayList.size(), arrayList2.size());
        if (arrayList.size() > 0 && arrayList.size() < n3) {
            Double d = (Double)arrayList.get(0);
            for (n = arrayList.size(); n < n3; ++n) {
                arrayList.add(d);
            }
        } else if (arrayList2.size() > 0 && arrayList2.size() < n3) {
            Double d = (Double)arrayList2.get(0);
            for (n = arrayList2.size(); n < n3; ++n) {
                arrayList2.add(d);
            }
        }
        Double[] doubleArray = null;
        n = Math.min(arrayList.size(), arrayList2.size());
        if (n > 0) {
            doubleArray = new Double[2 * n];
            for (int i = 0; i < n; ++i) {
                doubleArray[2 * i] = (Double)arrayList.get(i);
                doubleArray[2 * i + 1] = (Double)arrayList2.get(i);
            }
        }
        return doubleArray;
    }

    private static Double[] getThreeParameters(Object[][] objectArray, String[] stringArray) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        Map<String, String> map = SimulationHelper.getStatParameterLangNameMap();
        Object[][] objectArray2 = objectArray;
        int n2 = objectArray2.length;
        for (n = 0; n < n2; ++n) {
            Object[] objectArray3 = objectArray2[n];
            if (objectArray3[0].equals(map.get(stringArray[0])) || objectArray3[0].equals(stringArray[0])) {
                if (objectArray3[1] != null && ((String)objectArray3[1]).length() > 0) {
                    arrayList.add(Double.valueOf(UIToolResUtil.removeLocale((String)((String)objectArray3[1]))));
                    continue;
                }
                arrayList.add(null);
                continue;
            }
            if (objectArray3[0].equals(map.get(stringArray[1])) || objectArray3[0].equals(stringArray[1])) {
                if (objectArray3[1] != null && ((String)objectArray3[1]).length() > 0) {
                    arrayList2.add(Double.valueOf(UIToolResUtil.removeLocale((String)((String)objectArray3[1]))));
                    continue;
                }
                arrayList2.add(null);
                continue;
            }
            if (!objectArray3[0].equals(map.get(stringArray[2])) && !objectArray3[0].equals(stringArray[2])) continue;
            if (objectArray3[1] != null && ((String)objectArray3[1]).length() > 0) {
                arrayList3.add(Double.valueOf(UIToolResUtil.removeLocale((String)((String)objectArray3[1]))));
                continue;
            }
            arrayList3.add(null);
        }
        int n3 = Math.max(arrayList.size(), arrayList2.size());
        n3 = Math.max(n3, arrayList3.size());
        if (arrayList.size() > 0 && arrayList.size() < n3) {
            Double d = (Double)arrayList.get(0);
            for (n = arrayList.size(); n < n3; ++n) {
                arrayList.add(d);
            }
        }
        if (arrayList2.size() > 0 && arrayList2.size() < n3) {
            Double d = (Double)arrayList2.get(0);
            for (n = arrayList2.size(); n < n3; ++n) {
                arrayList2.add(d);
            }
        }
        if (arrayList3.size() > 0 && arrayList3.size() < n3) {
            Double d = (Double)arrayList3.get(0);
            for (n = arrayList3.size(); n < n3; ++n) {
                arrayList3.add(d);
            }
        }
        Double[] doubleArray = null;
        n = Math.min(arrayList.size(), arrayList2.size());
        if ((n = Math.min(n, arrayList3.size())) > 0) {
            doubleArray = new Double[3 * n];
            for (int i = 0; i < n; ++i) {
                doubleArray[3 * i] = (Double)arrayList.get(i);
                doubleArray[3 * i + 1] = (Double)arrayList2.get(i);
                doubleArray[3 * i + 2] = (Double)arrayList3.get(i);
            }
        }
        return doubleArray;
    }

    private static Vector<BaseMCSimulationTab.HistoBin> getBinData(SimulatedField simulatedField, Hashtable<String, BaseMCSimulationTab.ScannedVar> hashtable) {
        BaseMCSimulationTab.ScannedVar scannedVar;
        Vector<BaseMCSimulationTab.HistoBin> vector = null;
        if (hashtable != null && (scannedVar = hashtable.get(simulatedField.getMappedName())) != null) {
            vector = scannedVar.getHistoBins();
        }
        return vector;
    }

    private static TreeMap<OBS, Double> getOriginalData(SimulatedField simulatedField, Hashtable<String, BaseMCSimulationTab.ScannedVar> hashtable) {
        BaseMCSimulationTab.ScannedVar scannedVar;
        TreeMap<OBS, Double> treeMap = null;
        if (hashtable != null && (scannedVar = hashtable.get(simulatedField.getMappedName())) != null) {
            treeMap = scannedVar.getValMap();
        }
        return treeMap;
    }

    public static PlanParseInfo selectAndParseSimulationPlan(BaseDialog baseDialog) {
        PlanParseInfo planParseInfo = null;
        String string = SimulationHelper.showOpenPlanFileDialog(baseDialog, baseDialog.getResString("IDS_MC_OPEN_SIMULATION_PLAN_FILE_TITLE"), baseDialog.getResString("IDS_MC_OUTPUT_SAVE_PLAN_FILE_FILTER"), baseDialog.getResString("IDS_MC_OUTPUT_SAVE_PLAN_FILE_FILTER_EXTN"));
        if (string.length() != 0) {
            PesFile pesFile;
            File file = null;
            boolean bl = false;
            if (string.length() != 0) {
                file = new File(string);
            }
            if ((pesFile = PES_Repository.getPesFile((String)string)) != null) {
                String string2 = PES_Repository.RetrieveFromPES((PesFile)pesFile);
                file = pesFile.getCacheFile();
                bl = true;
                if (file == null) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, string2, VersionInfo.getAppVersionString());
                }
            }
            if (string.length() != 0) {
                Object object;
                boolean bl2 = false;
                String string3 = PrefsMgr.getPrefsMgr().getTempPath();
                String string4 = file.getName();
                if (DataServerProxy.getDataProxy().isRemoteConnection()) {
                    object = UtilityProxy.getUtilProxy();
                    if (!object.copyServerFile(string, string3 + string4, false)) {
                        return planParseInfo;
                    }
                    file = new File(string3 + string4);
                    bl = true;
                }
                if (file.exists() && file.canRead()) {
                    planParseInfo = SimulationHelper.openPlanFile(file);
                }
                if (planParseInfo != null) {
                    object = new SimulationPlanHandler();
                    bl2 = ((SimulationPlanHandler)object).parsePlanFile(string3 + planParseInfo.getPlanXMLName());
                    if (bl2) {
                        planParseInfo.setSimulationPlanHandler((SimulationPlanHandler)object);
                        planParseInfo.setPath(string);
                        planParseInfo.setFile(file);
                    } else {
                        planParseInfo = null;
                        SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, baseDialog.getResString("IDS_MC_ERROR_INVALID_MODEL"), VersionInfo.getAppVersionString());
                    }
                } else {
                    planParseInfo = null;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, baseDialog.getResString("IDS_MC_ERROR_INVALID_MODEL"), VersionInfo.getAppVersionString());
                }
                if (bl) {
                    file.delete();
                }
            }
        }
        return planParseInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlanParseInfo openPlanFile(File file) {
        PlanParseInfo planParseInfo = new PlanParseInfo();
        String string = PrefsMgr.getPrefsMgr().getTempPath();
        boolean bl = true;
        if (file != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                JarInputStream jarInputStream = new JarInputStream(fileInputStream);
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                while (jarEntry != null) {
                    bl = true;
                    ByteBuffer byteBuffer = SimulationHelper.readEntry(jarInputStream);
                    File file2 = new File(string + jarEntry.getName());
                    file2.deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    ((OutputStream)fileOutputStream).write(byteBuffer.array());
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    SimulationHelper.checkRootName(planParseInfo, string, jarEntry.getName());
                    jarInputStream.closeEntry();
                    jarEntry = jarInputStream.getNextJarEntry();
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (planParseInfo == null || planParseInfo.getPlanXMLName().length() == 0) {
            bl = false;
        }
        return !bl ? null : planParseInfo;
    }

    private static ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        try {
            int n = jarInputStream.read(byArray, 0, 2048);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 2048);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private static void checkRootName(PlanParseInfo planParseInfo, String string, String string2) {
        Document document;
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(new FileInputStream(string + string2)), SchemaType.SCHEMA_NONE);
            if (document == null) {
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        Element element = document.getDocumentElement();
        if (PLAN_ROOT_NAME.equals(element.getNodeName())) {
            planParseInfo.setPlanXMLName(string2);
        } else {
            planParseInfo.setPMMLName(string2);
        }
    }

    public static String showOpenPlanFileDialog(BaseDialog baseDialog, String string, String[] stringArray, String[] stringArray2) {
        int n;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileSelectionMode(0);
        for (n = 1; n < stringArray.length; ++n) {
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(stringArray[n], stringArray2[n]));
        }
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(stringArray[0], stringArray2[0]));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        n = remoteFileChooser.showOpenDialog((Component)baseDialog);
        if (n == 0) {
            String string2 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            return string2;
        }
        return "";
    }

    public static String showSaveFileDialog(BaseDialog baseDialog, String string, String[] stringArray, String[] stringArray2) {
        return SimulationHelper.showSaveFileDialog(baseDialog, string, stringArray, stringArray2, RemoteFileChooser.ChooserOption.Generic);
    }

    public static String showSaveFileDialog(BaseDialog baseDialog, String string, String[] stringArray, String[] stringArray2, RemoteFileChooser.ChooserOption chooserOption) {
        int n;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, chooserOption, FileLocationsUtil.getOtherFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileSelectionMode(0);
        for (n = 1; n < stringArray.length; ++n) {
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(stringArray[n], stringArray2[n]));
        }
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(stringArray[0], stringArray2[0]));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        n = remoteFileChooser.showSaveDialog((Component)baseDialog);
        if (n == 0) {
            String string2 = remoteFileChooser.getSelectedFilePath();
            RefFileFilter refFileFilter = (RefFileFilter)remoteFileChooser.getFileFilter();
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            int n2 = string2.indexOf(refFileFilter.getExtension());
            if (n2 == -1) {
                string2 = string2.concat(refFileFilter.getExtension());
            }
            return string2;
        }
        return "";
    }

    public static String showOpenPlanFileDialog(BaseDialog baseDialog, String string, String string2, String string3) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileSelectionMode(0);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string3));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showOpenDialog((Component)baseDialog);
        if (n == 0) {
            String string4 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            return string4;
        }
        return "";
    }

    static void setupColumnWidths(JTable jTable, double[] dArray) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (dArray == null || tableColumnModel.getColumnCount() != dArray.length) {
            return;
        }
        int n = jTable.getPreferredScrollableViewportSize().width;
        int n2 = 0;
        for (double d : dArray) {
            tableColumnModel.getColumn(n2).setPreferredWidth((int)((double)n * d));
            ++n2;
        }
    }

    public static boolean validateFields(Vector<SimulatedField> vector, boolean bl) {
        if (vector.size() == 0) {
            return false;
        }
        int n = 0;
        for (SimulatedField simulatedField : vector) {
            ArrayList<Pair<String, String>> arrayList;
            DistributionType distributionType = simulatedField.getDistributionType();
            if (distributionType == DistributionType.EMPIRICAL) {
                ++n;
                continue;
            }
            if (distributionType != DistributionType.FIXED) {
                ++n;
            }
            if ((arrayList = simulatedField.getParametersFor(distributionType)) == null || arrayList.size() == 0) {
                return false;
            }
            int n2 = 0;
            double d = 0.0;
            String string = "";
            boolean bl2 = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                Pair<String, String> pair = arrayList.get(i);
                if (pair == null || pair.getFirst() == null && pair.getSecond() == null || (distributionType != DistributionType.MULTINOMIAL ? pair.getFirst() != null && ((String)pair.getFirst()).length() == 0 && pair.getSecond() != null && ((String)pair.getSecond()).length() == 0 : pair.getSecond() == null || ((String)pair.getSecond()).length() == 0)) continue;
                if (((String)pair.getFirst()).length() > 0 && (pair.getSecond() == null || ((String)pair.getSecond()).length() == 0)) {
                    if (distributionType == DistributionType.RANGE) continue;
                    return false;
                }
                if (pair.getSecond() != null && distributionType != DistributionType.FIXED && SimulationHelper.isParamValueValid(distributionType, (String)pair.getFirst(), Double.parseDouble(UIToolResUtil.removeLocale((String)((String)pair.getSecond())))).length() > 0) {
                    return false;
                }
                if (distributionType == DistributionType.MULTINOMIAL || distributionType == DistributionType.RANGE && ((String)pair.getFirst()).equals("prob")) {
                    if (distributionType == DistributionType.MULTINOMIAL && !bl2) {
                        Vector<Double> vector2 = simulatedField.getProbsForCategory((String)pair.getFirst());
                        bl2 = vector2 != null && vector2.size() > 1;
                    }
                    d += Double.parseDouble(UIToolResUtil.removeLocale((String)((String)pair.getSecond())));
                }
                ++n2;
            }
            if (distributionType == DistributionType.MULTINOMIAL && n2 == 0) {
                return false;
            }
            if (distributionType != DistributionType.MULTINOMIAL && distributionType != DistributionType.RANGE) continue;
            if (distributionType == DistributionType.RANGE) {
                boolean bl3 = bl2 = simulatedField.getAllRangeProbs() != null && simulatedField.getAllRangeProbs().size() > 0;
            }
            if (!(Math.abs(d - 1.0) > sProbTolerance) || bl2) continue;
            return false;
        }
        return !bl || n != 0;
    }

    static void deleteIterationFrom(SimulatedField simulatedField) {
        String[] stringArray = SimulationHelper.getParamNameIds(simulatedField);
        DistributionType distributionType = simulatedField.getDistributionType();
        ArrayList<Pair<String, String>> arrayList = simulatedField.getParametersFor(distributionType);
        ArrayList<Pair<String, String>> arrayList2 = new ArrayList<Pair<String, String>>();
        if (distributionType != DistributionType.FIXED && distributionType != DistributionType.MULTINOMIAL && distributionType != DistributionType.RANGE) {
            block0: for (String string : stringArray) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Pair<String, String> pair = arrayList.get(i);
                    if (!string.equals(pair.getFirst())) continue;
                    arrayList2.add((Pair<String, String>)new Pair((Object)string, pair.getSecond()));
                    continue block0;
                }
            }
            simulatedField.removeAllParameters();
            simulatedField.addParameter(distributionType, arrayList2);
        } else if (distributionType == DistributionType.FIXED) {
            arrayList2.add(new Pair(arrayList.get(0).getFirst(), arrayList.get(0).getSecond()));
            simulatedField.removeAllParameters();
            simulatedField.addParameter(distributionType, arrayList2);
        } else if (distributionType == DistributionType.MULTINOMIAL) {
            ArrayList<Pair<String, Vector<Double>>> arrayList3 = simulatedField.getAllCatsAndProbs();
            for (int i = 0; i < arrayList3.size(); ++i) {
                Pair<String, Vector<Double>> pair = arrayList3.get(i);
                String string = (String)pair.getFirst();
                double d = (Double)((Vector)pair.getSecond()).get(0);
                String string2 = String.valueOf(d);
                arrayList2.add((Pair<String, String>)new Pair((Object)string, (Object)string2));
                Vector<Double> vector = new Vector<Double>();
                vector.add(d);
                simulatedField.addOneCatAndProbs(string, vector);
            }
            simulatedField.removeAllParameters();
            simulatedField.addParameter(distributionType, arrayList2);
        } else if (distributionType == DistributionType.RANGE) {
            Vector<Pair<Double, Double>> vector = simulatedField.getAllRangeMinMax();
            Vector<Vector<Double>> vector2 = simulatedField.getAllRangeProbs();
            for (int i = 0; i < vector.size(); ++i) {
                Pair<Double, Double> pair = vector.get(i);
                double d = vector2.get(i).get(0);
                arrayList2.add((Pair<String, String>)new Pair((Object)"min", (Object)String.valueOf(pair.getFirst())));
                arrayList2.add((Pair<String, String>)new Pair((Object)"max", (Object)String.valueOf(pair.getSecond())));
                arrayList2.add((Pair<String, String>)new Pair((Object)"prob", (Object)String.valueOf(d)));
                Vector<Double> vector3 = new Vector<Double>();
                vector3.add(d);
                simulatedField.addOnePairRangeMinMax(pair, vector3);
            }
            simulatedField.removeAllParameters();
            simulatedField.addParameter(distributionType, arrayList2);
        }
    }

    public static String isParamValueValid(DistributionType distributionType, String string, double d) {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String string2 = resourceBundle.getString("IDS_MC_INVALID_PARAMETER_VALUE_MIN");
        String string3 = resourceBundle.getString("IDS_MC_INVALID_PARAMETER_VALUE_MIN_MAX");
        String string4 = resourceBundle.getString("IDS_MC_INVALID_PARAMETER_VALUE_NONE_NEG");
        String string5 = "";
        if (distributionType == DistributionType.NORMAL) {
            if (string.equals("mean")) {
                return string5;
            }
            if (string.equals("stddev")) {
                if (d > 0.0) {
                    return string5;
                }
                return string2;
            }
        } else if (distributionType == DistributionType.BINOMIAL) {
            if (string.equals("n")) {
                if (d > 0.0) {
                    return string5;
                }
                return string2;
            }
            if (string.equals("prob")) {
                if (d >= 0.0 && d <= 1.0) {
                    return string5;
                }
                return String.format(ComponentState.getSPSSLocale(), string3, "0", "1");
            }
        } else if (distributionType == DistributionType.NEGBIN || distributionType == DistributionType.NEGBIN_TRIAL) {
            if (string.equals("thresh")) {
                if (d > 0.0) {
                    return string5;
                }
                return string2;
            }
            if (string.equals("prob")) {
                if (d >= 0.0 && d <= 1.0) {
                    return string5;
                }
                return String.format(ComponentState.getSPSSLocale(), string3, "0", "1");
            }
        } else if (distributionType == DistributionType.MULTINOMIAL) {
            if (string.equals("prob")) {
                if (d >= 0.0 && d <= 1.0) {
                    return string5;
                }
                return String.format(ComponentState.getSPSSLocale(), string3, "0", "1");
            }
        } else if (distributionType == DistributionType.POISSON) {
            if (string.equals("mean")) {
                if (d >= 0.0) {
                    return string5;
                }
                return string4;
            }
        } else if (distributionType == DistributionType.LOGNORMAL) {
            if (string.equals("a") || string.equals("b")) {
                if (d >= 0.0) {
                    return string5;
                }
                return string4;
            }
        } else if (distributionType == DistributionType.GAMMA) {
            if (string.equals("shape") || string.equals("scale")) {
                if (d >= 0.0) {
                    return string5;
                }
                return string4;
            }
        } else if (distributionType == DistributionType.WEIBULL) {
            if (string.equals("a") || string.equals("b")) {
                if (d >= 0.0) {
                    return string5;
                }
                return string4;
            }
        } else if (distributionType == DistributionType.BETA) {
            if (string.equals("shape1") || string.equals("shape2")) {
                if (d >= 0.0) {
                    return string5;
                }
                return string4;
            }
        } else if (distributionType == DistributionType.EXPONENTIAL) {
            if (string.equals("scale")) {
                if (d > 0.0) {
                    return string5;
                }
                return string2;
            }
        } else if (distributionType == DistributionType.RANGE) {
            if (string.equals("prob")) {
                if (d >= 0.0 && d <= 1.0) {
                    return string5;
                }
                return String.format(ComponentState.getSPSSLocale(), string3, "0", "1");
            }
        } else if (distributionType == DistributionType.BERNOULLI && string.equals("prob")) {
            if (d >= 0.0 && d <= 1.0) {
                return string5;
            }
            return String.format(ComponentState.getSPSSLocale(), string3, "0", "1");
        }
        return string5;
    }

    public static String validateFilePath(Component component, JTextField jTextField) {
        String string = FileValidator.validatePath(component, jTextField.getText(), DataServerProxy.getDataProxy().isRemoteConnection());
        if (string != null) {
            jTextField.requestFocus();
        }
        return string;
    }

    public static boolean showPathError(Component component, String string) {
        return FileValidator.showMessage(component, string);
    }

    static String getTransFileNamePath() {
        String string = SimulationHelper.getOtherFilePath();
        return "*" + SimulationHelper.getFileSeparator(string) + TEMP_TRANSFORMATION_XML_NAME;
    }

    static String getDefaultSimplanPath(boolean bl) {
        String string = SimulationHelper.getOtherFilePath();
        char c = SimulationHelper.getFileSeparator(string);
        RemoteFileStatus.FileNodeStatus fileNodeStatus = RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE;
        if (bl) {
            return "*" + c + PLAN_ROOT_NAME + ".splan";
        }
        if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
            Object object;
            File file = new File(string);
            boolean bl2 = false;
            boolean bl3 = true;
            if (!file.exists()) {
                bl3 = false;
            } else if (file.isDirectory()) {
                if (!file.canWrite()) {
                    bl2 = true;
                }
                if (!bl2) {
                    object = RemoteFileSysUtil.getRemoteFileSysUtil();
                    fileNodeStatus = object.validateFile(string).getFileStatus();
                }
            }
            if (!(!bl2 && string.length() != 0 && fileNodeStatus != RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY && fileNodeStatus != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST || (file = new File(string = FileLocationsUtil.readOtherFilesDirectoryPathFromPreferences())).exists() && !SimulationHelper.isPathReadOnly(string) || (string = FileLocationsUtil.getLocalAppdataPath()) != null && string.length() != 0)) {
                return "";
            }
            string = string + c;
            object = "SimulationPlan_1";
            String string2 = FileValidator.validatePath(null, string + (String)object + ".splan", DataServerProxy.getDataProxy().isRemoteConnection());
            int n = 2;
            while (string2 != null && string2.length() > 0) {
                object = "SimulationPlan_" + n;
                string2 = FileValidator.validatePath(null, string + (String)object + ".splan", DataServerProxy.getDataProxy().isRemoteConnection());
                ++n;
            }
            return string + (String)object + ".splan";
        }
        return "";
    }

    private static boolean isPathReadOnly(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.isDirectory()) {
            if (!file.canWrite()) {
                bl = true;
            }
            if (!bl) {
                RemoteFileSysUtil remoteFileSysUtil = RemoteFileSysUtil.getRemoteFileSysUtil();
                RemoteFileStatus remoteFileStatus = remoteFileSysUtil.validateFile(string);
                bl = remoteFileStatus.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY || remoteFileStatus.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
            }
        }
        return bl;
    }

    static char getFileSeparator(String string) {
        char c = string.indexOf(47) >= 0 ? (char)'/' : '\\';
        return c;
    }

    public static int getIndexOfFieldWithIterations(Vector<SimulatedField> vector) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            SimulatedField simulatedField = vector.get(i);
            if (!SimulationHelper.hasInteration(simulatedField)) continue;
            return i;
        }
        return n;
    }

    public static boolean hasInteration(SimulatedField simulatedField) {
        Vector<Double> vector;
        Vector<Vector<Double>> vector2;
        Vector<Double> vector3;
        if (simulatedField == null) {
            return false;
        }
        DistributionType distributionType = simulatedField.getDistributionType();
        ArrayList<Pair<String, String>> arrayList = simulatedField.getParametersFor(distributionType);
        if (distributionType != DistributionType.MULTINOMIAL && distributionType != DistributionType.RANGE) {
            int n = SimulationHelper.getNumberOfParameters(simulatedField);
            if (arrayList != null && arrayList.size() > n) {
                return true;
            }
        } else if (distributionType == DistributionType.MULTINOMIAL ? arrayList != null && arrayList.size() > 0 && (vector3 = simulatedField.getProbsForCategory((String)arrayList.get(0).getFirst())) != null && vector3.size() > 1 : arrayList != null && arrayList.size() > 0 && (vector2 = simulatedField.getAllRangeProbs()) != null && vector2.size() > 0 && (vector = vector2.get(0)) != null && vector.size() > 1) {
            return true;
        }
        return false;
    }

    private static Map<String, String> getStatParameterLangNameMap() {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mean", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MEAN"));
        hashMap.put("stddev", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_STDDEV"));
        hashMap.put("n", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_N"));
        hashMap.put("prob", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_PROB"));
        hashMap.put("thresh", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_THRESH"));
        hashMap.put("min", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MIN"));
        hashMap.put("max", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MAX"));
        hashMap.put("nbins", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_NBINS"));
        hashMap.put("mean", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MEAN"));
        hashMap.put("a", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_A"));
        hashMap.put("b", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_B"));
        hashMap.put("c", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_C"));
        hashMap.put("mode", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_MODE"));
        hashMap.put("shape", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SHAPE"));
        hashMap.put("shape1", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SHAPE_1"));
        hashMap.put("shape2", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SHAPE_2"));
        hashMap.put("scale", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_SCALE"));
        hashMap.put("value", resourceBundle.getString("IDS_MC_SIMULATED_PARAM_NAME_VALUE"));
        return hashMap;
    }

    static String getOtherFilePath() {
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            return FileLocationsUtil.getDataFilesDirectoryPath();
        }
        return FileLocationsUtil.getOtherFilesDirectoryPath();
    }

    private static String[] createOutputFormatArray() {
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        return resourceBundle.getStringArray("IDS_MC_OUTPUT_FORMAT_TABLE_FORMAT_COMBO");
    }

    static class PreviewCanvas
    extends JPanel {
        private BufferedImage mPrevImage;

        public PreviewCanvas(BufferedImage bufferedImage) {
            this.mPrevImage = bufferedImage;
        }

        public void setImage(BufferedImage bufferedImage) {
            this.mPrevImage = bufferedImage;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.mPrevImage != null) {
                graphics.drawImage(this.mPrevImage, 0, 0, null);
            }
        }
    }

    public static class PlanParseInfo {
        private String mPlanXMLName = "";
        private String mPMMLName = "";
        private SimulationPlanHandler mSimulationPlanHandler;
        private String mPath;
        private File mFile;

        private PlanParseInfo() {
        }

        public void setPlanXMLName(String string) {
            this.mPlanXMLName = string;
        }

        public void setPMMLName(String string) {
            this.mPMMLName = string;
        }

        public String getPlanXMLName() {
            return this.mPlanXMLName;
        }

        public String getPMMLName() {
            return this.mPMMLName;
        }

        public SimulationPlanHandler getSimulationPlanHandler() {
            return this.mSimulationPlanHandler;
        }

        public void setSimulationPlanHandler(SimulationPlanHandler simulationPlanHandler) {
            this.mSimulationPlanHandler = simulationPlanHandler;
        }

        public String getPath() {
            return this.mPath;
        }

        public void setPath(String string) {
            this.mPath = string;
        }

        public void setFile(File file) {
            this.mFile = file;
        }

        public File getFile() {
            return this.mFile;
        }

        public String getModifiedDateText() {
            long l = this.mFile.lastModified();
            Date date = new Date(l);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
            String string = simpleDateFormat.format(date);
            return string;
        }
    }

    public static class HelpPanel
    extends JPanel {
        private JTextArea mInfoDesc;
        private JLabel mHelpIconLabel;

        public HelpPanel(Font font) {
            this(font, PanelFactory.PanelType.xaxis);
        }

        public HelpPanel(Font font, PanelFactory.PanelType panelType) {
            this(font, panelType, false, true);
        }

        public HelpPanel(Font font, PanelFactory.PanelType panelType, boolean bl, boolean bl2) {
            this.setLayout(new GridBagLayout());
            if (bl2) {
                this.setBorder(new TitledBorder(""));
            }
            this.initLayout(font, panelType, bl);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                    HelpPanel.this.getAccessibleContext().setAccessibleName("");
                    HelpPanel.this.getAccessibleContext().setAccessibleDescription(HelpPanel.this.mInfoDesc.getText());
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                    HelpPanel.this.getAccessibleContext().setAccessibleName("");
                    HelpPanel.this.getAccessibleContext().setAccessibleDescription("");
                }
            });
        }

        protected void initLayout(Font font, PanelFactory.PanelType panelType, boolean bl) {
            this.mInfoDesc = new JTextArea();
            this.mInfoDesc.setOpaque(false);
            this.mInfoDesc.setFont(font);
            this.mInfoDesc.setLineWrap(true);
            this.mInfoDesc.setWrapStyleWord(true);
            this.mInfoDesc.setText("");
            this.mInfoDesc.setFocusable(false);
            this.mHelpIconLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            int n3 = 0;
            int n4 = 0;
            if (panelType == PanelFactory.PanelType.xaxis) {
                n3 = 1;
                n4 = 0;
            } else {
                n3 = 0;
                n4 = 1;
                this.mHelpIconLabel.setHorizontalAlignment(0);
            }
            if (!bl) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, 0, 0, 1, 1, n, null);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(this, this.mHelpIconLabel, gridBagConstraints, n3, n4, 1, 1, n, null);
            } else {
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(this, this.mHelpIconLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, n3, n4, 1, 1, n, null);
            }
        }

        public void setHelpForDistributionType(DistributionType distributionType) {
            if (distributionType != null) {
                this.mInfoDesc.setText(SimulationHelper.getDistributionHelpText(distributionType));
                this.mHelpIconLabel.setIcon(SimulationHelper.getDistributionHelpIcon(distributionType));
                this.mInfoDesc.setEnabled(true);
                this.mHelpIconLabel.setEnabled(true);
            } else {
                this.mInfoDesc.setText("");
                this.mInfoDesc.setEnabled(false);
                this.mHelpIconLabel.setIcon(null);
                this.mHelpIconLabel.setEnabled(false);
            }
            String string = SimulationHelper.getDistributionHelpIconTooltip(distributionType);
        }

        public void setHelpTextAndIcon(String string, ImageIcon imageIcon) {
            this.setHelpTextAndIcon(string, imageIcon, -1);
        }

        public void setHelpTextAndIcon(String string, ImageIcon imageIcon, int n) {
            this.mInfoDesc.setText(string);
            if (n > 0) {
                this.mInfoDesc.setRows(2);
            }
            this.mHelpIconLabel.setIcon(imageIcon);
            if (string.length() == 0) {
                this.mInfoDesc.setEnabled(false);
            } else {
                this.mInfoDesc.setEnabled(true);
            }
            if (imageIcon == null) {
                this.mHelpIconLabel.setEnabled(false);
            } else {
                this.mHelpIconLabel.setEnabled(true);
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            rectangle.grow(-4, -4);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static interface ParametersPanelCallback {
        public void processDistributionSelection(Object var1, DistributionType var2);

        public void processTableUpdate(SimulatedField var1);

        public Hashtable<String, BaseMCSimulationTab.ScannedVar> getScannedVarMap();

        public Map<String, BufferedImage> getImageMap();
    }

    public static enum DistributionType {
        NONE,
        NORMAL,
        BINOMIAL,
        NEGBIN,
        NEGBIN_TRIAL,
        MULTINOMIAL,
        EMPIRICAL,
        POISSON,
        LOGNORMAL,
        TRIANGULAR,
        UNIFORM,
        GAMMA,
        WEIBULL,
        BETA,
        EXPONENTIAL,
        RANGE,
        BERNOULLI,
        FIXED;


        public String toString() {
            switch (this) {
                case NONE: {
                    return "";
                }
                case NORMAL: {
                    return "Normal";
                }
                case BINOMIAL: {
                    return "Binomia";
                }
                case NEGBIN: {
                    return "NegBin";
                }
                case NEGBIN_TRIAL: {
                    return "NegBin";
                }
                case MULTINOMIAL: {
                    return "Categorical";
                }
                case EMPIRICAL: {
                    return "Empirical";
                }
                case POISSON: {
                    return "Poisson";
                }
                case LOGNORMAL: {
                    return "LogNormal";
                }
                case TRIANGULAR: {
                    return "Triangular";
                }
                case UNIFORM: {
                    return "Uniform";
                }
                case GAMMA: {
                    return "Gamma";
                }
                case WEIBULL: {
                    return "Weibull";
                }
                case BETA: {
                    return "Beta";
                }
                case EXPONENTIAL: {
                    return "Exponential";
                }
                case BERNOULLI: {
                    return "Bernoulli";
                }
                case FIXED: {
                    return "Fixed";
                }
                case RANGE: {
                    return "Range";
                }
            }
            return "";
        }
    }
}

