/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.MC.CorrelationEntry;
import com.spss.java_client.ui.dialogs.MC.ModelPMMLFileHandler;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.MC.res.MCResBundle;
import com.spss.java_client.ui.dialogs.base.graphs.IMatrixListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImageEx;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroupEx;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class SimulationGatingDlg
extends BaseGatingDialog
implements IMatrixListener {
    public static final String LOAD_MODEL_RESOURCE_KEY = "IDS_SIMULATION_LOAD_MODEL_LABEL";
    public static final String MANUALLY_RESOURCE_KEY = "IDS_SIMULATION_MANUALLY_LABEL";
    public static final String LOAD_PLAN_RESOURCE_KEY = "IDS_SIMULATION_LOAD_PLAN_LABEL";
    public static final String CREATE_DATA_RESOURCE_KEY = "IDS_SIMULATION_CREATE_DATA_LABEL";
    static String SIMULATION_GATING_SELECTION = "SIMULATION_GATING_SELECTION";
    static String MANUALLY_TYPE = "SIM_manually_typed";
    static String LOAD_PMML_MODEL = "SIM_LOAD_PMML";
    static String LOAD_PLAN_TYPE = "SIM_LOAD_PLAN";
    static String CREATE_DATA_WITHOUT_MODEL = "CREATE_DATA_WITHOUT_MODEL";
    private MatrixImagesGroupEx mControlChartsImageGroup;
    private MatrixImageEx mManuallyTypedImage;
    private JLabel mManualLabel;
    private MatrixImageEx mLoadModelImage;
    private JLabel mLoadModelLabel;
    private MatrixImageEx mLoadPlanImage;
    private JLabel mLoadPlanLabel;
    private JCheckBox mOpenAdvanced;
    private MatrixImageEx mCreateDataImage;
    private JLabel mCreateDataLabel;
    private static final Border WHITE_BORDER = BorderFactory.createLineBorder(Color.WHITE, 4);
    private static final Border SELECT_BORDER = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 4);
    private SimulationPlanHandler mSimHandler;
    private ModelPMMLFileHandler mPMMLModelHandler = null;
    private boolean mCanDispose = false;
    private String mNextActionKey = "";
    private HelpPanel mHelpPanel;

    public SimulationGatingDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, MCResBundle.getDefaultResourceBundleName(), MCResBundle.getImageFolder());
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        StringBuffer stringBuffer = new StringBuffer("");
        if (iSpssDataSrc.getDatasetName().length() == 0) {
            String string = SpssMgr.getSpssMgr().getNextFreeDatasetName();
            stringBuffer.append("\nDATASET NAME " + string + ".");
            boolean bl = SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
        }
        this.setTitle(this.getResString("IDS_SIMULATION_GATING_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.mCanDispose = false;
        this.mNextActionKey = "";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_modelsource";
    }

    @Override
    public String getIActionKey() {
        return "analyze_simulation_gating_dialog";
    }

    @Override
    public boolean continuePressed() {
        String string = null;
        if (this.mLoadModelImage.isSelected()) {
            string = "";
            String[] stringArray = this.getResStringArray("IDS_MC_XML_FILE_FILTER_ARRY");
            String[] stringArray2 = this.getResStringArray("IDS_MC_XML_FILE_EXT_ARRY");
            String string2 = SimulationHelper.showOpenPlanFileDialog((BaseDialog)this, this.getResString(LOAD_MODEL_RESOURCE_KEY), stringArray, stringArray2);
            if (string2.length() != 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.mPMMLModelHandler = new ModelPMMLFileHandler(string2);
                String string3 = this.mPMMLModelHandler.getErrorMessage();
                if (string3.length() == 0) {
                    this.getDialogDataModel().putObject("PMMLModelHandler", this.mPMMLModelHandler);
                    this.getDialogDataModel().putString("SimulationModelPMMLPath", string2);
                    this.getDialogDataModel().putObject("SimulationPlanHandler", null);
                    this.getDialogDataModel().putString("SimulationPlanPath", null);
                    string = "utilities_monte_carlo_simulation_model_dialog";
                    this.getDialogDataModel().putInteger("LAST_SELECTED_TAB", 1);
                } else {
                    String string4 = this.getResString(string3);
                    if (string4.length() == 0) {
                        string4 = string3;
                    } else if (this.mPMMLModelHandler.getModelTypeName().length() > 0) {
                        string4 = this.mPMMLModelHandler.getModelTypeName() + " " + string4;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string4, VersionInfo.getAppVersionString());
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else if (this.mManuallyTypedImage.isSelected()) {
            string = "utilities_monte_carlo_simulation_dialog";
            this.getDialogDataModel().putObject("SimulationPlanHandler", null);
            this.getDialogDataModel().putString("SimulationPlanPath", null);
            this.getDialogDataModel().putObject("PMMLModelHandler", null);
            this.getDialogDataModel().putString("SimulationModelPMMLPath", null);
            this.getDialogDataModel().putInteger("LAST_SELECTED_TAB", 0);
        } else if (this.mLoadPlanImage.isSelected()) {
            string = "";
            SimulationHelper.PlanParseInfo planParseInfo = SimulationHelper.selectAndParseSimulationPlan(this);
            if (planParseInfo != null) {
                boolean bl;
                ArrayList<SimulationPlanHandler.ModelFile> arrayList;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.mSimHandler = planParseInfo.getSimulationPlanHandler();
                ArrayList<CorrelationEntry> arrayList2 = this.mSimHandler.getCorrelationMatrix();
                this.getDialogDataModel().putObject("SimulationPlanHandler", this.mSimHandler);
                this.getDialogDataModel().putString("SimulationPlanPath", planParseInfo.getPath());
                this.getDialogDataModel().putString("SimulationPlanModifiedDateText", planParseInfo.getModifiedDateText());
                this.getDialogDataModel().putObject("PMMLModelHandler", null);
                this.getDialogDataModel().putString("SimulationModelPMMLPath", null);
                string = !this.mOpenAdvanced.isSelected() ? "utilities_monte_carlo_simulation_simple_model_dialog" : ((arrayList = this.mSimHandler.getModelFiles()) == null || arrayList.size() == 0 ? "utilities_monte_carlo_simulation_create_data_dialog" : (!(bl = arrayList.get(0).isIsCustomModel()) ? "utilities_monte_carlo_simulation_model_dialog" : "utilities_monte_carlo_simulation_dialog"));
                this.getDialogDataModel().putInteger("LAST_SELECTED_TAB", this.mOpenAdvanced.isSelected() ? 1 : 0);
                if (this.mSimHandler != null && this.mSimHandler.isCrossTabUsed() && this.mOpenAdvanced.isSelected()) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_MC_PLAN_WITH_CONTIGENCY_WARNING"), VersionInfo.getAppVersionString());
                }
            }
        } else if (this.mCreateDataImage.isSelected()) {
            string = "utilities_monte_carlo_simulation_create_data_dialog";
            this.getDialogDataModel().putObject("SimulationPlanHandler", null);
            this.getDialogDataModel().putString("SimulationPlanPath", null);
            this.getDialogDataModel().putObject("PMMLModelHandler", null);
            this.getDialogDataModel().putString("SimulationModelPMMLPath", null);
            this.getDialogDataModel().putInteger("LAST_SELECTED_TAB", 0);
        }
        if (string != null && string.length() > 0) {
            this.mNextActionKey = string;
            this.mCanDispose = true;
        } else {
            this.mCanDispose = false;
            this.mNextActionKey = "";
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        return this.mCanDispose;
    }

    @Override
    public String getNextProcDlgActionKey() {
        return this.mNextActionKey;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    public void matrixImageEvent(IMatrixListener.EventType eventType, int n) {
        if (eventType == IMatrixListener.EventType.selectionChange) {
            if (n == 2) {
                this.mOpenAdvanced.setEnabled(true);
            } else {
                this.mOpenAdvanced.setEnabled(false);
            }
        }
        if (eventType == IMatrixListener.EventType.doubleClick) {
            this.mContinueAction.actionPerformed(new ActionEvent(this, 1, "launch"));
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        int n2 = 10;
        int n3 = DialogUtil.getGroupBoxInnerMargin() + 2;
        Insets insets = new Insets(n3, n3, n3, n3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mHelpPanel, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        gridBagConstraints.fill = 0;
        insets.set(n3, n3, 0, n3 * 5);
        DialogUtil.addUsingGBL(jPanel, this.mLoadModelLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(0, n3, n3 * 2, n3 * 5);
        DialogUtil.addUsingGBL(jPanel, this.mLoadModelImage, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        insets.set(n3, n3 * 5, 0, n3);
        DialogUtil.addUsingGBL(jPanel, this.mManualLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        insets.set(0, n3 * 5, n3 * 2, n3);
        DialogUtil.addUsingGBL(jPanel, this.mManuallyTypedImage, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        insets.set(n3 * 2, n3, 0, n3 * 5);
        DialogUtil.addUsingGBL(jPanel, this.mLoadPlanLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        insets.set(0, n3, 0, n3 * 5);
        DialogUtil.addUsingGBL(jPanel, this.mLoadPlanImage, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        insets.set(0, n3, n3 * 4, n3 * 5);
        DialogUtil.addUsingGBL(jPanel, this.mOpenAdvanced, gridBagConstraints, 0, 5, 1, 1, n2, insets);
        insets.set(n3 * 2, n3 * 5, 0, n3);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDataLabel, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        insets.set(0, n3 * 5, 0, n3);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDataImage, gridBagConstraints, 1, 4, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getEmptyPanel(""), gridBagConstraints, 0, 6, 2, 1, n2, insets);
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        this.mControlChartsImageGroup = new MatrixImagesGroupEx();
        this.mLoadModelImage = new MatrixImageEx(this.getResImageURL("IDS_SIMULATION_LOAD_MODEL_IMAGE"));
        this.mLoadModelLabel = DialogUtil.createLabel(this, LOAD_MODEL_RESOURCE_KEY);
        this.mLoadModelLabel.setLabelFor(this.mLoadModelImage);
        this.mManuallyTypedImage = new MatrixImageEx(this.getResImageURL("IDS_SIMULATION_MANUALLY_IMAGE"));
        this.mManualLabel = DialogUtil.createLabel(this, MANUALLY_RESOURCE_KEY);
        this.mManualLabel.setLabelFor(this.mManuallyTypedImage);
        this.mLoadPlanImage = new MatrixImageEx(this.getResImageURL("IDS_SIMULATION_LOAD_PLAN_IMAGE"));
        this.mLoadPlanLabel = DialogUtil.createLabel(this, LOAD_PLAN_RESOURCE_KEY);
        this.mLoadPlanLabel.setLabelFor(this.mLoadPlanImage);
        this.mOpenAdvanced = DialogUtil.createCheckBox(this, "IDS_SIMULATION_GATING_ADVANCED_CHECK", null);
        this.mCreateDataImage = new MatrixImageEx(this.getResImageURL("IDS_SIMULATION_MANUALLY_IMAGE"));
        this.mCreateDataLabel = DialogUtil.createLabel(this, CREATE_DATA_RESOURCE_KEY);
        this.mCreateDataLabel.setLabelFor(this.mCreateDataImage);
        Vector<MatrixImageEx> vector = new Vector<MatrixImageEx>();
        vector.add(this.mLoadModelImage);
        vector.add(this.mManuallyTypedImage);
        vector.add(this.mLoadPlanImage);
        vector.add(this.mCreateDataImage);
        this.mControlChartsImageGroup.addMatrixImages(vector);
        this.mManuallyTypedImage.addMatrixListener(this);
        this.mLoadModelImage.addMatrixListener(this);
        this.mLoadPlanImage.addMatrixListener(this);
        this.mCreateDataImage.addMatrixListener(this);
        this.mHelpPanel = new HelpPanel();
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mControlChartsImageGroup);
            vector.add(this.mOpenAdvanced);
            vector.add(this.mDefineButton);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpPanel);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mHelpPanel);
            vector.add(this.mControlChartsImageGroup);
            vector.add(this.mOpenAdvanced);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mManuallyTypedImage.setDefaultSelectedImage(true);
        this.mLoadModelImage.setDefaultSelectedImage(false);
        this.mLoadPlanImage.setDefaultSelectedImage(false);
        this.mOpenAdvanced.setEnabled(false);
        this.mOpenAdvanced.setSelected(false);
    }

    @Override
    protected void processCancelAction() {
        super.processCancelAction();
    }

    @Override
    protected void processContinueAction(ActionEvent actionEvent) {
        super.processContinueAction(actionEvent);
    }

    public class HelpPanel
    extends JPanel {
        private JTextArea mInfoDesc;
        private JLabel mHelpIconLabel;

        public HelpPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.initLayout(this.getFont());
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                }
            });
        }

        protected void initLayout(Font font) {
            this.mInfoDesc = new JTextArea();
            this.mInfoDesc.setOpaque(false);
            this.mInfoDesc.setFont(font);
            this.mInfoDesc.setLineWrap(true);
            this.mInfoDesc.setWrapStyleWord(true);
            this.mInfoDesc.setText("");
            this.mInfoDesc.setFocusable(false);
            this.mHelpIconLabel = new JLabel();
            this.setHelpText();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, 0, 0, 1, 1, n, null);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(this, this.mHelpIconLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        }

        public void setHelpText() {
            this.mInfoDesc.setText(SimulationGatingDlg.this.getResString("IDS_SIMULATION_SELECTION_DESCRIPTION"));
            this.mInfoDesc.setEnabled(true);
            this.mHelpIconLabel.setEnabled(true);
            this.getAccessibleContext().setAccessibleName(this.mInfoDesc.getText());
            this.getAccessibleContext().setAccessibleDescription(this.mInfoDesc.getText());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

