/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class SimulatedFieldTableModel
extends AbstractTableModel {
    private final int NUMOFCOLUMNS = 5;
    private String[] titles = new String[5];
    private TreeMap<String, SimulatedField> mFieldsMap = null;
    private ArrayList<SimulatedField> mFieldsList = null;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public SimulatedFieldTableModel(String[] stringArray) {
        this.titles[0] = stringArray[0];
        this.titles[1] = stringArray[1];
        this.titles[2] = "lock";
        this.titles[3] = stringArray[2];
        this.titles[4] = stringArray[3];
    }

    @Override
    public int getRowCount() {
        if (this.mFieldsList == null) {
            return 0;
        }
        return this.mFieldsList.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        return this.titles[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        SimulatedField simulatedField = this.mFieldsList.get(n);
        switch (n2) {
            case 2: {
                if (object instanceof Boolean) {
                    simulatedField.setLock((Boolean)object);
                }
                this.fireTableCellUpdated(n, n2);
                this.fireTableCellUpdated(n, 3);
                this.fireTableCellUpdated(n, 4);
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.mFieldsList == null) {
            return null;
        }
        SimulatedField simulatedField = this.mFieldsList.get(n);
        switch (n2) {
            case 0: {
                return simulatedField.getName();
            }
            case 1: {
                return SimulationHelper.getMLevelString(simulatedField.getMeasurementLevel());
            }
            case 2: {
                return simulatedField.isLocked();
            }
            case 3: 
            case 4: {
                return simulatedField;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 2) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    public void setSimulatedPredictors(ArrayList<SimulatedField> arrayList) {
        this.setSimulatedPredictors(arrayList, true);
    }

    public void setSimulatedPredictors(ArrayList<SimulatedField> arrayList, boolean bl) {
        if (this.mFieldsList != null) {
            this.mFieldsList.clear();
            this.mFieldsMap.clear();
        } else {
            this.mFieldsList = new ArrayList();
            this.mFieldsMap = new TreeMap();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SimulatedField simulatedField = arrayList.get(i);
            this.mFieldsMap.put(simulatedField.getName(), simulatedField);
        }
        this.updateFieldList();
        if (bl) {
            this.setupMappedNames();
        }
        this.fireTableDataChanged();
    }

    public void reset() {
        if (this.mFieldsMap != null) {
            this.mFieldsMap.clear();
        }
        if (this.mFieldsList != null) {
            this.mFieldsList.clear();
        }
    }

    public void addOneSimulatedField(SimulatedField simulatedField) {
        if (this.mFieldsMap == null) {
            this.mFieldsList = new ArrayList();
            this.mFieldsMap = new TreeMap();
            this.mFieldsMap.put(simulatedField.getName(), simulatedField);
            this.mFieldsList.add(simulatedField);
        } else {
            this.mFieldsMap.put(simulatedField.getName(), simulatedField);
            this.mFieldsList.clear();
            this.updateFieldList();
        }
        this.fireTableDataChanged();
    }

    public void deleteOneSimulatedField(SimulatedField simulatedField) {
        int n = this.findRowIndex(simulatedField);
        if (n < 0) {
            return;
        }
        if (this.mFieldsMap != null && this.mFieldsList != null) {
            this.mFieldsList.remove((Object)simulatedField);
            this.mFieldsMap.remove(simulatedField.getName());
        }
        this.fireTableRowsDeleted(n, n);
    }

    public SimulatedField getSimulatedField(int n) {
        if (n >= 0 && n < this.mFieldsList.size()) {
            return this.mFieldsList.get(n);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        SimulatedField simulatedField = this.getSimulatedField(n);
        if (simulatedField != null && simulatedField.isInContingencyTable()) {
            return false;
        }
        return n2 == 2 || n2 == 3 || n2 == 4;
    }

    private void updateFieldList() {
        Iterator<String> iterator = this.mFieldsMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.mFieldsList.add(this.mFieldsMap.get(iterator.next()));
        }
    }

    private void setupMappedNames() {
        for (int i = 0; i < this.mFieldsList.size(); ++i) {
            SimulatedField simulatedField = this.mFieldsList.get(i);
            boolean bl = simulatedField.getType() > 0;
            MeasurementLevel measurementLevel = simulatedField.getMeasurementLevel();
            String string = simulatedField.getMappedName();
            String string2 = "";
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
            int n = string.length() == 0 ? iSpssDataSrc.findVarIndex(simulatedField.getName()) : iSpssDataSrc.findVarIndex(string);
            if (n < 0) {
                simulatedField.setMappedName("");
                continue;
            }
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
            if (iSpssVariable.getMeasurementLevel() != measurementLevel || (!bl || !iSpssVariable.getFormat().getFormatType().isStringFormat()) && (bl || iSpssVariable.getFormat().getFormatType().isStringFormat())) continue;
            string2 = iSpssVariable.getName();
            simulatedField.setMappedName(string2);
        }
    }

    public int findRowIndex(SimulatedField simulatedField) {
        int n = -1;
        for (int i = 0; i < this.mFieldsList.size(); ++i) {
            if (!simulatedField.getName().equals(this.mFieldsList.get(i).getName())) continue;
            n = i;
            break;
        }
        return n;
    }

    public int findRowIndex(String string) {
        int n = -1;
        if (this.mFieldsList == null) {
            return n;
        }
        for (int i = 0; i < this.mFieldsList.size(); ++i) {
            if (!string.equals(this.mFieldsList.get(i).getName())) continue;
            n = i;
            break;
        }
        return n;
    }
}

