/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.dialogs.MC.BaseMCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.DistributionParametersPanel;
import com.spss.java_client.ui.dialogs.MC.MCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulatedFieldTableModel;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.res.MCResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SimulatedFieldTable
extends JTable {
    private final int LOCK_WIDTH = 30;
    private final int FITTO_WIDTH = 60;
    private final int PARAMETERS_WIDTH = 320;
    private final int ROW_HEIGHT = 120;
    private Map<String, BufferedImage> mImageMap = new HashMap<String, BufferedImage>();
    private ResourceBundle mBundle;
    private Hashtable<String, BaseMCSimulationTab.ScannedVar> mScannedVarMap;
    private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private String mLockString = "";

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public SimulatedFieldTable(TableModel tableModel) {
        super(tableModel);
        this.mBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.mLockString = this.mBundle.getString("IDS_MC_SIMULATED_FIELD_TABLE_LOCK");
        this.init();
    }

    public void setScannedVarMap(Hashtable<String, BaseMCSimulationTab.ScannedVar> hashtable) {
        int n;
        this.mScannedVarMap.clear();
        this.mScannedVarMap.putAll(hashtable);
        int n2 = this.getRowCount();
        for (n = 0; n < n2; ++n) {
            SimulatedField simulatedField = (SimulatedField)((Object)this.getValueAt(n, 3));
            BaseMCSimulationTab.ScannedVar scannedVar = this.mScannedVarMap.get(simulatedField.getMappedName());
            if (scannedVar == null) continue;
            TreeMap<OBS, Double> treeMap = scannedVar.getValMap();
            double d = scannedVar.getStartPos();
            double d2 = scannedVar.getEndPos();
            Vector<BaseMCSimulationTab.HistoBin> vector = scannedVar.getHistoBins();
            if (vector != null) continue;
        }
        this.mImageMap.clear();
        n = this.getSelectedRow();
        int n3 = this.getSelectedColumn();
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
        if (n < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.selectCell(n, n3);
        this.getMCSimulationTab().updateFitButtons();
    }

    public SimulatedField getSelectedField() {
        return ((SimulatedFieldTableModel)this.getModel()).getSimulatedField(this.getSelectedRow());
    }

    public void refreshParametersCell(SimulatedField simulatedField) {
        int n = 0;
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.getModel();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (simulatedFieldTableModel.getSimulatedField(i) != simulatedField) continue;
            n = i;
            break;
        }
        simulatedFieldTableModel.fireTableCellUpdated(n, 4);
        this.setRowSelectionInterval(n, n);
        TableColumn tableColumn = this.getColumnModel().getColumn(4);
        ParametersTableCell parametersTableCell = (ParametersTableCell)tableColumn.getCellRenderer();
        DistributionParametersPanel distributionParametersPanel = (DistributionParametersPanel)parametersTableCell.getTableCellRendererComponent(this, (Object)simulatedField, true, true, n, 4);
        distributionParametersPanel.updateImage();
    }

    public void refreshFitStateImage(SimulatedField simulatedField) {
        int n = 0;
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.getModel();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (simulatedFieldTableModel.getSimulatedField(i) != simulatedField) continue;
            n = i;
            break;
        }
        Vector<SimulatedField> vector = new Vector<SimulatedField>();
        vector.add(simulatedField);
        if (SimulationHelper.validateFields(vector, false)) {
            simulatedFieldTableModel.fireTableCellUpdated(n, 3);
        }
    }

    public void reset() {
        if (this.isEditing() && this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        this.mScannedVarMap.clear();
        this.mImageMap.clear();
    }

    private void selectCell(int n, int n2) {
        this.getSelectionModel().setSelectionInterval(n, n);
        this.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
    }

    private void init() {
        this.mScannedVarMap = new Hashtable();
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(true);
        ModelsTableCellRenderer modelsTableCellRenderer = new ModelsTableCellRenderer();
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(modelsTableCellRenderer);
        tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(modelsTableCellRenderer);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(2);
        tableColumn2.setHeaderRenderer(new LockHeaderRenderer());
        tableColumn2.setCellRenderer(new LockColumnRenderer());
        final LockColumnRenderer lockColumnRenderer = new LockColumnRenderer();
        tableColumn2.setCellEditor(lockColumnRenderer);
        tableColumn2.setMaxWidth(30);
        tableColumn2.setPreferredWidth(30);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(3);
        tableColumn3.setCellRenderer(new FitToTableCell());
        final FitToTableCell fitToTableCell = new FitToTableCell();
        tableColumn3.setCellEditor(fitToTableCell);
        TableColumn tableColumn4 = this.getColumnModel().getColumn(4);
        tableColumn4.setCellRenderer(new ParametersTableCell());
        final ParametersTableCell parametersTableCell = new ParametersTableCell();
        tableColumn4.setCellEditor(parametersTableCell);
        tableColumn4.setPreferredWidth(320);
        tableColumn4.setMaxWidth(640);
        tableColumn4.setMinWidth(320);
        this.setRowHeight(120);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons();
                parametersTableCell.commitDistTable(mouseEvent.getPoint());
            }
        });
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.setGridColor(this.getGridColor().darker());
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = SimulatedFieldTable.this.getSelectedRow();
                int n2 = SimulatedFieldTable.this.getSelectedColumn();
                if (keyEvent.getKeyCode() == 32) {
                    if (n2 == 2 || n2 == 3 || n2 == 4) {
                        SimulatedFieldTable.this.editCellAt(n, n2);
                        if (n2 == 2) {
                            boolean bl = lockColumnRenderer.getLockCheckbox().isSelected();
                            lockColumnRenderer.getLockCheckbox().setSelected(!bl);
                            ((SimulatedFieldTableModel)SimulatedFieldTable.this.getModel()).getSimulatedField(n).setLock(!bl);
                            SimulatedFieldTable.this.setValueAt(!bl, SimulatedFieldTable.this.getSelectedRow(), 2);
                            SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons(((SimulatedFieldTableModel)SimulatedFieldTable.this.getModel()).getSimulatedField(n));
                        } else if (n2 == 3) {
                            fitToTableCell.getComboBox().processKeyEvent(keyEvent);
                            fitToTableCell.getComboBox().requestFocus();
                        } else {
                            parametersTableCell.getComboBox().processKeyEvent(keyEvent);
                            parametersTableCell.getComboBox().requestFocus();
                        }
                    }
                } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 37) {
                    int n3 = -1;
                    if (keyEvent.getKeyCode() == 38) {
                        if (n > 0) {
                            n3 = n - 1;
                        }
                    } else if (keyEvent.getKeyCode() == 40 && n < SimulatedFieldTable.this.getRowCount() - 1) {
                        n3 = n + 1;
                    }
                    if (n3 >= 0) {
                        SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons(((SimulatedFieldTableModel)SimulatedFieldTable.this.getModel()).getSimulatedField(n3));
                    } else {
                        SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons();
                    }
                } else if ((keyEvent.getKeyCode() == 84 || keyEvent.getKeyCode() == 77 || keyEvent.getKeyCode() == 88 || keyEvent.getKeyCode() == 89) && keyEvent.getModifiers() == 8) {
                    SimulatedFieldTable.this.setColumnSelectionInterval(4, 4);
                    SimulatedFieldTable.this.editCellAt(n, 4);
                    if (keyEvent.getKeyCode() == 89) {
                        parametersTableCell.getComboBox().processKeyEvent(keyEvent);
                        parametersTableCell.getComboBox().requestFocus();
                    } else if (keyEvent.getKeyCode() == 84) {
                        parametersTableCell.getParameterTable().requestFocus();
                        parametersTableCell.getParameterTable().setRowSelectionInterval(0, 0);
                        parametersTableCell.getParameterTable().setColumnSelectionInterval(1, 1);
                    } else if (keyEvent.getKeyCode() == 77) {
                        if (parametersTableCell.getMinField() != null && parametersTableCell.getMinField().isEnabled()) {
                            parametersTableCell.getMinField().requestFocus();
                        }
                    } else if (parametersTableCell.getMaxField() != null && parametersTableCell.getMaxField().isEnabled()) {
                        parametersTableCell.getMaxField().requestFocus();
                    }
                }
            }
        });
    }

    private MCSimulationTab getMCSimulationTab() {
        MCSimulationTab mCSimulationTab = null;
        Container container = this.getParent();
        while (!(container instanceof MCSimulationTab)) {
            container = container.getParent();
        }
        if (container instanceof MCSimulationTab) {
            mCSimulationTab = (MCSimulationTab)container;
        }
        return mCSimulationTab;
    }

    class FitToTableCell
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        JPanel mPanel = new JPanel();
        private JComboBox combo;

        public FitToTableCell() {
            this.mPanel.setBorder(UIManager.getBorder("Table.focusSelectedCellHighlightBorder"));
            this.mPanel.setOpaque(true);
            this.mPanel.setBackground(SimulatedFieldTable.this.getSelectionBackground());
            this.mPanel.getAccessibleContext();
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                this.updatePanel(ComponentState.prepareStringForBidiRendering((String)((String)object)), n, n2);
            } else {
                this.updatePanel(object, n, n2);
            }
            return this.mPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                this.updatePanel(ComponentState.prepareStringForBidiRendering((String)((String)object)), n, n2);
            } else {
                this.updatePanel(object, n, n2);
            }
            if (bl) {
                this.mPanel.setForeground(jTable.getSelectionForeground());
                this.mPanel.setBackground(jTable.getSelectionBackground());
            } else {
                this.mPanel.setForeground(jTable.getForeground());
                this.mPanel.setBackground(jTable.getBackground());
            }
            this.mPanel.setBorder(bl ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : SimulatedFieldTable.this.noFocusBorder);
            Component[] componentArray = this.mPanel.getComponents();
            String string = "";
            if (componentArray != null) {
                for (Component component : componentArray) {
                    if (component instanceof JComboBox) {
                        JComboBox jComboBox = (JComboBox)component;
                        string = string + " " + jComboBox.getSelectedItem().toString();
                        continue;
                    }
                    if (!(component instanceof JLabel)) continue;
                    string = string + " " + ((JLabel)component).getToolTipText();
                }
                this.mPanel.getAccessibleContext().setAccessibleName(string);
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    this.mPanel.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    this.mPanel.setToolTipText(string);
                }
            }
            return this.mPanel;
        }

        private void updatePanel(Object object, int n, int n2) {
            this.mPanel.removeAll();
            if (n2 == 3 && object != null) {
                Object object2;
                final SimulatedField simulatedField = (SimulatedField)((Object)object);
                boolean bl = simulatedField.getType() > 0;
                Vector<String> vector = new Vector<String>();
                TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
                vector.add(SimulatedFieldTable.this.mBundle.getString("IDS_MC_SIMULATED_FIELD_TABLE_FITTO_NONE"));
                String string = simulatedField.getMappedName();
                String string2 = simulatedField.getMappedName();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
                int n3 = 0;
                if (iSpssDataSrc != null) {
                    n3 = iSpssDataSrc.columnCount();
                    for (int i = 0; i < n3; ++i) {
                        object2 = iSpssDataSrc.getVariable(i);
                        if ((!bl || !object2.getFormat().getFormatType().isStringFormat()) && (bl || object2.getFormat().getFormatType().isStringFormat())) continue;
                        treeMap.put(object2.getName(), i);
                    }
                }
                Iterator iterator = treeMap.keySet().iterator();
                while (iterator.hasNext()) {
                    if (ComponentState.isBtdRtlOrLtr()) {
                        vector.add(ComponentState.prepareStringForBidiRendering((String)((String)iterator.next())));
                        continue;
                    }
                    vector.add((String)iterator.next());
                }
                this.combo = new JComboBox(vector);
                if (simulatedField.isLocked()) {
                    this.combo.setEnabled(false);
                }
                this.combo.setSelectedItem(string2);
                this.combo.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                            if (jComboBox.getSelectedItem().equals(SimulatedFieldTable.this.mBundle.getString("IDS_MC_SIMULATED_FIELD_TABLE_FITTO_NONE"))) {
                                simulatedField.setMappedName("");
                            } else {
                                simulatedField.setMappedName(((String)jComboBox.getSelectedItem()).trim());
                            }
                            SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons();
                        }
                    }
                });
                this.mPanel.setLayout(new BorderLayout());
                this.mPanel.add((Component)this.combo, "North");
                if (simulatedField.getAutoFitState() == MonteCarloSimulationDlg.FitToState.DistributionFittedBefore && (n3 == 0 || simulatedField.getMappedName().length() > 0)) {
                    simulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.MatchedAndFitted);
                }
                object2 = SimulationHelper.createStateImageLabel(simulatedField, false);
                this.mPanel.add((Component)object2);
            }
        }

        public JComboBox getComboBox() {
            return this.combo;
        }
    }

    class ParametersTableCell
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer,
    SimulationHelper.ParametersPanelCallback {
        DistributionParametersPanel mPanel = new DistributionParametersPanel(this, true);
        private int preRow = -1;
        private int preCol = -1;
        private int currRow;
        private int currCol;

        public ParametersTableCell() {
            this.mPanel.setBorder(UIManager.getBorder("Table.focusSelectedCellHighlightBorder"));
            this.mPanel.setOpaque(true);
            this.mPanel.setBackground(SimulatedFieldTable.this.getSelectionBackground());
            this.mPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (ParametersTableCell.this.mPanel.getParamTable() != null && ParametersTableCell.this.mPanel.getParamTable().isEditing()) {
                        ParametersTableCell.this.mPanel.getParamTable().getCellEditor().stopCellEditing();
                    }
                }
            });
            this.mPanel.getAccessibleContext();
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }

        public JComboBox getComboBox() {
            return this.mPanel.getComboBox();
        }

        public JTable getParameterTable() {
            return this.mPanel.getParamTable();
        }

        public JTextField getMinField() {
            return this.mPanel.getMinField();
        }

        public JTextField getMaxField() {
            return this.mPanel.getMaxField();
        }

        @Override
        public void processTableUpdate(SimulatedField simulatedField) {
            SimulatedFieldTable.this.refreshFitStateImage(simulatedField);
            SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons();
            SimulatedFieldTable.this.getMCSimulationTab().enableOKPaste();
        }

        @Override
        public void processDistributionSelection(Object object, SimulationHelper.DistributionType distributionType) {
            SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons();
            SimulatedFieldTable.this.getMCSimulationTab().updateCorrelationTable();
            SimulatedFieldTable.this.getMCSimulationTab().updateOutputInputList();
        }

        @Override
        public Hashtable<String, BaseMCSimulationTab.ScannedVar> getScannedVarMap() {
            return SimulatedFieldTable.this.mScannedVarMap;
        }

        @Override
        public Map<String, BufferedImage> getImageMap() {
            return SimulatedFieldTable.this.mImageMap;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (this.mPanel.getParamTable() != null && this.mPanel.getParamTable().isEditing()) {
                this.mPanel.getParamTable().getCellEditor().stopCellEditing();
            }
            this.mPanel.updatePanel((SimulatedField)((Object)object), n, n2, !((SimulatedField)((Object)object)).isLocked());
            return this.mPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && n2 > 1) {
                this.mPanel.updatePanel((SimulatedField)((Object)object), n, n2, !((SimulatedField)((Object)object)).isLocked());
            }
            if (bl) {
                this.mPanel.setForeground(jTable.getSelectionForeground());
                this.mPanel.setBackground(jTable.getSelectionBackground());
            } else {
                this.mPanel.setForeground(jTable.getForeground());
                this.mPanel.setBackground(jTable.getBackground());
            }
            this.mPanel.setBorder(bl ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : SimulatedFieldTable.this.noFocusBorder);
            String string = this.mPanel.getAccessName();
            this.mPanel.getAccessibleContext().setAccessibleName(string);
            int n3 = this.mPanel.getMinimumSize().width;
            TableColumn tableColumn = SimulatedFieldTable.this.getColumnModel().getColumn(4);
            if (n3 > tableColumn.getMinWidth()) {
                tableColumn.setMinWidth(n3);
            }
            return this.mPanel;
        }

        public void commitDistTable(Point point) {
            int n = SimulatedFieldTable.this.rowAtPoint(point);
            int n2 = SimulatedFieldTable.this.columnAtPoint(point);
            if (this.preRow != -1 && this.preCol != -1 && (this.preRow != n || this.preCol != n2) && this.mPanel.getParamTable() != null && this.mPanel.getParamTable().isEditing()) {
                this.mPanel.getParamTable().getCellEditor().stopCellEditing();
            }
            this.preRow = n;
            this.preCol = n2;
        }
    }

    class LockColumnRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    UIResource {
        private JPanel mPanel = new JPanel();
        private JCheckBox mCheckBox = new JCheckBox();

        public LockColumnRenderer() {
            this.mCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LockColumnRenderer.this.mPanel.setBackground(SimulatedFieldTable.this.getSelectionBackground());
                            SimulatedFieldTable.this.setValueAt(LockColumnRenderer.this.mCheckBox.isSelected(), SimulatedFieldTable.this.getSelectedRow(), 2);
                            SimulatedFieldTable.this.getMCSimulationTab().updateFitButtons();
                        }
                    });
                }
            });
            this.mCheckBox.setBorder(null);
            this.mPanel.setLayout(new FlowLayout(1, 0, 0));
            this.mPanel.setBorder(UIManager.getBorder("Table.focusSelectedCellHighlightBorder"));
            this.mPanel.setOpaque(true);
            this.mPanel.setBackground(SimulatedFieldTable.this.getSelectionBackground());
            this.mPanel.add(this.mCheckBox);
            this.mPanel.getAccessibleContext();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.updatePanel(jTable, object, bl);
            return this.mPanel;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mCheckBox.setSelected(object != null && (Boolean)object != false);
            return this.mPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        private void updatePanel(JTable jTable, Object object, boolean bl) {
            if (bl) {
                this.mPanel.setForeground(jTable.getSelectionForeground());
                this.mPanel.setBackground(jTable.getSelectionBackground());
            } else {
                this.mPanel.setForeground(jTable.getForeground());
                this.mPanel.setBackground(jTable.getBackground());
            }
            this.mPanel.setBorder(bl ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : SimulatedFieldTable.this.noFocusBorder);
            this.mCheckBox.setSelected(object != null && (Boolean)object != false);
            this.mPanel.getAccessibleContext().setAccessibleName(SimulatedFieldTable.this.mLockString + " " + Boolean.toString(this.mCheckBox.isSelected()));
        }

        public JCheckBox getLockCheckbox() {
            return this.mCheckBox;
        }
    }

    class ModelsTableCellRenderer
    extends DefaultTableCellRenderer {
        public ModelsTableCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ModelsTableCellRenderer modelsTableCellRenderer = null;
            modelsTableCellRenderer = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (ModelsTableCellRenderer)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (ModelsTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            modelsTableCellRenderer.setVerticalAlignment(1);
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                for (String string : stringArray) {
                    stringBuffer.append(string).append("<br>");
                }
                stringBuffer.append("</html>");
                modelsTableCellRenderer.setText(stringBuffer.toString());
            } else if (object instanceof String) {
                if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                    modelsTableCellRenderer.setText(ComponentState.prepareStringForBidiRendering((String)((String)object)));
                } else {
                    modelsTableCellRenderer.setText((String)object);
                }
            }
            return modelsTableCellRenderer;
        }
    }

    class LockHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private ImageIcon mIcon;

        public LockHeaderRenderer() {
            ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            URL uRL = ResUtil.getImageResourceFullPath(MCResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_MC_SIMULATED_FIELD_LOCK_IMAGE"));
            this.mIcon = new ImageIcon(uRL);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setIcon(this.mIcon);
            return this;
        }
    }
}

