/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.dialogs.MC.FitStatistics;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.shared.core_tools.utils.Pair;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class SimulatedField
extends SpssVariable {
    private static final String NEGBIN_FAILURE = "failures";
    private static final String NEGBIN_TRIAL = "trials";
    private ArrayList<String> mRelatedModelNames;
    private boolean mLock;
    private String mOutputFormat = "";
    private int mFormatIndex = 0;
    private int mDecimalDigits = 2;
    private SimulationHelper.DistributionType mPlanDistrType;
    private Hashtable<SimulationHelper.DistributionType, ArrayList<Pair<String, String>>> mDistTpeAndParameters;
    private Hashtable<SimulationHelper.DistributionType, Double> mDistTypeAndFitValue;
    private ArrayList<FitStatistics> mFittingStats = null;
    private ArrayList<FitStatistics> mFittingStatsForFitDetails = null;
    private String mMappedName;
    private double mMin;
    private double mMax;
    private MonteCarloSimulationDlg.FitToState mAutoFit;
    private boolean mExcludeFromOutput;
    private ArrayList<String> mAutofilDistNames;
    private Vector<Pair<Double, Double>> mRangeMinMax;
    private Vector<Vector<Double>> mRangeProbs;
    private ArrayList<Pair<String, Vector<Double>>> mCatAndProbs;
    private double mEmpricalMin;
    private double mEmpricalMax;
    private Vector<Double> mEmpricalProbs;
    private String mNegBinType;
    private Object[] mSelectedParameters;
    private Vector<String> mCatsFromModel = null;
    private int mCatsCountFromModel = 0;
    private Vector<String> mMismatchCats = null;
    private boolean mIsTotalZero = false;
    private boolean mIsInCtgtTable = false;
    private ArrayList<Pair<String, String>> mCatsAndProbFromPlan;
    private Hashtable<String, String> mCatValueAndLabels = null;

    public SimulatedField(String string) {
        this.setName(string);
        this.mRelatedModelNames = new ArrayList();
        this.mDistTpeAndParameters = new Hashtable();
        this.mDistTypeAndFitValue = new Hashtable();
        this.mMappedName = "";
        this.mMin = Double.NEGATIVE_INFINITY;
        this.mMax = Double.POSITIVE_INFINITY;
        this.mAutoFit = MonteCarloSimulationDlg.FitToState.DistributionNotSet;
        this.mPlanDistrType = SimulationHelper.DistributionType.NONE;
        this.mExcludeFromOutput = false;
        this.mLock = false;
        this.mAutofilDistNames = new ArrayList();
        this.mFittingStats = new ArrayList();
        this.mFittingStatsForFitDetails = new ArrayList();
        this.mRangeMinMax = new Vector();
        this.mRangeProbs = new Vector();
        this.mEmpricalMin = Double.NEGATIVE_INFINITY;
        this.mEmpricalMax = Double.POSITIVE_INFINITY;
        this.mEmpricalProbs = new Vector();
        this.mNegBinType = "";
        this.mCatAndProbs = new ArrayList();
        this.mOutputFormat = "";
    }

    public void addRelatedModelName(String string) {
        if (!this.mRelatedModelNames.contains(string)) {
            this.mRelatedModelNames.add(string);
        }
    }

    public void setRelatedModelNames(ArrayList<String> arrayList) {
        this.mRelatedModelNames = arrayList;
    }

    public ArrayList<String> getRelatedModelNames() {
        return this.mRelatedModelNames;
    }

    public void setDistributionType(SimulationHelper.DistributionType distributionType) {
        this.mPlanDistrType = distributionType;
    }

    public SimulationHelper.DistributionType getDistributionType() {
        return this.mPlanDistrType;
    }

    public void addParameter(SimulationHelper.DistributionType distributionType, ArrayList<Pair<String, String>> arrayList) {
        this.addParameter(distributionType, arrayList, true);
    }

    public void addParameter(SimulationHelper.DistributionType distributionType, ArrayList<Pair<String, String>> arrayList, boolean bl) {
        try {
            if (arrayList == null) {
                return;
            }
            this.mDistTpeAndParameters.put(distributionType, arrayList);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public ArrayList<Pair<String, String>> getParametersFor(SimulationHelper.DistributionType distributionType) {
        return this.mDistTpeAndParameters.get((Object)distributionType);
    }

    public void removeAllParameters() {
        if (this.mDistTpeAndParameters != null) {
            this.mDistTpeAndParameters.clear();
        }
    }

    public void addOneFitValue(SimulationHelper.DistributionType distributionType, double d) {
        this.mDistTypeAndFitValue.put(distributionType, d);
    }

    public double getFitValueOf(SimulationHelper.DistributionType distributionType) {
        Double d = this.mDistTypeAndFitValue.get((Object)distributionType);
        if (d != null) {
            return d;
        }
        return Double.MAX_VALUE;
    }

    public void addOneFitStatsForFitDetails(FitStatistics fitStatistics) {
        int n = this.mFittingStatsForFitDetails.indexOf(fitStatistics);
        if (n >= 0) {
            this.mFittingStatsForFitDetails.remove(n);
            this.mFittingStatsForFitDetails.add(n, fitStatistics);
        } else {
            this.mFittingStatsForFitDetails.add(this.mFittingStatsForFitDetails.size(), fitStatistics);
        }
    }

    public ArrayList<FitStatistics> getAllFitStatsForFitDetails() {
        return this.mFittingStatsForFitDetails;
    }

    public void removeAllFitStatsForFitDetails() {
        this.mFittingStatsForFitDetails = null;
        this.mFittingStatsForFitDetails = new ArrayList();
    }

    public void addOneFitStats(FitStatistics fitStatistics) {
        int n = this.mFittingStats.indexOf(fitStatistics);
        if (n >= 0) {
            this.mFittingStats.remove(n);
            this.mFittingStats.add(n, fitStatistics);
        } else {
            this.mFittingStats.add(this.mFittingStats.size(), fitStatistics);
        }
    }

    public void removeOneFitStats(SimulationHelper.DistributionType distributionType) {
        for (int i = 0; i < this.mFittingStats.size(); ++i) {
            if (this.mFittingStats.get(i).getDistType() != distributionType) continue;
            this.mFittingStats.remove(i);
            break;
        }
    }

    public void setFitStats(ArrayList<FitStatistics> arrayList) {
        this.mFittingStats = arrayList;
        if (this.mFittingStats == null) {
            this.mFittingStats = new ArrayList();
        }
    }

    public ArrayList<FitStatistics> getAllFitStats() {
        return this.mFittingStats;
    }

    public void removeAllFitStats() {
        this.mFittingStats.clear();
    }

    public void setLock(boolean bl) {
        this.mLock = bl;
    }

    public boolean isLocked() {
        return this.mLock;
    }

    public void setMappedName(String string) {
        this.mMappedName = string;
    }

    public String getMappedName() {
        return this.mMappedName;
    }

    public void setMinValue(double d) {
        this.mMin = d;
    }

    public void setMaxValue(double d) {
        this.mMax = d;
    }

    public double getMinValue() {
        return this.mMin;
    }

    public double getMaxValue() {
        return this.mMax;
    }

    public MonteCarloSimulationDlg.FitToState getAutoFitState() {
        return this.mAutoFit;
    }

    public void setAutoFit(MonteCarloSimulationDlg.FitToState fitToState) {
        this.mAutoFit = fitToState;
    }

    void setAutoFit(boolean bl) {
        this.mAutoFit = bl ? MonteCarloSimulationDlg.FitToState.DistributionFittedBefore : MonteCarloSimulationDlg.FitToState.ManualDefined;
    }

    public boolean isExcludeFromOutput() {
        return this.mExcludeFromOutput;
    }

    public void setExcludeFromOutput(boolean bl) {
        this.mExcludeFromOutput = bl;
    }

    public ArrayList<String> getAutofilDistNames() {
        return this.mAutofilDistNames;
    }

    public void addAutofilDistName(String string) {
        this.mAutofilDistNames.add(this.mAutofilDistNames.size(), string);
    }

    public void addOnePairRangeMinMax(Pair<Double, Double> pair, Vector<Double> vector) {
        int n = this.getMinMaxIndex(pair);
        if (n >= 0) {
            this.mRangeMinMax.remove(n);
            this.mRangeMinMax.add(n, pair);
            this.mRangeProbs.removeElementAt(n);
            this.mRangeProbs.add(n, vector);
        } else {
            this.mRangeMinMax.add(this.mRangeMinMax.size(), pair);
            this.mRangeProbs.add(this.mRangeProbs.size(), vector);
        }
    }

    public Vector<Pair<Double, Double>> getAllRangeMinMax() {
        return this.mRangeMinMax;
    }

    public Vector<Vector<Double>> getAllRangeProbs() {
        return this.mRangeProbs;
    }

    public double getEmpricalMin() {
        return this.mEmpricalMin;
    }

    public void setEmpricalMinMax(double d, double d2) {
        this.mEmpricalMin = d;
        this.mEmpricalMax = d2;
    }

    public double getEmpricalMax() {
        return this.mEmpricalMax;
    }

    public Vector<Double> getEmpricalProbs() {
        return this.mEmpricalProbs;
    }

    public void setEmpricalProbs(Vector<Double> vector) {
        this.mEmpricalProbs = vector;
    }

    public String getNegBinType() {
        return this.mNegBinType;
    }

    public void setNegBinType(String string) {
        this.mNegBinType = string;
        if (string.equals(NEGBIN_FAILURE)) {
            this.mPlanDistrType = SimulationHelper.DistributionType.NEGBIN;
        } else if (string.equals(NEGBIN_TRIAL)) {
            this.mPlanDistrType = SimulationHelper.DistributionType.NEGBIN_TRIAL;
        }
    }

    public void addOneCatAndProbs(String string, Vector<Double> vector) {
        int n = -1;
        for (int i = 0; i < this.mCatAndProbs.size(); ++i) {
            Pair<String, Vector<Double>> pair = this.mCatAndProbs.get(i);
            if (!string.equals(pair.getFirst())) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            this.mCatAndProbs.remove(n);
            Pair pair = new Pair((Object)string, vector);
            this.mCatAndProbs.add(n, (Pair<String, Vector<Double>>)pair);
        } else {
            Pair pair = new Pair((Object)string, vector);
            this.mCatAndProbs.add(this.mCatAndProbs.size(), (Pair<String, Vector<Double>>)pair);
        }
    }

    public ArrayList<Pair<String, Vector<Double>>> getAllCatsAndProbs() {
        return this.mCatAndProbs;
    }

    public Vector<Double> getProbsForCategory(String string) {
        if (this.mCatAndProbs == null) {
            return null;
        }
        for (int i = 0; i < this.mCatAndProbs.size(); ++i) {
            Pair<String, Vector<Double>> pair = this.mCatAndProbs.get(i);
            if (!string.equals(pair.getFirst())) continue;
            return (Vector)pair.getSecond();
        }
        return null;
    }

    public String getOutputFormat() {
        return this.mOutputFormat;
    }

    public void setOutputFormat(String string) {
        this.mOutputFormat = string;
    }

    public int getFormatIndex() {
        return this.mFormatIndex;
    }

    public void setFormatIndex(int n, int n2) {
        this.mFormatIndex = n;
        this.mDecimalDigits = n2;
    }

    public int getNumDecimals() {
        return this.mDecimalDigits;
    }

    public Object[] getSelectedParameters() {
        return this.mSelectedParameters;
    }

    public void setSelectedParameters(Object[] objectArray) {
        this.mSelectedParameters = objectArray;
    }

    private int getMinMaxIndex(Pair<Double, Double> pair) {
        int n = -1;
        if (this.mRangeMinMax != null && this.mRangeMinMax.size() > 0) {
            for (int i = 0; i < this.mRangeMinMax.size(); ++i) {
                Pair<Double, Double> pair2 = this.mRangeMinMax.get(i);
                if (((Double)pair.getFirst()).doubleValue() != ((Double)pair2.getFirst()).doubleValue() || ((Double)pair.getSecond()).doubleValue() != ((Double)pair2.getSecond()).doubleValue()) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public Vector<String> getCatsFromModel() {
        return this.mCatsFromModel;
    }

    public void setCatsFromModel(Vector<String> vector, int n) {
        this.mCatsFromModel = vector;
        this.mCatsCountFromModel = n;
    }

    public int getCatsCount() {
        return this.mCatsCountFromModel;
    }

    public void setMisMatchCats(Vector<String> vector) {
        this.mMismatchCats = vector;
    }

    public Vector<String> getMisMatchCats() {
        return this.mMismatchCats;
    }

    public boolean isTotalZero() {
        return this.mIsTotalZero;
    }

    public void setTotalZero(boolean bl) {
        this.mIsTotalZero = bl;
    }

    void removeMismaches() {
        if (this.mMismatchCats != null) {
            this.mMismatchCats.clear();
        }
    }

    void setInContingencyTable(boolean bl) {
        this.mIsInCtgtTable = bl;
    }

    boolean isInContingencyTable() {
        return this.mIsInCtgtTable;
    }

    void copyCatsAndProbs(ArrayList<Pair<String, String>> arrayList) {
        this.mCatsAndProbFromPlan = new ArrayList();
        for (Pair<String, String> pair : arrayList) {
            this.mCatsAndProbFromPlan.add((Pair<String, String>)new Pair(pair.getFirst(), pair.getSecond()));
        }
    }

    void reploadFromSavedPlan() {
        if (this.mCatsAndProbFromPlan != null) {
            this.mPlanDistrType = SimulationHelper.DistributionType.MULTINOMIAL;
            this.removeAllParameters();
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            for (Pair<String, String> pair : this.mCatsAndProbFromPlan) {
                arrayList.add((Pair<String, String>)new Pair(pair.getFirst(), pair.getSecond()));
            }
            this.addParameter(SimulationHelper.DistributionType.MULTINOMIAL, arrayList);
        }
    }

    void addCatValueLableFromModel(String string, String string2) {
        if (this.mCatValueAndLabels == null) {
            this.mCatValueAndLabels = new Hashtable();
        }
        this.mCatValueAndLabels.put(string, string2);
    }

    String getCatLabelForValue(String string) {
        String string2 = null;
        if (this.mCatValueAndLabels != null) {
            return this.mCatValueAndLabels.get(string);
        }
        return string2;
    }
}

