/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.MC.FloatFieldEditor;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SensitivityAnalysisSub
extends BaseSubDialog
implements ActionListener,
TableModelListener {
    private static final Dimension sMinListSize = new Dimension(120, 120);
    private static final String PARAM_COMBO = "IDS_MC_SENSITIVITY_PARAM_COMBO";
    private static final String sProb = " (Probability)";
    private static final String sRange = "Range ";
    private JTextArea mMessageArea;
    private JLabel mInputLabel;
    private StringTextField mInputFieldName;
    private JRadioButton mNoIterButton;
    private JRadioButton mIterateButton;
    private SpssButtonGroup mIterGroup;
    private JLabel mParamComboLabel;
    private JComboBox mParamCombo;
    private JLabel mTableLabel;
    private JTable mParameterTable;
    private DefaultTableModel mParameterTableModel;
    private SimulatedField mSField;
    private String[] mParamNames;
    private String[] mCatValues = null;
    private Hashtable<String, Vector<String>> mParamValues;
    private String mSelectedCatName;
    private boolean mSpeicalType = false;
    private Vector<Double> mMins = new Vector();
    private Vector<Double> mMaxs = new Vector();
    private Vector<Double> mProbValues = new Vector();
    private Hashtable<String, Vector<Double>> mRangeTable = null;
    private Hashtable<String, String> mMinMaxIndice = null;
    private FloatFieldEditor mFloatFieldEditor;
    private TextFieldEditor mTextFieldEditor;
    private ISpssVariable mMappedVar = null;

    public SensitivityAnalysisSub(BaseProcedureDialog baseProcedureDialog, SimulatedField simulatedField) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MC_SENSITIVITY_TITLE"), true);
        this.mSField = simulatedField;
        this.mParamValues = new Hashtable();
        this.mMins.clear();
        this.mMaxs.clear();
        this.mProbValues.clear();
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mNoIterButton) {
            this.enableParamTable(false);
        } else if (actionEvent.getSource() == this.mIterateButton) {
            this.enableParamTable(true);
        } else if (actionEvent.getSource() == this.mParamCombo) {
            int n = this.mParamCombo.getSelectedIndex();
            if (this.mParamNames != null && this.mParamNames.length > 1) {
                this.setDefaultParamValue(n);
            }
        }
    }

    @Override
    public boolean continuePressed() {
        boolean bl = this.mNoIterButton.isSelected();
        ArrayList<Pair<String, String>> arrayList = null;
        Vector<Double> vector = null;
        SimulationHelper.DistributionType distributionType = this.mSField.getDistributionType();
        String string = this.mParamCombo.getSelectedItem().toString();
        int n = this.mParamCombo.getSelectedIndex();
        Pair<String, String>[] pairArray = SimulationHelper.getParamNames(distributionType);
        boolean bl2 = false;
        if (distributionType == SimulationHelper.DistributionType.MULTINOMIAL || distributionType == SimulationHelper.DistributionType.RANGE) {
            bl2 = true;
            if (vector == null) {
                vector = new Vector<Double>();
            }
        } else {
            arrayList = new ArrayList<Pair<String, String>>();
        }
        int n2 = 0;
        for (n2 = 0; n2 < this.mParamNames.length; ++n2) {
            String string2 = this.mParamNames[n2];
            if (bl || !string.equals(string2)) {
                if (!bl2) {
                    arrayList.add((Pair<String, String>)new Pair(pairArray[n2].getFirst(), (Object)this.mParamValues.get(string2).get(0)));
                    continue;
                }
                if (!bl) continue;
                String string3 = this.mParamValues.get(string2).get(0);
                vector.add(Double.parseDouble(string3));
                continue;
            }
            for (int i = 0; !bl && i < this.mParameterTable.getRowCount(); ++i) {
                String string4 = UIToolResUtil.removeLocale((String)this.mParameterTable.getValueAt(i, 1).toString());
                if (string4.length() <= 0) continue;
                if (arrayList != null && this.isFieldString()) {
                    arrayList.add((Pair<String, String>)new Pair(pairArray[n].getFirst(), (Object)string4));
                    continue;
                }
                double d = Double.parseDouble(string4);
                String string5 = "";
                string5 = bl2 ? "prob" : (String)pairArray[n].getFirst();
                String string6 = SimulationHelper.isParamValueValid(distributionType, string5, d);
                if (string6.length() > 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string6, VersionInfo.getAppVersionString());
                    return false;
                }
                if (vector != null) {
                    vector.add(d);
                    continue;
                }
                arrayList.add((Pair<String, String>)new Pair(pairArray[n].getFirst(), (Object)string4));
            }
        }
        if (vector != null) {
            this.updateProbValues(distributionType, vector);
        } else {
            this.mSField.addParameter(distributionType, arrayList);
        }
        this.mSField.setLock(true);
        this.mSField.setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
        return true;
    }

    private void updateProbValues(SimulationHelper.DistributionType distributionType, Vector<Double> vector) {
        Object[] objectArray = this.mSField.getSelectedParameters();
        boolean bl = this.mNoIterButton.isSelected();
        String string = this.mParamCombo.getSelectedItem().toString();
        int n = sProb.length();
        if (distributionType == SimulationHelper.DistributionType.MULTINOMIAL) {
            String string2;
            Object object;
            int n2;
            int n3 = 0;
            boolean bl2 = this.mSField.getFormat().getFormatType().isStringFormat() || this.mSField.getType() > 0;
            String string3 = this.mCatValues[this.mParamCombo.getSelectedIndex()];
            objectArray[0] = string3;
            ArrayList<Pair<String, String>> arrayList = this.mSField.getParametersFor(distributionType);
            Vector<String> vector2 = new Vector<String>();
            Vector<Object> vector3 = new Vector<Object>();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = arrayList.get(n2);
                String string4 = (String)object.getFirst();
                if (!vector2.contains(string4)) {
                    vector2.add(string4);
                } else if (bl) continue;
                if (this.areCatsEqual(string4, objectArray[0].toString(), bl2)) {
                    string3 = string4;
                }
                Vector<Double> vector4 = new Vector<Double>();
                boolean bl3 = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Pair<String, String> pair = arrayList.get(i);
                    string2 = (String)pair.getFirst();
                    if (!string4.equalsIgnoreCase(string2) || (!bl || bl3) && bl) continue;
                    vector4.add(Double.parseDouble((String)pair.getSecond()));
                    if (!bl || bl3) continue;
                    vector3.add(pair.getSecond());
                    bl3 = true;
                }
                if (vector4.size() <= 0) continue;
                this.mSField.addOneCatAndProbs(string4, vector4);
                n3 = vector4.size();
            }
            if (bl) {
                ArrayList<Pair<String, String>> arrayList2 = new ArrayList<Pair<String, String>>();
                for (int i = 0; i < vector2.size(); ++i) {
                    arrayList2.add((Pair<String, String>)new Pair(vector2.get(i), vector3.get(i)));
                }
                this.mSField.addParameter(distributionType, arrayList2);
                return;
            }
            this.mSField.addOneCatAndProbs(string3, vector);
            object = this.mSField.getProbsForCategory(string3);
            arrayList.clear();
            double d = 1.0 / (1.0 - (Double)((Vector)object).get(0));
            for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                double d2 = (Double)((Vector)object).get(n2);
                for (int i = 0; i < vector2.size(); ++i) {
                    string2 = (String)vector2.get(i);
                    if (string2.equalsIgnoreCase(string3)) {
                        arrayList.add((Pair<String, String>)new Pair((Object)string2, (Object)String.valueOf(d2)));
                        continue;
                    }
                    Vector<Double> vector5 = this.mSField.getProbsForCategory(string2);
                    double d3 = vector5.get(0);
                    double d4 = (1.0 - d2) * d3;
                    Math.round(d4 *= d);
                    arrayList.add((Pair<String, String>)new Pair((Object)string2, (Object)String.valueOf(d4)));
                    if (n2 <= 0) continue;
                    vector5.add(n2, d4);
                    this.mSField.addOneCatAndProbs(string2, vector5);
                }
            }
        } else if (distributionType == SimulationHelper.DistributionType.RANGE) {
            Serializable serializable;
            Object object;
            Object object2;
            Object object3;
            int n4 = 0;
            int n5 = 0;
            String string5 = this.mMinMaxIndice.get(string);
            n5 = string5.indexOf("~");
            objectArray[0] = Double.parseDouble(string5.substring(0, n5));
            objectArray[1] = Double.parseDouble(string5.substring(n5 + 1));
            ArrayList<Pair<String, String>> arrayList = this.mSField.getParametersFor(distributionType);
            ArrayList<Pair<String, String>> arrayList3 = new ArrayList<Pair<String, String>>();
            for (n4 = 0; n4 < this.mParamNames.length; ++n4) {
                String string6 = this.mParamNames[n4];
                object3 = this.mMinMaxIndice.get(string6);
                n5 = ((String)object3).indexOf("~");
                object2 = ((String)object3).substring(0, n5);
                object = ((String)object3).substring(n5 + 1);
                if (bl) {
                    arrayList3.add((Pair<String, String>)new Pair((Object)"min", object2));
                    arrayList3.add((Pair<String, String>)new Pair((Object)"max", object));
                    serializable = this.mParamValues.get(string6);
                    arrayList3.add((Pair<String, String>)new Pair((Object)"prob", ((Vector)serializable).get(0)));
                    continue;
                }
                if (string.equals(string6)) {
                    this.mSField.addOnePairRangeMinMax((Pair<Double, Double>)new Pair((Object)((Double)objectArray[0]), (Object)((Double)objectArray[1])), vector);
                    continue;
                }
                this.mSField.addOnePairRangeMinMax((Pair<Double, Double>)new Pair((Object)Double.parseDouble((String)object2), (Object)Double.parseDouble((String)object)), this.mRangeTable.get(string6));
            }
            int n6 = 0;
            object3 = this.mSField.getAllRangeMinMax();
            object2 = this.mSField.getAllRangeProbs();
            if (bl) {
                this.mSField.addParameter(distributionType, arrayList3);
                for (n6 = 0; n6 < ((Vector)object2).size() && ((Vector)(object = (Vector)((Vector)object2).get(n6))).size() != 1; ++n6) {
                    serializable = (Double)((Vector)object).get(0);
                    ((Vector)object).clear();
                    ((Vector)object).add(serializable);
                }
                return;
            }
            this.mSField.removeAllParameters();
            arrayList.clear();
            double d = 1.0 / (1.0 - vector.get(0));
            for (int i = 0; i < vector.size(); ++i) {
                double d5 = vector.get(i);
                for (n6 = 0; n6 < ((Vector)object3).size(); ++n6) {
                    double d6;
                    Object object4 = (Pair)((Vector)object3).get(n6);
                    Vector vector6 = (Vector)((Vector)object2).get(n6);
                    if (object4.getFirst() == objectArray[0] && object4.getSecond() == objectArray[1]) continue;
                    double d7 = d6 = ((Double)vector6.get(0)).doubleValue();
                    if (i < ((Vector)object3).size() - 1) continue;
                    d7 = (1.0 - d5) * d6;
                    d7 *= d;
                    if (vector6.size() > i) {
                        vector6.remove(i);
                    }
                    vector6.insertElementAt(d7, i);
                }
            }
            for (n6 = 0; n6 < ((Vector)object3).size(); ++n6) {
                Pair pair = (Pair)((Vector)object3).get(n6);
                arrayList.add((Pair<String, String>)new Pair((Object)"min", (Object)String.valueOf(pair.getFirst())));
                arrayList.add((Pair<String, String>)new Pair((Object)"max", (Object)String.valueOf(pair.getSecond())));
                Vector vector7 = (Vector)((Vector)object2).get(n6);
                for (Object object4 : vector7) {
                    arrayList.add((Pair<String, String>)new Pair((Object)"prob", (Object)String.valueOf(object4)));
                }
                this.mSField.addOnePairRangeMinMax((Pair<Double, Double>)pair, vector7);
            }
            this.mSField.addParameter(distributionType, arrayList);
        }
    }

    private boolean areCatsEqual(String string, String string2, boolean bl) {
        if (bl) {
            return string.equalsIgnoreCase(string2);
        }
        return Double.parseDouble(string) == Double.parseDouble(string2);
    }

    private boolean fillRangeVectors() {
        boolean bl = false;
        ArrayList<Pair<String, String>> arrayList = this.mSField.getParametersFor(SimulationHelper.DistributionType.RANGE);
        for (int i = 0; i < arrayList.size(); ++i) {
            Pair<String, String> pair = arrayList.get(i);
            String string = (String)pair.getFirst();
            double d = Double.parseDouble((String)pair.getSecond());
            if (string.equalsIgnoreCase("min")) {
                this.mMins.add(d);
                continue;
            }
            if (string.equalsIgnoreCase("max")) {
                this.mMaxs.add(d);
                continue;
            }
            if (!string.equalsIgnoreCase("prob")) continue;
            this.mProbValues.add(d);
        }
        if (this.mMins.size() == this.mMaxs.size() && this.mMins.size() == this.mProbValues.size()) {
            bl = true;
        }
        if (bl) {
            this.mRangeTable = new Hashtable();
            this.mMinMaxIndice = new Hashtable();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.mMins.size(); ++i) {
                double d = this.mMins.get(i);
                double d2 = this.mMaxs.get(i);
                String string = d + "~" + d2;
                String string2 = sRange + (i + 1) + sProb;
                if (vector.contains(string2)) continue;
                vector.add(string2);
                Vector<String> vector2 = new Vector<String>();
                Vector<Double> vector3 = new Vector<Double>();
                for (int j = 0; j < this.mMins.size(); ++j) {
                    if (d != this.mMins.get(j) || d2 != this.mMaxs.get(j)) continue;
                    vector2.add(Double.toString(this.mProbValues.get(j)));
                    vector3.add(this.mProbValues.get(j));
                }
                if (vector2.size() <= 0) continue;
                this.mParamValues.put(string2, vector2);
                this.mRangeTable.put(string2, vector3);
                this.mMinMaxIndice.put(string2, string);
            }
            this.mParamNames = vector.toArray(new String[vector.size()]);
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_sensitivity";
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = tableModelEvent.getSource();
        if (tableModelEvent.getType() == 0 && object == this.mParameterTableModel) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            boolean bl = true;
            String string = "";
            if (n2 == 1) {
                String string2 = this.mParameterTableModel.getValueAt(n, 1).toString();
                try {
                    if (!this.isFieldString()) {
                        double d = Double.parseDouble(UIToolResUtil.removeLocale((String)string2));
                        if (this.mSpeicalType && (d > 1.0 || d <= 0.0)) {
                            bl = false;
                            string = String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MC_INVALID_PARAMETER_VALUE_MIN_MAX"), 0.0, 1.0);
                        }
                    }
                    if (bl) {
                        int n3 = this.mParameterTable.getRowCount() + 1;
                        String string3 = "" + n3;
                        this.addEmptyRow(this.mParameterTable, this.mParameterTableModel, new String[]{string3, ""});
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    string = this.getResString("IDS_MC_ERROR_ENTER_NUMBER");
                }
                if (!bl) {
                    Toolkit.getDefaultToolkit().beep();
                    SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                    this.mParameterTable.changeSelection(this.mParameterTableModel.getRowCount() - 1, 1, false, false);
                    this.mParameterTable.requestFocusInWindow();
                }
            }
        }
    }

    private void addEmptyRow(JTable jTable, DefaultTableModel defaultTableModel, Object[] objectArray) {
        boolean bl = true;
        int n = jTable.getColumnCount();
        int n2 = jTable.getRowCount() - 1;
        if (n < 0 || n2 < 0) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            Object object = defaultTableModel.getValueAt(n2, i);
            if (object == null || object.toString().length() <= 0) continue;
            bl = false;
        }
        if (!bl) {
            defaultTableModel.addRow(objectArray);
            jTable.changeSelection(defaultTableModel.getRowCount() - 1, 1, false, false);
        }
    }

    protected void initialize() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setupParamNameValue();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        int n = this.setDefaultParamValue(this.mParamCombo.getSelectedIndex());
        this.setDefault(n);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMessageArea);
        vector.add(this.mInputFieldName);
        vector.add(this.mIterGroup);
        vector.add(this.mParamCombo);
        vector.add(this.mParameterTable);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false, true));
    }

    private void enableParamTable(boolean bl) {
        this.mParamComboLabel.setEnabled(bl);
        this.mParamCombo.setEnabled(bl);
        this.mTableLabel.setEnabled(bl);
        this.mParameterTable.setEnabled(bl);
        if (bl) {
            this.selectlastCell();
        }
    }

    private void selectlastCell() {
        int n = this.mParameterTable.getRowCount() - 1;
        if (n < 0) {
            return;
        }
        this.mParameterTable.getSelectionModel().setSelectionInterval(n, n);
        this.mParameterTable.getColumnModel().getSelectionModel().setSelectionInterval(1, 1);
    }

    private void initVars() {
        Object[] objectArray;
        this.mFloatFieldEditor = new FloatFieldEditor(new FloatTextField(5));
        this.mTextFieldEditor = new TextFieldEditor(new JTextField(5));
        this.mInputLabel = DialogUtil.createLabel(this, "IDS_MC_SENSITIVITY_NUM_ITERATIOM_SPINNER");
        this.mInputFieldName = new StringTextField();
        this.mInputFieldName.setEnabled(true);
        this.mInputFieldName.setFocusable(true);
        this.mInputFieldName.setEditable(false);
        this.mInputFieldName.setOpaque(false);
        this.mInputFieldName.setBorder(BorderFactory.createEmptyBorder());
        this.mInputFieldName.setText(" " + this.mSField.getName());
        this.mMessageArea = new JTextArea(){

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (this.hasFocus()) {
                    Dimension dimension = this.getSize();
                    Insets insets = this.getMargin();
                    dimension.width -= insets.left + insets.right + 1;
                    dimension.height -= insets.top + insets.bottom + 1;
                    graphics.setColor(UIManager.getColor("ToggleButton.focus"));
                    LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                    if (lookAndFeel.getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
                        BasicGraphicsUtils.drawDashedRect(graphics, insets.left, insets.top, dimension.width, dimension.height);
                    } else {
                        graphics.drawRect(insets.left, insets.top, dimension.width, dimension.height);
                    }
                }
            }
        };
        this.mMessageArea.setRows(2);
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        this.mMessageArea.setText(this.getResString("IDS_MC_SENSITIVITY_MESSAGE"));
        this.mMessageArea.setFocusable(true);
        this.mMessageArea.setEnabled(true);
        this.mMessageArea.setEditable(false);
        this.mMessageArea.setForeground(UIManager.getColor("Panel.foreground"));
        this.mMessageArea.setBackground(UIManager.getColor("Panel.background"));
        this.mNoIterButton = DialogUtil.createRadioButton(this, "IDS_MC_SENSITIVITY_MANUALLY_SET_BUTTON", null);
        this.mNoIterButton.addActionListener(this);
        this.mIterateButton = DialogUtil.createRadioButton(this, "IDS_MC_SENSITIVITY_THROUGH_ITERATION_BUTTON", null);
        this.mIterateButton.addActionListener(this);
        this.mIterGroup = new SpssButtonGroup();
        this.mIterGroup.add(this.mNoIterButton);
        this.mIterGroup.add(this.mIterateButton);
        this.mParamComboLabel = DialogUtil.createLabel(this, "IDS_MC_SENSITIVITY_PARAMETER_COMBO");
        SimulationHelper.DistributionType distributionType = this.mSField.getDistributionType();
        if (distributionType == SimulationHelper.DistributionType.RANGE || distributionType == SimulationHelper.DistributionType.MULTINOMIAL) {
            this.fillParamName(distributionType);
            this.mSpeicalType = true;
        } else {
            objectArray = SimulationHelper.getParamNames(distributionType);
            this.mParamNames = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.mParamNames[i] = (String)objectArray[i].getSecond();
            }
        }
        this.mParamCombo = new JComboBox<String>(this.mParamNames);
        this.mParamCombo.setAction(new ComboboxAction(this, PARAM_COMBO));
        this.mParamCombo.addActionListener(this);
        this.mParamComboLabel.setLabelFor(this.mParamCombo);
        this.mTableLabel = DialogUtil.createLabel(this, "IDS_MC_SENSITIVITY_PARAMETER_TABLE_LABEL");
        objectArray = this.getResStringArray("IDS_MC_SENSITIVITY_PARAMETER_TABLE_COLUMN_ARRAY");
        Vector<Pair<String, String>> vector = new Vector<Pair<String, String>>();
        vector.add(objectArray[0]);
        vector.add(objectArray[1]);
        this.mParameterTableModel = new DefaultTableModel(vector, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && (!SensitivityAnalysisSub.this.mSpeicalType || n != 0);
            }
        };
        this.mParameterTable = new PlainTable(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return SensitivityAnalysisSub.this.getResString("IDS_MC_SENSITIVITY_PARAMETER_TABLE_LABEL");
            }
        };
        this.mParameterTable.setModel(this.mParameterTableModel);
        this.mParameterTable.setRowHeight(22);
        this.mParameterTable.setColumnSelectionAllowed(true);
        this.mParameterTable.setRowSelectionAllowed(true);
        this.mParameterTable.getTableHeader().setReorderingAllowed(false);
        this.mParameterTable.getTableHeader().setResizingAllowed(true);
        this.mParameterTable.setGridColor(Color.darkGray);
        this.mParameterTable.getTableHeader().setReorderingAllowed(false);
        this.mParameterTable.getModel().addTableModelListener(this);
        TableColumn tableColumn = this.mParameterTable.getColumnModel().getColumn(1);
        if (!this.isFieldString()) {
            tableColumn.setCellEditor(this.mFloatFieldEditor);
        } else {
            tableColumn.setCellEditor(this.mTextFieldEditor);
        }
        this.mParameterTable.getColumnModel().getColumn(0).setCellRenderer(new FloatFieldRenderer(0));
        this.mParameterTable.getColumnModel().getColumn(1).setCellRenderer(new FloatFieldRenderer(1));
        this.mTableLabel.setLabelFor(this.mParameterTable);
        this.addEmptyRow(this.mParameterTable, this.mParameterTableModel, new Object[]{"2", ""});
        SimulationHelper.setupColumnWidths(this.mParameterTable, new double[]{0.2, 0.8});
    }

    private void fillParamName(SimulationHelper.DistributionType distributionType) {
        ArrayList<Pair<String, String>> arrayList = this.mSField.getParametersFor(distributionType);
        int n = sProb.length();
        this.mParamNames = null;
        this.mParamValues.clear();
        if (distributionType == SimulationHelper.DistributionType.RANGE) {
            Vector<Pair<Double, Double>> vector = this.mSField.getAllRangeMinMax();
            Vector<Vector<Double>> vector2 = this.mSField.getAllRangeProbs();
            if (vector.size() == 0 || !this.hasInterationRange()) {
                this.fillRangeVectors();
            } else {
                this.mRangeTable = new Hashtable();
                this.mMinMaxIndice = new Hashtable();
                Vector<String> vector3 = new Vector<String>();
                for (int i = 0; i < vector.size(); ++i) {
                    Pair<Double, Double> pair = vector.get(i);
                    double d = (Double)pair.getFirst();
                    double d2 = (Double)pair.getSecond();
                    String string = d + "~" + d2;
                    String string2 = sRange + (i + 1) + sProb;
                    if (vector3.contains(string2)) continue;
                    vector3.add(string2);
                    Vector<String> vector4 = new Vector<String>();
                    Vector<Double> vector5 = new Vector<Double>();
                    this.mProbValues = vector2.get(i);
                    for (int j = 0; j < this.mProbValues.size(); ++j) {
                        vector4.add(Double.toString(this.mProbValues.get(j)));
                        vector5.add(this.mProbValues.get(j));
                    }
                    if (vector4.size() <= 0) continue;
                    this.mParamValues.put(string2, vector4);
                    this.mRangeTable.put(string2, vector5);
                    this.mMinMaxIndice.put(string2, string);
                }
                this.mParamNames = vector3.toArray(new String[vector3.size()]);
            }
        } else if (distributionType == SimulationHelper.DistributionType.MULTINOMIAL) {
            Object object;
            String string;
            String string3;
            Vector<String> vector = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            int n2 = 0;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                Pair<String, String> pair = arrayList.get(n2);
                string3 = (String)pair.getFirst();
                string = this.mSField.getCatLabelForValue(string3);
                if (string == null) {
                    string = string3;
                }
                if (vector.contains(object = string + sProb)) continue;
                vector.add((String)object);
                vector6.add(string3);
            }
            this.mParamNames = vector.toArray(new String[vector.size()]);
            this.mCatValues = vector6.toArray(new String[vector6.size()]);
            for (int i = 0; i < this.mParamNames.length; ++i) {
                string3 = this.mParamNames[i];
                string = this.mCatValues[i];
                object = new Vector();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    Pair<String, String> pair = arrayList.get(n2);
                    if (!string.equals(pair.getFirst())) continue;
                    ((Vector)object).add(pair.getSecond());
                }
                this.mParamValues.put(string3, (Vector<String>)object);
            }
        }
    }

    private String getCatLabel(String string) {
        OBS oBS;
        String string2;
        IValueLabelMap iValueLabelMap;
        String string3 = string;
        if (this.mMappedVar != null && (iValueLabelMap = this.mMappedVar.getValueLabels()) != null && (string2 = iValueLabelMap.get(oBS = this.mMappedVar.getType() > 0 || this.mMappedVar.getFormat().getFormatType().isStringFormat() ? new OBS(string) : new OBS(Double.valueOf(string).doubleValue()))) != null) {
            string3 = string2;
        }
        return string3;
    }

    private boolean hasCatLabel() {
        boolean bl = false;
        if (this.mSField.getMappedName().length() > 0 && this.mSField.getAutoFitState() == MonteCarloSimulationDlg.FitToState.MatchedAndFitted) {
            ISpssVariable iSpssVariable;
            IValueLabelMap iValueLabelMap;
            String string = this.mSField.getMappedName();
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(string);
            if (n >= 0 && (iValueLabelMap = (iSpssVariable = iSpssDataSrc.getVariable(n)).getValueLabels()) != null) {
                bl = true;
                this.mMappedVar = iSpssVariable;
            }
        }
        return bl;
    }

    void setDefault(int n) {
        if (n < 2) {
            this.mNoIterButton.setSelected(true);
            this.enableParamTable(false);
        } else {
            this.mIterateButton.setSelected(true);
            this.enableParamTable(true);
        }
    }

    private boolean isFieldString() {
        return this.mSField.getDistributionType() == SimulationHelper.DistributionType.FIXED && this.mSField.getMeasurementLevel() == MeasurementLevel.nominal;
    }

    private int setDefaultParamValue(int n) {
        int n2 = 0;
        if (this.mParamNames != null) {
            SimulationHelper.DistributionType distributionType = this.mSField.getDistributionType();
            Pair<String, String>[] pairArray = SimulationHelper.getParamNames(distributionType);
            Vector<String> vector = new Vector<String>();
            ArrayList<Pair<String, String>> arrayList = this.mSField.getParametersFor(distributionType);
            if (distributionType != SimulationHelper.DistributionType.MULTINOMIAL && distributionType != SimulationHelper.DistributionType.RANGE) {
                if (arrayList != null && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!((String)arrayList.get(i).getFirst()).equals(pairArray[n].getFirst())) continue;
                        vector.add(n2++, (String)arrayList.get(i).getSecond());
                    }
                }
                this.updateParamTable(vector);
            } else {
                n2 = this.updateParamTable(this.mParamValues.get(this.mParamNames[n]));
            }
        }
        return n2;
    }

    private int updateParamTable(Vector<String> vector) {
        int n = -1;
        if (this.mParameterTableModel != null) {
            if (this.mParameterTableModel.getRowCount() > 1) {
                this.mParameterTableModel.setRowCount(0);
            }
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.mParameterTableModel.addRow(new Object[]{Integer.toString(i + 1), vector.get(i)});
            }
            this.mParameterTableModel.addRow(new Object[]{Integer.toString(n + 1), ""});
            this.selectlastCell();
        }
        return n;
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMessageArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, 0, 2, n2);
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mInputLabel, this.mInputFieldName}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 4, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNoIterButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 4, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mIterateButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Dimension dimension = this.mParamCombo.getPreferredSize();
        this.mParamCombo.setPreferredSize(new Dimension(dimension.width + 20, dimension.height));
        insets.set(2, n2 * 8, 2, n2);
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mParamComboLabel, this.mParamCombo}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 8, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTableLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mParameterTable, 20, 31);
        jScrollPane.setMinimumSize(sMinListSize);
        jScrollPane.setPreferredSize(sMinListSize);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2 * 8, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 6, 1, 1, n, insets);
    }

    private void setupParamNameValue() {
        SimulationHelper.DistributionType distributionType = this.mSField.getDistributionType();
        ArrayList<Pair<String, String>> arrayList = this.mSField.getParametersFor(distributionType);
        if (distributionType != SimulationHelper.DistributionType.MULTINOMIAL && distributionType != SimulationHelper.DistributionType.RANGE && this.mParamNames != null && this.mParamNames.length > 0 && arrayList != null && arrayList.size() > 0) {
            int n = 0;
            Pair<String, String>[] pairArray = SimulationHelper.getParamNames(distributionType);
            for (n = 0; n < this.mParamNames.length; ++n) {
                String string = (String)pairArray[n].getFirst();
                Vector<Object> vector = new Vector<Object>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!((String)arrayList.get(i).getFirst()).equals(string)) continue;
                    vector.add(arrayList.get(i).getSecond());
                }
                this.mParamValues.put(this.mParamNames[n], vector);
            }
        }
    }

    private void setInitialProbs(SimulationHelper.DistributionType distributionType) {
        Object[] objectArray = this.mSField.getSelectedParameters();
        if (objectArray == null) {
            return;
        }
        int n = 1;
        Vector<String> vector = new Vector<String>();
        int n2 = objectArray.length;
        String string = "prob";
        if (distributionType == SimulationHelper.DistributionType.RANGE) {
            n = 2;
        }
        for (int i = n; i < n2; ++i) {
            vector.add(String.valueOf(objectArray[i]));
        }
        this.mParamValues.put(string, vector);
    }

    private boolean hasInterationRange() {
        Vector<Vector<Double>> vector = this.mSField.getAllRangeProbs();
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Vector<Double> vector2 = vector.get(i);
                if (vector2.size() <= 1) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    class FloatFieldRenderer
    extends DefaultTableCellRenderer {
        public FloatFieldRenderer(int n) {
            if (n == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(4);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FloatFieldRenderer floatFieldRenderer = (FloatFieldRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null && n2 == 1) {
                String string = (String)object;
                try {
                    double d = Double.parseDouble(string);
                    if (string.length() > 0) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
                        numberFormat.setGroupingUsed(false);
                        numberFormat.setMaximumFractionDigits(2);
                        this.setText(numberFormat.format(d));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setText(string);
                }
            }
            if (n2 == 0) {
                this.setBackground(jTable.getTableHeader().getBackground());
                this.setForeground(Color.black);
                this.setOpaque(true);
            } else if (!jTable.isEnabled()) {
                this.setBackground(Color.gray);
                this.setOpaque(true);
            } else if (bl2) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(jTable.getTableHeader().getBackground());
            }
            return floatFieldRenderer;
        }
    }

    class TextFieldEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTextField mField;

        TextFieldEditor(JTextField jTextField) {
            super(jTextField);
            this.mField = jTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 > 0) {
                if (object != null) {
                    this.mField.setText(object.toString());
                } else {
                    this.mField.setText("");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextFieldEditor.this.mField.setSelectionStart(0);
                        TextFieldEditor.this.mField.setSelectionEnd(TextFieldEditor.this.mField.getText().length());
                        TextFieldEditor.this.mField.requestFocus();
                    }
                });
            }
            return this.mField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mField.getText();
        }
    }
}

