/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.SpssVLMapId;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.TableWithEmptyRow;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatDocument;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class NewFieldNameAndTypeSubDlg
extends BaseSubDialog
implements ItemListener,
ActionListener {
    static final String TARGET_MEASUREMENT_COMBO = "IDS_MC_TARGET_MEASUREMENT_COMBO";
    static final String INPUT_MEASUREMENT_COMBO = "IDS_MC_INPUT_MEASUREMENT_COMBO";
    static final String NAME_COMBO = "IDS_MC_FIELD_NAME_COMBO";
    static final String FIXED_TYPE_COMBO = "IDS_MC_FIELD_TYPE_COMBO";
    static final String FIXED_DEFAULT_VALUE = "IDS_MC_FIXED_DEFAULT_VALUE";
    static final String TARGET_BUTTON = "IDS_MC_NAME_TYPE_TARGET_RADIO";
    static final String TARGET_CHECK = "IDS_MC_NAME_TYPE_CREATE_TARGET_CHECK";
    static final String INPUT_BUTTON = "IDS_MC_NAME_TYPE_DISTRIBUTION_BUTTON";
    static final String FIXED_BUTTON = "IDS_MC_NAME_TYPE_FIXED_BUTTON";
    static final String VALUE_LABELS = "IDS_MC_NAME_TYPE_VALUE_LABEL_TABLE";
    private String[] mNames = new String[0];
    private SimulationHelper.HelpPanel mInfoDes;
    private JLabel mNameLabel;
    private StringTextField mNewFieldName;
    private JLabel mRoleLabel;
    private JRadioButton mTargetButton;
    private JLabel mTargetMeasLabel;
    private JComboBox mTargetMeasLevelCombo;
    private JCheckBox mTargetCheck;
    private JRadioButton mInputButton;
    private JLabel mInnputMeasLabel;
    private JComboBox mInputMeasLevelCombo;
    private JRadioButton mFixedButton;
    private JLabel mTypeLabel;
    private JComboBox mFixedFieldTypes;
    private JLabel mFixedDefaultLabel;
    private ContextEnabledTextField mFixedDefaultValue;
    private FloatDocument mFloatDocument = new FloatDocument();
    private PlainDocument mStringDoc = new PlainDocument();
    private SpssButtonGroup mValueOptionGroup;
    private JLabel mValueLabelTableLabel;
    private TableWithEmptyRow mValueLabelTable;
    private DefaultTableModel mTableModel;
    private Vector<String> mExistingNames;
    private boolean mIsTarget;
    private ISpssVariable mSelectedVar;
    private String mFixedDefault;

    public NewFieldNameAndTypeSubDlg(MonteCarloSimulationDlg monteCarloSimulationDlg, String[] stringArray, boolean bl, Vector<String> vector, ISpssVariable iSpssVariable, String string) {
        super(monteCarloSimulationDlg, monteCarloSimulationDlg.getResString("IDS_MC_NAME_AND_TTYPE_TITLE"), true);
        if (stringArray != null) {
            this.mNames = stringArray;
        }
        this.mIsTarget = bl;
        this.mExistingNames = vector;
        this.mSelectedVar = iSpssVariable;
        this.mFixedDefault = string;
        this.initialize();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mTargetButton) {
            this.mTargetCheck.setEnabled(true);
            this.mTargetMeasLabel.setEnabled(true);
            this.mTargetMeasLevelCombo.setEnabled(true);
            this.mFixedDefaultValue.setEnabled(false);
            this.mFixedDefaultLabel.setEnabled(false);
            this.mTypeLabel.setEnabled(false);
            this.mFixedFieldTypes.setEnabled(false);
            this.mInnputMeasLabel.setEnabled(false);
            this.mInputMeasLevelCombo.setEnabled(false);
        } else if (itemEvent.getSource() == this.mInputButton) {
            this.mTargetCheck.setEnabled(false);
            this.mTargetMeasLabel.setEnabled(false);
            this.mTargetMeasLevelCombo.setEnabled(false);
            this.mFixedDefaultValue.setEnabled(false);
            this.mFixedDefaultLabel.setEnabled(false);
            this.mTypeLabel.setEnabled(false);
            this.mFixedFieldTypes.setEnabled(false);
            this.mInnputMeasLabel.setEnabled(true);
            this.mInputMeasLevelCombo.setEnabled(true);
        } else if (itemEvent.getSource() == this.mFixedButton) {
            this.mTargetCheck.setEnabled(false);
            this.mTargetMeasLabel.setEnabled(false);
            this.mTargetMeasLevelCombo.setEnabled(false);
            this.mInnputMeasLabel.setEnabled(false);
            this.mInputMeasLevelCombo.setEnabled(false);
            this.mFixedDefaultValue.setEnabled(true);
            this.mFixedDefaultLabel.setEnabled(true);
            this.mTypeLabel.setEnabled(true);
            this.mFixedFieldTypes.setEnabled(true);
            this.mValueLabelTableLabel.setEnabled(true);
            this.mValueLabelTable.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mInputMeasLevelCombo || actionEvent.getSource() == this.mTargetMeasLevelCombo) {
            int n = actionEvent.getSource() == this.mInputMeasLevelCombo ? this.mInputMeasLevelCombo.getSelectedIndex() : this.mTargetMeasLevelCombo.getSelectedIndex();
            if (n == 0) {
                this.mValueLabelTableLabel.setEnabled(false);
                this.mValueLabelTable.setEnabled(false);
            } else {
                this.mValueLabelTableLabel.setEnabled(true);
                this.mValueLabelTable.setEnabled(true);
            }
        } else if (actionEvent.getSource() == this.mFixedFieldTypes) {
            this.initializeDefaultTextField();
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_definedinputs";
    }

    protected void initialize() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(NAME_COMBO, this.mNewFieldName.getText());
            dialogDataModel.putInteger(FIXED_TYPE_COMBO, this.mFixedFieldTypes.getSelectedIndex());
            dialogDataModel.putInteger(TARGET_MEASUREMENT_COMBO, this.mTargetMeasLevelCombo.getSelectedIndex());
            dialogDataModel.putInteger(INPUT_MEASUREMENT_COMBO, this.mInputMeasLevelCombo.getSelectedIndex());
            TreeMap<OBS, String> treeMap = new TreeMap<OBS, String>();
            int n = this.mValueLabelTable.getRowCount();
            boolean bl2 = this.mFixedButton.isSelected() && this.mFixedFieldTypes.getSelectedIndex() == 1 || this.mInputMeasLevelCombo.getSelectedIndex() == 1;
            for (int i = 0; i < n - 1; ++i) {
                OBS oBS = null;
                Object object = this.mValueLabelTable.getValueAt(i, 0);
                if (object == null || object.toString().length() == 0) continue;
                Object object2 = this.mValueLabelTable.getValueAt(i, 1);
                String string = "";
                if (object2 != null) {
                    string = this.mValueLabelTable.getValueAt(i, 1).toString();
                }
                if (bl2) {
                    oBS = new OBS(object.toString());
                } else {
                    try {
                        oBS = new OBS(Double.parseDouble(object.toString()));
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (oBS == null) continue;
                treeMap.put(oBS, string);
            }
            if (treeMap.size() > 0) {
                dialogDataModel.putObject(VALUE_LABELS, new ValueLabelMap(SpssVLMapId.next(), treeMap));
            } else {
                dialogDataModel.putObject(VALUE_LABELS, null);
            }
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mIsTarget) {
            this.mTargetButton.setSelected(true);
            this.mTargetCheck.setSelected(true);
        }
        if (this.mSelectedVar != null) {
            this.mNewFieldName.setText(this.mSelectedVar.getName());
            if (this.mIsTarget) {
                this.mTargetButton.setSelected(true);
                this.mTargetMeasLevelCombo.setSelectedIndex(NewFieldNameAndTypeSubDlg.getIndexOfMLevelTarget(this.mSelectedVar.getMeasurementLevel()));
                this.mTargetCheck.setSelected(!((SimulatedField)this.mSelectedVar).isExcludeFromOutput());
            } else if (this.mSelectedVar.getRole() == Role.partition) {
                this.mFixedButton.setSelected(true);
                short s = this.mSelectedVar.getType();
                if (s != 0) {
                    this.mFixedFieldTypes.setSelectedIndex(1);
                } else {
                    this.mFixedFieldTypes.setSelectedIndex(0);
                }
                this.mFixedDefaultValue.setText(this.mFixedDefault);
            } else {
                this.mInputButton.setSelected(true);
                this.mInputMeasLevelCombo.setSelectedIndex(NewFieldNameAndTypeSubDlg.getIndexOfMLevelInput(this.mSelectedVar.getMeasurementLevel(), this.mSelectedVar.getType() > 0));
            }
            IValueLabelMap iValueLabelMap = this.mSelectedVar.getValueLabels();
            this.mTableModel.setDataVector(new Object[0][], this.getResStringArray("IDS_MC_NAME_TYPE_TABLE_COL_NAME_ARRARY"));
            if (iValueLabelMap != null) {
                Set set = iValueLabelMap.getValueLabelEntries();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Vector<String> vector = new Vector<String>(2);
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String string = ((OBS)entry.getKey()).isString() ? ((OBS)entry.getKey()).getString() : Double.toString(((OBS)entry.getKey()).getNum());
                    vector.add(0, string);
                    vector.add(1, (String)entry.getValue());
                    this.mTableModel.addRow(vector);
                }
            } else {
                this.addEmptyRow();
            }
            if (this.mTableModel.getRowCount() == 0) {
                this.addEmptyRow();
            }
            this.mValueLabelTable.setModel(this.mTableModel);
            this.enableValueLabelTable();
        } else {
            this.setDefaults();
        }
    }

    @Override
    public boolean continuePressed() {
        String string;
        String string2;
        if (this.mSelectedVar != null) {
            return true;
        }
        if (this.mValueLabelTable.isEditing()) {
            this.mValueLabelTable.getCellEditor().stopCellEditing();
        }
        if ((string2 = this.mNewFieldName.getText()).length() == 0) {
            String string3 = this.getResString("IDS_MC_ERROR_DEFINED_INPUT_SUB_EMPTY");
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
            return false;
        }
        int n = VarNameValidator.validateSPSSName((String)string2, (boolean)true).asInt();
        boolean bl = true;
        if (n == 0 && this.mExistingNames.contains(string2)) {
            string = ResUtil.getCommonDlgString("ERR_BADVAR_DUPLICATE_ERROR_MESSAGE");
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
            bl = false;
        }
        if (bl) {
            bl = DialogUtil.showBadSpssVarNameWarning(n, this);
        }
        if (!bl) {
            SPSSTextField.setSelectionText((JComponent)((Object)this.mNewFieldName), (int)0);
            return false;
        }
        if (this.mFixedButton.isSelected() && this.mFixedFieldTypes.getSelectedIndex() == 0 && (string = this.mFixedDefaultValue.getText()).length() > 0) {
            try {
                Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                SPSSTextField.showWarningDialog((JComponent)this.mFixedDefaultValue, (String)UIToolResUtil.getString((String)"ERR_WARNING_INVALID_NUMBER"), (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                SPSSTextField.setSelectionText((JComponent)this.mFixedDefaultValue, (int)0);
                return false;
            }
        }
        return true;
    }

    private void addEmptyRow() {
        Vector<String> vector = new Vector<String>(2);
        vector.add(0, "");
        vector.add(1, "");
        this.mTableModel.addRow(vector);
    }

    static int getIndexOfMLevelTarget(MeasurementLevel measurementLevel) {
        if (measurementLevel == MeasurementLevel.scale) {
            return 0;
        }
        if (measurementLevel == MeasurementLevel.nominal) {
            return 1;
        }
        if (measurementLevel == MeasurementLevel.ordinal) {
            return 2;
        }
        return 0;
    }

    static int getIndexOfMLevelInput(MeasurementLevel measurementLevel, boolean bl) {
        if (measurementLevel == MeasurementLevel.scale) {
            return 0;
        }
        if (measurementLevel == MeasurementLevel.nominal) {
            if (bl) {
                return 1;
            }
            return 2;
        }
        if (measurementLevel == MeasurementLevel.ordinal) {
            return 3;
        }
        return 0;
    }

    private void initVars() {
        this.mNewFieldName = new StringTextField();
        this.mNewFieldName.setColumns(10);
        this.mNameLabel = DialogUtil.createLabel(this, "IDS_MC_NAME_TYPE_NAME_LABEL");
        this.mNameLabel.setLabelFor((Component)((Object)this.mNewFieldName));
        this.mInfoDes = new SimulationHelper.HelpPanel(this.mNameLabel.getFont());
        String string = this.getResString("IDS_MC_NAME_AND_TYPE_MSG");
        this.mInfoDes.setHelpTextAndIcon(string, null);
        this.mInnputMeasLabel = DialogUtil.createLabel(this, "IDS_MC_NAME_TYPE_MEASUREMENT_LABEL");
        this.mInputMeasLevelCombo = new JComboBox<String>(this.getResStringArray("IDS_MC_NAME_TYPE_ML_ARRARY"));
        this.mInputMeasLevelCombo.setAction(new ComboboxAction(this, INPUT_MEASUREMENT_COMBO));
        this.mInputMeasLevelCombo.addActionListener(this);
        this.mInnputMeasLabel.setLabelFor(this.mInputMeasLevelCombo);
        this.mRoleLabel = DialogUtil.createLabel(this, "IDS_MC_NAME_TYPE_ROLE_LABEL");
        Dimension dimension = this.mInputMeasLevelCombo.getPreferredSize();
        this.mFixedFieldTypes = new JComboBox<String>(this.getResStringArray("IDS_MC_NAME_TYPE_FIXED_TYPE_ARRARY"));
        this.mFixedFieldTypes.setPreferredSize(dimension);
        this.mFixedFieldTypes.setMinimumSize(dimension);
        this.mFixedFieldTypes.setAction(new ComboboxAction(this, FIXED_TYPE_COMBO));
        this.mFixedFieldTypes.setEditable(false);
        this.mTypeLabel = DialogUtil.createLabel(this, "IDS_MC_NAME_TYPE_TYPE_LABEL");
        this.mTypeLabel.setLabelFor(this.mFixedFieldTypes);
        this.mFixedDefaultLabel = DialogUtil.createLabel(this, "IDS_MC_NAME_TYPE_DEFAULT_LABEL");
        this.mFixedDefaultValue = new StringTextField();
        this.mFixedDefaultValue.setAction((Action)new TextFieldAction(this, FIXED_DEFAULT_VALUE));
        this.mFixedDefaultValue.setColumns(12);
        this.mFixedDefaultLabel.setLabelFor((Component)this.mFixedDefaultValue);
        this.mTargetButton = DialogUtil.createRadioButton(this, TARGET_BUTTON, null);
        this.mTargetButton.addItemListener(this);
        this.mTargetMeasLabel = DialogUtil.createLabel(this, "IDS_MC_NAME_TYPE_MEASUREMENT_LABEL");
        this.mTargetMeasLevelCombo = new JComboBox<String>(this.getResStringArray("IDS_MC_NAME_TYPE_TARGET_ML_ARRARY"));
        this.mTargetMeasLevelCombo.setAction(new ComboboxAction(this, TARGET_MEASUREMENT_COMBO));
        this.mTargetMeasLevelCombo.addActionListener(this);
        this.mTargetMeasLabel.setLabelFor(this.mTargetMeasLevelCombo);
        this.mTargetCheck = DialogUtil.createCheckBox(this, TARGET_CHECK, null);
        this.mInputButton = DialogUtil.createRadioButton(this, INPUT_BUTTON, null);
        this.mInputButton.addItemListener(this);
        this.mFixedButton = DialogUtil.createRadioButton(this, FIXED_BUTTON, null);
        this.mFixedButton.addItemListener(this);
        this.mValueOptionGroup = new SpssButtonGroup();
        this.mValueOptionGroup.add(this.mTargetButton);
        this.mValueOptionGroup.add(this.mInputButton);
        this.mValueOptionGroup.add(this.mFixedButton);
        this.mValueLabelTableLabel = DialogUtil.createLabel(this, "IDS_MC_NAME_TYPE_VALUELABEL_LABEL");
        this.mTableModel = new DefaultTableModel(this.getResStringArray("IDS_MC_NAME_TYPE_TABLE_COL_NAME_ARRARY"), 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mValueLabelTable = new TableWithEmptyRow(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return NewFieldNameAndTypeSubDlg.this.getResString("IDS_MC_NAME_TYPE_VALUELABEL_LABEL");
            }

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent && ComponentState.isBtdRtlOrLtr() && (JTextComponent)component != null && ((JTextComponent)component).getDocument() != null) {
                    if (ComponentState.getBTD() == 1) {
                        ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    } else {
                        ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    }
                }
                return bl;
            }
        };
        this.mTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0 && NewFieldNameAndTypeSubDlg.this.mInputButton.isSelected() && (NewFieldNameAndTypeSubDlg.this.mInputMeasLevelCombo.getSelectedIndex() == 2 || NewFieldNameAndTypeSubDlg.this.mInputMeasLevelCombo.getSelectedIndex() == 3)) {
                    Object object;
                    int n = tableModelEvent.getFirstRow();
                    int n2 = tableModelEvent.getColumn();
                    if (n2 == 0 && (object = NewFieldNameAndTypeSubDlg.this.mTableModel.getValueAt(n, n2)) != null && object.toString().length() > 0) {
                        try {
                            Double.parseDouble(object.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog((Component)((Object)NewFieldNameAndTypeSubDlg.this), NewFieldNameAndTypeSubDlg.this.mResBundle.getString("IDS_MC_ERROR_ENTER_NUMBER"));
                            NewFieldNameAndTypeSubDlg.this.mTableModel.setValueAt("", n, n2);
                            NewFieldNameAndTypeSubDlg.this.mValueLabelTable.requestFocus();
                            return;
                        }
                    }
                }
            }
        });
        this.mValueLabelTable.setModel(this.mTableModel);
        this.mValueLabelTable.registerDeleteKeyAction();
        this.mValueLabelTable.setPreferredScrollableViewportSize(new Dimension(80, 40));
        this.mValueLabelTable.setRowHeight(22);
        this.mValueLabelTable.setColumnSelectionAllowed(false);
        this.mValueLabelTable.setRowSelectionAllowed(true);
        this.mValueLabelTable.setSelectionMode(0);
        this.mValueLabelTable.getTableHeader().setReorderingAllowed(false);
        this.mValueLabelTable.getTableHeader().setResizingAllowed(true);
        this.mValueLabelTable.setGridColor(Color.darkGray);
        this.mValueLabelTable.getTableHeader().setReorderingAllowed(false);
        this.mValueLabelTableLabel.setLabelFor(this.mValueLabelTable);
    }

    private void initializeDefaultTextField() {
        String string = "";
        if (this.mFixedDefaultValue != null) {
            string = this.mFixedDefaultValue.getText();
            if (string.length() > 0) {
                try {
                    this.mFixedDefaultValue.getDocument().remove(0, string.length());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.mFixedDefaultValue.removeAll();
        }
        if (this.mFixedFieldTypes.getSelectedIndex() == 0) {
            this.mFloatDocument = new FloatDocument();
            this.mFixedDefaultValue = new FloatTextField();
            this.mFixedDefaultValue.setColumns(12);
            this.mFixedDefaultValue.setDocument((Document)this.mFloatDocument);
        } else {
            this.mStringDoc = new PlainDocument();
            this.mFixedDefaultValue = new StringTextField();
            this.mFixedDefaultValue.setColumns(12);
            this.mFixedDefaultValue.setDocument((Document)this.mStringDoc);
        }
        if (string.length() > 0) {
            // empty if block
        }
    }

    private void setDefaults() {
        this.mNewFieldName.setText("");
        if (this.mIsTarget) {
            this.mTargetButton.setSelected(true);
            this.mTargetCheck.setSelected(true);
            this.mInputButton.setEnabled(false);
            this.mFixedButton.setEnabled(false);
        } else {
            this.mInputButton.setSelected(true);
            this.mTargetButton.setEnabled(false);
        }
        this.mValueLabelTable.setEnabled(true);
        this.mValueLabelTableLabel.setEnabled(true);
        this.mTargetMeasLevelCombo.setSelectedIndex(0);
        this.mInputMeasLevelCombo.setSelectedIndex(0);
        this.mFixedFieldTypes.setSelectedIndex(0);
        this.mFixedDefaultValue.setText("");
        this.enableValueLabelTable();
    }

    private void enableValueLabelTable() {
        int n = -1;
        if (this.mInputButton.isSelected()) {
            n = this.mInputMeasLevelCombo.getSelectedIndex();
        } else if (this.mTargetButton.isSelected()) {
            n = this.mTargetMeasLevelCombo.getSelectedIndex();
        }
        if (n == 0) {
            this.mValueLabelTableLabel.setEnabled(false);
            this.mValueLabelTable.setEnabled(false);
        } else {
            this.mValueLabelTableLabel.setEnabled(true);
            this.mValueLabelTable.setEnabled(true);
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfoDes);
        vector.add(this.mNewFieldName);
        vector.add(this.mTargetButton);
        vector.add(this.mTargetMeasLevelCombo);
        vector.add(this.mTargetCheck);
        vector.add(this.mInputButton);
        vector.add(this.mInputMeasLevelCombo);
        vector.add(this.mFixedButton);
        vector.add(this.mFixedFieldTypes);
        vector.add(this.mFixedDefaultValue);
        vector.add(this.mValueLabelTable);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = PanelFactory.getBasicPanel(new JComponent[]{this.mNameLabel, this.mNewFieldName}, PanelFactory.PanelType.xaxis, "");
        JPanel jPanel3 = PanelFactory.getBasicPanel(new JComponent[]{this.mTypeLabel, this.mFixedFieldTypes}, PanelFactory.PanelType.xaxis, "");
        JPanel jPanel4 = PanelFactory.getBasicPanel(new JComponent[]{this.mInnputMeasLabel, this.mInputMeasLevelCombo}, PanelFactory.PanelType.xaxis, "");
        JPanel jPanel5 = PanelFactory.getBasicPanel(new JComponent[]{this.mFixedDefaultLabel, this.mFixedDefaultValue}, PanelFactory.PanelType.xaxis, "");
        JPanel jPanel6 = PanelFactory.getBasicPanel(new JComponent[]{this.mTargetMeasLabel, this.mTargetMeasLevelCombo}, PanelFactory.PanelType.xaxis, "");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = 2;
        Insets insets = new Insets(1, n2, n2 + 1, n2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n3 = 0;
        int n4 = 260;
        int n5 = 46;
        this.mInfoDes.setMinimumSize(new Dimension(n4, n5));
        this.mInfoDes.setPreferredSize(new Dimension(n4, n5));
        DialogUtil.addUsingGBL(jPanel, this.mInfoDes, gridBagConstraints, 0, n3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mRoleLabel, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 6, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 12, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 12, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetCheck, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        insets.set(n2, n2 * 6, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mInputButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 12, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        insets.set(n2, n2 * 6, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFixedButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        insets.set(n2, n2 * 12, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2 * 12, n2 * 4, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        JPanel jPanel7 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mValueLabelTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mValueLabelTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, 80));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 80));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel7, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel7, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getEmptyPanel(""), gridBagConstraints, 0, ++n3, 1, 1, n, insets);
    }

    class ValueLabelTableModel
    extends DefaultTableModel {
        public ValueLabelTableModel(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        @Override
        public int getRowCount() {
            return super.getRowCount() + 1;
        }
    }
}

