/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.MC.CorrelationEntry;
import com.spss.java_client.ui.dialogs.MC.MCModelTab;
import com.spss.java_client.ui.dialogs.MC.MCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.MC.res.MCResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

public abstract class MonteCarloSimulationDlg
extends BaseTabbedDialog
implements ActionListener {
    private static final String NEW_PLAN_FILE_NAME = "IDS_MC_NEW_PLAN_FILE_NAME";
    protected static final Dimension sMinSwapperSize = new Dimension(180, 100);
    public static String FILE_HANDLE_KEY = "IDS_MC_PLAN_FILE_HANDLE_KEY";
    protected MCModelTab mModelTab;
    protected MCSimulationTab mSimulationTab;
    protected SimulationPlanHandler mSimHandler;
    protected FileTextField mPlanFilePath;
    private String mFileHandleName;

    public MonteCarloSimulationDlg(JFrame jFrame) {
        super(jFrame, true, MCResBundle.getDefaultResourceBundleName(), MCResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MC_TITLE"));
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        this.mFileHandleName = SimulationHelper.getFileHandleName();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(FILE_HANDLE_KEY, this.mFileHandleName);
        stringBuffer.append(this.mModelTab.getSimPrepSyntax());
        boolean bl = super.getPressedButton() == this.mOkButton;
        stringBuffer.append(SimulationHelper.generateSimCREATESyntax(dialogDataModel, false, bl));
        stringBuffer.append(SimulationHelper.generateSIMRUNsyntax(dialogDataModel));
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.mModelTab.doValidateTab()) {
            return false;
        }
        if (!this.mSimulationTab.doValidateTab()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void loadDialogState() {
        super.loadSimpleState();
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    public void reset() {
        this.mModelTab.reset();
        this.mSimulationTab.reset();
        this.mPlanFilePath.setText("");
    }

    void selectSimulationTab() {
        this.mTabbedPane.setSelectedIndex(1);
    }

    void selectModelTab() {
        this.mTabbedPane.setSelectedIndex(0);
    }

    public static double formatDoubleValue(double d, int n) {
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(n);
            return numberFormat.parse(numberFormat.format(d)).doubleValue();
        }
        catch (ParseException parseException) {
            return d;
        }
    }

    public String showSaveDialog() {
        return this.showSaveDialog(this.getResString("IDS_MC_OUTPUT_SAVE_SIMULATION_FILE_TITLE"), this.getResString("IDS_MC_OUTPUT_SAVE_PLAN_FILE_FILTER"), this.getResString("IDS_MC_OUTPUT_SAVE_PLAN_FILE_FILTER_EXTN"));
    }

    public String showSaveDialog(String string, String string2, String string3) {
        return MonteCarloSimulationDlg.showSaveDialog((Component)((Object)this), string, string2, string3);
    }

    public static String showSaveDialog(Component component, String string, String string2, String string3) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string3));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog(component);
        if (n == 0) {
            String string4 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            int n2 = string4.indexOf(string3);
            if (n2 == -1) {
                string4 = string4.concat(string3);
            }
            return string4;
        }
        return "";
    }

    void removeInput(Vector<SimulatedField> vector) {
        this.mSimulationTab.removeInput(vector);
    }

    void removeOneInput(String string) {
        this.mSimulationTab.removeOneInput(string);
    }

    void updateSimulationTab(Object[] objectArray, Hashtable<String, Object[]> hashtable) {
        this.updateSimulationTab(objectArray, hashtable, null);
    }

    void updateSimulationTab(Object[] objectArray, Hashtable<String, Object[]> hashtable, Hashtable<String, SimulatedField> hashtable2) {
        this.mSimulationTab.updateSimulatedTable(objectArray, hashtable, hashtable2);
    }

    public void reloadSimulationTab(ArrayList<SimulatedField> arrayList, ArrayList<SimulatedField> arrayList2) {
        this.reloadSimulationTab(arrayList, null, null, "", arrayList2);
    }

    public void reloadSimulationTab(ArrayList<SimulatedField> arrayList, ArrayList<SimulationPlanHandler.TargetField> arrayList2, ArrayList<SimulationPlanHandler.SamplingCriteria> arrayList3, String string) {
        this.reloadSimulationTab(arrayList, arrayList2, arrayList3, string, null);
    }

    public void reloadSimulationTab(ArrayList<SimulatedField> arrayList, ArrayList<SimulationPlanHandler.TargetField> arrayList2, ArrayList<SimulationPlanHandler.SamplingCriteria> arrayList3, String string, ArrayList<SimulatedField> arrayList4) {
        this.mSimulationTab.reloadSimulation(arrayList, arrayList2, arrayList3, string, arrayList4);
    }

    public void reloadCorrelation(ArrayList<CorrelationEntry> arrayList) {
        this.mSimulationTab.loadCorrelationTable(arrayList);
    }

    public void reloadCorrelation(ArrayList<CorrelationEntry> arrayList, boolean bl, Vector<String> vector) {
        this.mSimulationTab.loadCorrelationTable(arrayList, bl, vector);
    }

    static JPanel setupTablePanel(JTable jTable, JLabel jLabel, JButton[] jButtonArray) {
        return MonteCarloSimulationDlg.setupTablePanel(jTable, jLabel, jButtonArray, null);
    }

    static JPanel setupTablePanel(JTable jTable, JLabel jLabel, JButton[] jButtonArray, JPanel jPanel) {
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, n2 - 4, 6, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, 0, -3, 20);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 2;
        if (jButtonArray.length == 1) {
            gridBagConstraints.fill = 0;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, 0);
        int n3 = 1;
        for (JButton jButton : jButtonArray) {
            if (n3 == 1) {
                insets.set(0, 30, 0, 0);
            } else if (n3 == jButtonArray.length) {
                insets.set(0, 0, 0, n2);
            } else {
                insets.set(0, 0, 0, 0);
            }
            DialogUtil.addUsingGBL(jPanel2, jButton, gridBagConstraints, n3, 0, 1, 1, 24, insets);
            ++n3;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 20, 2, n2);
        JScrollPane jScrollPane = new JScrollPane(jTable, 20, 31);
        jLabel.setLabelFor(jTable);
        jScrollPane.setMinimumSize(sMinSwapperSize);
        jScrollPane.setPreferredSize(sMinSwapperSize);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, 0, 2, n2);
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, jButtonArray.length + 1, 1, n, insets);
        if (jPanel != null) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            n = 10;
            DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        }
        Dimension dimension = jPanel2.getPreferredSize();
        if (dimension.width > 500) {
            dimension.width = 500;
            jPanel2.setPreferredSize(dimension);
        }
        return jPanel2;
    }

    public MCModelTab getModelTab() {
        return this.mModelTab;
    }

    public MCSimulationTab getSimulationTab() {
        return this.mSimulationTab;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
    }

    @Override
    protected void init() {
        this.mPlanFilePath = new FileTextField();
        this.mPlanFilePath.setEnabled(false);
        this.mPlanFilePath.setEditable(false);
        this.mPlanFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mPlanFilePath.setAction(new TextFieldAction(this, NEW_PLAN_FILE_NAME));
        this.mUseContainerListener = false;
        super.init();
        this.mOkAction.putValue("Name", ResUtil.getCommonDlgString("IDS_RUN"));
        DialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
    }

    @Override
    protected void addMainViewComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, 4);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mPlanFilePath), gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel = new JLabel("                     ");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 20, 0, 20);
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, 6);
        gridBagConstraints.fill = 2;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    public static enum FitToState {
        DistributionNotSet,
        DistributionFittedBefore,
        DistributionFitChanged,
        MatchedAndFitted,
        ManualDefined;

    }

    public static enum CriteriaUnit {
        value,
        percent;

    }

    public static enum CriteriaType {
        point_value,
        tail;

    }

    public static enum CorrelationStructure {
        EQUAL,
        TOEPLITZ,
        FACTOR,
        UNSTRUCTURED,
        RANDOM;

    }
}

