/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.pasw.framework.common.data.DataModel;
import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.MeasurementType;
import com.pasw.framework.common.data.ModelOutputDescriptor;
import com.pasw.framework.common.data.ModelOutputRole;
import com.pasw.framework.common.data.RoleType;
import com.pasw.framework.common.data.StorageType;
import com.spss.cftool.ToolDataModelProvider;
import com.spss.cftool.data.ToolField;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.server.messages.sysfilemsg.CFExecutionResponse;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.MC.CorrelationEntry;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.direct_marketing.ParseScoringPropertiesXML;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelPMMLFileHandler {
    private static ArrayList<String> mSupportedModelNames = ModelPMMLFileHandler.loadSupportedModel();
    private static final int SYNC_TIMEOUT_VALUE = 3600000;
    private String mModelFilePath;
    private String mErrorMessage;
    private ParseScoringPropertiesXML.ScoringPropertiesInfo mScoringPropertiesInfo = null;
    private ArrayList<String> mInputFieldNames;
    private ArrayList<String> mTargetFieldNames;
    private ArrayList<SimulatedField> mSimulatedPredictors;
    private ArrayList<SimulatedField> mTargets;
    private Hashtable<String, Field> mInputFields;
    private ArrayList<CorrelationEntry> mCorrelations;

    public ModelPMMLFileHandler(String string) {
        this.mModelFilePath = string;
        this.mErrorMessage = "";
        this.mInputFieldNames = new ArrayList();
        this.mTargetFieldNames = new ArrayList();
        this.mTargets = new ArrayList();
        this.mInputFields = new Hashtable();
        this.mCorrelations = new ArrayList();
        this.parsingModelPMML();
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public ArrayList<String> getInputFieldNames() {
        return this.mInputFieldNames;
    }

    public ArrayList<String> getTargetFieldNames() {
        return this.mTargetFieldNames;
    }

    public String getModelTypeName() {
        if (this.mScoringPropertiesInfo != null) {
            return this.mScoringPropertiesInfo.getModelType();
        }
        return "";
    }

    public ArrayList<SimulatedField> getTargets() {
        return this.mTargets;
    }

    public ArrayList<SimulatedField> getSimulatedPredictors() {
        int n = this.mInputFieldNames.size();
        int n2 = this.mTargetFieldNames.size();
        this.mSimulatedPredictors = new ArrayList(n);
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < n; ++i) {
            String string = this.mInputFieldNames.get(i);
            SimulatedField simulatedField = new SimulatedField(string);
            for (int j = 0; j < n2; ++j) {
                simulatedField.addRelatedModelName(this.mTargetFieldNames.get(j));
            }
            Field field = this.mInputFields.get(string);
            MeasurementLevel measurementLevel = this.getSPSSMLevel(field.getFieldMeasurement());
            simulatedField.setMeasurementLevel(measurementLevel);
            SPSS_Format sPSS_Format = this.getSpssFormat(field.getFieldStorage());
            if (sPSS_Format.getFormatType().isStringFormat()) {
                simulatedField.setType((short)1);
            }
            simulatedField.setFormat(sPSS_Format);
            int n3 = 0;
            if (field instanceof ToolField) {
                n3 = ((ToolField)field).getValueLabelKeyCount();
            }
            if (measurementLevel == MeasurementLevel.nominal) {
                Iterator iterator = field.getValueLabelKeys();
                this.setCategoricalDist(simulatedField, iterator, n3, field);
            }
            this.mSimulatedPredictors.add(i, simulatedField);
        }
        return this.mSimulatedPredictors;
    }

    public ArrayList<CorrelationEntry> getCorrelationMatrix() {
        return this.mCorrelations;
    }

    private void setCategoricalDist(SimulatedField simulatedField, Iterator<Object> iterator, int n, Field field) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            vector.add(n2, object.toString());
            String string = field.getValueLabel(object);
            if (string != null && string.length() > 0) {
                simulatedField.addCatValueLableFromModel(object.toString(), string);
            }
            Pair pair = new Pair((Object)object.toString(), (Object)"");
            arrayList.add(n2++, (Pair<String, String>)pair);
        }
        simulatedField.setCatsFromModel(vector, n);
        simulatedField.addParameter(SimulationHelper.DistributionType.MULTINOMIAL, arrayList);
        simulatedField.setDistributionType(SimulationHelper.DistributionType.MULTINOMIAL);
    }

    private MeasurementLevel getSPSSMLevel(MeasurementType measurementType) {
        if (measurementType == MeasurementType.continuous) {
            return MeasurementLevel.scale;
        }
        if (measurementType == MeasurementType.ordinal) {
            return MeasurementLevel.ordinal;
        }
        if (measurementType == MeasurementType.unknown || measurementType == MeasurementType.typeless) {
            return MeasurementLevel.unknown;
        }
        return MeasurementLevel.nominal;
    }

    private SPSS_Format getSpssFormat(StorageType storageType) {
        SPSS_Format sPSS_Format = new SPSS_Format();
        if (storageType == StorageType.real || storageType == StorageType.integer) {
            sPSS_Format.setFormatType(FormatType.F);
        } else if (storageType == StorageType.string) {
            sPSS_Format.setFormatType(FormatType.A);
        } else if (storageType == StorageType.date) {
            sPSS_Format.setFormatType(FormatType.DATE);
        } else if (storageType == StorageType.time || storageType == StorageType.timestamp) {
            sPSS_Format.setFormatType(FormatType.TIME);
        } else {
            sPSS_Format.setFormatType(FormatType.F);
        }
        return sPSS_Format;
    }

    private String getModelPMMLPath() {
        return this.mModelFilePath;
    }

    public String getEnsembleType() {
        if (this.mScoringPropertiesInfo != null) {
            return this.mScoringPropertiesInfo.getEnsembleType();
        }
        return "";
    }

    private void parsingModelPMML() {
        String string = ModelPMMLFileHandler.getExecutionXML(true);
        CFExecutionResponse cFExecutionResponse = SysFileProxy.getSysFileProxy().executeBackendFrameworkOperation(SpssMgr.getSpssMgr().getActiveClientDatasetId(), string.getBytes(), "InputPMMLContainer", null, this.mModelFilePath, 3600000, false);
        if (cFExecutionResponse != null) {
            if (cFExecutionResponse.getErrorCode() == 0) {
                if (cFExecutionResponse.getErrorXml() != null && cFExecutionResponse.getErrorXml().length > 0) {
                    String string2 = this.parseErrorMessage(new ByteArrayInputStream(cFExecutionResponse.getErrorXml()), -1);
                    if (string2 != null || !this.executionReponseHasModelXML(cFExecutionResponse)) {
                        this.mErrorMessage = "IDS_MC_ERROR_INVALID_MODEL";
                    } else {
                        this.mScoringPropertiesInfo = ParseScoringPropertiesXML.initParseScoringPropertiesFromXML(new String(cFExecutionResponse.getModelPropertiesXml()));
                        if (this.mScoringPropertiesInfo != null && !this.mScoringPropertiesInfo.isUnknownModel()) {
                            if (!mSupportedModelNames.contains(this.mScoringPropertiesInfo.getModelType()) || this.mScoringPropertiesInfo.isHasSplits()) {
                                this.mErrorMessage = "IDS_MC_ERROR_NOT_SUPPORTED_MODEL";
                                return;
                            }
                            this.fillInputFieldList(this.readModelFromXML(cFExecutionResponse.getInputDataModelXml()));
                            if (this.mInputFieldNames.size() == 0) {
                                this.mErrorMessage = "IDS_MC_MODEL_PMML_NO_INPUT";
                            }
                            this.fillTargetField(this.readModelFromXML(cFExecutionResponse.getOutputDataModelXml()));
                        } else {
                            this.mErrorMessage = "IDS_MC_ERROR_INVALID_MODEL";
                        }
                    }
                } else {
                    this.mErrorMessage = "IDS_MC_ERROR_INVALID_MODEL";
                }
            } else {
                String string3;
                String string4 = cFExecutionResponse.getErrorCode() == 1 ? "ERR_NO_XFORMS" : "ERR_INTERNAL_ERROR";
                this.mErrorMessage = string3 = ResUtil.getCommonDlgString(string4);
            }
        }
    }

    private void fillTargetField(DataModel dataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        this.mTargetFieldNames = new ArrayList();
        for (int i = 0; i < dataModel.getFieldCount(); ++i) {
            ModelOutputDescriptor modelOutputDescriptor;
            Field field = dataModel.getField(dataModel.getFieldName(i));
            if (field.getModelOutputDescriptor() == null || (modelOutputDescriptor = field.getModelOutputDescriptor()).getModelOutputRole() != ModelOutputRole.predictedValue || modelOutputDescriptor.getTargetField() == null) continue;
            if (i != 0) {
                stringBuffer.append(", ");
            }
            String string = modelOutputDescriptor.getTargetField();
            this.mTargetFieldNames.add(string);
            SimulatedField simulatedField = new SimulatedField(string);
            simulatedField.setMeasurementLevel(this.getSPSSMLevel(field.getFieldMeasurement()));
            StorageType storageType = field.getFieldStorage();
            simulatedField.setFormat(this.getSpssFormat(storageType));
            if (storageType == StorageType.string) {
                simulatedField.setType((short)1);
            }
            this.mTargets.add(this.mTargets.size(), simulatedField);
        }
    }

    private void fillInputFieldList(DataModel dataModel) {
        ArrayList<RoleType> arrayList = new ArrayList<RoleType>();
        arrayList.add(RoleType.input);
        arrayList.add(RoleType.both);
        this.mInputFieldNames = this.getFieldNamesOfRoleType(dataModel, arrayList);
    }

    private ArrayList<String> getFieldNamesOfRoleType(DataModel dataModel, ArrayList<RoleType> arrayList) {
        String string;
        Object object;
        int n;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < dataModel.getFieldCount(); ++n) {
            String string2 = dataModel.getFieldName(n);
            object = dataModel.getField(string2);
            if (!arrayList.contains(object.getFieldRole())) continue;
            arrayList2.add(string2);
            this.mInputFields.put(string2, (Field)object);
            string = object.getFieldMeasurement();
            if (string != MeasurementType.continuous && string != MeasurementType.ordinal) continue;
            vector.add(string2);
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (String)vector.get(n);
                string = (String)vector.get(i);
                double d = n == i ? 1.0 : 0.0;
                CorrelationEntry correlationEntry = new CorrelationEntry((String)object, string, d);
                this.mCorrelations.add(correlationEntry);
            }
        }
        return arrayList2;
    }

    private DataModel readModelFromXML(byte[] byArray) {
        ToolDataModelProvider toolDataModelProvider = new ToolDataModelProvider();
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (string != null) {
            toolDataModelProvider.setDataModelFromXml(string);
        }
        return toolDataModelProvider.getDataModel();
    }

    private boolean executionReponseHasModelXML(CFExecutionResponse cFExecutionResponse) {
        return cFExecutionResponse.getInputDataModelXml() != null && cFExecutionResponse.getInputDataModelXml().length > 0 && cFExecutionResponse.getOutputDataModelXml() != null && cFExecutionResponse.getOutputDataModelXml().length > 0 && cFExecutionResponse.getModelPropertiesXml() != null && cFExecutionResponse.getModelPropertiesXml().length > 0;
    }

    private String parseErrorMessage(InputStream inputStream, int n) {
        String string = null;
        if (inputStream != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                documentBuilderFactory.setIgnoringComments(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName("Message");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    node = node.getFirstChild();
                    stringBuffer.append(node.getNodeValue());
                    if (i >= n && n != -1) break;
                    if (i >= nodeList.getLength() - 1) continue;
                    stringBuffer.append("\n");
                }
                string = stringBuffer.toString().trim().length() > 0 ? stringBuffer.toString() : null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                string = parserConfigurationException.getLocalizedMessage();
            }
            catch (SAXException sAXException) {
                string = sAXException.getLocalizedMessage();
            }
            catch (IOException iOException) {
                string = iOException.getLocalizedMessage();
            }
        }
        return string;
    }

    public String createFieldNamesText(ArrayList<String> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i));
            if (i + 1 >= arrayList.size()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    static String getExecutionXML(boolean bl) {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\n<Execution>\n<ContainerInputs>\n<ContainerInput id=\"InputPMMLContainer\"/>\n</ContainerInputs>\n<Operation componentId=\"scoring\" dependencyIds=\"\" id=\"1\" inputIds=\"\" moduleId=\"pasw.scoring\" version=\"2.0\">\n<Parameters>\n<Parameter name=\"missingValuePolicy\" value=\"";
        string = bl ? string + "scoreAsMissing" : string + "asMissingPredictor";
        string = string + "\"/>\n<Parameter name=\"encoding\" value=\"UTF-8\"/>\n<Parameter name=\"scoringDll\">\n<StructuredValue>\n<Attribute name=\"SmartScore\" value=\"mcscorersmart\"/>\n<Attribute name=\"NeuralNetwork\" value=\"mcscorernnet\"/>\n<Attribute name=\"MiningModel\" value=\"mcscorermining\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"modelDll\">\n<StructuredValue>\n<Attribute name=\"TreeModel\" value=\"TreeModel\"/>\n<Attribute name=\"discriminant-model\" value=\"discriminant-model\"/>\n<Attribute name=\"GeneralRegressionModel\" value=\"GeneralRegressionModel\"/>\n<Attribute name=\"ClusteringModel\" value=\"ClusteringModel\"/>\n<Attribute name=\"NeuralNetwork\" value=\"NeuralNetwork\"/>\n<Attribute name=\"AssociationModelLattice\" value=\"AssociationModelLattice\"/>\n<Attribute name=\"SeqAssociationLattice\" value=\"SeqAssociationLattice\"/>\n<Attribute name=\"NaiveBayesModel\" value=\"NaiveBayesModel\"/>\n<Attribute name=\"AssociationModel\" value=\"AssociationModel\"/>\n<Attribute name=\"RuleSetModel\" value=\"RuleSetModel\"/>\n<Attribute name=\"BayesNetModel\" value=\"BayesNetModel\"/>\n<Attribute name=\"SupportVectorMachineModel\" value=\"SupportVectorMachineModel\"/>\n<Attribute name=\"NearestNeighborModel\" value=\"NearestNeighborModel\"/>\n<Attribute name=\"MiningModel\" value=\"MiningModel\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"maxPredictions\" value=\"3\"/>\n<Parameter name=\"versionSupported\" value=\"4.0\"/>\n<Parameter name=\"isOutputInputData\" value=\"false\"/>\n<Parameter name=\"isOutputAll\" value=\"true\"/>\n<Parameter name=\"isPrediction\" value=\"true\"/>\n<Parameter name=\"isProbability\" value=\"false\"/>\n<Parameter name=\"isProbabilityCategory\" value=\"false\"/>\n<Parameter name=\"isConfidence\" value=\"true\"/>\n<Parameter name=\"isStandardDeviation\" value=\"false\"/>\n<Parameter name=\"isPropensity\" value=\"false\"/>\n<Parameter name=\"isRawPropensity\" value=\"false\"/>\n<Parameter name=\"isNodeID\" value=\"false\"/>\n<Parameter name=\"isCumHazard\" value=\"false\"/>\n<Parameter name=\"isNeighbor\" value=\"false\"/>\n<Parameter name=\"isDistance\" value=\"false\"/>\n<Parameter name=\"isOthers\" value=\"false\"/>\n<Parameter name=\"isEnsemble\" value=\"true\"/>\n<Parameter name=\"isBaseModels\" value=\"false\"/>\n<Parameter name=\"isReferenceModel\" value=\"false\"/>\n<Parameter name=\"modelID\">\n<StructuredValue>\n<Attribute name=\"TreeModel\" value=\"R\"/>\n<Attribute name=\"discriminant-model\" value=\"discriminant-model\"/>\n<Attribute name=\"GeneralRegressionModel\" value=\"L\"/>\n<Attribute name=\"ClusteringModel\" value=\"ClusteringModel\"/>\n<Attribute name=\"NeuralNetwork\" value=\"N\"/>\n<Attribute name=\"AssociationModelLattice\" value=\"AssociationModelLattice\"/>\n<Attribute name=\"SeqAssociationLattice\" value=\"SeqAssociationLattice\"/>\n<Attribute name=\"NaiveBayesModel\" value=\"NaiveBayesModel\"/>\n<Attribute name=\"AssociationModel\" value=\"AssociationModel\"/>\n<Attribute name=\"RuleSetModel\" value=\"RuleSetModel\"/>\n<Attribute name=\"BayesNetModel\" value=\"B\"/>\n<Attribute name=\"SupportVectorMachineModel\" value=\"S\"/>\n<Attribute name=\"NearestNeighborModel\" value=\"NearestNeighborModel\"/>\n<Attribute name=\"MiningModel\" value=\"MiningModel\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"resultType\">\n<StructuredValue>\n<Attribute name=\"prediction\" value=\"\"/>\n<Attribute name=\"probability\" value=\"P\"/>\n<Attribute name=\"probcategory\" value=\"P\"/>\n<Attribute name=\"confidence\" value=\"C\"/>\n<Attribute name=\"stddev\" value=\"S\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"namePattern\">\n<StructuredValue>\n<Attribute name=\"prediction\" value=\"${M}{S}-{T}\"/>\n<Attribute name=\"probability\" value=\"${M}{R}{S}-{T}\"/>\n<Attribute name=\"probcategory\" value=\"${M}{R}{S}-{C}\"/>\n<Attribute name=\"confidence\" value=\"${M}{R}{S}-{T}\"/>\n<Attribute name=\"stddev\" value=\"StdDev\"/>\n<Attribute name=\"tree-nodeid\" value=\"NodeID\"/>\n<Attribute name=\"cox-cumhazard\" value=\"CumHazard\"/>\n<Attribute name=\"knn-caseid\" value=\"Neighor\"/>\n<Attribute name=\"knn-distance\" value=\"Distance\"/>\n<Attribute name=\"adjustedpropensity\" value=\"$AP{S}-{T}\"/>\n<Attribute name=\"rawpropensity\" value=\"$RP{S}-{T}\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"nameList\">\n<StructuredValue>\n<Attribute name=\"prediction\" value=\"\"/>\n<Attribute name=\"probability\" value=\"\"/>\n<Attribute name=\"probcategory\">\n<ListValue/>\n</Attribute>\n<Attribute name=\"confidence\" value=\"\"/>\n<Attribute name=\"stddev\" value=\"\"/>\n<Attribute name=\"tree-nodeid\" value=\"\"/>\n<Attribute name=\"cox-cumhazard\" value=\"\"/>\n<Attribute name=\"knn-caseid\">\n<ListValue/>\n</Attribute>\n<Attribute name=\"knn-distance\">\n<ListValue/>\n</Attribute>\n<Attribute name=\"adjustedpropensity\" value=\"\"/>\n<Attribute name=\"rawpropensity\" value=\"\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"useNameList\" value=\"false\"/>\n<Parameter name=\"resolveNameConflict\" value=\"true\"/>\n<Parameter name=\"enableSQL\" value=\"false\"/>\n<Parameter name=\"maxCategories\" value=\"25\"/>\n<Parameter name=\"confidenceBasedOn\" value=\"onProbability\"/>\n<Parameter name=\"scoreValue\" value=\"\"/>\n</Parameters>\n<InputContainers>\n<Container id=\"InputPMMLContainer\" name=\"InputPMML\"/>\n</InputContainers>\n</Operation>\n</Execution>";
        return string;
    }

    private static ArrayList<String> loadSupportedModel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("LR");
        arrayList.add("GLR");
        arrayList.add("GZLR");
        arrayList.add("BLR");
        arrayList.add("COXREG");
        arrayList.add("MLR");
        arrayList.add("OR");
        arrayList.add("DA");
        arrayList.add("TREE_PMML");
        arrayList.add("CLUSTER_TWOSTEP");
        arrayList.add("NNETWORK_MLP");
        arrayList.add("NNETWORK_RBF");
        arrayList.add("NNETWORK_SOM");
        arrayList.add("CLUSTER_KMEANS");
        arrayList.add("RULESET_DL");
        arrayList.add("TREE_BOOSTED");
        return arrayList;
    }
}

