/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.MC.BaseMCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.CorrelationEntry;
import com.spss.java_client.ui.dialogs.MC.FitSelectSubDlg;
import com.spss.java_client.ui.dialogs.MC.FitStatistics;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SensitivityAnalysisSub;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulatedFieldTable;
import com.spss.java_client.ui.dialogs.MC.SimulatedFieldTableModel;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.MC.SimulationSidebarSelectorPanel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.shared.core_tools.utils.ZipUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class MCSimulationTab
extends BaseMCSimulationTab
implements ItemListener,
ActionListener,
IFrequencyScannerListener,
FocusListener,
TableModelListener {
    private static int sMAX_NUM = Integer.MAX_VALUE;
    private static int sMIN_NUM = 1;
    public static final String SIMULATION_TARGET_NAMES = "IDS_MC_SIMALATION_TARGET_NAMES";
    public static final String SIMULATION_TABLE_KEY = "IDS_MC_SIMULATION_TABLE_KEY";
    public static final String SIMULATION_FORMAT_TABLE = "IDS_MC_SIMALATION_FORMAT";
    public static final String SIMULATION_TARGET_LIMIT_TABLE = "IDS_MC_SIMULATION_TARGET_LIMIT_TABLE";
    private static final String CORRELATION_STRUCTURE_COMBO = "IDS_MC_CORRELATION_STRUCTURE_COMBO";
    public static final String NEW_PLAN_FILE_NAME = "IDS_MC_SAVE_PLAN_FILE_NAME";
    public static final String NEW_DATASET_NAME = "IDS_MC_SAVE_NEW_DATASET_NAME";
    public static final String NEW_SAV_FILE_NAME = "IDS_MC_SAVE_NEW_SAV_FILE_NAME";
    public static final String NEW_EXCEL_FILE_NAME = "IDS_MC_SAVE_NEW_EXCEL_FILE_NAME";
    private static final String TAIL_TYPE_COMBO = "IDS_MC_OPTION_TAIL_TYPE_COMBO";
    private static final String TAIL_SIDE_COMBO = "IDS_MC_OPTION_TAIL_SIDE_COMBO";
    public static final String TAIL_PERCENTILE_VALUE = "IDS_MC_OPTION_TAIL_PERCENTILE_VALUE";
    public static final String OPTION_TAIL_VALUE = "IDS_MC_OPTION_OPTION_TAIL_VALUE";
    private static final String THRESH_TYPE_COMBO = "IDS_MC_OPTION_THRESH_TYPE_COMBO";
    public static final String THRESH_PERCENTILE = "IDS_MC_OPTION_THRESH_PERCENTILE";
    public static final String THRESH_VALUE = "IDS_MC_OPTION_THRESH_VALUE";
    public static final String THRESH_CONFIDENCE = "IDS_MC_OPTION_THRESH_CONFIDENCE";
    public static final String LIMIT_CASE_NUM = "IDS_MC_OPTION_LIMIT_CASE_NUM";
    public static final String SEED_VALUE = "IDS_MC_OPTION_SEED_VALUE";
    private static final String TARGET_COMBO = "IDS_MC_OPTION_TARGET_COMBO";
    public static final String TORNADO_STDDEV_VALUE = "IDS_MC_TORNADO_STDDEV_VALUE";
    public static final String DF_DESC_CONF_VALUE = "IDS_MC_DESC_CONF_VALUE";
    public static final String OUTPUT_INTERVAL_VALUE = "IDS_MC_OUTPUT_INTERVAL_VALUE";
    public static final String DF_SIGMA_LEVEL_VALUE = "IDS_MC_DF_SIGMA_LEVEL_VALUE";
    public static final String DF_PERCENTILE_TOP_VALUE = "IDS_MC_DF_PERCENTILE_TOP_VALUE";
    public static final String DF_PERCENTILE_BOTTOM_VALUE = "IDS_MC_DF_PERCENTILE_BOTTOM_VALUE";
    public static final String DF_CUSTOM_REF_VALUES = "IDS_MC_DF_CUSTOM_REF_VALUES";
    public static final String DF_SLIDER_LOW_VALUE = "IDS_MC_DF_SLIDER_LOW_VALUE";
    public static final String DF_SLIDER_UPPER_VALUE = "IDS_MC_DF_SLIDER_UPPER_VALUE";
    public static final String EMPERICAL_BINS = "IDS_MC_EMPERICAL_BINS";
    public static final String NUM_CASES_TO_GENERATE = "IDS_MC_NUM_CASES_TO_GENERATE";
    public static final String OPTION_CRITERIA_TARGET_NAME = "IDS_MC_OPTION_CRITERIA_TARGET_NAME";
    public static final String OPTION_CRITERIA_TTHRESH_TYPE = "IDS_MC_OPTION_CRITERIA_TTHRESH_TYPE";
    public static final String OPTION_CRITERIA_TAIL_TYPE = "IDS_MC_OPTION_CRITERIA_TAIL_TYPE";
    public static final String OPTION_CRITERIA_TAIL_FREQ = "IDS_MC_OPTION_CRITERIA_TAIL_FREQ";
    public static final String OPTION_CRITERIA_TAIL_SIDE = "IDS_MC_OPTION_CRITERIA_TAIL_SIDE";
    public static final String CORRELATION_TABLE_KEY = "IDS_MC_CORRELATION_TABLE_KEY";
    public static final String CORRELATION_TABLE_CHANGED = "IDS_MC_CORRELATION_TABLE_CHANGED";
    public static final String OUTPUT_CUSTOM_PERCENT_TABLE_KEY = "IDS_MC_OUTPUT_CUSTOM_PERCENT_TABLE_KEY";
    private static final Dimension sMinListSize = new Dimension(100, 60);
    private boolean mHasSimPlan = false;
    private SimulationSidebarSelectorPanel mSimulationPanel;
    private JPanel mSimulatedField;
    private JButton mFitSelectedButton;
    private JButton mFitAllButton;
    private JButton mFitDetaildButton;
    private JButton mSensitivityButton;
    private SimulatedFieldTable mSimulatedFieldTable;
    private JLabel mSimulatedFieldTableLabel;
    private String mPlanTimeStamp = "";
    private JPanel mCorrelations;
    private JRadioButton mCorrRecalButton;
    private JRadioButton mCorrDontCalButton;
    private SpssButtonGroup mCorrGroup;
    private JButton mCorrResetButton;
    private JTable mCorrelationTable;
    private CorrelationTableModel mCorrelationTableModel;
    private JLabel mCorrelationTableLabel;
    private FloatTextField mCorrField;
    private StringTextField mCorrExcludeMesg;
    private boolean mCorrelationModified;
    private JCheckBox mCorrCrosstabCheck;
    private JRadioButton mCtgtFromDataButton;
    private JRadioButton mCtgtFromPlanButton;
    private SpssButtonGroup mCgtGroup;
    private JPanel mOptions;
    private JLabel mNumOfSCasesLabel;
    private IntTextField mNumOfScasesField;
    private JLabel mTargetLabel;
    private DefaultComboBoxModel mTargetComboModel;
    private JComboBox mTargetCombo;
    private Vector<String> mTargetNames = new Vector();
    private Vector<String> mAllVarNames = new Vector();
    private Vector<Integer> mFormatsIndice = new Vector();
    private Vector<Integer> mDecimals = new Vector();
    private JLabel mNumLabelEnd;
    private StringTextField mStopCriteriaLabel;
    private JRadioButton mNoneButton;
    private JRadioButton mTailButton;
    private JLabel mTailTypeLabel;
    private JComboBox mTailTypeCombo;
    private JLabel mTailSideLabel;
    private JComboBox mTailSideCombo;
    private JLabel mTailPercentileLabel;
    private FloatTextField mTailPercenField;
    private JLabel mTailFreqLabel;
    private IntTextField mTailFreq;
    private JLabel mTailValueLabel;
    private FloatTextField mTailValueField;
    private JLabel mBinSpinnderLabel;
    private NumberSpinner mBinNumber;
    private JRadioButton mThresholdButton;
    private SpssButtonGroup mCriteriaGroup;
    private JLabel mThreshTypeLabel;
    private JComboBox mThreshTypeCombo;
    private JLabel mThreshPercenLabel;
    private FloatTextField mThreshPercenField;
    private JLabel mThreshConfLabel;
    private FloatTextField mThreshConfField;
    private JLabel mThreshValuefLabel;
    private FloatTextField mThreshValueField;
    private StringTextField mNumCasesToUseLabel;
    private JRadioButton mNCasesButton;
    private JRadioButton mAllCases;
    private SpssButtonGroup mCasesButtonGroup;
    private JLabel mNLabel;
    private IntTextField mLimitNCaseField;
    private FocusableTextArea mFitForScaleFieldsLabel;
    private JRadioButton mAndersonDarlingButton;
    private JRadioButton mScaleKSButton;
    private SpssButtonGroup mFitScaleGroup;
    private FocusableTextArea mCatMissingLabel;
    private JRadioButton mMisExcludeButton;
    private JRadioButton mMisIncludeButton;
    private SpssButtonGroup mMissGroup;
    private JCheckBox mSeedCheck;
    private JButton mGenerateButton;
    private JLabel mSeedLabel;
    private IntTextField mSeedField;
    private JPanel mDFunctions;
    private JCheckBox mPDF;
    private JCheckBox mCDF;
    private JPanel mDFRefPanel;
    private JCheckBox mRefMeanCheck;
    private JCheckBox mRefMedianCheck;
    private JCheckBox mRefSigmaCheck;
    private JLabel mRefSigmaNumberLabel;
    private NumberSpinner mSigmaValue;
    private JCheckBox mRefPercentileCheck;
    private JLabel mTopLabel;
    private FloatTextField mTopValue;
    private JLabel mBottomLabel;
    private FloatTextField mBottomValue;
    private JCheckBox mRefCustomCheck;
    private JLabel mCustomLabel;
    private PlainTable mCustomValueTable;
    private DefaultTableModel mValueTableModel;
    private JCheckBox mOverlayCheck;
    private JPanel mPDFPanel;
    private StringTextField mCatGroupLabel;
    private JRadioButton mPredCatCheck;
    private JRadioButton mPredProbCheck;
    private JRadioButton mBothPredProb;
    private SpssButtonGroup mCatButtonGroup;
    private StringTextField mGroupingLabel;
    private JRadioButton mCatGroupButton;
    private JRadioButton mIterGroupButton;
    private SpssButtonGroup mGroupingGroup;
    private JCheckBox mSliderSetCheck;
    private JLabel mSliderLowLabel;
    private FloatTextField mSliderLowValue;
    private JLabel mSliderUppLabel;
    private FloatTextField mSliderUppValue;
    private JCheckBox mSliderNegInfCheck;
    private JCheckBox mSliderPosInfCheck;
    private JPanel mOutput;
    private JCheckBox mBoxPlotCheck;
    private JCheckBox mOverlayResultCheck;
    private JCheckBox mTornadoCharts;
    private JCheckBox mForOrdinalVar;
    private JCheckBox mContrToVariCheck;
    private JCheckBox mSensitivityToChangeCheck;
    private JLabel mInputStdDevLabel;
    private FloatTextField mInputStdDevField;
    private JCheckBox mScatterplots;
    private JCheckBox mCreatTableCheck;
    private JRadioButton mQuantitleCheck;
    private JRadioButton mIntervaCheck;
    private JLabel mIntervalLabel;
    private NumberSpinner mIntervalValue;
    private JRadioButton mCustPercenCheck;
    private SpssButtonGroup mPercentitleGroup;
    private JLabel mCustPercentLabel;
    private JTable mCustPercentList;
    private DefaultTableModel mCustPercentModel;
    private JCheckBox mDescrCheck;
    private JLabel mDescConfLabel;
    private FloatTextField mmDescConfField;
    private JLabel mSimInputListLabel;
    private InputCheckboxList mInputList;
    private JLabel mFormatTableLabel;
    private JTable mFormatTable;
    private DefaultTableModel mFormatTableModel;
    private String[] mTargetFormats;
    private JLabel mLimitRangeTableLabel;
    private JTable mLimitRangeTable;
    private DefaultTableModel mLimitRangeTableModel;
    private String[] mLimitValues;
    private JCheckBox mCrosstabCheck;
    private JPanel mSave;
    private JCheckBox mSavePlanFileCheck;
    private FileTextField mPlanNameField;
    private JLabel mSavePlanFileLabel;
    private JButton mBrowsePlanButton;
    private JCheckBox mSaveSimToFileCheck;
    private JRadioButton mSaveFileSav;
    private JRadioButton mSaveFileExcel;
    private JRadioButton mSaveToDataset;
    private SpssButtonGroup mSaveGrop;
    private JButton mBrowseSavButton;
    private JLabel mSavFileLabel;
    private FileTextField mSavNameField;
    private JButton mBrowseExcelButton;
    private JLabel mExcelFileLabel;
    private FileTextField mExcelNameField;
    private JLabel mDatasetFieldLabel;
    private StringTextField mDatasetNameField;
    private ArrayList<SimulationPlanHandler.TargetField> mTargetFromPlan = null;
    private FloatFieldEditor mFloatFieldEditor;
    private Vector<String> mCrossFactorNames;
    static Dimension sMinPanelSize = new Dimension(695, 570);

    public MCSimulationTab(BaseTabbedDialog baseTabbedDialog, SimulationPlanHandler simulationPlanHandler) {
        super(baseTabbedDialog);
        this.initialize();
        this.setTabThroughCells(true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mNCasesButton) {
            this.mNLabel.setEnabled(true);
            this.mLimitNCaseField.setEnabled(true);
        }
        if (object == this.mAllCases) {
            this.mNLabel.setEnabled(false);
            this.mLimitNCaseField.setEnabled(false);
        } else if (object == this.mSaveToDataset || object == this.mSaveFileSav || object == this.mSaveFileExcel) {
            this.enableSaveSidebarControls(true, false);
        } else if (object == this.mNoneButton || object == this.mTailButton || object == this.mThresholdButton) {
            this.enableOptionStopCriteriaControls((JRadioButton)object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mFitAllButton) {
            this.runFitAllSub();
        } else if (object == this.mFitDetaildButton || object == this.mSensitivityButton) {
            int n;
            SimulatedFieldTableModel simulatedFieldTableModel;
            SimulatedField simulatedField;
            if (this.mSimulatedFieldTable.getRowCount() > 0 && (simulatedField = (simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).getSimulatedField(n = this.mSimulatedFieldTable.getSelectedRow())) != null) {
                if (object == this.mFitDetaildButton) {
                    this.runFitDailtedSub(simulatedField, n);
                } else {
                    String string;
                    int n2;
                    int n3 = SimulationHelper.getIndexOfFieldWithIterations(this.getSimulatedFieldsList());
                    if (n3 >= 0 && n3 != n && (n2 = SpssAlertOptionPane.showConfirmDialog(this, string = String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MC_EXISTING_ITERATION"), simulatedFieldTableModel.getSimulatedField(n3).getName()), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
                        return;
                    }
                    this.runSensitivityAnalysisSbub(simulatedField, n, n3);
                }
            }
        } else if (object == this.mFitSelectedButton) {
            int n = this.mSimulatedFieldTable.getSelectedRow();
            int n4 = this.mSimulatedFieldTable.getSelectedColumn();
            if (n >= 0) {
                this.runFitSelectedSub(n, n4);
            }
        } else if (object == this.mTailTypeCombo) {
            int n = this.mTailTypeCombo.getSelectedIndex();
            if (n == 0) {
                this.mTailPercentileLabel.setEnabled(true);
                this.mTailPercenField.setEnabled(true);
                this.mTailSideCombo.setEnabled(false);
                this.mTailValueField.setEnabled(false);
                this.mTailValueLabel.setEnabled(false);
            } else if (n == 1) {
                this.mTailSideCombo.setEnabled(true);
                this.mTailValueField.setEnabled(true);
                this.mTailValueLabel.setEnabled(true);
                this.mTailPercentileLabel.setEnabled(false);
                this.mTailPercenField.setEnabled(false);
            }
        } else if (object == this.mThreshTypeCombo) {
            int n = this.mThreshTypeCombo.getSelectedIndex();
            if (n == 0) {
                this.mThreshPercenLabel.setEnabled(true);
                this.mThreshPercenField.setEnabled(true);
                this.mThreshValuefLabel.setEnabled(false);
                this.mThreshValueField.setEnabled(false);
            } else if (n == 1) {
                this.mThreshPercenLabel.setEnabled(false);
                this.mThreshPercenField.setEnabled(false);
                this.mThreshValuefLabel.setEnabled(true);
                this.mThreshValueField.setEnabled(true);
            }
        } else if (object == this.mPDF || object == this.mCDF) {
            if (!this.mPDF.isSelected() && !this.mCDF.isSelected()) {
                this.enableDFRefPanel(false);
                this.enableDFPDFPanel(false);
                this.mSliderSetCheck.setEnabled(false);
                this.mOverlayCheck.setEnabled(false);
            } else {
                if (this.mPDF.isSelected()) {
                    this.enableDFPDFPanel(true);
                } else {
                    this.enableDFPDFPanel(false);
                }
                this.enableDFRefPanel(true);
                this.mOverlayCheck.setEnabled(true);
                if (this.mTargetCombo.getItemCount() > 1) {
                    this.mSliderSetCheck.setEnabled(false);
                } else {
                    this.mSliderSetCheck.setEnabled(true);
                }
            }
            this.enableSliderPanel();
        } else if (object == this.mSavePlanFileCheck) {
            if (this.mSavePlanFileCheck.isSelected()) {
                this.mSavePlanFileLabel.setEnabled(true);
                this.mPlanNameField.setEnabled(true);
                this.mBrowsePlanButton.setEnabled(true);
            } else {
                this.mSavePlanFileLabel.setEnabled(false);
                this.mPlanNameField.setEnabled(false);
                this.mBrowsePlanButton.setEnabled(false);
            }
        } else if (object == this.mSaveSimToFileCheck) {
            this.enableSaveSidebarControls(this.mSaveSimToFileCheck.isSelected(), false);
        } else if (object == this.mBrowsePlanButton) {
            String string = ((MonteCarloSimulationDlg)this.mParent).showSaveDialog();
            if (string.length() > 0) {
                this.mPlanNameField.setText(string);
            }
        } else if (object == this.mBrowseSavButton) {
            String string = ((MonteCarloSimulationDlg)this.mParent).showSaveDialog(this.getResString("IDS_MC_SAVE_DIALOG_TITLE"), this.getResString("IDS_MC_SAV_FILE_FILTER"), this.getResString("IDS_MC_SAV_FILE_EXT"));
            if (string.length() > 0) {
                this.mSavNameField.setText(string);
            }
        } else if (object == this.mBrowseExcelButton) {
            String[] stringArray = this.getResStringArray("IDS_MC_EXCEL_FILE_FILTER_ARRAY");
            String[] stringArray2 = this.getResStringArray("IDS_MC_EXCEL_FILE_EXT_ARRAY");
            String string = SimulationHelper.showSaveFileDialog(this.mParent, this.getResString("IDS_MC_SAVE_DIALOG_TITLE"), stringArray, stringArray2, RemoteFileChooser.ChooserOption.GenericWithoutPES);
            if (string.length() > 0) {
                this.mExcelNameField.setText(string);
            }
        } else if (object == this.mSeedCheck) {
            if (this.mSeedCheck.isSelected()) {
                this.mGenerateButton.setEnabled(true);
                this.mSeedLabel.setEnabled(true);
                this.mSeedField.setEnabled(true);
            } else {
                this.mGenerateButton.setEnabled(false);
                this.mSeedLabel.setEnabled(false);
                this.mSeedField.setEnabled(false);
            }
        } else if (object == this.mRefSigmaCheck) {
            if (this.mRefSigmaCheck.isSelected()) {
                this.mRefSigmaNumberLabel.setEnabled(true);
                this.mSigmaValue.setEnabled(true);
            } else {
                this.mRefSigmaNumberLabel.setEnabled(false);
                this.mSigmaValue.setEnabled(false);
            }
        } else if (object == this.mRefPercentileCheck) {
            if (this.mRefPercentileCheck.isSelected()) {
                this.mTopLabel.setEnabled(true);
                this.mTopValue.setEnabled(true);
                this.mBottomLabel.setEnabled(true);
                this.mBottomValue.setEnabled(true);
            } else {
                this.mTopLabel.setEnabled(false);
                this.mTopValue.setEnabled(false);
                this.mBottomLabel.setEnabled(false);
                this.mBottomValue.setEnabled(false);
            }
        } else if (object == this.mRefCustomCheck) {
            if (this.mRefCustomCheck.isSelected()) {
                this.mCustomLabel.setEnabled(true);
                this.mCustomValueTable.setEnabled(true);
                this.mCustomValueTable.selectFirstCell();
            } else {
                this.mCustomLabel.setEnabled(false);
                this.mCustomValueTable.setEnabled(false);
            }
        } else if (object == this.mDescrCheck) {
            if (this.mDescrCheck.isSelected()) {
                this.mDescConfLabel.setEnabled(true);
                this.mmDescConfField.setEnabled(true);
            } else {
                this.mDescConfLabel.setEnabled(false);
                this.mmDescConfField.setEnabled(false);
            }
        } else if (object == this.mSliderSetCheck) {
            this.enableSliderPanel();
        } else if (object == this.mCorrCrosstabCheck) {
            this.enableCtgtButtons();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.mPDF || object == this.mCDF) {
            if (object == this.mPDF) {
                this.mSimulationPanel.setInforText(this.getResString("IDS_MC_DF_PDF_HELP"), new ImageIcon(this.getResImageURL("IDS_MC_DF_PDF_HELP_IMAGE")));
            } else {
                this.mSimulationPanel.setInforText(this.getResString("IDS_MC_DF_CDF_HELP"), new ImageIcon(this.getResImageURL("IDS_MC_DF_CDF_HELP_IMAGE")));
            }
        } else if (object == this.mTornadoCharts || object == this.mContrToVariCheck || object == this.mSensitivityToChangeCheck || object == this.mInputStdDevField || object == this.mBoxPlotCheck || object == this.mOverlayResultCheck || object == this.mScatterplots) {
            if (object == this.mTornadoCharts || object == this.mContrToVariCheck || object == this.mSensitivityToChangeCheck || object == this.mInputStdDevField) {
                this.mSimulationPanel.setInforText(this.getResString("IDS_MC_OUTPUT_TORNADO_HELP"), new ImageIcon(this.getResImageURL("IDS_MC_OUTPUT_TORNADO_HELP_IMAGE")));
            } else if (object == this.mBoxPlotCheck || object == this.mOverlayResultCheck) {
                this.mSimulationPanel.setInforText(this.getResString("IDS_MC_OUTPUT_BOXPLOT_HELP"), new ImageIcon(this.getResImageURL("IDS_MC_OUTPUT_BOXPLOT_HELP_IMAGE")));
            } else {
                this.mSimulationPanel.setInforText(this.getResString("IDS_MC_OUTPUT_SCATTER_PLOT_HELP"), new ImageIcon(this.getResImageURL("IDS_MC_OUTPUT_SCATTER_PLOT_HELP_IMAGE")));
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.mPDF || object == this.mCDF || object == this.mTornadoCharts || object == this.mContrToVariCheck || object == this.mSensitivityToChangeCheck || object == this.mInputStdDevField || object == this.mBoxPlotCheck || object == this.mOverlayResultCheck || object == this.mScatterplots) {
            this.mSimulationPanel.setInforText("", null);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = tableModelEvent.getSource();
        if (tableModelEvent.getType() == 0 && (object == this.mValueTableModel || object == this.mCustPercentModel || object == this.mCorrelationTableModel || object == this.mLimitRangeTableModel)) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            String string = "";
            boolean bl = true;
            try {
                if (object == this.mCustPercentModel) {
                    string = this.mCustPercentModel.getValueAt(n, 0).toString();
                } else if (object == this.mValueTableModel) {
                    string = this.mValueTableModel.getValueAt(n, 0).toString();
                } else {
                    if (object == this.mLimitRangeTableModel) {
                        if ((n2 == 2 || n2 == 3) && (string = this.mLimitRangeTableModel.getValueAt(n, 1).toString()).equalsIgnoreCase(this.mLimitValues[3])) {
                            double d;
                            double d2;
                            Object object2 = this.mLimitRangeTableModel.getValueAt(n, 2);
                            Object object3 = this.mLimitRangeTableModel.getValueAt(n, 3);
                            if (object2 != null && object2.toString().length() > 0 && object3 != null && object3.toString().length() > 0 && (d2 = Double.parseDouble(object2.toString())) > (d = Double.parseDouble(object3.toString()))) {
                                this.mLimitRangeTableModel.setValueAt("", n, n2);
                                Toolkit.getDefaultToolkit().beep();
                                SpssAlertOptionPane.showErrorMessageDialog(this, this.getResString("IDS_MC_ERROR_LIMIT_TABLE"), VersionInfo.getAppVersionString());
                                this.mLimitRangeTable.requestFocusInWindow();
                            }
                        }
                        return;
                    }
                    if (n2 > 0) {
                        string = this.mCorrelationTableModel.getValueAt(n, n2).toString();
                    } else {
                        bl = false;
                    }
                }
                double d = 0.0;
                if (bl) {
                    d = Double.parseDouble(string);
                }
                if (object == this.mCustPercentModel) {
                    this.addEmptyRow(this.mCustPercentList, this.mCustPercentModel, new String[]{""});
                } else if (object == this.mValueTableModel) {
                    this.addEmptyRow(this.mCustomValueTable, this.mValueTableModel, new String[]{""});
                } else if (bl && (d > 1.0 || d < -1.0)) {
                    Component component = this.mCorrelationTable.getCellEditor(n, n2).getTableCellEditorComponent(this.mCorrelationTable, string, true, n, n2);
                    if (component instanceof JTextField) {
                        SPSSTextField.setSelectionText((JComponent)((JTextField)component), (int)0);
                    }
                    Toolkit.getDefaultToolkit().beep();
                    SpssAlertOptionPane.showErrorMessageDialog(this, this.getResString("IDS_MC_ERROR_ENTER_NUMBER"), VersionInfo.getAppVersionString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                Component component = null;
                if (object == this.mCustPercentModel) {
                    component = this.mCustPercentList.getCellEditor(n, 0).getTableCellEditorComponent(this.mCustPercentList, string, true, n, 0);
                    this.mCustPercentList.setValueAt("", n, 0);
                } else if (object == this.mValueTableModel) {
                    component = this.mCustomValueTable.getCellEditor(n, 0).getTableCellEditorComponent(this.mCustomValueTable, string, true, n, 0);
                }
                if (component != null && component instanceof JTextField) {
                    SPSSTextField.setSelectionText((JComponent)((JTextField)component), (int)0);
                }
                Toolkit.getDefaultToolkit().beep();
                SpssAlertOptionPane.showErrorMessageDialog(this, this.getResString("IDS_MC_ERROR_ENTER_NUMBER"), VersionInfo.getAppVersionString());
                return;
            }
        }
    }

    private void addEmptyRow(JTable jTable, DefaultTableModel defaultTableModel, Object[] objectArray) {
        boolean bl = true;
        int n = jTable.getColumnCount();
        int n2 = jTable.getRowCount() - 1;
        if (n < 0 || n2 < 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object = defaultTableModel.getValueAt(n2, i);
            if (object == null || object.toString().length() <= 0) continue;
            bl = false;
        }
        if (!bl) {
            defaultTableModel.addRow(objectArray);
        }
    }

    @Override
    protected boolean runFitAllSub() {
        boolean bl = super.runFitAllSub();
        if (bl) {
            if (this.mSimulatedFieldTable.isEditing() && this.mSimulatedFieldTable.getCellEditor() != null) {
                this.mSimulatedFieldTable.getCellEditor().stopCellEditing();
            }
            for (int i = 0; i < this.mSimFieldList.size(); ++i) {
                ArrayList<FitStatistics> arrayList;
                if (((SimulatedField)((Object)this.mSimFieldList.get(i))).getAutoFitState() == MonteCarloSimulationDlg.FitToState.DistributionFitChanged || (arrayList = ((SimulatedField)((Object)this.mSimFieldList.get(i))).getAllFitStats()) == null || arrayList.size() <= 0) continue;
                if (!this.mMismatchVars.contains(((SimulatedField)((Object)this.mSimFieldList.get(i))).getName())) {
                    ((SimulatedField)((Object)this.mSimFieldList.get(i))).setAutoFit(MonteCarloSimulationDlg.FitToState.MatchedAndFitted);
                }
                ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableCellUpdated(i, 3);
            }
            ((MonteCarloSimulationDlg)this.mParent).enableOkPaste(this.validateSimulatedPanel());
        }
        return bl;
    }

    public boolean runFitSelectedSub(int n, int n2) {
        boolean bl = super.runFitSelectedSub(n);
        int n3 = n2;
        int n4 = n;
        if (bl) {
            ((MonteCarloSimulationDlg)this.mParent).enableOkPaste(this.validateSimulatedPanel());
            if (((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).getSimulatedField(n).getAutoFitState() != MonteCarloSimulationDlg.FitToState.DistributionFitChanged) {
                SimulatedField simulatedField = ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).getSimulatedField(n);
                if (!this.mMismatchVars.contains(simulatedField.getName())) {
                    ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).getSimulatedField(n).setAutoFit(MonteCarloSimulationDlg.FitToState.MatchedAndFitted);
                }
                ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableCellUpdated(n, 3);
            }
            if (this.mSimulatedFieldTable.isEditing() && this.mSimulatedFieldTable.getCellEditor() != null) {
                this.mSimulatedFieldTable.getCellEditor().stopCellEditing();
            }
        }
        return bl;
    }

    public boolean doValidateTab() {
        if (!this.validateSimulatedPanel()) {
            return false;
        }
        if (!this.validateCorrelationPanel()) {
            return false;
        }
        if (!this.validateOptionPanel()) {
            return false;
        }
        if (!this.validateDFunctionPanel()) {
            return false;
        }
        if (!this.validateOutputPanel()) {
            return false;
        }
        return this.validateSavePanel();
    }

    public void reloadSimulation(ArrayList<SimulatedField> arrayList, ArrayList<SimulationPlanHandler.TargetField> arrayList2, ArrayList<SimulationPlanHandler.SamplingCriteria> arrayList3, String string, ArrayList<SimulatedField> arrayList4) {
        Object object;
        Object object2;
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        simulatedFieldTableModel.setSimulatedPredictors(arrayList);
        this.mTargetFromPlan = arrayList2;
        this.mPlanTimeStamp = string;
        if (this.mPlanTimeStamp.length() > 0) {
            object2 = String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MC_SIMULATED_FIELD_TIME_STAMP"), this.mPlanTimeStamp);
            object = this.mSimulatedFieldTableLabel.getText() + (String)object2;
            this.mSimulatedFieldTableLabel.setText((String)object);
        }
        this.mSimulatedFieldTable.setRowSelectionInterval(0, 0);
        this.mSimulatedFieldTable.setColumnSelectionInterval(0, 0);
        SimulationHelper.setupColumnWidths(this.mSimulatedFieldTable, new double[]{0.12, 0.2, 0.05, 0.2, 0.43});
        object2 = new Vector();
        object = new Vector();
        this.mLimitRangeTableModel.setRowCount(0);
        if (arrayList4 != null && arrayList4.size() > 0) {
            for (int i = 0; i < arrayList4.size(); ++i) {
                SimulatedField simulatedField = arrayList4.get(i);
                if (simulatedField.getMeasurementLevel() == MeasurementLevel.scale) {
                    ((Vector)object2).add(simulatedField.getName());
                    continue;
                }
                if (simulatedField.getType() <= 0) continue;
                ((Vector)object).add(simulatedField.getName());
            }
        }
        this.fillLimitRangeTable((Vector<String>)object2, arrayList2);
        this.updateFitButtons();
        this.updateOutputSidebar((Vector<String>)object);
        this.updateOptionControlFromPlan(arrayList3);
        this.enableFitAllButton();
        ((MonteCarloSimulationDlg)this.mParent).enableOkPaste(this.validateSimulatedPanel());
    }

    @Override
    public String getDialogHelpID() {
        int n = this.mSimulationPanel.getSelectedIndex();
        if (n == 0) {
            return "idh_simulation_inputs";
        }
        if (n == 1) {
            return "idh_simulation_correlations";
        }
        if (n == 2) {
            return "idh_simulation_options";
        }
        if (n == 3) {
            return "idh_simulation_densityfunctions";
        }
        if (n == 4) {
            return "idh_simulation_output";
        }
        if (n == 5) {
            return "idh_simulation_save";
        }
        return "none";
    }

    public void setFromSimPlan(boolean bl) {
        this.mHasSimPlan = bl;
    }

    String getCorrelationPanelHelpText() {
        return this.getResString("IDS_MC_CORRELATION_PANEL_HELP");
    }

    String getSavePanelHelpText() {
        return this.getResString("IDS_MC_SAVE_PANEL_HELP");
    }

    String getOptionPanelHelpText() {
        return this.getResString("IDS_MC_OPTION_PANEL_HELP");
    }

    void updateSimulatedPanelHelp() {
        SimulatedField simulatedField;
        SimulationHelper.DistributionType distributionType = SimulationHelper.DistributionType.NONE;
        if (this.mSimulatedFieldTable.getRowCount() > 0 && (simulatedField = this.mSimulatedFieldTable.getSelectedField()) != null) {
            distributionType = simulatedField.getDistributionType();
        }
        this.updateDistParamHelpText(distributionType);
    }

    void enableOKPaste() {
        ((MonteCarloSimulationDlg)this.mParent).enableOkPaste(this.validateSimulatedPanel());
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        this.updataDFPanelControls();
        this.updateSavePanelControls();
        if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
            this.mPlanNameField.setText(SimulationHelper.getDefaultSimplanPath(false));
        }
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        dialogDataModel.putObject(SIMULATION_TABLE_KEY, this.mSimulatedFieldTable);
        dialogDataModel.putObject(SIMULATION_FORMAT_TABLE, this.mFormatTable);
        dialogDataModel.putObject(SIMULATION_TARGET_LIMIT_TABLE, this.mLimitRangeTable);
        dialogDataModel.putObject(CORRELATION_TABLE_KEY, this.mCorrelationTable);
        dialogDataModel.putBoolean(CORRELATION_TABLE_CHANGED, this.mCorrelationModified);
        dialogDataModel.putArray(SIMULATION_TARGET_NAMES, this.mTargetNames.toArray());
        dialogDataModel.putString(EMPERICAL_BINS, this.mBinNumber.getModel().getValue().toString());
        dialogDataModel.putString(OUTPUT_INTERVAL_VALUE, this.mIntervalValue.getModel().getValue().toString());
        dialogDataModel.putObject(OUTPUT_CUSTOM_PERCENT_TABLE_KEY, this.mCustPercentList);
        if (this.mTargetCombo.getSelectedItem() != null) {
            dialogDataModel.putString(OPTION_CRITERIA_TARGET_NAME, this.mTargetCombo.getSelectedItem().toString());
        }
        dialogDataModel.putInteger(OPTION_CRITERIA_TTHRESH_TYPE, this.mThreshTypeCombo.getSelectedIndex());
        dialogDataModel.putInteger(OPTION_CRITERIA_TAIL_TYPE, this.mTailTypeCombo.getSelectedIndex());
        dialogDataModel.putString(OPTION_CRITERIA_TAIL_FREQ, this.mTailFreq.getText());
        dialogDataModel.putInteger(OPTION_CRITERIA_TAIL_SIDE, this.mTailSideCombo.getSelectedIndex());
        if (this.mRefCustomCheck.isSelected()) {
            String string = "";
            for (int i = 0; i < this.mCustomValueTable.getRowCount(); ++i) {
                Object object = this.mCustomValueTable.getValueAt(i, 0);
                if (object == null || object.toString().length() <= 0) continue;
                string = string + object.toString() + " ";
            }
            dialogDataModel.putString(DF_CUSTOM_REF_VALUES, string);
        }
        super.saveTabState(dialogDataModel);
    }

    void removeInput(Vector<SimulatedField> vector) {
        if (vector != null && vector.size() > 0) {
            SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
            Iterator<SimulatedField> iterator = vector.iterator();
            while (iterator.hasNext()) {
                SimulatedField simulatedField;
                SimulatedField simulatedField2 = simulatedField = iterator.next();
                simulatedFieldTableModel.deleteOneSimulatedField(simulatedField2);
                MeasurementLevel measurementLevel = simulatedField2.getMeasurementLevel();
                if (simulatedField2.getDistributionType() == SimulationHelper.DistributionType.FIXED || measurementLevel != MeasurementLevel.scale && measurementLevel != MeasurementLevel.ordinal) continue;
                this.mCorrelationTableModel.removeOneRow(simulatedField2.getName());
            }
            this.updateFitButtons();
            this.updateOutputSidebar(null);
            this.enableFitAllButton();
            boolean bl = this.validateSimulatedPanel();
            ((MonteCarloSimulationDlg)this.mParent).enableOkPaste(bl);
        }
    }

    void removeOneInput(String string) {
        int n;
        SimulatedFieldTableModel simulatedFieldTableModel;
        if (string != null && string.length() > 0 && (simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()) != null && (n = simulatedFieldTableModel.findRowIndex(string)) >= 0) {
            Vector<SimulatedField> vector = new Vector<SimulatedField>();
            vector.add(simulatedFieldTableModel.getSimulatedField(n));
            this.removeInput(vector);
        }
    }

    void updateSimulatedTable(Object[] objectArray, Hashtable<String, Object[]> hashtable, Hashtable<String, SimulatedField> hashtable2) {
        SimulatedField simulatedField;
        Object object;
        int n;
        Object[] objectArray2;
        if ((objectArray == null || objectArray.length == 0) && hashtable != null) {
            return;
        }
        boolean bl = false;
        if ((objectArray == null || objectArray.length == 0) && hashtable == null && hashtable2 == null) {
            bl = true;
        }
        Vector<String> vector = new Vector<String>();
        if (hashtable != null) {
            objectArray2 = hashtable.keys();
            while (objectArray2.hasMoreElements()) {
                Object[] objectArray3;
                Object[] objectArray4 = objectArray3 = hashtable.get(objectArray2.nextElement());
                n = objectArray4.length;
                for (int i = 0; i < n; ++i) {
                    object = objectArray4[i];
                    String string = ((SimulatedField)((Object)object)).getName();
                    if (vector.contains(string)) continue;
                    vector.add(string);
                }
            }
        } else if (!bl && hashtable == null && hashtable2 == null) {
            for (Object object2 : objectArray) {
                SimulatedField simulatedField2 = (SimulatedField)((Object)object2);
                if (vector.contains(simulatedField2.getName())) continue;
                vector.add(simulatedField2.getName());
            }
        }
        objectArray2 = new Vector();
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
        for (n = 0; n < this.mSimulatedFieldTable.getRowCount() && (bl || vector.size() > 0); ++n) {
            String string = (String)simulatedFieldTableModel.getValueAt(n, 0);
            if (vector.contains(string)) continue;
            objectArray2.add(simulatedFieldTableModel.getSimulatedField(n));
        }
        SimulatedFieldTable.ParametersTableCell parametersTableCell = (SimulatedFieldTable.ParametersTableCell)this.mSimulatedFieldTable.getColumnModel().getColumn(4).getCellRenderer();
        parametersTableCell.getImageMap().clear();
        if (objectArray2.size() > 0) {
            for (int i = 0; i < objectArray2.size(); ++i) {
                simulatedFieldTableModel.deleteOneSimulatedField((SimulatedField)((Object)objectArray2.get(i)));
            }
        }
        for (int i = 0; i < this.mSimulatedFieldTable.getRowCount(); ++i) {
            hashtable3.put((String)simulatedFieldTableModel.getValueAt(i, 0), i);
        }
        String string = "";
        for (Object object3 : objectArray) {
            Integer n2;
            simulatedField = (SimulatedField)((Object)object3);
            if (hashtable3.get(simulatedField.getName()) == null && (hashtable == null || hashtable.get(simulatedField.getName()) == null)) {
                simulatedFieldTableModel.addOneSimulatedField(simulatedField);
                n2 = simulatedField.getMeasurementLevel();
                if (simulatedField.getDistributionType() != SimulationHelper.DistributionType.FIXED && (n2 == MeasurementLevel.scale || n2 == MeasurementLevel.ordinal)) {
                    this.mCorrelationTableModel.addOneRow(simulatedField.getName());
                    continue;
                }
                string = string + " " + simulatedField.getName() + ",";
                continue;
            }
            n2 = (Integer)hashtable3.get(simulatedField.getName());
            if (n2 == null) continue;
            ArrayList<String> arrayList = simulatedField.getRelatedModelNames();
            int n3 = n2;
            for (String string2 : arrayList) {
                simulatedFieldTableModel.getSimulatedField(n3).addRelatedModelName(string2);
            }
        }
        if (string.length() > 0) {
            if (string.charAt(string.length() - 1) == ',') {
                string = string.substring(0, string.length() - 1);
            }
            this.mCorrExcludeMesg.setText(this.getResString("IDS_MC_CORRELATIOM_EXCLUDE_MESG") + string);
        } else {
            this.mCorrExcludeMesg.setText("");
        }
        object = new Vector();
        Vector<String> vector2 = new Vector<String>();
        this.mLimitRangeTableModel.setRowCount(0);
        if (hashtable2 != null && hashtable2.size() > 0) {
            Enumeration<String> enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object object3;
                object3 = enumeration.nextElement();
                simulatedField = hashtable2.get(object3);
                if (simulatedField == null) continue;
                if (simulatedField.getMeasurementLevel() == MeasurementLevel.scale) {
                    ((Vector)object).add(object3);
                    continue;
                }
                if (simulatedField.getType() <= 0) continue;
                vector2.add((String)object3);
            }
            this.mSliderSetCheck.setEnabled(hashtable2.size() == 1);
        }
        this.fillLimitRangeTable((Vector<String>)object, null);
        if (this.mSimulatedFieldTable.getRowCount() > 0) {
            this.mSimulatedFieldTable.setRowSelectionInterval(0, 0);
            this.mSimulatedFieldTable.setColumnSelectionInterval(0, 0);
            this.updateFitButtons();
            this.updateOutputSidebar(vector2);
            this.enableFitAllButton();
            int n4 = this.validateSimulatedPanel() ? 1 : 0;
            ((MonteCarloSimulationDlg)this.mParent).enableOkPaste(n4 != 0);
        }
    }

    private void fillLimitRangeTable(Vector<String> vector, ArrayList<SimulationPlanHandler.TargetField> arrayList) {
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Vector<String> vector2 = new Vector<String>();
                vector2.add(vector.get(i));
                vector2.add(this.mLimitValues[0]);
                vector2.add("");
                vector2.add("");
                this.mLimitRangeTableModel.addRow(vector2);
            }
            this.mLimitRangeTable.setModel(this.mLimitRangeTableModel);
        } else if (arrayList != null) {
            this.fillRangeFromPlanTarget(arrayList);
        }
    }

    private void fillRangeFromPlanTarget(ArrayList<SimulationPlanHandler.TargetField> arrayList) {
        Vector<String> vector = new Vector<String>();
        for (SimulationPlanHandler.TargetField targetField : arrayList) {
            if (targetField.getMLevel() != MeasurementLevel.scale) continue;
            vector.add(targetField.getName());
            double d = targetField.getLowValue();
            double d2 = targetField.getHighValue();
            if (d != Double.NEGATIVE_INFINITY && d2 != Double.POSITIVE_INFINITY) {
                vector.add(this.mLimitValues[3]);
                vector.add(String.valueOf(d));
                vector.add(String.valueOf(d2));
            } else if (d != Double.NEGATIVE_INFINITY) {
                vector.add(this.mLimitValues[1]);
                vector.add(String.valueOf(d));
                vector.add("");
            } else if (d2 != Double.POSITIVE_INFINITY) {
                vector.add(this.mLimitValues[2]);
                vector.add("");
                vector.add(String.valueOf(d2));
            } else {
                vector.add(this.mLimitValues[0]);
                vector.add("");
                vector.add("");
            }
            this.mLimitRangeTableModel.addRow(vector);
        }
        this.mLimitRangeTable.setModel(this.mLimitRangeTableModel);
    }

    private void updateOptionControlFromPlan(ArrayList<SimulationPlanHandler.SamplingCriteria> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        SimulationPlanHandler.SamplingCriteria samplingCriteria = arrayList.get(0);
        MonteCarloSimulationDlg.CriteriaType criteriaType = samplingCriteria.getCriteriaType();
        MonteCarloSimulationDlg.CriteriaUnit criteriaUnit = samplingCriteria.getCriteriaUnit();
        if (criteriaType == MonteCarloSimulationDlg.CriteriaType.tail) {
            this.mTailButton.setSelected(true);
            if (criteriaUnit == MonteCarloSimulationDlg.CriteriaUnit.percent) {
                this.mTailTypeCombo.setSelectedIndex(0);
                this.mTailPercenField.setText(String.valueOf(samplingCriteria.getThreshold()));
            } else {
                this.mTailTypeCombo.setSelectedIndex(1);
                this.mTailValueField.setText(String.valueOf(samplingCriteria.getThreshold()));
                if (samplingCriteria.getTailSide().equalsIgnoreCase("right")) {
                    this.mTailSideCombo.setSelectedIndex(1);
                }
            }
            this.mTailFreq.setText(Integer.toString(samplingCriteria.getTailFrequency()));
        } else {
            this.mThresholdButton.setSelected(true);
            if (criteriaUnit == MonteCarloSimulationDlg.CriteriaUnit.percent) {
                this.mThreshTypeCombo.setSelectedIndex(0);
                this.mThreshPercenField.setText(String.valueOf(samplingCriteria.getThreshold()));
            } else {
                this.mThreshTypeCombo.setSelectedIndex(1);
                this.mThreshValueField.setText(String.valueOf(samplingCriteria.getThreshold()));
            }
            this.mThreshConfField.setText(String.valueOf(samplingCriteria.getConfLevel()));
        }
    }

    public void updateFitButtons() {
        this.updateFitButtons(null);
    }

    public void updateFitButtons(SimulatedField simulatedField) {
        int n;
        if (this.mSimulatedFieldTable.getRowCount() == 0) {
            return;
        }
        if (simulatedField == null) {
            simulatedField = this.mSimulatedFieldTable.getSelectedField();
            n = this.mSimulatedFieldTable.getSelectedRow();
        } else {
            n = ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).findRowIndex(simulatedField);
        }
        if (n < 0) {
            return;
        }
        boolean bl = (Boolean)this.mSimulatedFieldTable.getModel().getValueAt(n, 2);
        if (simulatedField != null) {
            if (bl) {
                this.mFitSelectedButton.setEnabled(false);
                this.mFitDetaildButton.setEnabled(false);
                this.mSensitivityButton.setEnabled(false);
            } else {
                boolean bl2 = true;
                SimulationHelper.DistributionType distributionType = simulatedField.getDistributionType();
                if (distributionType == SimulationHelper.DistributionType.EMPIRICAL) {
                    bl2 = false;
                } else {
                    ArrayList<Pair<String, String>> arrayList = simulatedField.getParametersFor(distributionType);
                    if (arrayList == null || arrayList.size() == 0) {
                        bl2 = false;
                    }
                }
                this.mSensitivityButton.setEnabled(bl2);
                if (simulatedField.getMappedName().length() > 0 && simulatedField.getDistributionType() != SimulationHelper.DistributionType.FIXED) {
                    this.mFitSelectedButton.setEnabled(true);
                } else {
                    this.mFitSelectedButton.setEnabled(false);
                }
                if (simulatedField.getAutoFitState() != MonteCarloSimulationDlg.FitToState.DistributionNotSet && simulatedField.getAllFitStats().size() > 0 && this.mScannedVarMap != null && this.mScannedVarMap.get(simulatedField.getMappedName()) != null) {
                    this.mFitDetaildButton.setEnabled(true);
                } else {
                    this.mFitDetaildButton.setEnabled(false);
                }
            }
            this.updateDistParamHelpText(simulatedField.getDistributionType());
            this.enableFitAllButton();
        }
    }

    void updateCorrelationTable() {
        if (this.mSimulatedFieldTable.getRowCount() == 0) {
            return;
        }
        SimulatedField simulatedField = this.mSimulatedFieldTable.getSelectedField();
        if (this.mCorrelationTableModel.hasRow(simulatedField.getName())) {
            if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.FIXED || simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL) {
                this.mCorrelationTableModel.removeOneRow(simulatedField.getName());
            }
        } else if (simulatedField.getDistributionType() != SimulationHelper.DistributionType.FIXED && simulatedField.getDistributionType() != SimulationHelper.DistributionType.MULTINOMIAL) {
            this.mCorrelationTableModel.addOneRow(simulatedField.getName());
        }
        this.mCorrExcludeMesg.setText(this.getExcludeVarNames());
    }

    public void updateDistParamHelpText(SimulationHelper.DistributionType distributionType) {
        if (distributionType == SimulationHelper.DistributionType.NONE) {
            this.mSimulationPanel.setInforText("", null);
        } else {
            String string = SimulationHelper.getDistributionHelpText(distributionType);
            this.mSimulationPanel.setInforText(string, SimulationHelper.getDistributionHelpIcon(distributionType));
            ((MonteCarloSimulationDlg)this.mParent).enableOkPaste(this.validateSimulatedPanel());
        }
    }

    public void updateSimulationPanelControlsForCreateData(boolean bl) {
        this.updateAdvancedPanelForCreateData(bl);
        this.updateDFunctionForCreateData(bl);
        this.updateOutputPanelForCreateData(bl);
        this.updateSavePanelForCreateData(bl);
    }

    private void updateOutputSidebar(Vector<String> vector) {
        Vector<String> vector2;
        Object object;
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        int n = this.mSimulatedFieldTable.getRowCount();
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        this.mAllVarNames.clear();
        this.mDecimals.clear();
        this.mFormatsIndice.clear();
        this.mTargetNames.clear();
        this.mInputList.setListData(new Object[0]);
        this.mFormatTableModel.setRowCount(0);
        this.mTargetComboModel.removeAllElements();
        this.mTargetCombo.setModel(this.mTargetComboModel);
        boolean bl = false;
        int n2 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        for (n2 = 0; n2 < n; ++n2) {
            boolean bl2;
            object = simulatedFieldTableModel.getSimulatedField(n2);
            if (object.getDistributionType() != SimulationHelper.DistributionType.FIXED && object.getRole() != Role.partition) {
                treeMap.put(object.getName(), !object.isExcludeFromOutput());
            }
            boolean bl3 = bl2 = object.getType() > 0 || object.getFormat().getFormatType().isStringFormat();
            if (!bl2 && !this.mAllVarNames.contains(object.getName())) {
                this.mAllVarNames.add(object.getName());
                this.mFormatsIndice.add(object.getFormatIndex());
                this.mDecimals.add(object.getNumDecimals());
            }
            vector2 = object.getRelatedModelNames();
            for (String string : vector2) {
                if (!this.mTargetNames.contains(string)) {
                    this.mTargetNames.add(string);
                }
                if (this.mAllVarNames.contains(string) || vector != null && (vector == null || vector.contains(string))) continue;
                this.mAllVarNames.add(string);
                this.getTargetFormatIndex(string, nArray, nArray2);
                this.mFormatsIndice.add(nArray[0]);
                this.mDecimals.add(nArray2[0]);
            }
        }
        if (this.mTargetNames.size() > 0) {
            this.mTargetCombo.setModel(this.mTargetComboModel);
            if (this.mTargetCombo.getSelectedIndex() < 0) {
                this.mTargetCombo.setSelectedIndex(0);
            }
            if (this.mTargetNames.size() < 2) {
                this.mTargetCombo.setEnabled(false);
                this.mTargetLabel.setEnabled(false);
            } else {
                this.mTargetCombo.setEnabled(true);
                this.mTargetLabel.setEnabled(true);
            }
            if (((MonteCarloSimulationDlg)this.mParent).getModelTab().isCreateDataButtonSelected()) {
                this.mTargetCombo.setEnabled(false);
                this.mTargetLabel.setEnabled(false);
            }
        }
        if (this.mTargetNames.size() == 0) {
            this.mTargetCombo.setEnabled(false);
            this.mTargetLabel.setEnabled(false);
            this.mNoneButton.setSelected(true);
            this.mTailButton.setEnabled(false);
            this.mThresholdButton.setEnabled(false);
        } else {
            this.mTailButton.setEnabled(true);
            this.mThresholdButton.setEnabled(true);
            this.mThresholdButton.setSelected(true);
        }
        object = treeMap.keySet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            vector2 = (String)iterator.next();
            JCheckBox jCheckBox = new JCheckBox((String)((Object)vector2));
            jCheckBox.setSelected((Boolean)treeMap.get(vector2));
            this.mInputList.addCheckbox(jCheckBox);
        }
        if (this.mInputList.getModel().getSize() > 0) {
            this.mInputList.setSelectedIndex(0);
        }
        for (n2 = 0; n2 < this.mAllVarNames.size(); ++n2) {
            vector2 = new Vector<String>();
            vector2.add(this.mAllVarNames.get(n2));
            vector2.add(this.mTargetFormats[this.mFormatsIndice.get(n2)]);
            vector2.add(this.mDecimals.get(n2).toString());
            this.mFormatTableModel.addRow(vector2);
        }
        this.mFormatTable.setModel(this.mFormatTableModel);
        if (this.mFormatTable.getRowCount() > 0 && this.mFormatTable.getColumnCount() > 0) {
            this.mFormatTable.setRowSelectionInterval(0, 0);
            this.mFormatTable.setColumnSelectionInterval(0, 0);
        }
    }

    void updateOutputInputList() {
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        int n = this.mSimulatedFieldTable.getRowCount();
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        this.mInputList.setListData(new Object[0]);
        for (int i = 0; i < n; ++i) {
            Object object = simulatedFieldTableModel.getSimulatedField(i);
            if (object.getDistributionType() == SimulationHelper.DistributionType.FIXED || object.getRole() == Role.partition) continue;
            treeMap.put(object.getName(), !object.isExcludeFromOutput());
        }
        Set set = treeMap.keySet();
        for (String string : set) {
            JCheckBox jCheckBox = new JCheckBox(string);
            jCheckBox.setSelected((Boolean)treeMap.get(string));
            this.mInputList.addCheckbox(jCheckBox);
        }
        if (this.mInputList.getModel().getSize() > 0) {
            this.mInputList.setSelectedIndex(0);
        }
    }

    public static String getHelpTextResKey(SimulationHelper.DistributionType distributionType) {
        return SimulationHelper.getDistributionHelpText(distributionType);
    }

    public void loadCorrelationTable(ArrayList<CorrelationEntry> arrayList) {
        this.loadCorrelationTable(arrayList, false, null);
    }

    public void loadCorrelationTable(ArrayList<CorrelationEntry> arrayList, boolean bl, Vector<String> vector) {
        if (vector != null && vector.size() > 0) {
            this.mCorrCrosstabCheck.setSelected(bl);
        }
        if (bl) {
            this.mCrossFactorNames = vector;
            this.mCtgtFromPlanButton.setSelected(true);
        }
        this.enableCtgtButtons();
        if (this.mCorrDontCalButton.isSelected()) {
            return;
        }
        if (arrayList != null && arrayList.size() > 0) {
            if (this.mCorrelationTableModel.getRowCount() > 0) {
                this.mCorrelationTableModel.setRowCount(0);
            }
            this.mCorrelationTableModel.setCorrelationEntries(arrayList);
            this.mCorrelationTable.setModel(this.mCorrelationTableModel);
            this.mCorrExcludeMesg.setText(this.getExcludeVarNames());
            this.mCorrelationModified = false;
        }
    }

    private String getExcludeVarNames() {
        String string = "";
        Vector<String> vector = this.mCorrelationTableModel.getColumnNames();
        Vector<String> vector2 = new Vector<String>();
        if (this.mCorrelationTableModel.getRowCount() < this.mSimulatedFieldTable.getRowCount()) {
            SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
            for (int i = 0; i < simulatedFieldTableModel.getRowCount(); ++i) {
                SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
                SimulationHelper.DistributionType distributionType = simulatedField.getDistributionType();
                if (distributionType == SimulationHelper.DistributionType.FIXED || distributionType == SimulationHelper.DistributionType.MULTINOMIAL) {
                    string = string + " " + simulatedField.getName() + ",";
                    continue;
                }
                if (vector.contains(simulatedField.getName())) continue;
                vector2.add(simulatedField.getName());
            }
        }
        if (vector2.size() > 0) {
            for (int i = 0; i < vector2.size(); ++i) {
                this.mCorrelationTableModel.addOneRow((String)vector2.get(i));
            }
        }
        if (string.length() > 0) {
            string = this.getResString("IDS_MC_CORRELATIOM_EXCLUDE_MESG") + string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String formatOBS(OBS oBS, SPSS_Format sPSS_Format) {
        String string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
        if (string.length() >= 40) {
            string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)new SPSS_Format(FormatType.E, sPSS_Format.getWidth(), sPSS_Format.getDecimals()));
        }
        return string;
    }

    public static void saveFitStatsToTemp(ByteBuffer byteBuffer) {
        try {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            File file = new File("C:\\temp\\simulation\\dist_fit_stat.xml");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(ZipUtil.decompressBytes((byte[])byteBuffer.array()));
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void runFitDailtedSub(SimulatedField simulatedField, int n) {
        BaseMCSimulationTab.ScannedVar scannedVar;
        if (this.mScannedVarMap != null && (scannedVar = (BaseMCSimulationTab.ScannedVar)this.mScannedVarMap.get(simulatedField.getMappedName())) != null) {
            FitSelectSubDlg fitSelectSubDlg = new FitSelectSubDlg((MonteCarloSimulationDlg)this.mParent, simulatedField, n, scannedVar);
            fitSelectSubDlg.setVisible(true);
            if (fitSelectSubDlg.wasContinuePressed()) {
                simulatedField.setLock(true);
                ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableCellUpdated(n, 2);
                ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableCellUpdated(n, 3);
                if (this.mSimulatedFieldTable.isEditing() && this.mSimulatedFieldTable.getCellEditor() != null) {
                    this.mSimulatedFieldTable.getCellEditor().stopCellEditing();
                }
                this.mSimulatedFieldTable.refreshParametersCell(simulatedField);
                this.updateFitButtons();
                this.updateCorrelationTable();
            }
        }
    }

    private void runSensitivityAnalysisSbub(SimulatedField simulatedField, int n, int n2) {
        SensitivityAnalysisSub sensitivityAnalysisSub = new SensitivityAnalysisSub((MonteCarloSimulationDlg)this.mParent, simulatedField);
        sensitivityAnalysisSub.setVisible(true);
        if (sensitivityAnalysisSub.wasContinuePressed()) {
            ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableCellUpdated(n, 2);
            ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableCellUpdated(n, 3);
            if (this.mSimulatedFieldTable.isEditing() && this.mSimulatedFieldTable.getCellEditor() != null) {
                this.mSimulatedFieldTable.getCellEditor().stopCellEditing();
            }
            this.mSimulatedFieldTable.refreshParametersCell(simulatedField);
            if (n2 >= 0 && n2 != n) {
                SimulatedField simulatedField2 = ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).getSimulatedField(n2);
                SimulationHelper.deleteIterationFrom(simulatedField2);
                ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableCellUpdated(n2, 3);
                this.mSimulatedFieldTable.refreshParametersCell(simulatedField2);
            }
        }
    }

    private int getRowWithIterations() {
        int n = -1;
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        for (int i = 0; i < this.mSimulatedFieldTable.getRowCount(); ++i) {
            SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
            ArrayList<Pair<String, String>> arrayList = simulatedField.getParametersFor(simulatedField.getDistributionType());
            int n2 = SimulationHelper.getNumberOfParameters(simulatedField);
            if (arrayList == null || arrayList.size() <= n2) continue;
            return i;
        }
        return n;
    }

    boolean validateSimulatedPanel() {
        return SimulationHelper.validateFields(this.getSimulatedFieldsList(), true);
    }

    private Vector<SimulatedField> getSimulatedFieldsList() {
        Vector<SimulatedField> vector = new Vector<SimulatedField>();
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        for (int i = 0; i < this.mSimulatedFieldTable.getRowCount(); ++i) {
            SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
            vector.add(simulatedField);
        }
        return vector;
    }

    private void updateContingencyFields(boolean bl) {
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        for (int i = 0; i < this.mSimulatedFieldTable.getRowCount(); ++i) {
            SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
            if (!this.mCrossFactorNames.contains(simulatedField.getName())) continue;
            if (!bl) {
                simulatedField.reploadFromSavedPlan();
            }
            simulatedField.setInContingencyTable(!bl);
            simulatedField.setLock(!bl);
            this.mSimulatedFieldTable.refreshParametersCell(simulatedField);
            if (!this.mSimulatedFieldTable.isEditing() || this.mSimulatedFieldTable.getCellEditor() == null) continue;
            this.mSimulatedFieldTable.getCellEditor().stopCellEditing();
        }
    }

    private void enableFitAllButton() {
        boolean bl = false;
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        for (int i = 0; i < this.mSimulatedFieldTable.getRowCount(); ++i) {
            SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
            if (simulatedField.isLocked() || simulatedField.getMappedName().length() <= 0 || simulatedField.getDistributionType() == SimulationHelper.DistributionType.FIXED) continue;
            bl = true;
            break;
        }
        this.mFitAllButton.setEnabled(bl);
    }

    private boolean validateCorrelationPanel() {
        return true;
    }

    private boolean validateOptionPanel() {
        if (this.mNumOfScasesField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            this.showIntFieldError(this.mNumOfScasesField, 1000, Integer.MAX_VALUE);
            return false;
        }
        if (this.mTailPercenField.isEnabled() && this.mTailPercenField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            this.mTailPercenField.showErrorMessage();
            return false;
        }
        if (this.mTailValueField.isEnabled() && this.mTailValueField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            this.mTailValueField.showErrorMessage();
            return false;
        }
        if (this.mThreshConfField.isEnabled() && this.mThreshConfField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            this.mThreshConfField.showErrorMessage();
            return false;
        }
        if (this.mThreshPercenField.isEnabled() && this.mThreshPercenField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            this.mThreshPercenField.showErrorMessage();
            return false;
        }
        if (this.mThreshValueField.isEnabled() && this.mThreshValueField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            this.mThreshValueField.showErrorMessage();
            return false;
        }
        if (this.mLimitNCaseField.isEnabled() && this.mLimitNCaseField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("IDS_MC_SAVE_FILED_EMPTY"), VersionInfo.getAppVersionString());
            SPSSTextField.setSelectionText((JComponent)this.mLimitNCaseField, (int)0);
            return false;
        }
        if (this.mSeedField.isEnabled() && this.mSeedField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(2);
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("IDS_MC_SAVE_FILED_EMPTY"), VersionInfo.getAppVersionString());
            SPSSTextField.setSelectionText((JComponent)this.mSeedField, (int)0);
            return false;
        }
        return true;
    }

    private void showIntFieldError(IntTextField intTextField, int n, int n2) {
        String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), n, n2);
        SPSSTextField.showWarningDialog((JComponent)intTextField, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
        SPSSTextField.setSelectionText((JComponent)intTextField, (int)0);
    }

    private boolean validateDFunctionPanel() {
        if (this.mTopValue.isEnabled() && this.mTopValue.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(3);
            this.mTopValue.showErrorMessage();
            return false;
        }
        if (this.mBottomValue.isEnabled() && this.mBottomValue.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(3);
            this.mBottomValue.showErrorMessage();
            return false;
        }
        if (this.mRefCustomCheck.isSelected() && this.mCustomValueTable.getRowCount() == 0) {
            boolean bl = false;
            for (int i = 0; i < this.mCustomValueTable.getRowCount(); ++i) {
                Object object = this.mCustomValueTable.getValueAt(i, 0);
                if (object == null || object.toString().length() <= 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.mSimulationPanel.setSelectedIndex(3);
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("IDS_MC_SAVE_FILED_EMPTY"), VersionInfo.getAppVersionString());
                this.mCustomValueTable.setRowSelectionInterval(0, 0);
                this.mCustomValueTable.setColumnSelectionInterval(0, 0);
                return false;
            }
        }
        if (this.mSliderSetCheck.isEnabled() && this.mSliderSetCheck.isSelected() && this.mSliderNegInfCheck.isSelected() && this.mSliderPosInfCheck.isSelected()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("IDS_MC_ERROR_BOTH_INF"), VersionInfo.getAppVersionString());
            this.mSliderNegInfCheck.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private boolean validateOutputPanel() {
        if (this.mInputStdDevField.isEnabled() && this.mInputStdDevField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(4);
            this.mInputStdDevField.showErrorMessage();
            return false;
        }
        if (this.mmDescConfField.isEnabled() && this.mmDescConfField.getText().length() == 0) {
            this.mSimulationPanel.setSelectedIndex(4);
            this.mmDescConfField.showErrorMessage();
            return false;
        }
        if (this.mCustPercenCheck.isSelected()) {
            boolean bl = false;
            for (int i = 0; i < this.mCustPercentList.getRowCount(); ++i) {
                Object object = this.mCustPercentList.getValueAt(i, 0);
                if (object == null || object.toString().length() <= 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.mSimulationPanel.setSelectedIndex(4);
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("IDS_MC_SAVE_FILED_EMPTY"), VersionInfo.getAppVersionString());
                this.mCustPercentList.setRowSelectionInterval(0, 0);
                this.mCustPercentList.setColumnSelectionInterval(0, 0);
                this.mCustPercentList.requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean validateSavePanel() {
        if (this.mPlanNameField.isEnabled() && !this.isFieldContentValid((JTextField)((Object)this.mPlanNameField), false)) {
            return false;
        }
        if (this.mSavNameField.isEnabled() && !this.isFieldContentValid((JTextField)((Object)this.mSavNameField), false)) {
            return false;
        }
        if (this.mDatasetNameField.isEnabled() && !this.isFieldContentValid((JTextField)((Object)this.mDatasetNameField), true)) {
            return false;
        }
        return !this.mExcelNameField.isEnabled() || this.isFieldContentValid((JTextField)((Object)this.mExcelNameField), false);
    }

    private boolean isFieldContentValid(JTextField jTextField, boolean bl) {
        if (jTextField.getText().length() == 0) {
            ((MonteCarloSimulationDlg)this.mParent).selectSimulationTab();
            this.mSimulationPanel.setSelectedIndex(5);
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_MC_SAVE_FILED_EMPTY"), VersionInfo.getAppVersionString());
            SPSSTextField.setSelectionText((JComponent)jTextField, (int)0);
            return false;
        }
        if (!bl) {
            String string = SimulationHelper.validateFilePath(this, jTextField);
            if (string != null && string.length() > 0) {
                ((MonteCarloSimulationDlg)this.mParent).selectSimulationTab();
                this.mSimulationPanel.setSelectedIndex(5);
                if (!SimulationHelper.showPathError(this, string)) {
                    SPSSTextField.setSelectionText((JComponent)jTextField, (int)0);
                    return false;
                }
            }
        } else {
            int n = DatasetNameValidator.validateDatasetName((String)jTextField.getText(), (Component)this);
            if (n == 0) {
                ((MonteCarloSimulationDlg)this.mParent).selectSimulationTab();
                this.mSimulationPanel.setSelectedIndex(5);
                SPSSTextField.setSelectionText((JComponent)jTextField, (int)0);
                return false;
            }
        }
        return true;
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        this.setupSimulatedSidebarPanel();
        this.setupCorrelationsSidebarPanel();
        this.setupOptionsSidebarPanel();
        this.setupDensityFunctionsPanel();
        this.setupOutputSidebarPanel();
        this.setupSaveSidebarPanel();
        this.mSimulationPanel.addPanel(this.mSimulatedField, this.getResString("IDS_MC_SIMULATION_FIELD_SIDE_BAR_TITLE"));
        this.mSimulationPanel.addPanel(this.mCorrelations, this.getResString("IDS_MC_CORRELATIONS_SIDE_BAR_TITLE"));
        this.mSimulationPanel.addPanel(this.mOptions, this.getResString("IDS_MC_OPTIONS_SIDE_BAR_TITLE"));
        this.mSimulationPanel.addPanel(this.mDFunctions, this.getResString("IDS_MC_DENSITY_FUNCTIONS_SIDE_BAR_TITLE"));
        this.mSimulationPanel.addPanel(this.mOutput, this.getResString("IDS_MC_OUTPUT_SIDE_BAR_TITLE"));
        this.mSimulationPanel.addPanel(this.mSave, this.getResString("IDS_MC_SAVE_SIDE_BAR_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2 * 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, n2, 2, 0);
        Dimension dimension = this.mSimulationPanel.getPreferredSize();
        if (dimension.height > 600) {
            this.mSimulationPanel.setPreferredSize(sMinPanelSize);
        }
        DialogUtil.addUsingGBL(this, this.mSimulationPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void updateAdvancedPanelForCreateData(boolean bl) {
        if (bl) {
            this.mNoneButton.setSelected(true);
            this.enableOptionStopCriteriaControls(this.mNoneButton);
            this.mTailButton.setEnabled(false);
            this.mThresholdButton.setEnabled(false);
            this.mTargetLabel.setEnabled(false);
            this.mTargetCombo.setEnabled(false);
        } else {
            this.mTailButton.setEnabled(true);
            this.mThresholdButton.setEnabled(true);
            this.mThresholdButton.setSelected(true);
            this.enableOptionStopCriteriaControls(this.mThresholdButton);
        }
    }

    private void updateDFunctionForCreateData(boolean bl) {
        boolean bl2 = !bl;
        this.mPDF.setEnabled(bl2);
        this.mCDF.setEnabled(bl2);
        if (bl2 && this.mTargetCombo.getItemCount() > 1) {
            this.mSliderSetCheck.setEnabled(false);
        } else {
            this.mSliderSetCheck.setEnabled(bl2);
        }
        this.enableSliderPanel();
        this.mRefMeanCheck.setEnabled(bl2);
        this.mRefMedianCheck.setEnabled(bl2);
        this.mRefSigmaCheck.setEnabled(bl2);
        if (this.mRefSigmaCheck.isEnabled() && this.mRefSigmaCheck.isSelected()) {
            this.mRefSigmaNumberLabel.setEnabled(true);
            this.mSigmaValue.setEnabled(true);
        } else {
            this.mRefSigmaNumberLabel.setEnabled(false);
            this.mSigmaValue.setEnabled(false);
        }
        this.mRefPercentileCheck.setEnabled(bl2);
        if (this.mRefPercentileCheck.isEnabled() && this.mRefPercentileCheck.isSelected()) {
            this.mTopLabel.setEnabled(true);
            this.mTopValue.setEnabled(true);
            this.mBottomLabel.setEnabled(true);
            this.mBottomValue.setEnabled(true);
        } else {
            this.mTopLabel.setEnabled(false);
            this.mTopValue.setEnabled(false);
            this.mBottomLabel.setEnabled(false);
            this.mBottomValue.setEnabled(false);
        }
        this.mRefCustomCheck.setEnabled(bl2);
        if (this.mRefCustomCheck.isEnabled() && this.mRefCustomCheck.isSelected()) {
            this.mCustomLabel.setEnabled(true);
            this.mCustomValueTable.setEnabled(true);
        } else {
            this.mCustomLabel.setEnabled(false);
            this.mCustomValueTable.setEnabled(false);
        }
        this.mOverlayCheck.setEnabled(bl2);
        this.mCatGroupLabel.setEnabled(bl2);
        this.mPredCatCheck.setEnabled(bl2);
        this.mPredProbCheck.setEnabled(bl2);
        this.mBothPredProb.setEnabled(bl2);
        this.mGroupingLabel.setEnabled(bl2);
        this.mCatGroupButton.setEnabled(bl2);
        this.mIterGroupButton.setEnabled(bl2);
    }

    private void updateOutputPanelForCreateData(boolean bl) {
        boolean bl2 = !bl;
        this.mTornadoCharts.setEnabled(bl2);
        this.mContrToVariCheck.setEnabled(bl2);
        this.mSensitivityToChangeCheck.setEnabled(bl2);
        if (bl2 && this.mSensitivityToChangeCheck.isSelected()) {
            this.mInputStdDevLabel.setEnabled(true);
            this.mInputStdDevField.setEnabled(true);
        } else {
            this.mInputStdDevLabel.setEnabled(false);
            this.mInputStdDevField.setEnabled(false);
        }
        this.mCreatTableCheck.setEnabled(bl2);
        if (bl2 && this.mCreatTableCheck.isSelected()) {
            this.enableTableOfPercentile(true);
        } else {
            this.enableTableOfPercentile(false);
        }
        this.mBoxPlotCheck.setEnabled(bl2);
        if (bl2 && this.mBoxPlotCheck.isSelected()) {
            this.mOverlayResultCheck.setEnabled(true);
        } else {
            this.mOverlayResultCheck.setEnabled(false);
        }
        this.mScatterplots.setEnabled(bl2);
        this.mLimitRangeTableLabel.setEnabled(bl2);
        this.mLimitRangeTable.setEnabled(bl2);
    }

    private void updateSavePanelForCreateData(boolean bl) {
        this.mSaveSimToFileCheck.setSelected(bl);
        this.enableSaveSidebarControls(bl, bl);
    }

    private void initVars() {
        this.mSimulationPanel = new SimulationSidebarSelectorPanel((BaseTabbedDialog)this.mParent, "Simulation_Tab", this.getResString("IDS_MC_SIMULATION_TAB_SIDEBAR_LABEL"), 83);
        this.initSimulatedFieldVars();
        this.initCorrelationVars();
        this.initOptionVars();
        this.initDFunctionVars();
        this.initOutputVars();
        this.initSaveVars();
    }

    private void setDefaults() {
        this.mHasSimPlan = false;
        this.mFitSelectedButton.setEnabled(false);
        this.mFitDetaildButton.setEnabled(false);
        this.mSensitivityButton.setEnabled(false);
        this.setCorrDefault();
        this.setOptionDefault();
        this.setDFunctionDefault();
        this.setOuputDefault();
        this.setSaveDefault();
    }

    private void setCorrDefault() {
        this.mCorrRecalButton.setSelected(true);
        this.mCorrelationModified = false;
        if (this.mCorrCrosstabCheck.isSelected() && this.mHasSimPlan) {
            this.mCtgtFromPlanButton.setSelected(true);
        } else {
            this.mCtgtFromDataButton.setSelected(true);
        }
        this.enableCtgtButtons();
    }

    private void setOptionDefault() {
        this.mNumOfScasesField.setText("100000");
        this.mLimitNCaseField.setText("10000");
        this.mLimitNCaseField.setColumns(12);
        this.mNumOfScasesField.setColumns(12);
        this.mTargetCombo.setEnabled(false);
        this.mTargetLabel.setEnabled(false);
        this.mThresholdButton.setSelected(true);
        this.mNoneButton.setSelected(false);
        this.mTailButton.setSelected(false);
        this.mTailPercenField.setText("95.00");
        this.mTailValueField.setText("0.00");
        this.mTailSideCombo.setSelectedIndex(1);
        this.mThreshPercenField.setText("1.00");
        this.mThreshValueField.setText("0.00");
        this.mThreshConfField.setText("95.00");
        this.mAllCases.setSelected(true);
        this.mAndersonDarlingButton.setSelected(true);
        this.mSeedCheck.setSelected(true);
        this.mGenerateButton.setEnabled(true);
        this.mSeedLabel.setEnabled(true);
        this.mSeedField.setEnabled(true);
        this.mSeedField.setText("629111597");
        this.mTailFreq.setText("10");
        this.mMisExcludeButton.setSelected(true);
    }

    private void setDFunctionDefault() {
        this.mPDF.setSelected(true);
        this.mSliderSetCheck.setSelected(false);
        this.enableSliderPanel();
        this.mRefSigmaCheck.setSelected(false);
        this.mRefSigmaNumberLabel.setEnabled(false);
        this.mSigmaValue.setEnabled(false);
        this.mSigmaValue.getModel().setValue(3);
        this.mRefPercentileCheck.setSelected(false);
        this.mTopLabel.setEnabled(false);
        this.mTopValue.setEnabled(false);
        this.mTopValue.setText("90.00");
        this.mBottomLabel.setEnabled(false);
        this.mBottomValue.setEnabled(false);
        this.mBottomValue.setText("10.00");
        this.mRefCustomCheck.setSelected(false);
        this.mCustomLabel.setEnabled(false);
        this.mCustomValueTable.setEnabled(false);
        this.mPredCatCheck.setSelected(true);
        this.mCatGroupButton.setSelected(true);
    }

    private void setSaveDefault() {
        if (this.mHasSimPlan) {
            this.mSavePlanFileCheck.setSelected(false);
            this.mPlanNameField.setEnabled(false);
            this.mPlanNameField.setEnabled(false);
            this.mBrowsePlanButton.setEnabled(false);
        } else {
            this.mSavePlanFileCheck.setSelected(true);
            this.mPlanNameField.setEnabled(true);
            this.mPlanNameField.setText(SimulationHelper.getDefaultSimplanPath(false));
            this.mBrowsePlanButton.setEnabled(true);
        }
        this.mSaveSimToFileCheck.setSelected(false);
        this.mSaveFileSav.setEnabled(false);
        this.mSaveFileSav.setSelected(true);
        this.enableSaveSidebarControls(false, false);
    }

    private void setOuputDefault() {
        this.mTornadoCharts.setSelected(true);
        this.mContrToVariCheck.setSelected(false);
        this.mSensitivityToChangeCheck.setSelected(false);
        this.mCreatTableCheck.setSelected(false);
        this.mCrosstabCheck.setSelected(true);
        this.enableTableOfPercentile(false);
        this.mBoxPlotCheck.setSelected(false);
        this.mOverlayResultCheck.setSelected(false);
        this.mOverlayResultCheck.setEnabled(false);
        this.mForOrdinalVar.setEnabled(false);
        this.mScatterplots.setSelected(false);
        this.mInputStdDevField.setText("1.0");
        this.mQuantitleCheck.setSelected(true);
        this.mIntervaCheck.setSelected(false);
        this.mIntervalLabel.setEnabled(false);
        this.mIntervalValue.setEnabled(false);
        this.mIntervalValue.getModel().setValue(10);
        this.mCustPercenCheck.setSelected(false);
        this.mCustPercentLabel.setEnabled(false);
        this.mCustPercentList.setEnabled(false);
        this.mDescrCheck.setSelected(true);
        this.mDescConfLabel.setEnabled(true);
        this.mmDescConfField.setEnabled(true);
        this.mmDescConfField.setText("95.0");
        this.mSensitivityToChangeCheck.setSelected(false);
        this.mInputStdDevField.setEnabled(false);
        this.mInputStdDevLabel.setEnabled(false);
    }

    private void setSimulatedPanelFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mSimulatedFieldTable);
        this.mComponentOrder.add(this.mFitAllButton);
        this.mComponentOrder.add(this.mFitSelectedButton);
        this.mComponentOrder.add(this.mFitDetaildButton);
        this.mComponentOrder.add(this.mSensitivityButton);
        this.mComponentOrder.add(this.mSimulationPanel.getHelpPanel());
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
    }

    private void setCorrPanelFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mCorrRecalButton);
        this.mComponentOrder.add(this.mCorrDontCalButton);
        this.mComponentOrder.add(this.mCorrResetButton);
        this.mComponentOrder.add(this.mCorrelationTable);
        if (this.mCorrExcludeMesg.getText().length() > 1) {
            this.mComponentOrder.add(this.mCorrExcludeMesg);
        }
        this.mComponentOrder.add(this.mCorrCrosstabCheck);
        this.mComponentOrder.add(this.mCtgtFromDataButton);
        this.mComponentOrder.add(this.mCtgtFromPlanButton);
        this.mComponentOrder.add(this.mSimulationPanel.getHelpPanel());
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
    }

    private void setOptionFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mNumOfScasesField);
        this.mComponentOrder.add(this.mTargetCombo);
        this.mComponentOrder.add(this.mNumLabelEnd);
        this.mComponentOrder.add(this.mStopCriteriaLabel);
        this.mComponentOrder.add(this.mNoneButton);
        this.mComponentOrder.add(this.mTailButton);
        this.mComponentOrder.add(this.mTailTypeCombo);
        this.mComponentOrder.add(this.mTailSideCombo);
        this.mComponentOrder.add(this.mTailPercenField);
        this.mComponentOrder.add(this.mTailFreq);
        this.mComponentOrder.add(this.mTailValueField);
        this.mComponentOrder.add(this.mThresholdButton);
        this.mComponentOrder.add(this.mThreshTypeCombo);
        this.mComponentOrder.add(this.mThreshPercenField);
        this.mComponentOrder.add(this.mThreshConfField);
        this.mComponentOrder.add(this.mThreshValueField);
        this.mComponentOrder.add(this.mNumCasesToUseLabel);
        this.mComponentOrder.add(this.mNCasesButton);
        this.mComponentOrder.add(this.mAllCases);
        this.mComponentOrder.add(this.mLimitNCaseField);
        this.mComponentOrder.add(this.mFitForScaleFieldsLabel);
        this.mComponentOrder.add(this.mAndersonDarlingButton);
        this.mComponentOrder.add(this.mScaleKSButton);
        this.mComponentOrder.add(this.mCatMissingLabel);
        this.mComponentOrder.add(this.mMisExcludeButton);
        this.mComponentOrder.add(this.mMisIncludeButton);
        this.mComponentOrder.add(this.mBinNumber.getEditor());
        this.mComponentOrder.add(this.mSeedCheck);
        this.mComponentOrder.add(this.mGenerateButton);
        this.mComponentOrder.add(this.mSeedField);
        this.mComponentOrder.add(this.mSimulationPanel.getHelpPanel());
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
    }

    private void setDFunctionFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mPDF);
        this.mComponentOrder.add(this.mCDF);
        this.mComponentOrder.add(this.mSliderSetCheck);
        this.mComponentOrder.add(this.mSliderLowValue);
        this.mComponentOrder.add(this.mSliderUppValue);
        this.mComponentOrder.add(this.mSliderNegInfCheck);
        this.mComponentOrder.add(this.mSliderPosInfCheck);
        this.mComponentOrder.add(this.mRefMeanCheck);
        this.mComponentOrder.add(this.mRefMedianCheck);
        this.mComponentOrder.add(this.mRefSigmaCheck);
        this.mComponentOrder.add(this.mRefSigmaNumberLabel);
        this.mComponentOrder.add(this.mSigmaValue.getEditor());
        this.mComponentOrder.add(this.mRefPercentileCheck);
        this.mComponentOrder.add(this.mBottomValue);
        this.mComponentOrder.add(this.mTopValue);
        this.mComponentOrder.add(this.mRefCustomCheck);
        this.mComponentOrder.add(this.mCustomValueTable);
        this.mComponentOrder.add(this.mOverlayCheck);
        this.mComponentOrder.add(this.mCatGroupLabel);
        this.mComponentOrder.add(this.mPredCatCheck);
        this.mComponentOrder.add(this.mPredProbCheck);
        this.mComponentOrder.add(this.mBothPredProb);
        this.mComponentOrder.add(this.mGroupingLabel);
        this.mComponentOrder.add(this.mCatGroupButton);
        this.mComponentOrder.add(this.mIterGroupButton);
        this.mComponentOrder.add(this.mSimulationPanel.getHelpPanel());
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
    }

    private void setOutputFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mTornadoCharts);
        this.mComponentOrder.add(this.mContrToVariCheck);
        this.mComponentOrder.add(this.mSensitivityToChangeCheck);
        this.mComponentOrder.add(this.mInputStdDevField);
        this.mComponentOrder.add(this.mBoxPlotCheck);
        this.mComponentOrder.add(this.mOverlayResultCheck);
        this.mComponentOrder.add(this.mScatterplots);
        this.mComponentOrder.add(this.mCreatTableCheck);
        this.mComponentOrder.add(this.mQuantitleCheck);
        this.mComponentOrder.add(this.mIntervaCheck);
        this.mComponentOrder.add(this.mIntervalValue.getEditor());
        this.mComponentOrder.add(this.mCustPercenCheck);
        this.mComponentOrder.add(this.mCustPercentList);
        this.mComponentOrder.add(this.mDescrCheck);
        this.mComponentOrder.add(this.mmDescConfField);
        this.mComponentOrder.add(this.mInputList);
        this.mComponentOrder.add(this.mFormatTable);
        this.mComponentOrder.add(this.mSimulationPanel.getHelpPanel());
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
    }

    private void setSaveFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mSavePlanFileCheck);
        this.mComponentOrder.add(this.mPlanNameField);
        this.mComponentOrder.add(this.mBrowsePlanButton);
        this.mComponentOrder.add(this.mSaveSimToFileCheck);
        this.mComponentOrder.add(this.mSaveFileSav);
        this.mComponentOrder.add(this.mSavNameField);
        this.mComponentOrder.add(this.mBrowseSavButton);
        this.mComponentOrder.add(this.mSaveToDataset);
        this.mComponentOrder.add(this.mDatasetNameField);
        this.mComponentOrder.add(this.mSaveFileExcel);
        this.mComponentOrder.add(this.mExcelNameField);
        this.mComponentOrder.add(this.mBrowseExcelButton);
        this.mComponentOrder.add(this.mSimulationPanel.getHelpPanel());
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
    }

    @Override
    public Vector<Object> getComponentOrder() {
        this.mComponentOrder.clear();
        JList jList = this.mSimulationPanel.getItemList();
        this.mComponentOrder.add(jList);
        if (this.mSimulationPanel.getSelectedIndex() == 0) {
            this.setSimulatedPanelFocusTraversalPolicy();
        } else if (this.mSimulationPanel.getSelectedIndex() == 1) {
            this.setCorrPanelFocusTraversalPolicy();
        }
        if (this.mSimulationPanel.getSelectedIndex() == 2) {
            this.setOptionFocusTraversalPolicy();
        }
        if (this.mSimulationPanel.getSelectedIndex() == 3) {
            this.setDFunctionFocusTraversalPolicy();
        }
        if (this.mSimulationPanel.getSelectedIndex() == 4) {
            this.setOutputFocusTraversalPolicy();
        }
        if (this.mSimulationPanel.getSelectedIndex() == 5) {
            this.setSaveFocusTraversalPolicy();
        }
        return this.mComponentOrder;
    }

    private void enableCtgtButtons() {
        if (this.mCorrCrosstabCheck.isSelected() && this.mCrossFactorNames != null && this.mCrossFactorNames.size() > 0) {
            this.mCtgtFromDataButton.setEnabled(true);
            this.mCtgtFromPlanButton.setEnabled(true);
        } else {
            this.mCtgtFromDataButton.setEnabled(false);
            this.mCtgtFromPlanButton.setEnabled(false);
        }
    }

    private void enableOptionStopCriteriaControls(JRadioButton jRadioButton) {
        if (jRadioButton == this.mNoneButton) {
            this.mTailTypeLabel.setEnabled(false);
            this.mTailTypeCombo.setEnabled(false);
            this.mTailSideLabel.setEnabled(false);
            this.mTailSideCombo.setEnabled(false);
            this.mTailPercentileLabel.setEnabled(false);
            this.mTailPercenField.setEnabled(false);
            this.mTailFreqLabel.setEnabled(false);
            this.mTailFreq.setEnabled(false);
            this.mTailValueLabel.setEnabled(false);
            this.mTailValueField.setEnabled(false);
            this.mThreshTypeLabel.setEnabled(false);
            this.mThreshTypeCombo.setEnabled(false);
            this.mThreshPercenLabel.setEnabled(false);
            this.mThreshPercenField.setEnabled(false);
            this.mThreshConfLabel.setEnabled(false);
            this.mThreshConfField.setEnabled(false);
            this.mThreshValuefLabel.setEnabled(false);
            this.mThreshValueField.setEnabled(false);
        } else if (jRadioButton == this.mTailButton) {
            this.mTailTypeLabel.setEnabled(true);
            this.mTailTypeCombo.setEnabled(true);
            this.mTailSideLabel.setEnabled(true);
            this.mTailSideCombo.setEnabled(true);
            this.mTailPercentileLabel.setEnabled(true);
            this.mTailPercenField.setEnabled(true);
            this.mTailFreqLabel.setEnabled(true);
            this.mTailFreq.setEnabled(true);
            this.mTailValueLabel.setEnabled(true);
            this.mTailValueField.setEnabled(true);
            int n = this.mTailTypeCombo.getSelectedIndex();
            if (n == 0) {
                this.mTailPercentileLabel.setEnabled(true);
                this.mTailPercenField.setEnabled(true);
                this.mTailSideCombo.setEnabled(false);
                this.mTailValueField.setEnabled(false);
                this.mTailValueLabel.setEnabled(false);
            } else if (n == 1) {
                this.mTailSideCombo.setEnabled(true);
                this.mTailValueField.setEnabled(true);
                this.mTailValueLabel.setEnabled(true);
                this.mTailPercentileLabel.setEnabled(false);
                this.mTailPercenField.setEnabled(false);
            }
            this.mThreshTypeLabel.setEnabled(false);
            this.mThreshTypeCombo.setEnabled(false);
            this.mThreshPercenLabel.setEnabled(false);
            this.mThreshPercenField.setEnabled(false);
            this.mThreshConfLabel.setEnabled(false);
            this.mThreshConfField.setEnabled(false);
            this.mThreshValuefLabel.setEnabled(false);
            this.mThreshValueField.setEnabled(false);
        } else if (jRadioButton == this.mThresholdButton) {
            this.mTailTypeLabel.setEnabled(false);
            this.mTailTypeCombo.setEnabled(false);
            this.mTailSideLabel.setEnabled(false);
            this.mTailSideCombo.setEnabled(false);
            this.mTailPercentileLabel.setEnabled(false);
            this.mTailPercenField.setEnabled(false);
            this.mTailFreqLabel.setEnabled(false);
            this.mTailFreq.setEnabled(false);
            this.mTailValueLabel.setEnabled(false);
            this.mTailValueField.setEnabled(false);
            this.mThreshTypeLabel.setEnabled(true);
            this.mThreshTypeCombo.setEnabled(true);
            this.mThreshPercenLabel.setEnabled(true);
            this.mThreshPercenField.setEnabled(true);
            this.mThreshConfLabel.setEnabled(true);
            this.mThreshConfField.setEnabled(true);
            this.mThreshValuefLabel.setEnabled(true);
            this.mThreshValueField.setEnabled(true);
            int n = this.mThreshTypeCombo.getSelectedIndex();
            if (n == 0) {
                this.mThreshPercenLabel.setEnabled(true);
                this.mThreshPercenField.setEnabled(true);
                this.mThreshValuefLabel.setEnabled(false);
                this.mThreshValueField.setEnabled(false);
            } else if (n == 1) {
                this.mThreshPercenLabel.setEnabled(false);
                this.mThreshPercenField.setEnabled(false);
                this.mThreshValuefLabel.setEnabled(true);
                this.mThreshValueField.setEnabled(true);
            }
        }
    }

    private void enableSaveSidebarControls(boolean bl, boolean bl2) {
        this.mSaveFileSav.setEnabled(bl);
        this.mSaveFileExcel.setEnabled(bl);
        this.mSaveToDataset.setEnabled(bl);
        if (bl2) {
            this.mSaveToDataset.setSelected(true);
        }
        if (bl) {
            if (this.mSaveFileSav.isSelected()) {
                this.mBrowseSavButton.setEnabled(true);
                this.mSavFileLabel.setEnabled(true);
                this.mSavNameField.setEnabled(true);
                this.mDatasetFieldLabel.setEnabled(false);
                this.mDatasetNameField.setEnabled(false);
                this.mBrowseExcelButton.setEnabled(false);
                this.mExcelFileLabel.setEnabled(false);
                this.mExcelNameField.setEnabled(false);
            } else if (this.mSaveToDataset.isSelected()) {
                this.mBrowseSavButton.setEnabled(false);
                this.mSavFileLabel.setEnabled(false);
                this.mSavNameField.setEnabled(false);
                this.mDatasetFieldLabel.setEnabled(true);
                this.mDatasetNameField.setEnabled(true);
                if (bl2 && this.mDatasetNameField.getText().length() == 0) {
                    this.mDatasetNameField.setText(SpssMgr.getSpssMgr().getNextFreeDatasetName());
                }
                this.mBrowseExcelButton.setEnabled(false);
                this.mExcelFileLabel.setEnabled(false);
                this.mExcelNameField.setEnabled(false);
            } else {
                this.mBrowseSavButton.setEnabled(false);
                this.mSavFileLabel.setEnabled(false);
                this.mSavNameField.setEnabled(false);
                this.mDatasetFieldLabel.setEnabled(false);
                this.mDatasetNameField.setEnabled(false);
                this.mBrowseExcelButton.setEnabled(true);
                this.mExcelFileLabel.setEnabled(true);
                this.mExcelNameField.setEnabled(true);
            }
        } else {
            this.mBrowseSavButton.setEnabled(false);
            this.mSavFileLabel.setEnabled(false);
            this.mSavNameField.setEnabled(false);
            this.mDatasetFieldLabel.setEnabled(false);
            this.mDatasetNameField.setEnabled(false);
            this.mBrowseExcelButton.setEnabled(false);
            this.mExcelFileLabel.setEnabled(false);
            this.mExcelNameField.setEnabled(false);
        }
    }

    private void enableDFRefPanel(boolean bl) {
        this.mRefMeanCheck.setEnabled(bl);
        this.mRefMedianCheck.setEnabled(bl);
        this.mRefSigmaCheck.setEnabled(bl);
        if (bl && this.mRefSigmaCheck.isSelected()) {
            this.mRefSigmaNumberLabel.setEnabled(bl);
            this.mSigmaValue.setEnabled(bl);
        }
        this.mRefPercentileCheck.setEnabled(bl);
        if (bl && this.mRefPercentileCheck.isSelected()) {
            this.mTopLabel.setEnabled(bl);
            this.mTopValue.setEnabled(bl);
            this.mBottomLabel.setEnabled(bl);
            this.mBottomValue.setEnabled(bl);
        }
        this.mRefCustomCheck.setEnabled(bl);
        if (bl && this.mRefCustomCheck.isSelected()) {
            this.mCustomLabel.setEnabled(bl);
            this.mCustomValueTable.setEnabled(bl);
        }
    }

    private void enableSliderPanel() {
        if (this.mSliderSetCheck.isEnabled() && this.mSliderSetCheck.isSelected()) {
            this.mSliderNegInfCheck.setEnabled(true);
            this.mSliderPosInfCheck.setEnabled(true);
            if (this.mSliderNegInfCheck.isSelected()) {
                this.mSliderLowLabel.setEnabled(false);
                this.mSliderLowValue.setEnabled(false);
            } else {
                this.mSliderLowLabel.setEnabled(true);
                this.mSliderLowValue.setEnabled(true);
            }
            if (this.mSliderPosInfCheck.isSelected()) {
                this.mSliderUppLabel.setEnabled(false);
                this.mSliderUppValue.setEnabled(false);
            } else {
                this.mSliderUppLabel.setEnabled(true);
                this.mSliderUppValue.setEnabled(true);
            }
        } else {
            this.mSliderLowLabel.setEnabled(false);
            this.mSliderLowValue.setEnabled(false);
            this.mSliderUppLabel.setEnabled(false);
            this.mSliderUppValue.setEnabled(false);
            this.mSliderNegInfCheck.setEnabled(false);
            this.mSliderPosInfCheck.setEnabled(false);
        }
    }

    private void updataDFPanelControls() {
        if (!this.mPDF.isSelected() && !this.mCDF.isSelected()) {
            this.enableDFRefPanel(false);
            this.enableDFPDFPanel(false);
            this.mOverlayCheck.setEnabled(false);
        } else {
            if (this.mPDF.isSelected()) {
                this.enableDFPDFPanel(true);
            } else {
                this.enableDFPDFPanel(false);
            }
            this.enableDFRefPanel(true);
            this.mOverlayCheck.setEnabled(true);
        }
    }

    private void updateSavePanelControls() {
        if (this.mSavePlanFileCheck.isSelected()) {
            this.mPlanNameField.setEnabled(true);
            this.mBrowsePlanButton.setEnabled(true);
        } else {
            this.mPlanNameField.setEnabled(false);
            this.mBrowsePlanButton.setEnabled(false);
        }
        if (this.mSaveSimToFileCheck.isSelected()) {
            this.enableSaveSidebarControls(true, false);
        } else {
            this.enableSaveSidebarControls(false, false);
        }
    }

    private void enableDFPDFPanel(boolean bl) {
        this.mCatGroupLabel.setEnabled(bl);
        this.mPredCatCheck.setEnabled(bl);
        this.mPredProbCheck.setEnabled(bl);
        this.mBothPredProb.setEnabled(bl);
        this.mGroupingLabel.setEnabled(bl);
        this.mCatGroupButton.setEnabled(bl);
        this.mIterGroupButton.setEnabled(bl);
    }

    private void initSimulatedFieldVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMULATED_FIELD_FIT_SELECTED_BUTTON");
        this.mFitSelectedButton = new JButton(toggleButtonAction);
        this.mFitSelectedButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMULATED_FIELD_FITALL_BUTTON");
        this.mFitAllButton = new JButton(toggleButtonAction);
        this.mFitAllButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMULATED_FIELD_FIT_DETAIL_BUTTON");
        this.mFitDetaildButton = new JButton(toggleButtonAction);
        this.mFitDetaildButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMULATED_FIELD_ITERATE_BUTTON");
        this.mSensitivityButton = new JButton(toggleButtonAction);
        this.mSensitivityButton.addActionListener(this);
        SimulatedFieldTableModel simulatedFieldTableModel = new SimulatedFieldTableModel(this.mParent.getResStringArray("IDS_MC_SIMULATED_FIELD_TABLE_COLUMN_NAME_ARRARY"));
        this.mSimulatedFieldTable = new SimulatedFieldTable(simulatedFieldTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return MCSimulationTab.this.mParent.getResString("IDS_MC_SIMULATED_FIELD_TOOLTIP_TEXT");
            }
        };
        this.mSimulatedFieldTableLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SIMULATED_FIELD_LABEL");
        this.mSimulatedFieldTableLabel.setLabelFor(this.mSimulatedFieldTable);
        this.mSimulatedFieldTable.setRowSelectionAllowed(true);
    }

    private void initCorrelationVars() {
        this.mCorrRecalButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_CORRELATION_RECALCULATE_BUTTON", null);
        this.mCorrDontCalButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_CORRELATION_DONNOT_BUTTON", null);
        this.mCorrGroup = new SpssButtonGroup();
        this.mCorrGroup.add(this.mCorrRecalButton);
        this.mCorrGroup.add(this.mCorrDontCalButton);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_CORRELATION_RESET_BUTTON");
        this.mCorrResetButton = new JButton(toggleButtonAction);
        this.mCorrResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MCSimulationTab.this.mCorrelationTable.getRowCount() > 0) {
                    boolean bl;
                    boolean bl2 = bl = SpssAlertOptionPane.showConfirmDialog(MCSimulationTab.this, MCSimulationTab.this.getResString("IDS_MC_CORRELATION_REST_MESG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0;
                    if (bl) {
                        MCSimulationTab.this.mCorrelationTableModel.resetAll();
                    }
                }
            }
        });
        Vector vector = new Vector();
        this.mCorrelationTableModel = new CorrelationTableModel();
        this.mCorrelationTable = new PlainTable(this.mCorrelationTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return MCSimulationTab.this.mParent.getResString("IDS_MC_CORRELATION_TABLE_LABEL");
            }
        };
        this.mCorrelationTable.setRowHeight(22);
        this.mCorrelationTable.setColumnSelectionAllowed(true);
        this.mCorrelationTable.setRowSelectionAllowed(true);
        this.mCorrelationTable.getTableHeader().setReorderingAllowed(false);
        this.mCorrelationTable.getTableHeader().setResizingAllowed(true);
        this.mCorrelationTable.setGridColor(Color.darkGray);
        this.mCorrelationTable.getTableHeader().setReorderingAllowed(false);
        this.mCorrelationTableLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_CORRELATION_TABLE_LABEL");
        this.mCorrelationTableLabel.setLabelFor(this.mCorrelationTable);
        CorrMatrixCellRender corrMatrixCellRender = new CorrMatrixCellRender();
        this.mCorrelationTable.setDefaultRenderer(Object.class, corrMatrixCellRender);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.mCorrelationTable.setDefaultRenderer(Double.class, corrMatrixCellRender);
        }
        this.mCorrField = new FloatTextField(-1.0, 1.0, 3);
        this.mCorrelationTable.setDefaultEditor(Double.class, new FloatFieldEditor(this.mCorrField));
        this.mCorrelationTable.getModel().addTableModelListener(this);
        this.mCorrExcludeMesg = new StringTextField();
        this.mCorrExcludeMesg.setText("");
        this.mCorrExcludeMesg.setEnabled(true);
        this.mCorrExcludeMesg.setFocusable(true);
        this.mCorrExcludeMesg.setEditable(false);
        this.mCorrExcludeMesg.setOpaque(false);
        this.mCorrExcludeMesg.setBorder(BorderFactory.createEmptyBorder());
        this.mCorrCrosstabCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_CORRELATION_CORR_CROSSTAB_CHECK", null);
        this.mCorrCrosstabCheck.addActionListener(this);
        this.mCorrCrosstabCheck.setSelected(false);
        this.mCtgtFromDataButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_CORRELATION_CONTIGENCY_FROM_DATA_BUTTON", null);
        this.mCtgtFromDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JRadioButton)actionEvent.getSource()).isSelected() && MCSimulationTab.this.mCorrCrosstabCheck.isSelected() && MCSimulationTab.this.mCrossFactorNames != null && MCSimulationTab.this.mCrossFactorNames.size() > 0) {
                    MCSimulationTab.this.updateContingencyFields(true);
                }
            }
        });
        this.mCtgtFromPlanButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_CORRELATION_CONTIGENCY_FROM_PLAN_BUTTON", null);
        this.mCtgtFromPlanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JRadioButton)actionEvent.getSource()).isSelected() && MCSimulationTab.this.mCorrCrosstabCheck.isSelected() && MCSimulationTab.this.mCrossFactorNames != null && MCSimulationTab.this.mCrossFactorNames.size() > 0) {
                    int n = SpssAlertOptionPane.showConfirmDialog(MCSimulationTab.this, MCSimulationTab.this.getResString("IDS_MC_CHANGE_FIELD_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                    if (n == 2) {
                        MCSimulationTab.this.mCtgtFromDataButton.setSelected(true);
                    } else {
                        MCSimulationTab.this.updateContingencyFields(false);
                    }
                }
            }
        });
        this.mCgtGroup = new SpssButtonGroup();
        this.mCgtGroup.add(this.mCtgtFromDataButton);
        this.mCgtGroup.add(this.mCtgtFromPlanButton);
    }

    private void initOptionVars() {
        Serializable serializable;
        this.mNumOfSCasesLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_NUM_SIMULATED_CASE_LABEL");
        this.mNumOfScasesField = new IntTextField(1000, Integer.MAX_VALUE);
        this.mNumOfScasesField.setAction((Action)new TextFieldAction(this.mParent, NUM_CASES_TO_GENERATE));
        this.mNumOfScasesField.setHorizontalAlignment(4);
        this.mNumOfSCasesLabel.setLabelFor((Component)this.mNumOfScasesField);
        this.mNumLabelEnd = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_NUM_SIMULATED_CASE_LABEL_TAIL");
        this.mTargetLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_TARGET_COMBO_LABEL");
        this.mTargetComboModel = new DefaultComboBoxModel<String>(this.mTargetNames);
        this.mTargetCombo = new JComboBox(this.mTargetComboModel);
        this.mTargetCombo.setAction(new ComboboxAction(this.mParent, TARGET_COMBO));
        this.mTargetCombo.addActionListener(this);
        this.mTargetLabel.setLabelFor(this.mTargetCombo);
        this.mStopCriteriaLabel = new StringTextField();
        this.mStopCriteriaLabel.setText(" " + this.getResString("IDS_MC_OPTION_STOP_CRITERIA_LABEL"));
        this.mStopCriteriaLabel.setEnabled(true);
        this.mStopCriteriaLabel.setFocusable(true);
        this.mStopCriteriaLabel.setEditable(false);
        this.mStopCriteriaLabel.setOpaque(false);
        this.mStopCriteriaLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mNoneButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_STOP_CRITERIA_RADIO_NONE", null);
        this.mNoneButton.addItemListener(this);
        this.mTailButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_STOP_CRITERIA_RADIO_BY_TAIL", null);
        this.mTailButton.addItemListener(this);
        this.mTailTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_TAIL_TYPE");
        this.mTailTypeCombo = new JComboBox<String>(this.getResStringArray("IDS_MC_OPTION_STOP_TAIL_TYPE_ARRAY"));
        this.mTailTypeCombo.setAction(new ComboboxAction(this.mParent, TAIL_TYPE_COMBO));
        this.mTailTypeCombo.addActionListener(this);
        this.mTailTypeLabel.setLabelFor(this.mTailTypeCombo);
        this.mTailSideLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_TAIL_SIDE");
        this.mTailSideCombo = new JComboBox<String>(this.getResStringArray("IDS_MC_OPTION_STOP_TAIL_SIDE_ARRAY"));
        this.mTailSideCombo.setAction(new ComboboxAction(this.mParent, TAIL_SIDE_COMBO));
        this.mTailSideLabel.setLabelFor(this.mTailSideCombo);
        this.mTailPercentileLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_TAIL_PERCENTILE");
        this.mTailPercenField = new FloatTextField(1.0, 100.0, 2, true, true);
        this.mTailPercenField.setHorizontalAlignment(4);
        this.mTailPercenField.setColumns(8);
        this.mTailPercenField.setAction((Action)new TextFieldAction(this.mParent, TAIL_PERCENTILE_VALUE));
        this.mTailPercentileLabel.setLabelFor((Component)this.mTailPercenField);
        this.mTailFreqLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_TAIL_FREQ");
        this.mTailFreq = new IntTextField(true);
        this.mTailFreq.setHorizontalAlignment(4);
        this.mTailFreq.setColumns(7);
        this.mTailFreqLabel.setLabelFor((Component)this.mTailFreq);
        this.mTailValueLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_TAIL_VALUE");
        this.mTailValueField = new FloatTextField(2);
        this.mTailValueField.setHorizontalAlignment(4);
        this.mTailValueField.setColumns(8);
        this.mTailValueField.setAction((Action)new TextFieldAction(this.mParent, OPTION_TAIL_VALUE));
        this.mTailValueLabel.setLabelFor((Component)this.mTailValueField);
        this.mThresholdButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_STOP_CRITERIA_RADIO_BY_THRESHOLD", null);
        this.mThresholdButton.addItemListener(this);
        this.mCriteriaGroup = new SpssButtonGroup();
        this.mCriteriaGroup.add(this.mNoneButton);
        this.mCriteriaGroup.add(this.mTailButton);
        this.mCriteriaGroup.add(this.mThresholdButton);
        this.mThreshTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_CRITERIA_THRESH_TYPE");
        this.mThreshTypeCombo = new JComboBox<String>(this.getResStringArray("IDS_MC_OPTION_STOP_THRESH_TYPE_ARRAY"));
        this.mThreshTypeCombo.setAction(new ComboboxAction(this.mParent, THRESH_TYPE_COMBO));
        this.mThreshTypeCombo.addActionListener(this);
        this.mThreshTypeLabel.setLabelFor(this.mThreshTypeCombo);
        this.mThreshPercenLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_THRESH_PERCENTILE");
        this.mThreshPercenField = new FloatTextField(0.0, Double.MAX_VALUE, 2, true, true);
        this.mThreshPercenField.setIncludeMinRange(false);
        this.mThreshPercenField.setHorizontalAlignment(4);
        this.mThreshPercenField.setAction((Action)new TextFieldAction(this.mParent, THRESH_PERCENTILE));
        this.mThreshPercenField.setColumns(8);
        this.mThreshPercenLabel.setLabelFor((Component)this.mThreshPercenField);
        this.mThreshValuefLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_THRESH_VALUE");
        this.mThreshValueField = new FloatTextField(2);
        this.mThreshValueField.setHorizontalAlignment(4);
        this.mThreshValueField.setAction((Action)new TextFieldAction(this.mParent, THRESH_VALUE));
        this.mThreshValueField.setColumns(8);
        this.mThreshValuefLabel.setLabelFor((Component)this.mThreshValueField);
        this.mThreshConfLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_STOP_CRITERIA_CONFIDENCE");
        this.mThreshConfField = new FloatTextField(50.0, 100.0, 3, true, true);
        this.mThreshConfField.setIncludeMaxRange(false);
        this.mThreshConfField.setHorizontalAlignment(4);
        this.mThreshConfField.setAction((Action)new TextFieldAction(this.mParent, THRESH_CONFIDENCE));
        this.mThreshConfField.setColumns(6);
        this.mThreshConfLabel.setLabelFor((Component)this.mThreshConfField);
        this.mNumCasesToUseLabel = new StringTextField();
        this.mNumCasesToUseLabel.setText(" " + this.getResString("IDS_MC_OPTION_NUM_CASES_TO_USE_LABEL"));
        this.mNumCasesToUseLabel.setEnabled(true);
        this.mNumCasesToUseLabel.setFocusable(true);
        this.mNumCasesToUseLabel.setEditable(false);
        this.mNumCasesToUseLabel.setOpaque(false);
        this.mNumCasesToUseLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mNCasesButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_LIMIT_TO_N_LABEL", null);
        this.mNCasesButton.addItemListener(this);
        this.mAllCases = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_ALL_CASE_LABEL", null);
        this.mAllCases.addItemListener(this);
        this.mCasesButtonGroup = new SpssButtonGroup();
        this.mCasesButtonGroup.add(this.mNCasesButton);
        this.mCasesButtonGroup.add(this.mAllCases);
        this.mLimitNCaseField = new IntTextField(true);
        this.mLimitNCaseField.setHorizontalAlignment(4);
        this.mLimitNCaseField.setAction((Action)new TextFieldAction(this.mParent, LIMIT_CASE_NUM));
        this.mNLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_LIMIT_TO_N_FIELD");
        this.mNLabel.setLabelFor((Component)this.mLimitNCaseField);
        this.mFitForScaleFieldsLabel = new FocusableTextArea(this.getResString("IDS_MC_OPTION_FIT_FOR_SCALE_FIELD_LABEL"), null);
        this.mAndersonDarlingButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_ANDERSON_DARLING_LABEL", null);
        this.mAndersonDarlingButton.addItemListener(this);
        this.mScaleKSButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_KS_SCALE_LABEL", null);
        this.mScaleKSButton.addItemListener(this);
        this.mFitScaleGroup = new SpssButtonGroup();
        this.mFitScaleGroup.add(this.mAndersonDarlingButton);
        this.mFitScaleGroup.add(this.mScaleKSButton);
        this.mCatMissingLabel = new FocusableTextArea(this.getResString("IDS_MC_OPTION_CAT_MISSING_LABEL"), null);
        this.mMisExcludeButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_CAT_EXCLUDE_BUTTON", null);
        this.mMisIncludeButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OPTION_CAT_INCLUDE_BUTTON", null);
        this.mMissGroup = new SpssButtonGroup();
        this.mMissGroup.add(this.mMisExcludeButton);
        this.mMissGroup.add(this.mMisIncludeButton);
        this.mBinSpinnderLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_EMPIRICAL_BIN_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(100, 10, 1000, 1);
        IntTextField intTextField = new IntTextField(10, 1000, true);
        intTextField.setHorizontalAlignment(4);
        this.mBinNumber = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mBinNumber.setAlignmentX(1.0f);
        this.mBinSpinnderLabel.setLabelFor(this.mBinNumber.getEditor());
        this.mSeedCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OPTION_SEED_CHECK", null);
        this.mSeedCheck.addActionListener(this);
        this.mSeedLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OPTION_SEED_FIELD_LABEL");
        int n = this.mSeedLabel.getPreferredSize().width;
        if (n > 180) {
            serializable = null;
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                String string = "IDS_MC_OPTION_SEED_FIELD_LABEL_KEY";
                string = string.replace("IDS_", "IDK_");
                serializable = this.mParent.getDlgAccessKey(string);
            }
            this.mSeedLabel = new SpssMultiLineLabel(this.getResString("IDS_MC_OPTION_SEED_FIELD_LABEL"), (Integer)serializable, 180, true);
        }
        this.mSeedField = new IntTextField(true);
        this.mSeedField.setAction((Action)new TextFieldAction(this.mParent, SEED_VALUE));
        this.mSeedField.setColumns(10);
        this.mSeedLabel.setLabelFor((Component)this.mSeedField);
        serializable = new ToggleButtonAction(this.mParent, "IDS_MC_OPTION_SEED_GENERATE_BUTTON");
        this.mGenerateButton = new JButton((Action)((Object)serializable));
        this.mGenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (int)(Math.random() * (double)(sMAX_NUM - sMIN_NUM + 1)) + sMIN_NUM;
                MCSimulationTab.this.mSeedField.setText(n.toString());
                MCSimulationTab.this.mSeedField.requestFocusInWindow();
            }
        });
    }

    private void initDFunctionVars() {
        this.mPDF = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_PDF_CHECK", null);
        this.mPDF.addActionListener(this);
        this.mPDF.addFocusListener(this);
        this.mCDF = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_CDF_CHECK", null);
        this.mCDF.addActionListener(this);
        this.mCDF.addFocusListener(this);
        this.mSliderSetCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_SLIDER_SET_CHECK", null);
        this.mSliderSetCheck.addActionListener(this);
        this.mSliderLowValue = new FloatTextField();
        this.mSliderLowValue.setIncludeMaxRange(false);
        this.mSliderLowValue.setAction((Action)new TextFieldAction(this.mParent, DF_SLIDER_LOW_VALUE));
        this.mSliderLowValue.setColumns(10);
        this.mSliderLowLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_DFUNCTIONS_SLIDER_LOWER_LABEL");
        this.mSliderLowLabel.setLabelFor((Component)this.mSliderLowValue);
        this.mSliderUppValue = new FloatTextField();
        this.mSliderUppValue.setIncludeMaxRange(false);
        this.mSliderUppValue.setAction((Action)new TextFieldAction(this.mParent, DF_SLIDER_UPPER_VALUE));
        this.mSliderUppValue.setColumns(10);
        this.mSliderUppLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_DFUNCTIONS_SLIDER_UPPER_LABEL");
        this.mSliderUppLabel.setLabelFor((Component)this.mSliderUppValue);
        this.mSliderNegInfCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_SLIDER_NEG_INF_CHECK", null);
        this.mSliderNegInfCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    MCSimulationTab.this.mSliderLowLabel.setEnabled(false);
                    MCSimulationTab.this.mSliderLowValue.setEnabled(false);
                } else {
                    MCSimulationTab.this.mSliderLowLabel.setEnabled(true);
                    MCSimulationTab.this.mSliderLowValue.setEnabled(true);
                }
            }
        });
        this.mSliderPosInfCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_SLIDER_POS_INF_CHECK", null);
        this.mSliderPosInfCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    MCSimulationTab.this.mSliderUppLabel.setEnabled(false);
                    MCSimulationTab.this.mSliderUppValue.setEnabled(false);
                } else {
                    MCSimulationTab.this.mSliderUppLabel.setEnabled(true);
                    MCSimulationTab.this.mSliderUppValue.setEnabled(true);
                }
            }
        });
        this.mRefMeanCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_REF_MEAN_CHECK", null);
        this.mRefMedianCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_REF_MEDIAN_CHECK", null);
        this.mRefSigmaCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_REF_SIGMA_CHECK", null);
        this.mRefSigmaCheck.addActionListener(this);
        this.mRefSigmaNumberLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_DFUNCTIONS_SIGMA_NUMBER_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(3, 1, 10, 1);
        IntTextField intTextField = new IntTextField(1, 10, true);
        intTextField.setHorizontalAlignment(4);
        intTextField.setAction((Action)new TextFieldAction(this.mParent, DF_SIGMA_LEVEL_VALUE));
        this.mSigmaValue = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mRefSigmaNumberLabel.setLabelFor(this.mSigmaValue.getEditor());
        this.mRefPercentileCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_REF_PERCENTILE_CHECK", null);
        this.mRefPercentileCheck.addActionListener(this);
        this.mTopLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_DFUNCTIONS_REF_TOP_LABEL");
        this.mTopValue = new FloatTextField(50.0, 100.0, 2, true, true);
        this.mTopValue.setIncludeMaxRange(false);
        this.mTopValue.setHorizontalAlignment(4);
        this.mTopValue.setAction((Action)new TextFieldAction(this.mParent, DF_PERCENTILE_TOP_VALUE));
        this.mTopValue.setColumns(10);
        this.mTopLabel.setLabelFor((Component)this.mTopValue);
        this.mBottomLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_DFUNCTIONS_REF_BOTTOM_LABEL");
        this.mBottomValue = new FloatTextField(0.0, 50.0, 2, true, true);
        this.mBottomValue.setIncludeMinRange(false);
        this.mBottomValue.setHorizontalAlignment(4);
        this.mBottomValue.setColumns(10);
        this.mBottomValue.setAction((Action)new TextFieldAction(this.mParent, DF_PERCENTILE_BOTTOM_VALUE));
        this.mBottomLabel.setLabelFor((Component)this.mBottomValue);
        this.mRefCustomCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_REF_CUSTOM_CHECK", null);
        this.mRefCustomCheck.addActionListener(this);
        this.mCustomLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_DFUNCTIONS_REF_VALUE_LABEL");
        this.mValueTableModel = new DefaultTableModel(new String[]{" "}, 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mCustomValueTable = new PlainTable();
        this.mCustomValueTable.setModel(this.mValueTableModel);
        this.mCustomValueTable.setRowHeight(22);
        this.mCustomValueTable.setColumnSelectionAllowed(false);
        this.mCustomValueTable.setRowSelectionAllowed(true);
        this.mCustomValueTable.setSelectionMode(0);
        this.mCustomValueTable.getTableHeader().setReorderingAllowed(false);
        this.mCustomValueTable.getTableHeader().setResizingAllowed(true);
        this.mCustomValueTable.setGridColor(Color.darkGray);
        this.mCustomValueTable.getTableHeader().setReorderingAllowed(false);
        this.mCustomValueTable.setSelectionMode(0);
        this.mCustomLabel.setLabelFor(this.mCustomValueTable);
        this.mCustomValueTable.getModel().addTableModelListener(this);
        this.mOverlayCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_DFUNCTIONS_OVERLAY_CHECK", null);
        this.mCatGroupLabel = new StringTextField();
        this.mCatGroupLabel.setText(" " + this.getResString("IDS_MC_DFUNCTIONS_CAT_GROUP_LABEL"));
        this.mCatGroupLabel.setEnabled(true);
        this.mCatGroupLabel.setFocusable(true);
        this.mCatGroupLabel.setEditable(false);
        this.mCatGroupLabel.setOpaque(false);
        this.mCatGroupLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mPredCatCheck = DialogUtil.createRadioButton(this.mParent, "IDS_MC_DFUNCTIONS_PRED_CAT_CHECK", null);
        this.mPredProbCheck = DialogUtil.createRadioButton(this.mParent, "IDS_MC_DFUNCTIONS_PRED_PROB_CHECK", null);
        this.mBothPredProb = DialogUtil.createRadioButton(this.mParent, "IDS_MC_DFUNCTIONS_BOTH_PRED_PROB_CHECK", null);
        this.mCatButtonGroup = new SpssButtonGroup();
        this.mCatButtonGroup.add(this.mPredCatCheck);
        this.mCatButtonGroup.add(this.mPredProbCheck);
        this.mCatButtonGroup.add(this.mBothPredProb);
        this.mGroupingLabel = new StringTextField();
        this.mGroupingLabel.setText(" " + this.getResString("IDS_MC_DFUNCTIONS_GROUPING_LABEL"));
        this.mGroupingLabel.setEnabled(true);
        this.mGroupingLabel.setFocusable(true);
        this.mGroupingLabel.setEditable(false);
        this.mGroupingLabel.setOpaque(false);
        this.mGroupingLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mCatGroupButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_DFUNCTIONS_GROUP_CAT_BUTTON", null);
        this.mCatGroupButton.addItemListener(this);
        this.mIterGroupButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_DFUNCTIONS_GROUP_ITERATION_BUTTON", null);
        this.mIterGroupButton.addItemListener(this);
        this.mGroupingGroup = new SpssButtonGroup();
        this.mGroupingGroup.add(this.mCatGroupButton);
        this.mGroupingGroup.add(this.mIterGroupButton);
    }

    private void initOutputVars() {
        this.mInputList = new InputCheckboxList();
        this.mInputList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    JCheckBox jCheckBox;
                    int n = MCSimulationTab.this.mInputList.getSelectedIndex();
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)MCSimulationTab.this.mInputList.getModel().getElementAt(n)).isSelected());
                    MCSimulationTab.this.updateSimulatedField(jCheckBox.getText(), jCheckBox.isSelected());
                    MCSimulationTab.this.repaint();
                }
            }
        });
        this.mSimInputListLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OUTPUT_SIM_TARGET_LABEL");
        this.mSimInputListLabel.setLabelFor(this.mInputList);
        this.mBoxPlotCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_BOXPLOT_CHECK", null);
        this.mBoxPlotCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    MCSimulationTab.this.mOverlayResultCheck.setEnabled(true);
                } else {
                    MCSimulationTab.this.mOverlayResultCheck.setEnabled(false);
                }
            }
        });
        this.mBoxPlotCheck.addFocusListener(this);
        this.mOverlayResultCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_OVERLAY_CHECK", null);
        this.mTornadoCharts = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_TORNADO_CHECK", null);
        this.mTornadoCharts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    MCSimulationTab.this.mForOrdinalVar.setEnabled(true);
                } else {
                    MCSimulationTab.this.mForOrdinalVar.setEnabled(false);
                }
            }
        });
        this.mTornadoCharts.addFocusListener(this);
        this.mForOrdinalVar = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_USE_ORDINAL_CHECK", null);
        this.mContrToVariCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_CONTRI_TO_VARIANCE_CHECK", null);
        this.mSensitivityToChangeCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_SENSITIVITY_TO_CHAHNGE_CHECK", null);
        this.mSensitivityToChangeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    MCSimulationTab.this.mInputStdDevLabel.setEnabled(true);
                    MCSimulationTab.this.mInputStdDevField.setEnabled(true);
                } else {
                    MCSimulationTab.this.mInputStdDevLabel.setEnabled(false);
                    MCSimulationTab.this.mInputStdDevField.setEnabled(false);
                }
            }
        });
        this.mInputStdDevLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OUTPUT_INPUT_STDDEV_LABEL");
        this.mInputStdDevField = new FloatTextField(0.01, 10.0, 2, true, true);
        this.mInputStdDevField.setAction((Action)new TextFieldAction(this.mParent, TORNADO_STDDEV_VALUE));
        this.mInputStdDevField.setColumns(8);
        this.mInputStdDevField.setHorizontalAlignment(4);
        this.mInputStdDevLabel.setLabelFor((Component)this.mInputStdDevField);
        this.mScatterplots = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_SCATTERPLOT_MATRIX_CHECK", null);
        this.mScatterplots.addFocusListener(this);
        this.mCreatTableCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_CREATE_TABLE_CHECK", null);
        this.mCreatTableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    MCSimulationTab.this.enableTableOfPercentile(true);
                } else {
                    MCSimulationTab.this.enableTableOfPercentile(false);
                }
            }
        });
        this.mQuantitleCheck = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OUTPUT_QUARTILE_CHECK", null);
        this.mQuantitleCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MCSimulationTab.this.mCreatTableCheck.isSelected()) {
                    MCSimulationTab.this.enableTableOfPercentile(true);
                } else {
                    MCSimulationTab.this.enableTableOfPercentile(false);
                }
            }
        });
        this.mIntervaCheck = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OUTPUT_INVERVAL_CHECK", null);
        this.mIntervaCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MCSimulationTab.this.mCreatTableCheck.isSelected()) {
                    MCSimulationTab.this.enableTableOfPercentile(true);
                } else {
                    MCSimulationTab.this.enableTableOfPercentile(false);
                }
            }
        });
        this.mIntervalLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OUTPUT_INVERVAL_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 2, 100, 1);
        IntTextField intTextField = new IntTextField(2, 100, true);
        intTextField.setHorizontalAlignment(4);
        this.mIntervalValue = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mIntervalLabel.setLabelFor(this.mIntervalValue.getEditor());
        this.mCustPercenCheck = DialogUtil.createRadioButton(this.mParent, "IDS_MC_OUTPUT_CUSTOM_PERCENT_CHECK", null);
        this.mCustPercenCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MCSimulationTab.this.mCreatTableCheck.isSelected()) {
                    MCSimulationTab.this.enableTableOfPercentile(true);
                } else {
                    MCSimulationTab.this.enableTableOfPercentile(false);
                }
            }
        });
        this.mPercentitleGroup = new SpssButtonGroup();
        this.mPercentitleGroup.add(this.mQuantitleCheck);
        this.mPercentitleGroup.add(this.mIntervaCheck);
        this.mPercentitleGroup.add(this.mCustPercenCheck);
        this.mCustPercentLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OUTPUT_CUSTOM_PERCENTILE_LABEL");
        this.mCustPercentModel = new DefaultTableModel(new String[]{" "}, 1);
        this.mCustPercentList = new PlainTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return MCSimulationTab.this.mCustPercenCheck.isEnabled() && MCSimulationTab.this.mCustPercenCheck.isSelected();
            }
        };
        this.mCustPercentList.setModel(this.mCustPercentModel);
        this.mCustPercentList.setFocusable(true);
        this.mCustPercentList.setRowHeight(22);
        this.mCustPercentList.setColumnSelectionAllowed(true);
        this.mCustPercentList.setRowSelectionAllowed(true);
        this.mCustPercentList.setCellSelectionEnabled(true);
        this.mCustPercentList.getTableHeader().setReorderingAllowed(false);
        this.mCustPercentList.getTableHeader().setResizingAllowed(false);
        this.mCustPercentLabel.setLabelFor(this.mCustPercentList);
        this.mCustPercentList.getModel().addTableModelListener(this);
        this.mDescrCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_DESCRIB_CHECK", null);
        this.mDescrCheck.addActionListener(this);
        this.mDescConfLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OUTPUT_CONF_INTERVAL_LABEL");
        this.mmDescConfField = new FloatTextField(50.0, 99.9, 2, true, true);
        this.mmDescConfField.setHorizontalAlignment(4);
        this.mmDescConfField.setColumns(10);
        this.mmDescConfField.setAction((Action)new TextFieldAction(this.mParent, DF_DESC_CONF_VALUE));
        this.mDescConfLabel.setLabelFor((Component)this.mmDescConfField);
        this.mCrosstabCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_OUTPUT_CORRELATION_CROSSTAB_CHECK", null);
        this.mFormatTableModel = new DefaultTableModel(this.getResStringArray("IDS_MC_OUTPUT_FORMAT_TABLE_COLUMN_NAME"), 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }
        };
        this.mFormatTable = new PlainTable(this.mFormatTableModel);
        this.mFormatTable.setFocusable(true);
        this.mFormatTable.setRowHeight(22);
        this.mFormatTable.setColumnSelectionAllowed(true);
        this.mFormatTable.setRowSelectionAllowed(true);
        this.mFormatTable.setCellSelectionEnabled(true);
        this.mFormatTable.getTableHeader().setReorderingAllowed(false);
        this.mFormatTable.getTableHeader().setResizingAllowed(true);
        this.mFormatTable.setGridColor(Color.darkGray);
        this.mFormatTable.getTableHeader().setReorderingAllowed(false);
        if (ComponentState.isBtdRtlOrLtr()) {
            this.mFormatTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = null;
                    jLabel = object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (n2 == 0) {
                        jLabel.setHorizontalAlignment(0);
                    } else {
                        jLabel.setHorizontalAlignment(2);
                    }
                    jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    jLabel.setBackground(jTable.getTableHeader().getBackground());
                    jLabel.setForeground(jTable.getTableHeader().getForeground());
                    return jLabel;
                }
            });
        }
        this.mTargetFormats = this.getResStringArray("IDS_MC_OUTPUT_FORMAT_TABLE_FORMAT_COMBO");
        final FieldFormatEditor fieldFormatEditor = new FieldFormatEditor(this.mTargetFormats);
        this.mFormatTable.getColumnModel().getColumn(1).setCellEditor(fieldFormatEditor);
        this.mFormatTable.getColumnModel().getColumn(1).setCellRenderer(new FieldFormatRenderer(this.mTargetFormats));
        final DisplayDecimalEditor displayDecimalEditor = new DisplayDecimalEditor();
        this.mFormatTable.getColumnModel().getColumn(2).setCellEditor(displayDecimalEditor);
        this.mFormatTableLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OUTPUT_FORMAT_TABLE_LABEL");
        this.mFormatTableLabel.setLabelFor(this.mFormatTable);
        this.mFormatTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = MCSimulationTab.this.mFormatTable.getSelectedRow();
                int n2 = MCSimulationTab.this.mFormatTable.getSelectedColumn();
                if (keyEvent.getKeyCode() == 32 && (n2 == 1 || n2 == 2)) {
                    MCSimulationTab.this.mFormatTable.editCellAt(n, n2);
                    if (n2 == 1) {
                        fieldFormatEditor.getComboBox().processKeyEvent(keyEvent);
                        fieldFormatEditor.getComboBox().requestFocus();
                    } else {
                        int n3 = displayDecimalEditor.getTextField().getText().length();
                        displayDecimalEditor.getTextField().setSelectionStart(0);
                        displayDecimalEditor.getTextField().setSelectionEnd(n3);
                        displayDecimalEditor.getTextField().requestFocus();
                    }
                }
            }
        });
        this.mLimitRangeTableLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_OUTPUT_LIMIT_TABLE_LABEL");
        this.mLimitRangeTableModel = new DefaultTableModel(this.getResStringArray("IDS_MC_OUTPUT_LIMIT_TABLE_COLUMN_NAME"), 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n2 == 0) {
                    return false;
                }
                if (n2 == 2 || n2 == 3) {
                    String string = MCSimulationTab.this.mLimitRangeTableModel.getValueAt(n, 1).toString();
                    if (string.equals(MCSimulationTab.this.mLimitValues[0])) {
                        return false;
                    }
                    if (string.equals(MCSimulationTab.this.mLimitValues[3])) {
                        return true;
                    }
                    if (string.equals(MCSimulationTab.this.mLimitValues[1])) {
                        return n2 == 2;
                    }
                    return n2 == 3;
                }
                return true;
            }
        };
        this.mLimitRangeTableModel.addTableModelListener(this);
        this.mLimitRangeTable = new PlainTable(this.mLimitRangeTableModel);
        this.mLimitRangeTable.setFocusable(true);
        this.mLimitRangeTable.setRowHeight(22);
        this.mLimitRangeTable.setColumnSelectionAllowed(true);
        this.mLimitRangeTable.setRowSelectionAllowed(true);
        this.mLimitRangeTable.setCellSelectionEnabled(true);
        this.mLimitRangeTable.getTableHeader().setReorderingAllowed(false);
        this.mLimitRangeTable.getTableHeader().setResizingAllowed(true);
        this.mLimitRangeTable.setGridColor(Color.darkGray);
        this.mLimitRangeTable.getTableHeader().setReorderingAllowed(false);
        this.mFloatFieldEditor = new FloatFieldEditor(new FloatTextField(5));
        this.mLimitValues = this.getResStringArray("IDS_MC_OUTPUT_LIMIT_VALUE_COMBO");
        this.mLimitRangeTable.getColumnModel().getColumn(1).setCellEditor(new FieldFormatEditor(this.mLimitValues));
        this.mLimitRangeTable.getColumnModel().getColumn(1).setCellRenderer(new FieldFormatRenderer(this.mLimitValues));
        this.mLimitRangeTable.getColumnModel().getColumn(2).setCellEditor(this.mFloatFieldEditor);
        this.mLimitRangeTable.getColumnModel().getColumn(2).setCellRenderer(new FloatFieldRender());
        this.mLimitRangeTable.getColumnModel().getColumn(3).setCellEditor(this.mFloatFieldEditor);
        this.mLimitRangeTable.getColumnModel().getColumn(3).setCellRenderer(new FloatFieldRender());
        this.mLimitRangeTableLabel.setLabelFor(this.mLimitRangeTable);
    }

    private void initSaveVars() {
        this.mSavePlanFileCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SAVE_PLAN_FILE_CHECK", null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SAVE_PLAN_FILE_BUTTON");
        this.mSavePlanFileCheck.addActionListener(this);
        this.mSavePlanFileLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SAVE_PLAN_FILE_LABEL");
        this.mPlanNameField = new FileTextField();
        this.mPlanNameField.setColumns(26);
        this.mPlanNameField.setAction(new TextFieldAction(this.mParent, NEW_PLAN_FILE_NAME));
        this.mSavePlanFileLabel.setLabelFor((Component)((Object)this.mPlanNameField));
        this.mBrowsePlanButton = new JButton(toggleButtonAction);
        this.mBrowsePlanButton.addActionListener(this);
        this.mSaveSimToFileCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SAVE_SIM_DATA_CHECK", null);
        this.mSaveSimToFileCheck.addActionListener(this);
        this.mDatasetFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SAVE_DATASET_LABEL");
        this.mSaveFileSav = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SAVE_AS_SAV_FILE_BUTTON", null);
        this.mSaveFileSav.addItemListener(this);
        this.mSaveToDataset = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SAVE_DATASET_BUTTON", null);
        this.mSaveToDataset.addItemListener(this);
        this.mSaveFileExcel = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SAVE_AS_EXCEL_FILE_BUTTON", null);
        this.mSaveFileExcel.addItemListener(this);
        this.mSaveGrop = new SpssButtonGroup();
        this.mSaveGrop.add(this.mSaveFileSav);
        this.mSaveGrop.add(this.mSaveToDataset);
        this.mSaveGrop.add(this.mSaveFileExcel);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SAVE_SAV_BROWSE_BUTTON");
        this.mBrowseSavButton = new JButton(toggleButtonAction);
        this.mBrowseSavButton.addActionListener(this);
        this.mSavFileLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SAVE_SAV_FILE_LABEL");
        this.mSavNameField = new FileTextField();
        this.mSavNameField.setColumns(26);
        this.mSavFileLabel.setLabelFor((Component)((Object)this.mSavNameField));
        this.mSavNameField.setAction(new TextFieldAction(this.mParent, NEW_SAV_FILE_NAME));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SAVE_EXCEL_BROWSE_BUTTON");
        this.mBrowseExcelButton = new JButton(toggleButtonAction);
        this.mBrowseExcelButton.addActionListener(this);
        this.mExcelFileLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SAVE_EXCEL_FILE_LABEL");
        this.mExcelNameField = new FileTextField();
        this.mExcelNameField.setColumns(26);
        this.mExcelFileLabel.setLabelFor((Component)((Object)this.mExcelNameField));
        this.mExcelNameField.setAction(new TextFieldAction(this.mParent, NEW_EXCEL_FILE_NAME));
        this.mDatasetNameField = new StringTextField();
        this.mDatasetNameField.setColumns(26);
        this.mDatasetNameField.setAction(new TextFieldAction(this.mParent, NEW_DATASET_NAME));
        this.mDatasetFieldLabel.setLabelFor((Component)((Object)this.mDatasetNameField));
    }

    private void addEmptyRow() {
        Vector<String> vector = new Vector<String>();
        vector.add("");
        this.mCustPercentModel.addRow(vector);
        this.mCustPercentList.setModel(this.mCustPercentModel);
    }

    @Override
    public int getNumSimulatedFields() {
        return this.mSimulatedFieldTable.getRowCount();
    }

    @Override
    public SimulatedField getFitToSimulatedField(int n) {
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(n);
        return simulatedField;
    }

    @Override
    public void setScannedVarMap(Hashtable<String, BaseMCSimulationTab.ScannedVar> hashtable) {
        this.mSimulatedFieldTable.setScannedVarMap(hashtable);
    }

    @Override
    public void setSimulatedPredictors(ArrayList<SimulatedField> arrayList) {
        ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).setSimulatedPredictors(arrayList, false);
    }

    @Override
    public void updateParameterCellFor(Vector<String> vector) {
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        for (int i = 0; i < simulatedFieldTableModel.getRowCount(); ++i) {
            SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
            if (!vector.contains(simulatedField.getName())) continue;
            this.mSimulatedFieldTable.refreshParametersCell(simulatedField);
        }
    }

    @Override
    public String getAutofitNCasesSyntax() {
        StringBuffer stringBuffer = new StringBuffer("\n /AUTOFIT NCASES=");
        if (this.mNCasesButton.isSelected() && this.mLimitNCaseField.getText().length() > 0) {
            stringBuffer.append(this.mLimitNCaseField.getText() + " ");
        } else {
            stringBuffer.append("ALL ");
        }
        if (this.mAndersonDarlingButton.isSelected()) {
            stringBuffer.append("FIT= AD");
        } else {
            stringBuffer.append("FIT= KS");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getMissingHandleSyntax() {
        StringBuffer stringBuffer = new StringBuffer("\n /MISSING CLASSMISSING=");
        if (this.mMisIncludeButton.isSelected()) {
            stringBuffer.append("INCLUDE");
        } else {
            stringBuffer.append("EXCLUDE");
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetSimulationPanel();
        this.resetCorrelationPanel();
        this.resetOptionPanel();
        this.resetDFunctionPanel();
        this.resetOutputPanel();
        this.setDefaults();
        this.mSimulationPanel.setInforText("", null);
    }

    private void resetSimulationPanel() {
        this.mSimulatedFieldTable.reset();
        ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).reset();
        ((SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel()).fireTableDataChanged();
        this.updateFitButtons();
    }

    private void resetCorrelationPanel() {
        if (this.mCorrelationTableModel.getRowCount() > 0) {
            this.mCorrelationTableModel.removeAll();
            this.mCorrelationTableModel = new CorrelationTableModel();
            this.mCorrelationTable.setModel(this.mCorrelationTableModel);
        }
        this.mCorrExcludeMesg.setText("");
    }

    private void resetOptionPanel() {
        if (this.mTargetNames != null) {
            this.mTargetNames.removeAllElements();
            this.mTargetComboModel.removeAllElements();
            this.mTargetCombo.setModel(this.mTargetComboModel);
            this.mTargetCombo.setEnabled(false);
            this.mTargetLabel.setEnabled(false);
        }
    }

    private void resetDFunctionPanel() {
        ((DefaultTableModel)this.mCustomValueTable.getModel()).setRowCount(0);
        ((DefaultTableModel)this.mCustomValueTable.getModel()).setRowCount(1);
    }

    private void resetOutputPanel() {
        this.mCustPercentModel.setRowCount(0);
        this.addEmptyRow();
        this.mFormatTableModel.setRowCount(0);
        this.mInputList.setListData(new Object[0]);
        this.mInputList.removeAll();
    }

    private void enableTableOfPercentile(boolean bl) {
        this.mQuantitleCheck.setEnabled(bl);
        if (this.mQuantitleCheck.isEnabled() && this.mQuantitleCheck.isSelected()) {
            this.mIntervalLabel.setEnabled(false);
            this.mIntervalValue.setEnabled(false);
            this.mCustPercentLabel.setEnabled(false);
            this.mCustPercentList.setEnabled(false);
        }
        this.mIntervaCheck.setEnabled(bl);
        if (this.mIntervaCheck.isEnabled() && this.mIntervaCheck.isSelected()) {
            this.mIntervalLabel.setEnabled(true);
            this.mIntervalValue.setEnabled(true);
        } else {
            this.mIntervalLabel.setEnabled(false);
            this.mIntervalValue.setEnabled(false);
        }
        this.mCustPercenCheck.setEnabled(bl);
        if (this.mCustPercenCheck.isEnabled() && this.mCustPercenCheck.isSelected()) {
            this.mCustPercentLabel.setEnabled(true);
            this.mCustPercentList.setEnabled(true);
            if (this.mCustPercentList.getEditorComponent() != null) {
                this.mCustPercentList.getEditorComponent().setEnabled(true);
            }
        } else {
            this.mCustPercentLabel.setEnabled(false);
            this.mCustPercentList.setEnabled(false);
            if (this.mCustPercentList.getEditorComponent() != null) {
                this.mCustPercentList.getEditorComponent().setEnabled(false);
            }
        }
    }

    private String formatDouble(double d, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }

    private void setupSimulatedSidebarPanel() {
        this.mSimulatedField = PanelFactory.getEmptyPanel("");
        JPanel jPanel = MonteCarloSimulationDlg.setupTablePanel(this.mSimulatedFieldTable, this.mSimulatedFieldTableLabel, new JButton[]{this.mFitAllButton, this.mFitSelectedButton, this.mFitDetaildButton, this.mSensitivityButton});
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, n2, 2, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mSimulatedField, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setSimulatedPanelFocusTraversalPolicy();
    }

    private void setupCorrelationsSidebarPanel() {
        this.mCorrelations = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mCorrelations, this.mCorrRecalButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2 * 4, n2);
        DialogUtil.addUsingGBL(this.mCorrelations, this.mCorrDontCalButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Dimension dimension = new Dimension(100, this.mCorrResetButton.getPreferredSize().height);
        this.mCorrResetButton.setPreferredSize(dimension);
        this.mCorrResetButton.setMinimumSize(dimension);
        JPanel jPanel = MonteCarloSimulationDlg.setupTablePanel(this.mCorrelationTable, this.mCorrelationTableLabel, new JButton[]{this.mCorrResetButton});
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2 * 4, n2, n2 * 3, n2 * 2);
        DialogUtil.addUsingGBL(this.mCorrelations, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 * 4, n2, n2 * 2, n2 * 2);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        jPanel2.setBorder(new TitledBorder(""));
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        Font font = new JTextArea().getFont();
        SimulationHelper.HelpPanel helpPanel = new SimulationHelper.HelpPanel(font, PanelFactory.PanelType.xaxis, true, false);
        helpPanel.setFocusable(true);
        helpPanel.setHelpTextAndIcon(this.getResString("IDK_MC_CORRELATION_CORR_CROSSTAB_INFO"), new ImageIcon(uRL), 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mCorrCrosstabCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 8, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mCtgtFromDataButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 8, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mCtgtFromPlanButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 2, n2 * 8, n2 * 6, n2);
        DialogUtil.addUsingGBL(jPanel2, helpPanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 3, n2, n2 * 3, n2 * 3);
        DialogUtil.addUsingGBL(this.mCorrelations, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setCorrPanelFocusTraversalPolicy();
    }

    private void setupOptionsSidebarPanel() {
        this.mOptions = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = 2;
        int n3 = 1;
        Insets insets = new Insets(n3, 0, n3, n2);
        gridBagConstraints.fill = 1;
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mParent.getResString("IDS_MC_OPTION_MAX_CASES_TITLE"));
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mNumOfSCasesLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n3, n2);
        Dimension dimension = (Dimension)this.mNumOfScasesField.getPreferredSize().clone();
        dimension.width = 120;
        this.mNumOfScasesField.setPreferredSize(dimension);
        this.mNumOfScasesField.setMinimumSize(dimension);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mNumOfScasesField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mNumLabelEnd, gridBagConstraints, 2, 0, 1, 1, n, insets);
        int n4 = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 6, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2, n3, n4);
        Dimension dimension2 = this.mTargetCombo.getPreferredSize();
        this.mTargetCombo.setPreferredSize(new Dimension(60, dimension2.height));
        this.mTargetCombo.setMinimumSize(new Dimension(60, dimension2.height));
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mTargetLabel, this.mTargetCombo}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 1, 6, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2, n3, n4);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mStopCriteriaLabel), gridBagConstraints, 0, 2, 6, 1, n, insets);
        insets.set(n3, n2 * 3, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mNoneButton, gridBagConstraints, 0, 3, 6, 1, n, insets);
        insets.set(n3, n2 * 3, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTailButton, gridBagConstraints, 0, 4, 6, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2 * 7, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTailTypeLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTailTypeCombo, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2 * 2, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTailPercentileLabel, gridBagConstraints, 2, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n3, n2);
        Dimension dimension3 = (Dimension)this.mTailPercenField.getPreferredSize().clone();
        dimension3.width = 60;
        this.mTailPercenField.setPreferredSize(dimension3);
        this.mTailPercenField.setMinimumSize(dimension3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTailPercenField, gridBagConstraints, 3, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 7, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTailFreqLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        dimension2 = this.mTailFreq.getPreferredSize();
        int n5 = this.mTailTypeCombo.getPreferredSize().width;
        this.mTailFreq.setMinimumSize(new Dimension(n5, dimension2.height));
        this.mTailFreq.setPreferredSize(new Dimension(n5, dimension2.height));
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTailFreq, gridBagConstraints, 1, 6, 1, 1, n, insets);
        insets.set(n3, n2 * 2, n3, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTailValueLabel, gridBagConstraints, 2, 6, 1, 1, n, insets);
        insets.set(n3, 2, n3, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mTailValueField.setPreferredSize(dimension3);
        this.mTailValueField.setMinimumSize(dimension3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTailValueField, gridBagConstraints, 3, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 2, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mTailSideLabel, gridBagConstraints, 4, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n4, 2, n4, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTailSideCombo, gridBagConstraints, 5, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 3, n3, 2);
        DialogUtil.addUsingGBL(jPanel, this.mThresholdButton, gridBagConstraints, 0, 7, 6, 1, n, insets);
        insets.set(n4, n2 * 7, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreshTypeLabel, gridBagConstraints, 0, 8, 1, 1, n, insets);
        insets.set(n3, n2, n3, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreshTypeCombo, gridBagConstraints, 1, 8, 1, 1, n, insets);
        insets.set(n3, n2 * 2, n3, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreshPercenLabel, gridBagConstraints, 2, 8, 1, 1, n, insets);
        insets.set(n3, n2, n3, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.mThreshPercenField.setPreferredSize(dimension3);
        this.mThreshPercenField.setMinimumSize(dimension3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreshPercenField, gridBagConstraints, 3, 8, 1, 1, n, insets);
        insets.set(n3, n2 * 7, n3, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreshConfLabel, gridBagConstraints, 0, 9, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2, n3, 2);
        this.mThreshConfField.setPreferredSize(dimension3);
        this.mThreshConfField.setMinimumSize(dimension3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreshConfField, gridBagConstraints, 1, 9, 1, 1, n, insets);
        insets.set(n3, n2 * 2, n3, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreshValuefLabel, gridBagConstraints, 2, 9, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2, n3, 2);
        this.mThreshValueField.setPreferredSize(dimension3);
        this.mThreshValueField.setMinimumSize(dimension3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreshValueField, gridBagConstraints, 3, 9, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel(this.mParent.getResString("IDS_MC_OPTION_FITTING_TITLE"));
        JPanel jPanel4 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel4, (JComponent)((Object)this.mNumCasesToUseLabel), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        JPanel jPanel5 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 0, n3, 2);
        DialogUtil.addUsingGBL(jPanel5, this.mNLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n3, n2);
        this.mLimitNCaseField.setPreferredSize(dimension3);
        this.mLimitNCaseField.setMinimumSize(dimension3);
        DialogUtil.addUsingGBL(jPanel5, (JComponent)this.mLimitNCaseField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n2 * 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel4, this.mAllCases, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n2 * 2, 0, n2);
        DialogUtil.addUsingGBL(jPanel4, this.mNCasesButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n2 * 6, 0, n2);
        DialogUtil.addUsingGBL(jPanel4, jPanel5, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JPanel jPanel6 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 0, 2, n2);
        DialogUtil.addUsingGBL(jPanel6, this.mFitForScaleFieldsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n6 = 1;
        if (this.mFitForScaleFieldsLabel.getText().length() > 44) {
            this.mFitForScaleFieldsLabel.setRows(2);
            n6 = 2;
        }
        this.mFitForScaleFieldsLabel.setMinimumSize(this.mFitForScaleFieldsLabel.getPreferredSize());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel6, this.mAndersonDarlingButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2 * 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel6, this.mScaleKSButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JPanel jPanel7 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 0, n3, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mCatMissingLabel, gridBagConstraints, 0, 0, 1, 2, n, insets);
        if (this.mCatMissingLabel.getText().length() > 80) {
            this.mCatMissingLabel.setRows(n6 + 1);
        }
        Dimension dimension4 = this.mCatMissingLabel.getPreferredSize();
        this.mCatMissingLabel.setMinimumSize(dimension4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mMisExcludeButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2 * 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel7, this.mMisIncludeButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel4, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2, n3, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel6, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2, n3, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel7, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel8 = PanelFactory.getEmptyPanel(this.getResString("IDS_MC_OPTION_EMPIRICAL_PANLE_TITLE"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 0, n3, 2);
        DialogUtil.addUsingGBL(jPanel8, this.mBinSpinnderLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n3, n2);
        dimension2 = this.mBinNumber.getPreferredSize();
        this.mBinNumber.setMinimumSize(new Dimension(80, dimension2.height));
        this.mBinNumber.setPreferredSize(new Dimension(80, dimension2.height));
        DialogUtil.addUsingGBL(jPanel8, (JComponent)this.mBinNumber, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel9 = PanelFactory.getEmptyPanel(this.getResString("IDS_MC_OPTION_RANDOM_SEED_PANLE_TITLE"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 0, n3, n2);
        DialogUtil.addUsingGBL(jPanel9, this.mSeedCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 3, n3, n2);
        DialogUtil.addUsingGBL(jPanel9, this.mGenerateButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel10 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel10, this.mSeedLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        dimension3.width = 40;
        this.mSeedField.setPreferredSize(dimension3);
        this.mSeedField.setMinimumSize(dimension3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel10, (JComponent)this.mSeedField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, 2, 2, n2);
        DialogUtil.addUsingGBL(jPanel9, jPanel10, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        DialogUtil.addUsingGBL(this.mOptions, jPanel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        DialogUtil.addUsingGBL(this.mOptions, jPanel3, gridBagConstraints, 0, 1, 1, 2, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        DialogUtil.addUsingGBL(this.mOptions, jPanel8, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, 2, n2, n2);
        DialogUtil.addUsingGBL(this.mOptions, jPanel9, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel11 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(this.mOptions, jPanel11, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.setOptionFocusTraversalPolicy();
    }

    private void setupOutputSidebarPanel() {
        this.mOutput = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = 3;
        int n3 = 1;
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MC_OUTPUT_TORNADO_CHART_TITLE"));
        Insets insets = new Insets(0, 0, n3, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTornadoCharts, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 7, n3, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mContrToVariCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSensitivityToChangeCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
        insets.set(n3, n2 * 7, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mInputStdDevLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        int n4 = this.mInputStdDevField.getPreferredSize().height;
        this.mInputStdDevField.setMinimumSize(new Dimension(80, 25));
        this.mInputStdDevField.setPreferredSize(new Dimension(80, 25));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInputStdDevField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, n2, n2);
        DialogUtil.addUsingGBL(this.mOutput, jPanel, gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mOutput, this.mBoxPlotCheck, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n2 * 7, n3, n2);
        DialogUtil.addUsingGBL(this.mOutput, this.mOverlayResultCheck, gridBagConstraints, 0, 2, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 2, n2, n2);
        DialogUtil.addUsingGBL(this.mOutput, this.mScatterplots, gridBagConstraints, 0, 3, 3, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mParent.getResString("IDS_MC_OUTPUT_PERCENTILE_VALUE_PANEL_TITLE"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2, n3, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mCreatTableCheck, gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 5, n3, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mQuantitleCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mIntervaCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
        insets.set(2, n2 * 10, n3, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mIntervalLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, n2, n3, n2);
        Dimension dimension = this.mIntervalValue.getPreferredSize();
        this.mIntervalValue.setMinimumSize(new Dimension(80, dimension.height));
        this.mIntervalValue.setPreferredSize(new Dimension(80, dimension.height));
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mIntervalValue, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mCustPercenCheck, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mCustPercentLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mCustPercentList, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(MCSimulationTab.sMinListSize.width, MCSimulationTab.sMinListSize.height));
        jScrollPane.setPreferredSize(new Dimension(MCSimulationTab.sMinListSize.width, MCSimulationTab.sMinListSize.height));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n2 * 3, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n2, n2 * 5);
        DialogUtil.addUsingGBL(this.mOutput, jPanel2, gridBagConstraints, 0, 4, 2, 2, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        DialogUtil.addUsingGBL(this.mOutput, this.mDescrCheck, gridBagConstraints, 0, 6, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2 * 6, n3, n2);
        DialogUtil.addUsingGBL(this.mOutput, this.mDescConfLabel, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        this.mmDescConfField.setMinimumSize(new Dimension(80, n4));
        this.mmDescConfField.setPreferredSize(new Dimension(80, n4));
        DialogUtil.addUsingGBL(this.mOutput, (JComponent)this.mmDescConfField, gridBagConstraints, 1, 7, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, 2, n3, n2);
        DialogUtil.addUsingGBL(this.mOutput, this.mCrosstabCheck, gridBagConstraints, 0, 8, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2, n3, n2 * 6);
        DialogUtil.addUsingGBL(this.mOutput, this.mSimInputListLabel, gridBagConstraints, 0, 9, 2, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mInputList, 20, 31);
        double d = jPanel2.getPreferredSize().width;
        int n5 = (int)(d * 0.4);
        jScrollPane2.setMinimumSize(new Dimension(n5, 80));
        jScrollPane2.setPreferredSize(new Dimension(n5, 80));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 2, n3, n2 * 5);
        DialogUtil.addUsingGBL(this.mOutput, jScrollPane2, gridBagConstraints, 0, 10, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n3, n2, n3, n2);
        DialogUtil.addUsingGBL(this.mOutput, this.mLimitRangeTableLabel, gridBagConstraints, 2, 4, 1, 1, n, insets);
        JScrollPane jScrollPane3 = new JScrollPane(this.mLimitRangeTable, 20, 31);
        n5 = (int)(d - (double)n5);
        jScrollPane3.setMinimumSize(new Dimension(n5, 80));
        jScrollPane3.setPreferredSize(new Dimension(n5, 80));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(0, 0, 4, n2);
        DialogUtil.addUsingGBL(this.mOutput, jScrollPane3, gridBagConstraints, 2, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mOutput, this.mFormatTableLabel, gridBagConstraints, 2, 6, 1, 1, n, insets);
        JScrollPane jScrollPane4 = new JScrollPane(this.mFormatTable, 20, 31);
        n5 = (int)(d - (double)n5);
        jScrollPane4.setMinimumSize(new Dimension(n5, 100));
        jScrollPane4.setPreferredSize(new Dimension(n5, 100));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(0, 0, 2, n2);
        DialogUtil.addUsingGBL(this.mOutput, jScrollPane4, gridBagConstraints, 2, 7, 1, 4, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, 2);
        DialogUtil.addUsingGBL(this.mOutput, jPanel3, gridBagConstraints, 0, 11, 2, 1, n, insets);
        this.setOutputFocusTraversalPolicy();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return null;
    }

    private void setupSaveSidebarPanel() {
        this.mSave = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, 0, 2, n2);
        DialogUtil.addUsingGBL(this.mSave, this.mSavePlanFileCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2 * 5, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(this.mSave, PanelFactory.getBasicPanel(new JComponent[]{this.mSavePlanFileLabel, this.mPlanNameField, this.mBrowsePlanButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, 2, n2);
        DialogUtil.addUsingGBL(this.mSave, this.mSaveSimToFileCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(this.mSave, this.mSaveFileSav, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(this.mSave, PanelFactory.getBasicPanel(new JComponent[]{this.mSavFileLabel, this.mSavNameField, this.mBrowseSavButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 2, n2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(this.mSave, this.mSaveToDataset, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JPanel jPanel = PanelFactory.getBasicPanel(new JComponent[]{this.mDatasetFieldLabel, this.mDatasetNameField}, PanelFactory.PanelType.xaxis, "");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(this.mSave, jPanel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(this.mSave, this.mSaveFileExcel, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2 * 5, n2, 2);
        DialogUtil.addUsingGBL(this.mSave, PanelFactory.getBasicPanel(new JComponent[]{this.mExcelFileLabel, this.mExcelNameField, this.mBrowseExcelButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 8, 1, 1, n, insets);
        this.setSaveFocusTraversalPolicy();
    }

    private void setupDensityFunctionsPanel() {
        this.mDFunctions = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = 3;
        int n3 = 1;
        Insets insets = new Insets(0, 0, n3, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mDFunctions, this.mPDF, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n3, 0, n3, n2);
        DialogUtil.addUsingGBL(this.mDFunctions, this.mCDF, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel = this.setupDFSliderPanel();
        gridBagConstraints.fill = 1;
        insets.set(n3, n2, n3, n2);
        DialogUtil.addUsingGBL(this.mDFunctions, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mDFRefPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MC_DFUNCTIONS_REF_PANEL_TITLE"));
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mRefMeanCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mRefMedianCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mRefSigmaCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 7, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mRefSigmaNumberLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mSigmaValue, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mRefPercentileCheck, gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 7, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mBottomLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mBottomValue, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 7, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mTopLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mTopValue, gridBagConstraints, 1, 6, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(jPanel3, this.mRefCustomCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 8, n3, 2);
        DialogUtil.addUsingGBL(jPanel3, this.mCustomLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mCustomValueTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(200, 100));
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 8, n3, 2);
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, n2, n3, n2 * 5);
        DialogUtil.addUsingGBL(this.mDFRefPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, n2 * 10, n3, 2);
        DialogUtil.addUsingGBL(this.mDFRefPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(this.mDFunctions, this.mDFRefPanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 4, n3, 2);
        DialogUtil.addUsingGBL(this.mDFunctions, this.mOverlayCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mPDFPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MC_DFUNCTIONS_CAT_PANEL_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(this.mPDFPanel, (JComponent)((Object)this.mCatGroupLabel), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 6, n3, 2);
        DialogUtil.addUsingGBL(this.mPDFPanel, this.mPredCatCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 6, n3, 2);
        DialogUtil.addUsingGBL(this.mPDFPanel, this.mPredProbCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 6, n3, 2);
        DialogUtil.addUsingGBL(this.mPDFPanel, this.mBothPredProb, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(this.mPDFPanel, (JComponent)((Object)this.mGroupingLabel), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 6, n3, 2);
        DialogUtil.addUsingGBL(this.mPDFPanel, this.mCatGroupButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, n2 * 6, n3, 2);
        DialogUtil.addUsingGBL(this.mPDFPanel, this.mIterGroupButton, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(this.mDFunctions, this.mPDFPanel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JPanel jPanel4 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, n2, n3, 2);
        DialogUtil.addUsingGBL(this.mDFunctions, jPanel4, gridBagConstraints, 0, 6, 1, 1, n, insets);
        this.setDFunctionFocusTraversalPolicy();
    }

    private JPanel setupDFSliderPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mParent.getResString("IDS_MC_DFUNCTIONS_SLIDER_PANEL_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = 3;
        int n3 = 1;
        Insets insets = new Insets(n3, n2, n3, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSliderSetCheck, gridBagConstraints, 0, 0, 4, 1, n, insets);
        insets.set(n3, n2 * 7, n3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSliderLowLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n3, n2, n3, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSliderLowValue, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n3, n2 * 2, n3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSliderUppLabel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        insets.set(n3, n2, n3, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSliderUppValue, gridBagConstraints, 3, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n2, n3, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mSliderNegInfCheck, gridBagConstraints, 1, 2, 2, 1, n, insets);
        insets.set(n3, n2, n3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSliderPosInfCheck, gridBagConstraints, 3, 2, 2, 1, n, insets);
        return jPanel;
    }

    private void updateSimulatedField(String string, boolean bl) {
        SimulatedFieldTableModel simulatedFieldTableModel = (SimulatedFieldTableModel)this.mSimulatedFieldTable.getModel();
        for (int i = 0; i < this.mSimulatedFieldTable.getRowCount(); ++i) {
            SimulatedField simulatedField = simulatedFieldTableModel.getSimulatedField(i);
            if (!simulatedField.getName().equals(string)) continue;
            simulatedField.setExcludeFromOutput(!bl);
        }
    }

    private void getTargetFormatIndex(String string, int[] nArray, int[] nArray2) {
        nArray[0] = 0;
        nArray2[0] = 2;
        if (this.mTargetFromPlan != null) {
            for (int i = 0; i < this.mTargetFromPlan.size(); ++i) {
                SimulationPlanHandler.TargetField targetField = this.mTargetFromPlan.get(i);
                if (!targetField.getName().equals(string)) continue;
                nArray[0] = targetField.getFormatIndex();
                nArray2[0] = targetField.getNumDecimals();
                return;
            }
        }
    }

    protected class InputCheckboxList
    extends JList {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public InputCheckboxList() {
            this.setCellRenderer(new CellRenderer());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = InputCheckboxList.this.locationToIndex(mouseEvent.getPoint());
                    if (n != -1) {
                        JCheckBox jCheckBox;
                        jCheckBox.setSelected(!(jCheckBox = (JCheckBox)InputCheckboxList.this.getModel().getElementAt(n)).isSelected());
                        MCSimulationTab.this.updateSimulatedField(jCheckBox.getText(), jCheckBox.isSelected());
                        InputCheckboxList.this.repaint();
                    }
                }
            });
            this.setSelectionMode(0);
        }

        public void addCheckbox(JCheckBox jCheckBox) {
            ListModel listModel = this.getModel();
            JCheckBox[] jCheckBoxArray = new JCheckBox[listModel.getSize() + 1];
            for (int i = 0; i < listModel.getSize(); ++i) {
                jCheckBoxArray[i] = (JCheckBox)listModel.getElementAt(i);
            }
            jCheckBoxArray[jCheckBoxArray.length - 1] = jCheckBox;
            this.setListData(jCheckBoxArray);
        }

        protected class CellRenderer
        implements ListCellRenderer {
            protected CellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JCheckBox jCheckBox = (JCheckBox)object;
                if (ComponentState.isBtdRtlOrLtr() && jCheckBox != null && jCheckBox.getText() != null && jCheckBox.getText().length() > 0) {
                    jCheckBox.setText(ComponentState.prepareStringForBidiRendering((String)jCheckBox.getText()));
                }
                if (bl) {
                    if (jList.hasFocus()) {
                        InputCheckboxList.this.setBackground(jList.getSelectionBackground());
                        InputCheckboxList.this.setForeground(jList.getSelectionForeground());
                    } else {
                        InputCheckboxList.this.setBackground(Color.lightGray);
                        InputCheckboxList.this.setForeground(Color.black);
                    }
                } else {
                    InputCheckboxList.this.setBackground(jList.getBackground());
                    InputCheckboxList.this.setForeground(jList.getForeground());
                }
                jCheckBox.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
                jCheckBox.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                jCheckBox.setEnabled(InputCheckboxList.this.isEnabled());
                jCheckBox.setFont(InputCheckboxList.this.getFont());
                jCheckBox.setFocusPainted(true);
                jCheckBox.setBorderPainted(true);
                jCheckBox.setBorder(bl ? UIManager.getBorder("List.focusCellHighlightBorder") : InputCheckboxList.this.noFocusBorder);
                jList.getAccessibleContext().setAccessibleDescription(Boolean.toString(jCheckBox.isSelected()));
                return jCheckBox;
            }
        }
    }

    class CorrelationTableModel
    extends DefaultTableModel {
        private Vector<String> mColNames = new Vector();
        private TreeMap<String, Integer> mSortedVarNameMap = null;
        private ArrayList<CorrelationEntry> mCorrEntryList = null;

        @Override
        public int getRowCount() {
            if (this.mColNames == null) {
                return 0;
            }
            return this.mColNames.size() - 1;
        }

        @Override
        public int getColumnCount() {
            return this.mColNames.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n >= 0 && n < this.mColNames.size()) {
                return this.mColNames.get(n);
            }
            return "";
        }

        public Vector<String> getColumnNames() {
            return this.mColNames;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 > 0) {
                String string = this.mColNames.get(n + 1);
                String string2 = this.mColNames.get(n2);
                this.setValue(string, string2, object);
                this.setValue(string2, string, object);
                this.fireTableDataChanged();
                MCSimulationTab.this.mCorrelationModified = true;
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n2 < 0 || this.mColNames == null || this.mColNames.size() == 0 || n >= this.mColNames.size() - 1 || n2 >= this.mColNames.size()) {
                return null;
            }
            if (n2 == 0) {
                return this.mColNames.get(n + 1);
            }
            String string = this.mColNames.get(n + 1);
            String string2 = this.mColNames.get(n2);
            return this.findValue(string, string2);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            return Double.class;
        }

        public void setCorrelationEntries(ArrayList<CorrelationEntry> arrayList) {
            this.mCorrEntryList = arrayList;
            this.mSortedVarNameMap = new TreeMap();
            int n = 0;
            for (CorrelationEntry correlationEntry : arrayList) {
                this.mSortedVarNameMap.put(correlationEntry.getColFieldName(), n++);
            }
            this.updateTable();
            this.fireTableDataChanged();
        }

        public void removeOneRow(String string) {
            if (this.mSortedVarNameMap != null && this.mSortedVarNameMap.size() > 0) {
                int n = this.mColNames.indexOf(string);
                if (n < 0) {
                    return;
                }
                int n2 = this.mColNames.indexOf(string) - 1;
                this.mSortedVarNameMap.remove(string);
                this.mColNames.remove(string);
                if (this.mSortedVarNameMap.size() > 1) {
                    ArrayList<CorrelationEntry> arrayList = new ArrayList<CorrelationEntry>();
                    for (int i = 0; i < this.mCorrEntryList.size(); ++i) {
                        CorrelationEntry correlationEntry = this.mCorrEntryList.get(i);
                        if (correlationEntry.getColFieldName().equals(string) || correlationEntry.getRowFiledName().equals(string)) continue;
                        arrayList.add(correlationEntry);
                    }
                    this.mCorrEntryList.clear();
                    this.mCorrEntryList.addAll(arrayList);
                    this.fireTableRowsDeleted(n2, n2);
                    this.fireTableStructureChanged();
                } else {
                    this.removeAll();
                }
            }
        }

        public void addOneRow(String string) {
            if (this.mSortedVarNameMap == null) {
                this.mSortedVarNameMap = new TreeMap();
                this.mSortedVarNameMap.put(string, this.mSortedVarNameMap.size());
                this.mColNames.add(0, "");
                this.mColNames.add(1, string);
            } else if (this.mColNames.indexOf(string) < 0) {
                this.mSortedVarNameMap.put(string, this.mSortedVarNameMap.size());
                this.mColNames.clear();
                this.updateTable();
            }
            this.fireTableDataChanged();
        }

        public void resetAll() {
            for (int i = 0; i < this.mCorrEntryList.size(); ++i) {
                CorrelationEntry correlationEntry = this.mCorrEntryList.get(i);
                if (correlationEntry.getColFieldName().equals(correlationEntry.getRowFiledName())) continue;
                correlationEntry.setValue(0.0);
                this.mCorrEntryList.set(i, correlationEntry);
            }
            this.fireTableDataChanged();
        }

        public void removeAll() {
            this.mColNames.clear();
            if (this.mCorrEntryList != null) {
                this.mCorrEntryList.clear();
            }
            if (this.mSortedVarNameMap != null) {
                this.mSortedVarNameMap.clear();
            }
            this.fireTableDataChanged();
        }

        public boolean hasRow(String string) {
            if (this.mColNames == null || this.mColNames.size() == 0) {
                return false;
            }
            return this.mColNames.contains(string);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 && n2 - 1 < n;
        }

        private Double findValue(String string, String string2) {
            for (int i = 0; i < this.mCorrEntryList.size(); ++i) {
                CorrelationEntry correlationEntry = this.mCorrEntryList.get(i);
                if (!correlationEntry.getColFieldName().equals(string2) || !correlationEntry.getRowFiledName().equals(string)) continue;
                return new Double(correlationEntry.getValue());
            }
            return null;
        }

        private void setValue(String string, String string2, Object object) {
            try {
                for (int i = 0; i < this.mCorrEntryList.size(); ++i) {
                    CorrelationEntry correlationEntry = this.mCorrEntryList.get(i);
                    if (!correlationEntry.getColFieldName().equals(string2) || !correlationEntry.getRowFiledName().equals(string)) continue;
                    correlationEntry.setValue(Double.parseDouble(object.toString()));
                    this.mCorrEntryList.set(i, correlationEntry);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void updateTable() {
            this.mColNames.clear();
            int n = 0;
            this.mColNames.add(n++, "");
            Iterator<String> iterator = this.mSortedVarNameMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.mColNames.add(n++, iterator.next());
            }
            Object[][] objectArray = new Object[this.mColNames.size() - 1][];
            for (int i = 0; i < this.mColNames.size() - 1; ++i) {
                objectArray[i] = new Object[this.mColNames.size()];
                objectArray[i][0] = this.mColNames.get(i + 1);
                objectArray[i][i + 1] = new Double(1.0);
            }
            Object[] objectArray2 = new String[this.mColNames.size()];
            this.mColNames.copyInto(objectArray2);
            this.setDataVector(objectArray, objectArray2);
            if (this.mCorrEntryList == null) {
                this.mCorrEntryList = new ArrayList();
            }
            for (int i = 0; i < this.mSortedVarNameMap.size(); ++i) {
                for (int j = 1; j < this.mColNames.size(); ++j) {
                    String string;
                    String string2 = this.mColNames.get(i + 1);
                    Double d = this.findValue(string2, string = this.mColNames.get(j));
                    if (d != null) continue;
                    double d2 = i == j - 1 ? 1.0 : 0.0;
                    this.mCorrEntryList.add(new CorrelationEntry(string2, string, d2));
                }
            }
        }
    }

    class FloatFieldEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private FloatTextField mField;

        FloatFieldEditor(FloatTextField floatTextField) {
            super((JTextField)floatTextField);
            this.mField = floatTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 > 0 && object != null) {
                this.mField.setText(object.toString());
            }
            return this.mField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mField.getText();
        }
    }

    class CorrMatrixCellRender
    extends DefaultTableCellRenderer {
        NumberFormat mForamt = NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());

        public CorrMatrixCellRender() {
            this.setHorizontalAlignment(4);
            this.mForamt.setGroupingUsed(false);
            this.mForamt.setMaximumFractionDigits(3);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0) {
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(Color.black);
                jLabel.setOpaque(true);
            } else if (!jTable.getModel().isCellEditable(n, n2)) {
                this.setBackground(Color.gray);
                this.setForeground(jTable.getForeground());
                this.setOpaque(true);
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
                this.setOpaque(false);
            }
            if (object != null && n2 != 0) {
                String string = object.toString();
                try {
                    double d = Double.parseDouble(string);
                    string = d != -1.7976931348623157E308 ? this.mForamt.format(d) : ".";
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.setText(string);
            }
            return this;
        }
    }

    public class DisplayDecimalRenderer
    implements TableCellRenderer {
        SpinnerNumberModel model;
        JSpinner spinner;

        public DisplayDecimalRenderer(int n, int n2, int n3, int n4) {
            this.model = new SpinnerNumberModel(n, n2, n3, n4);
            this.spinner = new JSpinner(this.model);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && object.toString().length() > 0) {
                this.spinner.setValue(Integer.parseInt(object.toString()));
            }
            return this.spinner;
        }
    }

    class DisplayDecimalEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private IntTextField mNumField;
        private NumberSpinner mDecimalSpinner;

        DisplayDecimalEditor() {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(2, 0, 5, 1);
            this.mNumField = new IntTextField(0, 5, true);
            this.mNumField.setText("2");
            this.mNumField.setHorizontalAlignment(4);
            this.mDecimalSpinner = new NumberSpinner(this.mNumField, spinnerNumberModel);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mNumField.setText(object.toString());
            this.mDecimalSpinner.setValue((Object)Integer.parseInt(object.toString()));
            return this.mDecimalSpinner;
        }

        @Override
        public Object getCellEditorValue() {
            return (Integer)this.mDecimalSpinner.getValue();
        }

        public IntTextField getTextField() {
            return this.mNumField;
        }
    }

    public class FieldFormatRenderer
    extends JComboBox
    implements TableCellRenderer {
        private Border noFocusBorder;

        public FieldFormatRenderer(String[] stringArray) {
            super(stringArray);
            this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            this.setSelectedIndex(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.getModel().setSelectedItem(object);
            if (bl || bl2) {
                this.setBorder(UIManager.getBorder("Table.focusSelectedCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            if (bl2 && n2 == 1 && this.getModel().getSelectedItem() != null) {
                this.getAccessibleContext().setAccessibleDescription(this.getModel().getSelectedItem().toString());
            }
            return this;
        }
    }

    class FieldFormatEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mCombo = new JComboBox();

        FieldFormatEditor(String[] stringArray) {
            this.mCombo = new JComboBox<String>(stringArray);
            this.mCombo.setSelectedIndex(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = "";
            if (object.toString().length() == 0) {
                object = null;
            } else {
                string = object.toString();
            }
            this.mCombo.setSelectedItem(object);
            return this.mCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCombo.getSelectedItem();
        }

        public JComboBox getComboBox() {
            return this.mCombo;
        }
    }

    class FloatFieldRender
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        FloatFieldRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && (n2 == 2 || n2 == 3)) {
                Object object2;
                boolean bl3 = jTable.isCellEditable(n, n2);
                this.setBackground(jTable.getTableHeader().getBackground());
                if (bl3) {
                    this.setForeground(jTable.getForeground());
                    this.setOpaque(false);
                } else {
                    this.setForeground(Color.gray);
                    this.setOpaque(true);
                }
                if (bl2) {
                    object2 = null;
                    if (bl) {
                        object2 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                    }
                    if (object2 == null) {
                        object2 = UIManager.getBorder("Table.focusCellHighlightBorder");
                    }
                    this.setBorder((Border)object2);
                } else {
                    this.setBorder(noFocusBorder);
                }
                this.setEnabled(bl3);
                object2 = object.toString();
                try {
                    double d = Double.parseDouble((String)object2);
                    if (((String)object2).length() > 0) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
                        numberFormat.setGroupingUsed(false);
                        numberFormat.setMaximumFractionDigits(2);
                        this.setText(numberFormat.format(d));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setText((String)object2);
                }
            }
            return this;
        }
    }
}

