/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.MC.MCModelTab;
import com.spss.java_client.ui.dialogs.MC.MCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.ModelPMMLFileHandler;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JFrame;

public class MCSimulationModelDlg
extends MonteCarloSimulationDlg {
    public MCSimulationModelDlg(JFrame jFrame) {
        super(jFrame);
    }

    @Override
    public String getIActionKey() {
        return "utilities_monte_carlo_simulation_model_dialog";
    }

    @Override
    public void loadDialogState() {
        SimulationPlanHandler simulationPlanHandler;
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_simulation_gating_dialog", dialogDataModel);
        String string = dialogDataModel.getString("SimulationPlanPath");
        if (string != null && string.length() > 0) {
            this.mPlanFilePath.setText(string);
            this.mSimulationTab.setFromSimPlan(true);
        }
        if ((simulationPlanHandler = (SimulationPlanHandler)dialogDataModel.getObject("SimulationPlanHandler")) != null) {
            String string2 = PrefsMgr.getPrefsMgr().getTempPath();
            ArrayList<SimulationPlanHandler.ModelFile> arrayList = simulationPlanHandler.getModelFiles();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.mModelTab.runPMMLModelHandler(string2, arrayList.get(i).getFileName());
            }
            this.reloadSimulationTab(simulationPlanHandler.getSimulatedPredictors(), simulationPlanHandler.getTargets(), simulationPlanHandler.getCriterias(), simulationPlanHandler.getPlanTimeStamp());
            this.mSimulationTab.loadCorrelationTable(simulationPlanHandler.getCorrelationMatrix(), simulationPlanHandler.isCrossTabUsed(), simulationPlanHandler.getCrossFactorNames());
        } else {
            ModelPMMLFileHandler modelPMMLFileHandler = (ModelPMMLFileHandler)dialogDataModel.getObject("PMMLModelHandler");
            if (modelPMMLFileHandler != null) {
                ArrayList<String> arrayList = modelPMMLFileHandler.getInputFieldNames();
                String string3 = modelPMMLFileHandler.createFieldNamesText(arrayList);
                ArrayList<String> arrayList2 = modelPMMLFileHandler.getTargetFieldNames();
                String string4 = modelPMMLFileHandler.createFieldNamesText(arrayList2);
                String string5 = modelPMMLFileHandler.getModelTypeName();
                this.mModelTab.setTargetAndInputsFromModelPMML(modelPMMLFileHandler.getTargets(), modelPMMLFileHandler.getSimulatedPredictors());
                this.mModelTab.updateModelInfo(string3, string5, dialogDataModel.getString("SimulationModelPMMLPath"), string4);
                this.reloadSimulationTab(modelPMMLFileHandler.getSimulatedPredictors(), modelPMMLFileHandler.getTargets());
                this.reloadCorrelation(modelPMMLFileHandler.getCorrelationMatrix());
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        if (this.mSimHandler == null) {
            this.mSimHandler = new SimulationPlanHandler();
        }
        this.mModelTab = new MCModelTab(this, this.mSimHandler, MCModelTab.TableType.MODEL);
        this.addTab(this.getResString("IDS_MC_MODEL_TAB_TITLE"), this.mModelTab);
        this.mSimulationTab = new MCSimulationTab(this, this.mSimHandler);
        this.addTab(this.getResString("IDS_MC_SIMULATION_TAB_TITLE"), this.mSimulationTab);
        this.setSizeConstraints(new Dimension(1000, 750));
        this.pack();
    }
}

