/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.charteditor.util.DrawUtil;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.MC.BaseMCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.DistributionParametersPanel;
import com.spss.java_client.ui.dialogs.MC.MCSimpleSimulationModelDlg;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SensitivityAnalysisSub;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.res.MCResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MCSimpleSimulationSimulationTab
extends BaseMCSimulationTab
implements ItemListener,
ListDataListener,
ActionListener,
SimulationHelper.ParametersPanelCallback {
    private static final String SRC_VAR_LIST = "IDS_SIMPLE_SIMULATION_SRC_VARLIST";
    private SimulatedFieldsList mSimulatedFieldsList;
    private JScrollPane mSimulatedFieldsScrollPane;
    private JCheckBox mMissingHandleCheck;
    private JButton mSensitivityButton;
    private JButton mFitAllButton;
    private JLabel mSimulatedInputsLabel;
    private JLabel mSimFieldNameLabel;
    private JLabel mFitStateNameAndImageLabel;
    private SpssButtonGroup mFitToFieldButtonGroup;
    private JRadioButton mFitToFieldRadioButton;
    private JComboBox mFieldComboBox;
    private JLabel mFieldLabel;
    private JRadioButton mManuallySetParamsRadioButton;
    SimulationHelper.HelpPanel mHelpPanel;
    private Map<String, BufferedImage> mImageMap = new HashMap<String, BufferedImage>();
    private Hashtable<String, BaseMCSimulationTab.ScannedVar> mScannedVarMap = new Hashtable();
    DistributionParametersPanel mDistParamPanel;
    SimulationHelper.PreviewCanvas mCanvas;
    public static final Dimension mPreviewImageSize = new Dimension(175, 55);
    public static final Dimension mFixedCellSize = new Dimension((int)mPreviewImageSize.getWidth() + 50, (int)mPreviewImageSize.getHeight() + 25);
    public static final Dimension mScrollPanePrefferedSize = new Dimension(MCSimpleSimulationSimulationTab.mFixedCellSize.width + 100, MCSimpleSimulationSimulationTab.mFixedCellSize.height * 4);
    Dimension mDistPanelPrefferedSize = new Dimension(250, 140);
    Dimension mNamePanelPrefferedSize = new Dimension(150, 100);

    public MCSimpleSimulationSimulationTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog);
        this.initialize();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSimulatedFieldsList;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        ((MCSimpleSimulationModelDlg)this.mParent).enableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        ((MCSimpleSimulationModelDlg)this.mParent).enableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        ((MCSimpleSimulationModelDlg)this.mParent).enableOkPaste();
    }

    private void clearControls() {
        this.mSimFieldNameLabel.setText("");
        this.mFitStateNameAndImageLabel.setText("");
        this.mFitStateNameAndImageLabel.setIcon(null);
        this.mSensitivityButton.setEnabled(false);
        this.mFitAllButton.setEnabled(false);
        this.mDistParamPanel.updatePanel(null, -1, -1, false);
        this.mFitToFieldRadioButton.setEnabled(false);
        this.enableFitToFieldControls(false);
        this.mHelpPanel.setHelpForDistributionType(null);
    }

    private void enableFitAllControl() {
        boolean bl = false;
        int n = this.getNumSimulatedFields();
        for (int i = 0; i < n; ++i) {
            SimulatedField simulatedField = this.getSimulatedFieldAt(i);
            if (!this.canFitToField(simulatedField)) continue;
            bl = true;
            break;
        }
        this.mFitAllButton.setEnabled(bl);
    }

    private void enableSensitivityButton() {
        SimulatedField simulatedField = this.getSelectedSimulatedField();
        boolean bl = true;
        if (simulatedField != null) {
            SimulationHelper.DistributionType distributionType = simulatedField.getDistributionType();
            if (distributionType == SimulationHelper.DistributionType.EMPIRICAL) {
                bl = false;
            } else {
                ArrayList<Pair<String, String>> arrayList = simulatedField.getParametersFor(distributionType);
                if (arrayList == null || arrayList.size() == 0) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        this.mSensitivityButton.setEnabled(bl);
    }

    private void enableFitToFieldControls(boolean bl) {
        this.enableFitToFieldControls(this.getSelectedSimulatedField(), bl);
    }

    private void enableFitToFieldControls(SimulatedField simulatedField, boolean bl) {
        this.mFieldLabel.setEnabled(bl);
        this.mFieldComboBox.setEnabled(bl);
        this.mFitToFieldRadioButton.setEnabled(simulatedField != null && !simulatedField.isLocked());
    }

    private void enableManuallySetParamsLabel(SimulatedField simulatedField) {
        this.mManuallySetParamsRadioButton.setEnabled(simulatedField != null && !simulatedField.isLocked());
    }

    private SimulatedField getSelectedSimulatedField() {
        SimulatedField simulatedField = null;
        if (this.mSimulatedFieldsList.getModel().getSize() > 0) {
            simulatedField = (SimulatedField)((Object)this.mSimulatedFieldsList.getSelectedValue());
        }
        return simulatedField;
    }

    protected boolean validateTabForOKPaste() {
        boolean bl = SimulationHelper.validateFields(this.getSimulatedFieldsList(), false);
        return bl;
    }

    protected boolean canEnableOkPaste() {
        boolean bl = SimulationHelper.validateFields(this.getSimulatedFieldsList(), false);
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_simple_simulation";
    }

    public VarListModel getSrcListModel() {
        return this.mSimulatedFieldsList.getModel();
    }

    public String getTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        return stringBuffer.toString();
    }

    private String getVarListSyntax(String string, TargetVariableList targetVariableList) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (targetVariableList.getModel().getSize() != 0) {
            for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
                ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
                if (iSpssVariable == null) continue;
                stringBuffer2.append(iSpssVariable.getName());
                stringBuffer2.append(" ");
            }
        }
        stringBuffer2.toString().trim();
        stringBuffer.append(stringBuffer2.toString());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.reloadSimulation(null, false);
    }

    public boolean setEnabledOkPaste() {
        boolean bl = false;
        ((MCSimpleSimulationModelDlg)this.mParent).enableOkPaste(bl);
        return bl;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mFitAllButton) {
            this.runFitSelectedSub(-1);
        } else if (object == this.mSensitivityButton) {
            int n = SimulationHelper.getIndexOfFieldWithIterations(this.getSimulatedFieldsList());
            int n2 = this.mSimulatedFieldsList.getSelectedIndex();
            SimulatedField simulatedField = this.getSelectedSimulatedField();
            if (n >= 0 && n != n2) {
                SimulatedField simulatedField2 = this.getSimulatedFieldAt(n);
                String string = String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MC_EXISTING_ITERATION"), simulatedField2.getName());
                int n3 = SpssAlertOptionPane.showConfirmDialog(this, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                if (n3 == 2) {
                    return;
                }
            }
            this.runSensitivityAnalysisSub(simulatedField, n2, n);
        }
    }

    private void runSensitivityAnalysisSub(SimulatedField simulatedField, int n, int n2) {
        if (this.mSimulatedFieldsList.getModel().getSize() > 0 && simulatedField != null) {
            SensitivityAnalysisSub sensitivityAnalysisSub = new SensitivityAnalysisSub((BaseTabbedDialog)this.mParent, simulatedField);
            sensitivityAnalysisSub.setVisible(true);
            if (sensitivityAnalysisSub.wasContinuePressed()) {
                if (n2 >= 0 && n2 != n) {
                    SimulatedField simulatedField2 = this.getSimulatedFieldAt(n2);
                    SimulationHelper.deleteIterationFrom(simulatedField2);
                    this.removeImageForRow(n2);
                }
                this.removeImageForRow(n);
                this.mSimulatedFieldsList.repaint();
                this.updateDistParamPanel();
            }
        }
    }

    public void removeImageForRow(int n) {
        String string = SimulationHelper.createImageKey(n);
        this.mImageMap.remove(string);
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.createMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSimulatedInputsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mFitAllButton, gridBagConstraints, 1, 0, 1, 1, n, null);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        n = 23;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n2, 2, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mSimulatedFieldsScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mMissingHandleCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 2, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(5, 0, 5, 0);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.mSensitivityButton);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 0, 1, 1, n, null);
        JPanel jPanel4 = this.createSimulatedFieldsPanel();
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 2, 1, 1, 2, n, insets);
        this.setTabTraversal();
    }

    private JPanel createSimulatedFieldsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = this.createNameFitStatePanel();
        jPanel2.setPreferredSize(this.mNamePanelPrefferedSize);
        jPanel2.setMinimumSize(this.mNamePanelPrefferedSize);
        JPanel jPanel3 = this.createChangeSelectionsPanel();
        this.mHelpPanel = this.createHelpPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 15, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 0.75;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.25;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mHelpPanel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel createNameFitStatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, n2);
        this.mSimFieldNameLabel = new JLabel(this.getNameLabel(null));
        this.mFitStateNameAndImageLabel = new JLabel();
        DialogUtil.addUsingGBL(jPanel, this.mSimFieldNameLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFitStateNameAndImageLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createChangeSelectionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(5, 25, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFitToFieldRadioButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mFieldLabel);
        jPanel2.add(this.mFieldComboBox);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mManuallySetParamsRadioButton, gridBagConstraints, 0, 2, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mDistParamPanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private SimulationHelper.HelpPanel createHelpPanel() {
        Font font = new JTextArea().getFont();
        SimulationHelper.HelpPanel helpPanel = new SimulationHelper.HelpPanel(font);
        helpPanel.setFocusable(true);
        helpPanel.setPreferredSize(new Dimension(10, 110));
        helpPanel.setMinimumSize(new Dimension(100, 110));
        return helpPanel;
    }

    private JPanel createMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2 * 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2 * 2, n2, 2, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mParent.getResString("IDS_MC_SIMPLE_SIM_TAB_FIELDS_TO_SIMULATE_LABEL")));
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
    }

    public void reloadSimulation(ArrayList<SimulatedField> arrayList) {
        this.mImageMap = new HashMap<String, BufferedImage>();
        this.mScannedVarMap = new Hashtable();
        this.reloadSimulation(arrayList, true);
    }

    public void reloadSimulation(ArrayList<SimulatedField> arrayList, boolean bl) {
        this.mSimulatedFieldsList.removeAll();
        this.mSimulatedFieldsList.getModel().setSortType(SpssVariableSortType.alpha);
        this.clearControls();
        if (arrayList != null && arrayList.size() > 0) {
            for (SimulatedField simulatedField : arrayList) {
                this.mSimulatedFieldsList.getModel().addElement((ISpssVariable)simulatedField, bl);
            }
            this.mSimulatedFieldsList.setSelectedIndex(0);
        }
        this.doEnableRunPaste();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMULATED_FIELD_FITALL_BUTTON");
        this.mFitAllButton = new JButton(toggleButtonAction);
        this.mFitAllButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMPLE_SIM_TAB_SENSITIVITY_BUTTON");
        this.mSensitivityButton = new JButton(toggleButtonAction);
        this.mSensitivityButton.addActionListener(this);
        this.mSimulatedFieldsList = new SimulatedFieldsList(VariableList.VarMoveType.eMoveOriginal);
        this.mSimulatedFieldsList.getModel().addListDataListener(this);
        this.mSimulatedFieldsList.setSelectionMode(0);
        this.mSimulatedFieldsList.setIdentifier(SRC_VAR_LIST);
        this.mSimulatedFieldsList.setContextMenuFlags(this.mSimulatedFieldsList.getContextMenuFlags() | 8);
        this.mSimulatedFieldsList.setCellRenderer(new MyListCellRenderer());
        this.mSimulatedFieldsList.setFixedCellWidth((int)mFixedCellSize.getWidth());
        this.mSimulatedFieldsList.setFixedCellHeight((int)mFixedCellSize.getHeight());
        this.mSimulatedFieldsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.requestFocusInWindow();
                MCSimpleSimulationSimulationTab.this.updatePanelsBasedOnSimFieldSelection();
                ((MCSimpleSimulationModelDlg)MCSimpleSimulationSimulationTab.this.mParent).enableOkPaste();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.requestFocusInWindow();
                    }
                });
            }
        });
        this.mSimulatedInputsLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SIMPLE_SIMULATION_INPUTS_LABEL");
        this.mSimulatedInputsLabel.setLabelFor(this.mSimulatedFieldsList);
        this.mSimulatedFieldsScrollPane = new JScrollPane(this.mSimulatedFieldsList);
        this.mSimulatedFieldsScrollPane.setPreferredSize(this.mSimulatedFieldsList.getMinimumSize());
        this.mSimulatedFieldsScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSimulatedFieldsScrollPane.setVerticalScrollBarPolicy(20);
        this.mSimulatedFieldsScrollPane.setPreferredSize(mScrollPanePrefferedSize);
        this.mSimulatedFieldsScrollPane.setMinimumSize(mScrollPanePrefferedSize);
        this.mSimulatedFieldsScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.repaint();
            }
        });
        this.mSimFieldNameLabel = new JLabel(this.getNameLabel(null));
        this.mFitStateNameAndImageLabel = new JLabel();
        this.mDistParamPanel = new DistributionParametersPanel(this, false);
        this.mDistParamPanel.setDistLabelText(this.mParent.getResString("IDS_MC_SIMPLE_SIMULATION_DISTRIBUTIONS_COMBO_LABEL"));
        this.mDistParamPanel.setPreferredSize(this.mDistPanelPrefferedSize);
        this.mDistParamPanel.setMinimumSize(this.mDistPanelPrefferedSize);
        this.mDistParamPanel.setPreviewImageSize(mPreviewImageSize);
        this.mFitToFieldButtonGroup = new SpssButtonGroup();
        this.mFitToFieldRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SIMPLE_SIMULATION_FIT_TO_FIELD_RADIO", (ActionListener)new FitToFieldAction());
        this.mFitToFieldButtonGroup.add(this.mFitToFieldRadioButton);
        this.mFitToFieldRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MCSimpleSimulationSimulationTab.this.processFitToFieldSelection();
            }
        });
        this.mFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SIMPLE_SIMULATION_FIELD_COMBO_LABEL");
        this.mFieldComboBox = new JComboBox();
        this.mFieldLabel.setLabelFor(this.mFieldComboBox);
        this.mManuallySetParamsRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SIMPLE_SIMULATION_EDIT_THE_PARAMS_RADIO", (ActionListener)new EditParametersAction());
        this.mFitToFieldButtonGroup.add(this.mManuallySetParamsRadioButton);
        this.mManuallySetParamsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MCSimpleSimulationSimulationTab.this.processSetManualParamsSelection();
            }
        });
        this.mMissingHandleCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_MISSING_HANDLE_CHECK", null);
        this.loadMatchingVariablesFromGatingDialog();
    }

    private void processSetManualParamsSelection() {
        this.enableDistParamPanel();
        this.enableFitToFieldControls(false);
        this.enableFitAllControl();
        this.enableSensitivityButton();
        this.repaint();
    }

    private void processFitToFieldSelection() {
        this.enableFitToFieldControls(true);
        this.enableDistParamPanel();
        this.enableFitAllControl();
        this.enableSensitivityButton();
        this.doEnableRunPaste();
        this.repaint();
    }

    private void doEnableRunPaste() {
        ((MCSimpleSimulationModelDlg)this.mParent).enableOkPaste(this.validateTabForOKPaste());
    }

    private void setFieldAutoFitSate(boolean bl) {
        SimulatedField simulatedField = this.getSelectedSimulatedField();
        if (simulatedField != null) {
            if (bl) {
                simulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
            } else if (this.mFieldComboBox.getSelectedIndex() == 0) {
                simulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.DistributionFittedBefore);
            } else {
                simulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.MatchedAndFitted);
            }
            this.updateFitStateLabel(simulatedField);
        }
        this.repaint();
    }

    private void updateFitStateLabel(SimulatedField simulatedField) {
        String string = SimulationHelper.getDistributionName(simulatedField.getDistributionType());
        JLabel jLabel = SimulationHelper.createStateImageLabel(simulatedField, false);
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            this.mFitStateNameAndImageLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mFitStateNameAndImageLabel.setText(string);
        }
        this.mFitStateNameAndImageLabel.setIcon(jLabel.getIcon());
    }

    private void enableDistParamPanel() {
        if (this.mSimulatedFieldsList.getModel().getSize() > 0) {
            this.updateDistParamPanel();
        }
    }

    private void updateDistParamPanel() {
        int n = this.mSimulatedFieldsList.getSelectedIndex();
        SimulatedField simulatedField = (SimulatedField)((Object)this.mSimulatedFieldsList.getSelectedValue());
        this.updateDistParamPanel(simulatedField, n);
    }

    private void updateDistParamPanel(SimulatedField simulatedField, int n) {
        boolean bl = simulatedField != null && !simulatedField.isLocked() && this.mManuallySetParamsRadioButton.isSelected();
        this.mDistParamPanel.updatePanel(simulatedField, n, bl);
    }

    private void updatePanelsBasedOnSimFieldSelection() {
        int n = -1;
        SimulatedField simulatedField = null;
        if (this.mSimulatedFieldsList.getModel().getSize() > 0) {
            n = this.mSimulatedFieldsList.getSelectedIndex();
            simulatedField = (SimulatedField)((Object)this.mSimulatedFieldsList.getSelectedValue());
        }
        this.updatePanelsBasedOnSimFieldSelection(simulatedField, n);
    }

    private void updatePanelsBasedOnSimFieldSelection(SimulatedField simulatedField, int n) {
        if (simulatedField != null) {
            if (ComponentState.isBtdRtlOrLtr() && this.getNameLabel(simulatedField) != null && this.getNameLabel(simulatedField).length() > 0) {
                this.mSimFieldNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)this.getNameLabel(simulatedField)));
            } else {
                this.mSimFieldNameLabel.setText(this.getNameLabel(simulatedField));
            }
            this.updateFitStateLabel(simulatedField);
            this.updateDistParamPanel(simulatedField, n);
            this.mSensitivityButton.setEnabled(true);
            this.updateFitToFieldCombobox(simulatedField);
            this.updateRadioButtonSelection(simulatedField);
            this.updateHelpText(simulatedField.getDistributionType());
            boolean bl = simulatedField != null && !simulatedField.isLocked() && this.mFitToFieldRadioButton.isSelected();
            this.enableFitToFieldControls(simulatedField, bl);
            this.enableFitAllControl();
            this.enableSensitivityButton();
            this.enableManuallySetParamsLabel(simulatedField);
        } else {
            this.clearControls();
        }
        this.mDistParamPanel.repaint();
    }

    private void updateRadioButtonSelection(SimulatedField simulatedField) {
        boolean bl;
        MonteCarloSimulationDlg.FitToState fitToState = simulatedField.getAutoFitState();
        boolean bl2 = bl = fitToState == MonteCarloSimulationDlg.FitToState.ManualDefined;
        if (bl) {
            this.mManuallySetParamsRadioButton.setSelected(true);
            this.processSetManualParamsSelection();
        } else {
            this.mFitToFieldRadioButton.setSelected(true);
            this.processFitToFieldSelection();
        }
    }

    public void updateHelpText(SimulationHelper.DistributionType distributionType) {
        this.mHelpPanel.setHelpForDistributionType(distributionType);
    }

    private void updateFitToFieldCombobox(SimulatedField simulatedField) {
        Vector<String> vector = new Vector<String>();
        vector.add(this.mParent.getResString("IDS_MC_SIMULATED_FIELD_TABLE_FITTO_NONE"));
        String string = simulatedField.getMappedName();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
        int n = iSpssDataSrc.columnCount();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            vector.add(iSpssVariable.getName());
        }
        this.mFieldComboBox.setModel(new DefaultComboBoxModel(vector));
        if (!vector.contains(string)) {
            simulatedField.setMappedName("");
            this.mFieldComboBox.setSelectedIndex(0);
        } else {
            this.mFieldComboBox.setSelectedItem(string);
        }
        this.mFieldComboBox.addItemListener(new FieldComboboxListener());
    }

    private String getNameLabel(SimulatedField simulatedField) {
        StringBuffer stringBuffer = new StringBuffer(this.mParent.getResString("IDS_MC_SIMPLE_SIMULATION_NAME_LABEL"));
        if (simulatedField == null) {
            stringBuffer.append("");
        } else {
            stringBuffer.append(simulatedField.getName());
        }
        return stringBuffer.toString();
    }

    private void loadMatchingVariablesFromGatingDialog() {
        this.mSimulatedFieldsList.getModel().removeAll();
    }

    private boolean canFitToField(SimulatedField simulatedField) {
        boolean bl = false;
        if (simulatedField != null) {
            MonteCarloSimulationDlg.FitToState fitToState = simulatedField.getAutoFitState();
            boolean bl2 = simulatedField.getMappedName() != null && simulatedField.getMappedName().trim().length() != 0;
            bl = !simulatedField.isLocked() && bl2;
        }
        return bl;
    }

    @Override
    public void processDistributionSelection(Object object, SimulationHelper.DistributionType distributionType) {
        this.doEnableRunPaste();
        this.mSimulatedFieldsList.repaint();
    }

    public String[] getDistributionNames(SimulatedField simulatedField) {
        String[] stringArray = simulatedField != null ? SimulationHelper.getDistributionNames(simulatedField) : null;
        return stringArray;
    }

    @Override
    public void processTableUpdate(SimulatedField simulatedField) {
        this.mSimulatedFieldsList.repaint();
        this.doEnableRunPaste();
    }

    @Override
    public Hashtable<String, BaseMCSimulationTab.ScannedVar> getScannedVarMap() {
        return this.mScannedVarMap;
    }

    @Override
    public Map<String, BufferedImage> getImageMap() {
        return this.mImageMap;
    }

    @Override
    public int getNumSimulatedFields() {
        return this.mSimulatedFieldsList.getModel().getSize();
    }

    @Override
    public SimulatedField getFitToSimulatedField(int n) {
        SimulatedField simulatedField = this.getSimulatedFieldAt(n);
        boolean bl = this.canFitToField(simulatedField);
        return bl ? simulatedField : null;
    }

    @Override
    public void setScannedVarMap(Hashtable<String, BaseMCSimulationTab.ScannedVar> hashtable) {
        this.mScannedVarMap.clear();
        this.mScannedVarMap.putAll(hashtable);
        int n = this.getNumSimulatedFields();
        for (int i = 0; i < n; ++i) {
            BaseMCSimulationTab.ScannedVar scannedVar;
            SimulatedField simulatedField = this.getFitToSimulatedField(i);
            if (simulatedField == null || (scannedVar = this.mScannedVarMap.get(simulatedField.getMappedName())) == null) continue;
            TreeMap<OBS, Double> treeMap = scannedVar.getValMap();
            double d = scannedVar.getStartPos();
            double d2 = scannedVar.getEndPos();
            Vector<BaseMCSimulationTab.HistoBin> vector = scannedVar.getHistoBins();
            if (vector != null) continue;
        }
        this.mImageMap.clear();
        this.mSimulatedFieldsList.repaint();
    }

    @Override
    public void setSimulatedPredictors(ArrayList<SimulatedField> arrayList) {
        ArrayList<SimulatedField> arrayList2 = new ArrayList<SimulatedField>();
        int n = this.getNumSimulatedFields();
        int n2 = this.mSimulatedFieldsList.getSelectedIndex();
        for (int i = 0; i < n; ++i) {
            int n3;
            SimulatedField simulatedField = this.getSimulatedFieldAt(i);
            String string = simulatedField.getName();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                SimulatedField simulatedField2 = arrayList.get(n3);
                String string2 = simulatedField2.getName();
                if (!string.equalsIgnoreCase(string2)) continue;
                arrayList2.add(simulatedField2);
                this.removeImageForRow(i);
                break;
            }
            if (n3 != arrayList.size()) continue;
            arrayList2.add(simulatedField);
        }
        this.reloadSimulation(arrayList2, false);
        this.mSimulatedFieldsList.setSelectedIndex(n2);
    }

    @Override
    void updateParameterCellFor(Vector<String> vector) {
    }

    @Override
    public String getAutofitNCasesSyntax() {
        return null;
    }

    @Override
    public String getMissingHandleSyntax() {
        return "";
    }

    private SimulatedField getSimulatedFieldAt(int n) {
        return (SimulatedField)this.mSimulatedFieldsList.getModel().getElementAt(n);
    }

    private void setTabTraversal() {
        this.mComponentOrder.clear();
        this.addToComponentOrder(this.mFitAllButton);
        this.addToComponentOrder(this.mSimulatedFieldsList);
        this.addToComponentOrder(this.mMissingHandleCheck);
        this.addToComponentOrder(this.mSensitivityButton);
        this.addToComponentOrder(this.mFitToFieldButtonGroup);
        this.addToComponentOrder(this.mFieldComboBox);
        if (this.mDistParamPanel != null) {
            if (this.mDistParamPanel.getDistNamesCombo() != null) {
                this.addToComponentOrder(this.mDistParamPanel.getDistNamesCombo());
            }
            if (this.mDistParamPanel.getDistNamesCombo() != null) {
                this.addToComponentOrder(this.mDistParamPanel.getParamTable());
            }
        }
        this.addToComponentOrder(this.mHelpPanel);
        for (Component component : this.mParent.getCmdButtonPanel().getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private Vector<SimulatedField> getSimulatedFieldsList() {
        Vector<SimulatedField> vector = new Vector<SimulatedField>();
        VarListModel varListModel = this.mSimulatedFieldsList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            vector.add((SimulatedField)varListModel.getElementAt(i));
        }
        return vector;
    }

    private JLabel createLockLabel(SimulatedField simulatedField) {
        JLabel jLabel = new JLabel();
        boolean bl = simulatedField.isLocked();
        ResourceBundle resourceBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (bl) {
            String string = "IDS_MC_SIMULATED_FIELD_LOCK_IMAGE";
            String string2 = this.mParent.getResString("IDS_MC_SIMULATED_FIELD_NOT_SET_TOOLTIP");
            URL uRL = ResUtil.getImageResourceFullPath(MCResBundle.getImageFolder() + ResUtil.getString(resourceBundle, string));
            ImageIcon imageIcon = new ImageIcon(uRL);
            jLabel = new JLabel(imageIcon);
            jLabel.setToolTipText(string2);
        } else {
            jLabel.setText("  ");
        }
        return jLabel;
    }

    private String getStateTextForField(SimulatedField simulatedField) {
        JLabel jLabel = SimulationHelper.createStateImageLabel(simulatedField, false);
        String string = jLabel != null ? jLabel.getToolTipText() : null;
        return string;
    }

    class SimulatedFieldsList
    extends SrcVariableList {
        public SimulatedFieldsList(VariableList.VarMoveType varMoveType) {
            super(varMoveType);
            this.turnOffCustomTooltips();
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                mouseEvent.consume();
            }
            super.processMouseEvent(mouseEvent);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.locationToIndex(point);
            SimulatedField simulatedField = MCSimpleSimulationSimulationTab.this.getSimulatedFieldAt(n);
            String string = null;
            if (simulatedField != null) {
                SimulationHelper.DistributionType distributionType = simulatedField.getDistributionType();
                MyListCellRenderer myListCellRenderer = (MyListCellRenderer)this.getCellRenderer();
                CellPanel cellPanel = (CellPanel)myListCellRenderer.getListCellRendererComponent((JList)MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList, (Object)simulatedField, n, false, false);
                Rectangle rectangle = this.getCellBounds(n, n);
                point = new Point(point.x - rectangle.x, point.y - rectangle.y);
                if (cellPanel.mGraphRect.contains(point)) {
                    string = SimulationHelper.getDistributionHelpIconTooltip(distributionType);
                }
                if (cellPanel.mLockImageRect != null && cellPanel.mLockImageRect.contains(point) && simulatedField.isLocked()) {
                    string = MCSimpleSimulationSimulationTab.this.mParent.getResString("IDS_MC_SIMPLE_FIELD_LOCKED");
                }
                if (cellPanel.mFitImageRect != null && cellPanel.mFitImageRect.contains(point)) {
                    string = MCSimpleSimulationSimulationTab.this.getStateTextForField(simulatedField);
                }
            }
            return string;
        }
    }

    class MyListCellRenderer
    extends AbstractCellEditor
    implements ListCellRenderer {
        CellPanel mPanel;

        public MyListCellRenderer() {
            this.mPanel = new CellPanel();
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SimulatedField) {
                this.mPanel.setField((SimulatedField)((Object)object));
                this.mPanel.setIndex(n);
                this.mPanel.setIsSelected(bl);
                this.mPanel.setCellHasFocus(bl2);
                SimulatedField simulatedField = (SimulatedField)((Object)object);
                MCSimpleSimulationSimulationTab.this.setToolTipText(null);
                StringBuffer stringBuffer = new StringBuffer(simulatedField.getName());
                stringBuffer.append(" ");
                stringBuffer.append(SimulationHelper.getDistributionName(simulatedField.getDistributionType()));
                stringBuffer.append(" ");
                if (simulatedField.isLocked()) {
                    stringBuffer.append(MCSimpleSimulationSimulationTab.this.mParent.getResString("IDS_MC_SIMPLE_FIELD_LOCKED"));
                } else {
                    stringBuffer.append(MCSimpleSimulationSimulationTab.this.mParent.getResString("IDS_MC_SIMPLE_FIELD_UNLOCKED"));
                }
                stringBuffer.append(" ");
                String string = MCSimpleSimulationSimulationTab.this.getStateTextForField(simulatedField);
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                }
                MCSimpleSimulationSimulationTab.this.getAccessibleContext().setAccessibleName(stringBuffer.toString());
            }
            return this.mPanel;
        }
    }

    class CellPanel
    extends JPanel {
        private Rectangle mGraphRect;
        private Rectangle mLockImageRect;
        private Rectangle mFitImageRect;
        private int mIndex;
        private boolean mIsSelected;
        private boolean mCellHasFocus;
        SimulatedField mSimField;
        JLabel label = new JLabel();
        int leftPadding = 5;
        int rightPadding = 5;

        CellPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.BLUE, 2));
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    CellPanel.this.setToolTipText(mouseEvent);
                }
            });
        }

        public void setField(SimulatedField simulatedField) {
            this.mSimField = simulatedField;
        }

        public void setToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            String string = "";
            if (this.mGraphRect.contains(point)) {
                string = "GRAPH";
            }
            if (this.mLockImageRect.contains(point)) {
                string = "mLockImageRect";
            }
            if (this.mFitImageRect.contains(point)) {
                string = "mFitImageRect";
            }
            this.setToolTipText(string);
        }

        private void paintBorder(Graphics2D graphics2D, Rectangle rectangle) {
            Color color = graphics2D.getColor();
            Color color2 = this.mIsSelected ? MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.getSelectionBackground() : MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.getBackground();
            com.spss.uitools.util.DrawUtil.fillRect((Graphics)graphics2D, (Color)color2, (Rectangle)rectangle);
            int n = this.mIndex == MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.getModel().getSize() ? rectangle.height - 3 : rectangle.height - 3;
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(1, 1, rectangle.width - 2, n);
            graphics2D.setColor(color);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.mSimField != null) {
                BufferedImage bufferedImage;
                int n;
                Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
                Color color = this.mIsSelected ? MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.getSelectionForeground() : MCSimpleSimulationSimulationTab.this.mSimulatedFieldsList.getForeground();
                Font font = this.label.getFont();
                Font font2 = font.deriveFont(1);
                font2 = font2.deriveFont((float)font.getSize() + 2.0f);
                this.paintBorder(graphics2D, rectangle);
                this.paintFocus(graphics2D, rectangle);
                graphics2D.setColor(color);
                graphics2D.setFont(font2);
                int n2 = graphics2D.getFontMetrics().getHeight() + graphics2D.getFontMetrics().getAscent();
                int n3 = n = graphics.getFontMetrics().getMaxAscent() + 5;
                graphics2D.drawString(this.mSimField.getName(), this.leftPadding, n);
                String string = SimulationHelper.getDistributionName(this.mSimField.getDistributionType());
                graphics2D.setFont(font);
                int n4 = graphics2D.getFontMetrics().stringWidth(string);
                graphics2D.drawString(string, rectangle.width - n4 - this.rightPadding, graphics.getFontMetrics().getMaxAscent());
                JLabel jLabel = SimulationHelper.createStateImageLabel(this.mSimField, true);
                n += (rectangle.height - n - jLabel.getIcon().getIconHeight()) / 2;
                jLabel.getIcon().paintIcon(this, graphics2D, this.leftPadding, n);
                this.mFitImageRect = new Rectangle(this.leftPadding, n, jLabel.getIcon().getIconWidth(), jLabel.getIcon().getIconHeight());
                int n5 = jLabel.getIcon().getIconWidth();
                int n6 = this.leftPadding + n5 + 5;
                JLabel jLabel2 = MCSimpleSimulationSimulationTab.this.createLockLabel(this.mSimField);
                if (jLabel2.getIcon() != null) {
                    this.mLockImageRect = new Rectangle(n6, n, jLabel2.getIcon().getIconWidth(), jLabel2.getIcon().getIconHeight());
                    jLabel2.getIcon().paintIcon(this, graphics2D, n6, n);
                }
                if ((bufferedImage = MCSimpleSimulationSimulationTab.this.mDistParamPanel.getImageForField(this.mSimField, this.mIndex, mPreviewImageSize, true)) != null) {
                    n6 = rectangle.width - bufferedImage.getWidth() - this.rightPadding;
                    this.mGraphRect = new Rectangle(n6, n3, bufferedImage.getWidth(), bufferedImage.getHeight());
                    graphics2D.drawImage((Image)bufferedImage, n6, n3, null);
                }
            }
        }

        public void setIndex(int n) {
            this.mIndex = n;
        }

        public void setIsSelected(boolean bl) {
            this.mIsSelected = bl;
        }

        public void setCellHasFocus(boolean bl) {
            this.mCellHasFocus = bl;
        }

        private void paintFocus(Graphics graphics, Rectangle rectangle) {
            if (this.mCellHasFocus) {
                Color color = graphics.getColor();
                Color color2 = DrawUtil.convertIfColorEqualsBackground((Color)this.getBackground(), (Color)UIManager.getColor("ToggleButton.focus"));
                graphics.setColor(color2);
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.grow(-3, -3);
                BasicGraphicsUtils.drawDashedRect(graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(color);
            }
        }
    }

    class EditParametersAction
    implements ActionListener {
        EditParametersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class FitToFieldAction
    implements ActionListener {
        FitToFieldAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class FieldComboboxListener
    implements ItemListener {
        FieldComboboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            SimulatedField simulatedField = MCSimpleSimulationSimulationTab.this.getSelectedSimulatedField();
            if (simulatedField != null) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                if (jComboBox.getSelectedItem().equals(MCSimpleSimulationSimulationTab.this.mParent.getResString("IDS_MC_SIMULATED_FIELD_TABLE_FITTO_NONE"))) {
                    simulatedField.setMappedName("");
                } else {
                    simulatedField.setMappedName(((String)MCSimpleSimulationSimulationTab.this.mFieldComboBox.getSelectedItem()).trim());
                }
                MCSimpleSimulationSimulationTab.this.enableFitAllControl();
                MCSimpleSimulationSimulationTab.this.enableSensitivityButton();
                MCSimpleSimulationSimulationTab.this.updateFitStateLabel(simulatedField);
                MCSimpleSimulationSimulationTab.this.repaint();
            }
        }
    }
}

