/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.MC.MCSimpleSimulationModelDlg;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class MCSimpleSimulationOutputTab
extends BaseProcedureTab
implements ItemListener,
ActionListener {
    public static final String NEW_DATASET_NAME = "IDS_MC_SIMPLE_SAVE_NEW_DATASET_NAME";
    public static final String NEW_SAV_FILE_NAME = "IDS_MC_SIMPLE_SAVE_NEW_SAV_FILE_NAME";
    public static final String NEW_EXCEL_FILE_NAME = "IDS_MC_SIMPLE_SAVE_NEW_EXCEL_FILE_NAME";
    public static final String NEW_PLAN_FILE_NAME = "IDS_MC_SIMPLE_SAVE_PLAN_FILE_NAME";
    private JCheckBox mPDF;
    private JCheckBox mCDF;
    private JCheckBox mTornadoCharts;
    private JCheckBox mContrToVariCheck;
    private JCheckBox mSensitivityToChangeCheck;
    private JCheckBox mScatterplots;
    private JCheckBox mBoxPlotCheck;
    private JCheckBox mOverlayResultCheck;
    private JCheckBox mQuantitleCheck;
    private JCheckBox mContingencyTableCheck;
    private JPanel mSave;
    private JCheckBox mSavePlanFileCheck;
    private JButton mBrowsePlanButton;
    private JCheckBox mSaveSimToFileCheck;
    private JRadioButton mSaveFileSavRB;
    private JRadioButton mSaveFileExcelRB;
    private JRadioButton mSaveToDatasetRB;
    private SpssButtonGroup mSaveGrop;
    private JButton mBrowseSavButton;
    private JLabel mSavFileLabel;
    private JButton mBrowseExcelButton;
    private JLabel mExcelFileLabel;
    private JLabel mDatasetFieldLabel;
    private JLabel mSavePlanFileLabel;
    private FileTextField mPlanFileField;
    private FileTextField mSavFileField;
    private FileTextField mExcelFileField;
    private StringTextField mDatasetNameField;

    public MCSimpleSimulationOutputTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_simple_output";
    }

    protected boolean validateTabForOKPaste() {
        return this.validateSavePanel();
    }

    protected boolean canEnableOkPaste() {
        return true;
    }

    private boolean validateSavePanel() {
        Object var1_1 = null;
        String string = null;
        boolean bl = true;
        if (this.mSavePlanFileCheck.isSelected() && (string = this.isValidFilePath(this.mPlanFileField)) != null) {
            bl = this.showPathError(this.mPlanFileField, string);
        }
        if (this.mSavFileField.isEnabled() && bl && (string = this.isValidFilePath(this.mSavFileField)) != null) {
            bl = this.showPathError(this.mSavFileField, string);
        }
        if (this.mDatasetNameField.isEnabled() && bl && !this.isValidVariableName(this.mDatasetNameField)) {
            ((MCSimpleSimulationModelDlg)this.mParent).selectOutputTab();
            this.selectAllAndFocus((JTextField)((Object)this.mDatasetNameField));
            return false;
        }
        if (this.mExcelFileField.isEnabled() && bl && (string = this.isValidFilePath(this.mExcelFileField)) != null) {
            bl = this.showPathError(this.mExcelFileField, string);
        }
        return bl;
    }

    private boolean showPathError(FileTextField fileTextField, String string) {
        boolean bl = SimulationHelper.showPathError((Component)this.mParent, string);
        ((MCSimpleSimulationModelDlg)this.mParent).selectOutputTab();
        this.selectAllAndFocus((JTextField)((Object)fileTextField));
        return bl;
    }

    private void selectAllAndFocus(JTextField jTextField) {
        jTextField.selectAll();
        jTextField.requestFocus();
    }

    private String isValidFilePath(FileTextField fileTextField) {
        String string = SimulationHelper.validateFilePath(this, (JTextField)((Object)fileTextField));
        return string;
    }

    private boolean isValidVariableName(StringTextField stringTextField) {
        boolean bl = false;
        if (stringTextField.getText().length() > 0 && DatasetNameValidator.validateDatasetName((String)stringTextField.getText(), (Component)this) == 1) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, n2, insets.bottom, insets.right);
        JPanel jPanel = this.setupLeftPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JPanel jPanel2 = this.setupSavePanel();
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, new JPanel(), gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, new JPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets2);
        this.setTabTraversal();
    }

    private JPanel setupLeftPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        JPanel jPanel2 = this.setupDensityFunctionsPanel();
        JPanel jPanel3 = this.setupTornadoPanel();
        JPanel jPanel4 = this.setupOtherChartsAndTablesPanel();
        this.mOverlayResultCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_OVERLAY_CHECK", null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets = new Insets(0, 17, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mOverlayResultCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        return jPanel;
    }

    private JPanel setupDensityFunctionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mParent.getResString("IDS_MC_SIMPLE_OUTPUT_TAB_DENSITY_FUNCTIONS_GROUPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        this.mPDF = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_PDF_CHECK", null);
        this.mPDF.addActionListener(this);
        this.mCDF = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_CDF_CHECK", null);
        this.mCDF.addActionListener(this);
        DialogUtil.addUsingGBL(jPanel, this.mPDF, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCDF, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTornadoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mParent.getResString("IDS_MC_SIMPLE_OUTPUT_TAB_TORNADO_CHARTS_GROUPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        this.mTornadoCharts = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_TORNADO_CHECK", null);
        this.mContrToVariCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_CONTRI_TO_VARIANCE_CHECK", null);
        this.mSensitivityToChangeCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_SENSITIVITY_TO_CHANGE_CHECK", null);
        DialogUtil.addUsingGBL(jPanel, this.mTornadoCharts, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mContrToVariCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSensitivityToChangeCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupOtherChartsAndTablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mParent.getResString("IDS_MC_SIMPLE_OUTPUT_TAB_OTHERCHARTSTABLES_GROUPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        this.mScatterplots = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_SCATTERPLOT_MATRIX_CHECK", null);
        this.mBoxPlotCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_BOXPLOT_CHECK", null);
        this.mBoxPlotCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    MCSimpleSimulationOutputTab.this.mOverlayResultCheck.setEnabled(true);
                } else {
                    MCSimpleSimulationOutputTab.this.mOverlayResultCheck.setEnabled(false);
                }
            }
        });
        this.mQuantitleCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_QUARTILE_TABLE_CHECK", null);
        DialogUtil.addUsingGBL(jPanel, this.mScatterplots, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mBoxPlotCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mQuantitleCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mContingencyTableCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_OUTPUT_CORRELATION_CROSSTAB_CHECK", null);
        DialogUtil.addUsingGBL(jPanel, this.mContingencyTableCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSavePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mParent.getResString("IDS_MC_SIMPLE_OUTPUT_TAB_SAVE_GROUPBOX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSavePlanFileCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2 * 5, n2, n2);
        JPanel jPanel2 = this.createFileBrowsePanel(this.mSavePlanFileLabel, (JComponent)((Object)this.mPlanFileField), this.mBrowsePlanButton);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, 0, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSaveSimToFileCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSaveFileSavRB, gridBagConstraints, 0, 3, 1, 1, n, new Insets(2, n2 * 2, 2, n2));
        Insets insets2 = new Insets(2, n2 * 5, n2, n2);
        JPanel jPanel3 = this.createFileBrowsePanel(this.mSavFileLabel, (JComponent)((Object)this.mSavFileField), this.mBrowseSavButton);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        insets.set(n2, 2, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSaveToDatasetRB, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JPanel jPanel4 = this.createFileBrowsePanel(this.mDatasetFieldLabel, (JComponent)((Object)this.mDatasetNameField), null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 6, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSaveFileExcelRB, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2 * 5, n2, 2);
        JPanel jPanel5 = this.createFileBrowsePanel(this.mExcelFileLabel, (JComponent)((Object)this.mExcelFileField), this.mBrowseExcelButton);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 8, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(2, 2, n2, n2);
        return jPanel;
    }

    private JPanel createFileBrowsePanel(JLabel jLabel, JComponent jComponent, JButton jButton) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, 5, 5);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponent, gridBagConstraints, 1, 0, 1, 1, n, insets);
        if (jButton != null) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        }
        return jPanel;
    }

    private void initSaveVars() {
        this.mSavePlanFileCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_SAVE_PLAN_FILE_CHECK", null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMPLE_SAVE_PLAN_FILE_BUTTON");
        this.mSavePlanFileCheck.addActionListener(this);
        this.mSavePlanFileLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SAVE_PLAN_FILE_LABEL");
        this.mPlanFileField = new FileTextField();
        this.mPlanFileField.setPreferredSize(new Dimension(175, 25));
        this.mPlanFileField.setAction(new TextFieldAction(this.mParent, NEW_PLAN_FILE_NAME));
        this.mSavePlanFileLabel.setLabelFor((Component)((Object)this.mPlanFileField));
        this.mBrowsePlanButton = new JButton(toggleButtonAction);
        this.mBrowsePlanButton.addActionListener(this);
        this.mSaveSimToFileCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MC_SIMPLE_SAVE_SIM_DATA_CHECK", null);
        this.mSaveSimToFileCheck.addActionListener(this);
        this.mDatasetFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SIMPLE_SAVE_DATASET_LABEL");
        this.mSaveFileSavRB = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SIMPLE_SAVE_AS_SAV_FILE_BUTTON", null);
        this.mSaveFileSavRB.addItemListener(this);
        this.mSaveToDatasetRB = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SIMPLE_SAVE_DATASET_BUTTON", null);
        this.mSaveToDatasetRB.addItemListener(this);
        this.mSaveFileExcelRB = DialogUtil.createRadioButton(this.mParent, "IDS_MC_SIMPLE_SAVE_AS_EXCEL_FILE_BUTTON", null);
        this.mSaveFileExcelRB.addItemListener(this);
        this.mSaveGrop = new SpssButtonGroup();
        this.mSaveGrop.add(this.mSaveFileSavRB);
        this.mSaveGrop.add(this.mSaveToDatasetRB);
        this.mSaveGrop.add(this.mSaveFileExcelRB);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMPLE_SAVE_SAV_BROWSE_BUTTON");
        this.mBrowseSavButton = new JButton(toggleButtonAction);
        this.mBrowseSavButton.addActionListener(this);
        this.mSavFileLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SIMPLE_SAVE_SAV_FILE_LABEL");
        this.mSavFileField = new FileTextField();
        this.mSavFileField.setPreferredSize(new Dimension(175, 25));
        this.mSavFileLabel.setLabelFor((Component)((Object)this.mSavFileField));
        this.mSavFileField.setAction(new TextFieldAction(this.mParent, NEW_SAV_FILE_NAME));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_SIMPLE_SAVE_EXCEL_BROWSE_BUTTON");
        this.mBrowseExcelButton = new JButton(toggleButtonAction);
        this.mBrowseExcelButton.addActionListener(this);
        this.mExcelFileLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_SIMPLE_SAVE_EXCEL_FILE_LABEL");
        this.mExcelFileField = new FileTextField();
        this.mExcelFileField.setPreferredSize(new Dimension(175, 25));
        this.mExcelFileLabel.setLabelFor((Component)((Object)this.mExcelFileField));
        this.mExcelFileField.setAction(new TextFieldAction(this.mParent, NEW_EXCEL_FILE_NAME));
        this.mDatasetNameField = new StringTextField();
        this.mDatasetNameField.setPreferredSize(new Dimension(175, 25));
        this.mDatasetNameField.setAction(new TextFieldAction(this.mParent, NEW_DATASET_NAME));
        this.mDatasetFieldLabel.setLabelFor((Component)((Object)this.mDatasetNameField));
    }

    private void initVars() {
        this.initSaveVars();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableSaveSidebarControls(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mSavePlanFileCheck) {
            if (this.mSavePlanFileCheck.isSelected()) {
                this.mSavePlanFileLabel.setEnabled(true);
                this.mPlanFileField.setEnabled(true);
                this.mBrowsePlanButton.setEnabled(true);
            } else {
                this.mSavePlanFileLabel.setEnabled(false);
                this.mPlanFileField.setEnabled(false);
                this.mBrowsePlanButton.setEnabled(false);
            }
        } else if (object == this.mSaveSimToFileCheck) {
            this.enableSaveSidebarControls(this.mSaveSimToFileCheck.isSelected());
        } else if (object == this.mBrowsePlanButton) {
            String string = MonteCarloSimulationDlg.showSaveDialog((Component)this.mParent, this.getResString("IDS_MC_SIMPLE_SAVE_DIALOG_TITLE"), this.getResString("IDS_MC_OUTPUT_SAVE_PLAN_FILE_FILTER"), this.getResString("IDS_MC_OUTPUT_SAVE_PLAN_FILE_FILTER_EXTN"));
            if (string.length() > 0) {
                this.mPlanFileField.setText(string);
            }
        } else if (object == this.mBrowseSavButton) {
            String string = MonteCarloSimulationDlg.showSaveDialog((Component)this.mParent, this.getResString("IDS_MC_SIMPLE_SAVE_DIALOG_TITLE"), this.getResString("IDS_MC_SAV_FILE_FILTER"), this.getResString("IDS_MC_SAV_FILE_EXT"));
            if (string.length() > 0) {
                this.mSavFileField.setText(string);
            }
        } else if (object == this.mBrowseExcelButton) {
            String[] stringArray = this.getResStringArray("IDS_MC_EXCEL_FILE_FILTER_ARRAY");
            String[] stringArray2 = this.getResStringArray("IDS_MC_EXCEL_FILE_EXT_ARRAY");
            String string = SimulationHelper.showSaveFileDialog(this.mParent, this.getResString("IDS_MC_SAVE_DIALOG_TITLE"), stringArray, stringArray2);
            if (string.length() > 0) {
                this.mExcelFileField.setText(string);
            }
        }
    }

    private void enableSaveSidebarControls(boolean bl) {
        this.mSaveFileSavRB.setEnabled(bl);
        this.mSaveFileExcelRB.setEnabled(bl);
        this.mSaveToDatasetRB.setEnabled(bl);
        if (bl) {
            if (this.mSavePlanFileCheck.isSelected()) {
                this.mSavePlanFileLabel.setEnabled(true);
                this.mPlanFileField.setEnabled(true);
            }
            if (this.mSaveFileSavRB.isSelected()) {
                this.mBrowseSavButton.setEnabled(true);
                this.mSavFileLabel.setEnabled(true);
                this.mSavFileField.setEnabled(true);
                this.mDatasetFieldLabel.setEnabled(false);
                this.mDatasetNameField.setEnabled(false);
                this.mBrowseExcelButton.setEnabled(false);
                this.mExcelFileLabel.setEnabled(false);
                this.mExcelFileField.setEnabled(false);
            } else if (this.mSaveToDatasetRB.isSelected()) {
                this.mBrowseSavButton.setEnabled(false);
                this.mSavFileLabel.setEnabled(false);
                this.mSavFileField.setEnabled(false);
                this.mDatasetFieldLabel.setEnabled(true);
                this.mDatasetNameField.setEnabled(true);
                this.mBrowseExcelButton.setEnabled(false);
                this.mExcelFileLabel.setEnabled(false);
                this.mExcelFileField.setEnabled(false);
            } else {
                this.mBrowseSavButton.setEnabled(false);
                this.mSavFileLabel.setEnabled(false);
                this.mSavFileField.setEnabled(false);
                this.mDatasetFieldLabel.setEnabled(false);
                this.mDatasetNameField.setEnabled(false);
                this.mBrowseExcelButton.setEnabled(true);
                this.mExcelFileLabel.setEnabled(true);
                this.mExcelFileField.setEnabled(true);
            }
        } else {
            this.mBrowseSavButton.setEnabled(false);
            this.mSavFileLabel.setEnabled(false);
            this.mSavFileField.setEnabled(false);
            this.mDatasetFieldLabel.setEnabled(false);
            this.mDatasetNameField.setEnabled(false);
            this.mBrowseExcelButton.setEnabled(false);
            this.mExcelFileLabel.setEnabled(false);
            this.mExcelFileField.setEnabled(false);
        }
    }

    public void enableAllControls(JPanel jPanel, boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = jPanel.getComponents()) {
            if (component instanceof JPanel) {
                this.enableAllControls((JPanel)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public void clearAllControls(JPanel jPanel) {
        Component[] componentArray;
        for (Component component : componentArray = jPanel.getComponents()) {
            if (component instanceof JPanel) {
                this.clearAllControls((JPanel)component);
                continue;
            }
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected(false);
                continue;
            }
            if (component instanceof JRadioButton) {
                ((JRadioButton)component).setSelected(false);
                continue;
            }
            if (component instanceof StringTextField) {
                ((StringTextField)((Object)component)).setText("");
                continue;
            }
            if (!(component instanceof FileTextField)) continue;
            ((FileTextField)((Object)component)).setText("");
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.clearAllControls(this);
        this.enableAllControls(this, false);
    }

    public void setDefaults(String string, boolean bl) {
        this.clearAllControls(this);
        if (bl) {
            this.enableAllControls(this, true);
        } else {
            this.enableAllControls(this, false);
        }
        this.mPDF.setSelected(true);
        this.setOuputDefault();
        if (bl) {
            this.mSaveSimToFileCheck.setSelected(false);
            this.mSaveFileSavRB.setSelected(true);
        } else {
            this.mSaveSimToFileCheck.setSelected(true);
            this.mSaveSimToFileCheck.setEnabled(true);
            this.mSaveToDatasetRB.setSelected(true);
            this.mSaveFileSavRB.setSelected(false);
        }
        this.mSavePlanFileCheck.setSelected(false);
        this.mSavePlanFileLabel.setEnabled(false);
        this.mPlanFileField.setEnabled(false);
        this.mBrowsePlanButton.setEnabled(false);
        this.mSaveFileSavRB.setEnabled(false);
        if (bl) {
            this.enableSaveSidebarControls(false);
        } else {
            this.enableSaveSidebarControls(true);
        }
        this.mPlanFileField.setText(SimulationHelper.getDefaultSimplanPath(false));
        this.mDatasetNameField.setText("SimulationDataSet");
        this.setDefaultFilePath(this.mSavFileField, "Simulation.sav");
        this.setDefaultFilePath(this.mExcelFileField, "Simulation.xlsx");
    }

    private void setDefaultFilePath(FileTextField fileTextField, String string) {
        String string2 = this.getDefaultPlanPathText(string);
        if (string2 != null) {
            fileTextField.setText(string2);
        }
    }

    private String getDefaultPlanPathText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        string2 = DataServerProxy.getDataProxy().isConnected() ? FileLocationsUtil.readDataFilesDirectoryPathFromPreferences() : FileLocationsUtil.readOtherFilesDirectoryPathFromPreferences();
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(System.getProperty("file.separator"));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void setOuputDefault() {
        this.mOverlayResultCheck.setEnabled(false);
        this.mQuantitleCheck.setSelected(true);
        this.mSensitivityToChangeCheck.setSelected(false);
        this.mContingencyTableCheck.setSelected(true);
    }

    private void setTabTraversal() {
        this.mComponentOrder.clear();
        this.addToComponentOrder(this.mPDF);
        this.addToComponentOrder(this.mCDF);
        this.addToComponentOrder(this.mTornadoCharts);
        this.addToComponentOrder(this.mContrToVariCheck);
        this.addToComponentOrder(this.mSensitivityToChangeCheck);
        this.addToComponentOrder(this.mScatterplots);
        this.addToComponentOrder(this.mBoxPlotCheck);
        this.addToComponentOrder(this.mQuantitleCheck);
        this.addToComponentOrder(this.mContingencyTableCheck);
        this.addToComponentOrder(this.mOverlayResultCheck);
        this.addToComponentOrder(this.mSavePlanFileCheck);
        this.addToComponentOrder(this.mPlanFileField);
        this.addToComponentOrder(this.mBrowsePlanButton);
        this.addToComponentOrder(this.mSaveSimToFileCheck);
        this.addToComponentOrder(this.mSaveFileSavRB);
        this.addToComponentOrder(this.mSavFileField);
        this.addToComponentOrder(this.mBrowseSavButton);
        this.addToComponentOrder(this.mSaveToDatasetRB);
        this.addToComponentOrder(this.mDatasetNameField);
        this.addToComponentOrder(this.mSaveFileExcelRB);
        this.addToComponentOrder(this.mExcelFileField);
        this.addToComponentOrder(this.mBrowseExcelButton);
        for (Component component : this.mParent.getCmdButtonPanel().getComponents()) {
            this.addToComponentOrder(component);
        }
    }
}

