/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.MC.MCSimpleSimulationOutputTab;
import com.spss.java_client.ui.dialogs.MC.MCSimpleSimulationSimulationTab;
import com.spss.java_client.ui.dialogs.MC.ModelPMMLFileHandler;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.MC.res.MCResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FocusableLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MCSimpleSimulationModelDlg
extends BaseTabbedDialog {
    public static final int SIMULATION_TAB_INDEX = 0;
    public static final int OUTPUT_TAB_INDEX = 1;
    public static String SIMPLE_MODEL_TYPE = "IDS_MC_SIMPLE_MODEL_TYPE";
    public static String SIMULATED_LIST_MODEL = "IDS_MC_SIMULATED_LIST_MODEL";
    private MCSimpleSimulationSimulationTab mSimulationTab;
    private MCSimpleSimulationOutputTab mOutputTab;
    protected FileTextField mPlanFileTextField;
    protected FocusableLabel mPlanModifiedDateLabel;
    protected JButton mOpenDiffPlanButton;
    private String mPMMLModelType = "";

    public MCSimpleSimulationModelDlg(JFrame jFrame) {
        super(jFrame, false, MCResBundle.getDefaultResourceBundleName(), MCResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SIMPLE_SIMULATION_TITLE"));
        this.mTabbedPane.setSelectedIndex(0);
    }

    public void reloadSimulationTab(ArrayList<SimulatedField> arrayList) {
        this.mSimulationTab.reloadSimulation(arrayList);
    }

    public void reloadOutputTab(String string, boolean bl) {
        this.mOutputTab.setDefaults(string, bl);
    }

    @Override
    protected void addMainViewComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mPlanFileTextField = new FileTextField(true);
        this.mPlanFileTextField.setBackground(this.getBackground());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)((Object)this.mPlanFileTextField), "Center");
        this.mPlanModifiedDateLabel = new FocusableLabel();
        JLabel jLabel = new JLabel(this.getResString("IDS_MC_SIMPLE_UPDATED_LABEL_TEXT"));
        jLabel.setLabelFor((Component)this.mPlanModifiedDateLabel);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_MC_SIMPLE_OPEN_DIFF_PLAN_FILE");
        this.mOpenDiffPlanButton = new JButton(toggleButtonAction);
        this.mOpenDiffPlanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationHelper.PlanParseInfo planParseInfo = SimulationHelper.selectAndParseSimulationPlan(MCSimpleSimulationModelDlg.this);
                if (planParseInfo != null && planParseInfo.getSimulationPlanHandler() != null) {
                    String string = planParseInfo.getPath();
                    MCSimpleSimulationModelDlg.this.setPlanPathLabel(string);
                    String string2 = planParseInfo.getModifiedDateText();
                    MCSimpleSimulationModelDlg.this.setModifiedDateLabel(string2);
                    MCSimpleSimulationModelDlg.this.getDialogDataModel().putObject("SimulationPlanHandler", planParseInfo.getSimulationPlanHandler());
                    MCSimpleSimulationModelDlg.this.getDialogDataModel().putString("SimulationPlanPath", string);
                    MCSimpleSimulationModelDlg.this.getDialogDataModel().putString("SimulationPlanModifiedDateText", planParseInfo.getModifiedDateText());
                    MCSimpleSimulationModelDlg.this.reloadSimulationTab(planParseInfo.getSimulationPlanHandler().getSimulatedPredictors());
                    SimulationPlanHandler simulationPlanHandler = planParseInfo.getSimulationPlanHandler();
                    ArrayList<SimulationPlanHandler.ModelFile> arrayList = simulationPlanHandler.getModelFiles();
                    boolean bl = true;
                    if (arrayList == null || arrayList.size() == 0) {
                        bl = false;
                    }
                    MCSimpleSimulationModelDlg.this.reloadOutputTab(string, bl);
                }
            }
        });
        jPanel3.add(this.mOpenDiffPlanButton);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, 4, 0, 4);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MC_SIMPLE_PLAN_LABEL_TEXT");
        jLabel2.setLabelFor((Component)((Object)this.mPlanFileTextField));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, 4);
        gridBagConstraints.fill = 2;
        jPanel2.setBackground(Color.RED);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mPlanFileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        n = 24;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOpenDiffPlanButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(jLabel);
        jPanel5.add((Component)this.mPlanModifiedDateLabel);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        insets.set(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 2, 3, 1, n, insets);
    }

    @Override
    protected void loadDialogState() {
        Object object;
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_simulation_gating_dialog", dialogDataModel);
        SimulationPlanHandler simulationPlanHandler = (SimulationPlanHandler)dialogDataModel.getObject("SimulationPlanHandler");
        this.mPMMLModelType = "";
        boolean bl = false;
        if (simulationPlanHandler != null) {
            this.reloadSimulationTab(simulationPlanHandler.getSimulatedPredictors());
            object = simulationPlanHandler.getModelFiles();
            if (object != null && ((ArrayList)object).size() > 0) {
                bl = true;
                boolean bl2 = ((SimulationPlanHandler.ModelFile)((ArrayList)object).get(0)).isIsCustomModel();
                if (!bl2) {
                    ModelPMMLFileHandler modelPMMLFileHandler;
                    String string = PrefsMgr.getPrefsMgr().getTempPath();
                    ArrayList<SimulationPlanHandler.ModelFile> arrayList = simulationPlanHandler.getModelFiles();
                    if (arrayList.size() > 0 && (modelPMMLFileHandler = new ModelPMMLFileHandler(string + arrayList.get(0).getFileName())).getErrorMessage().length() == 0) {
                        this.mPMMLModelType = modelPMMLFileHandler.getModelTypeName();
                    }
                }
            }
        } else {
            object = (ModelPMMLFileHandler)dialogDataModel.getObject("PMMLModelHandler");
            if (object != null) {
                this.reloadSimulationTab(((ModelPMMLFileHandler)object).getSimulatedPredictors());
            }
        }
        object = dialogDataModel.getString("SimulationPlanPath");
        this.setPlanPathLabel((String)object);
        this.reloadOutputTab((String)object, bl);
        String string = dialogDataModel.getString("SimulationPlanModifiedDateText");
        this.setModifiedDateLabel(string);
    }

    private void setPlanPathLabel(String string) {
        string = string != null && string.length() > 0 ? string : "";
        this.mPlanFileTextField.setText(" " + string);
        this.mPlanFileTextField.setBorder(BorderFactory.createEmptyBorder());
    }

    private void setModifiedDateLabel(String string) {
        string = string != null && string.length() > 0 ? string : "";
        this.mPlanModifiedDateLabel.setText(string);
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putObject(SIMULATED_LIST_MODEL, this.mSimulationTab.getSrcListModel());
        if (this.mPMMLModelType.length() > 0) {
            dialogDataModel.putString(SIMPLE_MODEL_TYPE, this.mPMMLModelType);
        }
    }

    public ISpssDataSrc getActiveDataSrc() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        return DataMgr.getDataMgr().getDataSource(locallyUniqueId);
    }

    public String getActiveDatasetName() {
        String string = null;
        ISpssDataSrc iSpssDataSrc = this.getActiveDataSrc();
        if (iSpssDataSrc != null) {
            string = iSpssDataSrc.getDatasetName();
        }
        return string;
    }

    @Override
    public void reset() {
        super.reset();
        this.mPlanFileTextField.setText("");
        this.mPlanModifiedDateLabel.setText("");
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(MonteCarloSimulationDlg.FILE_HANDLE_KEY, SimulationHelper.getFileHandleName());
        boolean bl = super.getPressedButton() == this.mOkButton;
        stringBuffer.append(SimulationHelper.generateSimCREATESyntax(dialogDataModel, true, bl));
        stringBuffer.append(SimulationHelper.generateSIMRUNsyntax(dialogDataModel, true));
        return stringBuffer.toString();
    }

    public void enableOkPaste() {
        boolean bl = this.mSimulationTab != null && this.mSimulationTab.canEnableOkPaste() && this.mOutputTab != null && this.mOutputTab.canEnableOkPaste();
        super.enableOkPaste(bl);
    }

    @Override
    public boolean okPastePressed() {
        if (!this.mSimulationTab.validateTabForOKPaste()) {
            return false;
        }
        if (!this.mOutputTab.validateTabForOKPaste()) {
            return false;
        }
        return super.okPastePressed();
    }

    protected void selectOutputTab() {
        this.mTabbedPane.setSelectedIndex(1);
    }

    @Override
    public String getIActionKey() {
        return "utilities_monte_carlo_simulation_simple_model_dialog";
    }

    public MCSimpleSimulationSimulationTab getSimulationTab() {
        return this.mSimulationTab;
    }

    public MCSimpleSimulationOutputTab getOutputTab() {
        return this.mOutputTab;
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected void init() {
        super.init();
        this.mSimulationTab = new MCSimpleSimulationSimulationTab(this);
        this.addTab(this.getResString("IDS_MC_SIMPLE_SIMULATION_TAB"), this.mSimulationTab);
        this.mOutputTab = new MCSimpleSimulationOutputTab(this);
        this.addTab(this.getResString("IDS_MC_SIMPLE_OUTPUT_TAB"), this.mOutputTab);
        this.pack();
        this.renameOKAction("IDS_RUN");
    }

    @Override
    protected Vector<Object> getAboveTabControls() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPlanFileTextField);
        vector.add(this.mPlanModifiedDateLabel);
        vector.add(this.mOpenDiffPlanButton);
        return vector;
    }
}

