/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FunctionList;
import com.spss.java_client.ui.controls.ListTravArrowButtonGroup;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.MC.EquationSubDlg;
import com.spss.java_client.ui.dialogs.MC.MCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.ModelPMMLFileHandler;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.NewFieldNameAndTypeSubDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MCModelTab
extends BaseProcedureTab
implements ActionListener,
ListSelectionListener,
ListDataListener {
    private static final int TEXT_FIELD_COLUMNS = 40;
    private static final String DELETE_KEY = "IDS_MC_DELETE_ONE_ROW";
    private static final String MC_COMPUTE = "COMPUTE ";
    public static final String NEW_MODEL_PMML_FILE_TYPE = "IDS_MC_MODEL_NEW_MODEL_PMML_FILE_TYPE";
    public static final String EQUATION_COMMENT_KEY = "IDS_MC_MODEL_TAB_EQUATION_COMMENT_KEY";
    public static final String NEW_MODEL_PMML_FILE_PATH = "IDS_MC_MODEL_NEW_MODEL_PMML_FILE_PATH";
    public static final String EQUATION_TARGET_KEY = "IDS_MC_MODEL_TAB_EQUATION_TARGET_KEY";
    private JTable mPlanTable;
    private DefaultTableModel mPlanTableModel;
    private JLabel mPlanTableLabel;
    private JButton mNewEquation;
    private JButton mEditPlan;
    private JButton mCopyPlan;
    private JButton mDeletePlan;
    private String[] mPlaneTableHeaderNames;
    private JPanel mPlanPanel;
    private ArrayList<Pair<String, String>> mTargetAndEquations;
    private Hashtable<String, String> mTargetAndComments;
    private Hashtable<String, Object[]> mTargetAndSimInputs;
    private JLabel mModelSource;
    private JRadioButton mLoadModelFile;
    private JRadioButton mEquationButton;
    private SpssButtonGroup mGroup;
    private JPanel mModelInfoPanel;
    private JLabel mPathLabel;
    private FileTextField mModelPmmlPath;
    private JLabel mTypeLabel;
    private StringTextField mModelTypeField;
    private JLabel mInputLabel;
    private StringTextField mModelInputField;
    private JLabel mTargetLabel;
    private StringTextField mTargetField;
    private JButton mModelBrowerButton;
    private ArrowButton mUpArrowButton;
    private ArrowButton mDownArrowButton;
    private JPanel mArrowPanel;
    private DisplayTableRenderer mTableRender;
    private ArrayList<SimulatedField> mTargetFromModel = null;
    private ArrayList<SimulatedField> mInputsFromModel = null;
    private TableType mType;
    private Hashtable<String, SimulatedField> mTargetsFromEquation;
    private JRadioButton mCreateDataButton;
    private SrcVariableList mSrcVarList;
    private JLabel mSourceListLabel;
    private TargetVariableList mTargetVarList;
    private JLabel mTargetListLabel;
    MCTargetVarListModel mTargetListModel = null;
    private JButton mNewFieldButton;
    private JButton mEditFieldButton;
    private JButton mDeleteFieldButton;
    private ArrowButton mArrowButton;
    private Vector<String> mSrcVarNames = null;
    private Hashtable<String, Object> mFixedFieldDefaultValues;

    public MCModelTab(BaseTabbedDialog baseTabbedDialog, SimulationPlanHandler simulationPlanHandler, TableType tableType) {
        super(baseTabbedDialog, true);
        this.mType = tableType;
        this.initialize(tableType);
        this.setTabThroughCells(true);
        this.mTargetAndSimInputs = new Hashtable();
        this.setTabThroughCells(true);
        this.mTargetsFromEquation = new Hashtable();
        this.mTargetAndComments = new Hashtable();
        this.mFixedFieldDefaultValues = new Hashtable();
    }

    public boolean doValidateTab() {
        if (this.mEquationButton.isSelected()) {
            return this.mPlanTable.getRowCount() > 0;
        }
        if (this.mLoadModelFile.isSelected()) {
            return this.mModelInputField.getText().length() > 0;
        }
        return this.mTargetVarList.getModel().getSize() > 0;
    }

    @Override
    public void reset() {
        this.mPlanTableModel.setDataVector(new Object[0][], this.mPlaneTableHeaderNames);
        this.mModelPmmlPath.setText("");
        this.mModelTypeField.setText("");
        this.mModelInputField.setText("");
        this.mTargetField.setText("");
        if (this.mTargetFromModel != null) {
            this.mTargetFromModel.clear();
        }
        if (this.mInputsFromModel != null) {
            this.mInputsFromModel.clear();
        }
        if (this.mTargetAndEquations != null) {
            this.mTargetAndEquations.clear();
        }
        if (this.mTargetAndSimInputs != null) {
            this.mTargetAndSimInputs.clear();
        }
        if (this.mTargetAndComments != null) {
            this.mTargetAndComments.clear();
        }
        if (this.mTargetsFromEquation != null) {
            this.mTargetsFromEquation.clear();
        }
        this.mTableRender = new DisplayTableRenderer(this.mUpArrowButton, this.mDownArrowButton);
        this.mPlanTable.getColumnModel().getColumn(0).setCellRenderer(this.mTableRender);
        this.mPlanTable.getColumnModel().getColumn(1).setCellRenderer(this.mTableRender);
        this.mPlanTable.getColumnModel().getColumn(2).setCellRenderer(this.mTableRender);
        this.mPlanTable.getColumnModel().getColumn(3).setCellRenderer(this.mTableRender);
        DialogDataModel dialogDataModel = ((MonteCarloSimulationDlg)this.mParent).getDialogDataModel();
        dialogDataModel.putString("IDS_MC_TARGET_FIELD_STRING", null);
        dialogDataModel.putString("IDS_MC_INPUT_FIELD_STRING", null);
        dialogDataModel.putString("IDS_MC_EQUATION_COMMEMENTS", null);
        dialogDataModel.putArray("IDS_MC_USED_SIM_FIELD", null);
        dialogDataModel.putArray("IDS_MC_EQUATION_SIM_ALL", null);
        dialogDataModel.putObject("IDS_MC_TARGET_FIELD_VARIABLE", null);
        dialogDataModel.putString(EQUATION_COMMENT_KEY, null);
        dialogDataModel.putString("SimulationPlanPath", null);
        if (this.mTargetListModel != null) {
            this.mTargetListModel.removeAll();
            this.mSrcVarList.loadFromActiveDataset();
        }
        this.mFixedFieldDefaultValues.clear();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_model";
    }

    public String getSimPrepSyntax() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mEquationButton.isSelected()) {
            String string;
            int n;
            stringBuffer.append("\n*Simulation preparation.");
            stringBuffer.append("\nBEGIN EXPR");
            stringBuffer.append("\n/OUTFILE PREPXML='");
            stringBuffer.append(SimulationHelper.getTransFileNamePath());
            stringBuffer.append("'.");
            int n2 = this.mTargetAndSimInputs.size();
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < this.mPlanTable.getRowCount(); ++n) {
                Object[] objectArray;
                string = this.mPlanTable.getValueAt(n, 0).toString();
                for (Object object : objectArray = this.mTargetAndSimInputs.get(string)) {
                    SimulatedField simulatedField = (SimulatedField)((Object)object);
                    String string2 = simulatedField.getName();
                    if (iSpssDataSrc.findVarIndex(string2) >= 0 || this.mTargetAndSimInputs.get(string2) != null || vector.contains(string2)) continue;
                    vector.add(string2);
                    boolean bl = false;
                    if (simulatedField.getType() > 0) {
                        stringBuffer.append("\nSTRING ");
                        stringBuffer.append(string2);
                        stringBuffer.append(" (A");
                        stringBuffer.append(this.getFixValueLength(simulatedField));
                        stringBuffer.append(").");
                        bl = true;
                    } else {
                        stringBuffer.append("\nNUMERIC " + string2 + ".");
                    }
                    stringBuffer.append(this.getMLevelSyntax(simulatedField));
                    stringBuffer.append(this.getValueLabelSyntax(simulatedField));
                }
                SimulatedField object = this.mTargetsFromEquation.get(string);
                if (object == null) continue;
                if (iSpssDataSrc.findVarIndex(object.getName()) < 0) {
                    stringBuffer.append("\nNUMERIC " + object.getName() + ".");
                }
                stringBuffer.append(this.getMLevelSyntax(object));
                stringBuffer.append(this.getValueLabelSyntax(object));
            }
            for (n = 0; n < this.mPlanTable.getRowCount(); ++n) {
                string = this.mPlanTable.getValueAt(n, 0).toString();
                stringBuffer.append("\nCOMPUTE ");
                stringBuffer.append(string + " = ");
                stringBuffer.append(this.mPlanTable.getValueAt(n, 1));
                stringBuffer.append(".");
            }
            stringBuffer.append("\nEND EXPR.");
        }
        return stringBuffer.toString();
    }

    @Override
    protected boolean validateTab() {
        if (this.mCreateDataButton.isSelected()) {
            VarListModel varListModel = this.mTargetVarList.getModel();
            int n = varListModel.getSize();
            SimulatedField[] simulatedFieldArray = new SimulatedField[n];
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                if (iSpssVariable instanceof SimulatedField) {
                    simulatedFieldArray[i] = iSpssVariable;
                    continue;
                }
                SimulatedField simulatedField = new SimulatedField(iSpssVariable.getName());
                simulatedField.setMappedName(iSpssVariable.getName());
                simulatedField.setMeasurementLevel(iSpssVariable.getMeasurementLevel());
                simulatedField.setType(iSpssVariable.getType());
                simulatedField.setFormat(iSpssVariable.getFormat());
                simulatedField.setDistributionType(SimulationHelper.DistributionType.NONE);
                simulatedField.setValueLabels(iSpssVariable.getValueLabels());
                simulatedFieldArray[i] = simulatedField;
            }
            ((MonteCarloSimulationDlg)this.mParent).updateSimulationTab((Object[])simulatedFieldArray, null);
        }
        ((MonteCarloSimulationDlg)this.mParent).getSimulationTab().updateSimulationPanelControlsForCreateData(this.isCreateDataButtonSelected());
        return true;
    }

    private void addCreateDataPanel(JPanel jPanel) {
        this.mGroup.add(this.mCreateDataButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDataButton, gridBagConstraints, 0, 8, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        insets.set(2, n2 * 5, n2, n2 * 2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel2 = this.setupLists();
        jPanel2.setMinimumSize(new Dimension(350, 130));
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 9, 1, 1, n, insets);
        if (this.mType == TableType.CREATE_DATA) {
            this.mCreateDataButton.setSelected(true);
        } else {
            this.mCreateDataButton.setSelected(false);
        }
        this.enableCreateDataControls(this.mCreateDataButton.isSelected());
    }

    private JPanel setupLists() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarNames = new Vector();
        VarListModel varListModel = this.mSrcVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            this.mSrcVarNames.add(varListModel.getElementAt(i).getName());
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        this.mSourceListLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_CREATE_DATA_SOURCE_LABEL");
        this.mSourceListLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, this.mSourceListLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSrcVarList.getFixedCellHeight() * 4 + 2));
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        jScrollPane.setMinimumSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mTargetListLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_CREATE_DATA_TARGET_LABEL");
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetListLabel.setLabelFor(this.mTargetVarList);
        this.mTargetVarList.setMaxLimitOfList(500);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetVarList.setSelectionMode(0);
        this.mTargetListModel = new MCTargetVarListModel(this.mTargetVarList);
        this.mTargetVarList.setModel(this.mTargetListModel);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MCModelTab.this.deleteOnesimulatedField();
            }
        };
        this.mTargetVarList.getActionMap().put(DELETE_KEY, abstractAction);
        this.mTargetVarList.getInputMap().put(KeyStroke.getKeyStroke(127, 0), DELETE_KEY);
        this.mTargetVarList.addMouseListener(new SimDoubleClickHandler());
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 4 + 2));
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        jScrollPane2.setMinimumSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_MODEL_CREATE_DATA_NEW_BUTTON");
        this.mNewFieldButton = new JButton(toggleButtonAction);
        this.mNewFieldButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_MODEL_CREATE_DATA_EDIT_BUTTON");
        this.mEditFieldButton = new JButton(toggleButtonAction);
        this.mEditFieldButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_MODEL_CREATE_DATA_DELETE_BUTTON");
        this.mDeleteFieldButton = new JButton(toggleButtonAction);
        this.mDeleteFieldButton.addActionListener(this);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        insets.set(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mNewFieldButton, gridBagConstraints, 0, 0, 1, 1, 24, insets);
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mEditFieldButton, gridBagConstraints, 1, 0, 1, 1, 24, insets);
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mDeleteFieldButton, gridBagConstraints, 2, 0, 1, 1, 24, insets);
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 3, 1, 1, 2, n, insets);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private int getFixValueLength(SimulatedField simulatedField) {
        int n = 8;
        if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.FIXED) {
            ArrayList<Pair<String, String>> arrayList = simulatedField.getParametersFor(SimulationHelper.DistributionType.FIXED);
            if (arrayList.size() == 1) {
                n = ((String)arrayList.get(0).getSecond()).length();
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n2 = ((String)arrayList.get(i).getSecond()).length();
                    if (i != 0 && n2 <= n) continue;
                    n = n2;
                }
            }
        }
        return n;
    }

    private String getMLevelSyntax(SimulatedField simulatedField) {
        StringBuffer stringBuffer = new StringBuffer("");
        MeasurementLevel measurementLevel = simulatedField.getMeasurementLevel();
        stringBuffer.append("\nVARIABLE LEVEL " + simulatedField.getName());
        if (measurementLevel == MeasurementLevel.ordinal) {
            stringBuffer.append(" (ORDINAL).");
        } else if (measurementLevel == MeasurementLevel.nominal) {
            stringBuffer.append(" (NOMINAL).");
        } else {
            stringBuffer.append(" (SCALE).");
        }
        return stringBuffer.toString();
    }

    private String getValueLabelSyntax(SimulatedField simulatedField) {
        StringBuffer stringBuffer = new StringBuffer("");
        IValueLabelMap iValueLabelMap = simulatedField.getValueLabels();
        if (iValueLabelMap != null) {
            boolean bl = simulatedField.getFormat().getFormatType().isStringFormat() || simulatedField.getType() > 0;
            Set set = iValueLabelMap.getValueLabelEntries();
            if (set.size() > 0) {
                Iterator iterator = set.iterator();
                stringBuffer.append("\nVALUE LABELS " + simulatedField.getName());
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (bl) {
                        stringBuffer.append(" " + CharacterUtil.smartQuote((String)((OBS)entry.getKey()).getString()));
                    } else {
                        stringBuffer.append(" " + ((OBS)entry.getKey()).getNum());
                    }
                    stringBuffer.append(" " + CharacterUtil.smartQuote((String)((String)entry.getValue())));
                }
                stringBuffer.append(".");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        if (this.mTargetAndComments.size() > 0) {
            dialogDataModel.putObject(EQUATION_COMMENT_KEY, this.mTargetAndComments);
        }
        if (this.mTargetsFromEquation.size() > 0) {
            dialogDataModel.putObject(EQUATION_TARGET_KEY, this.mTargetsFromEquation);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        int n;
        if (listDataEvent.getSource() == this.mTargetVarList.getModel() && (n = this.mTargetVarList.getSelectedIndex()) != -1) {
            ((MonteCarloSimulationDlg)this.mParent).removeOneInput(this.mTargetVarList.getModel().getElementAt(n).getName());
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() == this.mTargetVarList && (n = this.mTargetVarList.getSelectedIndex()) != -1) {
            this.mSrcVarList.clearSelection();
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(n);
            if (iSpssVariable instanceof SimulatedField) {
                this.mArrowButton.setEnabled(false);
                this.mDeleteFieldButton.setEnabled(true);
                this.mEditFieldButton.setEnabled(true);
            } else {
                this.mArrowButton.setEnabled(true);
                this.mDeleteFieldButton.setEnabled(false);
                this.mEditFieldButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mModelBrowerButton) {
            String[] stringArray = this.getResStringArray("IDS_MC_XML_FILE_FILTER_ARRY");
            String[] stringArray2 = this.getResStringArray("IDS_MC_XML_FILE_EXT_ARRY");
            String string = SimulationHelper.showOpenPlanFileDialog(this.mParent, this.getResString("IDS_SIMULATION_LOAD_MODEL_LABEL"), stringArray, stringArray2);
            if (string.length() != 0) {
                this.runPMMLModelHandler(string);
            }
        } else if (object == this.mNewEquation) {
            this.runNewEquationSub(-1);
            this.enableEquationControls(true);
        } else if (object == this.mEditPlan) {
            this.runNewEquationSub(this.mPlanTable.getSelectedRow());
        } else if (object == this.mDeletePlan) {
            this.deleteOneRow();
        } else if (object == this.mCopyPlan) {
            int n = this.mPlanTable.getSelectedRow();
            if (n >= 0) {
                this.insertOneRowAfter(n);
            }
        } else if (object instanceof ArrowButton) {
            ArrowButton arrowButton = (ArrowButton)object;
            int n = this.mPlanTable.getSelectedRow();
            if (n >= 0) {
                if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.up) {
                    this.manipulateUp(n);
                } else if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.down) {
                    this.manipulateDown(n);
                }
            }
        } else if (object instanceof JRadioButton) {
            boolean bl;
            boolean bl2 = ((JRadioButton)object).isSelected();
            JRadioButton jRadioButton = null;
            if (object == this.mEquationButton) {
                if (this.mModelInputField.getText().length() > 0) {
                    jRadioButton = this.mLoadModelFile;
                } else if (this.mTargetListModel.getSize() > 0) {
                    jRadioButton = this.mCreateDataButton;
                }
            } else if (object == this.mLoadModelFile) {
                if (this.mPlanTable.isEnabled() && this.mPlanTable.getRowCount() > 0) {
                    jRadioButton = this.mEquationButton;
                } else if (this.mTargetListModel.getSize() > 0) {
                    jRadioButton = this.mCreateDataButton;
                }
            } else if (object == this.mCreateDataButton) {
                if (this.mPlanTable.isEnabled() && this.mPlanTable.getRowCount() > 0) {
                    jRadioButton = this.mEquationButton;
                } else if (this.mModelInputField.getText().length() > 0) {
                    jRadioButton = this.mLoadModelFile;
                }
            }
            if (jRadioButton != null && (bl = this.checkModelSourceStatus((JRadioButton)object, jRadioButton))) {
                MonteCarloSimulationDlg monteCarloSimulationDlg = (MonteCarloSimulationDlg)this.mParent;
                monteCarloSimulationDlg.reset();
            }
            if (this.mEquationButton.isSelected()) {
                this.enableModelPMMLControls(false);
                this.enableEquationControls(true);
                this.enableCreateDataControls(false);
            } else if (this.mLoadModelFile.isSelected()) {
                this.enableModelPMMLControls(true);
                this.enableEquationControls(false);
                this.enableCreateDataControls(false);
            } else if (this.mCreateDataButton.isSelected()) {
                this.enableModelPMMLControls(false);
                this.enableEquationControls(false);
                this.enableCreateDataControls(true);
            }
        } else if (object == this.mNewFieldButton || object == this.mEditFieldButton) {
            this.handleNewOrEditFieldAction(object);
        } else if (object == this.mDeleteFieldButton) {
            this.deleteOnesimulatedField();
        }
    }

    public boolean isCreateDataButtonSelected() {
        return this.mCreateDataButton.isSelected();
    }

    private void handleNewOrEditFieldAction(Object object) {
        SimulatedField simulatedField = null;
        int n = this.mTargetVarList.getSelectedIndex();
        if (object == this.mEditFieldButton) {
            simulatedField = (SimulatedField)((Object)this.mTargetVarList.getSelectedValue());
        }
        NewFieldNameAndTypeSubDlg newFieldNameAndTypeSubDlg = new NewFieldNameAndTypeSubDlg((MonteCarloSimulationDlg)this.mParent, null, false, this.getExistingVarNames(), (ISpssVariable)simulatedField, this.getFixedDefaultValue((ISpssVariable)simulatedField));
        newFieldNameAndTypeSubDlg.setVisible(true);
        boolean bl = newFieldNameAndTypeSubDlg.wasContinuePressed();
        if (bl) {
            DialogDataModel dialogDataModel = ((MonteCarloSimulationDlg)this.mParent).getDialogDataModel();
            VarListModel varListModel = this.mTargetVarList.getModel();
            String string = dialogDataModel.getString("IDS_MC_FIELD_NAME_COMBO");
            SimulatedField simulatedField2 = null;
            simulatedField2 = object == this.mEditFieldButton ? simulatedField : new SimulatedField(string);
            short s = 0;
            if (dialogDataModel.getBoolean("IDS_MC_NAME_TYPE_DISTRIBUTION_BUTTON").booleanValue()) {
                simulatedField2.setRole(Role.input);
                int n2 = dialogDataModel.getInteger("IDS_MC_INPUT_MEASUREMENT_COMBO");
                if (n2 == 1) {
                    s = 1;
                }
                if (n2 == 2 || n2 == 3) {
                    --n2;
                }
                simulatedField2.setMeasurementLevel(EquationSubDlg.getMLevel(n2));
                simulatedField2.setType(s);
            } else {
                simulatedField2.setRole(Role.partition);
                if (dialogDataModel.getInteger("IDS_MC_FIELD_TYPE_COMBO") == 1) {
                    s = 1;
                }
                String string2 = dialogDataModel.getString("IDS_MC_FIXED_DEFAULT_VALUE");
                this.removeFixedDefaultValue(simulatedField2.getName());
                this.mFixedFieldDefaultValues.put(simulatedField2.getName(), string2);
                if (s == 0) {
                    simulatedField2.setMeasurementLevel(MeasurementLevel.scale);
                } else {
                    simulatedField2.setMeasurementLevel(MeasurementLevel.nominal);
                }
                simulatedField2.setType(s);
                simulatedField2.removeAllParameters();
                ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
                Pair pair = new Pair((Object)"value", (Object)string2);
                arrayList.add(pair);
                simulatedField2.setDistributionType(SimulationHelper.DistributionType.FIXED);
                simulatedField2.addParameter(SimulationHelper.DistributionType.FIXED, arrayList);
                simulatedField2.setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
            }
            Object object2 = dialogDataModel.getObject("IDS_MC_NAME_TYPE_VALUE_LABEL_TABLE");
            if (object2 != null) {
                simulatedField2.setValueLabels((IValueLabelMap)((ValueLabelMap)object2));
            }
            if (object == this.mEditFieldButton) {
                varListModel.setElementAt(n, (ISpssVariable)simulatedField2);
            } else {
                varListModel.addElement((ISpssVariable)simulatedField2);
            }
            newFieldNameAndTypeSubDlg.dispose();
        }
    }

    private Vector<String> getExistingVarNames() {
        Vector<String> vector = new Vector<String>();
        vector.addAll(this.mSrcVarNames);
        VarListModel varListModel = this.mTargetVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            String string = varListModel.getElementAt(i).getName();
            if (vector.contains(string)) continue;
            vector.add(string);
        }
        return vector;
    }

    private void deleteOneRow() {
        int n = this.mPlanTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = this.mPlanTable.getValueAt(n, 0).toString();
        String string2 = String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MC_ERROR_DELETE_EQUATION"), string);
        int n2 = SpssAlertOptionPane.showConfirmDialog(this, string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        if (n2 == 3) {
            return;
        }
        if (!this.isRowEmpty(n)) {
            this.mPlanTableModel.removeRow(n);
            Vector<SimulatedField> vector = this.deleteInputsFromSimulationTab(string);
            this.mTargetAndSimInputs.remove(string);
            this.mTargetsFromEquation.remove(string);
            this.mTargetAndComments.remove(string);
            if (n < this.mPlanTable.getRowCount()) {
                this.mPlanTable.setRowSelectionInterval(n, n);
                this.mPlanTable.setColumnSelectionInterval(0, 0);
            } else if (n - 1 >= 0) {
                this.mPlanTable.setRowSelectionInterval(n - 1, n - 1);
                this.mPlanTable.setColumnSelectionInterval(0, 0);
            }
            if (this.mPlanTable.getSelectedRowCount() == 0) {
                this.mDeletePlan.setEnabled(false);
                this.mEditPlan.setEnabled(false);
                this.mCopyPlan.setEnabled(false);
                this.mDownArrowButton.setEnabled(false);
                this.mUpArrowButton.setEnabled(false);
                this.mNewEquation.requestFocusInWindow();
            }
            ((MonteCarloSimulationDlg)this.mParent).removeInput(vector);
        }
    }

    Vector<SimulatedField> deleteInputsFromSimulationTab(String string) {
        Object object;
        Object object2;
        Object object4;
        Object[] objectArray = this.mTargetAndSimInputs.get(string);
        boolean[] blArray = new boolean[objectArray.length];
        int n = 0;
        for (n = 0; n < objectArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < this.mPlanTable.getRowCount(); ++n) {
            Object[] objectArray2;
            object4 = this.mPlanTable.getValueAt(n, 0).toString();
            if (((String)object4).equals(string)) continue;
            for (Object object3 : objectArray2 = this.mTargetAndSimInputs.get(object4)) {
                object2 = (SimulatedField)((Object)object3);
                object = object2.getName();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!object.equals(((SimulatedField)((Object)objectArray[i])).getName())) continue;
                    blArray[i] = true;
                }
            }
        }
        object4 = new Vector();
        for (int i = 0; i < objectArray.length; ++i) {
            if (blArray[i]) continue;
            SimulatedField simulatedField = (SimulatedField)((Object)objectArray[i]);
            ((Vector)object4).add(simulatedField);
        }
        DialogDataModel dialogDataModel = ((MonteCarloSimulationDlg)this.mParent).getDialogDataModel();
        Object[] objectArray2 = dialogDataModel.getArray("IDS_MC_EQUATION_SIM_ALL");
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < objectArray2.length; ++n) {
            Object object3;
            int n2 = 0;
            object3 = (ISpssVariable)objectArray2[n];
            object2 = ((Vector)object4).iterator();
            while (object2.hasNext()) {
                object = (SimulatedField)((Object)object2.next());
                if (!object.getName().equals(object3.getName()) && !string.equals(object3.getName())) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            vector.add(object3);
        }
        dialogDataModel.putArray("IDS_MC_EQUATION_SIM_ALL", vector.toArray());
        return object4;
    }

    private boolean checkModelSourceStatus(JRadioButton jRadioButton, JRadioButton jRadioButton2) {
        int n = SpssAlertOptionPane.showConfirmDialog(this, this.getResString("IDS_MC_MODEL_CHANGE_FROM_EQUATION_TO_MODEL"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
        if (n == 2) {
            jRadioButton2.setSelected(true);
            return false;
        }
        return true;
    }

    private void enableModelPMMLControls(boolean bl) {
        this.mModelBrowerButton.setEnabled(bl);
        this.mPathLabel.setEnabled(bl);
        this.mModelPmmlPath.setEnabled(bl);
        this.mTypeLabel.setEnabled(bl);
        this.mModelTypeField.setEnabled(bl);
        this.mInputLabel.setEnabled(bl);
        this.mModelInputField.setEnabled(bl);
        this.mTargetLabel.setEnabled(bl);
        this.mTargetField.setEnabled(bl);
        if (bl) {
            this.mModelInfoPanel.setBackground(this.mModelInputField.getBackground());
        } else {
            this.mModelInfoPanel.setBackground(this.mPathLabel.getBackground());
        }
    }

    private void enableEquationControls(boolean bl) {
        this.mNewEquation.setEnabled(bl);
        this.mEditPlan.setEnabled(bl);
        this.mCopyPlan.setEnabled(bl);
        this.mPlanTable.setEnabled(bl);
        this.mPlanTableLabel.setEnabled(bl);
        if (bl && this.mPlanTable.getSelectedRow() >= 0) {
            this.mDeletePlan.setEnabled(bl);
            this.mEditPlan.setEnabled(bl);
            this.mCopyPlan.setEnabled(bl);
        } else {
            this.mDeletePlan.setEnabled(false);
            this.mEditPlan.setEnabled(false);
            this.mCopyPlan.setEnabled(false);
        }
    }

    private void enableCreateDataControls(boolean bl) {
        this.mSrcVarList.setEnabled(bl);
        this.mSourceListLabel.setEnabled(bl);
        this.mTargetVarList.setEnabled(bl);
        this.mTargetListLabel.setEnabled(bl);
        this.mArrowButton.setEnabled(bl);
        this.mNewFieldButton.setEnabled(bl);
        if (bl && (this.mTargetVarList.getModel().getSize() == 0 || this.mTargetVarList.getSelectedIndex() < 0)) {
            this.mEditFieldButton.setEnabled(false);
            this.mDeleteFieldButton.setEnabled(false);
        } else {
            this.mEditFieldButton.setEnabled(bl);
            this.mDeleteFieldButton.setEnabled(bl);
        }
    }

    private void runNewEquationSub(int n) {
        String string;
        String string2;
        EquationSubDlg equationSubDlg;
        DialogDataModel dialogDataModel = ((MonteCarloSimulationDlg)this.mParent).getDialogDataModel();
        dialogDataModel.putArray("IDS_MC_USED_SIM_FIELD", null);
        if (n < 0) {
            equationSubDlg = new EquationSubDlg((MonteCarloSimulationDlg)this.mParent);
        } else {
            String string3 = this.mPlanTableModel.getValueAt(n, 0).toString();
            string2 = this.mPlanTableModel.getValueAt(n, 1).toString();
            string = "";
            if (this.mPlanTableModel.getValueAt(n, 3) != null) {
                string = this.mPlanTableModel.getValueAt(n, 3).toString();
            }
            equationSubDlg = new EquationSubDlg((MonteCarloSimulationDlg)this.mParent, string3, string2, string, this.mTargetsFromEquation.get(string3));
        }
        boolean bl = ((MonteCarloSimulationDlg)this.mParent).runSubDialog(equationSubDlg);
        FunctionList.getInstance();
        FunctionList.reset();
        if (bl) {
            dialogDataModel = ((MonteCarloSimulationDlg)this.mParent).getDialogDataModel();
            string2 = dialogDataModel.getString("IDS_MC_TARGET_FIELD_STRING");
            string = dialogDataModel.getString("IDS_MC_INPUT_FIELD_STRING");
            String string4 = dialogDataModel.getString("IDS_MC_EQUATION_COMMEMENTS");
            Object[] objectArray = dialogDataModel.getArray("IDS_MC_USED_SIM_FIELD");
            Object object = dialogDataModel.getObject("IDS_MC_TARGET_FIELD_VARIABLE");
            if (string2.length() > 0) {
                this.mTargetAndSimInputs.put(string2, objectArray);
                if (object != null) {
                    this.mTargetsFromEquation.put(string2, (SimulatedField)((Object)object));
                    if (string4 != null && string4.length() > 0) {
                        this.mTargetAndComments.put(string2, string4);
                    }
                }
                if (n >= 0) {
                    this.updateEquationToPlanTable(string2, dialogDataModel.getString("IDS_MC_EQUATION_FIELD_STRING"), string, string4, n);
                } else {
                    this.addOneEquationToPlanTable(string2, dialogDataModel.getString("IDS_MC_EQUATION_FIELD_STRING"), string, string4);
                }
                ((MonteCarloSimulationDlg)this.mParent).updateSimulationTab(objectArray, this.mTargetAndSimInputs, this.mTargetsFromEquation);
            }
        }
    }

    private void addOneEquationToPlanTable(String string, String string2, String string3, String string4) {
        int n = this.mPlanTableModel.getRowCount() - 1;
        Vector<String> vector = new Vector<String>();
        vector.add(0, string);
        vector.add(1, string2);
        vector.add(2, string3);
        vector.add(3, string4);
        if (this.isRowEmpty(n)) {
            this.mPlanTableModel.removeRow(n);
            this.mPlanTableModel.insertRow(n, vector);
        } else {
            this.mPlanTableModel.addRow(vector);
        }
        this.mPlanTable.setModel(this.mPlanTableModel);
    }

    private void updateEquationToPlanTable(String string, String string2, String string3, String string4, int n) {
        Vector<String> vector = new Vector<String>();
        vector.add(0, string);
        vector.add(1, string2);
        vector.add(2, string3);
        vector.add(3, string4);
        this.mPlanTableModel.removeRow(n);
        this.mPlanTableModel.insertRow(n, vector);
        this.mPlanTable.setModel(this.mPlanTableModel);
    }

    private boolean isRowEmpty(int n) {
        return n >= 0 && n < this.mPlanTable.getRowCount() && (this.mPlanTableModel.getValueAt(n, 0) == null || this.mPlanTableModel.getValueAt(n, 0).toString().length() == 0);
    }

    void updateCreateDataTargetList(ArrayList<SimulatedField> arrayList) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mTargetListModel.removeAll();
        for (int i = 0; i < arrayList.size(); ++i) {
            SimulatedField simulatedField = arrayList.get(i);
            String string = simulatedField.getName();
            int n = iSpssDataSrc.findVarIndex(string);
            if (n >= 0) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
                this.mTargetListModel.addElement(iSpssVariable);
                this.mSrcVarList.getModel().removeElement(iSpssVariable);
                continue;
            }
            this.mTargetListModel.addElement((ISpssVariable)simulatedField);
        }
    }

    void runPMMLModelHandler(String string) {
        this.runPMMLModelHandler(string, "");
    }

    void runPMMLModelHandler(String string, String string2) {
        ModelPMMLFileHandler modelPMMLFileHandler = new ModelPMMLFileHandler(string + string2);
        if (this.mTargetFromModel != null && string2.length() == 0 && !this.isPMMLModelMatch(modelPMMLFileHandler)) {
            int n = SpssAlertOptionPane.showConfirmDialog(this, this.getResString("IDS_MC_MODEL_PMML_NOT_MATCH"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n == 2) {
                return;
            }
            ((MonteCarloSimulationDlg)this.mParent).reset();
        }
        if (modelPMMLFileHandler.getErrorMessage().length() == 0) {
            ArrayList<String> arrayList = modelPMMLFileHandler.getInputFieldNames();
            String string3 = modelPMMLFileHandler.createFieldNamesText(arrayList);
            ArrayList<String> arrayList2 = modelPMMLFileHandler.getTargetFieldNames();
            String string4 = modelPMMLFileHandler.createFieldNamesText(arrayList2);
            String string5 = modelPMMLFileHandler.getModelTypeName();
            this.mTargetFromModel = modelPMMLFileHandler.getTargets();
            this.mInputsFromModel = modelPMMLFileHandler.getSimulatedPredictors();
            String string6 = string2;
            if (string6.length() == 0) {
                string6 = string;
            }
            this.updateModelInfo(string3, string5, string6, string4);
            if (string2.length() == 0) {
                MonteCarloSimulationDlg monteCarloSimulationDlg = (MonteCarloSimulationDlg)this.mParent;
                monteCarloSimulationDlg.reloadSimulationTab(modelPMMLFileHandler.getSimulatedPredictors(), modelPMMLFileHandler.getTargets());
                monteCarloSimulationDlg.reloadCorrelation(modelPMMLFileHandler.getCorrelationMatrix());
            }
        } else {
            String string7 = modelPMMLFileHandler.getErrorMessage();
            String string8 = this.getResString(string7);
            if (string8.length() == 0) {
                string8 = string7;
            }
            SpssAlertOptionPane.showWarningMessageDialog(this, string8, VersionInfo.getAppVersionString());
        }
    }

    void setTargetAndInputsFromModelPMML(ArrayList<SimulatedField> arrayList, ArrayList<SimulatedField> arrayList2) {
        this.mTargetFromModel = arrayList;
        this.mInputsFromModel = arrayList2;
    }

    private boolean isPMMLModelMatch(ModelPMMLFileHandler modelPMMLFileHandler) {
        if (this.mModelTypeField.getText().length() == 0) {
            return true;
        }
        boolean bl = modelPMMLFileHandler.getModelTypeName().equals(this.mModelTypeField.getText());
        if (!bl) {
            return bl;
        }
        ArrayList<SimulatedField> arrayList = modelPMMLFileHandler.getTargets();
        bl = this.areTwoListMatch(arrayList, this.mTargetFromModel);
        if (!bl) {
            return bl;
        }
        bl = this.areTwoListMatch(modelPMMLFileHandler.getSimulatedPredictors(), this.mInputsFromModel);
        if (!bl) {
            return bl;
        }
        return bl;
    }

    private boolean areTwoListMatch(ArrayList<SimulatedField> arrayList, ArrayList<SimulatedField> arrayList2) {
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SimulatedField simulatedField = arrayList.get(i);
            boolean bl = false;
            for (int j = 0; j < arrayList2.size(); ++j) {
                SimulatedField simulatedField2 = arrayList2.get(j);
                if (!simulatedField.getName().equals(simulatedField2.getName())) continue;
                bl = true;
                bl = simulatedField.getMeasurementLevel() == simulatedField2.getMeasurementLevel() && simulatedField.getFormat() == simulatedField2.getFormat();
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    void updatePlanTable(SimulationPlanHandler simulationPlanHandler) {
        try {
            Object object;
            if (simulationPlanHandler == null) {
                this.mPlanTableModel.getDataVector().clear();
                return;
            }
            this.mTargetAndEquations = new ArrayList();
            String string = simulationPlanHandler.getModelFiles().get(0).getFileName();
            String string2 = PrefsMgr.getPrefsMgr().getTempPath();
            File file = new File(string2 + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                return;
            }
            String string4 = SysFileProxy.getSysFileProxy().convertPmmlToSyntax(string3, false, true);
            String string5 = ".\n";
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            int n2 = 0;
            int n3 = string4.length();
            int n4 = 0;
            Vector<String> vector = new Vector<String>();
            while (n < n3) {
                if (string4.startsWith("\n**", n) && (n2 = string4.indexOf(46, n)) > 0) {
                    vector.add(string4.substring(n + 3, n2));
                    n = n2 + 1;
                }
                if (n >= n3) break;
                if (string4.charAt(n) == '\n') {
                    ++n;
                }
                if ((n2 = string4.indexOf(string5, n)) < 0) break;
                string3 = string4.substring(n, n2);
                if (string3.length() > 0 && string3.startsWith(MC_COMPUTE)) {
                    arrayList.add(n4++, string3);
                }
                n = n2 + 1;
            }
            if (arrayList.size() == 0) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String string6 = ((String)arrayList.get(i)).substring(MC_COMPUTE.length());
                n4 = string6.indexOf("=");
                object = string6.substring(0, n4).trim();
                String string7 = string6.substring(n4 + 1);
                this.mTargetAndEquations.add(i, (Pair<String, String>)new Pair(object, (Object)string7));
            }
            Hashtable<String, String> hashtable = this.parsingInputs(vector, simulationPlanHandler);
            this.fillTargetInfo(simulationPlanHandler.getTargets());
            this.mPlanTableModel.getDataVector().clear();
            for (int i = 0; i < this.mTargetAndEquations.size(); ++i) {
                object = new Vector();
                Pair<String, String> pair = this.mTargetAndEquations.get(i);
                ((Vector)object).add(0, pair.getFirst());
                ((Vector)object).add(1, pair.getSecond());
                ((Vector)object).add(2, hashtable.get(pair.getFirst()));
                String string8 = this.mTargetAndComments.get(pair.getFirst());
                if (string8 == null) {
                    string8 = "";
                }
                ((Vector)object).add(3, string8);
                this.mPlanTableModel.addRow((Vector<?>)object);
            }
            this.mPlanTable.setModel(this.mPlanTableModel);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fillTargetInfo(ArrayList<SimulationPlanHandler.TargetField> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        if (this.mTargetsFromEquation == null) {
            this.mTargetsFromEquation = new Hashtable();
        }
        if (this.mTargetAndComments == null) {
            this.mTargetAndComments = new Hashtable();
        }
        for (SimulationPlanHandler.TargetField targetField : arrayList) {
            SimulatedField simulatedField = new SimulatedField(targetField.getName());
            simulatedField.setExcludeFromOutput(simulatedField.isExcludeFromOutput());
            simulatedField.setOutputFormat(targetField.getOutputFormat());
            simulatedField.setMeasurementLevel(MeasurementLevel.scale);
            simulatedField.setRole(Role.target);
            this.mTargetsFromEquation.put(targetField.getName(), simulatedField);
            this.mTargetAndComments.put(targetField.getName(), targetField.getComment());
        }
    }

    void setSimFields(ArrayList<SimulatedField> arrayList) {
    }

    private Hashtable<String, String> parsingInputs(Vector<String> vector, SimulationPlanHandler simulationPlanHandler) {
        ArrayList<SimulatedField> arrayList = simulationPlanHandler.getSimulatedPredictors();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        int n2 = 0;
        String string = "";
        String string2 = "";
        for (int i = 0; i < vector.size(); ++i) {
            string2 = "";
            String string3 = vector.get(i);
            String string4 = " Target - ";
            n = string3.indexOf(string4);
            n2 = string3.indexOf(44, n);
            string = string3.substring(n + string4.length(), n2).trim();
            string4 = "Inputs -";
            n = string3.indexOf(string4, n2);
            n2 = string3.length();
            if (n <= 0 || n2 <= 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(n + string4.length(), n2));
            int n3 = stringTokenizer.countTokens();
            SimulatedField[] simulatedFieldArray = new SimulatedField[n3];
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                SimulatedField simulatedField = new SimulatedField(string5);
                for (SimulatedField simulatedField2 : arrayList) {
                    if (!string5.equalsIgnoreCase(simulatedField2.getName())) continue;
                    simulatedField.setMeasurementLevel(simulatedField2.getMeasurementLevel());
                    simulatedField.setType(simulatedField2.getType());
                    break;
                }
                simulatedFieldArray[n4++] = simulatedField;
                string2 = string2 + string5;
                if (n4 >= n3) continue;
                string2 = string2 + ",";
            }
            hashtable.put(string, string2);
            this.mTargetAndSimInputs.put(string, (Object[])simulatedFieldArray);
        }
        return hashtable;
    }

    void updateModelInfo(String string, String string2, String string3, String string4) {
        this.mModelPmmlPath.setText(string3);
        this.mModelTypeField.setText(string2);
        this.mModelInputField.setText(string);
        this.mTargetField.setText(string4);
    }

    private void initialize(TableType tableType) {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        DialogUtil.addUsingGBL(jPanel, this.mModelSource, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLoadModelFile, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this.mModelInfoPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mPathLabel, this.mModelPmmlPath}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelInfoPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mTypeLabel, this.mModelTypeField}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelInfoPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mTargetLabel, this.mTargetField}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelInfoPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mInputLabel, this.mModelInputField}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n2 * 5, 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mModelInfoPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 5, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mModelBrowerButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, n2, n2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mEquationButton, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mArrowPanel = this.getArrowButtonPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = tableType == TableType.CREATE_DATA ? 0.0 : 1.0;
        insets.set(2, n2 * 5, n2, n2);
        this.mPlanPanel = MonteCarloSimulationDlg.setupTablePanel(this.mPlanTable, this.mPlanTableLabel, new JButton[]{this.mNewEquation, this.mEditPlan, this.mCopyPlan, this.mDeletePlan}, this.mArrowPanel);
        DialogUtil.addUsingGBL(jPanel, this.mPlanPanel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        this.addCreateDataPanel(jPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n2, 2, 0);
        Dimension dimension = jPanel.getPreferredSize();
        if (dimension.height > 600) {
            jPanel.setPreferredSize(MCSimulationTab.sMinPanelSize);
        }
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults(tableType);
        this.setFocusTraversalPolicy();
    }

    private JPanel getArrowButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, 0, 0, 0);
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mUpArrowButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mDownArrowButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void insertOneRowAfter(int n) {
        Object object;
        if (this.isRowEmpty(n)) {
            return;
        }
        int n2 = n + 1;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mPlanTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        Vector vector2 = vector.get(n);
        Vector<String> vector3 = new Vector<String>();
        this.getResString("");
        String string = vector2.get(0).toString();
        String string2 = String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MC_DUPLICATE_EQUATION_COMMENTS"), string);
        String string3 = "";
        for (int i = 0; i < vector2.size(); ++i) {
            object = vector2.get(i).toString();
            if (i == 0) {
                string3 = this.getNextTargetName((String)object);
                vector3.add(i, string3);
                continue;
            }
            if (i == 3) {
                vector3.add(i, (String)object + string2);
                continue;
            }
            vector3.add(i, vector2.get(i).toString());
        }
        this.mTargetAndSimInputs.put(string3, this.mTargetAndSimInputs.get(string));
        SimulatedField simulatedField = this.mTargetsFromEquation.get(string);
        if (simulatedField != null) {
            object = new SimulatedField(string3);
            object.setRole(simulatedField.getRole());
            object.setValueLabels(simulatedField.getValueLabels());
            ((SimulatedField)((Object)object)).setExcludeFromOutput(simulatedField.isExcludeFromOutput());
            object.setMeasurementLevel(simulatedField.getMeasurementLevel());
            this.mTargetsFromEquation.put(string3, (SimulatedField)((Object)object));
            String string4 = this.mTargetAndComments.get(string);
            this.mTargetAndComments.put(string3, string4 + string2);
        }
        defaultTableModel.insertRow(n2, vector3);
        this.mPlanTable.getSelectionModel().setSelectionInterval(n2, n2);
    }

    private String getNextTargetName(String string) {
        int n = 1;
        String string2 = string + "_" + n;
        while (this.mTargetAndSimInputs.get(string2) != null) {
            string2 = string + "_" + ++n;
        }
        return string2;
    }

    private void manipulateDown(int n) {
        int n2 = n + 2;
        int n3 = n;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mPlanTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        Vector vector2 = vector.get(n);
        defaultTableModel.insertRow(n2, vector2);
        defaultTableModel.removeRow(n3);
        this.mPlanTable.getSelectionModel().setSelectionInterval(n2, n2 - 1);
    }

    private void manipulateUp(int n) {
        int n2 = n - 1;
        int n3 = n + 1;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mPlanTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        Vector vector2 = vector.get(n);
        defaultTableModel.insertRow(n2, vector2);
        defaultTableModel.removeRow(n3);
        this.mPlanTable.getSelectionModel().setSelectionInterval(n2, n2);
    }

    @Override
    protected void aboutToShowTab() {
        if (this.mPlanTable != null) {
            if (this.mPlanTable.getModel().getRowCount() == 0) {
                this.addOneEquationToPlanTable("", "", "", "");
            }
            SimulationHelper.setupColumnWidths(this.mPlanTable, new double[]{0.2, 0.4, 0.2, 0.2});
        }
    }

    private void initVars() {
        this.mModelInfoPanel = PanelFactory.getEmptyPanel("");
        this.mModelInfoPanel.setBorder(new TitledBorder(""));
        this.mModelSource = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_TAB_MODEL_SOURCE_LABEL");
        this.mLoadModelFile = DialogUtil.createRadioButton(this.mParent, "IDS_MC_LOAD_MODEL_FILE_BUTTON", null);
        this.mLoadModelFile.addActionListener(this);
        this.mEquationButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_MODEL_ENTER_EQUATION_BUTTON", null);
        this.mEquationButton.addActionListener(this);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mLoadModelFile);
        this.mGroup.add(this.mEquationButton);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_MODEL_PMML_BROWER_BUTTON");
        this.mModelBrowerButton = new JButton(toggleButtonAction);
        this.mModelBrowerButton.addActionListener(this);
        this.mCreateDataButton = DialogUtil.createRadioButton(this.mParent, "IDS_MC_MODEL_CREATE_DATA_BUTTON", null);
        this.mCreateDataButton.addActionListener(this);
        this.mPathLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_PATH_LABEL");
        this.mModelPmmlPath = new FileTextField(true);
        this.mModelPmmlPath.setOpaque(false);
        this.mModelPmmlPath.setBorder(BorderFactory.createEmptyBorder());
        this.mModelPmmlPath.setColumns(40);
        this.mModelPmmlPath.setAction(new TextFieldAction(this.mParent, NEW_MODEL_PMML_FILE_PATH));
        this.mPathLabel.setLabelFor((Component)((Object)this.mModelPmmlPath));
        this.mTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_MODEL_LABEL");
        this.mModelTypeField = new StringTextField();
        this.mModelTypeField.setEnabled(true);
        this.mModelTypeField.setEditable(false);
        this.mModelTypeField.setOpaque(false);
        this.mModelTypeField.setAction(new TextFieldAction(this.mParent, NEW_MODEL_PMML_FILE_TYPE));
        this.mModelTypeField.setBorder(BorderFactory.createEmptyBorder());
        this.mTypeLabel.setLabelFor((Component)((Object)this.mModelTypeField));
        this.mInputLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_INPUTS_LABEL");
        this.mModelInputField = new StringTextField(40);
        this.mModelInputField.setEnabled(true);
        this.mModelInputField.setFocusable(true);
        this.mModelInputField.setEditable(false);
        this.mModelInputField.setOpaque(false);
        this.mModelInputField.setBorder(BorderFactory.createEmptyBorder());
        this.mInputLabel.setLabelFor((Component)((Object)this.mModelInputField));
        this.mTargetLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_TARGET_LABEL");
        this.mTargetField = new StringTextField(40);
        this.mTargetField.setFocusable(true);
        this.mTargetField.setEnabled(true);
        this.mTargetField.setEditable(false);
        this.mTargetField.setOpaque(false);
        this.mTargetField.setBorder(BorderFactory.createEmptyBorder());
        this.mTargetLabel.setLabelFor((Component)((Object)this.mTargetField));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_MC_NEW_EQUATION_BUTTON");
        this.mNewEquation = new JButton(toggleButtonAction);
        this.mNewEquation.addActionListener(this);
        Dimension dimension = this.mNewEquation.getPreferredSize();
        this.mEditPlan = DialogUtil.createButton(this.mParent, "IDS_MC_MODEL_EDIT_BUTTON", null);
        this.mEditPlan.setEnabled(false);
        this.mEditPlan.addActionListener(this);
        this.mEditPlan.setPreferredSize(dimension);
        this.mCopyPlan = DialogUtil.createButton(this.mParent, "IDS_MC_MODEL_COPY_BUTTON", null);
        this.mCopyPlan.setEnabled(false);
        this.mCopyPlan.addActionListener(this);
        this.mCopyPlan.setPreferredSize(dimension);
        this.mDeletePlan = DialogUtil.createButton(this.mParent, "IDS_MC_MODEL_DELETE_BUTTON", null);
        this.mDeletePlan.setEnabled(false);
        this.mDeletePlan.addActionListener(this);
        this.mDeletePlan.setPreferredSize(dimension);
        this.mPlanTableLabel = DialogUtil.createLabel(this.mParent, "IDS_MC_MODEL_EQUATION_TABLE_LABEL");
        this.mPlanTableLabel.setLabelFor(this.mPlanTable);
        Vector vector = new Vector();
        this.mPlaneTableHeaderNames = this.getResStringArray("IDS_MC_EQUATION_TABLE_HEADER_ARRARY");
        this.mPlanTableModel = new DefaultTableModel(this.mPlaneTableHeaderNames, 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 3;
            }
        };
        this.mPlanTable = new PlainTable(this.mPlanTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return MCModelTab.this.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_SUMMARY_TOOLTIP_TEXT");
            }
        };
        this.mPlanTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = MCModelTab.this.mPlanTable.getSelectedColumn();
                int n2 = MCModelTab.this.mPlanTable.getSelectedRow();
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    if (MCModelTab.this.isRowEmpty(n2)) {
                        MCModelTab.this.runNewEquationSub(-1);
                    } else {
                        MCModelTab.this.runNewEquationSub(n2);
                    }
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MCModelTab.this.deleteOneRow();
            }
        };
        this.mPlanTable.getActionMap().put(DELETE_KEY, abstractAction);
        this.mPlanTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), DELETE_KEY);
        this.mPlanTable.setRowHeight(22);
        this.mPlanTable.setColumnSelectionAllowed(false);
        this.mPlanTable.setRowSelectionAllowed(true);
        this.mPlanTable.setSelectionMode(0);
        this.mPlanTable.getTableHeader().setReorderingAllowed(false);
        this.mPlanTable.getTableHeader().setResizingAllowed(true);
        this.mPlanTable.setGridColor(Color.darkGray);
        this.mPlanTable.getTableHeader().setReorderingAllowed(false);
        this.mUpArrowButton = new ArrowButton();
        this.mUpArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.up);
        this.mUpArrowButton.addActionListener(this);
        this.mUpArrowButton.setEnabled(false);
        this.mDownArrowButton = new ArrowButton();
        this.mDownArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.down);
        this.mDownArrowButton.addActionListener(this);
        this.mDownArrowButton.setEnabled(false);
        this.mUpArrowButton.getAccessibleContext().setAccessibleDescription(ResUtil.getCommonDlgString("TXT_MOVE_UP_MESSAGE"));
        this.mDownArrowButton.getAccessibleContext().setAccessibleDescription(ResUtil.getCommonDlgString("TXT_MOVE_DOWN_MESSAGE"));
        ListTravArrowButtonGroup listTravArrowButtonGroup = new ListTravArrowButtonGroup();
        listTravArrowButtonGroup.add(this.mUpArrowButton);
        listTravArrowButtonGroup.add(this.mDownArrowButton);
        this.mTableRender = new DisplayTableRenderer(this.mUpArrowButton, this.mDownArrowButton);
        this.mPlanTable.getColumnModel().getColumn(0).setCellRenderer(this.mTableRender);
        this.mPlanTable.getColumnModel().getColumn(1).setCellRenderer(this.mTableRender);
        this.mPlanTable.getColumnModel().getColumn(2).setCellRenderer(this.mTableRender);
        this.mPlanTable.getColumnModel().getColumn(3).setCellRenderer(this.mTableRender);
    }

    private void setDefaults(TableType tableType) {
        if (tableType == TableType.EQUATION) {
            this.mEquationButton.setSelected(true);
            this.mLoadModelFile.setSelected(false);
            this.enableModelPMMLControls(false);
            this.enableEquationControls(true);
        } else if (tableType == TableType.MODEL) {
            this.mLoadModelFile.setSelected(true);
            this.mEquationButton.setSelected(false);
            this.enableModelPMMLControls(true);
            this.enableEquationControls(false);
        } else {
            this.enableCreateDataControls(true);
            this.enableModelPMMLControls(false);
            this.enableEquationControls(false);
        }
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        if (this.mLoadModelFile.isSelected()) {
            return this.mLoadModelFile;
        }
        return this.mEquationButton;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mLoadModelFile);
        vector.add(this.mModelPmmlPath);
        vector.add(this.mModelTypeField);
        vector.add(this.mTargetField);
        vector.add(this.mModelInputField);
        vector.add(this.mModelBrowerButton);
        vector.add(this.mEquationButton);
        vector.add(this.mNewEquation);
        vector.add(this.mEditPlan);
        vector.add(this.mCopyPlan);
        vector.add(this.mDeletePlan);
        vector.add(this.mUpArrowButton);
        vector.add(this.mDownArrowButton);
        vector.add(this.mPlanTable);
        vector.add(this.mCreateDataButton);
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mNewFieldButton);
        vector.add(this.mEditFieldButton);
        vector.add(this.mDeleteFieldButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    private void deleteOnesimulatedField() {
        int n = this.mTargetVarList.getSelectedIndex();
        if (n >= 0) {
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(n);
            String string = iSpssVariable.getName();
            ((MonteCarloSimulationDlg)this.mParent).removeOneInput(string);
            this.mTargetVarList.getModel().removeElementAt(n);
            if (!(iSpssVariable instanceof SimulatedField)) {
                this.mSrcVarList.getModel().addElement(iSpssVariable);
            }
            this.removeFixedDefaultValue(string);
            this.enableTargetListButtons();
        }
    }

    private void enableTargetListButtons() {
        int n = this.mTargetVarList.getSelectedIndex();
        if (n != -1) {
            this.mSrcVarList.clearSelection();
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(n);
            if (iSpssVariable instanceof SimulatedField) {
                this.mArrowButton.setEnabled(false);
                this.mDeleteFieldButton.setEnabled(true);
                this.mEditFieldButton.setEnabled(true);
            } else {
                this.mArrowButton.setEnabled(true);
                this.mDeleteFieldButton.setEnabled(false);
                this.mEditFieldButton.setEnabled(false);
            }
        } else {
            this.mDeleteFieldButton.setEnabled(false);
            this.mEditFieldButton.setEnabled(false);
        }
    }

    private void removeFixedDefaultValue(String string) {
        Object object = this.mFixedFieldDefaultValues.get(string);
        if (object != null) {
            this.mFixedFieldDefaultValues.remove(string);
        }
    }

    private String getFixedDefaultValue(ISpssVariable iSpssVariable) {
        if (iSpssVariable == null) {
            return "";
        }
        Object object = this.mFixedFieldDefaultValues.get(iSpssVariable.getName());
        if (object != null) {
            return (String)object;
        }
        return "";
    }

    class SimDoubleClickHandler
    extends MouseAdapter {
        SimDoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ISpssVariable iSpssVariable;
            int n;
            if (MCModelTab.this.mTargetVarList.isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = MCModelTab.this.mTargetVarList.getSelectedIndex()) >= 0 && (iSpssVariable = MCModelTab.this.mTargetVarList.getModel().getElementAt(n)) instanceof SimulatedField) {
                MCModelTab.this.deleteOnesimulatedField();
            }
        }
    }

    class MCTargetVarListModel
    extends VarListModel {
        MCTargetVarListModel(VariableList variableList) {
            super(variableList);
        }

        @Override
        public boolean removeElement(ISpssVariable iSpssVariable) {
            int n = this.mVariables.indexOf(iSpssVariable);
            if (n >= 0) {
                ((MonteCarloSimulationDlg)MCModelTab.this.mParent).removeOneInput(iSpssVariable.getName());
            }
            boolean bl = this.mVariables.removeElement(iSpssVariable);
            if (n >= 0) {
                this.fireIntervalRemoved(this, n, n);
            }
            return bl;
        }
    }

    class DisplayTableRenderer
    extends DefaultTableCellRenderer {
        private ArrowButton mUpArrow;
        private ArrowButton mDownArrow;

        public DisplayTableRenderer(ArrowButton arrowButton, ArrowButton arrowButton2) {
            this.mUpArrow = arrowButton;
            this.mDownArrow = arrowButton2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.isEnabled() && jTable.getRowCount() > 0) {
                if (bl) {
                    if (jTable.getRowCount() == 1) {
                        this.mUpArrow.setEnabled(false);
                        this.mDownArrow.setEnabled(false);
                    } else if (n == 0) {
                        this.mUpArrow.setEnabled(false);
                        this.mDownArrow.setEnabled(true);
                    } else if (n == jTable.getRowCount() - 1) {
                        this.mUpArrow.setEnabled(true);
                        this.mDownArrow.setEnabled(false);
                    } else {
                        this.mUpArrow.setEnabled(true);
                        this.mDownArrow.setEnabled(true);
                    }
                    MCModelTab.this.mDeletePlan.setEnabled(true);
                    MCModelTab.this.mEditPlan.setEnabled(true);
                    MCModelTab.this.mCopyPlan.setEnabled(true);
                }
            } else {
                MCModelTab.this.mDeletePlan.setEnabled(false);
                MCModelTab.this.mEditPlan.setEnabled(false);
                MCModelTab.this.mCopyPlan.setEnabled(false);
                this.mDownArrow.setEnabled(false);
                this.mUpArrow.setEnabled(false);
            }
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                return super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class SimulatedFieldTargetHandler
    implements IVarMoveHandler {
        SimulatedFieldTargetHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            return true;
        }
    }

    public static enum TableType {
        MODEL,
        EQUATION,
        CREATE_DATA;

    }
}

