/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.shared.core_tools.utils.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class FitStatistics {
    private String mDistName;
    private SimulationHelper.DistributionType mDistType;
    private ArrayList<Pair<String, String>> mParamAndValues;
    public TreeMap<String, Pair<Double, Double>> mFitValueAndP;
    public Vector<String> mFitFunctionNames;

    public FitStatistics(String string, SimulationHelper.DistributionType distributionType) {
        this.mDistName = string;
        this.mDistType = distributionType;
        this.mParamAndValues = new ArrayList();
        this.mFitValueAndP = new TreeMap();
        this.mFitFunctionNames = new Vector();
    }

    public boolean equals(Object object) {
        if (object instanceof FitStatistics) {
            return this.mDistType == ((FitStatistics)object).getDistType();
        }
        return false;
    }

    public void addOneParamAndValue(String string, String string2) {
        this.mParamAndValues.add(this.mParamAndValues.size(), (Pair<String, String>)new Pair((Object)string, (Object)string2));
    }

    public ArrayList<Pair<String, String>> getAllFittedParamAndValues() {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < this.mParamAndValues.size(); ++i) {
            Pair<String, String> pair = this.mParamAndValues.get(i);
            Pair pair2 = new Pair(pair.getFirst(), pair.getSecond());
            arrayList.add(i, (Pair<String, String>)pair2);
        }
        return arrayList;
    }

    public void addFitFunctionNameAndValue(String string, double d, double d2) {
        this.mFitValueAndP.put(string, (Pair<Double, Double>)new Pair((Object)new Double(d), (Object)new Double(d2)));
        this.mFitFunctionNames.add(this.mFitFunctionNames.size(), string);
    }

    public TreeMap<String, Pair<Double, Double>> getFittedValues() {
        return this.mFitValueAndP;
    }

    public String getDistName() {
        return this.mDistName;
    }

    public SimulationHelper.DistributionType getDistType() {
        return this.mDistType;
    }

    public String getFitStatisString() {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set = this.mFitValueAndP.keySet();
        if (set.size() == 0) {
            return "";
        }
        Iterator<String> iterator = set.iterator();
        int n = 0;
        for (int i = 0; i < this.mFitFunctionNames.size(); ++i) {
            Pair<Double, Double> pair;
            String string = this.mFitFunctionNames.get(i);
            if (n > 0) {
                stringBuffer.append("(");
            }
            if (string.length() > 0) {
                stringBuffer.append(string.charAt(0) + "=");
            }
            if ((Double)(pair = this.mFitValueAndP.get(string)).getFirst() == Double.MAX_VALUE) {
                stringBuffer.append(".");
            } else {
                stringBuffer.append(MonteCarloSimulationDlg.formatDoubleValue((Double)pair.getFirst(), 2));
            }
            stringBuffer.append(" P=");
            if ((Double)pair.getSecond() == Double.MAX_VALUE) {
                stringBuffer.append(".");
            } else {
                stringBuffer.append(MonteCarloSimulationDlg.formatDoubleValue((Double)pair.getSecond(), 2));
            }
            if (n > 0) {
                stringBuffer.append(")");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getParameterString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mParamAndValues.size(); ++i) {
            Pair<String, String> pair = this.mParamAndValues.get(i);
            stringBuffer.append((String)pair.getFirst());
            stringBuffer.append("=");
            String string = (String)pair.getSecond();
            try {
                stringBuffer.append(MonteCarloSimulationDlg.formatDoubleValue(Double.parseDouble(string), 2) + " ");
                continue;
            }
            catch (Exception exception) {
                stringBuffer.append(string + " ");
            }
        }
        return stringBuffer.toString();
    }
}

