/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.MC.BaseMCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.FitDetailTableItem;
import com.spss.java_client.ui.dialogs.MC.FitDetailTableModel;
import com.spss.java_client.ui.dialogs.MC.FitStatistics;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.shared.core_tools.utils.ZipUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FitSelectSubDlg
extends BaseSubDialog
implements ActionListener {
    private String mNotFit;
    private String mCannotFit;
    private int mIndexInSimulatedTable;
    HashMap<String, SimulationHelper.DistributionType> sDistNameTypeMap = null;
    HashMap<SimulationHelper.DistributionType, String> sDistTypeNameMap = null;
    public static final Dimension mImageSize = new Dimension(270, 110);
    private static String[] FITTED_COMBO_ARRAY;
    private SimulatedField mSelectedField;
    private JLabel mFieldToFitLabel;
    private StringTextField mFitNameField;
    private JButton mFitButton;
    private JLabel mFittedDistrTableLabel;
    private PlainTable mFittedDistrTable;
    private FitDetailTableModel mFittedDistrTableModel;
    private ImagePanel mImagePanel;
    private SimulationHelper.PreviewCanvas mCanvas;
    private SimulationHelper.HelpPanel mInfoPanel;
    private JLabel mMLeveLabel;
    private JComboBox mMLevelCombo;
    private Vector<SimulationHelper.DistributionType> mFittedDistTypes;
    private Vector<SimulationHelper.DistributionType> mCurrentDistTypes;
    private Vector<String> mDistNameToShow = new Vector();
    private BaseMCSimulationTab.ScannedVar mScannedVar;
    private boolean mRefitClicked;
    private Hashtable<SimulationHelper.DistributionType, ArrayList<Pair<String, String>>> mDistParameters;
    Border mEmptyBorder = BorderFactory.createEmptyBorder();
    Border mHighLightBorder = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");

    public FitSelectSubDlg(MonteCarloSimulationDlg monteCarloSimulationDlg, SimulatedField simulatedField, int n, BaseMCSimulationTab.ScannedVar scannedVar) {
        super(monteCarloSimulationDlg, monteCarloSimulationDlg.getResString("IDS_MC_FIT_SELECTED_TITLE"), true);
        this.mIndexInSimulatedTable = n;
        this.mSelectedField = simulatedField;
        this.mScannedVar = scannedVar;
        this.mRefitClicked = false;
        this.mNotFit = monteCarloSimulationDlg.getResString("IDS_MC_FIT_SELECTED_NOT_FIT");
        this.mCannotFit = monteCarloSimulationDlg.getResString("IDS_MC_FIT_SELECTED_CANNOT_BE_FIT");
        this.mDistParameters = new Hashtable();
        this.sDistNameTypeMap = SimulationHelper.buildDistributionNameTypeMap();
        this.sDistTypeNameMap = SimulationHelper.buildDistributionTypeNameMap();
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mFitButton) {
            this.runRefit();
            this.updateContinueButton();
        } else if (object == this.mMLevelCombo) {
            int n = this.mMLevelCombo.getSelectedIndex();
            this.mFittedDistrTable.setModel(this.getTableModel(this.getSelectedMLevel(n)));
            this.setFitTableRender();
            this.updateContinueButton();
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.mRefitClicked) {
            this.mSelectedField.removeAllFitStats();
        }
        SimulationHelper.DistributionType distributionType = this.mSelectedField.getDistributionType();
        FitDetailTableModel fitDetailTableModel = (FitDetailTableModel)this.mFittedDistrTable.getModel();
        for (int i = 0; i < this.mFittedDistrTable.getRowCount(); ++i) {
            FitDetailTableItem fitDetailTableItem = fitDetailTableModel.getValue(i);
            boolean bl = fitDetailTableItem.getRefit();
            SimulationHelper.DistributionType distributionType2 = this.sDistNameTypeMap.get(fitDetailTableItem.getDistribution());
            if (!bl || !fitDetailTableItem.getSelected()) continue;
            distributionType = distributionType2;
            this.mSelectedField.setDistributionType(distributionType2);
            break;
        }
        if (this.mRefitClicked) {
            this.mSelectedField.setFitStats(this.mSelectedField.getAllFitStatsForFitDetails());
            this.mSelectedField.removeAllFitStatsForFitDetails();
        }
        this.resetParametersForType(distributionType);
        return true;
    }

    void enableRefitButton() {
        if (this.mMLevelCombo != null && this.mMLevelCombo.getSelectedIndex() == 1) {
            boolean bl = false;
            FitDetailTableModel fitDetailTableModel = (FitDetailTableModel)this.mFittedDistrTable.getModel();
            for (int i = 0; i < this.mFittedDistrTable.getRowCount(); ++i) {
                FitDetailTableItem fitDetailTableItem = fitDetailTableModel.getValue(i);
                if (fitDetailTableItem.getRefit()) continue;
                bl = true;
                break;
            }
            this.mFitButton.setEnabled(bl);
        } else {
            this.mFitButton.setEnabled(true);
        }
    }

    private void resetParametersForType(SimulationHelper.DistributionType distributionType) {
        ArrayList<Pair<String, String>> arrayList = this.mSelectedField.getParametersFor(distributionType);
        if (arrayList == null || arrayList.size() == 0) {
            this.mSelectedField.removeAllParameters();
        }
        this.mSelectedField.setAutoFit(MonteCarloSimulationDlg.FitToState.DistributionFitChanged);
        ArrayList<FitStatistics> arrayList2 = this.mSelectedField.getAllFitStats();
        for (int i = 0; i < arrayList2.size(); ++i) {
            FitStatistics fitStatistics = arrayList2.get(i);
            if (fitStatistics.getDistType() != distributionType) continue;
            this.mSelectedField.addParameter(distributionType, fitStatistics.getAllFittedParamAndValues());
            break;
        }
    }

    SimulationHelper.DistributionType getDistributionType(String string) {
        SimulationHelper.DistributionType distributionType = SimulationHelper.DistributionType.NONE;
        if (this.sDistNameTypeMap != null) {
            distributionType = this.sDistNameTypeMap.get(string);
        }
        return distributionType;
    }

    private void updateContinueButton() {
        boolean bl = false;
        FitDetailTableModel fitDetailTableModel = (FitDetailTableModel)this.mFittedDistrTable.getModel();
        for (int i = 0; i < this.mFittedDistrTable.getRowCount(); ++i) {
            FitDetailTableItem fitDetailTableItem = fitDetailTableModel.getValue(i);
            boolean bl2 = fitDetailTableItem.getRefit();
            SimulationHelper.DistributionType distributionType = this.sDistNameTypeMap.get(fitDetailTableItem.getDistribution());
            if (!bl2 || !fitDetailTableItem.getSelected()) continue;
            bl = fitDetailTableItem.getParameters().length() > 0;
            break;
        }
        this.enableContinue(bl);
    }

    protected void initialize() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_fitdetails";
    }

    private MeasurementLevel getSelectedMLevel(int n) {
        switch (n) {
            case 0: {
                return MeasurementLevel.scale;
            }
            case 1: {
                return MeasurementLevel.nominal;
            }
            case 2: {
                return MeasurementLevel.ordinal;
            }
        }
        return MeasurementLevel.scale;
    }

    private void initVars() {
        FITTED_COMBO_ARRAY = this.getResStringArray("IDS_MC_NAME_TYPE_ML_FIT_SELECT_ARRARY");
        this.mFieldToFitLabel = DialogUtil.createLabel(this, "IDS_MC_FIT_SELECTED_FIELD_TO_FIT_LABEL");
        this.mFitNameField = new StringTextField();
        this.mFitNameField.setEnabled(true);
        this.mFitNameField.setFocusable(true);
        this.mFitNameField.setEditable(false);
        this.mFitNameField.setOpaque(false);
        this.mFitNameField.setBorder(BorderFactory.createEmptyBorder());
        this.mFieldToFitLabel.setLabelFor((Component)((Object)this.mFitNameField));
        this.mMLeveLabel = DialogUtil.createLabel(this, "IDS_MC_FIT_SELECTED_MLEVL_LABEL");
        this.mMLevelCombo = new JComboBox<String>(FITTED_COMBO_ARRAY);
        this.mMLevelCombo.addActionListener(this);
        this.mMLeveLabel.setLabelFor(this.mMLevelCombo);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_MC_FIT_SELECTED_GENERATE_FIT_BUTTON");
        String string = this.getResString("IDS_MC_FIT_SELECTED_GENERATE_FIT_BUTTON");
        int n = string.length();
        this.mFitButton = new JButton(toggleButtonAction);
        this.mFitButton.addActionListener(this);
        Dimension dimension = this.mFitButton.getPreferredSize();
        if (dimension.width < 100) {
            this.mFitButton.setPreferredSize(new Dimension(100, dimension.height));
            this.mFitButton.setMinimumSize(new Dimension(100, dimension.height));
        }
        if (this.mSelectedField.getType() > 0) {
            this.mMLeveLabel.setEnabled(false);
            this.mMLevelCombo.setEnabled(false);
            this.mFitButton.setEnabled(false);
        }
        String[] stringArray = this.getResStringArray("IDS_MC_FITTED_RESULT_NAME_ARRARY");
        this.mFittedDistrTable = new PlainTable(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.getSelectedRow();
                int n2 = this.getSelectedColumn();
                FitDetailTableItem fitDetailTableItem = FitSelectSubDlg.this.mFittedDistrTableModel.getValue(n);
                switch (n2) {
                    case 0: {
                        if (fitDetailTableItem.getSelected()) {
                            return FitSelectSubDlg.this.getResString("IDS_MC_FIT_SELECTED_USE");
                        }
                        return FitSelectSubDlg.this.getResString("IDS_MC_FIT_SELECTED_NOT_USED");
                    }
                    case 1: {
                        return fitDetailTableItem.getDistribution();
                    }
                    case 2: {
                        return fitDetailTableItem.getFitStatsStr();
                    }
                    case 3: {
                        return fitDetailTableItem.getParameters();
                    }
                    case 4: {
                        if (fitDetailTableItem.getRefit()) {
                            return FitSelectSubDlg.this.getResString("IDS_MC_FIT_SELECTED_FIT");
                        }
                        return FitSelectSubDlg.this.getResString("IDS_MC_FIT_SELECTED_NOT_FIT");
                    }
                }
                return FitSelectSubDlg.this.getResString("IDS_MC_FIT_SELECTED_FITTED_TABLE_LABEL");
            }
        };
        this.mFittedDistrTable.setPreferredScrollableViewportSize(new Dimension(600, 200));
        this.mFittedDistrTable.setRowHeight(22);
        this.mFittedDistrTable.setColumnSelectionAllowed(true);
        this.mFittedDistrTable.setSelectionMode(0);
        this.mFittedDistrTable.setRowSelectionAllowed(true);
        this.mFittedDistrTable.getTableHeader().setReorderingAllowed(false);
        this.mFittedDistrTable.getTableHeader().setResizingAllowed(true);
        this.mFittedDistrTable.setGridColor(Color.darkGray);
        this.mFittedDistrTable.getTableHeader().setReorderingAllowed(false);
        this.mFittedDistrTableLabel = DialogUtil.createLabel(this, "IDS_MC_FIT_SELECTED_FITTED_TABLE_LABEL");
        this.mFittedDistrTableLabel.setLabelFor(this.mFittedDistrTableLabel);
        this.mFittedDistrTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FitSelectSubDlg.this.enableRefitButton();
            }
        });
        this.mCanvas = new SimulationHelper.PreviewCanvas(null);
        this.mImagePanel = new ImagePanel();
        this.mInfoPanel = this.createHelpPanel();
        this.mInfoPanel.setHelpForDistributionType(null);
        this.mFittedDistrTableModel = this.getTableModel(this.mSelectedField.getMeasurementLevel());
        this.mFittedDistrTable.setModel(this.mFittedDistrTableModel);
        this.setFitTableRender();
        SimulationHelper.setupColumnWidths(this.mFittedDistrTable, new double[]{0.1, 0.15, 0.3, 0.35, 0.1});
        this.updateContinueButton();
    }

    private SimulationHelper.HelpPanel createHelpPanel() {
        Font font = new JTextArea().getFont();
        SimulationHelper.HelpPanel helpPanel = new SimulationHelper.HelpPanel(font);
        helpPanel.setFocusable(true);
        helpPanel.setPreferredSize(new Dimension(120, 110));
        helpPanel.setMinimumSize(new Dimension(120, 110));
        return helpPanel;
    }

    private void setDefaults() {
        this.mFitNameField.setText(" " + this.mSelectedField.getMappedName());
        MeasurementLevel measurementLevel = this.mSelectedField.getMeasurementLevel();
        int n = 0;
        if (measurementLevel == MeasurementLevel.nominal) {
            n = 1;
        } else if (measurementLevel == MeasurementLevel.ordinal) {
            n = 2;
        }
        this.mMLevelCombo.setSelectedIndex(n);
    }

    private FitDetailTableModel getTableModel(MeasurementLevel measurementLevel) {
        FitDetailTableItem fitDetailTableItem;
        boolean bl;
        Object object;
        if (this.mFittedDistrTable != null) {
            this.mFittedDistrTable.removeAll();
        }
        this.mDistParameters.clear();
        Vector<FitDetailTableItem> vector = new Vector<FitDetailTableItem>();
        this.mFittedDistTypes = new Vector();
        this.mCurrentDistTypes = new Vector();
        this.mDistNameToShow.clear();
        String[] stringArray = SimulationHelper.getDistributionNames(measurementLevel);
        for (String string : stringArray) {
            this.mDistNameToShow.add(string);
            this.mCurrentDistTypes.add(this.sDistNameTypeMap.get(string));
        }
        Object object2 = this.mSelectedField.getAllFitStatsForFitDetails();
        int n = 1;
        if (((ArrayList)object2).size() == 0) {
            object2 = this.mSelectedField.getAllFitStats();
            n = 0;
        }
        int n2 = 0;
        boolean bl2 = false;
        SimulationHelper.DistributionType distributionType = this.mSelectedField.getDistributionType();
        boolean bl3 = false;
        for (n2 = 0; n2 < ((ArrayList)object2).size(); ++n2) {
            object = (FitStatistics)((ArrayList)object2).get(n2);
            if (this.mDistParameters.containsValue((Object)object.getDistType())) {
                this.mDistParameters.remove((Object)object.getDistType());
            }
            this.mDistParameters.put(object.getDistType(), object.getAllFittedParamAndValues());
            if (!this.mCurrentDistTypes.contains((Object)object.getDistType())) continue;
            bl = false;
            if (n == 0) {
                if (distributionType == object.getDistType()) {
                    bl = true;
                }
            } else if (n2 == 0) {
                bl = true;
            }
            fitDetailTableItem = new FitDetailTableItem(bl, object.getDistName(), object.getDistType(), object.getFitStatisString(), object.getParameterString(), true);
            this.mFittedDistTypes.add(this.mFittedDistTypes.size(), this.sDistNameTypeMap.get(object.getDistName()));
            vector.add(vector.size(), fitDetailTableItem);
            bl3 = true;
        }
        for (n2 = 0; n2 < this.mCurrentDistTypes.size(); ++n2) {
            object = this.mCurrentDistTypes.get(n2);
            if (this.mFittedDistTypes.contains(object)) continue;
            bl = false;
            fitDetailTableItem = new FitDetailTableItem(bl, this.mDistNameToShow.get(n2), (SimulationHelper.DistributionType)((Object)object), this.mNotFit, "", false);
            vector.add(vector.size(), fitDetailTableItem);
        }
        if (this.mSelectedField.getType() > 0) {
            this.mFitButton.setEnabled(false);
        } else {
            this.mFitButton.setEnabled(bl3);
        }
        object = this.getResStringArray("IDS_MC_FITTED_RESULT_NAME_ARRARY");
        SimulationHelper.DistributionType distributionType2 = this.mFittedDistTypes.size() > 0 ? this.mFittedDistTypes.get(0) : this.mCurrentDistTypes.get(0);
        this.mInfoPanel.setHelpForDistributionType(distributionType2);
        this.updateImagePanel(distributionType2);
        return new FitDetailTableModel(this, vector, this.mFittedDistrTable, (String[])object);
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2);
        JPanel jPanel2 = PanelFactory.getBasicPanel(new JComponent[]{this.mFieldToFitLabel, this.mFitNameField}, PanelFactory.PanelType.xaxis, "");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getBasicPanel(new JComponent[]{this.mMLeveLabel, this.mMLevelCombo}, PanelFactory.PanelType.xaxis, "");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 0, n2, n2);
        JPanel jPanel4 = MonteCarloSimulationDlg.setupTablePanel(this.mFittedDistrTable, this.mFittedDistrTableLabel, new JButton[]{this.mFitButton});
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 0, n2, n2);
        int n3 = (int)((double)jPanel4.getPreferredSize().height / 2.0);
        Dimension dimension = new Dimension(240, n3);
        this.mCanvas.setPreferredSize(mImageSize);
        this.mCanvas.setMinimumSize(mImageSize);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Dimension dimension2 = new Dimension(290, 120);
        this.mImagePanel.setMinimumSize(dimension2);
        this.mImagePanel.setPreferredSize(dimension2);
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mImagePanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 * 2, n2, n2, n2);
        this.mInfoPanel.setMinimumSize(dimension2);
        this.mInfoPanel.setPreferredSize(dimension2);
        DialogUtil.addUsingGBL(jPanel, this.mInfoPanel, gridBagConstraints, 1, 3, 1, 1, n, insets);
    }

    private void updateImagePanel(SimulationHelper.DistributionType distributionType) {
        Object[][] objectArray = SimulationHelper.getDefaulCells(distributionType);
        ArrayList<Pair<String, String>> arrayList = this.mDistParameters.get((Object)distributionType);
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            Pair<String, String> pair = arrayList.get(i);
            String string = (String)pair.getFirst();
            for (int j = 0; j < objectArray.length; ++j) {
                if (!string.equals(objectArray[j][0])) continue;
                objectArray[j][1] = (String)pair.getSecond();
            }
        }
        BufferedImage bufferedImage = SimulationHelper.createPreviewImage(objectArray, distributionType, this.mSelectedField, this.mScannedVar, mImageSize);
        this.mCanvas.setImage(bufferedImage);
        this.mCanvas.setPreferredSize(new Dimension(120, 100));
        this.mCanvas.setMinimumSize(new Dimension(120, 100));
        this.mCanvas.setMaximumSize(new Dimension(120, 100));
        this.mCanvas.setOpaque(true);
        this.mCanvas.setBackground(Color.white);
        this.mImagePanel.validate();
        this.mImagePanel.repaint();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFitNameField);
        vector.add(this.mMLevelCombo);
        vector.add(this.mFittedDistrTable);
        vector.add(this.mFitButton);
        vector.add(this.mImagePanel);
        vector.add(this.mInfoPanel);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void runRefit() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        Object object5;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.mSelectedField.getName();
        String string2 = this.mSelectedField.getMappedName();
        stringBuffer.append("\n  /SIMINPUT INPUT=" + string);
        if (!string.equals(string2)) {
            stringBuffer.append("(MAPTO=");
            stringBuffer.append(string2);
            stringBuffer.append(")");
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        FitDetailTableModel fitDetailTableModel = (FitDetailTableModel)this.mFittedDistrTable.getModel();
        boolean bl2 = false;
        int n = 0;
        for (n = 0; n < this.mFittedDistrTable.getRowCount(); ++n) {
            object5 = fitDetailTableModel.getValue(n);
            bl = ((FitDetailTableItem)object5).getRefit();
            if (!bl) continue;
            object4 = this.sDistNameTypeMap.get(((FitDetailTableItem)object5).getDistribution());
            if (object4 == SimulationHelper.DistributionType.EMPIRICAL) {
                bl2 = true;
                continue;
            }
            object3 = SimulationHelper.getDistributionSyntax(object4);
            if (((String)object3).length() <= 0) continue;
            stringBuffer2.append((String)object3 + " ");
        }
        if (stringBuffer2.length() == 0) {
            return;
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" TYPE = AUTOFIT (");
            stringBuffer.append(stringBuffer2 + ")");
        }
        object5 = ((MonteCarloSimulationDlg)this.mParentDlg).getSimulationTab().getFitOnlySyntax(this.mIndexInSimulatedTable, stringBuffer.toString());
        bl = SyntaxMgr.getSyntaxMgr().executeSynchronousSyntax((String)object5);
        if (bl) {
            object4 = OutputManager.getOutputManager().getSimulationFitStatsXML();
            try {
                if (object4 != null) {
                    this.mSelectedField.removeAllFitStatsForFitDetails();
                    object3 = new ByteArrayInputStream(ZipUtil.decompressBytes((byte[])((ByteBuffer)object4).array()));
                    object2 = new InputStreamReader((InputStream)object3, "UTF-8");
                    object = new SimulationPlanHandler();
                    ArrayList<SimulatedField> arrayList = new ArrayList<SimulatedField>();
                    arrayList.add(this.mSelectedField);
                    bl = ((SimulationPlanHandler)object).parsingFitStats((InputStreamReader)object2, arrayList, true);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        if (!bl) {
            object4 = this.getResString("IDX_MC_FIT_DETAILS_DIST_REFIT_ERROR");
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), (String)object4, VersionInfo.getAppVersionString());
            return;
        }
        if (bl) {
            object4 = new Vector();
            object3 = new Vector();
            object2 = this.mSelectedField.getAllFitStatsForFitDetails();
            this.mRefitClicked = true;
            object = null;
            int n2 = -1;
            int n3 = 0;
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                FitStatistics fitStatistics = (FitStatistics)((ArrayList)object2).get(i);
                n = fitDetailTableModel.getDistRowIndex(this.sDistTypeNameMap.get((Object)fitStatistics.getDistType()));
                if (n == -1) continue;
                FitDetailTableItem fitDetailTableItem = fitDetailTableModel.getValue(n);
                if (fitStatistics.getDistType() == SimulationHelper.DistributionType.EMPIRICAL) {
                    object = fitStatistics;
                    n2 = n;
                }
                if (!fitDetailTableItem.getRefit()) continue;
                fitDetailTableItem.setFitStatsStr(fitStatistics.getFitStatisString());
                fitDetailTableItem.setParameters(fitStatistics.getParameterString());
                if (n3 == 0) {
                    fitDetailTableItem.setSelected(true);
                    this.mFittedDistrTable.setValueAt(true, n, 0);
                }
                ((Vector)object4).add(n3++, fitDetailTableItem);
                ((Vector)object3).add(n);
            }
            if (((Vector)object4).size() == 0 && object != null && n2 != -1) {
                FitDetailTableItem fitDetailTableItem = fitDetailTableModel.getValue(n2);
                fitDetailTableItem.setFitted(true);
                fitDetailTableItem.setFitStatsStr("");
                fitDetailTableItem.setParameters("");
                fitDetailTableItem.setSelected(true);
                this.mFittedDistrTable.setValueAt(true, n2, 0);
                ((Vector)object4).add(n3++, fitDetailTableItem);
                ((Vector)object3).add(n2);
            }
            Vector<FitDetailTableItem> vector = fitDetailTableModel.getTableData();
            for (int i = 0; i < vector.size(); ++i) {
                if (((Vector)object3).contains(i)) continue;
                if (vector.get(i).getRefit()) {
                    vector.get(i).setFitStatsStr(this.mCannotFit);
                } else {
                    vector.get(i).setFitStatsStr(this.mNotFit);
                }
                vector.get(i).setParameters("");
                ((Vector)object4).add(n3++, vector.get(i));
            }
            this.mFittedDistrTable.removeAll();
            fitDetailTableModel.setData((Vector<FitDetailTableItem>)object4);
            this.mFittedDistrTable.setModel(fitDetailTableModel);
            this.setFitTableRender();
        }
    }

    private void setFitTableRender() {
        this.mFittedDistrTable.setDefaultRenderer(Object.class, new SaveTableRenderer());
        this.mFittedDistrTable.getColumnModel().getColumn(0).setCellEditor(new RadioButtonEditor(new JCheckBox()));
        this.mFittedDistrTable.getColumnModel().getColumn(0).setCellRenderer(new RadioButtonRenderer());
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setVerticalAlignment(1);
        jCheckBox.setHorizontalAlignment(0);
        this.mFittedDistrTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(jCheckBox));
        this.mFittedDistrTable.getColumnModel().getColumn(4).setCellRenderer(new CheckBoxRenderer());
    }

    class SaveTableRenderer
    extends DefaultTableCellRenderer {
        boolean mSave;
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        SaveTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            FitDetailTableModel fitDetailTableModel = (FitDetailTableModel)jTable.getModel();
            FitDetailTableItem fitDetailTableItem = fitDetailTableModel.getValue(n);
            if (bl) {
                if (component.hasFocus()) {
                    component.setBackground(jTable.getSelectionBackground());
                }
            } else {
                component.setBackground(jTable.getBackground());
            }
            return component;
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(FitSelectSubDlg.this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setBorder(bl2 ? FitSelectSubDlg.this.mHighLightBorder : FitSelectSubDlg.this.mEmptyBorder);
            this.setSelected(object != null && (Boolean)object != false);
            this.setEnabled(jTable.isCellEditable(n, n2));
            return this;
        }
    }

    class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener,
    ActionListener {
        private JRadioButton mButton;
        private int mRow;
        private String mDistName;

        public RadioButtonEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.mButton = new JRadioButton();
            this.mButton.setHorizontalAlignment(0);
            this.mRow = 0;
            this.mDistName = "";
            this.mButton.getAccessibleContext().setAccessibleName("");
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mRow = n;
            if (object == null) {
                return null;
            }
            this.mButton.addItemListener(this);
            this.mButton.addActionListener(this);
            if (((Boolean)object).booleanValue()) {
                this.mButton.setSelected(true);
            } else {
                this.mButton.setSelected(false);
            }
            this.mDistName = (String)jTable.getModel().getValueAt(n, 1);
            return this.mButton;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.mButton.isSelected()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            super.fireEditingStopped();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SimulationHelper.DistributionType distributionType = FitSelectSubDlg.this.sDistNameTypeMap.get(this.mDistName);
            FitSelectSubDlg.this.mInfoPanel.setHelpForDistributionType(distributionType);
            FitSelectSubDlg.this.updateImagePanel(distributionType);
            FitSelectSubDlg.this.updateContinueButton();
        }
    }

    class RadioButtonRenderer
    implements TableCellRenderer {
        private JRadioButton mButton = new JRadioButton();

        public RadioButtonRenderer() {
            this.mButton.setHorizontalAlignment(0);
            this.mButton.setBorder(FitSelectSubDlg.this.mHighLightBorder);
            this.mButton.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            if (object == null) {
                return null;
            }
            if (((Boolean)object).booleanValue()) {
                this.mButton.setSelected(true);
                string = FitSelectSubDlg.this.getResString("IDS_MC_FIT_SELECTED_USE");
            } else {
                this.mButton.setSelected(false);
                string = FitSelectSubDlg.this.getResString("IDS_MC_FIT_SELECTED_NOT_USED");
            }
            if (bl) {
                this.mButton.setForeground(jTable.getSelectionForeground());
                this.mButton.setBackground(jTable.getSelectionBackground());
            } else {
                this.mButton.setForeground(jTable.getForeground());
                this.mButton.setBackground(jTable.getBackground());
            }
            this.mButton.setHorizontalAlignment(0);
            this.mButton.setBorder(bl2 ? FitSelectSubDlg.this.mHighLightBorder : FitSelectSubDlg.this.mEmptyBorder);
            this.mButton.getAccessibleContext().setAccessibleName("");
            this.mButton.getAccessibleContext().setAccessibleDescription(string);
            return this.mButton;
        }
    }

    class ImagePanel
    extends JPanel {
        public ImagePanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new TitledBorder(""));
            this.initLayout();
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    ImagePanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    ImagePanel.this.repaint();
                }
            });
        }

        protected void initLayout() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            FitSelectSubDlg.this.mCanvas.setPreferredSize(mImageSize);
            FitSelectSubDlg.this.mCanvas.setMinimumSize(mImageSize);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            Insets insets = new Insets(n2, n2, n2, n2);
            DialogUtil.addUsingGBL(this, FitSelectSubDlg.this.mCanvas, gridBagConstraints, 0, 0, 1, 1, n, null);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            rectangle.grow(-4, -4);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

