/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.MC.FitDetailTableItem;
import com.spss.java_client.ui.dialogs.MC.FitSelectSubDlg;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import java.util.Vector;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class FitDetailTableModel
extends AbstractTableModel {
    private FitSelectSubDlg mParent;
    private Vector<FitDetailTableItem> mData;
    private SpssButtonGroup mButtonGroup;
    private Vector<JRadioButton> mButtons;
    private JTable mTable;
    private String[] COLUMN_NAMES;

    public FitDetailTableModel(BaseSubDialog baseSubDialog, Vector<FitDetailTableItem> vector, JTable jTable, String[] stringArray) {
        this.mParent = (FitSelectSubDlg)baseSubDialog;
        this.mData = vector;
        this.mTable = jTable;
        this.COLUMN_NAMES = stringArray;
    }

    @Override
    public int getRowCount() {
        return this.mData.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    public FitDetailTableItem getValue(int n) {
        if (n < 0 || n >= this.mData.size()) {
            return null;
        }
        FitDetailTableItem fitDetailTableItem = this.mData.get(n);
        return fitDetailTableItem;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FitDetailTableItem fitDetailTableItem = this.mData.get(n);
        switch (n2) {
            case 0: {
                return fitDetailTableItem.getSelected();
            }
            case 1: {
                return fitDetailTableItem.getDistribution();
            }
            case 2: {
                return fitDetailTableItem.getFitStatsStr();
            }
            case 3: {
                return fitDetailTableItem.getParameters();
            }
            case 4: {
                return fitDetailTableItem.getRefit();
            }
        }
        return null;
    }

    public int getDistRowIndex(String string) {
        for (int i = 0; i < this.mData.size(); ++i) {
            if (!this.mData.get(i).getDistribution().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void setData(Vector<FitDetailTableItem> vector) {
        this.mData = vector;
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        FitDetailTableItem fitDetailTableItem = this.mData.get(n);
        if (n2 == 0 || n2 == 4) {
            Boolean bl = (Boolean)object;
            if (n2 == 0 && bl.booleanValue()) {
                fitDetailTableItem.setSelected(bl);
            } else {
                fitDetailTableItem.setFitted(bl);
            }
        } else if (n2 == 1) {
            String string = object.toString();
            fitDetailTableItem.setDistribution(string, this.mParent.getDistributionType(string));
        } else if (n2 == 2) {
            fitDetailTableItem.setFitStatsStr(object.toString());
        } else if (n2 == 3) {
            fitDetailTableItem.setParameters(object.toString());
        }
        if (fitDetailTableItem.getSelected()) {
            this.updateData(n);
        }
    }

    private void updateData(int n) {
        for (int i = 0; i < this.mData.size(); ++i) {
            FitDetailTableItem fitDetailTableItem = this.mData.get(i);
            if (i == n) {
                fitDetailTableItem.setSelected(true);
            } else {
                fitDetailTableItem.setSelected(false);
            }
            this.mData.set(i, fitDetailTableItem);
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 4) {
            return this.mData.get(n).getDistributionType() != SimulationHelper.DistributionType.EMPIRICAL;
        }
        if (n2 == 0) {
            return this.mData.get(n).getParameters().length() > 0;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.COLUMN_NAMES[n];
    }

    public Vector<FitDetailTableItem> getTableData() {
        return this.mData;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return JRadioButton.class;
        }
        if (n == 4) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }
}

