/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableComparator;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderDescArea;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionList;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.NewFieldNameAndTypeSubDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.base.transform.compute.ComputeDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class EquationSubDlg
extends BaseSubDialog
implements DocumentListener,
ListSelectionListener {
    public static final String TARGET_FIELD = "IDS_MC_TARGET_FIELD_STRING";
    public static final String TARGET_VAR = "IDS_MC_TARGET_FIELD_VARIABLE";
    public static final String EQUATION_FIELD = "IDS_MC_EQUATION_FIELD_STRING";
    public static final String MC_TEMP_DATA_FILE_NAME = "MC_TEMP_DATA_FILE_NAME";
    public static final String EQUATION_COMMENTS = "IDS_MC_EQUATION_COMMEMENTS";
    public static final String INPUT_FIELDS = "IDS_MC_INPUT_FIELD_STRING";
    public static final String USED_SIM_FIELD = "IDS_MC_USED_SIM_FIELD";
    public static final String SIMLIST_ALL = "IDS_MC_EQUATION_SIM_ALL";
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private StringTextField mTargetTextField;
    private ExpressionBuilderTextArea mNumericTextArea;
    private ExpressionBuilderTextArea mCommnentEdit;
    private ExpressionBuilderDescArea mDescriptionTextArea;
    private JButton mTargetEditButton;
    private SimulatedField mTargetVar;
    private SrcVariableList mSrcList;
    private ExpressionAreaArrowButton mNumericArrowButton;
    private CalcWidget mCalcPanel;
    private ArrowButton mFunctionArrowButton;
    private JList mFunctionGroupList;
    private JList mSpecialVariableList;
    private FunctionListControls mFunctionControls;
    private String mOriginalExpression;
    private NewFieldNameAndTypeSubDlg mNameTypeLabelDlg;
    private JLabel mNumericExpressionLabel;
    private JButton mSimuEditButton;
    private JButton mSimuNewButton;
    private TargetVariableList mSimuList;
    private JLabel mSimulistLabel;
    private ExpressionAreaArrowButton mSimulatedArrowButton;
    private Vector<SimulatedField> mUsedSimFields;
    private Vector<ISpssVariable> mSimAllFields;
    private Hashtable<String, Object> mFixedFieldDefaultValues;
    private String mEditTargetName = "";
    private String mEditExprString = "";
    private String mEditComments = "";
    private Vector<String> mSupportedFunctions = null;
    private static String sOperationChars = new String(" +-*/<>=&~|(),");

    public EquationSubDlg(MonteCarloSimulationDlg monteCarloSimulationDlg) {
        this(monteCarloSimulationDlg, "", "", "", null);
    }

    public EquationSubDlg(MonteCarloSimulationDlg monteCarloSimulationDlg, String string, String string2, String string3, SimulatedField simulatedField) {
        super(monteCarloSimulationDlg, monteCarloSimulationDlg.getResString("IDS_MC_EQUATION_EDITOR_TITLE"), true);
        this.mEditTargetName = string;
        this.mEditExprString = string2;
        this.mEditComments = string3;
        this.mFixedFieldDefaultValues = new Hashtable();
        this.mTargetVar = simulatedField;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        SimulatedField simulatedField;
        super.loadState(dialogDataModel);
        this.mNumericTextArea.setText(this.mEditExprString);
        this.mTargetTextField.setText(this.mEditTargetName);
        this.mCommnentEdit.setText(this.mEditComments);
        Object[] objectArray = dialogDataModel.getArray(SIMLIST_ALL);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ISpssVariable iSpssVariable = (ISpssVariable)objectArray[i];
                if (!iSpssVariable.getName().equalsIgnoreCase(this.mEditTargetName)) {
                    ArrayList<Pair<String, String>> arrayList;
                    if (iSpssVariable.getRole() == Role.partition && iSpssVariable instanceof SimulatedField && (arrayList = ((SimulatedField)iSpssVariable).getParametersFor(SimulationHelper.DistributionType.FIXED)) != null && arrayList.size() == 1) {
                        this.mFixedFieldDefaultValues.put(iSpssVariable.getName(), arrayList.get(0).getSecond());
                    }
                    if (this.mSrcList.getModel().findElementIndexesByName(iSpssVariable.getName()).length != 0) continue;
                    this.mSimuList.getModel().addElement(iSpssVariable);
                    continue;
                }
                if (this.mTargetVar != null) continue;
                this.mTargetVar = (SimulatedField)iSpssVariable;
            }
        }
        if (this.mTargetVar == null && this.mEditTargetName != null && this.mEditTargetName.length() > 0 && (simulatedField = (SimulatedField)((Object)dialogDataModel.getObject(TARGET_VAR))).getName().equals(this.mEditTargetName)) {
            this.mTargetVar = simulatedField;
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(TARGET_FIELD, this.mTargetTextField.getText());
            dialogDataModel.putString(EQUATION_FIELD, this.mNumericTextArea.getText());
            dialogDataModel.putString(EQUATION_COMMENTS, this.mCommnentEdit.getText());
            dialogDataModel.putString(INPUT_FIELDS, this.getInputFieldStr());
            dialogDataModel.putArray(USED_SIM_FIELD, this.mUsedSimFields.toArray());
            dialogDataModel.putArray(SIMLIST_ALL, this.mSimAllFields.toArray());
            dialogDataModel.putObject(TARGET_VAR, (Object)this.mTargetVar);
        }
        FunctionList.getInstance();
        FunctionList.reset();
        return bl;
    }

    private String getInputFieldStr() {
        Object object;
        ISpssVariable iSpssVariable;
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer(this.mNumericTextArea.getText());
        this.mUsedSimFields = new Vector();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(i);
            if (!this.isVarNameUsed(stringBuffer2, iSpssVariable2.getName())) continue;
            SimulatedField simulatedField = new SimulatedField(iSpssVariable2.getName());
            simulatedField.setMappedName(iSpssVariable2.getName());
            simulatedField.setMeasurementLevel(iSpssVariable2.getMeasurementLevel());
            simulatedField.addRelatedModelName(this.mTargetTextField.getText());
            simulatedField.setType(iSpssVariable2.getType());
            simulatedField.setFormat(iSpssVariable2.getFormat());
            if (iSpssVariable2.getRole() == Role.partition) {
                simulatedField.setDistributionType(SimulationHelper.DistributionType.FIXED);
                iSpssVariable = new Pair((Object)"value", (Object)this.getFixedDefaultValue(iSpssVariable2));
                object = new ArrayList();
                ((ArrayList)object).add(iSpssVariable);
                simulatedField.addParameter(SimulationHelper.DistributionType.FIXED, (ArrayList<Pair<String, String>>)object);
                simulatedField.setRole(Role.partition);
                simulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
            } else {
                simulatedField.setDistributionType(SimulationHelper.DistributionType.NONE);
            }
            simulatedField.setValueLabels(iSpssVariable2.getValueLabels());
            stringBuffer.append(iSpssVariable2.getName() + ",");
            this.mUsedSimFields.add(simulatedField);
        }
        SFListModel sFListModel = (SFListModel)this.mSimuList.getModel();
        int n = sFListModel.getSize();
        this.mSimAllFields = new Vector();
        for (int i = 0; i < n; ++i) {
            iSpssVariable = sFListModel.getElementAt(i);
            object = new SimulatedField(iSpssVariable.getName());
            object.setType(iSpssVariable.getType());
            object.setFormat(iSpssVariable.getFormat());
            if (iSpssVariable instanceof SimulatedField) {
                ((SimulatedField)((Object)object)).setExcludeFromOutput(((SimulatedField)iSpssVariable).isExcludeFromOutput());
            }
            if (iSpssVariable.getRole() == Role.partition) {
                ((SimulatedField)((Object)object)).setDistributionType(SimulationHelper.DistributionType.FIXED);
                Pair pair = new Pair((Object)"value", (Object)this.getFixedDefaultValue(iSpssVariable));
                ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
                arrayList.add(pair);
                ((SimulatedField)((Object)object)).addParameter(SimulationHelper.DistributionType.FIXED, arrayList);
                object.setRole(Role.partition);
                ((SimulatedField)((Object)object)).setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
            } else {
                ((SimulatedField)((Object)object)).setDistributionType(SimulationHelper.DistributionType.NONE);
            }
            object.setMeasurementLevel(iSpssVariable.getMeasurementLevel());
            ((SimulatedField)((Object)object)).addRelatedModelName(this.mTargetTextField.getText());
            object.setValueLabels(iSpssVariable.getValueLabels());
            if (this.isVarNameUsed(stringBuffer2, iSpssVariable.getName())) {
                stringBuffer.append(object.getName() + ",");
                this.mUsedSimFields.add((SimulatedField)((Object)object));
            }
            this.mSimAllFields.add((ISpssVariable)object);
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (this.mTargetVar == null) {
            this.mTargetVar = new SimulatedField(this.mTargetTextField.getText());
            this.mTargetVar.setMeasurementLevel(MeasurementLevel.scale);
            this.mTargetVar.setExcludeFromOutput(false);
            this.mTargetVar.setRole(Role.target);
        }
        if (this.mSrcList.getModel().findElementIndexesByName(this.mTargetTextField.getText()).length == 0) {
            this.mSimAllFields.add((ISpssVariable)this.mTargetVar);
        }
        return stringBuffer.toString();
    }

    private boolean isVarNameUsed(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.indexOf(string);
        int n2 = stringBuffer.toString().trim().length();
        while (n >= 0) {
            int n3;
            boolean bl = false;
            for (n3 = n + string.length(); n3 < n2 && sOperationChars.indexOf(stringBuffer.charAt(n3)) < 0; ++n3) {
                bl = true;
            }
            for (int i = n - 1; i >= 0 && sOperationChars.indexOf(stringBuffer.charAt(i)) < 0; --i) {
                bl = true;
            }
            if (!bl) {
                return true;
            }
            n = stringBuffer.indexOf(string, n3);
        }
        return false;
    }

    private boolean isTargetFieldValid(String string) {
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        boolean bl = true;
        if (n == 0) {
            if (this.mSimuList.getModel().findElementIndexesByName(string).length > 0) {
                String string2 = ResUtil.getCommonDlgString("ERR_BADVAR_DUPLICATE_ERROR_MESSAGE");
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
                bl = false;
            }
        } else {
            bl = false;
            DialogUtil.showBadSpssVarNameWarning(n, this);
        }
        if (!bl) {
            SPSSTextField.setSelectionText((JComponent)((Object)this.mTargetTextField), (int)0);
        }
        return bl;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mSimuList) {
            if (this.mSimuList.getSelectedIndex() >= 0) {
                this.mSimuEditButton.setEnabled(true);
            } else {
                this.mSimuEditButton.setEnabled(false);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void reset() {
        this.setDefaults();
        this.mTargetTextField.setText("");
        this.mFunctionControls.reset();
        if (this.mNumericArrowButton != null) {
            this.mNumericArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mNumericArrowButton.setEnabled(true);
        }
        this.updateExpressionLabel();
    }

    public SrcVariableList getSourceList() {
        return this.mSrcList;
    }

    public boolean isValidExpression(String string, String string2, boolean bl) {
        ExpressionValidator expressionValidator = new ExpressionValidator();
        boolean bl2 = expressionValidator.validateComputeExpression(string, string2, bl);
        if (!bl2) {
            String string3 = expressionValidator.checkError();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
            return bl2;
        }
        return bl2;
    }

    @Override
    public boolean continuePressed() {
        String string = this.mTargetTextField.getText();
        if (!this.isTargetFieldValid(string)) {
            return false;
        }
        ComputeDlg.closeUnNamedDataset();
        String string2 = this.useCOMPUTE();
        ExpressionValidator expressionValidator = new ExpressionValidator();
        boolean bl = expressionValidator.validateComputeWitVarExpression(string2);
        if (!bl) {
            String string3 = expressionValidator.checkError();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
            return bl;
        }
        return super.continuePressed();
    }

    private String useCOMPUTE() {
        String string = this.mTargetTextField.getText();
        String string2 = this.mNumericTextArea.getText();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string3 = iSpssDataSrc.getDatasetName();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nPRESERVE.");
        stringBuffer.append("\n_SET PRINTBACK=NONE.");
        stringBuffer.append(this.getStartSyntax());
        int n = this.mSimuList.getModel().getSize();
        int n2 = this.mSrcList.getModel().getSize();
        for (int i = 0; i < n + n2; ++i) {
            ISpssVariable iSpssVariable = i < n ? this.mSimuList.getModel().getElementAt(i) : this.mSrcList.getModel().getElementAt(i - n);
            if (iSpssVariable.getName().startsWith("CASEID_$")) continue;
            if (iSpssVariable.getType() > 0) {
                stringBuffer.append("\nSTRING ");
                stringBuffer.append(iSpssVariable.getName());
                stringBuffer.append(" (A8).");
                continue;
            }
            stringBuffer.append("\nNUMERIC ");
            stringBuffer.append(iSpssVariable.getName() + ".");
        }
        stringBuffer.append(this.getEndSyntax(string, string2, string3));
        return stringBuffer.toString();
    }

    public String useSIMPREP() {
        String string = this.mTargetTextField.getText();
        String string2 = this.mNumericTextArea.getText();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.getSIMPREBeginSyntax());
        int n = this.mSimuList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = this.mSimuList.getModel().getElementAt(i);
            if (iSpssVariable.getName().startsWith("CASEID_$")) continue;
            if (iSpssVariable.getType() > 0) {
                stringBuffer.append("\nSTRING ");
                stringBuffer.append(iSpssVariable.getName());
                stringBuffer.append(" (A8).");
                continue;
            }
            stringBuffer.append("\nNUMERIC ");
            stringBuffer.append(iSpssVariable.getName() + ".");
        }
        stringBuffer.append("\n_COMPUTE " + string + "=" + string2 + ".");
        stringBuffer.append(this.getSIMPREEndSyntax(iSpssDataSrc.getDatasetName()));
        return stringBuffer.toString();
    }

    private String getSIMPREBeginSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nOMS");
        stringBuffer.append("\n/SELECT ALL");
        stringBuffer.append("\n/TAG='_DELETE_'");
        stringBuffer.append("\n/DESTINATION VIEWER=NO.");
        String string = PrefsMgr.getPrefsMgr().getTempPath();
        stringBuffer.append("\nSIMPREP BEGIN /OUTFILE PREPXML='" + string + "simprep_temp.xml" + "'.");
        return stringBuffer.toString();
    }

    private String getSIMPREEndSyntax(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nSIMPREP END.");
        stringBuffer.append("\nOMSEND TAG=['_DELETE_'].");
        return stringBuffer.toString();
    }

    private String getStartSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nNEW FILE.");
        stringBuffer.append("\nDATASET NAME ");
        stringBuffer.append("MC_TEMP_DATA_FILE_NAME.");
        stringBuffer.append("\nINPUT PROGRAM.");
        return stringBuffer.toString();
    }

    private String getEndSyntax(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nEND FILE.");
        stringBuffer.append("\nEND INPUT PROGRAM.");
        stringBuffer.append("\n_COMPUTE " + string + "=" + string2 + ".");
        stringBuffer.append("\nDATASET CLOSE ");
        stringBuffer.append("MC_TEMP_DATA_FILE_NAME.");
        if (string3.length() > 0) {
            stringBuffer.append("\nDATASET ACTIVATE " + string3 + " WINDOW=ASIS.");
        } else {
            stringBuffer.append("\nNEW FILE.");
        }
        stringBuffer.append("\nRESTORE.");
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_simulation_equationeditor";
    }

    public void updateExpressionLabel() {
        Boolean bl = true;
        int n = bl != null ? (bl != false ? this.getDlgAccessKey("IDK_COMPUTE_NUMERIC_EXPRESSION_LABEL_KEY") : this.getDlgAccessKey("IDK_COMPUTE_STRING_EXPRESSION_LABEL_KEY")).intValue() : this.getDlgAccessKey("IDK_COMPUTE_NUMERIC_EXPRESSION_LABEL_KEY").intValue();
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mNumericExpressionLabel.setDisplayedMnemonic(n);
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mNumericTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mSpecialVariableList);
        }
        this.pack();
    }

    private boolean isTextPresentInTextComponent(JTextComponent jTextComponent) {
        return jTextComponent.getText().length() > 0 && (jTextComponent != this.mNumericTextArea || this.mNumericTextArea.getText().indexOf("?") == -1);
    }

    private void initVars() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(0);
        vector.add(1);
        vector.add(15);
        this.mSupportedFunctions = this.getSupportedFunctions();
        FunctionList.getInstance();
        FunctionList.reset();
        this.mFunctionControls = new FunctionListControls(true, true, vector, this.mSupportedFunctions);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mTargetTextField = new StringTextField();
        this.mTargetTextField.setValidateOnFocusLost(false);
        this.mTargetTextField.setAction(new TextFieldAction(this, "IDS_COMPUTE_TARGET_VARIABLE_LABEL"));
        this.mTargetTextField.getDocument().addDocumentListener(new TextDocumentListener());
        this.mNumericTextArea = new ExpressionBuilderTextArea(3, 30);
        this.mNumericTextArea.setLineWrap(true);
        this.mCommnentEdit = new ExpressionBuilderTextArea(3, 30);
        this.mCommnentEdit.setLineWrap(true);
        this.mCommnentEdit.setWrapStyleWord(true);
        this.mDescriptionTextArea = (ExpressionBuilderDescArea)this.mFunctionControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.setHelpAreaBackgroundColor();
        this.mTargetEditButton = new JButton(new ToggleButtonAction(this, "IDS_MC_NEW_EQUATION_TARGET_EDIT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EquationSubDlg.this.runNewFieldSubDlg(false, false);
            }
        });
        this.mSrcList = new SrcVariableList();
        this.mSrcList.setIdentifier("SourceList");
        this.mSrcList.setSelectionMode(0);
        this.mNumericArrowButton = new ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation.up);
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mNumericTextArea), CalcWidget.CalcType.eRelationalWithTilde);
        this.mFunctionArrowButton = this.mFunctionControls.getFunctionArrow();
        this.mSpecialVariableList = this.mFunctionControls.getFunctionList();
        this.mSpecialVariableList.setSelectionMode(0);
        this.mFunctionGroupList = this.mFunctionControls.getFunctionGroupList();
        this.mFunctionGroupList.setSelectionMode(0);
        this.mFunctionControls.setExpressionArea((JTextArea)((Object)this.mNumericTextArea));
        this.mFunctionControls.setSrcList(this.mSrcList);
        this.mFunctionControls.setFunctionGroupIdentifier("Function Grp");
        this.mFunctionControls.setFunctionListIdentifier("Function list");
        this.mSimuList = new TargetVariableList();
        this.mSimuList.setIdentifier("SimulatedSourceList");
        this.mSimuList.setModel(new SFListModel(this.mSimuList));
        this.mSimuList.setSelectionMode(0);
        this.mSimuList.addListSelectionListener(this);
        this.mSimulistLabel = DialogUtil.createLabel(this, "IDS_MC_NEW_EQUATION_INPUTS_LABEL");
        this.mSimulistLabel.setLabelFor(this.mSimuList);
        this.mSimuEditButton = new JButton(new ToggleButtonAction(this, "IDS_MC_NEW_EQUATION_TYPE_LABEL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EquationSubDlg.this.runNewFieldSubDlg(false, true);
            }
        });
        this.mSimuNewButton = new JButton(new ToggleButtonAction(this, "IDS_MC_NEW_EQUATION_NEW_LABEL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EquationSubDlg.this.runNewFieldSubDlg(true, true);
            }
        });
        this.mSimulatedArrowButton = new ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSimulatedArrowButton.registerComponents(this.mSimuList, SpssArrowButton.ButtonOrientation.right);
        this.mSimulatedArrowButton.registerComponents((JComponent)((Object)this.mNumericTextArea), SpssArrowButton.ButtonOrientation.left);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mNumericTextArea.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mNumericTextArea), this, dialogFocusTraversalPolicy, true));
        this.mNumericTextArea.getDocument().addDocumentListener(new TextDocumentListener());
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        this.mCommnentEdit.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mCommnentEdit), this, dialogFocusTraversalPolicy, true));
        this.mCommnentEdit.getDocument().addDocumentListener(new TextDocumentListener());
        this.mNumericArrowButton.registerComponents(this.mSrcList, SpssArrowButton.ButtonOrientation.up);
        this.mNumericArrowButton.registerComponents((JComponent)((Object)this.mNumericTextArea), SpssArrowButton.ButtonOrientation.down);
        this.mTargetTextField.getDocument().addDocumentListener(this);
    }

    private void setHelpAreaBackgroundColor() {
        if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Object object = toolkit.getDesktopProperty("win.highContrast.on");
            if (object != null && ((Boolean)object).booleanValue()) {
                this.mDescriptionTextArea.setBackground(Color.black);
            } else {
                this.mDescriptionTextArea.setBackground(Color.white);
            }
        }
    }

    private void runNewFieldSubDlg(boolean bl, boolean bl2) {
        String[] stringArray;
        if (!bl2 && (stringArray = this.mTargetTextField.getText()).length() > 0 && !this.isTargetFieldValid((String)stringArray)) {
            return;
        }
        stringArray = null;
        Vector<String> vector = new Vector<String>();
        boolean bl3 = false;
        Object object = null;
        if (bl) {
            bl3 = true;
            this.mParentDlg.getDialogDataModel().putBoolean("IDS_MC_NAME_TYPE_DISTRIBUTION_BUTTON", true);
        } else if (bl2) {
            stringArray = new String[this.mSimuList.getModel().getSize()];
            this.mParentDlg.getDialogDataModel().putBoolean("IDS_MC_NAME_TYPE_DISTRIBUTION_BUTTON", true);
            object = (ISpssVariable)this.mSimuList.getSelectedValue();
        } else {
            String string = this.mTargetTextField.getText();
            if (string.length() > 0) {
                stringArray = new String[]{string};
                if (this.mTargetVar == null) {
                    this.mTargetVar = new SimulatedField(string);
                }
                object = this.mTargetVar;
            } else {
                bl3 = true;
            }
            this.mParentDlg.getDialogDataModel().putBoolean("IDS_MC_NAME_TYPE_TARGET_RADIO", true);
        }
        int n = 0;
        for (n = 0; n < this.mSimuList.getModel().getSize(); ++n) {
            String string = this.mSimuList.getModel().getElementAt(n).getName();
            if (bl3) {
                vector.add(string);
            }
            if (!bl2 || bl3) continue;
            stringArray[n] = string;
        }
        for (n = 0; n < this.mSrcList.getModel().getSize() && bl3; ++n) {
            vector.add(this.mSrcList.getModel().getElementAt(n).getName());
        }
        this.mNameTypeLabelDlg = new NewFieldNameAndTypeSubDlg((MonteCarloSimulationDlg)this.mParentDlg, stringArray, !bl2, vector, (ISpssVariable)object, this.getFixedDefaultValue((ISpssVariable)object));
        this.mNameTypeLabelDlg.setVisible(true);
        boolean bl4 = this.mNameTypeLabelDlg.wasContinuePressed();
        if (bl4) {
            DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
            SFListModel sFListModel = (SFListModel)this.mSimuList.getModel();
            String string = dialogDataModel.getString("IDS_MC_FIELD_NAME_COMBO");
            SpssVariable spssVariable = null;
            int n2 = -1;
            if (!bl3) {
                if (bl2) {
                    n2 = sFListModel.findElementIndexesByName(string)[0];
                    spssVariable = sFListModel.getElementAt(n2);
                }
            } else if (bl2) {
                spssVariable = new SpssVariable();
                spssVariable.setName(string);
            } else {
                this.mTargetVar = new SimulatedField(string);
            }
            short s = 0;
            boolean bl5 = dialogDataModel.getBoolean("IDS_MC_NAME_TYPE_TARGET_RADIO");
            if (bl5) {
                this.mTargetVar.setRole(Role.target);
                this.mTargetVar.setMeasurementLevel(EquationSubDlg.getMLevel(dialogDataModel.getInteger("IDS_MC_TARGET_MEASUREMENT_COMBO")));
                this.mTargetVar.setExcludeFromOutput(dialogDataModel.getBoolean("IDS_MC_NAME_TYPE_CREATE_TARGET_CHECK") == false);
                this.mTargetVar.setType(s);
            } else if (dialogDataModel.getBoolean("IDS_MC_NAME_TYPE_DISTRIBUTION_BUTTON").booleanValue()) {
                spssVariable.setRole(Role.input);
                int n3 = dialogDataModel.getInteger("IDS_MC_INPUT_MEASUREMENT_COMBO");
                if (n3 == 1) {
                    s = 1;
                }
                if (n3 == 2 || n3 == 3) {
                    --n3;
                }
                spssVariable.setMeasurementLevel(EquationSubDlg.getMLevel(n3));
                this.removeFixedDefaultValue(spssVariable.getName());
                spssVariable.setType(s);
            } else {
                spssVariable.setRole(Role.partition);
                if (dialogDataModel.getInteger("IDS_MC_FIELD_TYPE_COMBO") == 1) {
                    s = 1;
                }
                String string2 = dialogDataModel.getString("IDS_MC_FIXED_DEFAULT_VALUE");
                this.removeFixedDefaultValue(spssVariable.getName());
                this.mFixedFieldDefaultValues.put(spssVariable.getName(), string2);
                if (s == 0) {
                    spssVariable.setMeasurementLevel(MeasurementLevel.scale);
                } else {
                    spssVariable.setMeasurementLevel(MeasurementLevel.nominal);
                }
                spssVariable.setType(s);
            }
            Object object2 = dialogDataModel.getObject("IDS_MC_NAME_TYPE_VALUE_LABEL_TABLE");
            if (object2 != null) {
                if (bl2) {
                    spssVariable.setValueLabels((IValueLabelMap)((ValueLabelMap)object2));
                } else {
                    this.mTargetVar.setValueLabels((IValueLabelMap)((ValueLabelMap)object2));
                }
            }
            if (!bl3) {
                if (bl2) {
                    sFListModel.setElementAt(n2, (ISpssVariable)spssVariable);
                }
            } else if (bl2) {
                sFListModel.addElement((ISpssVariable)spssVariable);
            } else {
                this.mTargetTextField.setText(this.mTargetVar.getName());
            }
            this.mNameTypeLabelDlg.dispose();
        }
    }

    private String getFixedDefaultValue(ISpssVariable iSpssVariable) {
        if (iSpssVariable == null) {
            return "";
        }
        Object object = this.mFixedFieldDefaultValues.get(iSpssVariable.getName());
        if (object != null) {
            return (String)object;
        }
        return "";
    }

    private void removeFixedDefaultValue(String string) {
        Object object = this.mFixedFieldDefaultValues.get(string);
        if (object != null) {
            this.mFixedFieldDefaultValues.remove(string);
        }
    }

    static MeasurementLevel getMLevel(int n) {
        switch (n) {
            case 0: {
                return MeasurementLevel.scale;
            }
            case 1: {
                return MeasurementLevel.nominal;
            }
            case 2: {
                return MeasurementLevel.ordinal;
            }
        }
        return MeasurementLevel.unknown;
    }

    private boolean runSubDialog(BaseSubDialog baseSubDialog) {
        return this.mParentDlg.runSubDialog(baseSubDialog);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTargetTextField);
        vector.add(this.mTargetEditButton);
        vector.add(this.mSimuList);
        vector.add(this.mSimulatedArrowButton);
        vector.add(this.mSimuNewButton);
        vector.add(this.mSimuEditButton);
        vector.add(this.mSrcList);
        vector.add(this.mNumericArrowButton);
        vector.add((Object)this.mNumericTextArea);
        vector.add(this.mCalcPanel.getDefaultFocusButton());
        vector.add(this.mFunctionGroupList);
        vector.add(this.mFunctionArrowButton);
        vector.add(this.mFunctionControls.getFunctionList());
        vector.add(this.mDescriptionTextArea);
        vector.add((Object)this.mCommnentEdit);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setDefaults() {
        this.mNumericTextArea.setText("");
        this.mTargetEditButton.setEnabled(true);
        this.mFunctionArrowButton.setEnabled(false);
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc.columnCount() > 0) {
            this.mSrcList.loadFromActiveDataset();
            this.mSrcList.setSelectedIndex(0);
        }
        this.mTargetTextField.requestFocus();
        this.mSimuEditButton.setEnabled(false);
        this.enableContinue(false);
    }

    private void setUpUI(JPanel jPanel) {
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MC_NEW_EQUATION_TARGET_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mTargetTextField));
        this.mNumericExpressionLabel = DialogUtil.createLabel(this, "IDS_MC_NEW_EQUATION_EXPRESSION_LABEL");
        this.mNumericExpressionLabel.setLabelFor((Component)((Object)this.mNumericTextArea));
        JLabel jLabel2 = new JLabel("    =");
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mNumericTextArea));
        jScrollPane.setVerticalScrollBarPolicy(20);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSrcList);
        jScrollPane2.setPreferredSize(this.mSrcList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mDescriptionTextArea);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setPreferredSize(new Dimension(110, 90));
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MC_NEW_EQUATION_FUNCTION_GROUP_LABEL");
        jLabel3.setLabelFor(this.mFunctionGroupList);
        JScrollPane jScrollPane4 = new JScrollPane(this.mFunctionGroupList);
        jScrollPane4.setVerticalScrollBarPolicy(20);
        jScrollPane4.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_MC_NEW_EQUATION_FUNCTION_AND_VARIABLE_LABEL");
        jLabel4.setLabelFor(this.mSpecialVariableList);
        JScrollPane jScrollPane5 = new JScrollPane(this.mSpecialVariableList);
        jScrollPane5.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNumericExpressionLabel, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 2;
        this.mInsets.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTargetTextField), this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 1, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(insets.top, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 1, 2, 4, n, this.mInsets);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_MC_EQUATION_COMMENT_LABEL");
        int n3 = 0;
        this.mCommnentEdit.setTabSize(n3);
        JScrollPane jScrollPane6 = new JScrollPane((Component)((Object)this.mCommnentEdit));
        jScrollPane6.setVerticalScrollBarPolicy(20);
        int n4 = jScrollPane6.getPreferredSize().width;
        int n5 = jScrollPane.getPreferredSize().height;
        jScrollPane6.setPreferredSize(new Dimension(n4, n5));
        this.mCommnentEdit.getDocument().addDocumentListener(this);
        jLabel5.setLabelFor((Component)((Object)this.mCommnentEdit));
        this.mInsets.set(n2, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel5, this.mConstraints, 4, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(insets.top, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane6, this.mConstraints, 4, 1, 1, 4, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(2, n2 * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetEditButton, this.mConstraints, 0, 2, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSimulistLabel, this.mConstraints, 0, 3, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, insets2.left, n2, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mSimulatedArrowButton, this.mConstraints, 1, 4, 1, 1, 19, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(0, n2, 2, 0);
        Dimension dimension = this.mSrcList.getMinimumSize();
        JScrollPane jScrollPane7 = new JScrollPane(this.mSimuList);
        jScrollPane7.setPreferredSize(new Dimension(dimension.width, (int)((double)dimension.height / 2.0)));
        DialogUtil.addUsingGBL(jPanel, jScrollPane7, this.mConstraints, 0, 4, 1, 3, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(2, n2, n2, 0);
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupSimulatedButtonPanel(), this.mConstraints, 0, 7, 1, 1, n, this.mInsets);
        JLabel jLabel6 = DialogUtil.createLabel(this, "IDS_MC_NEW_EQUATION_FIELD_LABEL");
        jLabel6.setLabelFor(this.mSrcList);
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel6, this.mConstraints, 0, 8, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, this.mConstraints, 0, 9, 1, 4, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mNumericArrowButton, this.mConstraints, 1, 9, 1, 1, 19, this.mInsets);
        JLabel jLabel7 = new JLabel("   ");
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, insets2.left, n2, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jLabel7, this.mConstraints, 1, 10, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(n2, insets2.left, 0, insets2.right);
        this.mConstraints.fill = 1;
        this.mInsets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, this.mConstraints, 2, 6, 1, 6, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2 * 2, insets2.left, 0, n2 * 3);
        n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionArrowButton, this.mConstraints, 3, 9, 1, 2, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n2 * 2, insets2.left, 0, n2 * 3);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, this.mConstraints, 1, 12, 3, 1, n, this.mInsets);
        this.mConstraints.fill = 0;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(n2, insets2.left, 0, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, jLabel3, this.mConstraints, 4, 5, 1, 1, n, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(0, insets2.left, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, this.mConstraints, 4, 6, 1, 4, n, null);
        this.mConstraints.fill = 0;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(n2, 0, -n2, 0);
        n = 21;
        DialogUtil.addUsingGBL(jPanel, jLabel4, this.mConstraints, 4, 10, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(-n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane5, this.mConstraints, 4, 11, 1, 2, n, null);
    }

    private JPanel setupSimulatedButtonPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSimuNewButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSimuEditButton, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private Vector<String> getSupportedFunctions() {
        Vector<String> vector = new Vector<String>();
        vector.add("Abs");
        vector.add("Cdf.Normal");
        vector.add("Cdfnorm");
        vector.add("Exp");
        vector.add("Idf.Normal");
        vector.add("Lg10");
        vector.add("Ln");
        vector.add("Max");
        vector.add("Mean");
        vector.add("Min");
        vector.add("Mod");
        vector.add("Pdf.Normal");
        vector.add("Rnd(1)");
        vector.add("Rnd(2)");
        vector.add("Rnd(3)");
        vector.add("Sd");
        vector.add("Sqrt");
        vector.add("Sum");
        vector.add("Sysmis");
        vector.add("Trunc(1)");
        vector.add("Trunc(2)");
        vector.add("Trunc(3)");
        vector.add("Value");
        vector.add("Variance");
        return vector;
    }

    private class ExpressionTextField
    extends JTextField {
        public ExpressionTextField(String string) {
            super(string);
        }

        @Override
        public void setText(String string) {
            EquationSubDlg.this.mOriginalExpression = string;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(string);
            if (n <= this.getWidth()) {
                super.setText(string);
                return;
            }
            String string2 = "...";
            int n2 = 1;
            int n3 = 0;
            String string3 = "";
            while (n3 < this.getWidth() - 10) {
                string3 = EquationSubDlg.this.mOriginalExpression.substring(0, n2);
                string3 = string3 + string2;
                n3 = fontMetrics.stringWidth(string3);
                ++n2;
            }
            super.setText(string3);
        }

        @Override
        public String getText() {
            return EquationSubDlg.this.mOriginalExpression;
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            this.putValue("Name", EquationSubDlg.this.getResString("IDS_MC_NEW_EQUATION_NEW_LABEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EquationSubDlg.this.runNewFieldSubDlg(true, true);
        }
    }

    class SFListModel
    extends VarListModel {
        protected SFListModel(VariableList variableList) {
            super(variableList);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable, boolean bl) {
            super.addElement(iSpssVariable, bl);
            this.sort();
            return true;
        }

        @Override
        public void sort() {
            try {
                ISpssVariable[] iSpssVariableArray = this.mVarList.getSelectedValues();
                Collections.sort(this.mVariables, new SpssVariableComparator(SpssVariableSortType.alpha, false));
                this.mVarList.clearSelection();
                this.mVarList.setSelection(iSpssVariableArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class TextDocumentListener
    implements DocumentListener {
        private TextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            EquationSubDlg.this.enableContinue(EquationSubDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)EquationSubDlg.this.mNumericTextArea)) && EquationSubDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)EquationSubDlg.this.mTargetTextField)));
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            EquationSubDlg.this.enableContinue(EquationSubDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)EquationSubDlg.this.mNumericTextArea)) && EquationSubDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)EquationSubDlg.this.mTargetTextField)));
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

