/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.MC.FloatFieldEditor;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.res.MCResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class DistributionParametersPanel
extends JPanel
implements ItemListener,
KeyListener {
    private Dimension mPreviewImageSize = null;
    private String mDistLabelText = null;
    private Map<String, SimulationHelper.DistributionType> mNameTypeMap;
    private boolean mShowGraph = true;
    private SimulationHelper.ParametersPanelCallback mCallback;
    private ResourceBundle mResBundle;
    private SimulatedField mSimulatedField = null;
    private String mImageKey = null;
    private int mRow = -1;
    private int mCol = -1;
    private boolean mEnable;
    private JComboBox mDistNamesCombo = new JComboBox();
    private JTable mParamTable = new JTable();
    private SimulationHelper.PreviewCanvas mCanvas;
    private JLabel mParamLbl;
    private JLabel mDistLabel;
    private RightAlignCellRenderer mRightAlignCellRenderer;
    private FloatFieldEditor mFloatFieldEditor;
    private TextFieldEditor mTextFieldEditor;
    private DistParamNameCellRenderer mDistParamNameCellRenderer;
    private JLabel mMinLbl;
    private FloatTextField mMinValue;
    private JLabel mMaxLbl;
    private FloatTextField mMaxValue;
    private String mAccessName = "";
    private boolean mCallItemState = true;

    public DistributionParametersPanel(SimulationHelper.ParametersPanelCallback parametersPanelCallback, boolean bl) {
        this.mCallback = parametersPanelCallback;
        this.mNameTypeMap = SimulationHelper.buildDistributionNameTypeMap();
        this.mParamTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DistributionParametersPanel.this.mParamTable.rowAtPoint(mouseEvent.getPoint());
                DistributionParametersPanel.this.doParametersTableSelectionChange(n);
            }
        });
        this.mParamTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    int n = DistributionParametersPanel.this.mParamTable.getSelectedRow();
                    if (n > 0) {
                        DistributionParametersPanel.this.doParametersTableSelectionChange(n - 1);
                    }
                } else if (keyEvent.getKeyCode() == 40) {
                    int n = DistributionParametersPanel.this.mParamTable.getSelectedRow();
                    if (n < DistributionParametersPanel.this.mParamTable.getRowCount() - 1) {
                        DistributionParametersPanel.this.doParametersTableSelectionChange(n + 1);
                    }
                } else if (keyEvent.getModifiers() == 8) {
                    if (keyEvent.getKeyCode() == 88 && DistributionParametersPanel.this.mMaxValue.isEnabled()) {
                        DistributionParametersPanel.this.mMaxValue.requestFocus();
                    } else if (keyEvent.getKeyCode() == 77 && DistributionParametersPanel.this.mMinValue.isEnabled()) {
                        DistributionParametersPanel.this.mMinValue.requestFocus();
                    } else if (keyEvent.getKeyCode() == 89) {
                        DistributionParametersPanel.this.mDistNamesCombo.requestFocus();
                    }
                }
            }
        });
        this.mShowGraph = bl;
        this.mResBundle = ResUtil.getBundle(MCResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.mMinLbl = this.createLabel("IDS_MC_SIMPLE_FIELD_MIN");
        this.mMaxLbl = this.createLabel("IDS_MC_SIMPLE_FIELD_MAX");
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DistributionParametersPanel.this.mParamTable != null && DistributionParametersPanel.this.mParamTable.isEditing()) {
                    DistributionParametersPanel.this.mParamTable.getCellEditor().stopCellEditing();
                }
            }
        };
        this.mMinValue = new FloatTextField(5);
        this.mMaxValue = new FloatTextField(5);
        this.mMinValue.addFocusListener((FocusListener)focusAdapter);
        this.mMaxValue.addFocusListener((FocusListener)focusAdapter);
        JPanel jPanel = new JPanel();
        jPanel.setFocusable(true);
        jPanel.setBorder(null);
        jPanel.setLayout(new FlowLayout(0, 2, 2));
        jPanel.add(this.mMinLbl);
        jPanel.add((Component)this.mMinValue);
        jPanel.add(this.mMaxLbl);
        jPanel.add((Component)this.mMaxValue);
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        this.mMinValue.addKeyListener((KeyListener)this);
        this.mMaxValue.addKeyListener((KeyListener)this);
        this.mCanvas = new SimulationHelper.PreviewCanvas(null);
        this.mCanvas.setPreferredSize(new Dimension(120, 100));
        this.mCanvas.setMinimumSize(new Dimension(120, 100));
        this.mCanvas.setMaximumSize(new Dimension(120, 100));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 5;
        String string = this.mDistLabelText != null ? this.mDistLabelText : this.mResBundle.getString("IDS_MC_NAME_TYPE_TYPE_LABEL");
        this.mDistLabel = this.createLabel("IDS_MC_NAME_TYPE_TYPE_LABEL");
        String[] stringArray = this.mResBundle.getStringArray("IDS_MC_SIMULATED_FIELD_TABLE_COLUMN_NAME_ARRARY");
        this.mParamLbl = this.createLabel("IDS_MC_SIMULATED_FIELD_TABLE_PARAMETERS");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = this.mParamLbl.getPreferredSize().height;
        this.mParamLbl.setPreferredSize(new Dimension(160, n2));
        this.mParamLbl.setMinimumSize(new Dimension(160, n2));
        DialogUtil.addUsingGBL(this, this.mDistLabel, gridBagConstraints, 0, 0, 1, 1, 23, new Insets(0, n, 0, n));
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mDistNamesCombo, gridBagConstraints, 1, 0, 1, 1, 23, new Insets(0, n, 0, n));
        DialogUtil.addUsingGBL(this, this.mParamLbl, gridBagConstraints, 0, 1, 2, 1, 23, new Insets(0, n, 0, n));
        if (this.mShowGraph) {
            DialogUtil.addUsingGBL(this, this.mCanvas, gridBagConstraints, 2, 0, 1, 4, 23, new Insets(0, 0, 0, n));
        }
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 3, 2, 1, 23, new Insets(0, n, 0, n));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, new JScrollPane(this.mParamTable), gridBagConstraints, 0, 2, 2, 1, 23, new Insets(0, n, 0, n));
        this.mRightAlignCellRenderer = new RightAlignCellRenderer();
        this.mFloatFieldEditor = new FloatFieldEditor(new FloatTextField(5));
        this.mTextFieldEditor = new TextFieldEditor(new JTextField(5));
        this.mDistParamNameCellRenderer = new DistParamNameCellRenderer();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            JComboBox jComboBox = (JComboBox)itemEvent.getSource();
            SimulationHelper.DistributionType distributionType = this.mNameTypeMap.get(jComboBox.getSelectedItem());
            if (distributionType == null) {
                return;
            }
            this.mSimulatedField.setDistributionType(distributionType);
            ArrayList<Pair<String, String>> arrayList = this.mSimulatedField.getParametersFor(distributionType);
            if (arrayList != null && arrayList.size() > 0) {
                this.mSimulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
            } else {
                this.mSimulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.DistributionNotSet);
            }
            this.mCallback.getImageMap().remove(this.mImageKey);
            if (this.mCallItemState) {
                this.updatePanel(this.mSimulatedField, this.mRow, this.mCol, this.mEnable);
            }
            this.mCallback.processDistributionSelection(jComboBox.getSelectedItem(), this.mNameTypeMap.get(jComboBox.getSelectedItem()));
        }
    }

    public void updatePanel(SimulatedField simulatedField, int n, int n2) {
        this.updatePanel(simulatedField, n, n2, true);
    }

    public void updatePanel(SimulatedField simulatedField, int n, boolean bl) {
        this.updatePanel(simulatedField, n, -1, bl);
    }

    public JComboBox getComboBox() {
        return this.mDistNamesCombo;
    }

    public void updatePanel(SimulatedField simulatedField, int n, int n2, boolean bl) {
        int n3;
        String string;
        String[] stringArray;
        this.mSimulatedField = simulatedField;
        this.mImageKey = SimulationHelper.createImageKey(n, n2);
        this.mRow = n;
        this.mCol = n2;
        this.mEnable = bl;
        String[] stringArray2 = stringArray = simulatedField != null ? SimulationHelper.getDistributionNames(simulatedField) : null;
        if (stringArray != null) {
            this.mDistNamesCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        } else {
            this.mDistNamesCombo.setModel(new DefaultComboBoxModel());
        }
        this.mDistNamesCombo.setEnabled(bl);
        this.mDistNamesCombo.removeItemListener(this);
        this.mDistNamesCombo.removeKeyListener(this);
        this.mDistNamesCombo.getAccessibleContext();
        Object[][] objectArray = null;
        if (simulatedField != null) {
            string = SimulationHelper.getDistributionName(simulatedField.getDistributionType());
            this.mCallItemState = false;
            this.mDistNamesCombo.setSelectedItem(string);
            this.mCallItemState = true;
            this.mDistNamesCombo.addItemListener(this);
            this.mDistNamesCombo.addKeyListener(this);
            if (this.mShowGraph) {
                this.mCanvas.setVisible(true);
            } else {
                this.mCanvas.setVisible(false);
            }
            objectArray = this.getParametersForField(simulatedField);
            BufferedImage bufferedImage = this.getImageForField(simulatedField, n, n2, this.mPreviewImageSize, true);
            this.mCanvas.setImage(bufferedImage);
            if (simulatedField.getMinValue() == Double.NEGATIVE_INFINITY) {
                this.mMinValue.setText("");
            } else {
                this.mMinValue.setText(String.valueOf(simulatedField.getMinValue()));
            }
            if (simulatedField.getMaxValue() == Double.POSITIVE_INFINITY) {
                this.mMaxValue.setText("");
            } else {
                this.mMaxValue.setText(String.valueOf(simulatedField.getMaxValue()));
            }
        }
        this.mParamTable = this.updateParametersTable(objectArray, simulatedField, this.mImageKey);
        this.mParamTable.setEnabled(bl);
        this.mDistLabel.setEnabled(this.mEnable);
        this.mParamLbl.setEnabled(this.mEnable);
        this.enableMinMaxPanel(this.mEnable);
        String string2 = string = simulatedField != null ? simulatedField.getParametersFor(simulatedField.getDistributionType()) : null;
        if (string != null) {
            int n4 = SimulationHelper.getNumberOfParameters(simulatedField);
            int n5 = n3 = ((ArrayList)((Object)string)).size() > n4 ? 1 : 0;
            if (n3 != 0 && simulatedField.getDistributionType() != SimulationHelper.DistributionType.RANGE && simulatedField.getDistributionType() != SimulationHelper.DistributionType.MULTINOMIAL) {
                this.mParamLbl.setEnabled(false);
                this.mParamTable.setEnabled(false);
                this.enableMinMaxPanel(false);
            }
        }
        if (simulatedField == null) {
            this.mDistNamesCombo.setEnabled(false);
            this.mParamTable.setEnabled(false);
            this.enableMinMaxPanel(false);
        } else if (!SimulationHelper.isMinMaxSupported(simulatedField.getDistributionType())) {
            this.enableMinMaxPanel(false);
        }
        this.mAccessName = this.mDistLabel.getText();
        if (this.mDistNamesCombo.getSelectedItem() != null) {
            this.mAccessName = this.mAccessName + " " + this.mDistNamesCombo.getSelectedItem().toString();
        }
        this.mAccessName = this.mAccessName + this.mParamLbl.getText() + " ";
        int n6 = this.mParamTable.getColumnCount();
        for (n3 = 0; this.mParamTable.getModel() != null && n6 > 0 && n3 < this.mParamTable.getRowCount(); ++n3) {
            Object object;
            Object object2 = this.mParamTable.getValueAt(n3, 0);
            if (object2 != null) {
                this.mAccessName = this.mAccessName + object2.toString();
            }
            if (n6 != 2 || (object = this.mParamTable.getValueAt(n3, 1)) == null) continue;
            try {
                if (object.toString().length() <= 0) continue;
                double d = Double.parseDouble(object.toString());
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(2);
                this.mAccessName = this.mAccessName + " " + numberFormat.format(d);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.mAccessName = this.mAccessName + " " + object.toString();
            }
        }
    }

    public String getAccessName() {
        return this.mAccessName;
    }

    private String[][] getParametersForField(SimulatedField simulatedField) {
        ArrayList<Pair<String, String>> arrayList = simulatedField != null ? simulatedField.getParametersFor(simulatedField.getDistributionType()) : null;
        String[][] stringArray = null;
        if (arrayList == null || arrayList.size() == 0) {
            if (stringArray == null) {
                stringArray = SimulationHelper.getDefaulCells(simulatedField);
            }
        } else {
            stringArray = new String[arrayList.size()][2];
            int n = 0;
            Pair<String, String>[] pairArray = SimulationHelper.getParamNames(simulatedField.getDistributionType());
            block0: for (Pair<String, String> pair : arrayList) {
                for (Pair<String, String> pair2 : pairArray) {
                    if (((String)pair2.getFirst()).length() == 0) {
                        stringArray[n][0] = (String)pair.getFirst();
                        stringArray[n][1] = (String)pair.getSecond();
                        ++n;
                        continue block0;
                    }
                    if (!((String)pair.getFirst()).equalsIgnoreCase((String)pair2.getFirst())) continue;
                    stringArray[n][0] = (String)pair2.getSecond();
                    stringArray[n][1] = (String)pair.getSecond();
                    ++n;
                    continue block0;
                }
            }
        }
        return stringArray;
    }

    public BufferedImage getImageForField(SimulatedField simulatedField, int n, Dimension dimension, boolean bl) {
        return this.getImageForField(simulatedField, n, -1, dimension, bl);
    }

    public BufferedImage getImageForField(SimulatedField simulatedField, int n, int n2, Dimension dimension, boolean bl) {
        String string = SimulationHelper.createImageKey(n, n2);
        Object[][] objectArray = this.getParametersForField(simulatedField);
        Map<String, BufferedImage> map = this.mCallback.getImageMap();
        BufferedImage bufferedImage = map.get(string);
        if (bufferedImage == null) {
            bufferedImage = SimulationHelper.createPreviewImage(objectArray, simulatedField.getDistributionType(), simulatedField, this.mCallback.getScannedVarMap(), dimension);
        }
        if (bl && bufferedImage != null) {
            map.put(string, bufferedImage);
        }
        return bufferedImage;
    }

    public void setDistLabelText(String string) {
        this.mDistLabelText = string;
    }

    public Dimension getPreviewImageSize() {
        return this.mPreviewImageSize;
    }

    public void setPreviewImageSize(Dimension dimension) {
        this.mPreviewImageSize = dimension;
    }

    public void updateImage() {
        this.mCallback.getImageMap().remove(this.mImageKey);
        this.updatePanel(this.mSimulatedField, this.mRow, this.mCol, this.mEnable);
    }

    private JTable updateParametersTable(Object[][] objectArray, final SimulatedField simulatedField, final String string) {
        DistributionTableModel distributionTableModel;
        if (simulatedField == null) {
            objectArray = objectArray == null ? this.getParametersForField(null) : objectArray;
            distributionTableModel = new DistributionTableModel(objectArray, new String[]{"", ""});
            this.mParamTable.setModel(distributionTableModel);
        } else {
            distributionTableModel = new DistributionTableModel(objectArray, new String[]{"", ""});
            this.mParamTable.setModel(distributionTableModel);
            this.mParamTable.getModel().addTableModelListener(new TableModelListener(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getType() == 0) {
                        ArrayList<Object> arrayList;
                        DistributionTableModel distributionTableModel = (DistributionTableModel)DistributionParametersPanel.this.mParamTable.getModel();
                        Object[][] objectArray = distributionTableModel.getCellValues();
                        if (simulatedField.getType() == 0) {
                            for (Object[] object2 : objectArray) {
                                if (object2[0] != null && ((String)object2[0]).length() > 0 && simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL && simulatedField.getType() == 0) {
                                    try {
                                        Double.parseDouble((String)object2[0]);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        Toolkit.getDefaultToolkit().beep();
                                        JOptionPane.showMessageDialog(DistributionParametersPanel.this, DistributionParametersPanel.this.mResBundle.getString("IDS_MC_ERROR_ENTER_NUMBER"));
                                        DistributionParametersPanel.this.mParamTable.setValueAt("", DistributionParametersPanel.this.mParamTable.getSelectedRow(), DistributionParametersPanel.this.mParamTable.getSelectedColumn());
                                        DistributionParametersPanel.this.mParamTable.requestFocus();
                                        return;
                                    }
                                }
                                if (object2[1] == null || ((String)object2[1]).length() <= 0) continue;
                                try {
                                    void var10_17;
                                    Pair<String, String>[] pairArray;
                                    double numberFormatException = Double.parseDouble((String)object2[1]);
                                    String string3 = (String)object2[0];
                                    if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL) {
                                        String string2 = "prob";
                                    }
                                    if ((pairArray = SimulationHelper.isParamValueValid(simulatedField.getDistributionType(), (String)var10_17, numberFormatException)).length() <= 0) continue;
                                    Toolkit.getDefaultToolkit().beep();
                                    JOptionPane.showMessageDialog(DistributionParametersPanel.this, pairArray);
                                    DistributionParametersPanel.this.mParamTable.setValueAt("", DistributionParametersPanel.this.mParamTable.getSelectedRow(), DistributionParametersPanel.this.mParamTable.getSelectedColumn());
                                    DistributionParametersPanel.this.mParamTable.requestFocus();
                                    return;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    Toolkit.getDefaultToolkit().beep();
                                    JOptionPane.showMessageDialog(DistributionParametersPanel.this, DistributionParametersPanel.this.mResBundle.getString("IDS_MC_ERROR_ENTER_NUMBER"));
                                    DistributionParametersPanel.this.mParamTable.setValueAt("", DistributionParametersPanel.this.mParamTable.getSelectedRow(), DistributionParametersPanel.this.mParamTable.getSelectedColumn());
                                    DistributionParametersPanel.this.mParamTable.requestFocus();
                                    return;
                                }
                            }
                        }
                        boolean bl = true;
                        if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.RANGE || simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL) {
                            if (SimulationHelper.hasInteration(simulatedField) || DistributionParametersPanel.this.checkSumOfProbs(objectArray, simulatedField.getDistributionType())) {
                                bl = false;
                            }
                            if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL) {
                                // empty if block
                            }
                        } else if (!(simulatedField.getDistributionType() != SimulationHelper.DistributionType.TRIANGULAR && simulatedField.getDistributionType() != SimulationHelper.DistributionType.UNIFORM && simulatedField.getDistributionType() != SimulationHelper.DistributionType.LOGNORMAL || DistributionParametersPanel.this.checkMinMax(objectArray, simulatedField.getDistributionType()))) {
                            return;
                        }
                        if ((arrayList = simulatedField.getParametersFor(simulatedField.getDistributionType())) == null) {
                            arrayList = new ArrayList();
                            simulatedField.addParameter(simulatedField.getDistributionType(), arrayList);
                        }
                        arrayList.clear();
                        Pair<String, String>[] pairArray = SimulationHelper.getParamNames(simulatedField.getDistributionType());
                        block5: for (Object[] objectArray2 : objectArray) {
                            if (objectArray2[1] == null) continue;
                            for (Pair<String, String> pair : pairArray) {
                                if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL) {
                                    arrayList.add((Pair<String, String>)new Pair((Object)((String)objectArray2[0]), (Object)((String)objectArray2[1])));
                                    continue block5;
                                }
                                if (!((String)pair.getSecond()).equals((String)objectArray2[0])) continue;
                                arrayList.add(new Pair(pair.getFirst(), (Object)((String)objectArray2[1])));
                                continue block5;
                            }
                        }
                        if (bl && (simulatedField.getDistributionType() == SimulationHelper.DistributionType.RANGE || simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL)) {
                            DistributionParametersPanel.this.insertBlankRows(distributionTableModel, simulatedField);
                        }
                        BufferedImage bufferedImage = SimulationHelper.createPreviewImage(objectArray, simulatedField.getDistributionType(), simulatedField, DistributionParametersPanel.this.mCallback.getScannedVarMap(), DistributionParametersPanel.this.mPreviewImageSize);
                        DistributionParametersPanel.this.mCallback.getImageMap().put(string, bufferedImage);
                        if (DistributionParametersPanel.this.mCanvas != null) {
                            DistributionParametersPanel.this.mCanvas.setImage(bufferedImage);
                        }
                        DistributionParametersPanel.this.doParametersTableSelectionChange(DistributionParametersPanel.this.mParamTable.getSelectedRow());
                        simulatedField.setAutoFit(MonteCarloSimulationDlg.FitToState.ManualDefined);
                        DistributionParametersPanel.this.mCallback.processTableUpdate(simulatedField);
                    }
                }
            });
            this.revalidate();
        }
        this.mParamTable.setColumnSelectionAllowed(true);
        int n = this.mParamTable.getColumnCount();
        TableColumn tableColumn = null;
        if (this.mParamTable.getColumnModel() != null && n > 0) {
            tableColumn = this.mParamTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(this.mDistParamNameCellRenderer);
        }
        if (this.mParamTable.getColumnModel() != null && n > 1) {
            tableColumn = this.mParamTable.getColumnModel().getColumn(1);
            tableColumn.setCellRenderer(this.mRightAlignCellRenderer);
            if (simulatedField != null) {
                if (simulatedField.getType() == 0) {
                    tableColumn.setCellEditor(this.mFloatFieldEditor);
                } else {
                    tableColumn.setCellEditor(this.mTextFieldEditor);
                }
            }
        }
        if (simulatedField != null && (simulatedField.getDistributionType() == SimulationHelper.DistributionType.RANGE || simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL)) {
            this.doParametersTableSelectionChange(0);
        }
        return this.mParamTable;
    }

    private void insertBlankRows(DistributionTableModel distributionTableModel, SimulatedField simulatedField) {
        if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL && simulatedField.getCatsCount() > 0) {
            return;
        }
        Object[][] objectArray = distributionTableModel.getCellValues();
        boolean bl = false;
        for (Object[] objectArray2 : objectArray) {
            if (objectArray2[1] != null && ((String)objectArray2[1]).length() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Object[][] objectArray3 = SimulationHelper.getDefaulCells(simulatedField);
            distributionTableModel.appendValues((String[][])objectArray3);
        }
    }

    private boolean checkMinMax(Object[][] objectArray, SimulationHelper.DistributionType distributionType) {
        boolean bl = true;
        if (distributionType == SimulationHelper.DistributionType.TRIANGULAR || distributionType == SimulationHelper.DistributionType.UNIFORM || distributionType == SimulationHelper.DistributionType.LOGNORMAL) {
            int n = objectArray.length;
            Vector<Double> vector = new Vector<Double>();
            Vector<Double> vector2 = new Vector<Double>();
            Vector<Double> vector3 = new Vector<Double>();
            Vector<Double> vector4 = new Vector<Double>();
            for (Object[] objectArray2 : objectArray) {
                if (objectArray2[1] == null || ((String)objectArray2[1]).length() <= 0) continue;
                double d = Double.parseDouble((String)objectArray2[1]);
                if ("min".equals(objectArray2[0])) {
                    vector.add(d);
                    continue;
                }
                if ("max".equals(objectArray2[0])) {
                    vector2.add(d);
                    continue;
                }
                if ("mode".equals(objectArray2[0])) {
                    vector3.add(d);
                    continue;
                }
                if (!"b".equals(objectArray2[0])) continue;
                vector4.add(d);
            }
            boolean bl2 = false;
            if (distributionType == SimulationHelper.DistributionType.TRIANGULAR) {
                bl2 = true;
            }
            if (vector2.size() > 0 && vector.size() > 0 && !this.compareValues(vector2, vector, bl2)) {
                bl = false;
            }
            if (bl && vector3.size() > 0 && vector.size() > 0 && !this.compareValues(vector3, vector, bl2)) {
                bl = false;
            }
            if (bl && vector3.size() > 0 && vector2.size() > 0 && !this.compareValues(vector2, vector3, bl2)) {
                bl = false;
            }
            if (bl && vector4.size() > 0 && !this.compareValues(vector4, null, bl2)) {
                bl = false;
            }
            if (!bl) {
                String string = "";
                string = distributionType == SimulationHelper.DistributionType.LOGNORMAL ? this.mResBundle.getString("IDS_MC_INVALID_PARAMETER_VALUE_MIN") : (distributionType == SimulationHelper.DistributionType.TRIANGULAR ? this.mResBundle.getString("IDS_MC_MAX_MODE_MIN_ERROR") : this.mResBundle.getString("IDS_MC_MAX_LESS_MIN_ERROR"));
                JOptionPane.showMessageDialog(this, string);
                this.mParamTable.setValueAt("", this.mParamTable.getSelectedRow(), this.mParamTable.getSelectedColumn());
                this.mParamTable.requestFocus();
            }
        }
        return bl;
    }

    private boolean compareValues(Vector<Double> vector, Vector<Double> vector2, boolean bl) {
        double d = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            double d2 = vector.get(i);
            if (vector2 != null) {
                for (int j = 0; j < vector2.size(); ++j) {
                    if (d2 < vector2.get(j)) {
                        return false;
                    }
                    if (bl || d2 != vector2.get(j)) continue;
                    return false;
                }
                continue;
            }
            if (!(d2 <= d)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSumOfProbs(Object[][] objectArray, SimulationHelper.DistributionType distributionType) {
        double d = 0.0;
        boolean bl = false;
        if (distributionType == SimulationHelper.DistributionType.RANGE) {
            for (Object[] objectArray2 : objectArray) {
                if (!"prob".equals(objectArray2[0]) || objectArray2[1] == null || ((String)objectArray2[1]).length() <= 0) continue;
                d += Double.parseDouble((String)objectArray2[1]);
            }
        } else if (distributionType == SimulationHelper.DistributionType.MULTINOMIAL) {
            for (Object[] objectArray2 : objectArray) {
                if (objectArray2[1] == null || ((String)objectArray2[1]).length() <= 0) continue;
                d += Double.parseDouble(UIToolResUtil.removeLocale((String)((String)objectArray2[1])));
                if (objectArray2[0] != null) continue;
                bl = true;
            }
        }
        if (d < 1.0) {
            return false;
        }
        if (Math.abs(d - 1.0) <= SimulationHelper.sProbTolerance || bl) {
            return true;
        }
        if (Math.abs(d - 1.0) > SimulationHelper.sProbTolerance) {
            String string = "" + d;
            String string2 = String.format(ComponentState.getSPSSLocale(), this.mResBundle.getString("IDS_MC_ERROR_SUM_OVER_ONE"), string);
            JOptionPane.showMessageDialog(this, string2);
            String string3 = (String)this.mParamTable.getValueAt(this.mParamTable.getSelectedRow(), 1);
            double d2 = Double.parseDouble(string3) - (d - 1.0);
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            this.mParamTable.setValueAt(String.valueOf(d2), this.mParamTable.getSelectedRow(), 1);
            return true;
        }
        return false;
    }

    public JTable getParamTable() {
        return this.mParamTable;
    }

    public JComboBox getDistNamesCombo() {
        return this.mDistNamesCombo;
    }

    public JTextField getMinField() {
        return this.mMinValue;
    }

    public JTextField getMaxField() {
        return this.mMaxValue;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.mSimulatedField == null) {
            return;
        }
        final Object object = keyEvent.getSource();
        if (object != this.mDistNamesCombo && keyEvent.getKeyCode() == 10) {
            double d;
            double d2;
            keyEvent.consume();
            String string = this.mMinValue.getText();
            String string2 = this.mMaxValue.getText();
            if (string.length() > 0 && string2.length() > 0 && (d2 = Double.parseDouble(string)) >= (d = Double.parseDouble(string2))) {
                if (object == this.mMinValue) {
                    JOptionPane.showMessageDialog(this, this.mResBundle.getString("IDS_MC_MIN_GREAT_MAX_ERROR"));
                    this.mMinValue.setText("");
                } else if (object == this.mMaxValue) {
                    JOptionPane.showMessageDialog(this, this.mResBundle.getString("IDS_MC_MAX_LESS_MIN_ERROR"));
                    this.mMaxValue.setText("");
                }
            }
            return;
        }
        if ((object == this.mMinValue || object == this.mMaxValue || object == this.mDistNamesCombo) && keyEvent.getModifiers() == 8) {
            if (keyEvent.getKeyCode() == 88) {
                this.mMaxValue.requestFocus();
            } else if (keyEvent.getKeyCode() == 77) {
                this.mMinValue.requestFocus();
            } else if (keyEvent.getKeyCode() == 84) {
                this.mParamTable.requestFocus();
                this.mParamTable.setRowSelectionInterval(0, 0);
                this.mParamTable.setColumnSelectionInterval(1, 1);
            } else if (keyEvent.getKeyCode() == 89) {
                this.mDistNamesCombo.requestFocus();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string;
                if (object == DistributionParametersPanel.this.mMinValue) {
                    String string2 = DistributionParametersPanel.this.mMinValue.getText();
                    if (string2.length() > 0) {
                        DistributionParametersPanel.this.mSimulatedField.setMinValue(Double.parseDouble(string2));
                    }
                } else if (object == DistributionParametersPanel.this.mMaxValue && (string = DistributionParametersPanel.this.mMaxValue.getText()).length() > 0) {
                    DistributionParametersPanel.this.mSimulatedField.setMaxValue(Double.parseDouble(string));
                }
            }
        });
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void enableMinMaxPanel(boolean bl) {
        this.mMinLbl.setEnabled(bl);
        this.mMinValue.setEnabled(bl);
        this.mMaxLbl.setEnabled(bl);
        this.mMaxValue.setEnabled(bl);
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(this.mResBundle.getString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string + "_KEY";
            Integer n = (Integer)UIToolResUtil.getObject((String)(string2 = string2.replace("IDS_", "IDK_")), (ResourceBundle)this.mResBundle);
            if (n != null) {
                jLabel.setDisplayedMnemonic(n);
            }
        }
        return jLabel;
    }

    private void doParametersTableSelectionChange(int n) {
        if (n < 0) {
            return;
        }
        SimulationHelper.DistributionType distributionType = this.mSimulatedField.getDistributionType();
        if (distributionType == SimulationHelper.DistributionType.RANGE) {
            Object[] objectArray;
            int n2 = n % 3;
            Object object = this.mParamTable.getValueAt(n - n2, 1);
            Object object2 = this.mParamTable.getValueAt(n - n2 + 1, 1);
            Object object3 = this.mParamTable.getValueAt(n - n2 + 2, 1);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (object != null && object2 != null && object3 != null) {
                objectArray = Double.valueOf((String)object);
                Double d = Double.valueOf((String)object2);
                for (int i = 0; i < this.mParamTable.getRowCount() - 2; ++i) {
                    Object object4;
                    Object object5;
                    Object object6 = this.mParamTable.getValueAt(i, 1);
                    if (!(object6 instanceof String) || !objectArray.equals(Double.valueOf((String)object6)) || !((object5 = this.mParamTable.getValueAt(i + 1, 1)) instanceof String) || !d.equals(Double.valueOf((String)object5)) || !((object4 = this.mParamTable.getValueAt(i + 2, 1)) instanceof String) || ((String)object4).length() <= 0) continue;
                    arrayList.add((String)object4);
                }
            }
            objectArray = new Object[arrayList.size() + 2];
            if (object instanceof String) {
                objectArray[0] = Double.valueOf((String)object);
            }
            if (object2 instanceof String) {
                objectArray[1] = Double.valueOf((String)object2);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray[i + 2] = Double.valueOf((String)arrayList.get(i));
            }
            this.mSimulatedField.setSelectedParameters(objectArray);
        } else if (distributionType == SimulationHelper.DistributionType.MULTINOMIAL) {
            if (this.mParamTable.getModel() == null || this.mParamTable.getColumnCount() == 0 || this.mParamTable.getRowCount() == 0) {
                return;
            }
            Object object = this.mParamTable.getValueAt(n, 0);
            if (object instanceof String && ((String)object).length() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                int n3 = this.mParamTable.getColumnCount();
                for (int i = 0; i < this.mParamTable.getRowCount(); ++i) {
                    String string;
                    if (!object.equals(this.mParamTable.getValueAt(i, 0)) || (string = (String)this.mParamTable.getValueAt(i, 1)) == null || string.length() <= 0) continue;
                    arrayList.add(string);
                }
                Object[] objectArray = new Object[arrayList.size() + 1];
                try {
                    objectArray[0] = Double.valueOf((String)object);
                }
                catch (Exception exception) {
                    objectArray[0] = (String)object;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    objectArray[i + 1] = Double.valueOf(UIToolResUtil.removeLocale((String)((String)arrayList.get(i))));
                }
                this.mSimulatedField.setSelectedParameters(objectArray);
            }
        } else {
            this.mSimulatedField.setSelectedParameters(null);
        }
    }

    class DistParamNameCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            DistParamNameCellRenderer distParamNameCellRenderer = (DistParamNameCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            DistributionTableModel distributionTableModel = (DistributionTableModel)jTable.getModel();
            int n3 = 0;
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                if (object == null || !object.equals(distributionTableModel.getValueAt(i, 0))) continue;
                ++n3;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            if (n3 > 1) {
                int n4 = 0;
                for (int i = 0; i <= n; ++i) {
                    if (object == null || !object.equals(distributionTableModel.getValueAt(i, 0))) continue;
                    ++n4;
                }
                if (object != null && DistributionParametersPanel.this.mSimulatedField != null && DistributionParametersPanel.this.mSimulatedField.getDistributionType() == SimulationHelper.DistributionType.RANGE) {
                    stringBuffer.append(this.getRangeText(object, n4, n));
                } else {
                    String string2;
                    if (object != null && DistributionParametersPanel.this.mSimulatedField != null && DistributionParametersPanel.this.mSimulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL && (string2 = DistributionParametersPanel.this.mSimulatedField.getCatLabelForValue(object.toString())) != null) {
                        stringBuffer.append(object + " [" + string2 + "]");
                    }
                    if (stringBuffer.toString().length() == 0) {
                        stringBuffer.append(object);
                    }
                    if (object != null && ((String)object).length() > 0) {
                        stringBuffer.append("(" + n4 + ")");
                    }
                }
            } else if (object != null && DistributionParametersPanel.this.mSimulatedField != null && DistributionParametersPanel.this.mSimulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL && (string = DistributionParametersPanel.this.mSimulatedField.getCatLabelForValue(object.toString())) != null) {
                stringBuffer.append(object + " [" + string + "]");
            }
            if (stringBuffer.length() > 0) {
                this.setText(stringBuffer.toString());
            }
            if (DistributionParametersPanel.this.mSimulatedField == null || DistributionParametersPanel.this.mSimulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(Color.gray);
            }
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                distParamNameCellRenderer = (DistParamNameCellRenderer)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            }
            return distParamNameCellRenderer;
        }

        private String getRangeText(Object object, int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer("");
            Vector<Vector<Double>> vector = DistributionParametersPanel.this.mSimulatedField.getAllRangeProbs();
            if (vector != null && vector.size() > 0 && object.toString().equalsIgnoreCase("prob") && vector.get(0).size() > 1) {
                int n3 = vector.get(0).size() + 2;
                int n4 = n2 / n3 + 1;
                int n5 = (n - 1) % (n3 - 2) + 1;
                stringBuffer.append(object + "[" + n4 + "](" + n5 + ")");
            }
            if (stringBuffer.toString().length() == 0) {
                stringBuffer.append(object + "[" + n + "]");
            }
            return stringBuffer.toString();
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    class TextFieldEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTextField mField;

        TextFieldEditor(JTextField jTextField) {
            super(jTextField);
            this.mField = jTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null) {
                this.mField.setText(object.toString());
            } else {
                this.mField.setText("");
            }
            if (object != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextFieldEditor.this.mField.setSelectionStart(0);
                        TextFieldEditor.this.mField.setSelectionEnd(TextFieldEditor.this.mField.getText().length());
                        TextFieldEditor.this.mField.requestFocus();
                    }
                });
            }
            return this.mField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mField.getText();
        }
    }

    class RightAlignCellRenderer
    extends DefaultTableCellRenderer {
        public RightAlignCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RightAlignCellRenderer rightAlignCellRenderer = (RightAlignCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null && n2 == 1) {
                String string = (String)object;
                try {
                    double d = Double.parseDouble(string);
                    if (string.length() > 0) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
                        numberFormat.setGroupingUsed(false);
                        numberFormat.setMaximumFractionDigits(2);
                        this.setText(numberFormat.format(d));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setText(string);
                }
            }
            return rightAlignCellRenderer;
        }
    }

    class DistributionTableModel
    extends AbstractTableModel {
        private Object[][] mCellArray;
        private String[] mColTitles;

        public DistributionTableModel(Object[][] objectArray, String[] stringArray) {
            this.mCellArray = objectArray;
            this.mColTitles = stringArray;
        }

        @Override
        public int getRowCount() {
            return this.mCellArray.length;
        }

        @Override
        public int getColumnCount() {
            return this.mColTitles.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.mCellArray[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.mCellArray[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public void appendValues(String[][] stringArray) {
            String[][] stringArray2 = new String[this.mCellArray.length + stringArray.length][2];
            System.arraycopy(this.mCellArray, 0, stringArray2, 0, this.mCellArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[this.mCellArray.length + i][0] = stringArray[i][0];
                stringArray2[this.mCellArray.length + i][1] = stringArray[i][1];
            }
            this.mCellArray = stringArray2;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return this.mColTitles[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (DistributionParametersPanel.this.mSimulatedField.getDistributionType() == SimulationHelper.DistributionType.EMPIRICAL) {
                return false;
            }
            if (DistributionParametersPanel.this.mSimulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL && n2 == 0) {
                return !SimulationHelper.hasInteration(DistributionParametersPanel.this.mSimulatedField) && DistributionParametersPanel.this.mSimulatedField.getCatsCount() <= 0;
            }
            if (n2 == 1) {
                if (DistributionParametersPanel.this.mSimulatedField.getDistributionType() != SimulationHelper.DistributionType.RANGE) {
                    return true;
                }
                if (!SimulationHelper.hasInteration(DistributionParametersPanel.this.mSimulatedField)) {
                    return true;
                }
                return n % 3 == 2;
            }
            return false;
        }

        public Object[][] getCellValues() {
            return this.mCellArray;
        }
    }
}

