/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.dialogs.MC.BaseMCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.vis.Visualization;
import com.spss.vis.VisualizationFactory;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.statistic.DistributionType;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.Vector;

public class DistributionImageUtil {
    private static String barWithDist = "<?xml version=\"1.0\"?>\n\n<visualization creator=\"en\" date=\"2012-03-09\" description=\"Bar of count by jobcat gender\" lang=\"en-US\" type=\"21000000\" version=\"1.4\" xmlns=\"http://www.ibm.com/software/analytics/spss/xml/visualization\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/software/analytics/spss/xml/visualization http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-3.0.xsd\">\n  <!-- Size -->\n  <location method=\"fixed\" part=\"left\" value=\"0px\"/>\n  <location method=\"fixed\" part=\"right\" value=\"625px\"/>\n  <location method=\"fixed\" part=\"top\" value=\"0px\"/>\n  <location method=\"fixed\" part=\"bottom\" value=\"500px\"/>\n  <!-- Data -->\n  <embeddedSource id=\"source0\">\n    <names>V4;$COUNT;V8</names>\n    <types>string;double;string</types>\n    <labels>;;</labels>\n    <labelColumns>;;</labelColumns>\n    {0}\n  </embeddedSource>\n  <embeddedSource id=\"source1\">\n    <names>V41;$COUNT1;V81</names>\n    <types>string;double;string</types>\n    <labels>;;</labels>\n    <labelColumns>;;</labelColumns>\n    {1}\n  </embeddedSource>\n  <sourceVariable id=\"variable4\" categorical=\"true\" creator=\"external_datasource\" key=\"false\" label=\"Employment Category\" shortLabel=\"Employment Category\" source=\"source0\" sourceName=\"V4\" weight=\"false\" />\n  <sourceVariable id=\"variable5\" categorical=\"false\" key=\"false\" label=\"Count\" shortLabel=\"Count\" source=\"source0\" sourceName=\"$COUNT\" weight=\"false\">\n    <extension statistic=\"numberOfCases\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable8\" categorical=\"true\" creator=\"external_datasource\" key=\"false\" label=\"Gender\" shortLabel=\"gender\" source=\"source0\" sourceName=\"V8\" weight=\"false\" />\n  <sourceVariable id=\"variable41\" categorical=\"true\" creator=\"external_datasource\" key=\"false\" label=\"Employment Category\" shortLabel=\"Employment Category\" source=\"source1\" sourceName=\"V41\" weight=\"false\" />\n  <sourceVariable id=\"variable51\" categorical=\"false\" key=\"false\" label=\"Count\" shortLabel=\"Count\" source=\"source1\" sourceName=\"$COUNT1\" weight=\"false\">\n    <extension statistic=\"numberOfCases\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable81\" categorical=\"true\" creator=\"external_datasource\" key=\"false\" label=\"Gender\" shortLabel=\"gender\" source=\"source1\" sourceName=\"V81\" weight=\"false\" />\n  <intervalDomain id=\"domain7\" date=\"false\">\n    <range exact=\"false\" max=\"0\" min=\"0\"/>\n  </intervalDomain>\n  <!-- Structure -->\n  <graph cellStyle=\"graphStyle2\" style=\"graphStyle\">\n    <!-- Size -->\n    <location method=\"fixed\" part=\"left\" value=\"1%\"/>\n    <location method=\"fixed\" part=\"top\" value=\"1%\"/>\n    <location method=\"fixed\" part=\"bottom\" value=\"99%\"/>\n    <location method=\"fixed\" part=\"right\" value=\"99%\"/>\n    <coordinates id=\"coordinates_36\">\n      <dimension clusterGap=\"5%\" clusterVariable=\"variable4\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle\"/>\n      </dimension>\n      <dimension domain=\"domain7\" unionDomain=\"true\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle2\"/>\n      </dimension>\n    </coordinates>\n    <coordinates id=\"coordinates_197\">\n      <dimension clusterGap=\"5%\" clusterVariable=\"variable41\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle3\"/>\n      </dimension>\n      <dimension domain=\"domain7\" unionDomain=\"true\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle4\"/>\n      </dimension>\n    </coordinates>\n    <facetLayout topDown=\"true\"/>\n    <interval id=\"element_clusteredbar_1\" coordinates=\"coordinates_36\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_clusteredbar_1\" showCollidingLabels=\"true\" style=\"intervalStyle\">\n      <styleBy styleCycle=\"styleCycleDefault2\" variable=\"variable8\"/>\n      <x variable=\"variable8\"/>\n      <y variable=\"variable5\"/>\n    </interval>\n    <interval id=\"element_clusteredbar_11\" coordinates=\"coordinates_197\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_clusteredbar_11\" showCollidingLabels=\"true\" style=\"intervalStyle2\">\n      <styleBy styleCycle=\"styleCycleDefault\" variable=\"variable81\"/>\n      <x variable=\"variable81\"/>\n      <y variable=\"variable51\"/>\n    </interval>\n  </graph>\n  <!-- Styles -->\n  <style id=\"intervalStyle\" visible=\"{2}\" color=\"red\" color2=\"black\" depth=\"75%\" font-family=\"Arial\" size=\"90%\" stroke-width=\"1px\"/>\n  <style id=\"intervalStyle2\" color=\"#D3CE97\" color2=\"black\" depth=\"75%\" font-family=\"Arial\" opacity=\"0.9\" size=\"{3}\" stroke-width=\"1px\"/>\n  <style id=\"graphStyle\" color=\"transparent\" color2=\"transparent\" font-family=\"Arial\"/>\n  <style id=\"visualizationStyle\" color=\"white\" color2=\"transparent\" />\n  <style id=\"graphStyle2\" color=\"#F0F0F0\" color2=\"black\"/>\n  <style id=\"axisStyle\" color=\"black\" stroke-width=\"0.5pt\"/>\n  <style id=\"axisStyle2\" color=\"black\" stroke-width=\"0.5pt\"/>\n  <style id=\"axisStyle3\" color=\"black\" stroke-width=\"0.5pt\"/>\n  <style id=\"axisStyle4\" color=\"black\" stroke-width=\"0.5pt\"/>\n  <!-- Style Cycles -->\n  <styleCycle id=\"styleCycleDefault2\">\n    <cycle>\n      <style color=\"{4}\"/>\n    </cycle>\n    <extension immutables=\"1\"/>\n  </styleCycle>\n  <styleCycle id=\"styleCycleDefault\">\n    <cycle>\n      {5}\n    </cycle>\n    <extension immutables=\"1\"/>\n  </styleCycle>\n</visualization>";
    private static String histWithDist = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<visualization creator=\"en\" date=\"2011-10-20\" description=\"Area of count by jobcat\" id=\"frame_graph_1\" lang=\"en-US\" style=\"frame_graph_1s\" type=\"20000001\" version=\"1.4\" xmlns=\"http://www.ibm.com/software/analytics/spss/xml/visualization\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/software/analytics/spss/xml/visualization http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-3.0.xsd\">\n  <!--  Extensions  -->\n  <extension id=\"extension_1022789\" styleCycleRepository=\"styleCycleRepository\"/>\n  <!--  Size  -->\n  <location id=\"location_1022785\" method=\"fixed\" part=\"left\" value=\"0px\"/>\n  <location id=\"location_1022786\" method=\"fixed\" part=\"right\" value=\"625px\"/>\n  <location id=\"location_1022787\" method=\"fixed\" part=\"top\" value=\"0px\"/>\n  <location id=\"location_1022788\" method=\"fixed\" part=\"bottom\" value=\"500px\"/>\n  <!--  Data  -->\n  <embeddedSource id=\"source0\">\n    <names>V4;$WEIGHT</names>\n    <types>double;double</types>\n    {0}\n  </embeddedSource>\n  <sourceVariable id=\"variable4\" categorical=\"false\" creator=\"external_datasource\" key=\"false\" label=\"Current Salary\" shortLabel=\"salary\" source=\"source0\" sourceName=\"V4\" weight=\"false\">\n    <format hiddenseparator=\"false\" minimumFractionDigits=\"0\" prefix=\"$\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable5\" categorical=\"false\" creator=\"internal_aggregate\" key=\"false\" label=\"Frequency\" shortLabel=\"Frequency\" source=\"source0\" sourceName=\"$WEIGHT\" weight=\"true\"/>\n  <!--  Structure  -->\n  <graph cellStyle=\"facetLabel_data_1s\" id=\"frame_data_1\" style=\"frame_data_1s\">\n    <!--  Size  -->\n    <location id=\"location_1022796\" method=\"fixed\" part=\"left\" value=\"1%\"/>\n    <location id=\"location_1022797\" method=\"fixed\" part=\"top\" value=\"1%\"/>\n    <location id=\"location_1022798\" method=\"fixed\" part=\"bottom\" value=\"99%\"/>\n    <location id=\"location_1022799\" method=\"fixed\" part=\"right\" value=\"99%\"/>\n    <coordinates id=\"coordinates_33\">\n      <dimension id=\"dimension_34\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisx_1\" repeat=\"never\" style=\"axis_axisx_1s\">     \n        </axis>\n      </dimension>\n      <dimension id=\"dimension_47\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisy_1\" repeat=\"never\" style=\"axis_axisy_1s\">\n        </axis>\n      </dimension>\n    </coordinates>\n    <facetLayout id=\"facetLayout_60\" topDown=\"true\"/>\n    <interval id=\"element_histogram_1\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_histogram_1\" showCollidingLabels=\"true\" style=\"intervalStyle\">\n      <binStatistic binCount=\"{1}\"/>\n      <summaryStatistic method=\"count\"/>\n      <x variable=\"variable4\"/>\n    </interval>\n    {2}\n    <lineGuide style=\"originLineStyle\" y=\"0\"/>\n  </graph>\n  <!--  Styles  -->\n  <style font-family=\"SansSerif\" font-size=\"8pt;6pt;\" id=\"container\" pattern=\"0\" stroke-linecap=\"butt\" text-fit=\"true\">\n    <style color=\"white\" color2=\"transparent\" id=\"frame_graph_1s\"/>\n    <style color=\"transparent\" color2=\"transparent\" id=\"frame_data_1s\"/>\n    <style color=\"#F0F0F0\" color2=\"black\" id=\"facetLabel_data_1s\"/>\n    <style color=\"black\" id=\"axis_axisx_1s\" stroke-width=\"0.5pt\"/> \n    <style color=\"black\" id=\"axis_axisy_1s\" stroke-width=\"0.5pt\"/>\n    <style id=\"intervalStyle\" visible=\"{3}\" color=\"{4}\" color2=\"black\" depth=\"75%\" font-family=\"Arial\" pattern=\"0\" stroke-width=\"1px\" width=\"100%\"/>\n  {5}     <style id=\"originLineStyle\"/>\n  </style>\n</visualization>";
    private static String histTriangle = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<visualization creator=\"en\" date=\"2011-10-20\" description=\"Area of count by jobcat\" id=\"frame_graph_1\" lang=\"en-US\" style=\"frame_graph_1s\" type=\"20000001\" version=\"1.4\" xmlns=\"http://www.ibm.com/software/analytics/spss/xml/visualization\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/software/analytics/spss/xml/visualization http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-3.0.xsd\">\n  <!--  Extensions  -->\n  <extension id=\"extension_1022789\" styleCycleRepository=\"styleCycleRepository\"/>\n  <!--  Size  -->\n  <location id=\"location_1022785\" method=\"fixed\" part=\"left\" value=\"0px\"/>\n  <location id=\"location_1022786\" method=\"fixed\" part=\"right\" value=\"625px\"/>\n  <location id=\"location_1022787\" method=\"fixed\" part=\"top\" value=\"0px\"/>\n  <location id=\"location_1022788\" method=\"fixed\" part=\"bottom\" value=\"500px\"/>\n  <!--  Data  -->\n  <embeddedSource id=\"source0\">\n    <names>V4;$WEIGHT</names>\n    <types>double;double</types>\n    {0}\n  </embeddedSource>\n\n  <embeddedSource id=\"source1\">\n    <names>X2;Y2;V7</names>\n    <types>string;double;string</types>\n    <labels>;;</labels>\n    <labelColumns>;;</labelColumns>\n    {1}\n  </embeddedSource>\n  \n  <sourceVariable id=\"variable4\" categorical=\"false\" creator=\"external_datasource\" key=\"false\" label=\"Current Salary\" shortLabel=\"salary\" source=\"source0\" sourceName=\"V4\" weight=\"false\">\n    <format hiddenseparator=\"false\" minimumFractionDigits=\"0\" prefix=\"$\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable5\" categorical=\"false\" creator=\"internal_aggregate\" key=\"false\" label=\"Frequency\" shortLabel=\"Frequency\" source=\"source0\" sourceName=\"$WEIGHT\" weight=\"true\"/>\n\n  <sourceVariable id=\"variable14\" categorical=\"false\" creator=\"external_datasource\" key=\"false\" source=\"source1\" sourceName=\"X2\" weight=\"false\"/>\n  <sourceVariable id=\"variable15\" categorical=\"false\" key=\"false\" source=\"source1\" sourceName=\"Y2\" weight=\"false\" />\n  <sourceVariable categorical=\"true\" id=\"variable7\" source=\"source1\" sourceName=\"V7\" weight=\"false\" />    \n  <!--  Structure  -->\n  <graph cellStyle=\"facetLabel_data_1s\" id=\"frame_data_1\" style=\"frame_data_1s\">\n    <!--  Size  -->\n    <location id=\"location_1022796\" method=\"fixed\" part=\"left\" value=\"1%\"/>\n    <location id=\"location_1022797\" method=\"fixed\" part=\"top\" value=\"1%\"/>\n    <location id=\"location_1022798\" method=\"fixed\" part=\"bottom\" value=\"99%\"/>\n    <location id=\"location_1022799\" method=\"fixed\" part=\"right\" value=\"99%\"/>\n    <coordinates id=\"coordinates_33\">\n      <dimension id=\"dimension_34\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisx_1\" repeat=\"never\" style=\"axis_axisx_1s\">\n        </axis>\n      </dimension>\n      <dimension id=\"dimension_47\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisy_1\" repeat=\"never\" style=\"axis_axisy_1s\">\n        </axis>\n      </dimension>\n    </coordinates>\n    <facetLayout id=\"facetLayout_60\" topDown=\"true\"/>\n    <interval id=\"element_histogram_1\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_histogram_1\" showCollidingLabels=\"true\" style=\"intervalStyle\">\n      <binStatistic binCount=\"{2}\"/>\n      <summaryStatistic method=\"count\"/>\n      <x variable=\"variable4\"/>\n    </interval>\n    <line style=\"lineStyle\">      \n      <styleBy id=\"styleBy8\" styleCycle=\"styleCycleDefault\" variable=\"variable7\"/>      <x variable=\"variable14\"/>\n      <y variable=\"variable15\"/>\n    </line>\n    <lineGuide style=\"originLineStyle\" y=\"0\"/>\n\n  </graph>\n  <!--  Styles  -->\n  <style font-family=\"SansSerif\" font-size=\"8pt;6pt;\" id=\"container\" pattern=\"0\" stroke-linecap=\"butt\" text-fit=\"true\">\n    <style color=\"white\" color2=\"transparent\" id=\"frame_graph_1s\"/>\n    <style color=\"transparent\" color2=\"transparent\" id=\"frame_data_1s\"/>\n    <style color=\"#F0F0F0\" color2=\"black\" id=\"facetLabel_data_1s\"/>\n    <style color=\"black\" id=\"axis_axisx_1s\" stroke-width=\"0.5pt\"/>\n    <style color=\"black\" id=\"axis_axisy_1s\" stroke-width=\"0.5pt\"/>\n    <style id=\"intervalStyle\" visible=\"{3}\" color=\"#D3CE97\" color2=\"black\" depth=\"75%\" font-family=\"Arial\" pattern=\"0\" stroke-width=\"1px\" width=\"100%\"/>\n    <style id=\"lineStyle\" color=\"blue\" color2=\"transparent\" depth=\"80%\" font-family=\"Arial\" opacity=\"1.0\" stroke-width=\"2px\"/>\n    <style id=\"originLineStyle\"/>\n  </style>\n<styleCycle id=\"styleCycleDefault\">\n    <cycle id=\"cycle_138607\">\n      <style color=\"#3E58AC\" id=\"style_138608\"/>\n      <style color=\"#2EB848\" id=\"style_138609\"/>\n      <style color=\"#D3CE97\" id=\"style_138610\"/>\n      <style color=\"#7C287D\" id=\"style_138611\"/>\n      <style color=\"#FBF873\" id=\"style_138612\"/>\n      <style color=\"#EF3338\" id=\"style_138613\"/>\n      <style color=\"#48C2C5\" id=\"style_138614\"/>\n      <style color=\"#CCCCCC\" id=\"style_138615\"/>\n      <style color=\"#7AAAD5\" id=\"style_138616\"/>\n      <style color=\"#0A562C\" id=\"style_138617\"/>\n      <style color=\"#F8981D\" id=\"style_138618\"/>\n      <style color=\"#DDBAF1\" id=\"style_138619\"/>\n      <style color=\"#1A5F76\" id=\"style_138620\"/>\n      <style color=\"#CCFFCC\" id=\"style_138621\"/>\n      <style color=\"#BB3F7F\" id=\"style_138622\"/>\n      <style color=\"#999999\" id=\"style_138623\"/>\n      <style color=\"#000000\" id=\"style_138624\"/>\n      <style color=\"#B6E7E8\" id=\"style_138625\"/>\n      <style color=\"#FFFFFF\" id=\"style_138626\"/>\n      <style color=\"#797AA7\" id=\"style_138627\"/>\n      <style color=\"#70DC84\" id=\"style_138628\"/>\n      <style color=\"#333333\" id=\"style_138629\"/>\n      <style color=\"#ACD0EE\" id=\"style_138630\"/>\n      <style color=\"#A21619\" id=\"style_138631\"/>\n      <style color=\"#5D61FF\" id=\"style_138632\"/>\n      <style color=\"#E4E4E4\" id=\"style_138633\"/>\n      <style color=\"#248BAC\" id=\"style_138634\"/>\n      <style color=\"#B89BC9\" id=\"style_138635\"/>\n      <style color=\"#666666\" id=\"style_138636\"/>\n      <style color=\"#0D8D46\" id=\"style_138637\"/>\n    </cycle>\n  </styleCycle></visualization>";
    private static String fixedValue = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<visualization creator=\"en\" date=\"2011-10-20\" description=\"Area of count by jobcat\" id=\"frame_graph_1\" lang=\"en-US\" style=\"frame_graph_1s\" type=\"20000001\" version=\"1.4\" xmlns=\"http://www.ibm.com/software/analytics/spss/xml/visualization\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/software/analytics/spss/xml/visualization http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-3.0.xsd\">\n  <!--  Extensions  -->\n  <extension id=\"extension_1022789\" styleCycleRepository=\"styleCycleRepository\"/>\n  <!--  Size  -->\n  <location id=\"location_1022785\" method=\"fixed\" part=\"left\" value=\"0px\"/>\n  <location id=\"location_1022786\" method=\"fixed\" part=\"right\" value=\"625px\"/>\n  <location id=\"location_1022787\" method=\"fixed\" part=\"top\" value=\"0px\"/>\n  <location id=\"location_1022788\" method=\"fixed\" part=\"bottom\" value=\"500px\"/>\n  <!--  Data  -->\n  <embeddedSource id=\"source0\">\n    <names>V4;$WEIGHT</names>\n    <types>double;double</types>\n    {0}\n  </embeddedSource>\n  <sourceVariable id=\"variable4\" categorical=\"false\" creator=\"external_datasource\" key=\"false\" label=\"Current Salary\" shortLabel=\"salary\" source=\"source0\" sourceName=\"V4\" weight=\"false\">\n    <format hiddenseparator=\"false\" minimumFractionDigits=\"0\" prefix=\"$\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable5\" categorical=\"false\" creator=\"internal_aggregate\" key=\"false\" label=\"Frequency\" shortLabel=\"Frequency\" source=\"source0\" sourceName=\"$WEIGHT\" weight=\"true\"/>\n  <!--  Structure  -->\n  <graph cellStyle=\"facetLabel_data_1s\" id=\"frame_data_1\" style=\"frame_data_1s\">\n    <!--  Size  -->\n    <location id=\"location_1022796\" method=\"fixed\" part=\"left\" value=\"1%\"/>\n    <location id=\"location_1022797\" method=\"fixed\" part=\"top\" value=\"1%\"/>\n    <location id=\"location_1022798\" method=\"fixed\" part=\"bottom\" value=\"99%\"/>\n    <location id=\"location_1022799\" method=\"fixed\" part=\"right\" value=\"99%\"/>\n    <coordinates id=\"coordinates_33\">\n      <dimension id=\"dimension_34\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisx_1\" repeat=\"never\" style=\"axis_axisx_1s\">\n        </axis>\n      </dimension>\n      <dimension id=\"dimension_47\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisy_1\" repeat=\"never\" style=\"axis_axisy_1s\">\n        </axis>\n      </dimension>\n    </coordinates>\n    <facetLayout id=\"facetLayout_60\" topDown=\"true\"/>\n    <interval id=\"element_histogram_1\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_histogram_1\" showCollidingLabels=\"true\" style=\"intervalStyle\">\n      <binStatistic binCount=\"{1}\"/>\n      <summaryStatistic method=\"count\"/>\n      <x variable=\"variable4\"/>\n    </interval>\n    <lineGuide style=\"originLineStyle\" y=\"0\"/>\n  </graph>\n  <labelFrame id=\"labelFrame_1023135\" style=\"style_1023140\">\n    <!--  Size  -->\n    <location id=\"location_1023177\" method=\"fixed\" part=\"left\" value=\"30%\"/>\n    <location id=\"location_1023178\" method=\"fixed\" part=\"top\" value=\"10%\"/>\n    <location id=\"location_1023179\" method=\"fixed\" part=\"right\" value=\"90%\"/>\n    <location id=\"location_1023181\" method=\"fixed\" part=\"height\" value=\"60%\"/>\n    <label id=\"label_1023141\" style=\"style_1023143\">\n      <text id=\"text_1023198\">{2}</text>\n    </label>\n  </labelFrame>\n  <!--  Styles  -->\n  <style font-family=\"SansSerif\" font-size=\"8pt;6pt;\" id=\"container\" pattern=\"0\" stroke-linecap=\"butt\" text-fit=\"true\">\n    <style color=\"white\" color2=\"transparent\" id=\"frame_graph_1s\"/>\n    <style color=\"transparent\" color2=\"transparent\" id=\"frame_data_1s\"/>\n    <style color=\"#F0F0F0\" color2=\"black\" id=\"facetLabel_data_1s\"/>\n    <style color=\"black\" id=\"axis_axisx_1s\" stroke-width=\"0.5pt\"/>\n    <style color=\"black\" id=\"axis_axisy_1s\" stroke-width=\"0.5pt\"/>\n    <style id=\"intervalStyle\" visible=\"{3}\" color=\"#D3CE97\" color2=\"black\" depth=\"75%\" font-family=\"Arial\" pattern=\"0\" stroke-width=\"1px\" width=\"100%\"/>\n    <style id=\"areaStyle\" color=\"red\" color2=\"transparent\" depth=\"80%\" font-family=\"Arial\" opacity=\"1.0\" stroke-width=\"2px\"/>\n    <style color=\"transparent\" color2=\"transparent\" id=\"style_1023140\"/>\n    <style font-size=\"9pt\" id=\"style_1023143\"  textAlignment=\"left\" labelLocationVertical=\"positive\" />\n    <style id=\"originLineStyle\"/>\n  </style>\n</visualization>";
    private static String linesHist = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<visualization creator=\"en\" date=\"2011-10-20\" description=\"Area of count by jobcat\" id=\"frame_graph_1\" lang=\"en-US\" style=\"frame_graph_1s\" type=\"20000001\" version=\"1.4\" xmlns=\"http://www.ibm.com/software/analytics/spss/xml/visualization\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/software/analytics/spss/xml/visualization http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-3.0.xsd\">\n  <!--  Extensions  -->\n  <extension id=\"extension_1022789\" styleCycleRepository=\"styleCycleRepository\"/>\n  <!--  Size  -->\n  <location id=\"location_1022785\" method=\"fixed\" part=\"left\" value=\"0px\"/>\n  <location id=\"location_1022786\" method=\"fixed\" part=\"right\" value=\"625px\"/>\n  <location id=\"location_1022787\" method=\"fixed\" part=\"top\" value=\"0px\"/>\n  <location id=\"location_1022788\" method=\"fixed\" part=\"bottom\" value=\"500px\"/>\n  <!--  Data  -->\n  <embeddedSource id=\"source0\">\n    <names>V4;$WEIGHT</names>\n    <types>double;double</types>\n    {0}\n  </embeddedSource>\n\n  <embeddedSource id=\"source1\">\n    <names>V6;V7;V8</names>\n    <types>double;double;string</types>\n    {1}\n  </embeddedSource>\n  \n  <sourceVariable id=\"variable4\" categorical=\"false\" creator=\"external_datasource\" key=\"false\" label=\"Current Salary\" shortLabel=\"salary\" source=\"source0\" sourceName=\"V4\" weight=\"false\">\n    <format hiddenseparator=\"false\" minimumFractionDigits=\"0\" prefix=\"$\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable5\" categorical=\"false\" creator=\"internal_aggregate\" key=\"false\" label=\"Frequency\" shortLabel=\"Frequency\" source=\"source0\" sourceName=\"$WEIGHT\" weight=\"true\"/>\n\n  <sourceVariable categorical=\"false\" creator=\"external_datasource\" id=\"variable6\" key=\"false\" source=\"source1\" sourceName=\"V6\" weight=\"false\">\n  </sourceVariable>\n  <sourceVariable categorical=\"false\" id=\"variable7\" key=\"false\" source=\"source1\" sourceName=\"V7\" weight=\"false\">\n    <extension id=\"extension_1022845\" statistic=\"numberOfCases\"/>\n  </sourceVariable>\n  <sourceVariable categorical=\"true\" creator=\"external_datasource\" id=\"variable8\" key=\"false\" source=\"source1\" sourceName=\"V8\" weight=\"false\">\n    <format>\n      <relabel from=\"1\" id=\"relabel_20\" to=\"Female\"/>\n      <relabel from=\"2\" id=\"relabel_21\" to=\"Male\"/>\n    </format>\n  </sourceVariable>\n  \n  <!--  Structure  -->\n  <graph cellStyle=\"facetLabel_data_1s\" id=\"frame_data_1\" style=\"frame_data_1s\">\n    <!--  Size  -->\n    <location id=\"location_1022796\" method=\"fixed\" part=\"left\" value=\"1%\"/>\n    <location id=\"location_1022797\" method=\"fixed\" part=\"top\" value=\"1%\"/>\n    <location id=\"location_1022798\" method=\"fixed\" part=\"bottom\" value=\"99%\"/>\n    <location id=\"location_1022799\" method=\"fixed\" part=\"right\" value=\"99%\"/>\n    <coordinates id=\"coordinates_33\">\n      <dimension id=\"dimension_34\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisx_1\" repeat=\"never\" style=\"axis_axisx_1s\">\n        </axis>\n      </dimension>\n      <dimension id=\"dimension_47\" lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" id=\"axis_axisy_1\" repeat=\"never\" style=\"axis_axisy_1s\">\n        </axis>\n      </dimension>\n    </coordinates>\n    <facetLayout id=\"facetLayout_60\" topDown=\"true\"/>\n    <interval id=\"element_histogram_1\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_histogram_1\" showCollidingLabels=\"true\" style=\"intervalStyle\">\n      <binStatistic binCount=\"27\"/>\n      <summaryStatistic method=\"count\"/>\n      <x variable=\"variable4\"/>\n    </interval>\n    <line breakRepresentation=\"wings\" dot=\"false\" id=\"element_simpleline_1\" labelCollisionHandling=\"none\" name=\"element_simpleline_1\" showCollidingLabels=\"true\" style=\"distLineStyle0\">\n      <styleBy id=\"styleBy8\" styleCycle=\"styleCycleDefault\" variable=\"variable8\"/>\n      <x variable=\"variable6\"/>\n      <y variable=\"variable7\"/>\n    </line>\n    <lineGuide style=\"originLineStyle\" y=\"0\"/>\n  </graph>\n  <!--  Styles  -->\n  <style font-family=\"SansSerif\" font-size=\"8pt;6pt;\" id=\"container\" pattern=\"0\" stroke-linecap=\"butt\" text-fit=\"true\">\n    <style color=\"white\" color2=\"transparent\" id=\"frame_graph_1s\"/>\n    <style color=\"transparent\" color2=\"transparent\" id=\"frame_data_1s\"/>\n    <style color=\"#F0F0F0\" color2=\"black\" id=\"facetLabel_data_1s\"/>\n    <style color=\"black\" id=\"axis_axisx_1s\" stroke-width=\"0.5pt\"/>\n    <style color=\"black\" id=\"axis_axisy_1s\" stroke-width=\"0.5pt\"/>\n    <style id=\"intervalStyle\" visible=\"{2}\" color=\"#D3CE97\" color2=\"black\" depth=\"75%\" font-family=\"Arial\" pattern=\"0\" stroke-width=\"1px\" width=\"100%\"/>\n    <style id=\"distLineStyle0\" color=\"blue\" color2=\"transparent\" depth=\"80%\" font-family=\"Arial\" opacity=\"1.0\" stroke-width=\"2px\"/>\n    <style id=\"originLineStyle\"/>\n  </style>\n  <styleCycle id=\"styleCycleDefault\">\n    <cycle>\n      <style color=\"#3E58AC\"/>\n      <style color=\"#2EB848\"/>\n      <style color=\"#D3CE97\"/>\n      <style color=\"#7C287D\"/>\n      <style color=\"#FBF873\"/>\n      <style color=\"#EF3338\"/>\n      <style color=\"#48C2C5\"/>\n      <style color=\"#CCCCCC\"/>\n      <style color=\"#7AAAD5\"/>\n      <style color=\"#0A562C\"/>\n      <style color=\"#F8981D\"/>\n      <style color=\"#DDBAF1\"/>\n      <style color=\"#1A5F76\"/>\n      <style color=\"#CCFFCC\"/>\n      <style color=\"#BB3F7F\"/>\n      <style color=\"#999999\"/>\n      <style color=\"#000000\"/>\n      <style color=\"#B6E7E8\"/>\n      <style color=\"#FFFFFF\"/>\n      <style color=\"#797AA7\"/>\n      <style color=\"#70DC84\"/>\n      <style color=\"#333333\"/>\n      <style color=\"#ACD0EE\"/>\n      <style color=\"#A21619\"/>\n      <style color=\"#5D61FF\"/>\n      <style color=\"#E4E4E4\"/>\n      <style color=\"#248BAC\"/>\n      <style color=\"#B89BC9\"/>\n      <style color=\"#666666\"/>\n      <style color=\"#0D8D46\"/>\n    </cycle>\n    <extension immutables=\"1\"/>\n  </styleCycle>\n</visualization>";
    private static String rangeHist = "<?xml version=\"1.0\"?>\n\n<visualization creator=\"en\" date=\"2011-10-20\" description=\"Area of count by jobcat\" id=\"frame_graph_1\" lang=\"en-US\" style=\"frame_graph_1s\" type=\"20000001\" version=\"1.4\" xmlns=\"http://www.ibm.com/software/analytics/spss/xml/visualization\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/software/analytics/spss/xml/visualization http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-3.0.xsd\">\n  <!-- Size -->\n  <location method=\"fixed\" part=\"left\" value=\"0px\"/>\n  <location method=\"fixed\" part=\"right\" value=\"625px\"/>\n  <location method=\"fixed\" part=\"top\" value=\"0px\"/>\n  <location method=\"fixed\" part=\"bottom\" value=\"500px\"/>\n  <!-- Data -->\n  <embeddedSource id=\"source0\">\n    <names>V4;$WEIGHT</names>\n    <types>double;double</types>\n    {0}\n  </embeddedSource>\n  <embeddedSource id=\"source1\">\n    <names>V6;V7;V8</names>\n    <types>double;double;string</types>\n    {1}\n  </embeddedSource>\n  <sourceVariable id=\"variable4\" categorical=\"false\" creator=\"external_datasource\" key=\"false\" label=\"Current Salary\" shortLabel=\"salary\" source=\"source0\" sourceName=\"V4\" weight=\"false\">\n    <format hiddenseparator=\"false\" minimumFractionDigits=\"0\" prefix=\"$\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable5\" categorical=\"false\" creator=\"internal_aggregate\" key=\"false\" label=\"Frequency\" shortLabel=\"Frequency\" source=\"source0\" sourceName=\"$WEIGHT\" weight=\"true\"/>\n  <sourceVariable id=\"variable6\" categorical=\"false\" creator=\"external_datasource\" key=\"false\" source=\"source1\" sourceName=\"V6\" weight=\"false\"/>\n  <sourceVariable id=\"variable7\" categorical=\"false\" key=\"false\" source=\"source1\" sourceName=\"V7\" weight=\"false\">\n    <extension statistic=\"numberOfCases\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable8\" categorical=\"true\" creator=\"external_datasource\" key=\"false\" source=\"source1\" sourceName=\"V8\" weight=\"false\">\n    <format>\n      <relabel from=\"1\" to=\"Female\"/>\n      <relabel from=\"2\" to=\"Male\"/>\n    </format>\n  </sourceVariable>\n  <!-- Structure -->\n  <graph cellStyle=\"graphStyle2\" style=\"graphStyle\">\n    <!-- Size -->\n    <location method=\"fixed\" part=\"left\" value=\"1%\"/>\n    <location method=\"fixed\" part=\"top\" value=\"1%\"/>\n    <location method=\"fixed\" part=\"bottom\" value=\"99%\"/>\n    <location method=\"fixed\" part=\"right\" value=\"99%\"/>\n    <coordinates>\n      <dimension lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle\"/>\n      </dimension>\n      <dimension lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle2\"/>\n      </dimension>\n    </coordinates>\n    <facetLayout topDown=\"true\"/>\n    <interval id=\"element_histogram_1\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_histogram_1\" showCollidingLabels=\"true\" style=\"intervalStyle\">\n      <binStatistic binCount=\"27\"/>\n      <summaryStatistic method=\"count\"/>\n      <x variable=\"variable4\"/>\n    </interval>\n    <area id=\"element_simpleline_1\" breakRepresentation=\"wings\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_simpleline_1\" showCollidingLabels=\"true\" style=\"areaStyle\">\n      <styleBy styleCycle=\"styleCycleDefault\" variable=\"variable8\"/>\n      <x variable=\"variable6\"/>\n      <y variable=\"variable7\"/>\n    </area>\n    <lineGuide style=\"originLineStyle\" y=\"0\"/>\n  </graph>\n  <!-- Styles -->\n  <style id=\"intervalStyle\" color=\"#D3CE97\" color2=\"black\" visible=\"{2}\" depth=\"75%\" font-family=\"Arial\" pattern=\"0\" stroke-width=\"1px\" width=\"100%\"/>\n  <style id=\"areaStyle\" color=\"blue\" color2=\"transparent\" depth=\"80%\" font-family=\"Arial\" opacity=\"1.0\" stroke-width=\"2px\"/>\n  <style id=\"graphStyle\" color=\"transparent\" color2=\"transparent\" font-family=\"Arial\"/>\n  <style color=\"white\" color2=\"transparent\" id=\"frame_graph_1s\"/>\n  <style id=\"graphStyle2\" color=\"#F0F0F0\" color2=\"black\"/>\n  <style id=\"axisStyle\" color=\"black\" stroke-width=\"0.5pt\"/>\n  <style id=\"axisStyle2\" color=\"black\" stroke-width=\"0.5pt\"/>\n  <style id=\"originLineStyle\"/>\n  <!-- Style Cycles -->\n  <styleCycle id=\"styleCycleDefault\">\n    <cycle>\n      <style color=\"#3E58AC\" color2=\"#3E58AC\" opacity=\".5\"/>\n    </cycle>\n    <extension immutables=\"1\"/>\n  </styleCycle>\n</visualization>";
    static String categoricalChart = "<?xml version=\"1.0\"?>\n\n<visualization creator=\"en\" date=\"2012-03-09\" description=\"Bar of count by jobcat\" lang=\"en-US\" style=\"visualizationStyle\" type=\"21000000\" version=\"1.4\" xmlns=\"http://www.ibm.com/software/analytics/spss/xml/visualization\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/software/analytics/spss/xml/visualization http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-3.0.xsd\">\n  <!-- Size -->\n  <location method=\"fixed\" part=\"left\" value=\"0px\"/>\n  <location method=\"fixed\" part=\"right\" value=\"625px\"/>\n  <location method=\"fixed\" part=\"top\" value=\"0px\"/>\n  <location method=\"fixed\" part=\"bottom\" value=\"500px\"/>\n  <!-- Data -->\n  <embeddedSource id=\"source0\">\n    <names>V4;$COUNT</names>\n    <types>string;double</types>\n    <labels>;</labels>\n    <labelColumns>;</labelColumns>\n    {0}\n  </embeddedSource>\n  <embeddedSource id=\"source1\">\n    <names>V8;V9</names>\n    <types>string;double</types>\n    <labels>;</labels>\n    <labelColumns>;</labelColumns>\n    {1}\n  </embeddedSource>\n  <sourceVariable id=\"variable4\" categorical=\"true\" creator=\"external_datasource\" key=\"false\" label=\"Employment Category\" shortLabel=\"Employment Category\" source=\"source0\" sourceName=\"V4\" weight=\"false\">\n    <format>\n      <relabel from=\"1\" to=\"Clerical\"/>\n      <relabel from=\"2\" to=\"Custodial\"/>\n      <relabel from=\"3\" to=\"Manager\"/>\n    </format>\n  </sourceVariable>\n  <sourceVariable id=\"variable5\" categorical=\"false\" key=\"false\" label=\"Count\" shortLabel=\"Count\" source=\"source0\" sourceName=\"$COUNT\" weight=\"false\">\n    <extension statistic=\"numberOfCases\"/>\n  </sourceVariable>\n  <sourceVariable id=\"variable8\" categorical=\"true\" creator=\"external_datasource\" key=\"false\" label=\"Employment Category\" shortLabel=\"Employment Category\" source=\"source1\" sourceName=\"V8\" weight=\"false\">\n    <format>\n      <relabel from=\"1\" to=\"Clerical\"/>\n      <relabel from=\"2\" to=\"Custodial\"/>\n      <relabel from=\"3\" to=\"Manager\"/>\n    </format>\n  </sourceVariable>\n  <sourceVariable id=\"variable9\" categorical=\"false\" key=\"false\" label=\"Count\" shortLabel=\"Count\" source=\"source1\" sourceName=\"V9\" weight=\"false\">\n    <extension statistic=\"numberOfCases\"/>\n  </sourceVariable>\n  <intervalDomain id=\"domain7\" date=\"false\">\n    <range exact=\"false\" max=\"0\" min=\"0\"/>\n  </intervalDomain>\n  <!-- Structure -->\n  <graph cellStyle=\"graphStyle2\" style=\"graphStyle\">\n    <!-- Size -->\n    <location method=\"fixed\" part=\"left\" value=\"1%\"/>\n    <location method=\"fixed\" part=\"top\" value=\"1%\"/>\n    <location method=\"fixed\" part=\"bottom\" value=\"99%\"/>\n    <location method=\"fixed\" part=\"right\" value=\"99%\"/>\n    <coordinates>\n      <dimension lowerMargin=\"5%\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle\"/>\n      </dimension>\n      <dimension domain=\"domain7\" unionDomain=\"true\" upperMargin=\"5%\">\n        <axis combineAxisLabels=\"true\" repeat=\"never\" style=\"axisStyle2\"/>\n      </dimension>\n    </coordinates>\n    <facetLayout topDown=\"true\"/>\n    <interval id=\"element_bar_1\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_bar_1\" showCollidingLabels=\"true\" style=\"intervalStyle\">\n      <x variable=\"variable4\"/>\n      <y variable=\"variable5\"/>\n    </interval>\n    <interval id=\"element_bar_2\" dot=\"false\" labelCollisionHandling=\"none\" name=\"element_bar_2\" showCollidingLabels=\"true\" style=\"intervalStyle2\">\n      <x variable=\"variable8\"/>\n      <y variable=\"variable9\"/>\n    </interval>\n  </graph>\n  <!-- Styles -->\n  <style id=\"intervalStyle\" color=\"#D3CE97\" color2=\"black\" visible=\"{2}\" depth=\"75%\" font-family=\"Arial\" pattern=\"0\" size=\"75%\" stroke-width=\"1px\"/>\n  <style id=\"intervalStyle2\" color=\"blue\" color2=\"black\" depth=\"75%\" font-family=\"Arial\" opacity=\".5\" pattern=\"0\" size=\"75%\" stroke-width=\"1px\"/>\n  <style id=\"graphStyle\" color=\"transparent\" color2=\"transparent\" font-family=\"Arial\"/>\n  <style id=\"visualizationStyle\" color=\"white\" color2=\"transparent\" />\n  <style id=\"graphStyle2\" color=\"#F0F0F0\" color2=\"black\"/>\n  <style id=\"axisStyle\" color=\"black\" stroke-width=\"0.5pt\"/>\n  <style id=\"axisStyle2\" color=\"black\" stroke-width=\"0.5pt\"/>\n</visualization>";

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    private DistributionImageUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage getScaleImage(Vector<BaseMCSimulationTab.HistoBin> vector, DistributionType distributionType, Double[] doubleArray, int n, int n2) {
        if (vector == null && doubleArray == null) {
            return null;
        }
        String string = "#D3CE97";
        String[] stringArray = new String[]{"blue", "red", "yellow", "gray", "black"};
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            void var14_23;
            int n3 = DistributionImageUtil.getValidPerametersCount(doubleArray);
            String string2 = "true";
            int n4 = 2;
            StringBuffer stringBuffer = new StringBuffer();
            if (vector == null) {
                if (distributionType == DistributionType.NORMAL) {
                    stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                    if (n3 > 0) {
                        stringBuffer.append("<row>").append(2.0 * doubleArray[0]).append(";").append(1).append("</row>");
                    }
                } else if (distributionType == DistributionType.WEIBULL) {
                    stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                    if (n3 > 0) {
                        stringBuffer.append("<row>").append(2.0 * doubleArray[0]).append(";").append(1).append("</row>");
                    }
                } else if (distributionType == DistributionType.UNIFORM) {
                    if (n3 > 1) {
                        stringBuffer.append("<row>").append(doubleArray[0]).append(";").append(1).append("</row>");
                        stringBuffer.append("<row>").append((doubleArray[0] + doubleArray[1]) / 2.0).append(";").append(1).append("</row>");
                        stringBuffer.append("<row>").append(doubleArray[1]).append(";").append(1).append("</row>");
                    }
                } else if (distributionType == DistributionType.GAMMA) {
                    stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                    stringBuffer.append("<row>").append(20).append(";").append(1).append("</row>");
                } else if (distributionType == DistributionType.BETA) {
                    stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                    stringBuffer.append("<row>").append(1).append(";").append(1).append("</row>");
                } else if (distributionType == DistributionType.EXPONENTIAL) {
                    stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                    stringBuffer.append("<row>").append(5).append(";").append(1).append("</row>");
                } else {
                    stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                    stringBuffer.append("<row>").append(10).append(";").append(1).append("</row>");
                }
                string2 = "false";
            } else {
                for (BaseMCSimulationTab.HistoBin object2 : vector) {
                    stringBuffer.append("<row>").append(object2.getBoundry()).append(";").append(object2.getCount()).append("</row>");
                }
                n4 = vector.size();
            }
            int n5 = 0;
            String string3 = "";
            String string4 = "";
            if (doubleArray != null) {
                int n6;
                if (distributionType == DistributionType.EXPONENTIAL) {
                    for (n6 = 0; n6 < doubleArray.length; ++n6) {
                        void var14_19;
                        if (doubleArray[n6] == null) continue;
                        string4 = string4 + "<line style=\"distLineStyle" + n5 + "\">\n <distributionStatistic distribution=\"";
                        string4 = string4 + distributionType.toString() + "\"";
                        string4 = string4 + " parameter=\"" + doubleArray[n6] + "\" ";
                        string4 = string4 + " />\n<x variable=\"variable4\"/></line>\n";
                        String string5 = (String)var14_19 + "    <style id=\"distLineStyle" + n5 + "\" color=\"" + stringArray[n5++ % stringArray.length] + "\" color2=\"transparent\" depth=\"80%\" font-family=\"Arial\" opacity=\"1.0\" stroke-width=\"2px\"/>\n";
                    }
                } else {
                    n5 = 0;
                    for (n6 = 0; n6 < n3; ++n6) {
                        void var14_21;
                        if (n5 % 2 != 0 || n5 + 1 >= n3 || doubleArray[n5] == null || doubleArray[n5 + 1] == null) continue;
                        string4 = string4 + "<line style=\"distLineStyle" + n5 + "\">\n <distributionStatistic distribution=\"";
                        string4 = string4 + distributionType.toString() + "\"";
                        string4 = string4 + " parameter=\"" + doubleArray[n5] + "\" ";
                        String string6 = (String)var14_21 + "    <style id=\"distLineStyle" + n5 + "\" color=\"" + stringArray[n5 / 2] + "\" color2=\"transparent\" depth=\"80%\" font-family=\"Arial\" opacity=\"1.0\" stroke-width=\"2px\"/>\n";
                        string4 = string4 + " secondaryParameter=\"" + doubleArray[n5 + 1] + "\" ";
                        string4 = string4 + " />\n<x variable=\"variable4\"/></line>\n";
                        n5 += 2;
                    }
                }
            }
            String string7 = MessageFormat.format(histWithDist, stringBuffer.toString(), n4, string4, string2, string, var14_23);
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string7));
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization.setOutputSize(n, n2);
            bufferedImage = visualization.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage getDiscreteImage(TreeMap<OBS, Double> treeMap, SimulationHelper.DistributionType distributionType, Double[] doubleArray, int n, int n2, int n3) {
        if (treeMap == null && doubleArray == null) {
            return null;
        }
        String string = "#D3CE97";
        Visualization visualization = new Visualization[]{"blue", "red", "yellow", "gray", "black"};
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            int n4;
            int n5;
            int n6 = treeMap == null ? 8 : treeMap.size();
            String string2 = "true";
            StringBuffer stringBuffer = new StringBuffer();
            if (treeMap == null) {
                for (n5 = 0; n5 < doubleArray.length; n5 += n) {
                    if (distributionType == SimulationHelper.DistributionType.BINOMIAL) {
                        if (doubleArray[n5] == null || doubleArray[n5 + 1] == null || doubleArray[n5] == null || !(doubleArray[n5] > (double)n6)) continue;
                        n6 = doubleArray[n5].intValue();
                        continue;
                    }
                    if (distributionType == SimulationHelper.DistributionType.NEGBIN || distributionType == SimulationHelper.DistributionType.NEGBIN_TRIAL) {
                        if (doubleArray[n5] == null || doubleArray[n5 + 1] == null || doubleArray[n5] == null || !(2.0 * doubleArray[n5] > (double)n6)) continue;
                        n6 = 2 * doubleArray[n5].intValue();
                        continue;
                    }
                    if (distributionType == SimulationHelper.DistributionType.POISSON) {
                        if (doubleArray[n5] == null || !(2.0 * doubleArray[n5] > (double)n6)) continue;
                        n6 = 2 * doubleArray[n5].intValue();
                        continue;
                    }
                    if (distributionType != SimulationHelper.DistributionType.BERNOULLI) continue;
                    n6 = 2;
                }
                if (distributionType == SimulationHelper.DistributionType.POISSON && n6 > 40) {
                    n6 = 40;
                }
                for (n4 = 1; n4 <= n6; ++n4) {
                    stringBuffer.append("<row>").append(n4).append(";").append(1).append(";").append(1).append("</row>");
                }
                string2 = "false";
            } else {
                Collection<Double> collection = treeMap.values();
                n4 = 1;
                for (Double object2 : collection) {
                    stringBuffer.append("<row>").append(n4).append(";").append(object2).append(";").append(1).append("</row>");
                    ++n4;
                }
            }
            n5 = 0;
            String string3 = "";
            StringBuffer stringBuffer2 = new StringBuffer();
            if (doubleArray != null) {
                ArrayList<double[]> arrayList = new ArrayList<double[]>();
                for (int i = 0; i < doubleArray.length; i += n) {
                    if (distributionType == SimulationHelper.DistributionType.BINOMIAL) {
                        if (doubleArray[i] == null || doubleArray[i + 1] == null) continue;
                        arrayList.add(DistributionImageUtil.getBinomialDist(doubleArray[i].intValue(), doubleArray[i + 1], n6));
                        continue;
                    }
                    if (distributionType == SimulationHelper.DistributionType.NEGBIN || distributionType == SimulationHelper.DistributionType.NEGBIN_TRIAL) {
                        if (doubleArray[i] == null || doubleArray[i + 1] == null) continue;
                        arrayList.add(DistributionImageUtil.getNegBinomialDist(doubleArray[i].intValue(), doubleArray[i + 1], n6));
                        continue;
                    }
                    if (distributionType == SimulationHelper.DistributionType.POISSON) {
                        if (doubleArray[i] == null) continue;
                        arrayList.add(DistributionImageUtil.getPoissonDist(doubleArray[i].intValue(), n6));
                        continue;
                    }
                    if (distributionType != SimulationHelper.DistributionType.BERNOULLI || doubleArray[i] == null) continue;
                    arrayList.add(DistributionImageUtil.getNernoulliDist(doubleArray[i], n6));
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    double[] dArray = (double[])arrayList.get(i);
                    for (int j = 0; j < dArray.length; ++j) {
                        stringBuffer2.append("<row>").append(j + 1).append(";").append(dArray[j]).append(";").append(i + 1).append("</row>");
                    }
                }
                for (String string4 : visualization) {
                    string3 = string3 + "<style color=\"" + string4 + "\"/>\n";
                }
                n5 = doubleArray.length > n ? 1 : 0;
            }
            String string5 = MessageFormat.format(barWithDist, stringBuffer.toString(), stringBuffer2.toString(), string2, n5 != 0 ? "100%" : "90%", string, string3);
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string5));
            Visualization visualization2 = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization2.setOutputSize(n2, n3);
            bufferedImage = visualization2.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage getTriangleImage(Vector<BaseMCSimulationTab.HistoBin> vector, Double[] doubleArray, int n, int n2) {
        if (vector == null && doubleArray == null) {
            return null;
        }
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            int n3 = DistributionImageUtil.getValidPerametersCount(doubleArray);
            String string = "true";
            double d = -1.0;
            int n4 = 2;
            StringBuffer stringBuffer = new StringBuffer();
            if (vector == null) {
                stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                if (n3 > 0) {
                    stringBuffer.append("<row>").append(doubleArray[0]).append(";").append(1).append("</row>");
                }
                string = "false";
            } else {
                for (BaseMCSimulationTab.HistoBin histoBin : vector) {
                    stringBuffer.append("<row>").append(histoBin.getBoundry()).append(";").append(histoBin.getCount()).append("</row>");
                    if (!(histoBin.getCount() > d)) continue;
                    d = histoBin.getCount();
                }
                n4 = vector.size();
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            if (doubleArray != null) {
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    if (n5 % 3 != 0 || n5 + 2 >= n3 || doubleArray[n5] == null || doubleArray[n5 + 1] == null || doubleArray[n5 + 2] == null) continue;
                    stringBuffer2.append("<row>").append(doubleArray[n5]).append(";").append(0).append(";").append(i).append("</row>");
                    if (vector != null) {
                        double d2 = DistributionImageUtil.getTriangleModeValue(vector, doubleArray[n5], doubleArray[n5 + 2], doubleArray[n5 + 1], d);
                        stringBuffer2.append("<row>").append(doubleArray[n5 + 2]).append(";").append(d2).append(";").append(i).append("</row>");
                    } else {
                        stringBuffer2.append("<row>").append(doubleArray[n5 + 2]).append(";").append(1).append(";").append(i).append("</row>");
                    }
                    stringBuffer2.append("<row>").append(doubleArray[n5 + 1]).append(";").append(0).append(";").append(i).append("</row>");
                    n5 += 3;
                }
            }
            String string2 = MessageFormat.format(histTriangle, stringBuffer.toString(), stringBuffer2.toString(), n4, string);
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string2));
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization.setOutputSize(n, n2);
            bufferedImage = visualization.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage getFixedValueImage(Vector<BaseMCSimulationTab.HistoBin> vector, Double[] doubleArray, int n, int n2) {
        if (vector == null && doubleArray == null) {
            return null;
        }
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            int n3 = DistributionImageUtil.getValidPerametersCount(doubleArray);
            String string = "true";
            int n4 = 2;
            StringBuffer stringBuffer = new StringBuffer();
            if (vector == null) {
                stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                if (n3 > 0) {
                    stringBuffer.append("<row>").append(doubleArray[0]).append(";").append(1).append("</row>");
                }
                string = "false";
            } else {
                for (BaseMCSimulationTab.HistoBin histoBin : vector) {
                    stringBuffer.append("<row>").append(histoBin.getBoundry()).append(";").append(histoBin.getCount()).append("</row>");
                }
                n4 = vector.size();
            }
            Object object = "";
            if (doubleArray != null) {
                for (int i = 0; i < n3; ++i) {
                    object = (String)object + String.valueOf(doubleArray[i]) + "\n";
                }
            }
            String string2 = MessageFormat.format(fixedValue, stringBuffer.toString(), n4, object, string);
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string2));
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization.setOutputSize(n, n2);
            bufferedImage = visualization.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage getLogNormalImage(Vector<BaseMCSimulationTab.HistoBin> vector, Double[] doubleArray, int n, int n2) {
        if (vector == null && doubleArray == null) {
            return null;
        }
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            int n3 = DistributionImageUtil.getValidPerametersCount(doubleArray);
            String string = "true";
            StringBuffer stringBuffer = new StringBuffer();
            if (vector == null) {
                if (doubleArray[0] != null && doubleArray[1] != null) {
                    double d = Math.log(doubleArray[0]);
                    stringBuffer.append("<row>").append(Math.exp(d - 1.2 * doubleArray[1])).append(";").append(1).append("</row>");
                    stringBuffer.append("<row>").append(Math.exp(d + 1.2 * doubleArray[1])).append(";").append(1).append("</row>");
                } else {
                    stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                    stringBuffer.append("<row>").append(5).append(";").append(1).append("</row>");
                }
                string = "false";
            } else {
                for (BaseMCSimulationTab.HistoBin histoBin : vector) {
                    stringBuffer.append("<row>").append(histoBin.getBoundry()).append(";").append(histoBin.getCount()).append("</row>");
                }
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            if (doubleArray != null && doubleArray.length > 1 && doubleArray[0] != null && doubleArray[1] != null) {
                int n4 = n3 / 2;
                if (n3 > 1) {
                    double d = 0.0;
                    double d2 = 5.0;
                    double d3 = Math.log(doubleArray[0]);
                    if (vector != null && vector.size() > 1) {
                        d = vector.get(0).getBoundry();
                        d2 = vector.get(vector.size() - 1).getBoundry();
                    } else {
                        d = Math.exp(d3 - 1.2 * doubleArray[1]);
                        d2 = Math.exp(d3 + 1.2 * doubleArray[1]);
                    }
                    double[] dArray = DistributionImageUtil.getXAxisData(d, d2, 100);
                    for (int i = 0; i < n4; ++i) {
                        int n5;
                        double d4;
                        double[] dArray2 = DistributionImageUtil.getLogNormalValues(dArray, Math.log(doubleArray[2 * i]), doubleArray[2 * i + 1]);
                        if (vector != null) {
                            d4 = DistributionImageUtil.getFittedLogNormalRatio(vector, dArray2, Math.log(doubleArray[2 * i]), doubleArray[2 * i + 1]);
                            for (n5 = 0; n5 < dArray2.length; ++n5) {
                                dArray2[n5] = d4 * dArray2[n5];
                            }
                        } else {
                            d4 = -1.0;
                            for (n5 = 0; n5 < dArray2.length; ++n5) {
                                if (!(dArray2[n5] > d4)) continue;
                                d4 = dArray2[n5];
                            }
                            for (n5 = 0; n5 < dArray2.length; ++n5) {
                                dArray2[n5] = dArray2[n5] * 0.9 / d4;
                            }
                        }
                        for (int j = 0; j < dArray.length; ++j) {
                            stringBuffer2.append("<row>").append(dArray[j]).append(";").append(dArray2[j]).append(";").append(i).append("</row>");
                        }
                    }
                }
            }
            String string2 = MessageFormat.format(linesHist, stringBuffer.toString(), stringBuffer2.toString(), string);
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string2));
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization.setOutputSize(n, n2);
            bufferedImage = visualization.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage getRangeImage(Vector<BaseMCSimulationTab.HistoBin> vector, Double[] doubleArray, int n, int n2) {
        if (vector == null && doubleArray == null) {
            return null;
        }
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            int n3 = DistributionImageUtil.getValidPerametersCount(doubleArray);
            String string = "true";
            StringBuffer stringBuffer = new StringBuffer();
            if (vector == null) {
                string = "false";
            } else {
                for (BaseMCSimulationTab.HistoBin histoBin : vector) {
                    stringBuffer.append("<row>").append(histoBin.getBoundry()).append(";").append(histoBin.getCount()).append("</row>");
                }
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            if (doubleArray != null) {
                int n4 = n3 / 3;
                double d = DistributionImageUtil.getRangeScale(vector, doubleArray, n4);
                for (int i = 0; i < n4; ++i) {
                    stringBuffer2.append("<row>").append(doubleArray[i * 3 + 0]).append(";").append(d * doubleArray[i * 3 + 2]).append(";").append(i + 1).append("</row>");
                    stringBuffer2.append("<row>").append(doubleArray[i * 3 + 1]).append(";").append(d * doubleArray[i * 3 + 2]).append(";").append(i + 1).append("</row>");
                }
            }
            String string2 = MessageFormat.format(rangeHist, stringBuffer.toString(), stringBuffer2.toString(), string);
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string2));
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization.setOutputSize(n, n2);
            bufferedImage = visualization.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage getCategoricalImage(TreeMap<OBS, Double> treeMap, Object[][] objectArray, int n, int n2) {
        if (treeMap == null && objectArray == null) {
            return null;
        }
        String string = "#D3CE97";
        String[] stringArray = new String[]{"blue", "red", "yellow", "gray", "black"};
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            int n3;
            VisualizationSpecification visualizationSpecification;
            double d = 1.0;
            int n4 = treeMap == null ? 8 : treeMap.size();
            String string2 = "true";
            StringBuffer stringBuffer = new StringBuffer();
            if (treeMap == null) {
                for (int i = 1; i <= n4; ++i) {
                    stringBuffer.append("<row>").append(i).append(";").append(1).append("</row>");
                }
                string2 = "false";
            } else {
                double d2 = 0.0;
                visualizationSpecification = treeMap.values();
                n3 = 1;
                for (Double d3 : visualizationSpecification) {
                    stringBuffer.append("<row>").append(n3).append(";").append(d3).append("</row>");
                    if (d3 > d2) {
                        d2 = d3;
                    }
                    ++n3;
                }
                d = d2;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            if (objectArray != null) {
                double d4 = 0.0;
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    double d5;
                    if (objectArray[n3] == null || objectArray[n3][1] == null || ((String)objectArray[n3][1]).length() <= 0 || !((d5 = Double.parseDouble(UIToolResUtil.removeLocale((String)((String)objectArray[n3][1])))) > d4)) continue;
                    d4 = d5;
                }
                if (d4 > 0.0) {
                    d /= d4;
                }
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (objectArray[n3] == null || objectArray[n3][1] == null || ((String)objectArray[n3][1]).length() <= 0) continue;
                    double d6 = Double.parseDouble(UIToolResUtil.removeLocale((String)((String)objectArray[n3][1])));
                    stringBuffer2.append("<row>").append(n3 + 1).append(";").append(d * d6).append("</row>");
                }
            }
            String string3 = MessageFormat.format(categoricalChart, stringBuffer.toString(), stringBuffer2.toString(), string2);
            visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string3));
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization.setOutputSize(n, n2);
            bufferedImage = visualization.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage getWeibullImage(Vector<BaseMCSimulationTab.HistoBin> vector, Double[] doubleArray, int n, int n2) {
        if (vector == null && doubleArray == null) {
            return null;
        }
        VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
        BufferedImage bufferedImage = null;
        try {
            int n3 = DistributionImageUtil.getValidPerametersCount(doubleArray);
            String string = "true";
            StringBuffer stringBuffer = new StringBuffer();
            if (vector == null) {
                stringBuffer.append("<row>").append(0).append(";").append(1).append("</row>");
                stringBuffer.append("<row>").append(100).append(";").append(1).append("</row>");
                string = "false";
            } else {
                for (BaseMCSimulationTab.HistoBin histoBin : vector) {
                    stringBuffer.append("<row>").append(histoBin.getBoundry()).append(";").append(histoBin.getCount()).append("</row>");
                }
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            if (doubleArray[0] != null && doubleArray[1] != null) {
                int n4 = n3 / 3;
                if (n3 > 1) {
                    double d = 0.0;
                    double d2 = 100.0;
                    if (vector != null && vector.size() > 1) {
                        d = vector.get(0).getBoundry();
                        d2 = vector.get(vector.size() - 1).getBoundry();
                    }
                    double[] dArray = DistributionImageUtil.getXAxisData(d, d2, 100);
                    for (int i = 0; i < n4; ++i) {
                        int n5;
                        double d3;
                        double[] dArray2 = DistributionImageUtil.getWeibullValues(dArray, doubleArray[2 * i], doubleArray[2 * i + 1], doubleArray[2 * i + 2] != null ? doubleArray[2 * i + 2] : 0.0);
                        if (vector != null) {
                            d3 = DistributionImageUtil.getFittedWeibullRatio(vector, dArray2);
                            for (n5 = 0; n5 < dArray2.length; ++n5) {
                                dArray2[n5] = d3 * dArray2[n5];
                            }
                        } else {
                            d3 = -1.0;
                            for (n5 = 0; n5 < dArray2.length; ++n5) {
                                if (!(dArray2[n5] > d3)) continue;
                                d3 = dArray2[n5];
                            }
                            for (n5 = 0; n5 < dArray2.length; ++n5) {
                                dArray2[n5] = dArray2[n5] * 0.9 / d3;
                            }
                        }
                        for (int j = 0; j < dArray.length; ++j) {
                            stringBuffer2.append("<row>").append(dArray[j]).append(";").append(dArray2[j]).append(";").append(i).append("</row>");
                        }
                    }
                }
            }
            String string2 = MessageFormat.format(linesHist, stringBuffer.toString(), stringBuffer2.toString(), string);
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string2));
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            visualization.setOutputSize(n, n2);
            bufferedImage = visualization.makeImage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bufferedImage;
    }

    private static int getValidPerametersCount(Double[] doubleArray) {
        int n;
        if (doubleArray != null) {
            for (n = 0; n < doubleArray.length && doubleArray[n] != null; ++n) {
            }
        }
        return n;
    }

    private static double getTriangleModeValue(Vector<BaseMCSimulationTab.HistoBin> vector, double d, double d2, double d3, double d4) {
        int n;
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
        int n2 = 10;
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = (double)(n + 1) * d4 / (double)n2;
        }
        for (n = 0; n < n2; ++n) {
            treeMap.put(DistributionImageUtil.calculateTriangleAreaDiff(vector, d, d3, dArray[n]), dArray[n]);
        }
        Double d5 = (Double)treeMap.firstKey();
        return (Double)treeMap.get(d5);
    }

    private static double calculateTriangleAreaDiff(Vector<BaseMCSimulationTab.HistoBin> vector, double d, double d2, double d3) {
        int n = vector.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = vector.get(i).getBoundry();
            dArray2[i] = vector.get(i).getCount();
        }
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d4 += dArray2[i];
        }
        double d5 = (d2 - d) * d3 / 2.0;
        return Math.abs((d4 *= dArray[1] - dArray[0]) - d5);
    }

    private static double getFittedLogNormalRatio(Vector<BaseMCSimulationTab.HistoBin> vector, double[] dArray, double d, double d2) {
        int n;
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
        double[] dArray2 = new double[vector.size()];
        double[] dArray3 = new double[vector.size()];
        double d3 = -1.0;
        int n2 = 0;
        for (BaseMCSimulationTab.HistoBin histoBin : vector) {
            if (histoBin.getCount() > d3) {
                d3 = histoBin.getCount();
            }
            dArray2[n2] = histoBin.getBoundry();
            dArray3[n2] = histoBin.getCount();
            ++n2;
        }
        double d4 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            d4 += dArray3[i];
        }
        d4 *= dArray2[1] - dArray2[0];
        double d5 = -1.0;
        for (double d6 : dArray) {
            if (!(d6 > d5)) continue;
            d5 = d6;
        }
        double d7 = d3 / d5;
        int n3 = 10;
        double[] dArray4 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray4[i] = (double)(i + 1) * d7 / (double)n3;
        }
        double d8 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d8 += dArray[n];
        }
        d8 *= (dArray2[1] - dArray2[0]) * (double)vector.size() / 100.0;
        for (n = 0; n < n3; ++n) {
            treeMap.put(Math.abs(d4 - dArray4[n] * d8), dArray4[n]);
        }
        Double d9 = (Double)treeMap.firstKey();
        return (Double)treeMap.get(d9);
    }

    private static double[] getBinomialDist(int n, double d, int n2) {
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d2 = 1.0;
            for (int j = 1; j <= n - i; ++j) {
                d2 *= (double)(n - j + 1) * (1.0 - d) / (double)j;
            }
            dArray[i] = d2 *= Math.pow(d, i);
        }
        return dArray;
    }

    private static double[] getNegBinomialDist(int n, double d, int n2) {
        if (n < 1) {
            return null;
        }
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d2 = Math.pow(1.0 - d, n);
            for (int j = 1; j <= n - 1; ++j) {
                d2 *= ((double)i + (double)j) / (double)j;
            }
            dArray[i] = d2 *= Math.pow(d, i);
        }
        return dArray;
    }

    private static double[] getPoissonDist(int n, int n2) {
        double[] dArray = new double[n2];
        dArray[0] = Math.pow(Math.E, -n);
        for (int i = 1; i < n2; ++i) {
            double d = 1.0;
            for (int j = 1; j <= i; ++j) {
                d *= (double)n / (double)j;
            }
            dArray[i] = d *= Math.pow(Math.E, -n);
        }
        return dArray;
    }

    private static double[] getNernoulliDist(double d, int n) {
        if (n < 2) {
            return null;
        }
        double[] dArray = new double[n];
        dArray[0] = 1.0 - d;
        dArray[1] = d;
        return dArray;
    }

    private static double[] getXAxisData(double d, double d2, int n) {
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + (double)i * d3;
        }
        return dArray;
    }

    private static double[] getLogNormalValues(double[] dArray, double d, double d2) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] == 0.0 ? 0.0 : Math.exp(-((Math.log(dArray[i]) - d) * (Math.log(dArray[i]) - d) / (2.0 * d2 * d2))) / (dArray[i] * d2 * Math.sqrt(Math.PI * 2));
        }
        return dArray2;
    }

    private static double getRangeScale(Vector<BaseMCSimulationTab.HistoBin> vector, Double[] doubleArray, int n) {
        double d = 1.0;
        if (vector != null && doubleArray.length > 0) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(doubleArray[i * 3 + 2]);
            }
            if (arrayList.size() > 0) {
                Collections.sort(arrayList);
                Double d2 = (Double)arrayList.get(0);
                if (arrayList.size() > 1) {
                    d2 = (Double)arrayList.get(arrayList.size() - 1);
                }
                double d3 = -1.0;
                for (BaseMCSimulationTab.HistoBin histoBin : vector) {
                    if (!(histoBin.getCount() > d3)) continue;
                    d3 = histoBin.getCount();
                }
                d = d3 / d2;
            }
        }
        return d;
    }

    private static double[] getWeibullValues(double[] dArray, double d, double d2, double d3) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] < 0.0 ? 0.0 : d2 / d * Math.pow((dArray[i] - d3) / d, d2 - 1.0) * Math.exp(-Math.pow((dArray[i] - d3) / d, d2));
        }
        return dArray2;
    }

    private static double getFittedWeibullRatio(Vector<BaseMCSimulationTab.HistoBin> vector, double[] dArray) {
        int n;
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
        double[] dArray2 = new double[vector.size()];
        double[] dArray3 = new double[vector.size()];
        double d = -1.0;
        int n2 = 0;
        for (BaseMCSimulationTab.HistoBin histoBin : vector) {
            if (histoBin.getCount() > d) {
                d = histoBin.getCount();
            }
            dArray2[n2] = histoBin.getBoundry();
            dArray3[n2] = histoBin.getCount();
            ++n2;
        }
        double d2 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            d2 += dArray3[i];
        }
        d2 *= dArray2[1] - dArray2[0];
        double d3 = -1.0;
        for (double d4 : dArray) {
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        double d5 = d / d3;
        int n3 = 10;
        double[] dArray4 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray4[i] = (double)(i + 1) * d5 / (double)n3;
        }
        double d6 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d6 += dArray[n];
        }
        d6 *= (dArray2[1] - dArray2[0]) * (double)vector.size() / 100.0;
        for (n = 0; n < n3; ++n) {
            treeMap.put(Math.abs(d2 - dArray4[n] * d6), dArray4[n]);
        }
        Double d7 = (Double)treeMap.firstKey();
        return (Double)treeMap.get(d7);
    }
}

