/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.MC;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.server.messages.sysfilemsg.ObsVecMap;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.MC.FitStatistics;
import com.spss.java_client.ui.dialogs.MC.MCSimulationTab;
import com.spss.java_client.ui.dialogs.MC.MonteCarloSimulationDlg;
import com.spss.java_client.ui.dialogs.MC.SimInputNotBeFitAlertDialog;
import com.spss.java_client.ui.dialogs.MC.SimulatedField;
import com.spss.java_client.ui.dialogs.MC.SimulationHelper;
import com.spss.java_client.ui.dialogs.MC.SimulationPlanHandler;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.FrequenciesScanner;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.utils.ZipUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public abstract class BaseMCSimulationTab
extends BaseProcedureTab
implements IFrequencyScannerListener {
    private CoreFrequencies mCoreFrequencies = new CoreFrequencies();
    protected Hashtable<String, ScannedVar> mScannedVarMap;
    private long mCasesScanned = 0L;
    private String[] mScannedVarNames;
    protected ArrayList<SimulatedField> mSimFieldList = new ArrayList();
    protected Vector<String> mMismatchVars = new Vector();

    public BaseMCSimulationTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    protected boolean runFitAllSub() {
        return this.runFittingAndScanning(-1);
    }

    public boolean runFitSelectedSub(int n) {
        return this.runFittingAndScanning(n);
    }

    @Override
    public void reset() {
        if (this.mScannedVarMap != null) {
            this.mScannedVarMap.clear();
        }
        if (this.mSimFieldList != null) {
            this.mSimFieldList.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runFittingAndScanning(int n) {
        block12: {
            Vector<String> vector = new Vector<String>();
            String string = this.getFitONLYsyntax(n, vector, "");
            if (string.length() <= 0) {
                return false;
            }
            boolean bl = SyntaxMgr.getSyntaxMgr().executeSynchronousSyntax(string);
            if (!bl) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_MC_ERROR_CANNOT_FIT"), VersionInfo.getAppVersionString());
                return false;
            }
            ByteBuffer byteBuffer = OutputManager.getOutputManager().getSimulationFitStatsXML();
            try {
                if (byteBuffer != null && byteBuffer.array().length > 0) {
                    ByteArrayInputStream byteArrayInputStream;
                    InputStreamReader inputStreamReader;
                    SimulationPlanHandler simulationPlanHandler;
                    if (this instanceof MCSimulationTab) {
                        // empty if block
                    }
                    if (bl = (simulationPlanHandler = new SimulationPlanHandler()).parsingFitStats(inputStreamReader = new InputStreamReader((InputStream)(byteArrayInputStream = new ByteArrayInputStream(ZipUtil.decompressBytes((byte[])byteBuffer.array()))), "UTF-8"), this.mSimFieldList)) {
                        this.mMismatchVars.clear();
                        for (int i = 0; i < this.mSimFieldList.size(); ++i) {
                            SimulatedField simulatedField = this.mSimFieldList.get(i);
                            boolean bl2 = true;
                            if (!vector.contains(simulatedField.getName())) continue;
                            if (simulatedField.getDistributionType() == SimulationHelper.DistributionType.MULTINOMIAL && simulatedField.isTotalZero()) {
                                this.mMismatchVars.add(simulatedField.getName());
                                bl2 = false;
                            }
                            if (!bl2) continue;
                            this.mSimFieldList.get(i).setAutoFit(MonteCarloSimulationDlg.FitToState.MatchedAndFitted);
                        }
                        this.setSimulatedPredictors(this.mSimFieldList);
                        this.updateParameterCellFor(vector);
                        if (this instanceof MCSimulationTab) {
                            ((MCSimulationTab)this).loadCorrelationTable(simulationPlanHandler.getCorrelationMatrix());
                        }
                        this.runScanData();
                    }
                    break block12;
                }
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_MC_ERROR_CANNOT_FIT"), VersionInfo.getAppVersionString());
                return false;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (this.mMismatchVars.size() > 0) {
            new SimInputNotBeFitAlertDialog((MonteCarloSimulationDlg)this.mParent, this.getResString("IDS_MC_ERROR_CATS_NOT_MATCH"), VersionInfo.getAppVersionString(), this.mMismatchVars);
        }
        return true;
    }

    public String getFitOnlySyntax(int n, String string) {
        return this.getFitONLYsyntax(n, null, string);
    }

    private String getFitONLYsyntax(int n, Vector<String> vector, String string) {
        String string2;
        IDataDocument iDataDocument;
        StringBuffer stringBuffer = new StringBuffer("");
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId != null && (iDataDocument = DataMgr.getDataMgr().findDataDocument(locallyUniqueId)) != null && (string2 = iDataDocument.getDatasetName()).length() > 0) {
            stringBuffer.append("DATASET ACTIVATE " + string2 + ".\n");
        }
        stringBuffer.append("_SIMPLAN FITONLY");
        int n2 = this.getNumSimulatedFields();
        if (n2 == 0) {
            return "";
        }
        if (this.mScannedVarMap == null) {
            this.mScannedVarMap = new Hashtable();
        }
        boolean bl = n == -1;
        this.mSimFieldList.clear();
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (int i = 0; i < n2; ++i) {
            SimulatedField simulatedField = this.getFitToSimulatedField(i);
            if (simulatedField == null) continue;
            this.mSimFieldList.add(simulatedField);
            String string3 = simulatedField.getMappedName();
            if (string3.length() <= 0 || string3.trim().length() <= 0) continue;
            String string4 = simulatedField.getName();
            if (n == -1 || n == i) {
                if (!simulatedField.isLocked()) {
                    if (this.mScannedVarMap.get(string3) == null) {
                        this.mScannedVarMap.put(string3, new ScannedVar(simulatedField));
                    }
                    simulatedField.removeAllParameters();
                    simulatedField.removeMismaches();
                    if (string.length() == 0) {
                        stringBuffer2.append("\n  /SIMINPUT INPUT=" + string4);
                        if (vector != null) {
                            vector.add(string4);
                        }
                        if (!string4.equalsIgnoreCase(string3)) {
                            stringBuffer2.append("(MAPTO=");
                            stringBuffer2.append(string3);
                            stringBuffer2.append(")");
                        }
                        if (simulatedField.getAutoFitState() == MonteCarloSimulationDlg.FitToState.DistributionFitChanged) {
                            stringBuffer2.append(" TYPE=AUTOFIT(");
                            ArrayList<FitStatistics> arrayList = simulatedField.getAllFitStats();
                            for (int j = 0; j < arrayList.size(); ++j) {
                                SimulationHelper.DistributionType distributionType = arrayList.get(j).getDistType();
                                if (distributionType == SimulationHelper.DistributionType.EMPIRICAL) continue;
                                stringBuffer2.append(SimulationHelper.getDistributionSyntax(distributionType) + " ");
                            }
                            stringBuffer2.append(")");
                        } else {
                            stringBuffer2.append(" TYPE=AUTOFIT(");
                            stringBuffer2.append(SimulationHelper.getSyntaxForMLevel(simulatedField.getMeasurementLevel()));
                            stringBuffer2.append(")");
                        }
                        stringBuffer2.append(" ");
                    } else if (n == i) {
                        stringBuffer2.append(string);
                    }
                    simulatedField.removeAllFitStats();
                    continue;
                }
                stringBuffer2.append("\n  /SIMINPUT INPUT=" + string4);
                stringBuffer2.append("(");
                if (!string4.equalsIgnoreCase(string3)) {
                    stringBuffer2.append("MAPTO=");
                    stringBuffer2.append(string3);
                }
                stringBuffer2.append(" DISTGROUP=");
                stringBuffer2.append(this.getDistGroupString(simulatedField));
                stringBuffer2.append(")");
                stringBuffer2.append(" TYPE = MANUAL( LOCK = YES )");
                continue;
            }
            stringBuffer2.append("\n  /SIMINPUT INPUT=" + string4);
            stringBuffer2.append("(");
            if (!string4.equalsIgnoreCase(string3)) {
                stringBuffer2.append("MAPTO=");
                stringBuffer2.append(string3);
            }
            stringBuffer2.append(" DISTGROUP=");
            stringBuffer2.append(this.getDistGroupString(simulatedField));
            stringBuffer2.append(")");
            stringBuffer2.append(" TYPE = MANUAL");
        }
        if (stringBuffer2.toString().length() == 0) {
            return "";
        }
        stringBuffer.append(stringBuffer2);
        String string5 = this.getAutofitNCasesSyntax();
        if (string5 != null) {
            stringBuffer.append(string5);
        }
        stringBuffer.append(this.getMissingHandleSyntax());
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    private String getDistGroupString(SimulatedField simulatedField) {
        MeasurementLevel measurementLevel = simulatedField.getMeasurementLevel();
        SimulationHelper.DistributionType distributionType = simulatedField.getDistributionType();
        if (distributionType != SimulationHelper.DistributionType.NONE && distributionType != SimulationHelper.DistributionType.EMPIRICAL && !SimulationHelper.isDefaultDistribution(distributionType, measurementLevel)) {
            measurementLevel = SimulationHelper.getMLevelOfDistribution(distributionType);
        }
        if (measurementLevel == MeasurementLevel.scale) {
            return "CONTINUOUS";
        }
        if (measurementLevel == MeasurementLevel.ordinal) {
            return "DISCRETE";
        }
        if (measurementLevel == MeasurementLevel.nominal) {
            return "CATEGORICAL";
        }
        return "CONTINUOUS";
    }

    private boolean runScanData() {
        String[] stringArray;
        Enumeration<String> enumeration = this.mScannedVarMap.keys();
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (this.mScannedVarMap.get(stringArray).getValMap() != null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        for (String object2 : vector) {
            stringArray[n++] = object2;
        }
        FrequenciesThread frequenciesThread = new FrequenciesThread(1000L, stringArray);
        frequenciesThread.start();
        FrequenciesScanner frequenciesScanner = new FrequenciesScanner(this.mCoreFrequencies, this.mParent, this.getResString("IDS_MI_IMPUTE_MISSING_DATA_TITLE"), false);
        frequenciesScanner.registerScannerListener(this);
        frequenciesScanner.startScanning();
        return true;
    }

    private int getUpdateInterval(long l) {
        int n = 500;
        if (l > 500000L) {
            n = 2000;
        } else if (l > 100000L) {
            n = 1000;
        }
        return n;
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        int n = coreFrequencies.getVarMapCount();
        this.mCasesScanned = coreFrequencies.casesPassed();
        for (int i = 0; i < n; ++i) {
            ObsVecMap obsVecMap = coreFrequencies.getVariableMap(i);
            short s = (Short)obsVecMap.getKeySpec().get(0);
            TreeMap treeMap = obsVecMap.getObsMap();
            String string = this.mScannedVarNames[i];
            ScannedVar scannedVar = this.mScannedVarMap.get(string);
            long l = this.getNonMissingCount(treeMap, scannedVar);
            int n2 = scannedVar.getValMap().size();
            if (n2 <= 0 || s != 0) continue;
            double d = scannedVar.getValMap().firstKey().getNum();
            double d2 = scannedVar.getValMap().lastKey().getNum();
            scannedVar.setNoOfBins(this.computeNumOfBin(l));
            this.createHistoData(scannedVar, d, d2);
        }
        this.setScannedVarMap(this.mScannedVarMap);
    }

    private long getNonMissingCount(TreeMap<OBS, Double> treeMap, ScannedVar scannedVar) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = 0;
        long l = 0L;
        TreeMap<OBS, Double> treeMap2 = new TreeMap<OBS, Double>();
        for (Map.Entry<OBS, Double> entry : treeMap.entrySet()) {
            boolean bl;
            OBS oBS = entry.getKey();
            double d = entry.getValue();
            boolean bl2 = scannedVar.getSimulatedField().isMissing(oBS);
            boolean bl3 = bl = oBS.getNum() == iSpssDataSrc.getSystemMissing();
            if (bl2 || bl) {
                n += (int)d;
                continue;
            }
            l = (long)((double)l + d);
            treeMap2.put(oBS, d);
        }
        scannedVar.setValMap(treeMap2);
        scannedVar.setMissingVals(n);
        return l;
    }

    private void createHistoData(ScannedVar scannedVar, double d, double d2) {
        int n = scannedVar.getNoOfBins();
        SPSS_Format sPSS_Format = scannedVar.getSimulatedField().getFormat();
        double d3 = (d2 - d) / (double)(n - 1);
        if (0.0 == d3) {
            d3 = this.getOffset(sPSS_Format.getFormatType(), sPSS_Format.getWidth(), sPSS_Format.getDecimals(), scannedVar.getMinVal(), scannedVar);
        }
        scannedVar.setInterval(d3);
        scannedVar.setStartPos(d - d3);
        scannedVar.setEndPos(d2 + d3);
        double d4 = scannedVar.getStartPos();
        this.computeFreqForEachBin(scannedVar, d4, n, d3);
    }

    private void computeFreqForEachBin(ScannedVar scannedVar, double d, int n, double d2) {
        int n2;
        double d3;
        double[] dArray;
        double[] dArray2;
        try {
            dArray2 = new double[n + 1];
            dArray = new double[n + 1];
            for (int i = 0; i <= n; ++i) {
                dArray2[i] = d + d2 * (double)(i + 1);
                dArray[i] = 0.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        for (Map.Entry<OBS, Double> object : scannedVar.getValMap().entrySet()) {
            d3 = scannedVar.getSimulatedField().getType() > 0 ? Double.parseDouble(object.getKey().getString()) : object.getKey().getNum();
            double d4 = object.getValue();
            for (n2 = 0; n2 < n; ++n2) {
                if (!(d3 >= dArray2[n2]) || !(d3 < dArray2[n2 + 1])) continue;
                int n3 = n2 + 1;
                dArray[n3] = dArray[n3] + d4;
            }
        }
        Vector vector = new Vector(n + 1);
        d3 = 0.0;
        OBS oBS = new OBS();
        SPSS_Format sPSS_Format = scannedVar.getSimulatedField().getFormat();
        sPSS_Format.setDecimals((byte)2);
        for (n2 = 0; n2 <= n; ++n2) {
            oBS.setNum(dArray2[n2]);
            HistoBin histoBin = new HistoBin();
            histoBin.setBinBoundry(dArray2[n2]);
            histoBin.setBinCount(dArray[n2]);
            vector.add(n2, histoBin);
            d3 = d3 < dArray[n2] ? dArray[n2] : d3;
        }
        scannedVar.setHistoBin(vector);
        scannedVar.setMaximumValue(d3);
    }

    public double getOffset(FormatType formatType, int n, int n2, double d, ScannedVar scannedVar) {
        double d2;
        switch (formatType) {
            case DATE: 
            case ADATE: 
            case JDATE: 
            case EDATE: 
            case SDATE: {
                d2 = 86400.0;
                break;
            }
            case TIME: {
                if (n2 > 0) {
                    d2 = Math.pow(10.0, -1 * n2);
                    break;
                }
                if (n >= 8 && n < 11) {
                    d2 = 1.0;
                    break;
                }
                d2 = 60.0;
                break;
            }
            case DATETIME: {
                if (n2 > 0) {
                    d2 = Math.pow(10.0, -1 * n2);
                    break;
                }
                if (n >= 20 && n < 23) {
                    d2 = 1.0;
                    break;
                }
                d2 = 60.0;
                break;
            }
            case DTIME: {
                if (n2 > 0) {
                    d2 = Math.pow(10.0, -1 * n2);
                    break;
                }
                if (n >= 12 && n < 15) {
                    d2 = 1.0;
                    break;
                }
                d2 = 60.0;
                break;
            }
            case MOYR: {
                d2 = 2678400.0;
                break;
            }
            case QYR: {
                d2 = 93.0;
                d2 *= 86400.0;
                break;
            }
            case WKYR: {
                d2 = 604800.0;
                break;
            }
            case WKDAY: 
            case MONTH: {
                d2 = 1.0;
                break;
            }
            default: {
                d2 = d == Math.ceil(d) && this.areAllDataValuesInt(scannedVar) ? 1.0 : Math.pow(10.0, -1 * n2);
            }
        }
        return d2;
    }

    public boolean areAllDataValuesInt(ScannedVar scannedVar) {
        for (Map.Entry<OBS, Double> entry : scannedVar.getValMap().entrySet()) {
            double d = entry.getKey().getNum();
            if (d == Math.ceil(d)) continue;
            return false;
        }
        return true;
    }

    private int computeNumOfBin(long l) {
        int n = (int)(3.0 + Math.log10(l) * (Math.log(l) / Math.log(2.0)));
        if (n < 3) {
            n = 3;
        } else if (n > 40) {
            n = 40;
        }
        return n;
    }

    public abstract int getNumSimulatedFields();

    abstract SimulatedField getFitToSimulatedField(int var1);

    abstract void setScannedVarMap(Hashtable<String, ScannedVar> var1);

    abstract void setSimulatedPredictors(ArrayList<SimulatedField> var1);

    abstract void updateParameterCellFor(Vector<String> var1);

    abstract String getAutofitNCasesSyntax();

    abstract String getMissingHandleSyntax();

    static /* synthetic */ String[] access$002(BaseMCSimulationTab baseMCSimulationTab, String[] stringArray) {
        baseMCSimulationTab.mScannedVarNames = stringArray;
        return stringArray;
    }

    public class HistoBin {
        double mBoundry;
        double mCount;
        String mLabel = "";

        public void setBinBoundry(double d) {
            this.mBoundry = d;
        }

        public void setLabel(String string) {
            this.mLabel = string;
        }

        public void setBinCount(double d) {
            this.mCount = d;
        }

        public double getCount() {
            return this.mCount;
        }

        public double getBoundry() {
            return this.mBoundry;
        }

        public String getLabel() {
            return this.mLabel;
        }
    }

    public class ScannedVar {
        private SimulatedField mSpssVar;
        private long mMissingVals;
        private double mMinVal;
        private double mMaxVal;
        private double mMaxValFromFreqTable;
        Vector<HistoBin> mHistobins;
        public double mInterval;
        public double mStartpos;
        public double mEndpos;
        public int mNoOfBins;
        private TreeMap<OBS, Double> mFreqTable;
        public boolean mDrawHistogram = false;

        public ScannedVar(SimulatedField simulatedField) {
            this.mSpssVar = simulatedField;
        }

        public void setHistoBin(Vector<HistoBin> vector) {
            this.mHistobins = vector;
        }

        public double getStartPos() {
            return this.mStartpos;
        }

        public double getEndPos() {
            return this.mEndpos;
        }

        public void setEndPos(double d) {
            this.mEndpos = d;
        }

        public void setStartPos(double d) {
            this.mStartpos = d;
        }

        public void setInterval(double d) {
            this.mInterval = d;
        }

        public double getInterval() {
            return this.mInterval;
        }

        public double getMaxVal() {
            return this.mMaxVal;
        }

        public void setMaxVal(double d) {
            this.mMaxVal = d;
        }

        public double getMinVal() {
            return this.mMinVal;
        }

        public void setMinVal(double d) {
            this.mMinVal = d;
        }

        public long getMissingVals() {
            return this.mMissingVals;
        }

        public void setMissingVals(long l) {
            this.mMissingVals = l;
        }

        public TreeMap<OBS, Double> getValMap() {
            return this.mFreqTable;
        }

        public void setValMap(TreeMap<OBS, Double> treeMap) {
            this.mFreqTable = treeMap;
            if (this.mFreqTable.size() > 0) {
                this.mMinVal = this.mFreqTable.firstKey().getNum();
                this.mMaxVal = this.mFreqTable.lastKey().getNum();
                this.mDrawHistogram = this.mMaxVal != this.mMinVal;
            }
        }

        public SimulatedField getSimulatedField() {
            return this.mSpssVar;
        }

        public void setNoOfBins(int n) {
            this.mNoOfBins = n;
        }

        public double getMaximumValue() {
            return this.mMaxValFromFreqTable;
        }

        public void setMaximumValue(double d) {
            this.mMaxValFromFreqTable = d;
        }

        public int getNoOfBins() {
            return this.mNoOfBins;
        }

        public Vector<HistoBin> getHistoBins() {
            return this.mHistobins;
        }

        public boolean canDrawHistogram() {
            return this.mDrawHistogram;
        }
    }

    class FrequenciesThread
    extends Thread {
        private long mMaxCases;

        public FrequenciesThread(long l, String[] stringArray) {
            this.mMaxCases = l;
            BaseMCSimulationTab.access$002(BaseMCSimulationTab.this, stringArray);
        }

        @Override
        public void run() {
            int n;
            super.run();
            DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
            LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            Vector<LocallyUniqueId> vector = new Vector<LocallyUniqueId>();
            for (String string : BaseMCSimulationTab.this.mScannedVarNames) {
                n = iSpssDataSrc.findVarIndex(string);
                if (n < 0) continue;
                vector.add(iSpssDataSrc.getVariable(n).getId());
            }
            if (vector.size() == 0) {
                return;
            }
            long l = iSpssDataSrc.rowCount();
            long l2 = this.mMaxCases == -1L ? Math.min(1000000L, l) : this.mMaxCases;
            n = BaseMCSimulationTab.this.getUpdateInterval(l2);
            BaseMCSimulationTab.this.mCoreFrequencies.wantWeighted(true);
            BaseMCSimulationTab.this.mCoreFrequencies.run(locallyUniqueId, vector, n, this.mMaxCases);
        }
    }
}

