/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.icon_view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class IconViewerItem
extends JComponent {
    private int mId;
    private ImageIcon mIcon;
    private ImageIcon mDisabledIcon;
    private boolean mEnabled;
    private boolean mSelected;
    private Image mSelectedimage;
    private Object mUserData;

    public IconViewerItem(int n, ImageIcon imageIcon) {
        this(n, imageIcon, null, null);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIconViewerItem();
        }
        return this.accessibleContext;
    }

    public IconViewerItem(int n, ImageIcon imageIcon, String string) {
        this(n, imageIcon, null, string, null);
    }

    public IconViewerItem(int n, ImageIcon imageIcon, ImageIcon imageIcon2, String string) {
        this(n, imageIcon, imageIcon2, string, null);
    }

    public IconViewerItem(int n, ImageIcon imageIcon, ImageIcon imageIcon2, String string, Object object) {
        this.mId = n;
        this.mIcon = imageIcon;
        this.mUserData = object;
        this.mDisabledIcon = imageIcon2;
        this.mEnabled = true;
        this.mSelected = false;
        this.mSelectedimage = null;
        if (string != null && string.length() > 0) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setToolTipText(string);
        }
    }

    public int getId() {
        return this.mId;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mEnabled = bl;
        this.repaint(100L);
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public void setSelected(boolean bl) {
        if (this.mSelected != bl) {
            this.mSelected = bl;
            this.repaint(100L);
        }
    }

    public ImageIcon getIcon() {
        return this.mIcon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.mIcon = imageIcon;
        this.repaint(100L);
    }

    public ImageIcon getDisabledIcon() {
        return this.mDisabledIcon;
    }

    public void setDisabledIcon(ImageIcon imageIcon) {
        this.mDisabledIcon = imageIcon;
        this.repaint(100L);
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public void setUserData(Object object) {
        this.mUserData = object;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.mIcon != null) {
            return new Dimension(this.mIcon.getIconWidth(), this.mIcon.getIconHeight());
        }
        return new Dimension(16, 16);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    void cleanup() {
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        ImageIcon imageIcon;
        ImageIcon imageIcon2 = imageIcon = !this.mEnabled && this.mDisabledIcon != null ? this.mDisabledIcon : this.mIcon;
        if (this.mSelected && this.mEnabled && this.getParent() != null && this.getParent().hasFocus()) {
            if (this.mSelectedimage == null) {
                this.generateSelectedImage(this.mIcon);
            }
            graphics.drawImage(this.mSelectedimage, 0, 0, null);
        } else {
            graphics.drawImage(imageIcon.getImage(), 0, 0, null);
        }
    }

    private void generateSelectedImage(ImageIcon imageIcon) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int n, int n2, int n3) {
                int n4;
                int n5 = n4 = n2 % 2 == 0 ? 1 : 0;
                if ((n + n4) % 2 == 0) {
                    return 0xFF000000 & n3 | 0xC0C0C0;
                }
                return n3;
            }
        };
        Dimension dimension = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, dimension.width, dimension.height);
        imageIcon.paintIcon(this, graphics2D, 0, 0);
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        this.mSelectedimage = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    class AccessibleIconViewerItem
    extends JComponent.AccessibleJComponent {
        AccessibleIconViewerItem() {
            super(IconViewerItem.this);
        }

        @Override
        public String getAccessibleName() {
            return this.getToolTipText();
        }

        @Override
        public String getAccessibleDescription() {
            return this.getToolTipText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST_ITEM;
        }
    }
}

