/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.icon_view;

import com.spss.java_client.ui.controls.icon_view.ConstrainedFlowLayout;
import com.spss.java_client.ui.controls.icon_view.IconViewDragAdapter;
import com.spss.java_client.ui.controls.icon_view.IconViewerActionListener;
import com.spss.java_client.ui.controls.icon_view.IconViewerItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class IconViewer
extends JPanel
implements FocusListener {
    private static int ITEM_GAP = 8;
    private TreeMap<Integer, IconViewerItem> mItems = new TreeMap();
    private IconViewerItem mSelectedItem;
    private ConstrainedFlowLayout mLayoutMgr;
    private ViewerKeyListener mKeyListener;
    private MouseClickAdapter mMouseAdapter;
    private IconViewDragAdapter mDragAdapter;
    private Vector<IconViewerActionListener> mActionListeners = new Vector();

    public IconViewer() {
        this(-1);
    }

    public IconViewer(int n) {
        super(true);
        this.mLayoutMgr = new ConstrainedFlowLayout(n, 3, ITEM_GAP, ITEM_GAP);
        this.setLayout(this.mLayoutMgr);
        this.mSelectedItem = null;
        this.mDragAdapter = null;
        this.mKeyListener = new ViewerKeyListener();
        this.addKeyListener(this.mKeyListener);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.mMouseAdapter = new MouseClickAdapter();
    }

    public void addItem(IconViewerItem iconViewerItem) {
        this.addItemListeners(iconViewerItem);
        this.mItems.put(iconViewerItem.getId(), iconViewerItem);
        this.add(iconViewerItem);
        if (this.accessibleContext != null) {
            this.getAccessibleContext().firePropertyChange("AccessibleVisibleData", false, true);
        }
    }

    public void removeItem(IconViewerItem iconViewerItem) {
        this.removeItemListeners(iconViewerItem);
        this.mItems.remove(iconViewerItem.getId());
        this.remove(iconViewerItem);
        this.selectEnabledItem();
        if (this.accessibleContext != null) {
            this.getAccessibleContext().firePropertyChange("AccessibleVisibleData", false, true);
        }
    }

    public void removeAllItems() {
        this.cleanup();
        this.mItems.clear();
        this.removeAll();
        this.mSelectedItem = null;
        if (this.accessibleContext != null) {
            this.getAccessibleContext().firePropertyChange("AccessibleVisibleData", false, true);
        }
    }

    public void addActionListener(IconViewerActionListener iconViewerActionListener) {
        if (!this.mActionListeners.contains(iconViewerActionListener)) {
            this.mActionListeners.add(iconViewerActionListener);
        }
    }

    public void removeActionListener(IconViewerActionListener iconViewerActionListener) {
        this.mActionListeners.remove(iconViewerActionListener);
    }

    public void cleanup() {
        for (Map.Entry<Integer, IconViewerItem> entry : this.mItems.entrySet()) {
            ToolTipManager.sharedInstance().unregisterComponent(entry.getValue());
        }
    }

    public boolean setItemEnabledState(int n, boolean bl) {
        if (this.mItems.containsKey(n)) {
            this.mItems.get(n).setEnabled(bl);
            this.selectEnabledItem();
            return true;
        }
        return false;
    }

    public void enableAllItems(boolean bl) {
        for (Map.Entry<Integer, IconViewerItem> entry : this.mItems.entrySet()) {
            entry.getValue().setEnabled(bl);
        }
    }

    public ImageIcon getSelectedItemImage() {
        if (this.mSelectedItem == null) {
            return null;
        }
        return this.mSelectedItem.getIcon();
    }

    public IconViewerItem getSelectedItem() {
        return this.mSelectedItem;
    }

    public void setSelectedItem(IconViewerItem iconViewerItem) {
        if (this.mSelectedItem != iconViewerItem) {
            int n;
            Accessible accessible = null;
            if (this.mSelectedItem != null && this.mSelectedItem.isSelected()) {
                n = this.isOneBased() ? this.mSelectedItem.getId() - 1 : this.mSelectedItem.getId();
                accessible = this.getAccessibleContext().getAccessibleChild(n);
            }
            if (this.mSelectedItem != null) {
                this.mSelectedItem.setSelected(false);
            }
            if (iconViewerItem != null) {
                iconViewerItem.setSelected(true);
            }
            this.mSelectedItem = iconViewerItem;
            Accessible accessible2 = null;
            if (this.mSelectedItem != null && this.mSelectedItem.isSelected()) {
                n = this.isOneBased() ? this.mSelectedItem.getId() - 1 : this.mSelectedItem.getId();
                accessible2 = this.getAccessibleContext().getAccessibleChild(n);
            }
            this.getAccessibleContext().firePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
            this.getAccessibleContext().firePropertyChange("AccessibleVisibleData", false, true);
            this.getAccessibleContext().firePropertyChange("AccessibleSelection", false, true);
        }
    }

    public void setSelectedItem(int n) {
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(this.getItem(n));
        }
    }

    public IconViewerItem getItem(int n) {
        return this.mItems.get(n);
    }

    public void setDragAdapter(IconViewDragAdapter iconViewDragAdapter) {
        this.mDragAdapter = iconViewDragAdapter;
        this.removeListeners();
        this.addListeners();
    }

    public void doContextMenu(IconViewerItem iconViewerItem, Point point, int n, boolean bl) {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIconViewer();
        }
        return this.accessibleContext;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.mSelectedItem == null) {
            for (Component component : this.getComponents()) {
                if (!(component instanceof IconViewerItem) || !component.isEnabled()) continue;
                this.setSelectedItem(this.mItems.get(((IconViewerItem)component).getId()));
                break;
            }
        }
        if (this.mSelectedItem != null) {
            this.mSelectedItem.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.mSelectedItem != null) {
            this.mSelectedItem.repaint();
        }
    }

    @Override
    public void doLayout() {
        this.removeAll();
        for (Map.Entry<Integer, IconViewerItem> entry : this.mItems.entrySet()) {
            this.add(entry.getValue());
        }
        super.doLayout();
    }

    public void addListeners() {
        this.addKeyListener(this.mKeyListener);
        if (this.mItems != null) {
            for (Map.Entry<Integer, IconViewerItem> entry : this.mItems.entrySet()) {
                this.addItemListeners(entry.getValue());
            }
        }
    }

    public void removeListeners() {
        if (this.mItems != null) {
            for (Map.Entry<Integer, IconViewerItem> entry : this.mItems.entrySet()) {
                this.removeItemListeners(entry.getValue());
            }
        }
        this.removeKeyListener(this.mKeyListener);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = this.isPreferredSizeSet() ? super.getPreferredSize() : dimension;
        if (this.mItems != null) {
            for (Map.Entry<Integer, IconViewerItem> entry : this.mItems.entrySet()) {
                IconViewerItem iconViewerItem = entry.getValue();
                if (!iconViewerItem.isVisible()) continue;
                dimension.width = Math.max(dimension.width, (int)iconViewerItem.getBounds().getMaxX() + ITEM_GAP);
                dimension.height = Math.max(dimension.height, (int)iconViewerItem.getBounds().getMaxY() + ITEM_GAP);
            }
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
        } else {
            dimension = dimension2;
        }
        return dimension;
    }

    @Override
    public void updateUI() {
        this.removeListeners();
        super.updateUI();
        this.addListeners();
    }

    public void fireActionEvent(IconViewerItem iconViewerItem) {
        if (iconViewerItem == null || !iconViewerItem.isEnabled()) {
            return;
        }
        for (IconViewerActionListener iconViewerActionListener : this.mActionListeners) {
            iconViewerActionListener.itemChosen(iconViewerItem);
        }
    }

    private void selectEnabledItem() {
        if (this.mSelectedItem != null) {
            this.mSelectedItem.setSelected(false);
        }
        this.mSelectedItem = null;
        for (Map.Entry<Integer, IconViewerItem> entry : this.mItems.entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            this.mSelectedItem = entry.getValue();
            this.mSelectedItem.setSelected(true);
            break;
        }
    }

    private void addItemListeners(IconViewerItem iconViewerItem) {
        iconViewerItem.addMouseListener(this.mMouseAdapter);
        if (this.mDragAdapter != null) {
            iconViewerItem.addMouseListener((MouseListener)((Object)this.mDragAdapter));
            iconViewerItem.addMouseMotionListener((MouseMotionListener)((Object)this.mDragAdapter));
        }
        ToolTipManager.sharedInstance().registerComponent(iconViewerItem);
    }

    private void removeItemListeners(IconViewerItem iconViewerItem) {
        iconViewerItem.removeMouseListener(this.mMouseAdapter);
        if (this.mDragAdapter != null) {
            iconViewerItem.removeMouseListener((MouseListener)((Object)this.mDragAdapter));
            iconViewerItem.removeMouseMotionListener((MouseMotionListener)((Object)this.mDragAdapter));
        }
        ToolTipManager.sharedInstance().unregisterComponent(iconViewerItem);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() instanceof IconViewerItem) {
            Point point = SwingUtilities.convertPoint((IconViewerItem)mouseEvent.getSource(), mouseEvent.getPoint(), this);
            this.doContextMenu((IconViewerItem)mouseEvent.getSource(), point, mouseEvent.getModifiersEx(), true);
        }
    }

    private void handleKeystroke(int n) {
        if (this.mSelectedItem == null) {
            return;
        }
        int n2 = this.mLayoutMgr.getRowCount();
        int n3 = this.mLayoutMgr.getColCount();
        Point point = this.mLayoutMgr.getComponentRowCol(this, this.mSelectedItem);
        if (point == null) {
            return;
        }
        switch (n) {
            case 38: {
                if (point.y == 0) {
                    return;
                }
                if (this.isComponentEnabledAt(point.x, point.y - 1)) {
                    --point.y;
                    break;
                }
                return;
            }
            case 40: {
                if (point.y == n2 - 1) {
                    return;
                }
                if (this.isComponentEnabledAt(point.x, point.y + 1)) {
                    ++point.y;
                    break;
                }
                return;
            }
            case 37: {
                if (point.x == 0) {
                    return;
                }
                if (this.isComponentEnabledAt(point.x - 1, point.y)) {
                    --point.x;
                    break;
                }
                return;
            }
            case 39: {
                if (point.x == n3 - 1) {
                    return;
                }
                if (this.isComponentEnabledAt(point.x + 1, point.y)) {
                    ++point.x;
                    break;
                }
                return;
            }
            case 33: {
                if (point.y != 0) break;
                return;
            }
            case 34: {
                if (point.y != n2 - 1) break;
                return;
            }
        }
        Component component = this.mLayoutMgr.getComponentAt(this, point.x, point.y);
        if (component instanceof IconViewerItem) {
            Container container;
            this.setSelectedItem((IconViewerItem)component);
            if (this.getParent() != null && (container = this.getParent().getParent()) instanceof JScrollPane) {
                ((JScrollPane)container).scrollRectToVisible(component.getBounds());
            }
        }
    }

    private boolean isComponentEnabledAt(int n, int n2) {
        boolean bl = false;
        Component component = this.mLayoutMgr.getComponentAt(this, n, n2);
        if (component instanceof IconViewerItem && component.isEnabled()) {
            bl = true;
        }
        return bl;
    }

    protected boolean isOneBased() {
        return this.mItems.size() > 0 && this.mItems.get(this.mItems.firstKey()).getId() == 1;
    }

    class AccessibleIconViewer
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        AccessibleIconViewer() {
            super(IconViewer.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return IconViewer.this.mItems.size();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (IconViewer.this.isOneBased() ? ++n > IconViewer.this.mItems.size() + 1 : n > IconViewer.this.mItems.size()) {
                return null;
            }
            return new AccessibleIconViewerItemChild(IconViewer.this, n);
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            int n = 0;
            for (Component component : IconViewer.this.getComponents()) {
                if (!(component instanceof IconViewerItem) || !((IconViewerItem)component).isSelected()) continue;
                ++n;
            }
            return n;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            int n2 = this.getAccessibleSelectionCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            if (IconViewer.this.getSelectedItem() != null) {
                if (IconViewer.this.isOneBased()) {
                    return this.getAccessibleChild(IconViewer.this.getSelectedItem().getId() - 1);
                }
                return this.getAccessibleChild(IconViewer.this.getSelectedItem().getId());
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            if (IconViewer.this.isOneBased()) {
                ++n;
            }
            for (Component component : IconViewer.this.getComponents()) {
                if (!(component instanceof IconViewerItem) || ((IconViewerItem)component).getId() != n) continue;
                return ((IconViewerItem)component).isSelected();
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int n) {
            if (IconViewer.this.isOneBased()) {
                ++n;
            }
            for (Component component : IconViewer.this.getComponents()) {
                if (!(component instanceof IconViewerItem) || ((IconViewerItem)component).getId() != n) continue;
                IconViewer.this.setSelectedItem((IconViewerItem)component);
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            IconViewer.this.setSelectedItem(null);
        }

        @Override
        public void clearAccessibleSelection() {
            IconViewer.this.setSelectedItem(null);
        }

        @Override
        public void selectAllAccessibleSelection() {
        }

        protected class AccessibleIconViewerItemChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private IconViewer parent = null;
            private int indexInParent;

            public AccessibleIconViewerItemChild(IconViewer iconViewer, int n) {
                this.parent = iconViewer;
                this.setAccessibleParent(iconViewer);
                this.indexInParent = n;
            }

            private Component getCurrentComponent() {
                return this.getComponentAtIndex(this.indexInParent);
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof IconViewerItem) {
                    return component.getAccessibleContext();
                }
                return null;
            }

            private Component getComponentAtIndex(int n) {
                if (IconViewer.this.isOneBased() ? n < 1 || n >= IconViewer.this.mItems.size() + 1 : n < 0 || n >= IconViewer.this.mItems.size()) {
                    return null;
                }
                if (this.parent != null) {
                    return (Component)IconViewer.this.mItems.get(n);
                }
                return null;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            @Override
            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleName();
                }
                return null;
            }

            @Override
            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return null;
            }

            @Override
            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return null;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                boolean bl;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                boolean bl2 = bl = this.getCurrentComponent() != null && this.getCurrentComponent().equals(this.parent.getSelectedItem());
                if (this.parent.isFocusOwner() && bl) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                if (bl) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                return accessibleStateSet;
            }

            @Override
            public int getAccessibleIndexInParent() {
                if (IconViewer.this.isOneBased()) {
                    return this.indexInParent - 1;
                }
                return this.indexInParent;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext() != null ? this.getCurrentAccessibleContext().getAccessibleAction() : null;
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext() != null ? this.getCurrentAccessibleContext().getAccessibleSelection() : null;
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext() != null ? this.getCurrentAccessibleContext().getAccessibleText() : null;
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext() != null ? this.getCurrentAccessibleContext().getAccessibleValue() : null;
            }

            @Override
            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                return component != null && component.isEnabled();
            }

            @Override
            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                for (Map.Entry entry : IconViewer.this.mItems.entrySet()) {
                    if (!((IconViewerItem)entry.getValue()).isVisible() || !((IconViewerItem)entry.getValue()).equals(this.getCurrentComponent())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void setVisible(boolean bl) {
            }

            @Override
            public boolean isShowing() {
                return this.parent.isShowing() && this.isVisible();
            }

            @Override
            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            @Override
            public Point getLocationOnScreen() {
                return null;
            }

            @Override
            public Point getLocation() {
                return null;
            }

            @Override
            public void setLocation(Point point) {
            }

            @Override
            public Rectangle getBounds() {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof IconViewerItem) {
                    return component.getBounds();
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle rectangle) {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof IconViewerItem) {
                    component.setBounds(rectangle);
                }
            }

            @Override
            public Dimension getSize() {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof IconViewerItem) {
                    return component.getSize();
                }
                return null;
            }

            @Override
            public void setSize(Dimension dimension) {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof IconViewerItem) {
                    component.setSize(dimension);
                }
            }

            @Override
            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                return component != null && component.isFocusable();
            }

            @Override
            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            @Override
            public AccessibleIcon[] getAccessibleIcon() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleIcon();
                }
                return null;
            }
        }
    }

    class ViewerKeyListener
    extends KeyAdapter {
        ViewerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (IconViewer.this.mSelectedItem == null) {
                for (Component component : IconViewer.this.getComponents()) {
                    if (!(component instanceof IconViewerItem) || !component.isEnabled()) continue;
                    IconViewer.this.setSelectedItem((IconViewerItem)IconViewer.this.mItems.get(((IconViewerItem)component).getId()));
                    break;
                }
                return;
            }
            if (keyEvent.getKeyCode() == 525 || keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
                IconViewerItem iconViewerItem = IconViewer.this.getSelectedItem();
                if (iconViewerItem != null) {
                    Rectangle rectangle = iconViewerItem.getBounds();
                    Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                    IconViewer.this.doContextMenu(iconViewerItem, point, keyEvent.getModifiersEx(), false);
                }
                keyEvent.consume();
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    IconViewer.this.handleKeystroke(keyEvent.getKeyCode());
                    break;
                }
                case 36: {
                    IconViewer.this.setSelectedItem((IconViewerItem)IconViewer.this.mItems.get(IconViewer.this.mItems.firstKey()));
                    break;
                }
                case 35: {
                    IconViewer.this.setSelectedItem((IconViewerItem)IconViewer.this.mItems.get(IconViewer.this.mItems.lastKey()));
                    break;
                }
                case 32: {
                    IconViewer.this.fireActionEvent(IconViewer.this.getSelectedItem());
                    break;
                }
            }
        }
    }

    class MouseClickAdapter
    extends MouseAdapter {
        MouseClickAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            IconViewer.this.showPopup(mouseEvent);
            IconViewer.this.requestFocusInWindow();
            if (mouseEvent.getSource() instanceof IconViewerItem) {
                IconViewer.this.setSelectedItem((IconViewerItem)mouseEvent.getSource());
            }
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1) {
                IconViewer.this.fireActionEvent(IconViewer.this.getSelectedItem());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            IconViewer.this.showPopup(mouseEvent);
        }
    }
}

