/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.icon_view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JScrollPane;

public class ConstrainedFlowLayout
extends FlowLayout {
    private int mMaxColumns;
    private int mRowCount;
    private int mColCount;
    private Vector<Point> mPositions = new Vector();

    public ConstrainedFlowLayout(int n, int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.mMaxColumns = n;
        this.mRowCount = 0;
        this.mColCount = 0;
    }

    public Component getComponentAt(Container container, int n, int n2) {
        Component component = null;
        int n3 = 0;
        for (Point point : this.mPositions) {
            if (point == null) continue;
            if (n3 >= container.getComponentCount()) break;
            Component component2 = container.getComponent(n3++);
            if (point.x != n || point.y != n2) continue;
            component = component2;
            break;
        }
        return component;
    }

    public Point getComponentRowCol(Container container, Component component) {
        int n = 0;
        for (Component component2 : container.getComponents()) {
            if (component2 == component) {
                return (Point)this.mPositions.get(n).clone();
            }
            ++n;
        }
        return null;
    }

    public int getRowCount() {
        return this.mRowCount + 1;
    }

    public int getColCount() {
        return this.mColCount + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            Container container2 = container.getParent().getParent() instanceof JScrollPane ? container.getParent().getParent() : container;
            int n = container2.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = insets.top + this.getVgap();
            int n5 = 0;
            int n6 = 0;
            this.mRowCount = 0;
            this.mColCount = 0;
            int n7 = -1;
            this.mPositions.setSize(n2);
            boolean bl = container.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                component.setSize(dimension.width, dimension.height);
                boolean bl2 = false;
                if (n3 > 0 && this.mMaxColumns > 0 && i - n6 >= this.mMaxColumns) {
                    bl2 = true;
                }
                if (!(bl2 || n3 != 0 && n3 + dimension.width + this.getHgap() > n)) {
                    if (n3 > 0) {
                        n3 += this.getHgap();
                    }
                    n3 += dimension.width;
                    n5 = Math.max(n5, dimension.height);
                    this.mPositions.set(i, new Point(++n7, this.mRowCount));
                    this.mColCount = Math.max(this.mColCount, n7);
                    continue;
                }
                this.moveComponents(container, insets.left + this.getHgap(), n4, n - n3, n5, n6, i, bl);
                n3 = dimension.width;
                n4 += this.getVgap() + n5;
                n5 = dimension.height;
                n6 = i;
                n7 = 0;
                ++this.mRowCount;
                this.mPositions.set(i, new Point(n7, this.mRowCount));
            }
            this.moveComponents(container, insets.left + this.getHgap(), n4, n - n3, n5, n6, n2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    n += bl ? 0 : n3;
                    break;
                }
                case 1: {
                    n += n3 / 2;
                    break;
                }
                case 2: {
                    n += bl ? n3 : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    n += n3;
                }
            }
            for (int i = n5; i < n6; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                if (bl) {
                    component.setLocation(n, n2 + (n4 - component.getHeight()) / 2);
                } else {
                    component.setLocation(container.getWidth() - n - component.getWidth(), n2 + (n4 - component.getHeight()) / 2);
                }
                n += component.getWidth() + this.getHgap();
            }
        }
    }
}

