/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.LayeredListWidget;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListFilterUtil;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainTableDragAdapter;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class VarListDropListener
implements IDropListener,
ActionListener {
    private static final int AUTOSCROLL_INSET = 10;
    protected static Cursor sSwapCursor = null;
    protected VariableList mDropTarget = null;
    protected Timer mTimer = null;
    protected Point mLastPosition = null;
    private Rectangle mOuterRect = new Rectangle();
    private Rectangle mInnerRect = new Rectangle();
    private int mHysteresis = 10;
    protected boolean mCanImport = false;
    private IVarMoveHandler mVarMoveHandler;
    private SrcVariableList mSrcVarList;
    private Vector<ISpssVariable> mTargetVarsVector = new Vector();
    protected boolean mSwapFlag = false;
    private BaseDialog mParentDlg = null;

    public VarListDropListener(VariableList variableList) {
        this.mDropTarget = variableList;
    }

    public VarListDropListener(VariableList variableList, IVarMoveHandler iVarMoveHandler) {
        this.mDropTarget = variableList;
        this.mVarMoveHandler = iVarMoveHandler;
    }

    public VariableList getTargetList() {
        return this.mDropTarget;
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        if (!(dragDropAdapter instanceof ListDragAdapter) && !(dragDropAdapter instanceof PlainTableDragAdapter)) {
            return cursor;
        }
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        boolean bl = false;
        if (this.contains(point)) {
            this.mCanImport = this.canDrop(dragDropAdapter);
            if (this.mCanImport && dragDropAdapter instanceof ListDragAdapter) {
                VariableList.TransferData transferData = (VariableList.TransferData)dragDropAdapter.getTransferData();
                ISpssVariable[] iSpssVariableArray = transferData != null ? transferData.getVariables() : null;
                bl = true;
                this.mDropTarget.showDropFeedback(point2);
                if (this.mDropTarget instanceof TargetVariableList) {
                    TargetVariableList targetVariableList = (TargetVariableList)this.mDropTarget;
                    JList jList = ((ListDragAdapter)dragDropAdapter).getSourceList();
                    if (targetVariableList.getTargetType() == TargetVariableList.TargetListType.single_item && this.mDropTarget.getModel().getSize() == 1 && iSpssVariableArray != null && iSpssVariableArray.length == 1 && jList != this.mDropTarget) {
                        Container container = this.mDropTarget.getTopLevelAncestor();
                        if (container instanceof BaseDialog) {
                            if (sSwapCursor == null) {
                                Image image = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SWAP_CURSOR_IMAGE"))).getImage();
                                sSwapCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), ResUtil.getCommonDlgString("IDS_CURSOR_NAME"));
                            }
                            cursor = sSwapCursor;
                        }
                    } else {
                        cursor = Cursor.getPredefinedCursor(12);
                    }
                } else {
                    cursor = Cursor.getPredefinedCursor(12);
                }
            } else if (this.mCanImport) {
                PlainTable.TransferData transferData = (PlainTable.TransferData)dragDropAdapter.getTransferData();
                bl = true;
                this.mDropTarget.showDropFeedback(point2);
                if (this.mDropTarget instanceof TargetVariableList) {
                    TargetVariableList targetVariableList = (TargetVariableList)this.mDropTarget;
                    if (targetVariableList.getTargetType() == TargetVariableList.TargetListType.single_item && this.mDropTarget.getModel().getSize() == 1 && transferData != null && transferData.getSelectedRows().length == 1) {
                        Container container = this.mDropTarget.getTopLevelAncestor();
                        if (container instanceof BaseDialog) {
                            if (sSwapCursor == null) {
                                Image image = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SWAP_CURSOR_IMAGE"))).getImage();
                                sSwapCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), ResUtil.getCommonDlgString("IDS_CURSOR_NAME"));
                            }
                            cursor = sSwapCursor;
                        }
                    } else {
                        cursor = Cursor.getPredefinedCursor(12);
                    }
                } else {
                    cursor = Cursor.getPredefinedCursor(12);
                }
            } else {
                this.mDropTarget.showDropFeedback(null);
                cursor = DragPane.getNoDropCursor();
            }
        } else {
            this.mDropTarget.showDropFeedback(null);
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(bl || this.mDropTarget.hasFocus());
        if (this.mCanImport) {
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        return this.mDropTarget.getVisibleRect().contains(point2);
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        VariableList.TransferData transferData;
        ISpssVariable[] iSpssVariableArray;
        boolean bl = false;
        if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && this.mDropTarget.isDragSupported())) {
            return bl;
        }
        Object object = dragDropAdapter.getTransferData();
        if (object instanceof VariableList.TransferData && (iSpssVariableArray = (transferData = (VariableList.TransferData)object).getVariables()) != null && iSpssVariableArray.length > 0) {
            if (this.mDropTarget instanceof TargetVariableList) {
                if (iSpssVariableArray.length > 1 && ((TargetVariableList)this.mDropTarget).getTargetType() == TargetVariableList.TargetListType.single_item) {
                    return false;
                }
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (this.mDropTarget.canIncludeVariable(iSpssVariable)) continue;
                    return false;
                }
            }
            bl = true;
        }
        return bl;
    }

    private void populateListVars(TargetVariableList targetVariableList) {
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            this.mTargetVarsVector.add(targetVariableList.getModel().getElementAt(i));
        }
    }

    private void recursiveGetSrcList(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof SrcVariableList) {
                this.mSrcVarList = (SrcVariableList)component;
                continue;
            }
            if (component instanceof TargetVariableList) {
                this.populateListVars((TargetVariableList)component);
                continue;
            }
            if (component instanceof LayeredListWidget) {
                ArrayList<VarListModel> arrayList = ((LayeredListWidget)component).getVarListModels();
                for (VarListModel varListModel : arrayList) {
                    for (int i = 0; i < varListModel.getSize(); ++i) {
                        this.mTargetVarsVector.add(varListModel.getElementAt(i));
                    }
                }
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.recursiveGetSrcList((Container)component);
        }
    }

    public void itemDropped(DropEvent dropEvent) {
        boolean bl;
        Component component = dropEvent.getSource();
        Container container = this.mDropTarget.getTopLevelAncestor();
        if (container instanceof BaseDialog) {
            this.mParentDlg = (BaseDialog)container;
            this.mTargetVarsVector = new Vector();
            this.recursiveGetSrcList(container);
        }
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(this.mDropTarget.hasFocus());
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        if (bl && this.mDropTarget != null && component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            Object object = dropEvent.getTransferData();
            if (object == null) {
                return;
            }
            if (!(object instanceof VariableList.TransferData)) {
                assert (false);
                return;
            }
            VariableList.TransferData transferData = (VariableList.TransferData)object;
            ISpssVariable[] iSpssVariableArray = transferData.getVariables();
            if (this.mVarMoveHandler != null && !this.mVarMoveHandler.preMoveVariables(iSpssVariableArray, this.mDropTarget)) {
                return;
            }
            int[] nArray = transferData.getSelectedIndices();
            VarListModel varListModel = this.mDropTarget.getModel();
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            int n = this.mDropTarget.locationToIndex(point);
            if (this.dropOnSource(variableList, n, nArray, point)) {
                return;
            }
            int n2 = varListModel.getSize();
            if (n < 0) {
                n = n2;
            } else {
                if (!this.mDropTarget.itemInUpperHalf(point)) {
                    ++n;
                }
                if (n > n2) {
                    n = n2;
                }
            }
            if (!this.showFilterError(this.mDropTarget, iSpssVariableArray, (Window)this.mParentDlg)) {
                return;
            }
            if (this.mDropTarget instanceof TargetVariableList && !((TargetVariableList)this.mDropTarget).isDataSource()) {
                if (component instanceof TargetVariableList) {
                    if (this.mDropTarget.getDragType() == VariableList.VarMoveType.eMoveOriginal && ((TargetVariableList)component).getDragType() == VariableList.VarMoveType.eKeepOriginal) {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
                        final VariableList variableList2 = variableList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                variableList2.requestFocus();
                            }
                        });
                        return;
                    }
                    if (iSpssVariableArray.length == 1 && ((TargetVariableList)this.mDropTarget).getTargetType() == TargetVariableList.TargetListType.single_item) {
                        if (this.mDropTarget.getDragType() == VariableList.VarMoveType.eKeepOriginal && ((TargetVariableList)component).getDragType() == VariableList.VarMoveType.eMoveOriginal && this.mDropTarget.getModel().getSize() > 0) {
                            String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_CANNOT_SWAP_VAR_FROM_MOVE_COPY_LIST"), this.mDropTarget.getModel().getElementAt(0).getName());
                            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, string, VersionInfo.getAppVersionString());
                            final VariableList variableList3 = variableList;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    variableList3.requestFocus();
                                }
                            });
                            return;
                        }
                        for (IVarFilter iVarFilter : ((TargetVariableList)component).mVarFilters) {
                            if (this.mDropTarget.getModel().getSize() <= 0 || iVarFilter == null || iVarFilter.canIncludeVariable(this.mDropTarget.getModel().getElementAt(0))) continue;
                            String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_CANNOT_SWAP_VAR_WRONG_TYPE_MEASUREMENT"), this.mDropTarget.getModel().getElementAt(0).getName());
                            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, string, VersionInfo.getAppVersionString());
                            final VariableList variableList4 = variableList;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    variableList4.requestFocus();
                                }
                            });
                            return;
                        }
                    }
                } else if (component instanceof SrcVariableList && this.mDropTarget.getDragType() != VariableList.VarMoveType.eKeepOriginal) {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (!this.mTargetVarsVector.contains(iSpssVariable)) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
                        final VariableList variableList5 = variableList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                variableList5.requestFocus();
                            }
                        });
                        return;
                    }
                }
                if (this.mDropTarget.mMaxLimitOfList != -1 && iSpssVariableArray.length + this.mDropTarget.getModel().getSize() > this.mDropTarget.mMaxLimitOfList) {
                    String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), this.mDropTarget.mMaxLimitOfList);
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, string, VersionInfo.getAppVersionString());
                    final VariableList variableList6 = variableList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            variableList6.requestFocus();
                        }
                    });
                    return;
                }
            }
            this.importData(iSpssVariableArray, variableList, n);
            if (!this.mSwapFlag) {
                this.finish(variableList, iSpssVariableArray.length, nArray, n);
            }
            this.mSwapFlag = false;
        }
    }

    private boolean showFilterError(VariableList variableList, ISpssVariable[] iSpssVariableArray, Window window) {
        String string = VarListFilterUtil.getVarListFilterErrorMessage(variableList, iSpssVariableArray);
        if (string != null) {
            SpssAlertOptionPane.showInformationMessageDialog(window, string, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.mDropTarget);
        Rectangle rectangle = (Rectangle)this.mInnerRect.clone();
        rectangle.grow(-this.mHysteresis, -this.mHysteresis);
        if (this.mLastPosition != null && this.pointWithin(this.mLastPosition, this.mOuterRect) && !this.pointWithin(this.mLastPosition, rectangle)) {
            this.autoscroll(this.mDropTarget, this.mLastPosition);
        }
    }

    private boolean pointWithin(Point point, Rectangle rectangle) {
        return point.x > rectangle.x && point.y > rectangle.y && point.x < rectangle.width && point.y < rectangle.height;
    }

    private boolean dropOnSource(VariableList variableList, int n, int[] nArray, Point point) {
        boolean bl;
        boolean bl2 = bl = variableList == this.mDropTarget && nArray != null;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = n >= nArray[0] && n <= nArray[nArray.length - 1];
            if (!bl3) {
                boolean bl5 = this.mDropTarget.itemInUpperHalf(point);
                if (n == nArray[0] - 1) {
                    bl3 = !bl5;
                } else if (n == nArray[nArray.length - 1] + 1) {
                    bl3 = bl5;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }

    protected void importData(ISpssVariable[] iSpssVariableArray, VariableList variableList, int n) {
        int n2;
        int n22;
        block17: {
            ISpssVariable iSpssVariable3;
            int n3;
            block18: {
                int n32;
                block21: {
                    block19: {
                        block20: {
                            block16: {
                                n22 = n;
                                n32 = n;
                                if (this.mDropTarget != variableList) break block16;
                                if (this.mDropTarget instanceof SrcVariableList || ((TargetVariableList)this.mDropTarget).isDataSource()) {
                                    return;
                                }
                                ISpssVariable[] object = iSpssVariableArray;
                                n2 = object.length;
                                for (n3 = 0; n3 < n2; ++n3) {
                                    iSpssVariable3 = object[n3];
                                    this.mDropTarget.getModel().insertElementAt(iSpssVariable3, n++);
                                }
                                break block17;
                            }
                            if (!(this.mDropTarget instanceof TargetVariableList) || ((TargetVariableList)this.mDropTarget).isDataSource()) break block18;
                            if (((TargetVariableList)this.mDropTarget).getTargetType() != TargetVariableList.TargetListType.single_item) break block19;
                            if (this.mDropTarget.getModel().getSize() != 1) break block20;
                            ISpssVariable iSpssVariable2 = this.mDropTarget.getModel().getElementAt(0);
                            this.mDropTarget.getModel().removeElementAt(0);
                            if (variableList instanceof SrcVariableList) {
                                if (this.mDropTarget.getDragType() != VariableList.VarMoveType.eKeepOriginal) {
                                    variableList.getModel().insertElementAt(iSpssVariable2, n);
                                }
                            } else {
                                variableList.getModel().removeElement(iSpssVariableArray[0]);
                                if (variableList.getModel().findElementIndex(iSpssVariable2) == -1) {
                                    variableList.getModel().addElement(iSpssVariable2);
                                }
                            }
                            if (this.mDropTarget.getDragType() != VariableList.VarMoveType.eKeepOriginal) {
                                variableList.getModel().removeElement(iSpssVariableArray[0]);
                            }
                            this.mSwapFlag = true;
                            break block21;
                        }
                        if (this.mDropTarget.getDragType() != VariableList.VarMoveType.eKeepOriginal || this.mSrcVarList == null || this.mSrcVarList.getModel().findElementIndex(iSpssVariableArray[0]) != -1) break block21;
                        this.mSrcVarList.getModel().insertElementAt(iSpssVariableArray[0], n);
                        break block21;
                    }
                    if (variableList.getDragType() == VariableList.VarMoveType.eMoveOriginal && this.mDropTarget.getDragType() == VariableList.VarMoveType.eKeepOriginal && this.mSrcVarList != null) {
                        for (ISpssVariable iSpssVariable3 : iSpssVariableArray) {
                            if (this.mSrcVarList.getModel().findElementIndex(iSpssVariable3) != -1) continue;
                            this.mSrcVarList.getModel().insertElementAt(iSpssVariable3, n++);
                        }
                    }
                }
                ISpssVariable[] iSpssVariableArray2 = iSpssVariableArray;
                n2 = iSpssVariableArray2.length;
                for (n3 = 0; n3 < n2; ++n3) {
                    iSpssVariable3 = iSpssVariableArray2[n3];
                    if (!((TargetVariableList)this.mDropTarget).isAllowDuplicates() && this.mDropTarget.getModel().findElementIndex(iSpssVariable3) != -1) continue;
                    if (((TargetVariableList)this.mDropTarget).getTargetType() == TargetVariableList.TargetListType.single_item) {
                        this.mDropTarget.getModel().addElement(iSpssVariable3);
                        continue;
                    }
                    this.mDropTarget.getModel().insertElementAt(iSpssVariable3, n32++);
                }
                final VariableList variableList2 = variableList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        variableList2.clearSelection();
                    }
                });
                break block17;
            }
            if (variableList.getDragType() != VariableList.VarMoveType.eKeepOriginal) {
                ISpssVariable[] iSpssVariableArray3 = iSpssVariableArray;
                n2 = iSpssVariableArray3.length;
                for (n3 = 0; n3 < n2; ++n3) {
                    iSpssVariable3 = iSpssVariableArray3[n3];
                    this.mDropTarget.getModel().insertElementAt(iSpssVariable3, n++);
                }
            }
        }
        if (this.mDropTarget instanceof TargetVariableList && ((TargetVariableList)this.mDropTarget).isAllowDuplicates()) {
            int[] nArray = new int[iSpssVariableArray.length];
            for (n2 = 0; n2 < iSpssVariableArray.length; ++n2) {
                nArray[n2] = n22 + n2;
            }
            this.mDropTarget.setSelectedIndices(nArray);
        } else {
            this.mDropTarget.setSelection(iSpssVariableArray);
        }
        final VariableList variableList3 = this.mDropTarget;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                variableList3.requestFocus();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAutoScroll(Point point) {
        if (this.mDropTarget instanceof SrcVariableList || !this.mDropTarget.getAutoscrolls()) {
            return;
        }
        if (this.mLastPosition == null) {
            if (this.mDropTarget.contains(point)) {
                this.mLastPosition = point.getLocation();
                this.updateAutoscrollRegion(this.mDropTarget);
                this.initPropertiesIfNecessary();
            }
        } else {
            VarListDropListener varListDropListener = this;
            synchronized (varListDropListener) {
                if (Math.abs(point.x - this.mLastPosition.x) > this.mHysteresis || Math.abs(point.y - this.mLastPosition.y) > this.mHysteresis) {
                    if (this.mTimer.isRunning()) {
                        this.mTimer.stop();
                    }
                    this.mLastPosition = null;
                } else {
                    if (!this.mTimer.isRunning()) {
                        this.mTimer.start();
                    }
                    this.mLastPosition = point;
                }
            }
        }
    }

    void updateAutoscrollRegion(JComponent jComponent) {
        int n;
        Rectangle rectangle = jComponent.getVisibleRect();
        this.mInnerRect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            n = 20;
            if (rectangle.width >= n) {
                insets.right = 10;
                insets.left = 10;
            }
            if (rectangle.height >= n) {
                insets.bottom = 10;
                insets.top = 10;
            }
        }
        n = rectangle.x;
        int n2 = rectangle.y;
        this.mOuterRect.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, n + rectangle.width + insets.right, n2 + rectangle.height + insets.bottom);
    }

    void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            int n;
            Rectangle rectangle;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.mInnerRect.y + this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle2);
                this.mLastPosition.y -= n;
            } else if (point.y > this.mInnerRect.y + this.mInnerRect.height - this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle3);
                this.mLastPosition.y += n;
            }
            if (point.x < this.mInnerRect.x) {
                int n2 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, -1);
                Rectangle rectangle4 = new Rectangle(this.mInnerRect.x - n2, this.mInnerRect.y, n2, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle4);
                this.mLastPosition.x -= n2;
            } else if (point.x > this.mInnerRect.x + this.mInnerRect.width) {
                int n3 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, 1);
                Rectangle rectangle5 = new Rectangle(this.mInnerRect.x + this.mInnerRect.width, this.mInnerRect.y, n3, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle5);
                this.mLastPosition.x += n3;
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.mTimer == null) {
            Integer n = 100;
            Integer n2 = 100;
            this.mTimer = new Timer(n2, this);
            this.mTimer.setCoalesce(true);
            this.mTimer.setInitialDelay(n);
        }
    }

    protected void finish(VariableList variableList, int n, int[] nArray, int n2) {
        try {
            int n3;
            VarListModel varListModel = variableList.getModel();
            if (n > 0 && this.mDropTarget == variableList) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] <= n2) continue;
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + n;
                }
            }
            if (this.mDropTarget == variableList) {
                if (this.mDropTarget instanceof SrcVariableList || ((TargetVariableList)this.mDropTarget).isDataSource()) {
                    return;
                }
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    varListModel.removeElementAt(nArray[n3]);
                }
            } else if (variableList instanceof TargetVariableList && !((TargetVariableList)variableList).isDataSource()) {
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    varListModel.removeElementAt(nArray[n3]);
                }
            } else if (this.mDropTarget.getDragType() != VariableList.VarMoveType.eKeepOriginal) {
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    varListModel.removeElementAt(nArray[n3]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

