/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.ctables.SummaryStatTree;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeDragAdapter
extends ComponentDragAdapter {
    private SummaryStatTree mSourceTree;

    public TreeDragAdapter(SummaryStatTree summaryStatTree, DragPane dragPane, String string) {
        super(dragPane, string);
        this.mSourceTree = summaryStatTree;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mDndArmedEvent = null;
        if (mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        this.mDndArmedEvent = mouseEvent;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mTransferData == null) {
            this.mDndArmedEvent = null;
            return;
        }
        super.mouseReleased(mouseEvent);
    }

    public Object getTransferData() {
        if (this.mTransferData == null) {
            this.acquireTransferData();
        }
        return this.mTransferData;
    }

    protected void startDrag(MouseEvent mouseEvent) {
        BufferedImage bufferedImage;
        if (mouseEvent == null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (!(component instanceof JTree)) {
            assert (false);
            return;
        }
        JTree jTree = (JTree)component;
        assert (this.mSourceTree == jTree);
        int n = this.mSourceTree.getRowForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (!this.mSourceTree.isRowSelected(n)) {
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                if (mouseEvent.isMetaDown() || mouseEvent.isShiftDown()) {
                    this.mSourceTree.addSelectionInterval(n, n);
                } else {
                    this.mSourceTree.setSelectionRow(n);
                }
            } else if (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
                this.mSourceTree.addSelectionInterval(n, n);
            } else {
                this.mSourceTree.setSelectionRow(n);
            }
        }
        if (this.mTransferData == null) {
            this.acquireTransferData();
        }
        if ((bufferedImage = this.getDragImage(this.mSourceTree)) == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointToScreen(point2, this.mSourceTree);
        SwingUtilities.convertPointFromScreen(point2, (Component)this.mDragPane);
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(ComponentState.getSPSSLocale());
        Point point3 = componentOrientation == ComponentOrientation.RIGHT_TO_LEFT ? new Point(this.mSourceTree.getWidth(), 0) : new Point(0, 0);
        this.mDragPane.setDragImage(bufferedImage, true);
        this.mDragPane.setDragPoint(point2);
        this.mDragPane.setImageHotSpot(point3);
        this.mDragPane.setVisible(true);
        this.mDragPane.repaint();
    }

    protected void acquireTransferData() {
        if (this.mSourceTree != null) {
            try {
                this.mTransferData = this.mSourceTree.getTransferData().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
    }

    protected BufferedImage getDragImage(Component component) {
        BufferedImage bufferedImage = null;
        if (component instanceof JTree) {
            JTree jTree = (JTree)component;
            int[] nArray = jTree.getSelectionRows();
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = null;
            for (int n : nArray) {
                rectangle2 = jTree.getRowBounds(n);
                rectangle = rectangle.union(rectangle2);
            }
            Object object = new Dimension(rectangle.width, rectangle.height);
            bufferedImage = new BufferedImage((int)((Dimension)object).getWidth(), (int)((Dimension)object).getHeight(), 3);
            TreePath[] treePathArray = jTree.getSelectionPaths();
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setClip(0, 0, ((Dimension)object).width, ((Dimension)object).height);
            TreePath[] treePathArray2 = treePathArray;
            int n = treePathArray2.length;
            int n2 = 0;
            if (n2 < n) {
                TreePath treePath = treePathArray2[n2];
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Rectangle rectangle3 = jTree.getPathBounds(treePath);
                JComponent jComponent = (JComponent)jTree.getCellRenderer().getTreeCellRendererComponent(jTree, defaultMutableTreeNode, false, jTree.isExpanded(treePath), ((DefaultTreeModel)jTree.getModel()).isLeaf(treePath.getLastPathComponent()), 0, false);
                jComponent.setBounds(rectangle3);
                jComponent.setLocation(new Point(0, 0));
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                jComponent.setOpaque(false);
                jComponent.paint(graphics2D);
            }
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

