/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.ModelTermsList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.TermsListDragAdapter;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class TermsListDropListener
implements IDropListener,
ActionListener {
    private static final int AUTOSCROLL_INSET = 10;
    private Rectangle mOuterRect = new Rectangle();
    private Timer mTimer = null;
    private Point mLastPosition = null;
    private ModelTermsList mDropTarget;
    private ComponentsArrowButton mArrowButton;
    private boolean mCanImport = false;
    private int mHysteresis = 10;
    private Rectangle mInnerRect = new Rectangle();

    public TermsListDropListener(ModelTermsList modelTermsList, ComponentsArrowButton componentsArrowButton) {
        this.mDropTarget = modelTermsList;
        this.mArrowButton = componentsArrowButton;
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        return true;
    }

    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        return this.mDropTarget.getVisibleRect().contains(point2);
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        boolean bl = false;
        if (this.contains(point)) {
            this.mCanImport = this.canDrop(dragDropAdapter);
            if (this.mCanImport) {
                bl = true;
                this.mDropTarget.showDropFeedback(point2);
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                this.mDropTarget.showDropFeedback(null);
                cursor = DragPane.getNoDropCursor();
            }
        } else if (!(dragDropAdapter instanceof TermsListDragAdapter)) {
            this.mDropTarget.showDropFeedback(null);
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(bl);
        if (this.mCanImport) {
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    public void itemDropped(DropEvent dropEvent) {
        boolean bl;
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(false);
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        if (bl && this.mDropTarget != null && component instanceof JList) {
            Object object = dropEvent.getTransferData();
            if (object == null) {
                return;
            }
            if (component instanceof ModelTermsList) {
                this.importData((ModelTermsList)component, (ModelTermsList.TermsTransferData)object, dropEvent);
            } else if (component instanceof VariableList) {
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                this.mArrowButton.doClick();
            }
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.mDropTarget);
        Rectangle rectangle = (Rectangle)this.mInnerRect.clone();
        rectangle.grow(-this.mHysteresis, -this.mHysteresis);
        if (this.mLastPosition != null && this.pointWithin(this.mLastPosition, this.mOuterRect) && !this.pointWithin(this.mLastPosition, rectangle)) {
            this.autoscroll(this.mDropTarget, this.mLastPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAutoScroll(Point point) {
        if (!this.mDropTarget.getAutoscrolls()) {
            return;
        }
        if (this.mLastPosition == null) {
            if (this.mDropTarget.contains(point)) {
                this.mLastPosition = point.getLocation();
                this.updateAutoscrollRegion(this.mDropTarget);
                this.initPropertiesIfNecessary();
            }
        } else {
            TermsListDropListener termsListDropListener = this;
            synchronized (termsListDropListener) {
                if (Math.abs(point.x - this.mLastPosition.x) > this.mHysteresis || Math.abs(point.y - this.mLastPosition.y) > this.mHysteresis) {
                    if (this.mTimer.isRunning()) {
                        this.mTimer.stop();
                    }
                    this.mLastPosition = null;
                } else {
                    if (!this.mTimer.isRunning()) {
                        this.mTimer.start();
                    }
                    this.mLastPosition = point;
                }
            }
        }
    }

    private void updateAutoscrollRegion(JComponent jComponent) {
        int n;
        Rectangle rectangle = jComponent.getVisibleRect();
        this.mInnerRect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            n = 20;
            if (rectangle.width >= n) {
                insets.right = 10;
                insets.left = 10;
            }
            if (rectangle.height >= n) {
                insets.bottom = 10;
                insets.top = 10;
            }
        }
        n = rectangle.x;
        int n2 = rectangle.y;
        this.mOuterRect.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, n + rectangle.width + insets.right, n2 + rectangle.height + insets.bottom);
    }

    private void initPropertiesIfNecessary() {
        if (this.mTimer == null) {
            Integer n = 100;
            Integer n2 = 100;
            this.mTimer = new Timer(n2, this);
            this.mTimer.setCoalesce(true);
            this.mTimer.setInitialDelay(n);
        }
    }

    private void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            int n;
            Rectangle rectangle;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.mInnerRect.y + this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle2);
                this.mLastPosition.y -= n;
            } else if (point.y > this.mInnerRect.y + this.mInnerRect.height - this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle3);
                this.mLastPosition.y += n;
            }
            if (point.x < this.mInnerRect.x) {
                int n2 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, -1);
                Rectangle rectangle4 = new Rectangle(this.mInnerRect.x - n2, this.mInnerRect.y, n2, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle4);
                this.mLastPosition.x -= n2;
            } else if (point.x > this.mInnerRect.x + this.mInnerRect.width) {
                int n3 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, 1);
                Rectangle rectangle5 = new Rectangle(this.mInnerRect.x + this.mInnerRect.width, this.mInnerRect.y, n3, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle5);
                this.mLastPosition.x += n3;
            }
        }
    }

    private boolean pointWithin(Point point, Rectangle rectangle) {
        return point.x > rectangle.x && point.y > rectangle.y && point.x < rectangle.width && point.y < rectangle.height;
    }

    private void importData(ModelTermsList modelTermsList, ModelTermsList.TermsTransferData termsTransferData, DropEvent dropEvent) {
        boolean bl;
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(false);
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        if (bl && this.mDropTarget != null && component instanceof ModelTermsList) {
            ModelTermsList modelTermsList2 = (ModelTermsList)component;
            Object object = dropEvent.getTransferData();
            if (object == null) {
                return;
            }
            if (!(object instanceof ModelTermsList.TermsTransferData)) {
                assert (false);
                return;
            }
            int[] nArray = termsTransferData.getSelectedIndices();
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            int n = this.mDropTarget.locationToIndex(point);
            if (this.dropOnSource(modelTermsList2, n, nArray, point)) {
                return;
            }
            int n2 = modelTermsList.getModel().getSize();
            if (n < 0) {
                n = n2;
            } else {
                if (!this.mDropTarget.itemInUpperHalf(point)) {
                    ++n;
                }
                if (n > n2) {
                    n = n2;
                }
            }
            String[] stringArray = termsTransferData.getVariables();
            int n3 = stringArray.length;
            this.importData(stringArray, (DefaultListModel)this.mDropTarget.getModel(), n);
            this.finish(modelTermsList2, n3, nArray, n);
            this.mDropTarget.setSelection(stringArray);
            final ModelTermsList modelTermsList3 = this.mDropTarget;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    modelTermsList3.requestFocus();
                }
            });
        }
    }

    private boolean dropOnSource(ModelTermsList modelTermsList, int n, int[] nArray, Point point) {
        boolean bl;
        boolean bl2 = bl = modelTermsList == this.mDropTarget && nArray != null;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = n >= nArray[0] && n <= nArray[nArray.length - 1];
            if (!bl3) {
                boolean bl5 = this.mDropTarget.itemInUpperHalf(point);
                if (n == nArray[0] - 1) {
                    bl3 = !bl5;
                } else if (n == nArray[nArray.length - 1] + 1) {
                    bl3 = bl5;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }

    private void importData(String[] stringArray, DefaultListModel defaultListModel, int n) {
        for (String string : stringArray) {
            defaultListModel.insertElementAt(string, n++);
        }
    }

    private void finish(ModelTermsList modelTermsList, int n, int[] nArray, int n2) {
        if (this.mDropTarget != modelTermsList) {
            return;
        }
        try {
            int n3;
            DefaultListModel defaultListModel = (DefaultListModel)modelTermsList.getModel();
            if (n > 0 && this.mDropTarget == modelTermsList) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] <= n2) continue;
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + n;
                }
            }
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                defaultListModel.removeElementAt(nArray[n3]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

