/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.uitools.util.EventUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;

public class TableMouseHandler
implements MouseInputListener {
    private JTable mTable;
    private Component dispatchComponent;
    private int pressedRow;
    private int pressedCol;
    private boolean mDragPressDidSelection;

    public TableMouseHandler(JTable jTable) {
        this.mTable = jTable;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void setDispatchComponent(MouseEvent mouseEvent) {
        Component component = this.mTable.getEditorComponent();
        Point point = mouseEvent.getPoint();
        Point point2 = SwingUtilities.convertPoint(this.mTable, point, component);
        this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        EventUtil.setSkipClickCount((Component)this.dispatchComponent, (int)(mouseEvent.getClickCount() - 1));
    }

    private boolean repostEvent(MouseEvent mouseEvent) {
        if (this.dispatchComponent == null || !this.mTable.isEditing()) {
            return false;
        }
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.mTable, mouseEvent, this.dispatchComponent);
        this.dispatchComponent.dispatchEvent(mouseEvent2);
        return true;
    }

    private void setValueIsAdjusting(boolean bl) {
        this.mTable.getSelectionModel().setValueIsAdjusting(bl);
        this.mTable.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (EventUtil.shouldIgnore((MouseEvent)mouseEvent, (JComponent)this.mTable)) {
            this.mDragPressDidSelection = false;
            return;
        }
        this.mDragPressDidSelection = true;
        if (this.mTable.isEditing() && !this.mTable.getCellEditor().stopCellEditing()) {
            Component component = this.mTable.getEditorComponent();
            if (component != null && !component.hasFocus()) {
                EventUtil.compositeRequestFocus((Component)component);
            }
            return;
        }
        Point point = mouseEvent.getPoint();
        this.pressedRow = this.mTable.rowAtPoint(point);
        this.pressedCol = this.mTable.columnAtPoint(point);
        EventUtil.adjustFocus((JComponent)this.mTable);
        this.setValueIsAdjusting(true);
        this.adjustSelection(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mTable.isEditing()) {
            EventUtil.adjustFocus((JComponent)this.mTable);
        }
        if (!this.mDragPressDidSelection) {
            Point point = mouseEvent.getPoint();
            this.pressedRow = this.mTable.rowAtPoint(point);
            this.pressedCol = this.mTable.columnAtPoint(point);
            this.adjustSelection(mouseEvent);
        }
        this.repostEvent(mouseEvent);
        this.dispatchComponent = null;
        this.setValueIsAdjusting(false);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (EventUtil.shouldIgnore((MouseEvent)mouseEvent, (JComponent)this.mTable)) {
            return;
        }
        this.repostEvent(mouseEvent);
        if (this.mTable.isEditing()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n = this.mTable.rowAtPoint(point);
        int n2 = this.mTable.columnAtPoint(point);
        if (n2 == -1 || n == -1) {
            return;
        }
        this.mTable.changeSelection(n, n2, mouseEvent.isControlDown(), true);
    }

    private void adjustSelection(MouseEvent mouseEvent) {
        if (this.pressedCol == -1 || this.pressedRow == -1) {
            return;
        }
        boolean bl = this.mTable.getDragEnabled();
        if (!bl && this.mTable.editCellAt(this.pressedRow, this.pressedCol, mouseEvent)) {
            this.setDispatchComponent(mouseEvent);
            this.repostEvent(mouseEvent);
        }
        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
        if (bl || tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
            this.mTable.changeSelection(this.pressedRow, this.pressedCol, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
        }
    }
}

