/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PlainListDropListener
implements IDropListener,
ActionListener {
    private static final int AUTOSCROLL_INSET = 10;
    private JList mDropTarget = null;
    private Timer mTimer = null;
    private Point mLastPosition = null;
    private Rectangle mOuterRect = new Rectangle();
    private Rectangle mInnerRect = new Rectangle();
    private int mHysteresis = 10;
    protected static Cursor sSwapCursor = null;
    private IPlainListVarMoveHandler mPlainListVarMoveHandler;
    private BaseDialog mParentDlg = null;
    private Vector<Object> mTargetVarsVector = new Vector();

    public PlainListDropListener(JList jList, IPlainListVarMoveHandler iPlainListVarMoveHandler) {
        this.mDropTarget = jList;
        this.mPlainListVarMoveHandler = iPlainListVarMoveHandler;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.mDropTarget);
        Rectangle rectangle = (Rectangle)this.mInnerRect.clone();
        rectangle.grow(-this.mHysteresis, -this.mHysteresis);
        if (this.mLastPosition != null && this.pointWithin(this.mLastPosition, this.mOuterRect) && !this.pointWithin(this.mLastPosition, rectangle)) {
            this.autoscroll(this.mDropTarget, this.mLastPosition);
        }
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        Point point2 = null;
        Object[] objectArray = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.contains(point)) {
            if (this.canDrop(dragDropAdapter)) {
                bl2 = true;
                bl = true;
                point2 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
                if (this.mDropTarget instanceof VariableList) {
                    VariableList variableList = (VariableList)this.mDropTarget;
                    if (dragDropAdapter instanceof PlainListDragAdapter) {
                        PlainList.TransferData transferData = (PlainList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = transferData != null ? transferData.getVariables() : null;
                        JList jList = ((PlainListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mPlainListVarMoveHandler != null) {
                            if (this.mPlainListVarMoveHandler.isDragAllowed(jList, this.mDropTarget, objectArray)) {
                                variableList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                variableList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                variableList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            variableList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            variableList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    } else if (dragDropAdapter instanceof ListDragAdapter) {
                        VariableList.TransferData transferData = (VariableList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = transferData != null ? transferData.getVariables() : null;
                        JList jList = ((ListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mPlainListVarMoveHandler != null) {
                            if (this.mPlainListVarMoveHandler.isDragAllowed(jList, this.mDropTarget, objectArray)) {
                                variableList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                variableList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                variableList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else if (jList != variableList && variableList instanceof TargetVariableList && ((TargetVariableList)variableList).getTargetType() == TargetVariableList.TargetListType.single_item && variableList.getModel().getSize() == 1 && objectArray != null && objectArray.length == 1) {
                            Container container = variableList.getTopLevelAncestor();
                            if (container instanceof BaseDialog) {
                                if (sSwapCursor == null) {
                                    Image image = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SWAP_CURSOR_IMAGE"))).getImage();
                                    sSwapCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), ResUtil.getCommonDlgString("IDS_CURSOR_NAME"));
                                }
                                cursor = sSwapCursor;
                            }
                        } else {
                            variableList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            variableList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    }
                } else if (this.mDropTarget instanceof PlainList) {
                    Object object;
                    Object object2;
                    PlainList plainList = (PlainList)this.mDropTarget;
                    if (dragDropAdapter instanceof ListDragAdapter) {
                        object2 = (VariableList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = object2 != null ? ((VariableList.TransferData)object2).getVariables() : null;
                        object = ((ListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mPlainListVarMoveHandler != null) {
                            if (this.mPlainListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                plainList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                plainList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                plainList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            plainList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            plainList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    } else if (dragDropAdapter instanceof PlainListDragAdapter) {
                        object2 = (PlainList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = object2 != null ? ((PlainList.TransferData)object2).getVariables() : null;
                        object = ((PlainListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mPlainListVarMoveHandler != null) {
                            if (this.mPlainListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                plainList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                plainList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                plainList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            plainList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            plainList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    }
                    if (cursor != DragPane.getNoDropCursor()) {
                        if (cursor == Cursor.getPredefinedCursor(12) && plainList.getListType() == PlainList.ListType.single_item && this.mDropTarget.getModel().getSize() == 1 && objectArray != null && objectArray.length == 1) {
                            object2 = this.mDropTarget.getTopLevelAncestor();
                            if (object2 instanceof BaseDialog) {
                                if (sSwapCursor == null) {
                                    object = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SWAP_CURSOR_IMAGE"))).getImage();
                                    sSwapCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), ResUtil.getCommonDlgString("IDS_CURSOR_NAME"));
                                }
                                cursor = sSwapCursor;
                            }
                        } else {
                            cursor = Cursor.getPredefinedCursor(12);
                        }
                    }
                    plainList.getFocusHighlighter().setHighlightBorder(bl2);
                }
            } else {
                if (this.mDropTarget instanceof VariableList) {
                    VariableList variableList = (VariableList)this.mDropTarget;
                    variableList.showDropFeedback(null);
                } else if (this.mDropTarget instanceof PlainList) {
                    PlainList plainList = (PlainList)this.mDropTarget;
                    plainList.showDropFeedback(null);
                }
                cursor = DragPane.getNoDropCursor();
            }
        }
        if (bl) {
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        return this.mDropTarget.getVisibleRect().contains(point2);
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        boolean bl = false;
        if (!this.mDropTarget.isEnabled() || !this.mDropTarget.isShowing()) {
            return bl;
        }
        if (!(dragDropAdapter instanceof ListDragAdapter) && !(dragDropAdapter instanceof PlainListDragAdapter)) {
            return bl;
        }
        bl = true;
        return bl;
    }

    public void itemDropped(DropEvent dropEvent) {
        if (!this.contains(dropEvent.getDropLocation()) || !this.canDrop(dropEvent.getDragSourceAdapter())) {
            return;
        }
        Component component = dropEvent.getSource();
        Container container = this.mDropTarget.getTopLevelAncestor();
        if (container instanceof BaseDialog) {
            this.mParentDlg = (BaseDialog)container;
            this.mTargetVarsVector = new Vector();
            this.recursiveGetPlainListVars(container);
        }
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        if (component instanceof VariableList) {
            if (this.mDropTarget instanceof VariableList) {
                return;
            }
            if (this.mDropTarget instanceof PlainList) {
                PlainList plainList = (PlainList)this.mDropTarget;
                VariableList variableList = (VariableList)component;
                Object object2 = dropEvent.getTransferData();
                if (object2 == null) {
                    return;
                }
                if (!(object2 instanceof VariableList.TransferData)) {
                    assert (false);
                    return;
                }
                VariableList.TransferData transferData = (VariableList.TransferData)object2;
                Object[] objectArray = transferData.getVariables();
                if (this.mPlainListVarMoveHandler != null && !this.mPlainListVarMoveHandler.isDragAllowed(variableList, this.mDropTarget, objectArray)) {
                    return;
                }
                if (objectArray.length > 1 && plainList.getListType() == PlainList.ListType.single_item) {
                    return;
                }
                if (plainList.getDragType() != PlainList.DragType.eAutoDragMove) {
                    for (Object object : objectArray) {
                        if (!this.mTargetVarsVector.contains(object)) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
                        final VariableList variableList2 = variableList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                variableList2.requestFocus();
                            }
                        });
                        return;
                    }
                }
                if (plainList.getMaxLimitOfList() != -1 && objectArray.length + plainList.getModel().getSize() > plainList.getMaxLimitOfList()) {
                    String objectArray2 = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), plainList.getMaxLimitOfList());
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, objectArray2, VersionInfo.getAppVersionString());
                    final VariableList variableList3 = variableList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            variableList3.requestFocus();
                        }
                    });
                    return;
                }
                if (this.mPlainListVarMoveHandler != null) {
                    if (this.mPlainListVarMoveHandler.preMoveVariables(objectArray, plainList)) {
                        Object[] plainList3 = this.mPlainListVarMoveHandler.getModifiedData(objectArray, variableList, plainList);
                        if (plainList3 != null) {
                            objectArray = plainList3;
                        }
                    } else {
                        final VariableList variableList4 = variableList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                variableList4.requestFocus();
                            }
                        });
                        return;
                    }
                }
                int[] nArray = transferData.getSelectedIndices();
                DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, plainList);
                int n = plainList.locationToIndex(point);
                int n2 = defaultListModel.getSize();
                if (n < 0) {
                    n = n2;
                } else {
                    if (!plainList.itemInUpperHalf(point)) {
                        ++n;
                    }
                    if (n > n2) {
                        n = n2;
                    }
                }
                this.handleVariableListToPlainList(objectArray, variableList, plainList, nArray, n);
            }
        } else if (component instanceof PlainList) {
            PlainList plainList = (PlainList)component;
            if (this.mDropTarget instanceof PlainList) {
                PlainList plainList2 = (PlainList)this.mDropTarget;
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof PlainList.TransferData)) {
                    assert (false);
                    return;
                }
                PlainList.TransferData transferData = (PlainList.TransferData)object;
                Object[] objectArray2 = transferData.getVariables();
                if (this.mPlainListVarMoveHandler != null && !this.mPlainListVarMoveHandler.isDragAllowed(plainList, this.mDropTarget, objectArray2)) {
                    return;
                }
                if (this.mPlainListVarMoveHandler != null) {
                    if (this.mPlainListVarMoveHandler.preMoveVariables(objectArray2, plainList2)) {
                        Object[] objectArray = this.mPlainListVarMoveHandler.getModifiedData(objectArray2, plainList, plainList2);
                        if (objectArray != null) {
                            objectArray2 = objectArray;
                        }
                    } else {
                        final PlainList plainList3 = plainList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                plainList3.requestFocus();
                            }
                        });
                        return;
                    }
                }
                int[] nArray = transferData.getSelectedIndices();
                DefaultListModel defaultListModel = (DefaultListModel)plainList2.getModel();
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, plainList2);
                int n = plainList2.locationToIndex(point);
                int n3 = defaultListModel.getSize();
                if (n < 0) {
                    n = n3;
                } else {
                    if (!plainList2.itemInUpperHalf(point)) {
                        ++n;
                    }
                    if (n > n3) {
                        n = n3;
                    }
                }
                if (plainList2.getListType() == PlainList.ListType.single_item) {
                    n = 0;
                }
                if (plainList2 == plainList) {
                    this.handleWithinSamePlainList(objectArray2, plainList2, n);
                } else {
                    this.handlePlainListToPlainList(objectArray2, plainList, plainList2, n, nArray);
                }
            } else if (this.mDropTarget instanceof VariableList) {
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof PlainList.TransferData)) {
                    assert (false);
                    return;
                }
                PlainList.TransferData transferData = (PlainList.TransferData)object;
                Object[] objectArray = transferData.getVariables();
                if (this.mPlainListVarMoveHandler != null && !this.mPlainListVarMoveHandler.isDragAllowed(plainList, this.mDropTarget, objectArray)) {
                    return;
                }
                this.handlePlainListToVariableList((PlainList)component);
            }
        }
    }

    void updateAutoscrollRegion(JComponent jComponent) {
        int n;
        Rectangle rectangle = jComponent.getVisibleRect();
        this.mInnerRect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            n = 20;
            if (rectangle.width >= n) {
                insets.right = 10;
                insets.left = 10;
            }
            if (rectangle.height >= n) {
                insets.bottom = 10;
                insets.top = 10;
            }
        }
        n = rectangle.x;
        int n2 = rectangle.y;
        this.mOuterRect.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, n + rectangle.width + insets.right, n2 + rectangle.height + insets.bottom);
    }

    void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            int n;
            Rectangle rectangle;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.mInnerRect.y + this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle2);
                this.mLastPosition.y -= n;
            } else if (point.y > this.mInnerRect.y + this.mInnerRect.height - this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle3);
                this.mLastPosition.y += n;
            }
            if (point.x < this.mInnerRect.x) {
                int n2 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, -1);
                Rectangle rectangle4 = new Rectangle(this.mInnerRect.x - n2, this.mInnerRect.y, n2, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle4);
                this.mLastPosition.x -= n2;
            } else if (point.x > this.mInnerRect.x + this.mInnerRect.width) {
                int n3 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, 1);
                Rectangle rectangle5 = new Rectangle(this.mInnerRect.x + this.mInnerRect.width, this.mInnerRect.y, n3, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle5);
                this.mLastPosition.x += n3;
            }
        }
    }

    private void requestFocusOnList(JList jList) {
        if (jList instanceof VariableList) {
            final VariableList variableList = (VariableList)jList;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    variableList.requestFocusInWindow();
                    variableList.repaint();
                }
            });
        } else if (jList instanceof PlainList) {
            final PlainList plainList = (PlainList)jList;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    plainList.requestFocusInWindow();
                    plainList.repaint();
                }
            });
        }
    }

    private void handlePlainListToVariableList(PlainList plainList) {
        Vector<SpssArrowButton> vector = plainList.getRegisteredArrowButtons();
        for (SpssArrowButton spssArrowButton : vector) {
            spssArrowButton.doClick();
        }
    }

    private void handleVariableListToPlainList(Object[] objectArray, VariableList variableList, PlainList plainList, int[] nArray, int n) {
        DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
        for (Object object : objectArray) {
            defaultListModel.insertElementAt(object, n++);
        }
        VarListModel varListModel = variableList.getModel();
        if (((PlainList)this.mDropTarget).getDragType() != PlainList.DragType.eAutoDragCopy) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                varListModel.removeElementAt(nArray[i]);
            }
        }
        if (variableList.getDragType() == VariableList.VarMoveType.eKeepOriginal) {
            variableList.clearSelection();
        }
        plainList.setSelection(objectArray);
        this.requestFocusOnList(plainList);
    }

    private void handlePlainListToPlainList(Object[] objectArray, PlainList plainList, PlainList plainList2, int n, int[] nArray) {
        int n2;
        Object object;
        Serializable serializable;
        boolean bl = false;
        Object e = null;
        if (plainList2.getListType() == PlainList.ListType.single_item && plainList2.getModel().getSize() == 1 && objectArray.length == 1) {
            if (plainList.isDataSource()) {
                if (plainList.getDragType() == PlainList.DragType.eAutoDragCopy) {
                    ((DefaultListModel)plainList2.getModel()).removeAllElements();
                } else {
                    serializable = plainList2.getRegisteredArrowButtons();
                    object = ((Vector)serializable).iterator();
                    while (object.hasNext()) {
                        SpssArrowButton spssArrowButton = (SpssArrowButton)object.next();
                        spssArrowButton.doClick();
                    }
                }
            } else {
                e = plainList2.getModel().getElementAt(0);
                ((DefaultListModel)plainList2.getModel()).removeAllElements();
                bl = true;
            }
        }
        serializable = (DefaultListModel)plainList2.getModel();
        for (Object object2 : objectArray) {
            if (((DefaultListModel)serializable).indexOf(object2) != -1) continue;
            ((DefaultListModel)serializable).insertElementAt(object2, n++);
        }
        object = (DefaultListModel)plainList.getModel();
        if (plainList.isDataSource()) {
            if (plainList.getDragType() != PlainList.DragType.eAutoDragCopy) {
                for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                    ((DefaultListModel)object).removeElementAt(nArray[n2]);
                }
            }
        } else {
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                ((DefaultListModel)object).removeElementAt(nArray[n2]);
            }
        }
        if (bl) {
            ((DefaultListModel)plainList.getModel()).insertElementAt(e, 0);
        }
        if (plainList.getDragType() == PlainList.DragType.eAutoDragCopy) {
            plainList.clearSelection();
        }
        plainList2.setSelection(objectArray);
        this.requestFocusOnList(plainList2);
    }

    private void handleWithinSamePlainList(Object[] objectArray, PlainList plainList, int n) {
        Object var4_4 = null;
        DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
        if (n != 0) {
            var4_4 = defaultListModel.getElementAt(n - 1);
        }
        for (Object object : objectArray) {
            defaultListModel.removeElement(object);
        }
        if (var4_4 != null) {
            n = defaultListModel.indexOf(var4_4) + 1;
        }
        for (Object object : objectArray) {
            defaultListModel.insertElementAt(object, n++);
        }
        plainList.setSelection(objectArray);
        this.requestFocusOnList(plainList);
    }

    private void populateListVars(PlainList plainList) {
        for (int i = 0; i < plainList.getModel().getSize(); ++i) {
            this.mTargetVarsVector.add(plainList.getModel().getElementAt(i));
        }
    }

    private void recursiveGetPlainListVars(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof PlainList && !((PlainList)component).isDataSource()) {
                this.populateListVars((PlainList)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.recursiveGetPlainListVars((Container)component);
        }
    }

    private boolean pointWithin(Point point, Rectangle rectangle) {
        return point.x > rectangle.x && point.y > rectangle.y && point.x < rectangle.width && point.y < rectangle.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAutoScroll(Point point) {
        if (!this.mDropTarget.getAutoscrolls()) {
            return;
        }
        if (this.mLastPosition == null) {
            if (this.mDropTarget.contains(point)) {
                this.mLastPosition = point.getLocation();
                this.updateAutoscrollRegion(this.mDropTarget);
                this.initPropertiesIfNecessary();
            }
        } else {
            PlainListDropListener plainListDropListener = this;
            synchronized (plainListDropListener) {
                if (Math.abs(point.x - this.mLastPosition.x) > this.mHysteresis || Math.abs(point.y - this.mLastPosition.y) > this.mHysteresis) {
                    if (this.mTimer.isRunning()) {
                        this.mTimer.stop();
                    }
                    this.mLastPosition = null;
                } else {
                    if (!this.mTimer.isRunning()) {
                        this.mTimer.start();
                    }
                    this.mLastPosition = point;
                }
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.mTimer == null) {
            Integer n = 100;
            Integer n2 = 100;
            this.mTimer = new Timer(n2, this);
            this.mTimer.setCoalesce(true);
            this.mTimer.setInitialDelay(n);
        }
    }
}

