/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;

public class PlainListDragAdapter
extends ComponentDragAdapter {
    private static final int MAX_DRAG_IMAGE_ITEMS = 10;
    private PlainList mSourceList = null;

    public PlainListDragAdapter(PlainList plainList, DragPane dragPane, String string) {
        super(dragPane, string);
        this.mSourceList = plainList;
    }

    public Object getTransferData() {
        if (this.mTransferData == null) {
            this.acquireTransferData();
        }
        return this.mTransferData;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle;
        this.mDndArmedEvent = null;
        if (mouseEvent.isConsumed() || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (!(component instanceof PlainList)) {
            assert (false);
            return;
        }
        PlainList plainList = (PlainList)component;
        assert (this.mSourceList == plainList);
        if (!plainList.isEnabled() || plainList.getDragType() == PlainList.DragType.eNoAutoDrag) {
            return;
        }
        int n = this.mSourceList.locationToIndex(mouseEvent.getPoint());
        Rectangle rectangle2 = rectangle = n > -1 ? this.mSourceList.getCellBounds(n, n) : new Rectangle(0, 0, 0, 0);
        if (n > -1 && this.mSourceList.getDragType() != PlainList.DragType.eNoAutoDrag && rectangle.contains(mouseEvent.getPoint())) {
            this.mDndArmedEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        if (this.mTransferData == null) {
            this.mDndArmedEvent = null;
            return;
        }
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.mSourceList);
        boolean bl2 = bl = !this.overVarList(point);
        if (bl) {
            this.mSourceList.setLockSelections(true);
        }
        super.mouseReleased(mouseEvent);
        this.mSourceList.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlainListDragAdapter.this.mSourceList.setEnabled(true);
                if (bl) {
                    PlainListDragAdapter.this.mSourceList.setLockSelections(false);
                }
            }
        });
    }

    public JList getSourceList() {
        return this.mSourceList;
    }

    protected void startDrag(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (!(component instanceof PlainList)) {
            assert (false);
            return;
        }
        PlainList plainList = (PlainList)component;
        assert (this.mSourceList == plainList);
        int n = this.mSourceList.locationToIndex(mouseEvent.getPoint());
        if (!this.mSourceList.isSelectedIndex(n)) {
            if (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
                this.mSourceList.addSelectionInterval(n, n);
            } else {
                this.mSourceList.setSelectedIndex(n);
            }
        }
        this.acquireTransferData();
        BufferedImage bufferedImage = this.getDragImage(this.mSourceList);
        if (bufferedImage == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointToScreen(point2, this.mSourceList);
        SwingUtilities.convertPointFromScreen(point2, (Component)this.mDragPane);
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(ComponentState.getSPSSLocale());
        Point point3 = componentOrientation == ComponentOrientation.RIGHT_TO_LEFT ? new Point(this.mSourceList.getWidth(), 0) : new Point(0, 0);
        this.mDragPane.setDragImage(bufferedImage, true);
        this.mDragPane.setDragPoint(point2);
        this.mDragPane.setImageHotSpot(point3);
        this.mDragPane.setVisible(true);
        this.mDragPane.repaint();
    }

    protected BufferedImage getDragImage(Component component) {
        if (!(component instanceof JList)) {
            assert (false);
            return null;
        }
        JList jList = (JList)component;
        int[] nArray = jList.getSelectedIndices();
        if (nArray.length == 0) {
            return null;
        }
        Object[] objectArray = jList.getSelectedValues();
        Dimension dimension = new Dimension(jList.getCellBounds((int)nArray[0], (int)nArray[nArray.length - 1]).width, jList.getFixedCellHeight());
        boolean bl = nArray.length > 10;
        int n = !bl ? nArray.length : 10;
        Dimension dimension2 = new Dimension(dimension.width, dimension.height * n);
        if (bl) {
            dimension2.height += dimension.height;
        }
        jList.getSelectedValue();
        BufferedImage bufferedImage = new BufferedImage(dimension2.width, dimension2.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, dimension2.width, dimension2.height);
        Point point = new Point(0, 0);
        for (int i = 0; i < n; ++i) {
            JLabel jLabel = (JLabel)jList.getCellRenderer().getListCellRendererComponent(jList, objectArray[i], nArray[i], false, false);
            jLabel.setLocation(new Point(0, 0));
            jLabel.setSize(dimension.width, dimension.height);
            graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
            boolean bl2 = jLabel.isOpaque();
            jLabel.setOpaque(false);
            jLabel.paint(graphics2D);
            jLabel.setOpaque(bl2);
            graphics2D.translate(0, dimension.height);
            point.y += dimension.height;
        }
        if (bl) {
            String string = ResUtil.getCommonDlgString("IDS_MORE_ELLIPSIS");
            graphics2D.setFont(jList.getFont());
            graphics2D.drawString(string, 2, 14);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected void acquireTransferData() {
        if (this.mSourceList != null) {
            try {
                this.mTransferData = this.mSourceList.getTransferData().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
    }

    private boolean overVarList(Point point) {
        Container container;
        for (container = this.mSourceList.getParent(); container != null && !(container instanceof JDialog); container = container.getParent()) {
        }
        if (container != null) {
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, container);
            Component component = container.findComponentAt(point2);
            return component instanceof PlainList || component instanceof DragPane;
        }
        return false;
    }
}

