/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.AbstractTableDropListener;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDragAdapter;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class PairedVariablesDropListener
extends AbstractTableDropListener {
    private Component mRegisteredSource;

    public PairedVariablesDropListener(PlainTable plainTable, Component component) {
        super(plainTable, component);
        this.mRegisteredSource = component;
    }

    public PairedVariablesDropListener(PlainTable plainTable, IVarMoveHandler iVarMoveHandler, Component component) {
        super(plainTable, iVarMoveHandler, component);
        this.mRegisteredSource = component;
    }

    @Override
    public Component getRegisteredSource() {
        return this.mRegisteredSource;
    }

    @Override
    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        boolean bl = false;
        if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && ((PlainTable)this.mDropTarget).isDragSupported())) {
            return bl;
        }
        Object object = dragDropAdapter.getTransferData();
        if (object instanceof VariableList.TransferData) {
            VariableList.TransferData transferData = (VariableList.TransferData)object;
            ISpssVariable[] iSpssVariableArray = transferData.getVariables();
            if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
                bl = true;
            }
        } else if (object instanceof PlainTable.TransferData) {
            PlainTable.TransferData transferData = (PlainTable.TransferData)object;
            Vector<Object[]> vector = transferData.getVectorData();
            bl = vector.size() > 1 ? false : super.canDrop(dragDropAdapter);
        }
        return bl;
    }

    @Override
    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mRegisteredSource);
        if (((SrcVariableList)this.mRegisteredSource).getVisibleRect().contains(point2)) {
            this.mCanImport = this.canDrop(dragDropAdapter);
            if (this.mCanImport) {
                this.showDropFeedback(point2);
                return Cursor.getPredefinedCursor(12);
            }
            this.showDropFeedback(null);
            return DragPane.getNoDropCursor();
        }
        if (this.mDropTarget instanceof PlainTable) {
            if (dragDropAdapter.getTransferData() instanceof PlainTable.TransferData) {
                point2 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
                PlainTable plainTable = (PlainTable)this.mDropTarget;
                int n = plainTable.rowAtPoint(point2);
                int n2 = plainTable.columnAtPoint(point2);
                if (n != PairedVariablesDragAdapter.sDraggedRow || n2 == 0 || PairedVariablesDragAdapter.sDraggedCol == 0) {
                    this.showDropFeedback(null);
                    return DragPane.getNoDropCursor();
                }
            } else if (dragDropAdapter.getTransferData() instanceof VariableList.TransferData) {
                point2 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
                PlainTable plainTable = (PlainTable)this.mDropTarget;
                int n = plainTable.columnAtPoint(point2);
                if (n == 0) {
                    this.showDropFeedback(null);
                    return DragPane.getNoDropCursor();
                }
            }
        }
        return super.dragItemOver(point, dragDropAdapter);
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        Object object;
        DefaultTableModel defaultTableModel;
        PlainTable plainTable;
        Object object2;
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.setHighlightBorder(false);
        boolean bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        Component component2 = dropEvent.getSource();
        int n = -1;
        int n2 = -1;
        if (component2 instanceof PlainTable) {
            object2 = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen((Point)object2, component2);
            n = ((PlainTable)component2).columnAtPoint((Point)object2);
            n2 = ((PlainTable)component2).rowAtPoint((Point)object2);
        }
        if (bl && this.mDropTarget != null) {
            if (component instanceof SrcVariableList) {
                object2 = dropEvent.getTransferData();
                if (object2 == null) {
                    return;
                }
                if (!(object2 instanceof VariableList.TransferData)) {
                    assert (false);
                    return;
                }
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
                PlainTable plainTable2 = (PlainTable)this.mDropTarget;
                if (plainTable2.columnAtPoint(point) == 0) {
                    return;
                }
                VariableList.TransferData transferData = (VariableList.TransferData)object2;
                ISpssVariable[] iSpssVariableArray = transferData.getVariables();
                for (int i = 0; i < iSpssVariableArray.length; ++i) {
                    ISpssVariable iSpssVariable = iSpssVariableArray[i];
                    if (iSpssVariable.getType() <= 0) continue;
                    SpssAlertOptionPane.showInformationMessageDialog((JComponent)component, ResUtil.getCommonDlgString("ERR_FILTER_STRING_MSG"), VersionInfo.getAppVersionString());
                    return;
                }
                if (iSpssVariableArray.length > 2) {
                    SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_TOO_SAME_VARS_WARNING"), VersionInfo.getAppVersionString());
                    return;
                }
                Point point2 = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
                int n3 = ((PlainTable)this.mDropTarget).rowAtPoint(point2);
                int n4 = ((PlainTable)this.mDropTarget).columnAtPoint(point2);
                this.importData(iSpssVariableArray, (JComponent)component, n3, n4);
                this.mSwapFlag = false;
                return;
            }
            if (n > 0 && n2 == PairedVariablesDragAdapter.sDraggedRow && PairedVariablesDragAdapter.sDraggedCol != 0) {
                object2 = null;
                if (dropEvent.getDragSourceAdapter() instanceof PairedVariablesDragAdapter) {
                    object2 = (PairedVariablesDragAdapter)dropEvent.getDragSourceAdapter();
                }
                if (object2 != null) {
                    plainTable = (PlainTable)this.mDropTarget;
                    if (plainTable.getSelectedRows().length > 1) {
                        return;
                    }
                    defaultTableModel = (DefaultTableModel)plainTable.getModel();
                    object = defaultTableModel.getValueAt(n2, n);
                    Object object3 = defaultTableModel.getValueAt(PairedVariablesDragAdapter.sDraggedRow, PairedVariablesDragAdapter.sDraggedCol);
                    defaultTableModel.setValueAt(object, PairedVariablesDragAdapter.sDraggedRow, PairedVariablesDragAdapter.sDraggedCol);
                    defaultTableModel.setValueAt(object3, n2, n);
                    plainTable.requestFocus();
                }
            }
        }
        object2 = (Point)dropEvent.getDropLocation().clone();
        SwingUtilities.convertPointFromScreen((Point)object2, this.mRegisteredSource);
        if (((SrcVariableList)this.mRegisteredSource).getVisibleRect().contains((Point)object2) && dropEvent.getTransferData() instanceof PlainTable.TransferData) {
            plainTable = (PlainTable)this.mDropTarget;
            defaultTableModel = (DefaultTableModel)plainTable.getModel();
            object = plainTable.getSelectedRows();
            int n5 = plainTable.getColumnCount();
            for (int i = ((int[])object).length - 1; i >= 0; --i) {
                boolean bl2 = false;
                for (int j = 0; j < n5; ++j) {
                    if (!plainTable.isCellSelected(object[i], j)) continue;
                    ArrayList<Integer> arrayList = this.getBlankRows(defaultTableModel);
                    if (j == 0) {
                        if (arrayList.size() > 0 && object[i] == arrayList.get(0)) {
                            SpssAlertOptionPane.showWarningMessageDialog((JComponent)plainTable.getParent(), ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_EMPTY_ROW_WARNING"), VersionInfo.getAppVersionString());
                            this.mRegisteredSource.requestFocus();
                            return;
                        }
                        defaultTableModel.removeRow(object[i]);
                        this.assignRowNos(defaultTableModel);
                        continue;
                    }
                    bl2 = true;
                    defaultTableModel.setValueAt("", object[i], j);
                }
                if (!bl2 || !defaultTableModel.getValueAt(object[i], 1).equals("") || !defaultTableModel.getValueAt(object[i], 2).equals("")) continue;
                defaultTableModel.removeRow(object[i]);
                this.assignRowNos(defaultTableModel);
            }
            this.mRegisteredSource.requestFocus();
        }
    }

    protected void importData(Object object, JComponent jComponent, int n, int n2) {
        PlainTable plainTable;
        if (object instanceof ISpssVariable[]) {
            plainTable = (PlainTable)this.mDropTarget;
            ISpssVariable[] iSpssVariableArray = (ISpssVariable[])object;
            Object[] objectArray = new Object[iSpssVariableArray.length + 1];
            objectArray[0] = n + 1;
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                objectArray[i + 1] = iSpssVariableArray[i];
            }
            plainTable.setColumnSelectionAllowed(true);
            plainTable.setRowSelectionAllowed(true);
            if (n == -1) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)plainTable.getModel();
                ArrayList<Integer> arrayList = this.getBlankRows(defaultTableModel);
                if (arrayList.size() == 1) {
                    int n3 = arrayList.get(0);
                    for (int i = 1; i < objectArray.length; ++i) {
                        plainTable.setValueAt(objectArray[i], n3, i);
                        plainTable.changeSelection(n3, i, false, false);
                    }
                    if (objectArray.length == 3) {
                        plainTable.getSelectionModel().addSelectionInterval(n3, n3);
                    }
                    this.addBlankRow(defaultTableModel);
                }
            } else if (n < plainTable.getRowCount()) {
                Object object2;
                if (iSpssVariableArray.length == 2) {
                    plainTable.setValueAt(objectArray[1], n, 1);
                    plainTable.setValueAt(objectArray[2], n, 2);
                } else {
                    Object object3 = null;
                    Object object4 = object3 = n2 == 1 ? plainTable.getValueAt(n, 2) : plainTable.getValueAt(n, 1);
                    if (object3 instanceof ISpssVariable && (object2 = (ISpssVariable)object3).getId().equals((Object)iSpssVariableArray[0].getId())) {
                        SpssAlertOptionPane.showWarningMessageDialog(jComponent, ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_DUPLICATE_CELL_WARNING"), VersionInfo.getAppVersionString());
                        SrcVariableList srcVariableList = (SrcVariableList)jComponent;
                        int n4 = srcVariableList.getModel().findElementIndex((ISpssVariable)object2);
                        if (n4 != -1) {
                            srcVariableList.setSelectedIndex(n4);
                            srcVariableList.requestFocus();
                            return;
                        }
                    }
                    plainTable.setValueAt(objectArray[1], n, n2);
                    plainTable.changeSelection(n, n2, false, false);
                }
                DefaultTableModel defaultTableModel = (DefaultTableModel)plainTable.getModel();
                object2 = this.getBlankRows(defaultTableModel);
                if (((ArrayList)object2).size() == 0) {
                    this.addBlankRow(defaultTableModel);
                }
            } else {
                ((DefaultTableModel)plainTable.getModel()).insertRow(n, objectArray);
            }
        }
        plainTable = (PlainTable)this.mDropTarget;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                plainTable.requestFocus();
            }
        });
    }

    @Override
    protected void importData(Object object, JComponent jComponent, int n) {
    }

    private void addBlankRow(DefaultTableModel defaultTableModel) {
        Object[] objectArray = new Object[]{"" + (defaultTableModel.getRowCount() + 1), "", ""};
        defaultTableModel.addRow(objectArray);
    }

    private void assignRowNos(DefaultTableModel defaultTableModel) {
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            defaultTableModel.setValueAt("" + (i + 1), i, 0);
        }
    }

    private ArrayList<Integer> getBlankRows(DefaultTableModel defaultTableModel) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            Object object = defaultTableModel.getValueAt(i, 1);
            Object object2 = defaultTableModel.getValueAt(i, 2);
            if (!(object instanceof String) || !(object2 instanceof String)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }
}

