/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ModelTermsList;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.TermsListDragAdapter;
import com.spss.java_client.ui.dialogs.common.IModelTermsListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ModelsListDropListener
implements IDropListener,
ActionListener {
    private static final int AUTOSCROLL_INSET = 10;
    protected JList mDropTarget = null;
    protected Timer mTimer = null;
    protected Point mLastPosition = null;
    private Rectangle mOuterRect = new Rectangle();
    private Rectangle mInnerRect = new Rectangle();
    private int mHysteresis = 10;
    protected static Cursor sSwapCursor = null;
    protected IModelTermsListVarMoveHandler mModelListVarMoveHandler;
    protected BaseDialog mParentDlg = null;
    protected Vector<Object> mTargetVarsVector = new Vector();

    public ModelsListDropListener(JList jList, IModelTermsListVarMoveHandler iModelTermsListVarMoveHandler) {
        this.mDropTarget = jList;
        this.mModelListVarMoveHandler = iModelTermsListVarMoveHandler;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.mDropTarget);
        Rectangle rectangle = (Rectangle)this.mInnerRect.clone();
        rectangle.grow(-this.mHysteresis, -this.mHysteresis);
        if (this.mLastPosition != null && this.pointWithin(this.mLastPosition, this.mOuterRect) && !this.pointWithin(this.mLastPosition, rectangle)) {
            this.autoscroll(this.mDropTarget, this.mLastPosition);
        }
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        Point point2 = null;
        Object[] objectArray = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.contains(point)) {
            if (this.canDrop(dragDropAdapter)) {
                bl2 = true;
                bl = true;
                point2 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
                if (this.mDropTarget instanceof VariableList) {
                    VariableList variableList = (VariableList)this.mDropTarget;
                    if (dragDropAdapter instanceof TermsListDragAdapter) {
                        ModelTermsList.TermsTransferData termsTransferData = (ModelTermsList.TermsTransferData)dragDropAdapter.getTransferData();
                        objectArray = termsTransferData != null ? termsTransferData.getVariables() : null;
                        JList jList = ((TermsListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed(jList, this.mDropTarget, objectArray)) {
                                cursor = Cursor.getPredefinedCursor(12);
                                variableList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                cursor = DragPane.getNoDropCursor();
                            }
                            variableList.showDropFeedback(null);
                        } else {
                            variableList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            variableList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    } else if (dragDropAdapter instanceof ListDragAdapter) {
                        VariableList.TransferData transferData = (VariableList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = transferData != null ? transferData.getVariables() : null;
                        JList jList = ((ListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed(jList, this.mDropTarget, objectArray)) {
                                variableList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                variableList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                variableList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else if (jList != variableList && variableList instanceof TargetVariableList && ((TargetVariableList)variableList).getTargetType() == TargetVariableList.TargetListType.single_item && variableList.getModel().getSize() == 1 && objectArray != null && objectArray.length == 1) {
                            Container container = variableList.getTopLevelAncestor();
                            if (container instanceof BaseDialog) {
                                if (sSwapCursor == null) {
                                    Image image = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SWAP_CURSOR_IMAGE"))).getImage();
                                    sSwapCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), ResUtil.getCommonDlgString("IDS_CURSOR_NAME"));
                                }
                                cursor = sSwapCursor;
                            }
                        } else {
                            variableList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            variableList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    }
                } else if (this.mDropTarget instanceof ModelTermsList) {
                    Object object;
                    Object object2;
                    ModelTermsList modelTermsList = (ModelTermsList)this.mDropTarget;
                    if (dragDropAdapter instanceof ListDragAdapter) {
                        object2 = (VariableList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = object2 != null ? ((VariableList.TransferData)object2).getVariables() : null;
                        object = ((ListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                modelTermsList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                modelTermsList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                modelTermsList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            modelTermsList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            modelTermsList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    } else if (dragDropAdapter instanceof TermsListDragAdapter) {
                        object2 = (ModelTermsList.TermsTransferData)dragDropAdapter.getTransferData();
                        objectArray = object2 != null ? ((ModelTermsList.TermsTransferData)object2).getVariables() : null;
                        object = ((TermsListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                modelTermsList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                modelTermsList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                modelTermsList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            modelTermsList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            modelTermsList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    } else if (dragDropAdapter instanceof PlainListDragAdapter) {
                        object2 = (PlainList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = object2 != null ? ((PlainList.TransferData)object2).getVariables() : null;
                        object = ((PlainListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                modelTermsList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                modelTermsList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                modelTermsList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            modelTermsList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            modelTermsList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    }
                    if (cursor != DragPane.getNoDropCursor()) {
                        if (cursor == Cursor.getPredefinedCursor(12) && modelTermsList.getListType() == ModelTermsList.ListType.single_item && this.mDropTarget.getModel().getSize() == 1 && objectArray != null && objectArray.length == 1) {
                            object2 = this.mDropTarget.getTopLevelAncestor();
                            if (object2 instanceof BaseDialog) {
                                if (sSwapCursor == null) {
                                    object = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SWAP_CURSOR_IMAGE"))).getImage();
                                    sSwapCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), ResUtil.getCommonDlgString("IDS_CURSOR_NAME"));
                                }
                                cursor = sSwapCursor;
                            }
                        } else {
                            cursor = Cursor.getPredefinedCursor(12);
                        }
                    }
                    modelTermsList.getFocusHighlighter().setHighlightBorder(bl2);
                } else if (this.mDropTarget instanceof PlainList) {
                    Object object;
                    Object object3;
                    PlainList plainList = (PlainList)this.mDropTarget;
                    if (dragDropAdapter instanceof ListDragAdapter) {
                        object3 = (VariableList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = object3 != null ? ((VariableList.TransferData)object3).getVariables() : null;
                        object = ((ListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                plainList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                plainList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                plainList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            plainList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            plainList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    } else if (dragDropAdapter instanceof TermsListDragAdapter) {
                        object3 = (ModelTermsList.TermsTransferData)dragDropAdapter.getTransferData();
                        objectArray = object3 != null ? ((ModelTermsList.TermsTransferData)object3).getVariables() : null;
                        object = ((TermsListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                plainList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                plainList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                plainList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            plainList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            plainList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    } else if (dragDropAdapter instanceof PlainListDragAdapter) {
                        object3 = (PlainList.TransferData)dragDropAdapter.getTransferData();
                        objectArray = object3 != null ? ((PlainList.TransferData)object3).getVariables() : null;
                        object = ((PlainListDragAdapter)dragDropAdapter).getSourceList();
                        if (this.mModelListVarMoveHandler != null) {
                            if (this.mModelListVarMoveHandler.isDragAllowed((JList)object, this.mDropTarget, objectArray)) {
                                plainList.showDropFeedback(point2);
                                cursor = Cursor.getPredefinedCursor(12);
                                plainList.getFocusHighlighter().setHighlightBorder(bl2);
                            } else {
                                plainList.showDropFeedback(null);
                                cursor = DragPane.getNoDropCursor();
                            }
                        } else {
                            plainList.showDropFeedback(point2);
                            cursor = Cursor.getPredefinedCursor(12);
                            plainList.getFocusHighlighter().setHighlightBorder(bl2);
                        }
                    }
                    if (cursor != DragPane.getNoDropCursor()) {
                        if (cursor == Cursor.getPredefinedCursor(12) && plainList.getListType() == PlainList.ListType.single_item && this.mDropTarget.getModel().getSize() == 1 && objectArray != null && objectArray.length == 1) {
                            object3 = this.mDropTarget.getTopLevelAncestor();
                            if (object3 instanceof BaseDialog) {
                                if (sSwapCursor == null) {
                                    object = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SWAP_CURSOR_IMAGE"))).getImage();
                                    sSwapCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), ResUtil.getCommonDlgString("IDS_CURSOR_NAME"));
                                }
                                cursor = sSwapCursor;
                            }
                        } else {
                            cursor = Cursor.getPredefinedCursor(12);
                        }
                    }
                    plainList.getFocusHighlighter().setHighlightBorder(bl2);
                }
            } else {
                if (this.mDropTarget instanceof VariableList) {
                    VariableList variableList = (VariableList)this.mDropTarget;
                    variableList.showDropFeedback(null);
                } else if (this.mDropTarget instanceof ModelTermsList) {
                    ModelTermsList modelTermsList = (ModelTermsList)this.mDropTarget;
                    modelTermsList.showDropFeedback(null);
                } else if (this.mDropTarget instanceof PlainList) {
                    PlainList plainList = (PlainList)this.mDropTarget;
                    plainList.showDropFeedback(null);
                }
                cursor = DragPane.getNoDropCursor();
            }
        }
        if (bl) {
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        return this.mDropTarget.getVisibleRect().contains(point2);
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        boolean bl = false;
        if (!this.mDropTarget.isEnabled() || !this.mDropTarget.isShowing()) {
            return bl;
        }
        if (!(dragDropAdapter instanceof ListDragAdapter || dragDropAdapter instanceof TermsListDragAdapter || dragDropAdapter instanceof PlainListDragAdapter)) {
            return bl;
        }
        bl = true;
        return bl;
    }

    public void itemDropped(DropEvent dropEvent) {
        if (!this.contains(dropEvent.getDropLocation()) || !this.canDrop(dropEvent.getDragSourceAdapter())) {
            return;
        }
        Component component = dropEvent.getSource();
        Container container = this.mDropTarget.getTopLevelAncestor();
        if (container instanceof BaseDialog) {
            this.mParentDlg = (BaseDialog)container;
            this.mTargetVarsVector = new Vector();
            this.recursiveGetTermsListVars(container);
        }
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        if (component instanceof VariableList) {
            if (this.mDropTarget instanceof VariableList) {
                return;
            }
            if (this.mDropTarget instanceof ModelTermsList) {
                ModelTermsList modelTermsList = (ModelTermsList)this.mDropTarget;
                VariableList variableList = (VariableList)component;
                Object object2 = dropEvent.getTransferData();
                if (object2 == null) {
                    return;
                }
                if (!(object2 instanceof VariableList.TransferData)) {
                    assert (false);
                    return;
                }
                VariableList.TransferData transferData = (VariableList.TransferData)object2;
                Object[] objectArray = transferData.getVariables();
                if (this.mModelListVarMoveHandler != null && !this.mModelListVarMoveHandler.isDragAllowed(variableList, this.mDropTarget, objectArray)) {
                    return;
                }
                if (modelTermsList.getDragType() != ModelTermsList.DragType.eAutoDragMove) {
                    for (Object object : objectArray) {
                        if (!this.mTargetVarsVector.contains(object)) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
                        final VariableList variableList2 = variableList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                variableList2.requestFocus();
                            }
                        });
                        return;
                    }
                }
                if (modelTermsList.getMaxLimitOfList() != -1 && objectArray.length + modelTermsList.getModel().getSize() > modelTermsList.getMaxLimitOfList()) {
                    String nArray = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), modelTermsList.getMaxLimitOfList());
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParentDlg, nArray, VersionInfo.getAppVersionString());
                    final VariableList variableList3 = variableList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            variableList3.requestFocus();
                        }
                    });
                    return;
                }
                if (this.mModelListVarMoveHandler != null) {
                    if (this.mModelListVarMoveHandler.preMoveVariables(objectArray, modelTermsList)) {
                        Object[] objectArray2 = this.mModelListVarMoveHandler.getModifiedData(objectArray, variableList, modelTermsList);
                        if (objectArray2 != null) {
                            objectArray = objectArray2;
                        }
                    } else {
                        final VariableList variableList4 = variableList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                variableList4.requestFocus();
                            }
                        });
                        return;
                    }
                }
                int[] nArray = transferData.getSelectedIndices();
                DefaultListModel defaultListModel = (DefaultListModel)modelTermsList.getModel();
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, modelTermsList);
                int n = modelTermsList.locationToIndex(point);
                int n2 = defaultListModel.getSize();
                if (n < 0) {
                    n = n2;
                } else {
                    if (!modelTermsList.itemInUpperHalf(point)) {
                        ++n;
                    }
                    if (n > n2) {
                        n = n2;
                    }
                }
                this.handleVariableListToTermsList(objectArray, variableList, modelTermsList, nArray, n);
            }
        } else if (component instanceof ModelTermsList) {
            ModelTermsList modelTermsList = (ModelTermsList)component;
            if (this.mDropTarget instanceof ModelTermsList) {
                ModelTermsList modelTermsList2 = (ModelTermsList)this.mDropTarget;
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof ModelTermsList.TermsTransferData)) {
                    assert (false);
                    return;
                }
                ModelTermsList.TermsTransferData termsTransferData = (ModelTermsList.TermsTransferData)object;
                Object[] objectArray = termsTransferData.getVariables();
                int[] nArray = termsTransferData.getSelectedIndices();
                DefaultListModel defaultListModel = (DefaultListModel)modelTermsList2.getModel();
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, modelTermsList2);
                int n = modelTermsList2.locationToIndex(point);
                int n3 = defaultListModel.getSize();
                if (n < 0) {
                    n = n3;
                } else {
                    if (!modelTermsList2.itemInUpperHalf(point)) {
                        ++n;
                    }
                    if (n > n3) {
                        n = n3;
                    }
                }
                if (modelTermsList2 == modelTermsList) {
                    this.handleWithinSameTermsList(objectArray, modelTermsList2, n);
                    final ModelTermsList modelTermsList3 = modelTermsList2;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            modelTermsList3.requestFocus();
                        }
                    });
                } else {
                    if (this.mModelListVarMoveHandler != null && !this.mModelListVarMoveHandler.isDragAllowed(modelTermsList, this.mDropTarget, objectArray)) {
                        return;
                    }
                    if (this.mModelListVarMoveHandler != null) {
                        if (this.mModelListVarMoveHandler.preMoveVariables(objectArray, modelTermsList2)) {
                            Object[] objectArray3 = this.mModelListVarMoveHandler.getModifiedData(objectArray, modelTermsList, modelTermsList2);
                            if (objectArray3 != null) {
                                objectArray = objectArray3;
                            }
                        } else {
                            final ModelTermsList modelTermsList4 = modelTermsList;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    modelTermsList4.requestFocus();
                                }
                            });
                            return;
                        }
                    }
                    this.handleTermsListToTermsList(objectArray, modelTermsList, modelTermsList2, n, nArray);
                }
            } else if (this.mDropTarget instanceof VariableList) {
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof ModelTermsList.TermsTransferData)) {
                    assert (false);
                    return;
                }
                ModelTermsList.TermsTransferData termsTransferData = (ModelTermsList.TermsTransferData)object;
                Object[] objectArray = termsTransferData.getVariables();
                if (this.mModelListVarMoveHandler != null && !this.mModelListVarMoveHandler.isDragAllowed(modelTermsList, this.mDropTarget, objectArray)) {
                    return;
                }
                this.handleTermsListToVariableList((ModelTermsList)component);
                this.mDropTarget.requestFocus();
            }
        }
    }

    void updateAutoscrollRegion(JComponent jComponent) {
        int n;
        Rectangle rectangle = jComponent.getVisibleRect();
        this.mInnerRect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            n = 20;
            if (rectangle.width >= n) {
                insets.right = 10;
                insets.left = 10;
            }
            if (rectangle.height >= n) {
                insets.bottom = 10;
                insets.top = 10;
            }
        }
        n = rectangle.x;
        int n2 = rectangle.y;
        this.mOuterRect.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, n + rectangle.width + insets.right, n2 + rectangle.height + insets.bottom);
    }

    void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            int n;
            Rectangle rectangle;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.mInnerRect.y + this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle2);
                this.mLastPosition.y -= n;
            } else if (point.y > this.mInnerRect.y + this.mInnerRect.height - this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle3);
                this.mLastPosition.y += n;
            }
            if (point.x < this.mInnerRect.x) {
                int n2 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, -1);
                Rectangle rectangle4 = new Rectangle(this.mInnerRect.x - n2, this.mInnerRect.y, n2, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle4);
                this.mLastPosition.x -= n2;
            } else if (point.x > this.mInnerRect.x + this.mInnerRect.width) {
                int n3 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, 1);
                Rectangle rectangle5 = new Rectangle(this.mInnerRect.x + this.mInnerRect.width, this.mInnerRect.y, n3, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle5);
                this.mLastPosition.x += n3;
            }
        }
    }

    protected void requestFocusOnList(JList jList) {
        if (jList instanceof VariableList) {
            final VariableList variableList = (VariableList)jList;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    variableList.requestFocusInWindow();
                    variableList.repaint();
                }
            });
        } else if (jList instanceof ModelTermsList) {
            final ModelTermsList modelTermsList = (ModelTermsList)jList;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    modelTermsList.requestFocusInWindow();
                    modelTermsList.repaint();
                }
            });
        }
    }

    protected void handleTermsListToVariableList(ModelTermsList modelTermsList) {
        Vector<SpssArrowButton> vector = modelTermsList.getRegisteredArrowButtons();
        for (SpssArrowButton spssArrowButton : vector) {
            spssArrowButton.doClick();
        }
    }

    protected void handleVariableListToTermsList(Object[] objectArray, VariableList variableList, ModelTermsList modelTermsList, int[] nArray, int n) {
        DefaultListModel defaultListModel = (DefaultListModel)modelTermsList.getModel();
        if (objectArray.length != 0) {
            for (Object object : objectArray) {
                defaultListModel.insertElementAt(object, n++);
            }
            modelTermsList.setSelection(objectArray);
            this.requestFocusOnList(modelTermsList);
        }
    }

    protected void handleTermsListToTermsList(Object[] objectArray, ModelTermsList modelTermsList, ModelTermsList modelTermsList2, int n, int[] nArray) {
        int n2;
        DefaultListModel defaultListModel = (DefaultListModel)modelTermsList2.getModel();
        for (Object object : objectArray) {
            if (defaultListModel.indexOf(object) != -1) continue;
            defaultListModel.insertElementAt(object, n++);
        }
        DefaultListModel defaultListModel2 = (DefaultListModel)modelTermsList.getModel();
        if (modelTermsList.isDataSource()) {
            if (modelTermsList.getDragType() != ModelTermsList.DragType.eAutoDragCopy) {
                for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                    defaultListModel2.removeElementAt(nArray[n2]);
                }
            }
        } else {
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                defaultListModel2.removeElementAt(nArray[n2]);
            }
        }
        if (modelTermsList.getDragType() == ModelTermsList.DragType.eAutoDragCopy) {
            modelTermsList.clearSelection();
        }
        modelTermsList2.setSelection(objectArray);
        this.requestFocusOnList(modelTermsList2);
    }

    protected void handleWithinSameTermsList(Object[] objectArray, ModelTermsList modelTermsList, int n) {
        Object var4_4 = null;
        DefaultListModel defaultListModel = (DefaultListModel)modelTermsList.getModel();
        if (n != 0) {
            var4_4 = defaultListModel.getElementAt(n - 1);
        }
        for (Object object : objectArray) {
            defaultListModel.removeElement(object);
        }
        if (var4_4 != null) {
            n = defaultListModel.indexOf(var4_4) + 1;
        }
        for (Object object : objectArray) {
            defaultListModel.insertElementAt(object, n++);
        }
        modelTermsList.setSelection(objectArray);
        this.requestFocusOnList(modelTermsList);
    }

    private void populateListVars(ModelTermsList modelTermsList) {
        for (int i = 0; i < modelTermsList.getModel().getSize(); ++i) {
            this.mTargetVarsVector.add(modelTermsList.getModel().getElementAt(i));
        }
    }

    protected void recursiveGetTermsListVars(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof ModelTermsList && !((ModelTermsList)component).isDataSource()) {
                this.populateListVars((ModelTermsList)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.recursiveGetTermsListVars((Container)component);
        }
    }

    private boolean pointWithin(Point point, Rectangle rectangle) {
        return point.x > rectangle.x && point.y > rectangle.y && point.x < rectangle.width && point.y < rectangle.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAutoScroll(Point point) {
        if (!this.mDropTarget.getAutoscrolls()) {
            return;
        }
        if (this.mLastPosition == null) {
            if (this.mDropTarget.contains(point)) {
                this.mLastPosition = point.getLocation();
                this.updateAutoscrollRegion(this.mDropTarget);
                this.initPropertiesIfNecessary();
            }
        } else {
            ModelsListDropListener modelsListDropListener = this;
            synchronized (modelsListDropListener) {
                if (Math.abs(point.x - this.mLastPosition.x) > this.mHysteresis || Math.abs(point.y - this.mLastPosition.y) > this.mHysteresis) {
                    if (this.mTimer.isRunning()) {
                        this.mTimer.stop();
                    }
                    this.mLastPosition = null;
                } else {
                    if (!this.mTimer.isRunning()) {
                        this.mTimer.start();
                    }
                    this.mLastPosition = point;
                }
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.mTimer == null) {
            Integer n = 100;
            Integer n2 = 100;
            this.mTimer = new Timer(n2, this);
            this.mTimer.setCoalesce(true);
            this.mTimer.setInitialDelay(n);
        }
    }
}

