/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.EventUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.MouseInputListener;

public class ListMouseHandler
implements MouseInputListener {
    private JList mList;
    private boolean mDragPressDidSelection;

    public ListMouseHandler(JList jList) {
        this.mList = jList;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (EventUtil.shouldIgnore((MouseEvent)mouseEvent, (JComponent)this.mList)) {
            this.mDragPressDidSelection = false;
            return;
        }
        this.mDragPressDidSelection = true;
        this.mList.setValueIsAdjusting(true);
        EventUtil.adjustFocus((JComponent)this.mList);
        this.adjustSelection(mouseEvent);
    }

    public void dragStarting(MouseEvent mouseEvent) {
        if (this.isDiscontinuousSelectionKeyPressed(mouseEvent)) {
            int n = EventUtil.loc2IndexFileList((JList)this.mList, (Point)mouseEvent.getPoint());
            this.mList.addSelectionInterval(n, n);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (EventUtil.shouldIgnore((MouseEvent)mouseEvent, (JComponent)this.mList)) {
            return;
        }
        if (mouseEvent.isShiftDown() || this.isDiscontinuousSelectionKeyPressed(mouseEvent)) {
            return;
        }
        int n = this.mList.locationToIndex(mouseEvent.getPoint());
        if (n != -1 && (rectangle = this.mList.getCellBounds(n, n)) != null) {
            this.mList.scrollRectToVisible(rectangle);
            this.mList.setSelectionInterval(n, n);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        EventUtil.adjustFocus((JComponent)this.mList);
        if (!this.mDragPressDidSelection && !mouseEvent.isPopupTrigger()) {
            this.adjustSelection(mouseEvent);
        }
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.mList.setValueIsAdjusting(true);
            EventUtil.adjustFocus((JComponent)this.mList);
            this.adjustSelection(mouseEvent);
        }
        this.mList.setValueIsAdjusting(false);
    }

    private static int adjustIndex(int n, JList jList) {
        return n < jList.getModel().getSize() ? n : -1;
    }

    private void adjustSelection(MouseEvent mouseEvent) {
        int n = EventUtil.loc2IndexFileList((JList)this.mList, (Point)mouseEvent.getPoint());
        if (n >= 0) {
            boolean bl;
            int n2 = ListMouseHandler.adjustIndex(this.mList.getAnchorSelectionIndex(), this.mList);
            if (n2 == -1) {
                n2 = 0;
                bl = false;
            } else {
                bl = this.mList.isSelectedIndex(n2);
            }
            if (this.isDiscontinuousSelectionKeyPressed(mouseEvent)) {
                if (mouseEvent.isShiftDown()) {
                    if (bl) {
                        this.mList.addSelectionInterval(n2, n);
                    } else {
                        this.mList.removeSelectionInterval(n2, n);
                    }
                } else if (this.mList.isSelectedIndex(n)) {
                    this.mList.removeSelectionInterval(n, n);
                } else {
                    this.mList.addSelectionInterval(n, n);
                }
            } else if (mouseEvent.isShiftDown()) {
                this.mList.setSelectionInterval(n2, n);
            } else {
                this.mList.setSelectionInterval(n, n);
            }
        }
    }

    private boolean isDiscontinuousSelectionKeyPressed(MouseEvent mouseEvent) {
        boolean bl = false;
        bl = OSInfo.getOSType() == OSInfo.OSType.MAC ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
        return bl;
    }
}

