/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionObject;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.AbstractDropListener;
import com.spss.java_client.ui.controls.drag_drop.ExpressionTextAreaDragAdapter;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionParam;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DropEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ExpressionTextAreaDropListener
extends AbstractDropListener {
    public ExpressionTextAreaDropListener(ExpressionBuilderTextArea expressionBuilderTextArea) {
        super((JComponent)((Object)expressionBuilderTextArea));
    }

    public ExpressionTextAreaDropListener(ContextEnabledTextField contextEnabledTextField) {
        super((JComponent)contextEnabledTextField);
    }

    @Override
    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = super.dragItemOver(point, dragDropAdapter);
        boolean bl = this.canDrop(dragDropAdapter) && this.contains(point);
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        if (bl) {
            if (this.mDropTarget instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)this.mDropTarget;
                jTextArea.setCaretPosition(jTextArea.viewToModel(point2));
                jTextArea.getCaret().setVisible(true);
            } else if (this.mDropTarget instanceof JTextField) {
                JTextField jTextField = (JTextField)this.mDropTarget;
                jTextField.setCaretPosition(jTextField.viewToModel(point2));
                jTextField.getCaret().setVisible(true);
            }
        } else if (this.mDropTarget instanceof JTextArea) {
            ((JTextArea)this.mDropTarget).getCaret().setVisible(false);
        } else if (this.mDropTarget instanceof JTextField) {
            ((JTextField)this.mDropTarget).getCaret().setVisible(false);
        }
        if (this.mDropTarget instanceof ExpressionBuilderTextArea) {
            ((ExpressionBuilderTextArea)((Object)this.mDropTarget)).getFocusHighlighter().setHighlightBorder(bl);
        }
        if (bl) {
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    @Override
    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        ExpressionTextAreaDragAdapter.TransferData transferData;
        String string;
        boolean bl = false;
        if (!this.mDropTarget.isEnabled() || !this.mDropTarget.isShowing()) {
            return bl;
        }
        Object object = dragDropAdapter.getTransferData();
        if (object instanceof VariableList.TransferData) {
            VariableList.TransferData transferData2 = (VariableList.TransferData)object;
            ISpssVariable[] iSpssVariableArray = transferData2.getVariables();
            if (iSpssVariableArray != null && iSpssVariableArray.length > 0 && this.mDropTarget instanceof JTextArea) {
                return iSpssVariableArray.length <= 1;
            }
        } else if (object instanceof PlainList.TransferData) {
            PlainList.TransferData transferData3 = (PlainList.TransferData)object;
            Object[] objectArray = transferData3.getVariables();
            if (objectArray != null && objectArray.length > 0 && this.mDropTarget instanceof JTextArea) {
                if (objectArray.length > 1) {
                    return false;
                }
                if (objectArray[0] instanceof FunctionObject) {
                    return true;
                }
                if (objectArray[0] instanceof RegressionParam) {
                    return true;
                }
            }
        } else if (object instanceof ExpressionTextAreaDragAdapter.TransferData && (string = (transferData = (ExpressionTextAreaDragAdapter.TransferData)object).getData()) != null && string.length() > 0) {
            return true;
        }
        return bl;
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        boolean bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        Point point = (Point)dropEvent.getDropLocation().clone();
        SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
        if (bl && this.mDropTarget != null && component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            Object object = dropEvent.getTransferData();
            if (object == null || !(object instanceof VariableList.TransferData)) {
                return;
            }
            VariableList.TransferData transferData = (VariableList.TransferData)object;
            ISpssVariable[] iSpssVariableArray = transferData.getVariables();
            if (this.mDropTarget instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)this.mDropTarget;
                int n = jTextArea.viewToModel(point);
                this.importData(iSpssVariableArray, variableList, n);
            } else if (this.mDropTarget instanceof JTextField) {
                JTextField jTextField = (JTextField)this.mDropTarget;
                int n = jTextField.viewToModel(point);
                this.importData(iSpssVariableArray, variableList, n);
            }
        } else if (bl && this.mDropTarget != null && component instanceof PlainList) {
            PlainList plainList = (PlainList)component;
            Object object = dropEvent.getTransferData();
            if (object == null || !(object instanceof PlainList.TransferData)) {
                return;
            }
            PlainList.TransferData transferData = (PlainList.TransferData)object;
            Object[] objectArray = transferData.getVariables();
            if (this.mDropTarget instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)this.mDropTarget;
                int n = jTextArea.viewToModel(point);
                this.importData(objectArray, plainList, n);
            } else if (this.mDropTarget instanceof JTextField) {
                JTextField jTextField = (JTextField)this.mDropTarget;
                int n = jTextField.viewToModel(point);
                this.importData(objectArray, plainList, n);
            }
        } else if (bl && this.mDropTarget != null && component instanceof JTextArea) {
            Object object = dropEvent.getTransferData();
            if (object == null || !(object instanceof ExpressionTextAreaDragAdapter.TransferData)) {
                return;
            }
            ExpressionTextAreaDragAdapter.TransferData transferData = (ExpressionTextAreaDragAdapter.TransferData)object;
            int n = ((JTextArea)this.mDropTarget).viewToModel(point);
            this.importData(transferData, (JComponent)component, n);
        } else if (!bl && this.mDropTarget == component) {
            Object object = dropEvent.getTransferData();
            if (object == null || !(object instanceof ExpressionTextAreaDragAdapter.TransferData)) {
                return;
            }
            ExpressionTextAreaDragAdapter.TransferData transferData = (ExpressionTextAreaDragAdapter.TransferData)object;
            ((JTextArea)component).replaceRange("", transferData.getSelectionStart(), transferData.getSelectionStart() + transferData.getData().length());
            ((JTextArea)component).requestFocus();
        }
    }

    @Override
    protected void importData(Object object, JComponent jComponent, int n) {
        final JTextArea jTextArea = (JTextArea)this.mDropTarget;
        if (object instanceof ISpssVariable[] && ((ISpssVariable[])object).length == 1 && jComponent instanceof VariableList) {
            ISpssVariable iSpssVariable = ((ISpssVariable[])object)[0];
            jTextArea.insert(iSpssVariable.getName(), n);
        } else if (object instanceof Object[] && ((Object[])object).length == 1 && jComponent instanceof PlainList) {
            Object[] objectArray = (Object[])object;
            if (objectArray[0] instanceof FunctionObject) {
                FunctionObject functionObject = (FunctionObject)objectArray[0];
                jTextArea.insert(functionObject.getInsertString(), n);
            } else if (objectArray[0] instanceof RegressionParam) {
                RegressionParam regressionParam = (RegressionParam)objectArray[0];
                jTextArea.insert(regressionParam.getParamName(), n);
            }
        } else if (object instanceof ExpressionTextAreaDragAdapter.TransferData) {
            ExpressionTextAreaDragAdapter.TransferData transferData = (ExpressionTextAreaDragAdapter.TransferData)object;
            if (jComponent == this.mDropTarget) {
                int n2 = transferData.getSelectionStart();
                int n3 = n2 + transferData.getData().length();
                if (n < n2) {
                    jTextArea.replaceRange("", n2, n3);
                    jTextArea.insert(transferData.getData(), n);
                } else if (n >= n3) {
                    jTextArea.replaceRange("", n2, n3);
                    jTextArea.insert(transferData.getData(), n -= transferData.getData().length());
                }
            } else {
                jTextArea.insert(transferData.getData(), n);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextArea.requestFocus();
            }
        });
    }

    @Override
    protected void showDropFeedback(Point point) {
    }

    @Override
    protected void setHighlightBorder(boolean bl) {
    }

    @Override
    protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
    }
}

