/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class ExpressionTextAreaDragAdapter
extends ComponentDragAdapter {
    private JTextComponent mTextComponent;

    public ExpressionTextAreaDragAdapter(ExpressionBuilderTextArea expressionBuilderTextArea, DragPane dragPane, String string) {
        super(dragPane, string);
        this.mTextComponent = expressionBuilderTextArea;
    }

    public ExpressionTextAreaDragAdapter(ContextEnabledTextField contextEnabledTextField, DragPane dragPane, String string) {
        super(dragPane, string);
        this.mTextComponent = contextEnabledTextField;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isDragPossible(mouseEvent)) {
            super.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, component);
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point, (Component)this.mDragPane);
        this.mDragPane.setVisible(false);
        this.mDragPane.setDragImage(null, false);
        this.mDragPane.setDragPoint(point);
        this.mDragPane.fireDropEvent(new DropEvent(component, point2, (DragDropAdapter)this));
        this.mTransferData = null;
    }

    protected void acquireTransferData() {
        String string = this.mTextComponent.getSelectedText();
        if (string != null && string.length() > 0) {
            this.mTransferData = new TransferData(string, this.mTextComponent.getSelectionStart(), this.mTextComponent);
        }
    }

    protected BufferedImage getDragImage(Component component) {
        String string = this.mTextComponent.getSelectedText();
        if (string == null || string.length() == 0) {
            return null;
        }
        JLabel jLabel = new JLabel();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        if (string.length() > 20) {
            jLabel.setText(string.substring(0, 20) + "...");
        } else {
            jLabel.setText(string);
        }
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(jLabel.getText(), jLabel.getGraphics());
        jLabel.setSize((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return super.getDragImage((Component)jLabel);
    }

    private boolean isDragPossible(MouseEvent mouseEvent) {
        int n;
        Caret caret;
        int n2;
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
        if (jTextComponent.isEnabled() && (n2 = (caret = jTextComponent.getCaret()).getDot()) != (n = caret.getMark())) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n3 = jTextComponent.viewToModel(point);
            int n4 = Math.min(n2, n);
            int n5 = Math.max(n2, n);
            if (n3 >= n4 && n3 < n5) {
                return true;
            }
        }
        return false;
    }

    public class TransferData
    implements Cloneable {
        private String mData;
        private int mSelectionStart;
        private JComponent mSource;

        public TransferData(String string, int n, JTextComponent jTextComponent) {
            this.mData = string;
            this.mSelectionStart = n;
            this.mSource = jTextComponent;
        }

        public String getData() {
            return this.mData;
        }

        public int getSelectionStart() {
            return this.mSelectionStart;
        }

        public JComponent getSource() {
            return this.mSource;
        }

        public Object clone() throws CloneNotSupportedException {
            TransferData transferData = (TransferData)super.clone();
            transferData.mData = this.mData;
            transferData.mSelectionStart = this.mSelectionStart;
            return transferData;
        }
    }
}

