/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.VarDropCallback;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;

public class CallbackVarDropListener
extends VarListDropListener {
    private VarDropCallback mCallback;

    public CallbackVarDropListener(VariableList variableList, VarDropCallback varDropCallback) {
        super(variableList);
        this.mCallback = varDropCallback;
    }

    public static void addDragAdapters(DragPane dragPane, Component component, VarDropCallback varDropCallback) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
            dragPane.addDropListener((IDropListener)new CallbackVarDropListener(variableList, varDropCallback));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                CallbackVarDropListener.addDragAdapters(dragPane, component2, varDropCallback);
            }
        }
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        boolean bl;
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(false);
        Component component = dropEvent.getSource();
        VariableList variableList = (VariableList)component;
        Object object = dropEvent.getTransferData();
        if (object == null) {
            return;
        }
        if (!(object instanceof VariableList.TransferData)) {
            assert (false);
            return;
        }
        VariableList.TransferData transferData = (VariableList.TransferData)object;
        ISpssVariable[] iSpssVariableArray = transferData.getVariables();
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.mCallback.canDrop(variableList, this.mDropTarget, iSpssVariableArray);
        if (bl) {
            this.mCallback.processDrop(variableList, this.mDropTarget, iSpssVariableArray);
        }
    }
}

