/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.PlainTree;
import com.spss.java_client.ui.controls.drag_drop.AbstractDropListener;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.ctables.SummaryStatTree;
import com.spss.uitools.canvas.tables.StatPack;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DropEvent;
import java.awt.Component;
import java.awt.Point;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public abstract class AbstractTableDropListener
extends AbstractDropListener {
    private Component mRegisteredSource;

    public AbstractTableDropListener(PlainTable plainTable, Component component) {
        super(plainTable);
        this.mRegisteredSource = component;
    }

    public AbstractTableDropListener(PlainTable plainTable, IVarMoveHandler iVarMoveHandler, Component component) {
        super(plainTable, iVarMoveHandler);
        this.mRegisteredSource = component;
    }

    public Component getRegisteredSource() {
        return this.mRegisteredSource;
    }

    @Override
    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        PlainTree.TransferData transferData;
        Vector<Object> vector;
        boolean bl = false;
        if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && ((PlainTable)this.mDropTarget).isDragSupported())) {
            return bl;
        }
        Object object = dragDropAdapter.getTransferData();
        if (object instanceof PlainList.TransferData) {
            PlainList.TransferData transferData2 = (PlainList.TransferData)object;
            if (transferData2.getSource() != null && this.getRegisteredSource() != transferData2.getSource()) {
                return bl;
            }
            Object[] objectArray = transferData2.getVariables();
            if (objectArray != null && objectArray.length > 0) {
                bl = true;
            }
        } else if (object instanceof PlainTable.TransferData) {
            PlainTable.TransferData transferData3 = (PlainTable.TransferData)object;
            Vector<Object[]> vector2 = transferData3.getVectorData();
            if (vector2 != null && vector2.size() > 0) {
                bl = true;
            }
        } else if (object instanceof PlainTree.TransferData && (vector = (transferData = (PlainTree.TransferData)object).getVectorData()) != null && vector.size() > 0 && vector.get(0) instanceof StatPack) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        if (this.mDropTarget.getParent() != null && this.mDropTarget.getParent().getParent() instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)this.mDropTarget.getParent().getParent();
            SwingUtilities.convertPointFromScreen(point2, jScrollPane);
            return jScrollPane.getVisibleRect().contains(point2);
        }
        return super.contains(point);
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        boolean bl;
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.setHighlightBorder(false);
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        if (bl && this.mDropTarget != null) {
            if (component == this.mDropTarget) {
                PlainTable plainTable = (PlainTable)component;
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof PlainTable.TransferData)) {
                    assert (false);
                    return;
                }
                PlainTable.TransferData transferData = (PlainTable.TransferData)object;
                Vector<Object[]> vector = transferData.getVectorData();
                int[] nArray = transferData.getSelectedRows();
                TableModel tableModel = ((PlainTable)this.mDropTarget).getModel();
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
                int n = ((PlainTable)this.mDropTarget).rowAtPoint(point);
                if (this.dropOnSource(plainTable, n, nArray, point)) {
                    return;
                }
                int n2 = tableModel.getRowCount();
                if (n < 0) {
                    n = n2;
                } else {
                    if (!((PlainTable)this.mDropTarget).itemInUpperHalf(point)) {
                        ++n;
                    }
                    if (n > n2) {
                        n = n2;
                    }
                }
                this.importData(vector, (JComponent)component, n);
                if (!this.mSwapFlag) {
                    this.finish(plainTable, vector.size(), nArray, n);
                }
                this.mSwapFlag = false;
            } else if (component instanceof PlainList) {
                PlainList plainList = (PlainList)component;
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof PlainList.TransferData)) {
                    assert (false);
                    return;
                }
                PlainList.TransferData transferData = (PlainList.TransferData)object;
                Object[] objectArray = transferData.getVariables();
                int[] nArray = transferData.getSelectedIndices();
                TableModel tableModel = ((PlainTable)this.mDropTarget).getModel();
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
                int n = ((PlainTable)this.mDropTarget).rowAtPoint(point);
                if (this.dropOnSource(plainList, n, nArray, point)) {
                    return;
                }
                int n3 = tableModel.getRowCount();
                if (n < 0) {
                    n = n3;
                } else {
                    if (!((PlainTable)this.mDropTarget).itemInUpperHalf(point)) {
                        ++n;
                    }
                    if (n > n3) {
                        n = n3;
                    }
                }
                this.importData(objectArray, (JComponent)component, n);
                if (!this.mSwapFlag) {
                    this.finish((JComponent)component, objectArray.length, nArray, n);
                }
                this.mSwapFlag = false;
            } else if (component instanceof SummaryStatTree) {
                SummaryStatTree summaryStatTree = (SummaryStatTree)component;
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof PlainTree.TransferData)) {
                    assert (false);
                    return;
                }
                PlainTree.TransferData transferData = (PlainTree.TransferData)object;
                Vector<Object> vector = transferData.getVectorData();
                Vector<DefaultMutableTreeNode> vector2 = transferData.getVectorNodes();
                TableModel tableModel = ((PlainTable)this.mDropTarget).getModel();
                Point point = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
                int n = ((PlainTable)this.mDropTarget).rowAtPoint(point);
                if (summaryStatTree == this.mDropTarget) {
                    return;
                }
                int n4 = tableModel.getRowCount();
                if (n < 0) {
                    n = n4;
                } else {
                    if (!((PlainTable)this.mDropTarget).itemInUpperHalf(point)) {
                        ++n;
                    }
                    if (n > n4) {
                        n = n4;
                    }
                }
                this.importData(vector, (JComponent)component, n);
                if (!this.mSwapFlag) {
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)summaryStatTree.getModel();
                    for (DefaultMutableTreeNode defaultMutableTreeNode : vector2) {
                        summaryStatTree.removeNode(defaultMutableTreeNode, true);
                    }
                }
            }
            this.mSwapFlag = false;
        }
    }

    @Override
    protected void showDropFeedback(Point point) {
        ((PlainTable)this.mDropTarget).showDropFeedback(point);
    }

    @Override
    protected void setHighlightBorder(boolean bl) {
        ((PlainTable)this.mDropTarget).getFocusHighlighter().setHighlightBorder(bl);
    }

    @Override
    protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
        try {
            if (jComponent instanceof PlainTable) {
                int n3;
                PlainTable plainTable = (PlainTable)jComponent;
                DefaultTableModel defaultTableModel = plainTable.getDefaultTableModel();
                if (n > 0 && this.mDropTarget == jComponent) {
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        if (nArray[n3] <= n2) continue;
                        int n4 = n3;
                        nArray[n4] = nArray[n4] + n;
                    }
                }
                if (this.mDropTarget == jComponent) {
                    for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                        defaultTableModel.removeRow(nArray[n3]);
                    }
                }
            } else if (jComponent instanceof PlainList) {
                int n5;
                PlainList plainList = (PlainList)jComponent;
                DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
                if (n > 0 && this.mDropTarget == jComponent) {
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        if (nArray[n5] <= n2) continue;
                        int n6 = n5;
                        nArray[n6] = nArray[n6] + n;
                    }
                }
                for (n5 = nArray.length - 1; n5 >= 0; --n5) {
                    defaultListModel.removeElementAt(nArray[n5]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean dropOnSource(JComponent jComponent, int n, int[] nArray, Point point) {
        boolean bl;
        boolean bl2 = bl = jComponent == this.mDropTarget && nArray != null;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = n >= nArray[0] && n <= nArray[nArray.length - 1];
            if (!bl3) {
                boolean bl5 = ((PlainTable)this.mDropTarget).itemInUpperHalf(point);
                if (n == nArray[0] - 1) {
                    bl3 = !bl5;
                } else if (n == nArray[nArray.length - 1] + 1) {
                    bl3 = bl5;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }
}

