/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.drag_drop.AbstractDropListener;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DropEvent;
import java.awt.Component;
import java.awt.Point;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public abstract class AbstractListDropListener
extends AbstractDropListener {
    private Component mRegisteredSource;

    public AbstractListDropListener(PlainList plainList, Component component) {
        super(plainList);
        this.mRegisteredSource = component;
    }

    public AbstractListDropListener(PlainList plainList, IVarMoveHandler iVarMoveHandler, Component component) {
        super(plainList, iVarMoveHandler);
        this.mRegisteredSource = component;
    }

    public Component getRegisteredSource() {
        return this.mRegisteredSource;
    }

    @Override
    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        boolean bl = false;
        if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && ((PlainList)this.mDropTarget).isDragSupported())) {
            return bl;
        }
        Object object = dragDropAdapter.getTransferData();
        if (object instanceof PlainTable.TransferData) {
            PlainTable.TransferData transferData = (PlainTable.TransferData)object;
            if (transferData.getSource() != null && this.getRegisteredSource() != transferData.getSource()) {
                return bl;
            }
            Vector<Object[]> vector = transferData.getVectorData();
            if (vector != null && vector.size() > 0) {
                bl = true;
            }
        } else if (object instanceof PlainList.TransferData) {
            PlainList.TransferData transferData = (PlainList.TransferData)object;
            if (transferData.getSource() != null && this.getRegisteredSource() != transferData.getSource()) {
                return bl;
            }
            Object[] objectArray = transferData.getVariables();
            if (objectArray != null && objectArray.length > 0) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        boolean bl;
        if (!this.isRecursivelyVisible(this.mDropTarget)) {
            return;
        }
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.setHighlightBorder(false);
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        if (bl && this.mDropTarget != null && component instanceof PlainTable) {
            PlainTable plainTable = (PlainTable)component;
            Object object = dropEvent.getTransferData();
            if (object == null) {
                return;
            }
            if (!(object instanceof PlainTable.TransferData)) {
                assert (false);
                return;
            }
            PlainTable.TransferData transferData = (PlainTable.TransferData)object;
            Vector<Object[]> vector = transferData.getVectorData();
            int[] nArray = transferData.getSelectedRows();
            ListModel listModel = ((PlainList)this.mDropTarget).getModel();
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            int n = -1;
            int n2 = listModel.getSize();
            if (n < 0) {
                n = n2;
            }
            this.importData(vector, plainTable, n);
            if (!this.mSwapFlag) {
                this.finish(plainTable, vector.size(), nArray, n);
            }
            this.mSwapFlag = false;
        } else if (bl && this.mDropTarget != null && this.mDropTarget instanceof PlainList && component instanceof PlainList) {
            PlainList plainList = (PlainList)component;
            Object object = dropEvent.getTransferData();
            if (object == null) {
                return;
            }
            if (!(object instanceof PlainList.TransferData)) {
                assert (false);
                return;
            }
            PlainList.TransferData transferData = (PlainList.TransferData)object;
            int[] nArray = transferData.getSelectedIndices();
            ListModel listModel = ((PlainList)this.mDropTarget).getModel();
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            int n = ((PlainList)this.mDropTarget).locationToIndex(point);
            if (this.dropOnSource(plainList, n, nArray, point)) {
                return;
            }
            int n3 = listModel.getSize();
            if (n < 0) {
                n = n3;
            } else {
                if (!((PlainList)this.mDropTarget).itemInUpperHalf(point)) {
                    ++n;
                }
                if (n > n3) {
                    n = n3;
                }
            }
            this.importData(transferData, (JComponent)component, n);
            if (!this.mSwapFlag) {
                this.finish((JComponent)component, transferData.getVariables().length, nArray, n);
            }
            this.mSwapFlag = false;
        }
    }

    boolean isRecursivelyVisible(Component component) {
        boolean bl = component.isVisible();
        if (bl && component.getParent() != null) {
            bl = this.isRecursivelyVisible(component.getParent());
        }
        return bl;
    }

    @Override
    protected void showDropFeedback(Point point) {
        ((PlainList)this.mDropTarget).showDropFeedback(point);
    }

    @Override
    protected void setHighlightBorder(boolean bl) {
        ((PlainList)this.mDropTarget).getFocusHighlighter().setHighlightBorder(false);
    }

    @Override
    protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
        try {
            if (jComponent instanceof PlainTable) {
                DefaultTableModel defaultTableModel = ((PlainTable)jComponent).getDefaultTableModel();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    defaultTableModel.removeRow(nArray[i]);
                }
            } else if (jComponent instanceof PlainList) {
                boolean bl = jComponent == this.mDropTarget && n2 < nArray[0];
                DefaultListModel defaultListModel = (DefaultListModel)((PlainList)jComponent).getModel();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n3 = bl ? nArray[i] + n : nArray[i];
                    defaultListModel.removeElementAt(n3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean dropOnSource(JComponent jComponent, int n, int[] nArray, Point point) {
        boolean bl;
        boolean bl2 = bl = jComponent == this.mDropTarget && nArray != null;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = n >= nArray[0] && n <= nArray[nArray.length - 1];
            if (!bl3) {
                boolean bl5 = ((PlainList)this.mDropTarget).itemInUpperHalf(point);
                if (n == nArray[0] - 1) {
                    bl3 = !bl5;
                } else if (n == nArray[nArray.length - 1] + 1) {
                    bl3 = bl5;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }
}

